package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DsgUserGroupGetOdpsRoleGroups invokes the dataworks_public.DsgUserGroupGetOdpsRoleGroups API synchronously
func (client *Client) DsgUserGroupGetOdpsRoleGroups(request *DsgUserGroupGetOdpsRoleGroupsRequest) (response *DsgUserGroupGetOdpsRoleGroupsResponse, err error) {
	response = CreateDsgUserGroupGetOdpsRoleGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// DsgUserGroupGetOdpsRoleGroupsWithChan invokes the dataworks_public.DsgUserGroupGetOdpsRoleGroups API asynchronously
func (client *Client) DsgUserGroupGetOdpsRoleGroupsWithChan(request *DsgUserGroupGetOdpsRoleGroupsRequest) (<-chan *DsgUserGroupGetOdpsRoleGroupsResponse, <-chan error) {
	responseChan := make(chan *DsgUserGroupGetOdpsRoleGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DsgUserGroupGetOdpsRoleGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DsgUserGroupGetOdpsRoleGroupsWithCallback invokes the dataworks_public.DsgUserGroupGetOdpsRoleGroups API asynchronously
func (client *Client) DsgUserGroupGetOdpsRoleGroupsWithCallback(request *DsgUserGroupGetOdpsRoleGroupsRequest, callback func(response *DsgUserGroupGetOdpsRoleGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DsgUserGroupGetOdpsRoleGroupsResponse
		var err error
		defer close(result)
		response, err = client.DsgUserGroupGetOdpsRoleGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DsgUserGroupGetOdpsRoleGroupsRequest is the request struct for api DsgUserGroupGetOdpsRoleGroups
type DsgUserGroupGetOdpsRoleGroupsRequest struct {
	*requests.RpcRequest
	ProjectName string `position:"Query" name:"ProjectName"`
}

// DsgUserGroupGetOdpsRoleGroupsResponse is the response struct for api DsgUserGroupGetOdpsRoleGroups
type DsgUserGroupGetOdpsRoleGroupsResponse struct {
	*responses.BaseResponse
	Success        bool     `json:"Success" xml:"Success"`
	ErrorCode      string   `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string   `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Data           []string `json:"Data" xml:"Data"`
}

// CreateDsgUserGroupGetOdpsRoleGroupsRequest creates a request to invoke DsgUserGroupGetOdpsRoleGroups API
func CreateDsgUserGroupGetOdpsRoleGroupsRequest() (request *DsgUserGroupGetOdpsRoleGroupsRequest) {
	request = &DsgUserGroupGetOdpsRoleGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DsgUserGroupGetOdpsRoleGroups", "", "")
	request.Method = requests.GET
	return
}

// CreateDsgUserGroupGetOdpsRoleGroupsResponse creates a response to parse from DsgUserGroupGetOdpsRoleGroups response
func CreateDsgUserGroupGetOdpsRoleGroupsResponse() (response *DsgUserGroupGetOdpsRoleGroupsResponse) {
	response = &DsgUserGroupGetOdpsRoleGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
