package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTagsForPrivateAccessPolicy invokes the csas.ListTagsForPrivateAccessPolicy API synchronously
func (client *Client) ListTagsForPrivateAccessPolicy(request *ListTagsForPrivateAccessPolicyRequest) (response *ListTagsForPrivateAccessPolicyResponse, err error) {
	response = CreateListTagsForPrivateAccessPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// ListTagsForPrivateAccessPolicyWithChan invokes the csas.ListTagsForPrivateAccessPolicy API asynchronously
func (client *Client) ListTagsForPrivateAccessPolicyWithChan(request *ListTagsForPrivateAccessPolicyRequest) (<-chan *ListTagsForPrivateAccessPolicyResponse, <-chan error) {
	responseChan := make(chan *ListTagsForPrivateAccessPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTagsForPrivateAccessPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTagsForPrivateAccessPolicyWithCallback invokes the csas.ListTagsForPrivateAccessPolicy API asynchronously
func (client *Client) ListTagsForPrivateAccessPolicyWithCallback(request *ListTagsForPrivateAccessPolicyRequest, callback func(response *ListTagsForPrivateAccessPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTagsForPrivateAccessPolicyResponse
		var err error
		defer close(result)
		response, err = client.ListTagsForPrivateAccessPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTagsForPrivateAccessPolicyRequest is the request struct for api ListTagsForPrivateAccessPolicy
type ListTagsForPrivateAccessPolicyRequest struct {
	*requests.RpcRequest
	PolicyIds *[]string `position:"Query" name:"PolicyIds"  type:"Repeated"`
	SourceIp  string    `position:"Query" name:"SourceIp"`
}

// ListTagsForPrivateAccessPolicyResponse is the response struct for api ListTagsForPrivateAccessPolicy
type ListTagsForPrivateAccessPolicyResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Polices   []Policy `json:"Polices" xml:"Polices"`
}

// CreateListTagsForPrivateAccessPolicyRequest creates a request to invoke ListTagsForPrivateAccessPolicy API
func CreateListTagsForPrivateAccessPolicyRequest() (request *ListTagsForPrivateAccessPolicyRequest) {
	request = &ListTagsForPrivateAccessPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListTagsForPrivateAccessPolicy", "", "")
	request.Method = requests.GET
	return
}

// CreateListTagsForPrivateAccessPolicyResponse creates a response to parse from ListTagsForPrivateAccessPolicy response
func CreateListTagsForPrivateAccessPolicyResponse() (response *ListTagsForPrivateAccessPolicyResponse) {
	response = &ListTagsForPrivateAccessPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
