package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApprovalSchemas invokes the csas.ListApprovalSchemas API synchronously
func (client *Client) ListApprovalSchemas(request *ListApprovalSchemasRequest) (response *ListApprovalSchemasResponse, err error) {
	response = CreateListApprovalSchemasResponse()
	err = client.DoAction(request, response)
	return
}

// ListApprovalSchemasWithChan invokes the csas.ListApprovalSchemas API asynchronously
func (client *Client) ListApprovalSchemasWithChan(request *ListApprovalSchemasRequest) (<-chan *ListApprovalSchemasResponse, <-chan error) {
	responseChan := make(chan *ListApprovalSchemasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApprovalSchemas(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListApprovalSchemasWithCallback invokes the csas.ListApprovalSchemas API asynchronously
func (client *Client) ListApprovalSchemasWithCallback(request *ListApprovalSchemasRequest, callback func(response *ListApprovalSchemasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListApprovalSchemasResponse
		var err error
		defer close(result)
		response, err = client.ListApprovalSchemas(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListApprovalSchemasRequest is the request struct for api ListApprovalSchemas
type ListApprovalSchemasRequest struct {
	*requests.RpcRequest
	SourceIp    string           `position:"Query" name:"SourceIp"`
	SchemaIds   *[]string        `position:"Query" name:"SchemaIds"  type:"Repeated"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	SchemaName  string           `position:"Query" name:"SchemaName"`
	PolicyType  string           `position:"Query" name:"PolicyType"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
}

// ListApprovalSchemasResponse is the response struct for api ListApprovalSchemas
type ListApprovalSchemasResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	TotalNum  string     `json:"TotalNum" xml:"TotalNum"`
	Schemas   []DataList `json:"Schemas" xml:"Schemas"`
}

// CreateListApprovalSchemasRequest creates a request to invoke ListApprovalSchemas API
func CreateListApprovalSchemasRequest() (request *ListApprovalSchemasRequest) {
	request = &ListApprovalSchemasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListApprovalSchemas", "", "")
	request.Method = requests.GET
	return
}

// CreateListApprovalSchemasResponse creates a response to parse from ListApprovalSchemas response
func CreateListApprovalSchemasResponse() (response *ListApprovalSchemasResponse) {
	response = &ListApprovalSchemasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
