package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApplicationsForPrivateAccessPolicy invokes the csas.ListApplicationsForPrivateAccessPolicy API synchronously
func (client *Client) ListApplicationsForPrivateAccessPolicy(request *ListApplicationsForPrivateAccessPolicyRequest) (response *ListApplicationsForPrivateAccessPolicyResponse, err error) {
	response = CreateListApplicationsForPrivateAccessPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// ListApplicationsForPrivateAccessPolicyWithChan invokes the csas.ListApplicationsForPrivateAccessPolicy API asynchronously
func (client *Client) ListApplicationsForPrivateAccessPolicyWithChan(request *ListApplicationsForPrivateAccessPolicyRequest) (<-chan *ListApplicationsForPrivateAccessPolicyResponse, <-chan error) {
	responseChan := make(chan *ListApplicationsForPrivateAccessPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApplicationsForPrivateAccessPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListApplicationsForPrivateAccessPolicyWithCallback invokes the csas.ListApplicationsForPrivateAccessPolicy API asynchronously
func (client *Client) ListApplicationsForPrivateAccessPolicyWithCallback(request *ListApplicationsForPrivateAccessPolicyRequest, callback func(response *ListApplicationsForPrivateAccessPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListApplicationsForPrivateAccessPolicyResponse
		var err error
		defer close(result)
		response, err = client.ListApplicationsForPrivateAccessPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListApplicationsForPrivateAccessPolicyRequest is the request struct for api ListApplicationsForPrivateAccessPolicy
type ListApplicationsForPrivateAccessPolicyRequest struct {
	*requests.RpcRequest
	PolicyIds *[]string `position:"Query" name:"PolicyIds"  type:"Repeated"`
	SourceIp  string    `position:"Query" name:"SourceIp"`
}

// ListApplicationsForPrivateAccessPolicyResponse is the response struct for api ListApplicationsForPrivateAccessPolicy
type ListApplicationsForPrivateAccessPolicyResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Polices   []Policy `json:"Polices" xml:"Polices"`
}

// CreateListApplicationsForPrivateAccessPolicyRequest creates a request to invoke ListApplicationsForPrivateAccessPolicy API
func CreateListApplicationsForPrivateAccessPolicyRequest() (request *ListApplicationsForPrivateAccessPolicyRequest) {
	request = &ListApplicationsForPrivateAccessPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListApplicationsForPrivateAccessPolicy", "", "")
	request.Method = requests.GET
	return
}

// CreateListApplicationsForPrivateAccessPolicyResponse creates a response to parse from ListApplicationsForPrivateAccessPolicy response
func CreateListApplicationsForPrivateAccessPolicyResponse() (response *ListApplicationsForPrivateAccessPolicyResponse) {
	response = &ListApplicationsForPrivateAccessPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
