package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetScanMode invokes the cloudwf.GetScanMode API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getscanmode.html
func (client *Client) GetScanMode(request *GetScanModeRequest) (response *GetScanModeResponse, err error) {
	response = CreateGetScanModeResponse()
	err = client.DoAction(request, response)
	return
}

// GetScanModeWithChan invokes the cloudwf.GetScanMode API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getscanmode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetScanModeWithChan(request *GetScanModeRequest) (<-chan *GetScanModeResponse, <-chan error) {
	responseChan := make(chan *GetScanModeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetScanMode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetScanModeWithCallback invokes the cloudwf.GetScanMode API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getscanmode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetScanModeWithCallback(request *GetScanModeRequest, callback func(response *GetScanModeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetScanModeResponse
		var err error
		defer close(result)
		response, err = client.GetScanMode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetScanModeRequest is the request struct for api GetScanMode
type GetScanModeRequest struct {
	*requests.RpcRequest
	MacList *[]string `position:"Query" name:"MacList"  type:"Repeated"`
}

// GetScanModeResponse is the response struct for api GetScanMode
type GetScanModeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetScanModeRequest creates a request to invoke GetScanMode API
func CreateGetScanModeRequest() (request *GetScanModeRequest) {
	request = &GetScanModeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetScanMode", "cloudwf", "openAPI")
	return
}

// CreateGetScanModeResponse creates a response to parse from GetScanMode response
func CreateGetScanModeResponse() (response *GetScanModeResponse) {
	response = &GetScanModeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
