package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyFirewallV2RoutePolicySwitch invokes the cloudfw.ModifyFirewallV2RoutePolicySwitch API synchronously
func (client *Client) ModifyFirewallV2RoutePolicySwitch(request *ModifyFirewallV2RoutePolicySwitchRequest) (response *ModifyFirewallV2RoutePolicySwitchResponse, err error) {
	response = CreateModifyFirewallV2RoutePolicySwitchResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyFirewallV2RoutePolicySwitchWithChan invokes the cloudfw.ModifyFirewallV2RoutePolicySwitch API asynchronously
func (client *Client) ModifyFirewallV2RoutePolicySwitchWithChan(request *ModifyFirewallV2RoutePolicySwitchRequest) (<-chan *ModifyFirewallV2RoutePolicySwitchResponse, <-chan error) {
	responseChan := make(chan *ModifyFirewallV2RoutePolicySwitchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyFirewallV2RoutePolicySwitch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyFirewallV2RoutePolicySwitchWithCallback invokes the cloudfw.ModifyFirewallV2RoutePolicySwitch API asynchronously
func (client *Client) ModifyFirewallV2RoutePolicySwitchWithCallback(request *ModifyFirewallV2RoutePolicySwitchRequest, callback func(response *ModifyFirewallV2RoutePolicySwitchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyFirewallV2RoutePolicySwitchResponse
		var err error
		defer close(result)
		response, err = client.ModifyFirewallV2RoutePolicySwitch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyFirewallV2RoutePolicySwitchRequest is the request struct for api ModifyFirewallV2RoutePolicySwitch
type ModifyFirewallV2RoutePolicySwitchRequest struct {
	*requests.RpcRequest
	ShouldRecover                     string `position:"Query" name:"ShouldRecover"`
	FirewallId                        string `position:"Query" name:"FirewallId"`
	SourceIp                          string `position:"Query" name:"SourceIp"`
	Lang                              string `position:"Query" name:"Lang"`
	TrFirewallRoutePolicyId           string `position:"Query" name:"TrFirewallRoutePolicyId"`
	TrFirewallRoutePolicySwitchStatus string `position:"Query" name:"TrFirewallRoutePolicySwitchStatus"`
}

// ModifyFirewallV2RoutePolicySwitchResponse is the response struct for api ModifyFirewallV2RoutePolicySwitch
type ModifyFirewallV2RoutePolicySwitchResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyFirewallV2RoutePolicySwitchRequest creates a request to invoke ModifyFirewallV2RoutePolicySwitch API
func CreateModifyFirewallV2RoutePolicySwitchRequest() (request *ModifyFirewallV2RoutePolicySwitchRequest) {
	request = &ModifyFirewallV2RoutePolicySwitchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "ModifyFirewallV2RoutePolicySwitch", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyFirewallV2RoutePolicySwitchResponse creates a response to parse from ModifyFirewallV2RoutePolicySwitch response
func CreateModifyFirewallV2RoutePolicySwitchResponse() (response *ModifyFirewallV2RoutePolicySwitchResponse) {
	response = &ModifyFirewallV2RoutePolicySwitchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
