package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCompanyTemplatePicture invokes the cloudesl.GetCompanyTemplatePicture API synchronously
func (client *Client) GetCompanyTemplatePicture(request *GetCompanyTemplatePictureRequest) (response *GetCompanyTemplatePictureResponse, err error) {
	response = CreateGetCompanyTemplatePictureResponse()
	err = client.DoAction(request, response)
	return
}

// GetCompanyTemplatePictureWithChan invokes the cloudesl.GetCompanyTemplatePicture API asynchronously
func (client *Client) GetCompanyTemplatePictureWithChan(request *GetCompanyTemplatePictureRequest) (<-chan *GetCompanyTemplatePictureResponse, <-chan error) {
	responseChan := make(chan *GetCompanyTemplatePictureResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCompanyTemplatePicture(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCompanyTemplatePictureWithCallback invokes the cloudesl.GetCompanyTemplatePicture API asynchronously
func (client *Client) GetCompanyTemplatePictureWithCallback(request *GetCompanyTemplatePictureRequest, callback func(response *GetCompanyTemplatePictureResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCompanyTemplatePictureResponse
		var err error
		defer close(result)
		response, err = client.GetCompanyTemplatePicture(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCompanyTemplatePictureRequest is the request struct for api GetCompanyTemplatePicture
type GetCompanyTemplatePictureRequest struct {
	*requests.RpcRequest
	ExtraParams string `position:"Body" name:"ExtraParams"`
	Data        string `position:"Body" name:"Data"`
}

// GetCompanyTemplatePictureResponse is the response struct for api GetCompanyTemplatePicture
type GetCompanyTemplatePictureResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Code           string `json:"Code" xml:"Code"`
	Base64Picture  string `json:"Base64Picture" xml:"Base64Picture"`
	Message        string `json:"Message" xml:"Message"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
}

// CreateGetCompanyTemplatePictureRequest creates a request to invoke GetCompanyTemplatePicture API
func CreateGetCompanyTemplatePictureRequest() (request *GetCompanyTemplatePictureRequest) {
	request = &GetCompanyTemplatePictureRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "GetCompanyTemplatePicture", "", "")
	request.Method = requests.POST
	return
}

// CreateGetCompanyTemplatePictureResponse creates a response to parse from GetCompanyTemplatePicture response
func CreateGetCompanyTemplatePictureResponse() (response *GetCompanyTemplatePictureResponse) {
	response = &GetCompanyTemplatePictureResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
