package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBinders invokes the cloudesl.DescribeBinders API synchronously
func (client *Client) DescribeBinders(request *DescribeBindersRequest) (response *DescribeBindersResponse, err error) {
	response = CreateDescribeBindersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBindersWithChan invokes the cloudesl.DescribeBinders API asynchronously
func (client *Client) DescribeBindersWithChan(request *DescribeBindersRequest) (<-chan *DescribeBindersResponse, <-chan error) {
	responseChan := make(chan *DescribeBindersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBinders(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBindersWithCallback invokes the cloudesl.DescribeBinders API asynchronously
func (client *Client) DescribeBindersWithCallback(request *DescribeBindersRequest, callback func(response *DescribeBindersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBindersResponse
		var err error
		defer close(result)
		response, err = client.DescribeBinders(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBindersRequest is the request struct for api DescribeBinders
type DescribeBindersRequest struct {
	*requests.RpcRequest
	ExtraParams string           `position:"Body" name:"ExtraParams"`
	StoreId     string           `position:"Body" name:"StoreId"`
	PageNumber  requests.Integer `position:"Body" name:"PageNumber"`
	EslBarCode  string           `position:"Body" name:"EslBarCode"`
	PageSize    requests.Integer `position:"Body" name:"PageSize"`
	ItemBarCode string           `position:"Body" name:"ItemBarCode"`
	ItemTitle   string           `position:"Body" name:"ItemTitle"`
}

// DescribeBindersResponse is the response struct for api DescribeBinders
type DescribeBindersResponse struct {
	*responses.BaseResponse
	RequestId        string            `json:"RequestId" xml:"RequestId"`
	ErrorMessage     string            `json:"ErrorMessage" xml:"ErrorMessage"`
	Success          bool              `json:"Success" xml:"Success"`
	ErrorCode        string            `json:"ErrorCode" xml:"ErrorCode"`
	Code             string            `json:"Code" xml:"Code"`
	Message          string            `json:"Message" xml:"Message"`
	DynamicMessage   string            `json:"DynamicMessage" xml:"DynamicMessage"`
	PageNumber       int               `json:"PageNumber" xml:"PageNumber"`
	PageSize         int               `json:"PageSize" xml:"PageSize"`
	TotalCount       int               `json:"TotalCount" xml:"TotalCount"`
	DynamicCode      string            `json:"DynamicCode" xml:"DynamicCode"`
	EslItemBindInfos []EslItemBindInfo `json:"EslItemBindInfos" xml:"EslItemBindInfos"`
}

// CreateDescribeBindersRequest creates a request to invoke DescribeBinders API
func CreateDescribeBindersRequest() (request *DescribeBindersRequest) {
	request = &DescribeBindersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "DescribeBinders", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeBindersResponse creates a response to parse from DescribeBinders response
func CreateDescribeBindersResponse() (response *DescribeBindersResponse) {
	response = &DescribeBindersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
