package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCloudSiemAssets invokes the cloud_siem.DescribeCloudSiemAssets API synchronously
func (client *Client) DescribeCloudSiemAssets(request *DescribeCloudSiemAssetsRequest) (response *DescribeCloudSiemAssetsResponse, err error) {
	response = CreateDescribeCloudSiemAssetsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCloudSiemAssetsWithChan invokes the cloud_siem.DescribeCloudSiemAssets API asynchronously
func (client *Client) DescribeCloudSiemAssetsWithChan(request *DescribeCloudSiemAssetsRequest) (<-chan *DescribeCloudSiemAssetsResponse, <-chan error) {
	responseChan := make(chan *DescribeCloudSiemAssetsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCloudSiemAssets(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCloudSiemAssetsWithCallback invokes the cloud_siem.DescribeCloudSiemAssets API asynchronously
func (client *Client) DescribeCloudSiemAssetsWithCallback(request *DescribeCloudSiemAssetsRequest, callback func(response *DescribeCloudSiemAssetsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCloudSiemAssetsResponse
		var err error
		defer close(result)
		response, err = client.DescribeCloudSiemAssets(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCloudSiemAssetsRequest is the request struct for api DescribeCloudSiemAssets
type DescribeCloudSiemAssetsRequest struct {
	*requests.RpcRequest
	PageSize     requests.Integer `position:"Body" name:"PageSize"`
	AssetType    string           `position:"Body" name:"AssetType"`
	CurrentPage  requests.Integer `position:"Body" name:"CurrentPage"`
	IncidentUuid string           `position:"Body" name:"IncidentUuid"`
}

// DescribeCloudSiemAssetsResponse is the response struct for api DescribeCloudSiemAssets
type DescribeCloudSiemAssetsResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeCloudSiemAssetsRequest creates a request to invoke DescribeCloudSiemAssets API
func CreateDescribeCloudSiemAssetsRequest() (request *DescribeCloudSiemAssetsRequest) {
	request = &DescribeCloudSiemAssetsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DescribeCloudSiemAssets", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCloudSiemAssetsResponse creates a response to parse from DescribeCloudSiemAssets response
func CreateDescribeCloudSiemAssetsResponse() (response *DescribeCloudSiemAssetsResponse) {
	response = &DescribeCloudSiemAssetsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
