package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainBpsData invokes the cdn.DescribeDomainBpsData API synchronously
func (client *Client) DescribeDomainBpsData(request *DescribeDomainBpsDataRequest) (response *DescribeDomainBpsDataResponse, err error) {
	response = CreateDescribeDomainBpsDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainBpsDataWithChan invokes the cdn.DescribeDomainBpsData API asynchronously
func (client *Client) DescribeDomainBpsDataWithChan(request *DescribeDomainBpsDataRequest) (<-chan *DescribeDomainBpsDataResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainBpsDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainBpsData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainBpsDataWithCallback invokes the cdn.DescribeDomainBpsData API asynchronously
func (client *Client) DescribeDomainBpsDataWithCallback(request *DescribeDomainBpsDataRequest, callback func(response *DescribeDomainBpsDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainBpsDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainBpsData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainBpsDataRequest is the request struct for api DescribeDomainBpsData
type DescribeDomainBpsDataRequest struct {
	*requests.RpcRequest
	DomainName     string `position:"Query" name:"DomainName"`
	EndTime        string `position:"Query" name:"EndTime"`
	Interval       string `position:"Query" name:"Interval"`
	LocationNameEn string `position:"Query" name:"LocationNameEn"`
	StartTime      string `position:"Query" name:"StartTime"`
	IspNameEn      string `position:"Query" name:"IspNameEn"`
}

// DescribeDomainBpsDataResponse is the response struct for api DescribeDomainBpsData
type DescribeDomainBpsDataResponse struct {
	*responses.BaseResponse
	EndTime            string             `json:"EndTime" xml:"EndTime"`
	StartTime          string             `json:"StartTime" xml:"StartTime"`
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	IspNameEn          string             `json:"IspNameEn" xml:"IspNameEn"`
	LocationNameEn     string             `json:"LocationNameEn" xml:"LocationNameEn"`
	DomainName         string             `json:"DomainName" xml:"DomainName"`
	DataInterval       string             `json:"DataInterval" xml:"DataInterval"`
	BpsDataPerInterval BpsDataPerInterval `json:"BpsDataPerInterval" xml:"BpsDataPerInterval"`
}

// CreateDescribeDomainBpsDataRequest creates a request to invoke DescribeDomainBpsData API
func CreateDescribeDomainBpsDataRequest() (request *DescribeDomainBpsDataRequest) {
	request = &DescribeDomainBpsDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeDomainBpsData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDomainBpsDataResponse creates a response to parse from DescribeDomainBpsData response
func CreateDescribeDomainBpsDataResponse() (response *DescribeDomainBpsDataResponse) {
	response = &DescribeDomainBpsDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
