package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CommitContactFlow invokes the ccc.CommitContactFlow API synchronously
func (client *Client) CommitContactFlow(request *CommitContactFlowRequest) (response *CommitContactFlowResponse, err error) {
	response = CreateCommitContactFlowResponse()
	err = client.DoAction(request, response)
	return
}

// CommitContactFlowWithChan invokes the ccc.CommitContactFlow API asynchronously
func (client *Client) CommitContactFlowWithChan(request *CommitContactFlowRequest) (<-chan *CommitContactFlowResponse, <-chan error) {
	responseChan := make(chan *CommitContactFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CommitContactFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CommitContactFlowWithCallback invokes the ccc.CommitContactFlow API asynchronously
func (client *Client) CommitContactFlowWithCallback(request *CommitContactFlowRequest, callback func(response *CommitContactFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CommitContactFlowResponse
		var err error
		defer close(result)
		response, err = client.CommitContactFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CommitContactFlowRequest is the request struct for api CommitContactFlow
type CommitContactFlowRequest struct {
	*requests.RpcRequest
	ContactFlowId string `position:"Query" name:"ContactFlowId"`
	DraftId       string `position:"Query" name:"DraftId"`
	Description   string `position:"Query" name:"Description"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	Definition    string `position:"Query" name:"Definition"`
}

// CommitContactFlowResponse is the response struct for api CommitContactFlow
type CommitContactFlowResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateCommitContactFlowRequest creates a request to invoke CommitContactFlow API
func CreateCommitContactFlowRequest() (request *CommitContactFlowRequest) {
	request = &CommitContactFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "CommitContactFlow", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCommitContactFlowResponse creates a response to parse from CommitContactFlow response
func CreateCommitContactFlowResponse() (response *CommitContactFlowResponse) {
	response = &CommitContactFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
