package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTransitRouterCidr invokes the cbn.CreateTransitRouterCidr API synchronously
func (client *Client) CreateTransitRouterCidr(request *CreateTransitRouterCidrRequest) (response *CreateTransitRouterCidrResponse, err error) {
	response = CreateCreateTransitRouterCidrResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTransitRouterCidrWithChan invokes the cbn.CreateTransitRouterCidr API asynchronously
func (client *Client) CreateTransitRouterCidrWithChan(request *CreateTransitRouterCidrRequest) (<-chan *CreateTransitRouterCidrResponse, <-chan error) {
	responseChan := make(chan *CreateTransitRouterCidrResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTransitRouterCidr(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTransitRouterCidrWithCallback invokes the cbn.CreateTransitRouterCidr API asynchronously
func (client *Client) CreateTransitRouterCidrWithCallback(request *CreateTransitRouterCidrRequest, callback func(response *CreateTransitRouterCidrResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTransitRouterCidrResponse
		var err error
		defer close(result)
		response, err = client.CreateTransitRouterCidr(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTransitRouterCidrRequest is the request struct for api CreateTransitRouterCidr
type CreateTransitRouterCidrRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	Description          string           `position:"Query" name:"Description"`
	Cidr                 string           `position:"Query" name:"Cidr"`
	PublishCidrRoute     requests.Boolean `position:"Query" name:"PublishCidrRoute"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TransitRouterId      string           `position:"Query" name:"TransitRouterId"`
	Version              string           `position:"Query" name:"Version"`
	Name                 string           `position:"Query" name:"Name"`
}

// CreateTransitRouterCidrResponse is the response struct for api CreateTransitRouterCidr
type CreateTransitRouterCidrResponse struct {
	*responses.BaseResponse
	TransitRouterCidrId string `json:"TransitRouterCidrId" xml:"TransitRouterCidrId"`
	RequestId           string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateTransitRouterCidrRequest creates a request to invoke CreateTransitRouterCidr API
func CreateCreateTransitRouterCidrRequest() (request *CreateTransitRouterCidrRequest) {
	request = &CreateTransitRouterCidrRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "CreateTransitRouterCidr", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateTransitRouterCidrResponse creates a response to parse from CreateTransitRouterCidr response
func CreateCreateTransitRouterCidrResponse() (response *CreateTransitRouterCidrResponse) {
	response = &CreateTransitRouterCidrResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
