package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAccountRelation invokes the bssopenapi.GetAccountRelation API synchronously
func (client *Client) GetAccountRelation(request *GetAccountRelationRequest) (response *GetAccountRelationResponse, err error) {
	response = CreateGetAccountRelationResponse()
	err = client.DoAction(request, response)
	return
}

// GetAccountRelationWithChan invokes the bssopenapi.GetAccountRelation API asynchronously
func (client *Client) GetAccountRelationWithChan(request *GetAccountRelationRequest) (<-chan *GetAccountRelationResponse, <-chan error) {
	responseChan := make(chan *GetAccountRelationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAccountRelation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAccountRelationWithCallback invokes the bssopenapi.GetAccountRelation API asynchronously
func (client *Client) GetAccountRelationWithCallback(request *GetAccountRelationRequest, callback func(response *GetAccountRelationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAccountRelationResponse
		var err error
		defer close(result)
		response, err = client.GetAccountRelation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAccountRelationRequest is the request struct for api GetAccountRelation
type GetAccountRelationRequest struct {
	*requests.RpcRequest
	RequestId  string           `position:"Query" name:"RequestId"`
	RelationId requests.Integer `position:"Query" name:"RelationId"`
}

// GetAccountRelationResponse is the response struct for api GetAccountRelation
type GetAccountRelationResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetAccountRelationRequest creates a request to invoke GetAccountRelation API
func CreateGetAccountRelationRequest() (request *GetAccountRelationRequest) {
	request = &GetAccountRelationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "GetAccountRelation", "bssopenapi", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetAccountRelationResponse creates a response to parse from GetAccountRelation response
func CreateGetAccountRelationResponse() (response *GetAccountRelationResponse) {
	response = &GetAccountRelationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
