package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFabricOrdererLogs invokes the baas.DescribeFabricOrdererLogs API synchronously
// api document: https://help.aliyun.com/api/baas/describefabricordererlogs.html
func (client *Client) DescribeFabricOrdererLogs(request *DescribeFabricOrdererLogsRequest) (response *DescribeFabricOrdererLogsResponse, err error) {
	response = CreateDescribeFabricOrdererLogsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFabricOrdererLogsWithChan invokes the baas.DescribeFabricOrdererLogs API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricordererlogs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricOrdererLogsWithChan(request *DescribeFabricOrdererLogsRequest) (<-chan *DescribeFabricOrdererLogsResponse, <-chan error) {
	responseChan := make(chan *DescribeFabricOrdererLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFabricOrdererLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFabricOrdererLogsWithCallback invokes the baas.DescribeFabricOrdererLogs API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricordererlogs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricOrdererLogsWithCallback(request *DescribeFabricOrdererLogsRequest, callback func(response *DescribeFabricOrdererLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFabricOrdererLogsResponse
		var err error
		defer close(result)
		response, err = client.DescribeFabricOrdererLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFabricOrdererLogsRequest is the request struct for api DescribeFabricOrdererLogs
type DescribeFabricOrdererLogsRequest struct {
	*requests.RpcRequest
	OrdererName  string `position:"Query" name:"OrdererName"`
	Lines        string `position:"Query" name:"Lines"`
	ConsortiumId string `position:"Query" name:"ConsortiumId"`
}

// DescribeFabricOrdererLogsResponse is the response struct for api DescribeFabricOrdererLogs
type DescribeFabricOrdererLogsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateDescribeFabricOrdererLogsRequest creates a request to invoke DescribeFabricOrdererLogs API
func CreateDescribeFabricOrdererLogsRequest() (request *DescribeFabricOrdererLogsRequest) {
	request = &DescribeFabricOrdererLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeFabricOrdererLogs", "baas", "openAPI")
	return
}

// CreateDescribeFabricOrdererLogsResponse creates a response to parse from DescribeFabricOrdererLogs response
func CreateDescribeFabricOrdererLogsResponse() (response *DescribeFabricOrdererLogsResponse) {
	response = &DescribeFabricOrdererLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
