package avatar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ClientStart invokes the avatar.ClientStart API synchronously
func (client *Client) ClientStart(request *ClientStartRequest) (response *ClientStartResponse, err error) {
	response = CreateClientStartResponse()
	err = client.DoAction(request, response)
	return
}

// ClientStartWithChan invokes the avatar.ClientStart API asynchronously
func (client *Client) ClientStartWithChan(request *ClientStartRequest) (<-chan *ClientStartResponse, <-chan error) {
	responseChan := make(chan *ClientStartResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ClientStart(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ClientStartWithCallback invokes the avatar.ClientStart API asynchronously
func (client *Client) ClientStartWithCallback(request *ClientStartRequest, callback func(response *ClientStartResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ClientStartResponse
		var err error
		defer close(result)
		response, err = client.ClientStart(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ClientStartRequest is the request struct for api ClientStart
type ClientStartRequest struct {
	*requests.RpcRequest
	AppId    string           `position:"Query" name:"AppId"`
	TenantId requests.Integer `position:"Query" name:"TenantId"`
}

// ClientStartResponse is the response struct for api ClientStart
type ClientStartResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateClientStartRequest creates a request to invoke ClientStart API
func CreateClientStartRequest() (request *ClientStartRequest) {
	request = &ClientStartRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("avatar", "2022-01-30", "ClientStart", "", "")
	request.Method = requests.POST
	return
}

// CreateClientStartResponse creates a response to parse from ClientStart response
func CreateClientStartResponse() (response *ClientStartResponse) {
	response = &ClientStartResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
