package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DelAuthToken invokes the arms.DelAuthToken API synchronously
func (client *Client) DelAuthToken(request *DelAuthTokenRequest) (response *DelAuthTokenResponse, err error) {
	response = CreateDelAuthTokenResponse()
	err = client.DoAction(request, response)
	return
}

// DelAuthTokenWithChan invokes the arms.DelAuthToken API asynchronously
func (client *Client) DelAuthTokenWithChan(request *DelAuthTokenRequest) (<-chan *DelAuthTokenResponse, <-chan error) {
	responseChan := make(chan *DelAuthTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DelAuthToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DelAuthTokenWithCallback invokes the arms.DelAuthToken API asynchronously
func (client *Client) DelAuthTokenWithCallback(request *DelAuthTokenRequest, callback func(response *DelAuthTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DelAuthTokenResponse
		var err error
		defer close(result)
		response, err = client.DelAuthToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DelAuthTokenRequest is the request struct for api DelAuthToken
type DelAuthTokenRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// DelAuthTokenResponse is the response struct for api DelAuthToken
type DelAuthTokenResponse struct {
	*responses.BaseResponse
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDelAuthTokenRequest creates a request to invoke DelAuthToken API
func CreateDelAuthTokenRequest() (request *DelAuthTokenRequest) {
	request = &DelAuthTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "DelAuthToken", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDelAuthTokenResponse creates a response to parse from DelAuthToken response
func CreateDelAuthTokenResponse() (response *DelAuthTokenResponse) {
	response = &DelAuthTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
