package amp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MyROAHTTP invokes the amp.MyROAHTTP API synchronously
func (client *Client) MyROAHTTP(request *MyROAHTTPRequest) (response *MyROAHTTPResponse, err error) {
	response = CreateMyROAHTTPResponse()
	err = client.DoAction(request, response)
	return
}

// MyROAHTTPWithChan invokes the amp.MyROAHTTP API asynchronously
func (client *Client) MyROAHTTPWithChan(request *MyROAHTTPRequest) (<-chan *MyROAHTTPResponse, <-chan error) {
	responseChan := make(chan *MyROAHTTPResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MyROAHTTP(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MyROAHTTPWithCallback invokes the amp.MyROAHTTP API asynchronously
func (client *Client) MyROAHTTPWithCallback(request *MyROAHTTPRequest, callback func(response *MyROAHTTPResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MyROAHTTPResponse
		var err error
		defer close(result)
		response, err = client.MyROAHTTP(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MyROAHTTPRequest is the request struct for api MyROAHTTP
type MyROAHTTPRequest struct {
	*requests.RoaRequest
	RequestId string `position:"Query" name:"requestId"`
}

// MyROAHTTPResponse is the response struct for api MyROAHTTP
type MyROAHTTPResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"requestId" xml:"requestId"`
	Address   Address `json:"address" xml:"address"`
}

// CreateMyROAHTTPRequest creates a request to invoke MyROAHTTP API
func CreateMyROAHTTPRequest() (request *MyROAHTTPRequest) {
	request = &MyROAHTTPRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("amp", "2020-07-08", "MyROAHTTP", "/rpc/v1/demo8", "ServiceCode", "openAPI")
	request.Method = requests.POST
	return
}

// CreateMyROAHTTPResponse creates a response to parse from MyROAHTTP response
func CreateMyROAHTTPResponse() (response *MyROAHTTPResponse) {
	response = &MyROAHTTPResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
