package amp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// LastTestDuhe invokes the amp.LastTestDuhe API synchronously
func (client *Client) LastTestDuhe(request *LastTestDuheRequest) (response *LastTestDuheResponse, err error) {
	response = CreateLastTestDuheResponse()
	err = client.DoAction(request, response)
	return
}

// LastTestDuheWithChan invokes the amp.LastTestDuhe API asynchronously
func (client *Client) LastTestDuheWithChan(request *LastTestDuheRequest) (<-chan *LastTestDuheResponse, <-chan error) {
	responseChan := make(chan *LastTestDuheResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.LastTestDuhe(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// LastTestDuheWithCallback invokes the amp.LastTestDuhe API asynchronously
func (client *Client) LastTestDuheWithCallback(request *LastTestDuheRequest, callback func(response *LastTestDuheResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *LastTestDuheResponse
		var err error
		defer close(result)
		response, err = client.LastTestDuhe(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// LastTestDuheRequest is the request struct for api LastTestDuhe
type LastTestDuheRequest struct {
	*requests.RoaRequest
}

// LastTestDuheResponse is the response struct for api LastTestDuhe
type LastTestDuheResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateLastTestDuheRequest creates a request to invoke LastTestDuhe API
func CreateLastTestDuheRequest() (request *LastTestDuheRequest) {
	request = &LastTestDuheRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("amp", "2020-07-08", "LastTestDuhe", "/aef/a", "ServiceCode", "openAPI")
	request.Method = requests.POST
	return
}

// CreateLastTestDuheResponse creates a response to parse from LastTestDuhe response
func CreateLastTestDuheResponse() (response *LastTestDuheResponse) {
	response = &LastTestDuheResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
