package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDohUserInfo invokes the alidns.DescribeDohUserInfo API synchronously
func (client *Client) DescribeDohUserInfo(request *DescribeDohUserInfoRequest) (response *DescribeDohUserInfoResponse, err error) {
	response = CreateDescribeDohUserInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDohUserInfoWithChan invokes the alidns.DescribeDohUserInfo API asynchronously
func (client *Client) DescribeDohUserInfoWithChan(request *DescribeDohUserInfoRequest) (<-chan *DescribeDohUserInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeDohUserInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDohUserInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDohUserInfoWithCallback invokes the alidns.DescribeDohUserInfo API asynchronously
func (client *Client) DescribeDohUserInfoWithCallback(request *DescribeDohUserInfoRequest, callback func(response *DescribeDohUserInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDohUserInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeDohUserInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDohUserInfoRequest is the request struct for api DescribeDohUserInfo
type DescribeDohUserInfoRequest struct {
	*requests.RpcRequest
	StartDate string `position:"Query" name:"StartDate"`
	EndDate   string `position:"Query" name:"EndDate"`
	Lang      string `position:"Query" name:"Lang"`
}

// DescribeDohUserInfoResponse is the response struct for api DescribeDohUserInfo
type DescribeDohUserInfoResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	SubDomainCount int    `json:"SubDomainCount" xml:"SubDomainCount"`
	PdnsId         int64  `json:"PdnsId" xml:"PdnsId"`
	DomainCount    int    `json:"DomainCount" xml:"DomainCount"`
}

// CreateDescribeDohUserInfoRequest creates a request to invoke DescribeDohUserInfo API
func CreateDescribeDohUserInfoRequest() (request *DescribeDohUserInfoRequest) {
	request = &DescribeDohUserInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeDohUserInfo", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDohUserInfoResponse creates a response to parse from DescribeDohUserInfo response
func CreateDescribeDohUserInfoResponse() (response *DescribeDohUserInfoResponse) {
	response = &DescribeDohUserInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
