package aimiaobi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateToken invokes the aimiaobi.CreateToken API synchronously
func (client *Client) CreateToken(request *CreateTokenRequest) (response *CreateTokenResponse, err error) {
	response = CreateCreateTokenResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTokenWithChan invokes the aimiaobi.CreateToken API asynchronously
func (client *Client) CreateTokenWithChan(request *CreateTokenRequest) (<-chan *CreateTokenResponse, <-chan error) {
	responseChan := make(chan *CreateTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTokenWithCallback invokes the aimiaobi.CreateToken API asynchronously
func (client *Client) CreateTokenWithCallback(request *CreateTokenRequest, callback func(response *CreateTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTokenResponse
		var err error
		defer close(result)
		response, err = client.CreateToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTokenRequest is the request struct for api CreateToken
type CreateTokenRequest struct {
	*requests.RpcRequest
	AgentKey string `position:"Query" name:"AgentKey"`
}

// CreateTokenResponse is the response struct for api CreateToken
type CreateTokenResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateCreateTokenRequest creates a request to invoke CreateToken API
func CreateCreateTokenRequest() (request *CreateTokenRequest) {
	request = &CreateTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("AiMiaoBi", "2023-08-01", "CreateToken", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateTokenResponse creates a response to parse from CreateToken response
func CreateCreateTokenResponse() (response *CreateTokenResponse) {
	response = &CreateTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
