package aimath

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenStep invokes the aimath.GenStep API synchronously
func (client *Client) GenStep(request *GenStepRequest) (response *GenStepResponse, err error) {
	response = CreateGenStepResponse()
	err = client.DoAction(request, response)
	return
}

// GenStepWithChan invokes the aimath.GenStep API asynchronously
func (client *Client) GenStepWithChan(request *GenStepRequest) (<-chan *GenStepResponse, <-chan error) {
	responseChan := make(chan *GenStepResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenStep(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenStepWithCallback invokes the aimath.GenStep API asynchronously
func (client *Client) GenStepWithCallback(request *GenStepRequest, callback func(response *GenStepResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenStepResponse
		var err error
		defer close(result)
		response, err = client.GenStep(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenStepRequest is the request struct for api GenStep
type GenStepRequest struct {
	*requests.RpcRequest
	ExerciseCode string `position:"Body" name:"ExerciseCode"`
}

// GenStepResponse is the response struct for api GenStep
type GenStepResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	EventType string `json:"EventType" xml:"EventType"`
	Content   string `json:"Content" xml:"Content"`
	ErrCode   string `json:"ErrCode" xml:"ErrCode"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
}

// CreateGenStepRequest creates a request to invoke GenStep API
func CreateGenStepRequest() (request *GenStepRequest) {
	request = &GenStepRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("AIMath", "2024-11-14", "GenStep", "", "")
	request.Method = requests.POST
	return
}

// CreateGenStepResponse creates a response to parse from GenStep response
func CreateGenStepResponse() (response *GenStepResponse) {
	response = &GenStepResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
