package aicontent

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Personalizedtxt2imgQueryModelTrainJobList invokes the aicontent.Personalizedtxt2imgQueryModelTrainJobList API synchronously
func (client *Client) Personalizedtxt2imgQueryModelTrainJobList(request *Personalizedtxt2imgQueryModelTrainJobListRequest) (response *Personalizedtxt2imgQueryModelTrainJobListResponse, err error) {
	response = CreatePersonalizedtxt2imgQueryModelTrainJobListResponse()
	err = client.DoAction(request, response)
	return
}

// Personalizedtxt2imgQueryModelTrainJobListWithChan invokes the aicontent.Personalizedtxt2imgQueryModelTrainJobList API asynchronously
func (client *Client) Personalizedtxt2imgQueryModelTrainJobListWithChan(request *Personalizedtxt2imgQueryModelTrainJobListRequest) (<-chan *Personalizedtxt2imgQueryModelTrainJobListResponse, <-chan error) {
	responseChan := make(chan *Personalizedtxt2imgQueryModelTrainJobListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Personalizedtxt2imgQueryModelTrainJobList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// Personalizedtxt2imgQueryModelTrainJobListWithCallback invokes the aicontent.Personalizedtxt2imgQueryModelTrainJobList API asynchronously
func (client *Client) Personalizedtxt2imgQueryModelTrainJobListWithCallback(request *Personalizedtxt2imgQueryModelTrainJobListRequest, callback func(response *Personalizedtxt2imgQueryModelTrainJobListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *Personalizedtxt2imgQueryModelTrainJobListResponse
		var err error
		defer close(result)
		response, err = client.Personalizedtxt2imgQueryModelTrainJobList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// Personalizedtxt2imgQueryModelTrainJobListRequest is the request struct for api Personalizedtxt2imgQueryModelTrainJobList
type Personalizedtxt2imgQueryModelTrainJobListRequest struct {
	*requests.RoaRequest
}

// Personalizedtxt2imgQueryModelTrainJobListResponse is the response struct for api Personalizedtxt2imgQueryModelTrainJobList
type Personalizedtxt2imgQueryModelTrainJobListResponse struct {
	*responses.BaseResponse
	RequestId      string     `json:"requestId" xml:"requestId"`
	Success        bool       `json:"success" xml:"success"`
	ErrCode        string     `json:"errCode" xml:"errCode"`
	ErrMessage     string     `json:"errMessage" xml:"errMessage"`
	HttpStatusCode int        `json:"httpStatusCode" xml:"httpStatusCode"`
	Data           []DataItem `json:"data" xml:"data"`
}

// CreatePersonalizedtxt2imgQueryModelTrainJobListRequest creates a request to invoke Personalizedtxt2imgQueryModelTrainJobList API
func CreatePersonalizedtxt2imgQueryModelTrainJobListRequest() (request *Personalizedtxt2imgQueryModelTrainJobListRequest) {
	request = &Personalizedtxt2imgQueryModelTrainJobListRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("AiContent", "20240611", "Personalizedtxt2imgQueryModelTrainJobList", "/api/v1/personalizedtxt2img/queryModelTrainJobList", "", "")
	request.Method = requests.GET
	return
}

// CreatePersonalizedtxt2imgQueryModelTrainJobListResponse creates a response to parse from Personalizedtxt2imgQueryModelTrainJobList response
func CreatePersonalizedtxt2imgQueryModelTrainJobListResponse() (response *Personalizedtxt2imgQueryModelTrainJobListResponse) {
	response = &Personalizedtxt2imgQueryModelTrainJobListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
