package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyHotParamRule invokes the ahas_openapi.ModifyHotParamRule API synchronously
func (client *Client) ModifyHotParamRule(request *ModifyHotParamRuleRequest) (response *ModifyHotParamRuleResponse, err error) {
	response = CreateModifyHotParamRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyHotParamRuleWithChan invokes the ahas_openapi.ModifyHotParamRule API asynchronously
func (client *Client) ModifyHotParamRuleWithChan(request *ModifyHotParamRuleRequest) (<-chan *ModifyHotParamRuleResponse, <-chan error) {
	responseChan := make(chan *ModifyHotParamRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyHotParamRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyHotParamRuleWithCallback invokes the ahas_openapi.ModifyHotParamRule API asynchronously
func (client *Client) ModifyHotParamRuleWithCallback(request *ModifyHotParamRuleRequest, callback func(response *ModifyHotParamRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyHotParamRuleResponse
		var err error
		defer close(result)
		response, err = client.ModifyHotParamRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyHotParamRuleRequest is the request struct for api ModifyHotParamRule
type ModifyHotParamRuleRequest struct {
	*requests.RpcRequest
	MetricType        requests.Integer `position:"Query" name:"MetricType"`
	ParamIdx          requests.Integer `position:"Query" name:"ParamIdx"`
	ControlBehavior   requests.Integer `position:"Query" name:"ControlBehavior"`
	Threshold         requests.Float   `position:"Query" name:"Threshold"`
	AhasRegionId      string           `position:"Query" name:"AhasRegionId"`
	Enable            requests.Boolean `position:"Query" name:"Enable"`
	MaxQueueingTimeMs requests.Integer `position:"Query" name:"MaxQueueingTimeMs"`
	RuleId            requests.Integer `position:"Query" name:"RuleId"`
	StatDurationSec   requests.Integer `position:"Query" name:"StatDurationSec"`
	BurstCount        requests.Integer `position:"Query" name:"BurstCount"`
}

// ModifyHotParamRuleResponse is the response struct for api ModifyHotParamRule
type ModifyHotParamRuleResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateModifyHotParamRuleRequest creates a request to invoke ModifyHotParamRule API
func CreateModifyHotParamRuleRequest() (request *ModifyHotParamRuleRequest) {
	request = &ModifyHotParamRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "ModifyHotParamRule", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyHotParamRuleResponse creates a response to parse from ModifyHotParamRule response
func CreateModifyHotParamRuleResponse() (response *ModifyHotParamRuleResponse) {
	response = &ModifyHotParamRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
