package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateElasticPlan invokes the adb.CreateElasticPlan API synchronously
func (client *Client) CreateElasticPlan(request *CreateElasticPlanRequest) (response *CreateElasticPlanResponse, err error) {
	response = CreateCreateElasticPlanResponse()
	err = client.DoAction(request, response)
	return
}

// CreateElasticPlanWithChan invokes the adb.CreateElasticPlan API asynchronously
func (client *Client) CreateElasticPlanWithChan(request *CreateElasticPlanRequest) (<-chan *CreateElasticPlanResponse, <-chan error) {
	responseChan := make(chan *CreateElasticPlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateElasticPlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateElasticPlanWithCallback invokes the adb.CreateElasticPlan API asynchronously
func (client *Client) CreateElasticPlanWithCallback(request *CreateElasticPlanRequest, callback func(response *CreateElasticPlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateElasticPlanResponse
		var err error
		defer close(result)
		response, err = client.CreateElasticPlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateElasticPlanRequest is the request struct for api CreateElasticPlan
type CreateElasticPlanRequest struct {
	*requests.RpcRequest
	ResourceOwnerId         requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ElasticPlanType         string           `position:"Query" name:"ElasticPlanType"`
	ElasticPlanTimeStart    string           `position:"Query" name:"ElasticPlanTimeStart"`
	ElasticPlanEndDay       string           `position:"Query" name:"ElasticPlanEndDay"`
	ElasticPlanWeeklyRepeat string           `position:"Query" name:"ElasticPlanWeeklyRepeat"`
	ElasticPlanWorkerSpec   string           `position:"Query" name:"ElasticPlanWorkerSpec"`
	ElasticPlanEnable       requests.Boolean `position:"Query" name:"ElasticPlanEnable"`
	ElasticPlanTimeEnd      string           `position:"Query" name:"ElasticPlanTimeEnd"`
	ElasticPlanStartDay     string           `position:"Query" name:"ElasticPlanStartDay"`
	ResourceOwnerAccount    string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId             string           `position:"Query" name:"DBClusterId"`
	OwnerAccount            string           `position:"Query" name:"OwnerAccount"`
	OwnerId                 requests.Integer `position:"Query" name:"OwnerId"`
	ElasticPlanName         string           `position:"Query" name:"ElasticPlanName"`
	ResourcePoolName        string           `position:"Query" name:"ResourcePoolName"`
	ElasticPlanNodeNum      requests.Integer `position:"Query" name:"ElasticPlanNodeNum"`
}

// CreateElasticPlanResponse is the response struct for api CreateElasticPlan
type CreateElasticPlanResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateElasticPlanRequest creates a request to invoke CreateElasticPlan API
func CreateCreateElasticPlanRequest() (request *CreateElasticPlanRequest) {
	request = &CreateElasticPlanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "CreateElasticPlan", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateElasticPlanResponse creates a response to parse from CreateElasticPlan response
func CreateCreateElasticPlanResponse() (response *CreateElasticPlanResponse) {
	response = &CreateElasticPlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
