// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/speech/v1p1beta1/cloud_speech.proto

package speechpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The encoding of the audio data sent in the request.
//
// All encodings support only 1 channel (mono) audio, unless the
// `audio_channel_count` and `enable_separate_recognition_per_channel` fields
// are set.
//
// For best results, the audio source should be captured and transmitted using
// a lossless encoding (`FLAC` or `LINEAR16`). The accuracy of the speech
// recognition can be reduced if lossy codecs are used to capture or transmit
// audio, particularly if background noise is present. Lossy codecs include
// `MULAW`, `AMR`, `AMR_WB`, `OGG_OPUS`, `SPEEX_WITH_HEADER_BYTE`, `MP3`,
// and `WEBM_OPUS`.
//
// The `FLAC` and `WAV` audio file formats include a header that describes the
// included audio content. You can request recognition for `WAV` files that
// contain either `LINEAR16` or `MULAW` encoded audio.
// If you send `FLAC` or `WAV` audio file format in
// your request, you do not need to specify an `AudioEncoding`; the audio
// encoding format is determined from the file header. If you specify
// an `AudioEncoding` when you send  send `FLAC` or `WAV` audio, the
// encoding configuration must match the encoding described in the audio
// header; otherwise the request returns an
// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error
// code.
type RecognitionConfig_AudioEncoding int32

const (
	// Not specified.
	RecognitionConfig_ENCODING_UNSPECIFIED RecognitionConfig_AudioEncoding = 0
	// Uncompressed 16-bit signed little-endian samples (Linear PCM).
	RecognitionConfig_LINEAR16 RecognitionConfig_AudioEncoding = 1
	// `FLAC` (Free Lossless Audio
	// Codec) is the recommended encoding because it is
	// lossless--therefore recognition is not compromised--and
	// requires only about half the bandwidth of `LINEAR16`. `FLAC` stream
	// encoding supports 16-bit and 24-bit samples, however, not all fields in
	// `STREAMINFO` are supported.
	RecognitionConfig_FLAC RecognitionConfig_AudioEncoding = 2
	// 8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
	RecognitionConfig_MULAW RecognitionConfig_AudioEncoding = 3
	// Adaptive Multi-Rate Narrowband codec. `sample_rate_hertz` must be 8000.
	RecognitionConfig_AMR RecognitionConfig_AudioEncoding = 4
	// Adaptive Multi-Rate Wideband codec. `sample_rate_hertz` must be 16000.
	RecognitionConfig_AMR_WB RecognitionConfig_AudioEncoding = 5
	// Opus encoded audio frames in Ogg container
	// ([OggOpus](https://wiki.xiph.org/OggOpus)).
	// `sample_rate_hertz` must be one of 8000, 12000, 16000, 24000, or 48000.
	RecognitionConfig_OGG_OPUS RecognitionConfig_AudioEncoding = 6
	// Although the use of lossy encodings is not recommended, if a very low
	// bitrate encoding is required, `OGG_OPUS` is highly preferred over
	// Speex encoding. The [Speex](https://speex.org/)  encoding supported by
	// Cloud Speech API has a header byte in each block, as in MIME type
	// `audio/x-speex-with-header-byte`.
	// It is a variant of the RTP Speex encoding defined in
	// [RFC 5574](https://tools.ietf.org/html/rfc5574).
	// The stream is a sequence of blocks, one block per RTP packet. Each block
	// starts with a byte containing the length of the block, in bytes, followed
	// by one or more frames of Speex data, padded to an integral number of
	// bytes (octets) as specified in RFC 5574. In other words, each RTP header
	// is replaced with a single byte containing the block length. Only Speex
	// wideband is supported. `sample_rate_hertz` must be 16000.
	RecognitionConfig_SPEEX_WITH_HEADER_BYTE RecognitionConfig_AudioEncoding = 7
	// MP3 audio. MP3 encoding is a Beta feature and only available in
	// v1p1beta1. Support all standard MP3 bitrates (which range from 32-320
	// kbps). When using this encoding, `sample_rate_hertz` has to match the
	// sample rate of the file being used.
	RecognitionConfig_MP3 RecognitionConfig_AudioEncoding = 8
	// Opus encoded audio frames in WebM container
	// ([WebM](https://www.webmproject.org/docs/container/)).
	// `sample_rate_hertz` must be one of 8000, 12000, 16000, 24000, or 48000.
	RecognitionConfig_WEBM_OPUS RecognitionConfig_AudioEncoding = 9
	// 8-bit samples that compand 13-bit audio samples using G.711 PCMU/a-law.
	RecognitionConfig_ALAW RecognitionConfig_AudioEncoding = 10
)

// Enum value maps for RecognitionConfig_AudioEncoding.
var (
	RecognitionConfig_AudioEncoding_name = map[int32]string{
		0:  "ENCODING_UNSPECIFIED",
		1:  "LINEAR16",
		2:  "FLAC",
		3:  "MULAW",
		4:  "AMR",
		5:  "AMR_WB",
		6:  "OGG_OPUS",
		7:  "SPEEX_WITH_HEADER_BYTE",
		8:  "MP3",
		9:  "WEBM_OPUS",
		10: "ALAW",
	}
	RecognitionConfig_AudioEncoding_value = map[string]int32{
		"ENCODING_UNSPECIFIED":   0,
		"LINEAR16":               1,
		"FLAC":                   2,
		"MULAW":                  3,
		"AMR":                    4,
		"AMR_WB":                 5,
		"OGG_OPUS":               6,
		"SPEEX_WITH_HEADER_BYTE": 7,
		"MP3":                    8,
		"WEBM_OPUS":              9,
		"ALAW":                   10,
	}
)

func (x RecognitionConfig_AudioEncoding) Enum() *RecognitionConfig_AudioEncoding {
	p := new(RecognitionConfig_AudioEncoding)
	*p = x
	return p
}

func (x RecognitionConfig_AudioEncoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RecognitionConfig_AudioEncoding) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_enumTypes[0].Descriptor()
}

func (RecognitionConfig_AudioEncoding) Type() protoreflect.EnumType {
	return &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_enumTypes[0]
}

func (x RecognitionConfig_AudioEncoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RecognitionConfig_AudioEncoding.Descriptor instead.
func (RecognitionConfig_AudioEncoding) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{5, 0}
}

// Use case categories that the audio recognition request can be described
// by.
type RecognitionMetadata_InteractionType int32

const (
	// Use case is either unknown or is something other than one of the other
	// values below.
	RecognitionMetadata_INTERACTION_TYPE_UNSPECIFIED RecognitionMetadata_InteractionType = 0
	// Multiple people in a conversation or discussion. For example in a
	// meeting with two or more people actively participating. Typically
	// all the primary people speaking would be in the same room (if not,
	// see PHONE_CALL)
	RecognitionMetadata_DISCUSSION RecognitionMetadata_InteractionType = 1
	// One or more persons lecturing or presenting to others, mostly
	// uninterrupted.
	RecognitionMetadata_PRESENTATION RecognitionMetadata_InteractionType = 2
	// A phone-call or video-conference in which two or more people, who are
	// not in the same room, are actively participating.
	RecognitionMetadata_PHONE_CALL RecognitionMetadata_InteractionType = 3
	// A recorded message intended for another person to listen to.
	RecognitionMetadata_VOICEMAIL RecognitionMetadata_InteractionType = 4
	// Professionally produced audio (eg. TV Show, Podcast).
	RecognitionMetadata_PROFESSIONALLY_PRODUCED RecognitionMetadata_InteractionType = 5
	// Transcribe spoken questions and queries into text.
	RecognitionMetadata_VOICE_SEARCH RecognitionMetadata_InteractionType = 6
	// Transcribe voice commands, such as for controlling a device.
	RecognitionMetadata_VOICE_COMMAND RecognitionMetadata_InteractionType = 7
	// Transcribe speech to text to create a written document, such as a
	// text-message, email or report.
	RecognitionMetadata_DICTATION RecognitionMetadata_InteractionType = 8
)

// Enum value maps for RecognitionMetadata_InteractionType.
var (
	RecognitionMetadata_InteractionType_name = map[int32]string{
		0: "INTERACTION_TYPE_UNSPECIFIED",
		1: "DISCUSSION",
		2: "PRESENTATION",
		3: "PHONE_CALL",
		4: "VOICEMAIL",
		5: "PROFESSIONALLY_PRODUCED",
		6: "VOICE_SEARCH",
		7: "VOICE_COMMAND",
		8: "DICTATION",
	}
	RecognitionMetadata_InteractionType_value = map[string]int32{
		"INTERACTION_TYPE_UNSPECIFIED": 0,
		"DISCUSSION":                   1,
		"PRESENTATION":                 2,
		"PHONE_CALL":                   3,
		"VOICEMAIL":                    4,
		"PROFESSIONALLY_PRODUCED":      5,
		"VOICE_SEARCH":                 6,
		"VOICE_COMMAND":                7,
		"DICTATION":                    8,
	}
)

func (x RecognitionMetadata_InteractionType) Enum() *RecognitionMetadata_InteractionType {
	p := new(RecognitionMetadata_InteractionType)
	*p = x
	return p
}

func (x RecognitionMetadata_InteractionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RecognitionMetadata_InteractionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_enumTypes[1].Descriptor()
}

func (RecognitionMetadata_InteractionType) Type() protoreflect.EnumType {
	return &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_enumTypes[1]
}

func (x RecognitionMetadata_InteractionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RecognitionMetadata_InteractionType.Descriptor instead.
func (RecognitionMetadata_InteractionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{7, 0}
}

// Enumerates the types of capture settings describing an audio file.
type RecognitionMetadata_MicrophoneDistance int32

const (
	// Audio type is not known.
	RecognitionMetadata_MICROPHONE_DISTANCE_UNSPECIFIED RecognitionMetadata_MicrophoneDistance = 0
	// The audio was captured from a closely placed microphone. Eg. phone,
	// dictaphone, or handheld microphone. Generally if there speaker is within
	// 1 meter of the microphone.
	RecognitionMetadata_NEARFIELD RecognitionMetadata_MicrophoneDistance = 1
	// The speaker if within 3 meters of the microphone.
	RecognitionMetadata_MIDFIELD RecognitionMetadata_MicrophoneDistance = 2
	// The speaker is more than 3 meters away from the microphone.
	RecognitionMetadata_FARFIELD RecognitionMetadata_MicrophoneDistance = 3
)

// Enum value maps for RecognitionMetadata_MicrophoneDistance.
var (
	RecognitionMetadata_MicrophoneDistance_name = map[int32]string{
		0: "MICROPHONE_DISTANCE_UNSPECIFIED",
		1: "NEARFIELD",
		2: "MIDFIELD",
		3: "FARFIELD",
	}
	RecognitionMetadata_MicrophoneDistance_value = map[string]int32{
		"MICROPHONE_DISTANCE_UNSPECIFIED": 0,
		"NEARFIELD":                       1,
		"MIDFIELD":                        2,
		"FARFIELD":                        3,
	}
)

func (x RecognitionMetadata_MicrophoneDistance) Enum() *RecognitionMetadata_MicrophoneDistance {
	p := new(RecognitionMetadata_MicrophoneDistance)
	*p = x
	return p
}

func (x RecognitionMetadata_MicrophoneDistance) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RecognitionMetadata_MicrophoneDistance) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_enumTypes[2].Descriptor()
}

func (RecognitionMetadata_MicrophoneDistance) Type() protoreflect.EnumType {
	return &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_enumTypes[2]
}

func (x RecognitionMetadata_MicrophoneDistance) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RecognitionMetadata_MicrophoneDistance.Descriptor instead.
func (RecognitionMetadata_MicrophoneDistance) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{7, 1}
}

// The original media the speech was recorded on.
type RecognitionMetadata_OriginalMediaType int32

const (
	// Unknown original media type.
	RecognitionMetadata_ORIGINAL_MEDIA_TYPE_UNSPECIFIED RecognitionMetadata_OriginalMediaType = 0
	// The speech data is an audio recording.
	RecognitionMetadata_AUDIO RecognitionMetadata_OriginalMediaType = 1
	// The speech data originally recorded on a video.
	RecognitionMetadata_VIDEO RecognitionMetadata_OriginalMediaType = 2
)

// Enum value maps for RecognitionMetadata_OriginalMediaType.
var (
	RecognitionMetadata_OriginalMediaType_name = map[int32]string{
		0: "ORIGINAL_MEDIA_TYPE_UNSPECIFIED",
		1: "AUDIO",
		2: "VIDEO",
	}
	RecognitionMetadata_OriginalMediaType_value = map[string]int32{
		"ORIGINAL_MEDIA_TYPE_UNSPECIFIED": 0,
		"AUDIO":                           1,
		"VIDEO":                           2,
	}
)

func (x RecognitionMetadata_OriginalMediaType) Enum() *RecognitionMetadata_OriginalMediaType {
	p := new(RecognitionMetadata_OriginalMediaType)
	*p = x
	return p
}

func (x RecognitionMetadata_OriginalMediaType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RecognitionMetadata_OriginalMediaType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_enumTypes[3].Descriptor()
}

func (RecognitionMetadata_OriginalMediaType) Type() protoreflect.EnumType {
	return &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_enumTypes[3]
}

func (x RecognitionMetadata_OriginalMediaType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RecognitionMetadata_OriginalMediaType.Descriptor instead.
func (RecognitionMetadata_OriginalMediaType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{7, 2}
}

// The type of device the speech was recorded with.
type RecognitionMetadata_RecordingDeviceType int32

const (
	// The recording device is unknown.
	RecognitionMetadata_RECORDING_DEVICE_TYPE_UNSPECIFIED RecognitionMetadata_RecordingDeviceType = 0
	// Speech was recorded on a smartphone.
	RecognitionMetadata_SMARTPHONE RecognitionMetadata_RecordingDeviceType = 1
	// Speech was recorded using a personal computer or tablet.
	RecognitionMetadata_PC RecognitionMetadata_RecordingDeviceType = 2
	// Speech was recorded over a phone line.
	RecognitionMetadata_PHONE_LINE RecognitionMetadata_RecordingDeviceType = 3
	// Speech was recorded in a vehicle.
	RecognitionMetadata_VEHICLE RecognitionMetadata_RecordingDeviceType = 4
	// Speech was recorded outdoors.
	RecognitionMetadata_OTHER_OUTDOOR_DEVICE RecognitionMetadata_RecordingDeviceType = 5
	// Speech was recorded indoors.
	RecognitionMetadata_OTHER_INDOOR_DEVICE RecognitionMetadata_RecordingDeviceType = 6
)

// Enum value maps for RecognitionMetadata_RecordingDeviceType.
var (
	RecognitionMetadata_RecordingDeviceType_name = map[int32]string{
		0: "RECORDING_DEVICE_TYPE_UNSPECIFIED",
		1: "SMARTPHONE",
		2: "PC",
		3: "PHONE_LINE",
		4: "VEHICLE",
		5: "OTHER_OUTDOOR_DEVICE",
		6: "OTHER_INDOOR_DEVICE",
	}
	RecognitionMetadata_RecordingDeviceType_value = map[string]int32{
		"RECORDING_DEVICE_TYPE_UNSPECIFIED": 0,
		"SMARTPHONE":                        1,
		"PC":                                2,
		"PHONE_LINE":                        3,
		"VEHICLE":                           4,
		"OTHER_OUTDOOR_DEVICE":              5,
		"OTHER_INDOOR_DEVICE":               6,
	}
)

func (x RecognitionMetadata_RecordingDeviceType) Enum() *RecognitionMetadata_RecordingDeviceType {
	p := new(RecognitionMetadata_RecordingDeviceType)
	*p = x
	return p
}

func (x RecognitionMetadata_RecordingDeviceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RecognitionMetadata_RecordingDeviceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_enumTypes[4].Descriptor()
}

func (RecognitionMetadata_RecordingDeviceType) Type() protoreflect.EnumType {
	return &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_enumTypes[4]
}

func (x RecognitionMetadata_RecordingDeviceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RecognitionMetadata_RecordingDeviceType.Descriptor instead.
func (RecognitionMetadata_RecordingDeviceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{7, 3}
}

// Indicates the type of speech event.
type StreamingRecognizeResponse_SpeechEventType int32

const (
	// No speech event specified.
	StreamingRecognizeResponse_SPEECH_EVENT_UNSPECIFIED StreamingRecognizeResponse_SpeechEventType = 0
	// This event indicates that the server has detected the end of the user's
	// speech utterance and expects no additional speech. Therefore, the server
	// will not process additional audio (although it may subsequently return
	// additional results). The client should stop sending additional audio
	// data, half-close the gRPC connection, and wait for any additional results
	// until the server closes the gRPC connection. This event is only sent if
	// `single_utterance` was set to `true`, and is not used otherwise.
	StreamingRecognizeResponse_END_OF_SINGLE_UTTERANCE StreamingRecognizeResponse_SpeechEventType = 1
	// This event indicates that the server has detected the beginning of human
	// voice activity in the stream. This event can be returned multiple times
	// if speech starts and stops repeatedly throughout the stream. This event
	// is only sent if `voice_activity_events` is set to true.
	StreamingRecognizeResponse_SPEECH_ACTIVITY_BEGIN StreamingRecognizeResponse_SpeechEventType = 2
	// This event indicates that the server has detected the end of human voice
	// activity in the stream. This event can be returned multiple times if
	// speech starts and stops repeatedly throughout the stream. This event is
	// only sent if `voice_activity_events` is set to true.
	StreamingRecognizeResponse_SPEECH_ACTIVITY_END StreamingRecognizeResponse_SpeechEventType = 3
	// This event indicates that the user-set timeout for speech activity begin
	// or end has exceeded. Upon receiving this event, the client is expected to
	// send a half close. Further audio will not be processed.
	StreamingRecognizeResponse_SPEECH_ACTIVITY_TIMEOUT StreamingRecognizeResponse_SpeechEventType = 4
)

// Enum value maps for StreamingRecognizeResponse_SpeechEventType.
var (
	StreamingRecognizeResponse_SpeechEventType_name = map[int32]string{
		0: "SPEECH_EVENT_UNSPECIFIED",
		1: "END_OF_SINGLE_UTTERANCE",
		2: "SPEECH_ACTIVITY_BEGIN",
		3: "SPEECH_ACTIVITY_END",
		4: "SPEECH_ACTIVITY_TIMEOUT",
	}
	StreamingRecognizeResponse_SpeechEventType_value = map[string]int32{
		"SPEECH_EVENT_UNSPECIFIED": 0,
		"END_OF_SINGLE_UTTERANCE":  1,
		"SPEECH_ACTIVITY_BEGIN":    2,
		"SPEECH_ACTIVITY_END":      3,
		"SPEECH_ACTIVITY_TIMEOUT":  4,
	}
)

func (x StreamingRecognizeResponse_SpeechEventType) Enum() *StreamingRecognizeResponse_SpeechEventType {
	p := new(StreamingRecognizeResponse_SpeechEventType)
	*p = x
	return p
}

func (x StreamingRecognizeResponse_SpeechEventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StreamingRecognizeResponse_SpeechEventType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_enumTypes[5].Descriptor()
}

func (StreamingRecognizeResponse_SpeechEventType) Type() protoreflect.EnumType {
	return &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_enumTypes[5]
}

func (x StreamingRecognizeResponse_SpeechEventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StreamingRecognizeResponse_SpeechEventType.Descriptor instead.
func (StreamingRecognizeResponse_SpeechEventType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{13, 0}
}

// The top-level message sent by the client for the `Recognize` method.
type RecognizeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Provides information to the recognizer that specifies how to
	// process the request.
	Config *RecognitionConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Required. The audio data to be recognized.
	Audio *RecognitionAudio `protobuf:"bytes,2,opt,name=audio,proto3" json:"audio,omitempty"`
}

func (x *RecognizeRequest) Reset() {
	*x = RecognizeRequest{}
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RecognizeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecognizeRequest) ProtoMessage() {}

func (x *RecognizeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecognizeRequest.ProtoReflect.Descriptor instead.
func (*RecognizeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{0}
}

func (x *RecognizeRequest) GetConfig() *RecognitionConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *RecognizeRequest) GetAudio() *RecognitionAudio {
	if x != nil {
		return x.Audio
	}
	return nil
}

// The top-level message sent by the client for the `LongRunningRecognize`
// method.
type LongRunningRecognizeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Provides information to the recognizer that specifies how to
	// process the request.
	Config *RecognitionConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Required. The audio data to be recognized.
	Audio *RecognitionAudio `protobuf:"bytes,2,opt,name=audio,proto3" json:"audio,omitempty"`
	// Optional. Specifies an optional destination for the recognition results.
	OutputConfig *TranscriptOutputConfig `protobuf:"bytes,4,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
}

func (x *LongRunningRecognizeRequest) Reset() {
	*x = LongRunningRecognizeRequest{}
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LongRunningRecognizeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LongRunningRecognizeRequest) ProtoMessage() {}

func (x *LongRunningRecognizeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LongRunningRecognizeRequest.ProtoReflect.Descriptor instead.
func (*LongRunningRecognizeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{1}
}

func (x *LongRunningRecognizeRequest) GetConfig() *RecognitionConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *LongRunningRecognizeRequest) GetAudio() *RecognitionAudio {
	if x != nil {
		return x.Audio
	}
	return nil
}

func (x *LongRunningRecognizeRequest) GetOutputConfig() *TranscriptOutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

// Specifies an optional destination for the recognition results.
type TranscriptOutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to OutputType:
	//
	//	*TranscriptOutputConfig_GcsUri
	OutputType isTranscriptOutputConfig_OutputType `protobuf_oneof:"output_type"`
}

func (x *TranscriptOutputConfig) Reset() {
	*x = TranscriptOutputConfig{}
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TranscriptOutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TranscriptOutputConfig) ProtoMessage() {}

func (x *TranscriptOutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TranscriptOutputConfig.ProtoReflect.Descriptor instead.
func (*TranscriptOutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{2}
}

func (m *TranscriptOutputConfig) GetOutputType() isTranscriptOutputConfig_OutputType {
	if m != nil {
		return m.OutputType
	}
	return nil
}

func (x *TranscriptOutputConfig) GetGcsUri() string {
	if x, ok := x.GetOutputType().(*TranscriptOutputConfig_GcsUri); ok {
		return x.GcsUri
	}
	return ""
}

type isTranscriptOutputConfig_OutputType interface {
	isTranscriptOutputConfig_OutputType()
}

type TranscriptOutputConfig_GcsUri struct {
	// Specifies a Cloud Storage URI for the recognition results. Must be
	// specified in the format: `gs://bucket_name/object_name`, and the bucket
	// must already exist.
	GcsUri string `protobuf:"bytes,1,opt,name=gcs_uri,json=gcsUri,proto3,oneof"`
}

func (*TranscriptOutputConfig_GcsUri) isTranscriptOutputConfig_OutputType() {}

// The top-level message sent by the client for the `StreamingRecognize` method.
// Multiple `StreamingRecognizeRequest` messages are sent. The first message
// must contain a `streaming_config` message and must not contain
// `audio_content`. All subsequent messages must contain `audio_content` and
// must not contain a `streaming_config` message.
type StreamingRecognizeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The streaming request, which is either a streaming config or audio content.
	//
	// Types that are assignable to StreamingRequest:
	//
	//	*StreamingRecognizeRequest_StreamingConfig
	//	*StreamingRecognizeRequest_AudioContent
	StreamingRequest isStreamingRecognizeRequest_StreamingRequest `protobuf_oneof:"streaming_request"`
}

func (x *StreamingRecognizeRequest) Reset() {
	*x = StreamingRecognizeRequest{}
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingRecognizeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingRecognizeRequest) ProtoMessage() {}

func (x *StreamingRecognizeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingRecognizeRequest.ProtoReflect.Descriptor instead.
func (*StreamingRecognizeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{3}
}

func (m *StreamingRecognizeRequest) GetStreamingRequest() isStreamingRecognizeRequest_StreamingRequest {
	if m != nil {
		return m.StreamingRequest
	}
	return nil
}

func (x *StreamingRecognizeRequest) GetStreamingConfig() *StreamingRecognitionConfig {
	if x, ok := x.GetStreamingRequest().(*StreamingRecognizeRequest_StreamingConfig); ok {
		return x.StreamingConfig
	}
	return nil
}

func (x *StreamingRecognizeRequest) GetAudioContent() []byte {
	if x, ok := x.GetStreamingRequest().(*StreamingRecognizeRequest_AudioContent); ok {
		return x.AudioContent
	}
	return nil
}

type isStreamingRecognizeRequest_StreamingRequest interface {
	isStreamingRecognizeRequest_StreamingRequest()
}

type StreamingRecognizeRequest_StreamingConfig struct {
	// Provides information to the recognizer that specifies how to process the
	// request. The first `StreamingRecognizeRequest` message must contain a
	// `streaming_config`  message.
	StreamingConfig *StreamingRecognitionConfig `protobuf:"bytes,1,opt,name=streaming_config,json=streamingConfig,proto3,oneof"`
}

type StreamingRecognizeRequest_AudioContent struct {
	// The audio data to be recognized. Sequential chunks of audio data are sent
	// in sequential `StreamingRecognizeRequest` messages. The first
	// `StreamingRecognizeRequest` message must not contain `audio_content` data
	// and all subsequent `StreamingRecognizeRequest` messages must contain
	// `audio_content` data. The audio bytes must be encoded as specified in
	// `RecognitionConfig`. Note: as with all bytes fields, proto buffers use a
	// pure binary representation (not base64). See
	// [content limits](https://cloud.google.com/speech-to-text/quotas#content).
	AudioContent []byte `protobuf:"bytes,2,opt,name=audio_content,json=audioContent,proto3,oneof"`
}

func (*StreamingRecognizeRequest_StreamingConfig) isStreamingRecognizeRequest_StreamingRequest() {}

func (*StreamingRecognizeRequest_AudioContent) isStreamingRecognizeRequest_StreamingRequest() {}

// Provides information to the recognizer that specifies how to process the
// request.
type StreamingRecognitionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Provides information to the recognizer that specifies how to
	// process the request.
	Config *RecognitionConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// If `false` or omitted, the recognizer will perform continuous
	// recognition (continuing to wait for and process audio even if the user
	// pauses speaking) until the client closes the input stream (gRPC API) or
	// until the maximum time limit has been reached. May return multiple
	// `StreamingRecognitionResult`s with the `is_final` flag set to `true`.
	//
	// If `true`, the recognizer will detect a single spoken utterance. When it
	// detects that the user has paused or stopped speaking, it will return an
	// `END_OF_SINGLE_UTTERANCE` event and cease recognition. It will return no
	// more than one `StreamingRecognitionResult` with the `is_final` flag set to
	// `true`.
	//
	// The `single_utterance` field can only be used with specified models,
	// otherwise an error is thrown. The `model` field in
	// [RecognitionConfig][google.cloud.speech.v1p1beta1.RecognitionConfig] must
	// be set to:
	//
	//   - `command_and_search`
	//   - `phone_call` AND additional field `useEnhanced`=`true`
	//   - The `model` field is left undefined. In this case the API auto-selects
	//     a model based on any other parameters that you set in
	//     `RecognitionConfig`.
	SingleUtterance bool `protobuf:"varint,2,opt,name=single_utterance,json=singleUtterance,proto3" json:"single_utterance,omitempty"`
	// If `true`, interim results (tentative hypotheses) may be
	// returned as they become available (these interim results are indicated with
	// the `is_final=false` flag).
	// If `false` or omitted, only `is_final=true` result(s) are returned.
	InterimResults bool `protobuf:"varint,3,opt,name=interim_results,json=interimResults,proto3" json:"interim_results,omitempty"`
	// If `true`, responses with voice activity speech events will be returned as
	// they are detected.
	EnableVoiceActivityEvents bool `protobuf:"varint,5,opt,name=enable_voice_activity_events,json=enableVoiceActivityEvents,proto3" json:"enable_voice_activity_events,omitempty"`
	// If set, the server will automatically close the stream after the specified
	// duration has elapsed after the last VOICE_ACTIVITY speech event has been
	// sent. The field `voice_activity_events` must also be set to true.
	VoiceActivityTimeout *StreamingRecognitionConfig_VoiceActivityTimeout `protobuf:"bytes,6,opt,name=voice_activity_timeout,json=voiceActivityTimeout,proto3" json:"voice_activity_timeout,omitempty"`
}

func (x *StreamingRecognitionConfig) Reset() {
	*x = StreamingRecognitionConfig{}
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingRecognitionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingRecognitionConfig) ProtoMessage() {}

func (x *StreamingRecognitionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingRecognitionConfig.ProtoReflect.Descriptor instead.
func (*StreamingRecognitionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{4}
}

func (x *StreamingRecognitionConfig) GetConfig() *RecognitionConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *StreamingRecognitionConfig) GetSingleUtterance() bool {
	if x != nil {
		return x.SingleUtterance
	}
	return false
}

func (x *StreamingRecognitionConfig) GetInterimResults() bool {
	if x != nil {
		return x.InterimResults
	}
	return false
}

func (x *StreamingRecognitionConfig) GetEnableVoiceActivityEvents() bool {
	if x != nil {
		return x.EnableVoiceActivityEvents
	}
	return false
}

func (x *StreamingRecognitionConfig) GetVoiceActivityTimeout() *StreamingRecognitionConfig_VoiceActivityTimeout {
	if x != nil {
		return x.VoiceActivityTimeout
	}
	return nil
}

// Provides information to the recognizer that specifies how to process the
// request.
type RecognitionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Encoding of audio data sent in all `RecognitionAudio` messages.
	// This field is optional for `FLAC` and `WAV` audio files and required
	// for all other audio formats. For details, see
	// [AudioEncoding][google.cloud.speech.v1p1beta1.RecognitionConfig.AudioEncoding].
	Encoding RecognitionConfig_AudioEncoding `protobuf:"varint,1,opt,name=encoding,proto3,enum=google.cloud.speech.v1p1beta1.RecognitionConfig_AudioEncoding" json:"encoding,omitempty"`
	// Sample rate in Hertz of the audio data sent in all
	// `RecognitionAudio` messages. Valid values are: 8000-48000.
	// 16000 is optimal. For best results, set the sampling rate of the audio
	// source to 16000 Hz. If that's not possible, use the native sample rate of
	// the audio source (instead of re-sampling).
	// This field is optional for FLAC and WAV audio files, but is
	// required for all other audio formats. For details, see
	// [AudioEncoding][google.cloud.speech.v1p1beta1.RecognitionConfig.AudioEncoding].
	SampleRateHertz int32 `protobuf:"varint,2,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
	// The number of channels in the input audio data.
	// ONLY set this for MULTI-CHANNEL recognition.
	// Valid values for LINEAR16, OGG_OPUS and FLAC are `1`-`8`.
	// Valid value for MULAW, AMR, AMR_WB and SPEEX_WITH_HEADER_BYTE is only `1`.
	// If `0` or omitted, defaults to one channel (mono).
	// Note: We only recognize the first channel by default.
	// To perform independent recognition on each channel set
	// `enable_separate_recognition_per_channel` to 'true'.
	AudioChannelCount int32 `protobuf:"varint,7,opt,name=audio_channel_count,json=audioChannelCount,proto3" json:"audio_channel_count,omitempty"`
	// This needs to be set to `true` explicitly and `audio_channel_count` > 1
	// to get each channel recognized separately. The recognition result will
	// contain a `channel_tag` field to state which channel that result belongs
	// to. If this is not true, we will only recognize the first channel. The
	// request is billed cumulatively for all channels recognized:
	// `audio_channel_count` multiplied by the length of the audio.
	EnableSeparateRecognitionPerChannel bool `protobuf:"varint,12,opt,name=enable_separate_recognition_per_channel,json=enableSeparateRecognitionPerChannel,proto3" json:"enable_separate_recognition_per_channel,omitempty"`
	// Required. The language of the supplied audio as a
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
	// Example: "en-US".
	// See [Language
	// Support](https://cloud.google.com/speech-to-text/docs/languages) for a list
	// of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// A list of up to 3 additional
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tags,
	// listing possible alternative languages of the supplied audio.
	// See [Language
	// Support](https://cloud.google.com/speech-to-text/docs/languages) for a list
	// of the currently supported language codes. If alternative languages are
	// listed, recognition result will contain recognition in the most likely
	// language detected including the main language_code. The recognition result
	// will include the language tag of the language detected in the audio. Note:
	// This feature is only supported for Voice Command and Voice Search use cases
	// and performance may vary for other use cases (e.g., phone call
	// transcription).
	AlternativeLanguageCodes []string `protobuf:"bytes,18,rep,name=alternative_language_codes,json=alternativeLanguageCodes,proto3" json:"alternative_language_codes,omitempty"`
	// Maximum number of recognition hypotheses to be returned.
	// Specifically, the maximum number of `SpeechRecognitionAlternative` messages
	// within each `SpeechRecognitionResult`.
	// The server may return fewer than `max_alternatives`.
	// Valid values are `0`-`30`. A value of `0` or `1` will return a maximum of
	// one. If omitted, will return a maximum of one.
	MaxAlternatives int32 `protobuf:"varint,4,opt,name=max_alternatives,json=maxAlternatives,proto3" json:"max_alternatives,omitempty"`
	// If set to `true`, the server will attempt to filter out
	// profanities, replacing all but the initial character in each filtered word
	// with asterisks, e.g. "f***". If set to `false` or omitted, profanities
	// won't be filtered out.
	ProfanityFilter bool `protobuf:"varint,5,opt,name=profanity_filter,json=profanityFilter,proto3" json:"profanity_filter,omitempty"`
	// Speech adaptation configuration improves the accuracy of speech
	// recognition. For more information, see the [speech
	// adaptation](https://cloud.google.com/speech-to-text/docs/adaptation)
	// documentation.
	// When speech adaptation is set it supersedes the `speech_contexts` field.
	Adaptation *SpeechAdaptation `protobuf:"bytes,20,opt,name=adaptation,proto3" json:"adaptation,omitempty"`
	// Optional. Use transcription normalization to automatically replace parts of
	// the transcript with phrases of your choosing. For StreamingRecognize, this
	// normalization only applies to stable partial transcripts (stability > 0.8)
	// and final transcripts.
	TranscriptNormalization *TranscriptNormalization `protobuf:"bytes,24,opt,name=transcript_normalization,json=transcriptNormalization,proto3" json:"transcript_normalization,omitempty"`
	// Array of [SpeechContext][google.cloud.speech.v1p1beta1.SpeechContext].
	// A means to provide context to assist the speech recognition. For more
	// information, see
	// [speech
	// adaptation](https://cloud.google.com/speech-to-text/docs/adaptation).
	SpeechContexts []*SpeechContext `protobuf:"bytes,6,rep,name=speech_contexts,json=speechContexts,proto3" json:"speech_contexts,omitempty"`
	// If `true`, the top result includes a list of words and
	// the start and end time offsets (timestamps) for those words. If
	// `false`, no word-level time offset information is returned. The default is
	// `false`.
	EnableWordTimeOffsets bool `protobuf:"varint,8,opt,name=enable_word_time_offsets,json=enableWordTimeOffsets,proto3" json:"enable_word_time_offsets,omitempty"`
	// If `true`, the top result includes a list of words and the
	// confidence for those words. If `false`, no word-level confidence
	// information is returned. The default is `false`.
	EnableWordConfidence bool `protobuf:"varint,15,opt,name=enable_word_confidence,json=enableWordConfidence,proto3" json:"enable_word_confidence,omitempty"`
	// If 'true', adds punctuation to recognition result hypotheses.
	// This feature is only available in select languages. Setting this for
	// requests in other languages has no effect at all.
	// The default 'false' value does not add punctuation to result hypotheses.
	EnableAutomaticPunctuation bool `protobuf:"varint,11,opt,name=enable_automatic_punctuation,json=enableAutomaticPunctuation,proto3" json:"enable_automatic_punctuation,omitempty"`
	// The spoken punctuation behavior for the call
	// If not set, uses default behavior based on model of choice
	// e.g. command_and_search will enable spoken punctuation by default
	// If 'true', replaces spoken punctuation with the corresponding symbols in
	// the request. For example, "how are you question mark" becomes "how are
	// you?". See https://cloud.google.com/speech-to-text/docs/spoken-punctuation
	// for support. If 'false', spoken punctuation is not replaced.
	EnableSpokenPunctuation *wrapperspb.BoolValue `protobuf:"bytes,22,opt,name=enable_spoken_punctuation,json=enableSpokenPunctuation,proto3" json:"enable_spoken_punctuation,omitempty"`
	// The spoken emoji behavior for the call
	// If not set, uses default behavior based on model of choice
	// If 'true', adds spoken emoji formatting for the request. This will replace
	// spoken emojis with the corresponding Unicode symbols in the final
	// transcript. If 'false', spoken emojis are not replaced.
	EnableSpokenEmojis *wrapperspb.BoolValue `protobuf:"bytes,23,opt,name=enable_spoken_emojis,json=enableSpokenEmojis,proto3" json:"enable_spoken_emojis,omitempty"`
	// If 'true', enables speaker detection for each recognized word in
	// the top alternative of the recognition result using a speaker_label
	// provided in the WordInfo.
	// Note: Use diarization_config instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/speech/v1p1beta1/cloud_speech.proto.
	EnableSpeakerDiarization bool `protobuf:"varint,16,opt,name=enable_speaker_diarization,json=enableSpeakerDiarization,proto3" json:"enable_speaker_diarization,omitempty"`
	// If set, specifies the estimated number of speakers in the conversation.
	// Defaults to '2'. Ignored unless enable_speaker_diarization is set to true.
	// Note: Use diarization_config instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/speech/v1p1beta1/cloud_speech.proto.
	DiarizationSpeakerCount int32 `protobuf:"varint,17,opt,name=diarization_speaker_count,json=diarizationSpeakerCount,proto3" json:"diarization_speaker_count,omitempty"`
	// Config to enable speaker diarization and set additional
	// parameters to make diarization better suited for your application.
	// Note: When this is enabled, we send all the words from the beginning of the
	// audio for the top alternative in every consecutive STREAMING responses.
	// This is done in order to improve our speaker tags as our models learn to
	// identify the speakers in the conversation over time.
	// For non-streaming requests, the diarization results will be provided only
	// in the top alternative of the FINAL SpeechRecognitionResult.
	DiarizationConfig *SpeakerDiarizationConfig `protobuf:"bytes,19,opt,name=diarization_config,json=diarizationConfig,proto3" json:"diarization_config,omitempty"`
	// Metadata regarding this request.
	Metadata *RecognitionMetadata `protobuf:"bytes,9,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Which model to select for the given request. Select the model
	// best suited to your domain to get best results. If a model is not
	// explicitly specified, then we auto-select a model based on the parameters
	// in the RecognitionConfig.
	// <table>
	//
	//	<tr>
	//	  <td><b>Model</b></td>
	//	  <td><b>Description</b></td>
	//	</tr>
	//	<tr>
	//	  <td><code>latest_long</code></td>
	//	  <td>Best for long form content like media or conversation.</td>
	//	</tr>
	//	<tr>
	//	  <td><code>latest_short</code></td>
	//	  <td>Best for short form content like commands or single shot directed
	//	  speech.</td>
	//	</tr>
	//	<tr>
	//	  <td><code>command_and_search</code></td>
	//	  <td>Best for short queries such as voice commands or voice search.</td>
	//	</tr>
	//	<tr>
	//	  <td><code>phone_call</code></td>
	//	  <td>Best for audio that originated from a phone call (typically
	//	  recorded at an 8khz sampling rate).</td>
	//	</tr>
	//	<tr>
	//	  <td><code>video</code></td>
	//	  <td>Best for audio that originated from video or includes multiple
	//	      speakers. Ideally the audio is recorded at a 16khz or greater
	//	      sampling rate. This is a premium model that costs more than the
	//	      standard rate.</td>
	//	</tr>
	//	<tr>
	//	  <td><code>default</code></td>
	//	  <td>Best for audio that is not one of the specific audio models.
	//	      For example, long-form audio. Ideally the audio is high-fidelity,
	//	      recorded at a 16khz or greater sampling rate.</td>
	//	</tr>
	//	<tr>
	//	  <td><code>medical_conversation</code></td>
	//	  <td>Best for audio that originated from a conversation between a
	//	      medical provider and patient.</td>
	//	</tr>
	//	<tr>
	//	  <td><code>medical_dictation</code></td>
	//	  <td>Best for audio that originated from dictation notes by a medical
	//	      provider.</td>
	//	</tr>
	//
	// </table>
	Model string `protobuf:"bytes,13,opt,name=model,proto3" json:"model,omitempty"`
	// Set to true to use an enhanced model for speech recognition.
	// If `use_enhanced` is set to true and the `model` field is not set, then
	// an appropriate enhanced model is chosen if an enhanced model exists for
	// the audio.
	//
	// If `use_enhanced` is true and an enhanced version of the specified model
	// does not exist, then the speech is recognized using the standard version
	// of the specified model.
	UseEnhanced bool `protobuf:"varint,14,opt,name=use_enhanced,json=useEnhanced,proto3" json:"use_enhanced,omitempty"`
}

func (x *RecognitionConfig) Reset() {
	*x = RecognitionConfig{}
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RecognitionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecognitionConfig) ProtoMessage() {}

func (x *RecognitionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecognitionConfig.ProtoReflect.Descriptor instead.
func (*RecognitionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{5}
}

func (x *RecognitionConfig) GetEncoding() RecognitionConfig_AudioEncoding {
	if x != nil {
		return x.Encoding
	}
	return RecognitionConfig_ENCODING_UNSPECIFIED
}

func (x *RecognitionConfig) GetSampleRateHertz() int32 {
	if x != nil {
		return x.SampleRateHertz
	}
	return 0
}

func (x *RecognitionConfig) GetAudioChannelCount() int32 {
	if x != nil {
		return x.AudioChannelCount
	}
	return 0
}

func (x *RecognitionConfig) GetEnableSeparateRecognitionPerChannel() bool {
	if x != nil {
		return x.EnableSeparateRecognitionPerChannel
	}
	return false
}

func (x *RecognitionConfig) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *RecognitionConfig) GetAlternativeLanguageCodes() []string {
	if x != nil {
		return x.AlternativeLanguageCodes
	}
	return nil
}

func (x *RecognitionConfig) GetMaxAlternatives() int32 {
	if x != nil {
		return x.MaxAlternatives
	}
	return 0
}

func (x *RecognitionConfig) GetProfanityFilter() bool {
	if x != nil {
		return x.ProfanityFilter
	}
	return false
}

func (x *RecognitionConfig) GetAdaptation() *SpeechAdaptation {
	if x != nil {
		return x.Adaptation
	}
	return nil
}

func (x *RecognitionConfig) GetTranscriptNormalization() *TranscriptNormalization {
	if x != nil {
		return x.TranscriptNormalization
	}
	return nil
}

func (x *RecognitionConfig) GetSpeechContexts() []*SpeechContext {
	if x != nil {
		return x.SpeechContexts
	}
	return nil
}

func (x *RecognitionConfig) GetEnableWordTimeOffsets() bool {
	if x != nil {
		return x.EnableWordTimeOffsets
	}
	return false
}

func (x *RecognitionConfig) GetEnableWordConfidence() bool {
	if x != nil {
		return x.EnableWordConfidence
	}
	return false
}

func (x *RecognitionConfig) GetEnableAutomaticPunctuation() bool {
	if x != nil {
		return x.EnableAutomaticPunctuation
	}
	return false
}

func (x *RecognitionConfig) GetEnableSpokenPunctuation() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnableSpokenPunctuation
	}
	return nil
}

func (x *RecognitionConfig) GetEnableSpokenEmojis() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnableSpokenEmojis
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/speech/v1p1beta1/cloud_speech.proto.
func (x *RecognitionConfig) GetEnableSpeakerDiarization() bool {
	if x != nil {
		return x.EnableSpeakerDiarization
	}
	return false
}

// Deprecated: Marked as deprecated in google/cloud/speech/v1p1beta1/cloud_speech.proto.
func (x *RecognitionConfig) GetDiarizationSpeakerCount() int32 {
	if x != nil {
		return x.DiarizationSpeakerCount
	}
	return 0
}

func (x *RecognitionConfig) GetDiarizationConfig() *SpeakerDiarizationConfig {
	if x != nil {
		return x.DiarizationConfig
	}
	return nil
}

func (x *RecognitionConfig) GetMetadata() *RecognitionMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *RecognitionConfig) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *RecognitionConfig) GetUseEnhanced() bool {
	if x != nil {
		return x.UseEnhanced
	}
	return false
}

// Config to enable speaker diarization.
type SpeakerDiarizationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If 'true', enables speaker detection for each recognized word in
	// the top alternative of the recognition result using a speaker_label
	// provided in the WordInfo.
	EnableSpeakerDiarization bool `protobuf:"varint,1,opt,name=enable_speaker_diarization,json=enableSpeakerDiarization,proto3" json:"enable_speaker_diarization,omitempty"`
	// Minimum number of speakers in the conversation. This range gives you more
	// flexibility by allowing the system to automatically determine the correct
	// number of speakers. If not set, the default value is 2.
	MinSpeakerCount int32 `protobuf:"varint,2,opt,name=min_speaker_count,json=minSpeakerCount,proto3" json:"min_speaker_count,omitempty"`
	// Maximum number of speakers in the conversation. This range gives you more
	// flexibility by allowing the system to automatically determine the correct
	// number of speakers. If not set, the default value is 6.
	MaxSpeakerCount int32 `protobuf:"varint,3,opt,name=max_speaker_count,json=maxSpeakerCount,proto3" json:"max_speaker_count,omitempty"`
	// Output only. Unused.
	//
	// Deprecated: Marked as deprecated in google/cloud/speech/v1p1beta1/cloud_speech.proto.
	SpeakerTag int32 `protobuf:"varint,5,opt,name=speaker_tag,json=speakerTag,proto3" json:"speaker_tag,omitempty"`
}

func (x *SpeakerDiarizationConfig) Reset() {
	*x = SpeakerDiarizationConfig{}
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpeakerDiarizationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeakerDiarizationConfig) ProtoMessage() {}

func (x *SpeakerDiarizationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeakerDiarizationConfig.ProtoReflect.Descriptor instead.
func (*SpeakerDiarizationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{6}
}

func (x *SpeakerDiarizationConfig) GetEnableSpeakerDiarization() bool {
	if x != nil {
		return x.EnableSpeakerDiarization
	}
	return false
}

func (x *SpeakerDiarizationConfig) GetMinSpeakerCount() int32 {
	if x != nil {
		return x.MinSpeakerCount
	}
	return 0
}

func (x *SpeakerDiarizationConfig) GetMaxSpeakerCount() int32 {
	if x != nil {
		return x.MaxSpeakerCount
	}
	return 0
}

// Deprecated: Marked as deprecated in google/cloud/speech/v1p1beta1/cloud_speech.proto.
func (x *SpeakerDiarizationConfig) GetSpeakerTag() int32 {
	if x != nil {
		return x.SpeakerTag
	}
	return 0
}

// Description of audio data to be recognized.
//
// Deprecated: Marked as deprecated in google/cloud/speech/v1p1beta1/cloud_speech.proto.
type RecognitionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The use case most closely describing the audio content to be recognized.
	InteractionType RecognitionMetadata_InteractionType `protobuf:"varint,1,opt,name=interaction_type,json=interactionType,proto3,enum=google.cloud.speech.v1p1beta1.RecognitionMetadata_InteractionType" json:"interaction_type,omitempty"`
	// The industry vertical to which this speech recognition request most
	// closely applies. This is most indicative of the topics contained
	// in the audio.  Use the 6-digit NAICS code to identify the industry
	// vertical - see https://www.naics.com/search/.
	IndustryNaicsCodeOfAudio uint32 `protobuf:"varint,3,opt,name=industry_naics_code_of_audio,json=industryNaicsCodeOfAudio,proto3" json:"industry_naics_code_of_audio,omitempty"`
	// The audio type that most closely describes the audio being recognized.
	MicrophoneDistance RecognitionMetadata_MicrophoneDistance `protobuf:"varint,4,opt,name=microphone_distance,json=microphoneDistance,proto3,enum=google.cloud.speech.v1p1beta1.RecognitionMetadata_MicrophoneDistance" json:"microphone_distance,omitempty"`
	// The original media the speech was recorded on.
	OriginalMediaType RecognitionMetadata_OriginalMediaType `protobuf:"varint,5,opt,name=original_media_type,json=originalMediaType,proto3,enum=google.cloud.speech.v1p1beta1.RecognitionMetadata_OriginalMediaType" json:"original_media_type,omitempty"`
	// The type of device the speech was recorded with.
	RecordingDeviceType RecognitionMetadata_RecordingDeviceType `protobuf:"varint,6,opt,name=recording_device_type,json=recordingDeviceType,proto3,enum=google.cloud.speech.v1p1beta1.RecognitionMetadata_RecordingDeviceType" json:"recording_device_type,omitempty"`
	// The device used to make the recording.  Examples 'Nexus 5X' or
	// 'Polycom SoundStation IP 6000' or 'POTS' or 'VoIP' or
	// 'Cardioid Microphone'.
	RecordingDeviceName string `protobuf:"bytes,7,opt,name=recording_device_name,json=recordingDeviceName,proto3" json:"recording_device_name,omitempty"`
	// Mime type of the original audio file.  For example `audio/m4a`,
	// `audio/x-alaw-basic`, `audio/mp3`, `audio/3gpp`.
	// A list of possible audio mime types is maintained at
	// http://www.iana.org/assignments/media-types/media-types.xhtml#audio
	OriginalMimeType string `protobuf:"bytes,8,opt,name=original_mime_type,json=originalMimeType,proto3" json:"original_mime_type,omitempty"`
	// Obfuscated (privacy-protected) ID of the user, to identify number of
	// unique users using the service.
	//
	// Deprecated: Marked as deprecated in google/cloud/speech/v1p1beta1/cloud_speech.proto.
	ObfuscatedId int64 `protobuf:"varint,9,opt,name=obfuscated_id,json=obfuscatedId,proto3" json:"obfuscated_id,omitempty"`
	// Description of the content. Eg. "Recordings of federal supreme court
	// hearings from 2012".
	AudioTopic string `protobuf:"bytes,10,opt,name=audio_topic,json=audioTopic,proto3" json:"audio_topic,omitempty"`
}

func (x *RecognitionMetadata) Reset() {
	*x = RecognitionMetadata{}
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RecognitionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecognitionMetadata) ProtoMessage() {}

func (x *RecognitionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecognitionMetadata.ProtoReflect.Descriptor instead.
func (*RecognitionMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{7}
}

func (x *RecognitionMetadata) GetInteractionType() RecognitionMetadata_InteractionType {
	if x != nil {
		return x.InteractionType
	}
	return RecognitionMetadata_INTERACTION_TYPE_UNSPECIFIED
}

func (x *RecognitionMetadata) GetIndustryNaicsCodeOfAudio() uint32 {
	if x != nil {
		return x.IndustryNaicsCodeOfAudio
	}
	return 0
}

func (x *RecognitionMetadata) GetMicrophoneDistance() RecognitionMetadata_MicrophoneDistance {
	if x != nil {
		return x.MicrophoneDistance
	}
	return RecognitionMetadata_MICROPHONE_DISTANCE_UNSPECIFIED
}

func (x *RecognitionMetadata) GetOriginalMediaType() RecognitionMetadata_OriginalMediaType {
	if x != nil {
		return x.OriginalMediaType
	}
	return RecognitionMetadata_ORIGINAL_MEDIA_TYPE_UNSPECIFIED
}

func (x *RecognitionMetadata) GetRecordingDeviceType() RecognitionMetadata_RecordingDeviceType {
	if x != nil {
		return x.RecordingDeviceType
	}
	return RecognitionMetadata_RECORDING_DEVICE_TYPE_UNSPECIFIED
}

func (x *RecognitionMetadata) GetRecordingDeviceName() string {
	if x != nil {
		return x.RecordingDeviceName
	}
	return ""
}

func (x *RecognitionMetadata) GetOriginalMimeType() string {
	if x != nil {
		return x.OriginalMimeType
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/speech/v1p1beta1/cloud_speech.proto.
func (x *RecognitionMetadata) GetObfuscatedId() int64 {
	if x != nil {
		return x.ObfuscatedId
	}
	return 0
}

func (x *RecognitionMetadata) GetAudioTopic() string {
	if x != nil {
		return x.AudioTopic
	}
	return ""
}

// Provides "hints" to the speech recognizer to favor specific words and phrases
// in the results.
type SpeechContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of strings containing words and phrases "hints" so that
	// the speech recognition is more likely to recognize them. This can be used
	// to improve the accuracy for specific words and phrases, for example, if
	// specific commands are typically spoken by the user. This can also be used
	// to add additional words to the vocabulary of the recognizer. See
	// [usage limits](https://cloud.google.com/speech-to-text/quotas#content).
	//
	// List items can also be set to classes for groups of words that represent
	// common concepts that occur in natural language. For example, rather than
	// providing phrase hints for every month of the year, using the $MONTH class
	// improves the likelihood of correctly transcribing audio that includes
	// months.
	Phrases []string `protobuf:"bytes,1,rep,name=phrases,proto3" json:"phrases,omitempty"`
	// Hint Boost. Positive value will increase the probability that a specific
	// phrase will be recognized over other similar sounding phrases. The higher
	// the boost, the higher the chance of false positive recognition as well.
	// Negative boost values would correspond to anti-biasing. Anti-biasing is not
	// enabled, so negative boost will simply be ignored. Though `boost` can
	// accept a wide range of positive values, most use cases are best served with
	// values between 0 and 20. We recommend using a binary search approach to
	// finding the optimal value for your use case.
	Boost float32 `protobuf:"fixed32,4,opt,name=boost,proto3" json:"boost,omitempty"`
}

func (x *SpeechContext) Reset() {
	*x = SpeechContext{}
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpeechContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechContext) ProtoMessage() {}

func (x *SpeechContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechContext.ProtoReflect.Descriptor instead.
func (*SpeechContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{8}
}

func (x *SpeechContext) GetPhrases() []string {
	if x != nil {
		return x.Phrases
	}
	return nil
}

func (x *SpeechContext) GetBoost() float32 {
	if x != nil {
		return x.Boost
	}
	return 0
}

// Contains audio data in the encoding specified in the `RecognitionConfig`.
// Either `content` or `uri` must be supplied. Supplying both or neither
// returns [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
// See [content limits](https://cloud.google.com/speech-to-text/quotas#content).
type RecognitionAudio struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The audio source, which is either inline content or a Google Cloud
	// Storage uri.
	//
	// Types that are assignable to AudioSource:
	//
	//	*RecognitionAudio_Content
	//	*RecognitionAudio_Uri
	AudioSource isRecognitionAudio_AudioSource `protobuf_oneof:"audio_source"`
}

func (x *RecognitionAudio) Reset() {
	*x = RecognitionAudio{}
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RecognitionAudio) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecognitionAudio) ProtoMessage() {}

func (x *RecognitionAudio) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecognitionAudio.ProtoReflect.Descriptor instead.
func (*RecognitionAudio) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{9}
}

func (m *RecognitionAudio) GetAudioSource() isRecognitionAudio_AudioSource {
	if m != nil {
		return m.AudioSource
	}
	return nil
}

func (x *RecognitionAudio) GetContent() []byte {
	if x, ok := x.GetAudioSource().(*RecognitionAudio_Content); ok {
		return x.Content
	}
	return nil
}

func (x *RecognitionAudio) GetUri() string {
	if x, ok := x.GetAudioSource().(*RecognitionAudio_Uri); ok {
		return x.Uri
	}
	return ""
}

type isRecognitionAudio_AudioSource interface {
	isRecognitionAudio_AudioSource()
}

type RecognitionAudio_Content struct {
	// The audio data bytes encoded as specified in
	// `RecognitionConfig`. Note: as with all bytes fields, proto buffers use a
	// pure binary representation, whereas JSON representations use base64.
	Content []byte `protobuf:"bytes,1,opt,name=content,proto3,oneof"`
}

type RecognitionAudio_Uri struct {
	// URI that points to a file that contains audio data bytes as specified in
	// `RecognitionConfig`. The file must not be compressed (for example, gzip).
	// Currently, only Google Cloud Storage URIs are
	// supported, which must be specified in the following format:
	// `gs://bucket_name/object_name` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]).
	// For more information, see [Request
	// URIs](https://cloud.google.com/storage/docs/reference-uris).
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3,oneof"`
}

func (*RecognitionAudio_Content) isRecognitionAudio_AudioSource() {}

func (*RecognitionAudio_Uri) isRecognitionAudio_AudioSource() {}

// The only message returned to the client by the `Recognize` method. It
// contains the result as zero or more sequential `SpeechRecognitionResult`
// messages.
type RecognizeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sequential list of transcription results corresponding to
	// sequential portions of audio.
	Results []*SpeechRecognitionResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	// When available, billed audio seconds for the corresponding request.
	TotalBilledTime *durationpb.Duration `protobuf:"bytes,3,opt,name=total_billed_time,json=totalBilledTime,proto3" json:"total_billed_time,omitempty"`
	// Provides information on adaptation behavior in response
	SpeechAdaptationInfo *SpeechAdaptationInfo `protobuf:"bytes,7,opt,name=speech_adaptation_info,json=speechAdaptationInfo,proto3" json:"speech_adaptation_info,omitempty"`
	// The ID associated with the request. This is a unique ID specific only to
	// the given request.
	RequestId int64 `protobuf:"varint,8,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Whether request used legacy asr models (was not automatically migrated to
	// use conformer models).
	UsingLegacyModels bool `protobuf:"varint,9,opt,name=using_legacy_models,json=usingLegacyModels,proto3" json:"using_legacy_models,omitempty"`
}

func (x *RecognizeResponse) Reset() {
	*x = RecognizeResponse{}
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RecognizeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecognizeResponse) ProtoMessage() {}

func (x *RecognizeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecognizeResponse.ProtoReflect.Descriptor instead.
func (*RecognizeResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{10}
}

func (x *RecognizeResponse) GetResults() []*SpeechRecognitionResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *RecognizeResponse) GetTotalBilledTime() *durationpb.Duration {
	if x != nil {
		return x.TotalBilledTime
	}
	return nil
}

func (x *RecognizeResponse) GetSpeechAdaptationInfo() *SpeechAdaptationInfo {
	if x != nil {
		return x.SpeechAdaptationInfo
	}
	return nil
}

func (x *RecognizeResponse) GetRequestId() int64 {
	if x != nil {
		return x.RequestId
	}
	return 0
}

func (x *RecognizeResponse) GetUsingLegacyModels() bool {
	if x != nil {
		return x.UsingLegacyModels
	}
	return false
}

// The only message returned to the client by the `LongRunningRecognize` method.
// It contains the result as zero or more sequential `SpeechRecognitionResult`
// messages. It is included in the `result.response` field of the `Operation`
// returned by the `GetOperation` call of the `google::longrunning::Operations`
// service.
type LongRunningRecognizeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sequential list of transcription results corresponding to
	// sequential portions of audio.
	Results []*SpeechRecognitionResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	// When available, billed audio seconds for the corresponding request.
	TotalBilledTime *durationpb.Duration `protobuf:"bytes,3,opt,name=total_billed_time,json=totalBilledTime,proto3" json:"total_billed_time,omitempty"`
	// Original output config if present in the request.
	OutputConfig *TranscriptOutputConfig `protobuf:"bytes,6,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// If the transcript output fails this field contains the relevant error.
	OutputError *status.Status `protobuf:"bytes,7,opt,name=output_error,json=outputError,proto3" json:"output_error,omitempty"`
	// Provides information on speech adaptation behavior in response
	SpeechAdaptationInfo *SpeechAdaptationInfo `protobuf:"bytes,8,opt,name=speech_adaptation_info,json=speechAdaptationInfo,proto3" json:"speech_adaptation_info,omitempty"`
	// The ID associated with the request. This is a unique ID specific only to
	// the given request.
	RequestId int64 `protobuf:"varint,9,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *LongRunningRecognizeResponse) Reset() {
	*x = LongRunningRecognizeResponse{}
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LongRunningRecognizeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LongRunningRecognizeResponse) ProtoMessage() {}

func (x *LongRunningRecognizeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LongRunningRecognizeResponse.ProtoReflect.Descriptor instead.
func (*LongRunningRecognizeResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{11}
}

func (x *LongRunningRecognizeResponse) GetResults() []*SpeechRecognitionResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *LongRunningRecognizeResponse) GetTotalBilledTime() *durationpb.Duration {
	if x != nil {
		return x.TotalBilledTime
	}
	return nil
}

func (x *LongRunningRecognizeResponse) GetOutputConfig() *TranscriptOutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

func (x *LongRunningRecognizeResponse) GetOutputError() *status.Status {
	if x != nil {
		return x.OutputError
	}
	return nil
}

func (x *LongRunningRecognizeResponse) GetSpeechAdaptationInfo() *SpeechAdaptationInfo {
	if x != nil {
		return x.SpeechAdaptationInfo
	}
	return nil
}

func (x *LongRunningRecognizeResponse) GetRequestId() int64 {
	if x != nil {
		return x.RequestId
	}
	return 0
}

// Describes the progress of a long-running `LongRunningRecognize` call. It is
// included in the `metadata` field of the `Operation` returned by the
// `GetOperation` call of the `google::longrunning::Operations` service.
type LongRunningRecognizeMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Approximate percentage of audio processed thus far. Guaranteed to be 100
	// when the audio is fully processed and the results are available.
	ProgressPercent int32 `protobuf:"varint,1,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Time when the request was received.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time of the most recent processing update.
	LastUpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=last_update_time,json=lastUpdateTime,proto3" json:"last_update_time,omitempty"`
	// Output only. The URI of the audio file being transcribed. Empty if the
	// audio was sent as byte content.
	Uri string `protobuf:"bytes,4,opt,name=uri,proto3" json:"uri,omitempty"`
	// Output only. A copy of the TranscriptOutputConfig if it was set in the
	// request.
	OutputConfig *TranscriptOutputConfig `protobuf:"bytes,5,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
}

func (x *LongRunningRecognizeMetadata) Reset() {
	*x = LongRunningRecognizeMetadata{}
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LongRunningRecognizeMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LongRunningRecognizeMetadata) ProtoMessage() {}

func (x *LongRunningRecognizeMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LongRunningRecognizeMetadata.ProtoReflect.Descriptor instead.
func (*LongRunningRecognizeMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{12}
}

func (x *LongRunningRecognizeMetadata) GetProgressPercent() int32 {
	if x != nil {
		return x.ProgressPercent
	}
	return 0
}

func (x *LongRunningRecognizeMetadata) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *LongRunningRecognizeMetadata) GetLastUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastUpdateTime
	}
	return nil
}

func (x *LongRunningRecognizeMetadata) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *LongRunningRecognizeMetadata) GetOutputConfig() *TranscriptOutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

// `StreamingRecognizeResponse` is the only message returned to the client by
// `StreamingRecognize`. A series of zero or more `StreamingRecognizeResponse`
// messages are streamed back to the client. If there is no recognizable
// audio, and `single_utterance` is set to false, then no messages are streamed
// back to the client.
//
// Here's an example of a series of `StreamingRecognizeResponse`s that might be
// returned while processing audio:
//
// 1. results { alternatives { transcript: "tube" } stability: 0.01 }
//
// 2. results { alternatives { transcript: "to be a" } stability: 0.01 }
//
//  3. results { alternatives { transcript: "to be" } stability: 0.9 }
//     results { alternatives { transcript: " or not to be" } stability: 0.01 }
//
//  4. results { alternatives { transcript: "to be or not to be"
//     confidence: 0.92 }
//     alternatives { transcript: "to bee or not to bee" }
//     is_final: true }
//
// 5. results { alternatives { transcript: " that's" } stability: 0.01 }
//
//  6. results { alternatives { transcript: " that is" } stability: 0.9 }
//     results { alternatives { transcript: " the question" } stability: 0.01 }
//
//  7. results { alternatives { transcript: " that is the question"
//     confidence: 0.98 }
//     alternatives { transcript: " that was the question" }
//     is_final: true }
//
// Notes:
//
//   - Only two of the above responses #4 and #7 contain final results; they are
//     indicated by `is_final: true`. Concatenating these together generates the
//     full transcript: "to be or not to be that is the question".
//
//   - The others contain interim `results`. #3 and #6 contain two interim
//     `results`: the first portion has a high stability and is less likely to
//     change; the second portion has a low stability and is very likely to
//     change. A UI designer might choose to show only high stability `results`.
//
//   - The specific `stability` and `confidence` values shown above are only for
//     illustrative purposes. Actual values may vary.
//
//   - In each response, only one of these fields will be set:
//     `error`,
//     `speech_event_type`, or
//     one or more (repeated) `results`.
type StreamingRecognizeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If set, returns a [google.rpc.Status][google.rpc.Status] message that
	// specifies the error for the operation.
	Error *status.Status `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// This repeated list contains zero or more results that
	// correspond to consecutive portions of the audio currently being processed.
	// It contains zero or one `is_final=true` result (the newly settled portion),
	// followed by zero or more `is_final=false` results (the interim results).
	Results []*StreamingRecognitionResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	// Indicates the type of speech event.
	SpeechEventType StreamingRecognizeResponse_SpeechEventType `protobuf:"varint,4,opt,name=speech_event_type,json=speechEventType,proto3,enum=google.cloud.speech.v1p1beta1.StreamingRecognizeResponse_SpeechEventType" json:"speech_event_type,omitempty"`
	// Time offset between the beginning of the audio and event emission.
	SpeechEventTime *durationpb.Duration `protobuf:"bytes,8,opt,name=speech_event_time,json=speechEventTime,proto3" json:"speech_event_time,omitempty"`
	// When available, billed audio seconds for the stream.
	// Set only if this is the last response in the stream.
	TotalBilledTime *durationpb.Duration `protobuf:"bytes,5,opt,name=total_billed_time,json=totalBilledTime,proto3" json:"total_billed_time,omitempty"`
	// Provides information on adaptation behavior in response
	SpeechAdaptationInfo *SpeechAdaptationInfo `protobuf:"bytes,9,opt,name=speech_adaptation_info,json=speechAdaptationInfo,proto3" json:"speech_adaptation_info,omitempty"`
	// The ID associated with the request. This is a unique ID specific only to
	// the given request.
	RequestId int64 `protobuf:"varint,10,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *StreamingRecognizeResponse) Reset() {
	*x = StreamingRecognizeResponse{}
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingRecognizeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingRecognizeResponse) ProtoMessage() {}

func (x *StreamingRecognizeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingRecognizeResponse.ProtoReflect.Descriptor instead.
func (*StreamingRecognizeResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{13}
}

func (x *StreamingRecognizeResponse) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *StreamingRecognizeResponse) GetResults() []*StreamingRecognitionResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *StreamingRecognizeResponse) GetSpeechEventType() StreamingRecognizeResponse_SpeechEventType {
	if x != nil {
		return x.SpeechEventType
	}
	return StreamingRecognizeResponse_SPEECH_EVENT_UNSPECIFIED
}

func (x *StreamingRecognizeResponse) GetSpeechEventTime() *durationpb.Duration {
	if x != nil {
		return x.SpeechEventTime
	}
	return nil
}

func (x *StreamingRecognizeResponse) GetTotalBilledTime() *durationpb.Duration {
	if x != nil {
		return x.TotalBilledTime
	}
	return nil
}

func (x *StreamingRecognizeResponse) GetSpeechAdaptationInfo() *SpeechAdaptationInfo {
	if x != nil {
		return x.SpeechAdaptationInfo
	}
	return nil
}

func (x *StreamingRecognizeResponse) GetRequestId() int64 {
	if x != nil {
		return x.RequestId
	}
	return 0
}

// A streaming speech recognition result corresponding to a portion of the audio
// that is currently being processed.
type StreamingRecognitionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// May contain one or more recognition hypotheses (up to the
	// maximum specified in `max_alternatives`).
	// These alternatives are ordered in terms of accuracy, with the top (first)
	// alternative being the most probable, as ranked by the recognizer.
	Alternatives []*SpeechRecognitionAlternative `protobuf:"bytes,1,rep,name=alternatives,proto3" json:"alternatives,omitempty"`
	// If `false`, this `StreamingRecognitionResult` represents an
	// interim result that may change. If `true`, this is the final time the
	// speech service will return this particular `StreamingRecognitionResult`,
	// the recognizer will not return any further hypotheses for this portion of
	// the transcript and corresponding audio.
	IsFinal bool `protobuf:"varint,2,opt,name=is_final,json=isFinal,proto3" json:"is_final,omitempty"`
	// An estimate of the likelihood that the recognizer will not
	// change its guess about this interim result. Values range from 0.0
	// (completely unstable) to 1.0 (completely stable).
	// This field is only provided for interim results (`is_final=false`).
	// The default of 0.0 is a sentinel value indicating `stability` was not set.
	Stability float32 `protobuf:"fixed32,3,opt,name=stability,proto3" json:"stability,omitempty"`
	// Time offset of the end of this result relative to the
	// beginning of the audio.
	ResultEndTime *durationpb.Duration `protobuf:"bytes,4,opt,name=result_end_time,json=resultEndTime,proto3" json:"result_end_time,omitempty"`
	// For multi-channel audio, this is the channel number corresponding to the
	// recognized result for the audio from that channel.
	// For audio_channel_count = N, its output values can range from '1' to 'N'.
	ChannelTag int32 `protobuf:"varint,5,opt,name=channel_tag,json=channelTag,proto3" json:"channel_tag,omitempty"`
	// Output only. The [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
	// language tag of the language in this result. This language code was
	// detected to have the most likelihood of being spoken in the audio.
	LanguageCode string `protobuf:"bytes,6,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *StreamingRecognitionResult) Reset() {
	*x = StreamingRecognitionResult{}
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingRecognitionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingRecognitionResult) ProtoMessage() {}

func (x *StreamingRecognitionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingRecognitionResult.ProtoReflect.Descriptor instead.
func (*StreamingRecognitionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{14}
}

func (x *StreamingRecognitionResult) GetAlternatives() []*SpeechRecognitionAlternative {
	if x != nil {
		return x.Alternatives
	}
	return nil
}

func (x *StreamingRecognitionResult) GetIsFinal() bool {
	if x != nil {
		return x.IsFinal
	}
	return false
}

func (x *StreamingRecognitionResult) GetStability() float32 {
	if x != nil {
		return x.Stability
	}
	return 0
}

func (x *StreamingRecognitionResult) GetResultEndTime() *durationpb.Duration {
	if x != nil {
		return x.ResultEndTime
	}
	return nil
}

func (x *StreamingRecognitionResult) GetChannelTag() int32 {
	if x != nil {
		return x.ChannelTag
	}
	return 0
}

func (x *StreamingRecognitionResult) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// A speech recognition result corresponding to a portion of the audio.
type SpeechRecognitionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// May contain one or more recognition hypotheses (up to the
	// maximum specified in `max_alternatives`).
	// These alternatives are ordered in terms of accuracy, with the top (first)
	// alternative being the most probable, as ranked by the recognizer.
	Alternatives []*SpeechRecognitionAlternative `protobuf:"bytes,1,rep,name=alternatives,proto3" json:"alternatives,omitempty"`
	// For multi-channel audio, this is the channel number corresponding to the
	// recognized result for the audio from that channel.
	// For audio_channel_count = N, its output values can range from '1' to 'N'.
	ChannelTag int32 `protobuf:"varint,2,opt,name=channel_tag,json=channelTag,proto3" json:"channel_tag,omitempty"`
	// Time offset of the end of this result relative to the
	// beginning of the audio.
	ResultEndTime *durationpb.Duration `protobuf:"bytes,4,opt,name=result_end_time,json=resultEndTime,proto3" json:"result_end_time,omitempty"`
	// Output only. The [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
	// language tag of the language in this result. This language code was
	// detected to have the most likelihood of being spoken in the audio.
	LanguageCode string `protobuf:"bytes,5,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *SpeechRecognitionResult) Reset() {
	*x = SpeechRecognitionResult{}
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpeechRecognitionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechRecognitionResult) ProtoMessage() {}

func (x *SpeechRecognitionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechRecognitionResult.ProtoReflect.Descriptor instead.
func (*SpeechRecognitionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{15}
}

func (x *SpeechRecognitionResult) GetAlternatives() []*SpeechRecognitionAlternative {
	if x != nil {
		return x.Alternatives
	}
	return nil
}

func (x *SpeechRecognitionResult) GetChannelTag() int32 {
	if x != nil {
		return x.ChannelTag
	}
	return 0
}

func (x *SpeechRecognitionResult) GetResultEndTime() *durationpb.Duration {
	if x != nil {
		return x.ResultEndTime
	}
	return nil
}

func (x *SpeechRecognitionResult) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Alternative hypotheses (a.k.a. n-best list).
type SpeechRecognitionAlternative struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Transcript text representing the words that the user spoke.
	// In languages that use spaces to separate words, the transcript might have a
	// leading space if it isn't the first result. You can concatenate each result
	// to obtain the full transcript without using a separator.
	Transcript string `protobuf:"bytes,1,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// The confidence estimate between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. This field is set only for the top alternative of a non-streaming
	// result or, of a streaming result where `is_final=true`.
	// This field is not guaranteed to be accurate and users should not rely on it
	// to be always provided.
	// The default of 0.0 is a sentinel value indicating `confidence` was not set.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// A list of word-specific information for each recognized word.
	// Note: When `enable_speaker_diarization` is true, you will see all the words
	// from the beginning of the audio.
	Words []*WordInfo `protobuf:"bytes,3,rep,name=words,proto3" json:"words,omitempty"`
}

func (x *SpeechRecognitionAlternative) Reset() {
	*x = SpeechRecognitionAlternative{}
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpeechRecognitionAlternative) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechRecognitionAlternative) ProtoMessage() {}

func (x *SpeechRecognitionAlternative) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechRecognitionAlternative.ProtoReflect.Descriptor instead.
func (*SpeechRecognitionAlternative) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{16}
}

func (x *SpeechRecognitionAlternative) GetTranscript() string {
	if x != nil {
		return x.Transcript
	}
	return ""
}

func (x *SpeechRecognitionAlternative) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *SpeechRecognitionAlternative) GetWords() []*WordInfo {
	if x != nil {
		return x.Words
	}
	return nil
}

// Word-specific information for recognized words.
type WordInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time offset relative to the beginning of the audio,
	// and corresponding to the start of the spoken word.
	// This field is only set if `enable_word_time_offsets=true` and only
	// in the top hypothesis.
	// This is an experimental feature and the accuracy of the time offset can
	// vary.
	StartTime *durationpb.Duration `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time offset relative to the beginning of the audio,
	// and corresponding to the end of the spoken word.
	// This field is only set if `enable_word_time_offsets=true` and only
	// in the top hypothesis.
	// This is an experimental feature and the accuracy of the time offset can
	// vary.
	EndTime *durationpb.Duration `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The word corresponding to this set of information.
	Word string `protobuf:"bytes,3,opt,name=word,proto3" json:"word,omitempty"`
	// The confidence estimate between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. This field is set only for the top alternative of a non-streaming
	// result or, of a streaming result where `is_final=true`.
	// This field is not guaranteed to be accurate and users should not rely on it
	// to be always provided.
	// The default of 0.0 is a sentinel value indicating `confidence` was not set.
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Output only. A distinct integer value is assigned for every speaker within
	// the audio. This field specifies which one of those speakers was detected to
	// have spoken this word. Value ranges from '1' to diarization_speaker_count.
	// speaker_tag is set if enable_speaker_diarization = 'true' and only for the
	// top alternative.
	// Note: Use speaker_label instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/speech/v1p1beta1/cloud_speech.proto.
	SpeakerTag int32 `protobuf:"varint,5,opt,name=speaker_tag,json=speakerTag,proto3" json:"speaker_tag,omitempty"`
	// Output only. A label value assigned for every unique speaker within the
	// audio. This field specifies which speaker was detected to have spoken this
	// word. For some models, like medical_conversation this can be actual speaker
	// role, for example "patient" or "provider", but generally this would be a
	// number identifying a speaker. This field is only set if
	// enable_speaker_diarization = 'true' and only for the top alternative.
	SpeakerLabel string `protobuf:"bytes,6,opt,name=speaker_label,json=speakerLabel,proto3" json:"speaker_label,omitempty"`
}

func (x *WordInfo) Reset() {
	*x = WordInfo{}
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WordInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WordInfo) ProtoMessage() {}

func (x *WordInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WordInfo.ProtoReflect.Descriptor instead.
func (*WordInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{17}
}

func (x *WordInfo) GetStartTime() *durationpb.Duration {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *WordInfo) GetEndTime() *durationpb.Duration {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *WordInfo) GetWord() string {
	if x != nil {
		return x.Word
	}
	return ""
}

func (x *WordInfo) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// Deprecated: Marked as deprecated in google/cloud/speech/v1p1beta1/cloud_speech.proto.
func (x *WordInfo) GetSpeakerTag() int32 {
	if x != nil {
		return x.SpeakerTag
	}
	return 0
}

func (x *WordInfo) GetSpeakerLabel() string {
	if x != nil {
		return x.SpeakerLabel
	}
	return ""
}

// Information on speech adaptation use in results
type SpeechAdaptationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether there was a timeout when applying speech adaptation. If true,
	// adaptation had no effect in the response transcript.
	AdaptationTimeout bool `protobuf:"varint,1,opt,name=adaptation_timeout,json=adaptationTimeout,proto3" json:"adaptation_timeout,omitempty"`
	// If set, returns a message specifying which part of the speech adaptation
	// request timed out.
	TimeoutMessage string `protobuf:"bytes,4,opt,name=timeout_message,json=timeoutMessage,proto3" json:"timeout_message,omitempty"`
}

func (x *SpeechAdaptationInfo) Reset() {
	*x = SpeechAdaptationInfo{}
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpeechAdaptationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechAdaptationInfo) ProtoMessage() {}

func (x *SpeechAdaptationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechAdaptationInfo.ProtoReflect.Descriptor instead.
func (*SpeechAdaptationInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{18}
}

func (x *SpeechAdaptationInfo) GetAdaptationTimeout() bool {
	if x != nil {
		return x.AdaptationTimeout
	}
	return false
}

func (x *SpeechAdaptationInfo) GetTimeoutMessage() string {
	if x != nil {
		return x.TimeoutMessage
	}
	return ""
}

// Events that a timeout can be set on for voice activity.
type StreamingRecognitionConfig_VoiceActivityTimeout struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Duration to timeout the stream if no speech begins.
	SpeechStartTimeout *durationpb.Duration `protobuf:"bytes,1,opt,name=speech_start_timeout,json=speechStartTimeout,proto3" json:"speech_start_timeout,omitempty"`
	// Duration to timeout the stream after speech ends.
	SpeechEndTimeout *durationpb.Duration `protobuf:"bytes,2,opt,name=speech_end_timeout,json=speechEndTimeout,proto3" json:"speech_end_timeout,omitempty"`
}

func (x *StreamingRecognitionConfig_VoiceActivityTimeout) Reset() {
	*x = StreamingRecognitionConfig_VoiceActivityTimeout{}
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingRecognitionConfig_VoiceActivityTimeout) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingRecognitionConfig_VoiceActivityTimeout) ProtoMessage() {}

func (x *StreamingRecognitionConfig_VoiceActivityTimeout) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingRecognitionConfig_VoiceActivityTimeout.ProtoReflect.Descriptor instead.
func (*StreamingRecognitionConfig_VoiceActivityTimeout) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP(), []int{4, 0}
}

func (x *StreamingRecognitionConfig_VoiceActivityTimeout) GetSpeechStartTimeout() *durationpb.Duration {
	if x != nil {
		return x.SpeechStartTimeout
	}
	return nil
}

func (x *StreamingRecognitionConfig_VoiceActivityTimeout) GetSpeechEndTimeout() *durationpb.Duration {
	if x != nil {
		return x.SpeechEndTimeout
	}
	return nil
}

var File_google_cloud_speech_v1p1beta1_cloud_speech_proto protoreflect.FileDescriptor

var file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2f, 0x76,
	0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77,
	0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xad, 0x01, 0x0a, 0x10, 0x52, 0x65, 0x63, 0x6f, 0x67,
	0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x6f,
	0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4a, 0x0a, 0x05, 0x61, 0x75,
	0x64, 0x69, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x05, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x22, 0x99, 0x02, 0x0a, 0x1b, 0x4c, 0x6f, 0x6e, 0x67, 0x52,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4a, 0x0a, 0x05, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x41, 0x75, 0x64, 0x69, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x61, 0x75, 0x64, 0x69,
	0x6f, 0x12, 0x5f, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76,
	0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0x42, 0x0a, 0x16, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x19, 0x0a, 0x07,
	0x67, 0x63, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x06, 0x67, 0x63, 0x73, 0x55, 0x72, 0x69, 0x42, 0x0d, 0x0a, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0xbf, 0x01, 0x0a, 0x19, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x66, 0x0a, 0x10, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x25, 0x0a, 0x0d,
	0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x42, 0x13, 0x0a, 0x11, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67,
	0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0xb6, 0x04, 0x0a, 0x1a, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4d, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31,
	0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65,
	0x5f, 0x75, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x55, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x27, 0x0a, 0x0f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6d, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6d, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x3f, 0x0a, 0x1c, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x41, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x84, 0x01, 0x0a, 0x16,
	0x76, 0x6f, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x41, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x52, 0x14, 0x76, 0x6f,
	0x69, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x6f,
	0x75, 0x74, 0x1a, 0xac, 0x01, 0x0a, 0x14, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x4b, 0x0a, 0x14, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x53, 0x74, 0x61, 0x72,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x47, 0x0a, 0x12, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x10, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75,
	0x74, 0x22, 0xf9, 0x0c, 0x0a, 0x11, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5a, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64,
	0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x75, 0x64, 0x69,
	0x6f, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64,
	0x69, 0x6e, 0x67, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x72, 0x61,
	0x74, 0x65, 0x5f, 0x68, 0x65, 0x72, 0x74, 0x7a, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f,
	0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x61, 0x74, 0x65, 0x48, 0x65, 0x72, 0x74, 0x7a, 0x12,
	0x2e, 0x0a, 0x13, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x61, 0x75,
	0x64, 0x69, 0x6f, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x54, 0x0a, 0x27, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x70, 0x61, 0x72, 0x61,
	0x74, 0x65, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70,
	0x65, 0x72, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x23, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x65,
	0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x3c, 0x0a, 0x1a, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x12, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x18, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x29, 0x0a,
	0x10, 0x6d, 0x61, 0x78, 0x5f, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x41, 0x6c, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x66,
	0x61, 0x6e, 0x69, 0x74, 0x79, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x66, 0x61, 0x6e, 0x69, 0x74, 0x79, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x4f, 0x0a, 0x0a, 0x61, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31,
	0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x41, 0x64,
	0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x61, 0x64, 0x61, 0x70, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x76, 0x0a, 0x18, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x5f, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x17, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x4e,
	0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x55, 0x0a, 0x0f,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x52, 0x0e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x73, 0x12, 0x37, 0x0a, 0x18, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x77, 0x6f,
	0x72, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x73, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x6f, 0x72,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x73, 0x12, 0x34, 0x0a, 0x16,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x57, 0x6f, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e,
	0x63, 0x65, 0x12, 0x40, 0x0a, 0x1c, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x70, 0x75, 0x6e, 0x63, 0x74, 0x75, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x50, 0x75, 0x6e, 0x63, 0x74, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73,
	0x70, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x70, 0x75, 0x6e, 0x63, 0x74, 0x75, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x17, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x70, 0x6f, 0x6b, 0x65,
	0x6e, 0x50, 0x75, 0x6e, 0x63, 0x74, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4c, 0x0a, 0x14,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x65, 0x6d,
	0x6f, 0x6a, 0x69, 0x73, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f,
	0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x70,
	0x6f, 0x6b, 0x65, 0x6e, 0x45, 0x6d, 0x6f, 0x6a, 0x69, 0x73, 0x12, 0x40, 0x0a, 0x1a, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x5f, 0x64, 0x69, 0x61,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x18, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x61, 0x6b, 0x65,
	0x72, 0x44, 0x69, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x19,
	0x64, 0x69, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x61,
	0x6b, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x11, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x17, 0x64, 0x69, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x66, 0x0a, 0x12,
	0x64, 0x69, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76,
	0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72,
	0x44, 0x69, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x11, 0x64, 0x69, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x4e, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x21, 0x0a, 0x0c, 0x75, 0x73,
	0x65, 0x5f, 0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0b, 0x75, 0x73, 0x65, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x22, 0xad, 0x01,
	0x0a, 0x0d, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12,
	0x18, 0x0a, 0x14, 0x45, 0x4e, 0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x4c, 0x49, 0x4e,
	0x45, 0x41, 0x52, 0x31, 0x36, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x4c, 0x41, 0x43, 0x10,
	0x02, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x55, 0x4c, 0x41, 0x57, 0x10, 0x03, 0x12, 0x07, 0x0a, 0x03,
	0x41, 0x4d, 0x52, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x4d, 0x52, 0x5f, 0x57, 0x42, 0x10,
	0x05, 0x12, 0x0c, 0x0a, 0x08, 0x4f, 0x47, 0x47, 0x5f, 0x4f, 0x50, 0x55, 0x53, 0x10, 0x06, 0x12,
	0x1a, 0x0a, 0x16, 0x53, 0x50, 0x45, 0x45, 0x58, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x48, 0x45,
	0x41, 0x44, 0x45, 0x52, 0x5f, 0x42, 0x59, 0x54, 0x45, 0x10, 0x07, 0x12, 0x07, 0x0a, 0x03, 0x4d,
	0x50, 0x33, 0x10, 0x08, 0x12, 0x0d, 0x0a, 0x09, 0x57, 0x45, 0x42, 0x4d, 0x5f, 0x4f, 0x50, 0x55,
	0x53, 0x10, 0x09, 0x12, 0x08, 0x0a, 0x04, 0x41, 0x4c, 0x41, 0x57, 0x10, 0x0a, 0x22, 0xd8, 0x01,
	0x0a, 0x18, 0x53, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x44, 0x69, 0x61, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3c, 0x0a, 0x1a, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x5f, 0x64, 0x69, 0x61,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x18,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x44, 0x69, 0x61,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x11, 0x6d, 0x69, 0x6e, 0x5f,
	0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0f, 0x6d, 0x69, 0x6e, 0x53, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2a, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x70, 0x65, 0x61,
	0x6b, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0f, 0x6d, 0x61, 0x78, 0x53, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x26, 0x0a, 0x0b, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x5f, 0x74, 0x61, 0x67, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x05, 0xe0, 0x41, 0x03, 0x18, 0x01, 0x52, 0x0a, 0x73, 0x70,
	0x65, 0x61, 0x6b, 0x65, 0x72, 0x54, 0x61, 0x67, 0x22, 0x83, 0x0a, 0x0a, 0x13, 0x52, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x6d, 0x0a, 0x10, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67,
	0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x3e, 0x0a, 0x1c, 0x69, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79, 0x5f, 0x6e, 0x61, 0x69, 0x63,
	0x73, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x6f, 0x66, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x18, 0x69, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79, 0x4e,
	0x61, 0x69, 0x63, 0x73, 0x43, 0x6f, 0x64, 0x65, 0x4f, 0x66, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x12,
	0x76, 0x0a, 0x13, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x64, 0x69,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x45, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x52, 0x12, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x44,
	0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x74, 0x0a, 0x13, 0x6f, 0x72, 0x69, 0x67, 0x69,
	0x6e, 0x61, 0x6c, 0x5f, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61,
	0x6c, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x54, 0x79, 0x70, 0x65, 0x52, 0x11, 0x6f, 0x72, 0x69, 0x67,
	0x69, 0x6e, 0x61, 0x6c, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x7a, 0x0a,
	0x15, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x13, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x72, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x69, 0x6e, 0x67, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a,
	0x12, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x72, 0x69, 0x67, 0x69,
	0x6e, 0x61, 0x6c, 0x4d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x27, 0x0a, 0x0d, 0x6f,
	0x62, 0x66, 0x75, 0x73, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x03, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0c, 0x6f, 0x62, 0x66, 0x75, 0x73, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x74, 0x6f,
	0x70, 0x69, 0x63, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x75, 0x64, 0x69, 0x6f,
	0x54, 0x6f, 0x70, 0x69, 0x63, 0x22, 0xc5, 0x01, 0x0a, 0x0f, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x49, 0x4e, 0x54,
	0x45, 0x52, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x44,
	0x49, 0x53, 0x43, 0x55, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x50,
	0x52, 0x45, 0x53, 0x45, 0x4e, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x0e, 0x0a,
	0x0a, 0x50, 0x48, 0x4f, 0x4e, 0x45, 0x5f, 0x43, 0x41, 0x4c, 0x4c, 0x10, 0x03, 0x12, 0x0d, 0x0a,
	0x09, 0x56, 0x4f, 0x49, 0x43, 0x45, 0x4d, 0x41, 0x49, 0x4c, 0x10, 0x04, 0x12, 0x1b, 0x0a, 0x17,
	0x50, 0x52, 0x4f, 0x46, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x4c, 0x59, 0x5f, 0x50,
	0x52, 0x4f, 0x44, 0x55, 0x43, 0x45, 0x44, 0x10, 0x05, 0x12, 0x10, 0x0a, 0x0c, 0x56, 0x4f, 0x49,
	0x43, 0x45, 0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x10, 0x06, 0x12, 0x11, 0x0a, 0x0d, 0x56,
	0x4f, 0x49, 0x43, 0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x41, 0x4e, 0x44, 0x10, 0x07, 0x12, 0x0d,
	0x0a, 0x09, 0x44, 0x49, 0x43, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x08, 0x22, 0x64, 0x0a,
	0x12, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x4d, 0x49, 0x43, 0x52, 0x4f, 0x50, 0x48, 0x4f, 0x4e,
	0x45, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x45, 0x41, 0x52,
	0x46, 0x49, 0x45, 0x4c, 0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x4d, 0x49, 0x44, 0x46, 0x49,
	0x45, 0x4c, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x46, 0x41, 0x52, 0x46, 0x49, 0x45, 0x4c,
	0x44, 0x10, 0x03, 0x22, 0x4e, 0x0a, 0x11, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x4d,
	0x65, 0x64, 0x69, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x4f, 0x52, 0x49, 0x47,
	0x49, 0x4e, 0x41, 0x4c, 0x5f, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a,
	0x05, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x56, 0x49, 0x44, 0x45,
	0x4f, 0x10, 0x02, 0x22, 0xa4, 0x01, 0x0a, 0x13, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e,
	0x67, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x21, 0x52,
	0x45, 0x43, 0x4f, 0x52, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x4d, 0x41, 0x52, 0x54, 0x50, 0x48, 0x4f, 0x4e, 0x45,
	0x10, 0x01, 0x12, 0x06, 0x0a, 0x02, 0x50, 0x43, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x48,
	0x4f, 0x4e, 0x45, 0x5f, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x56, 0x45,
	0x48, 0x49, 0x43, 0x4c, 0x45, 0x10, 0x04, 0x12, 0x18, 0x0a, 0x14, 0x4f, 0x54, 0x48, 0x45, 0x52,
	0x5f, 0x4f, 0x55, 0x54, 0x44, 0x4f, 0x4f, 0x52, 0x5f, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x10,
	0x05, 0x12, 0x17, 0x0a, 0x13, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x5f, 0x49, 0x4e, 0x44, 0x4f, 0x4f,
	0x52, 0x5f, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x10, 0x06, 0x3a, 0x02, 0x18, 0x01, 0x22, 0x3f,
	0x0a, 0x0d, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12,
	0x18, 0x0a, 0x07, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x07, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x62, 0x6f, 0x6f,
	0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x22,
	0x52, 0x0a, 0x10, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x75,
	0x64, 0x69, 0x6f, 0x12, 0x1a, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12,
	0x12, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x03,
	0x75, 0x72, 0x69, 0x42, 0x0e, 0x0a, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x22, 0xe6, 0x02, 0x0a, 0x11, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x50, 0x0a, 0x07, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x45, 0x0a, 0x11, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x62, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x42, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x69, 0x0a, 0x16, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x61, 0x64, 0x61,
	0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x41, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x14, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x41,
	0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1d, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x13,
	0x75, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x75, 0x73, 0x69, 0x6e, 0x67,
	0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x22, 0xd4, 0x03, 0x0a,
	0x1c, 0x4c, 0x6f, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f,
	0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x50, 0x0a,
	0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12,
	0x45, 0x0a, 0x11, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x62, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x42, 0x69, 0x6c, 0x6c,
	0x65, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x35, 0x0a, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0b, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x69, 0x0a, 0x16, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x5f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x41, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x14,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x41, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0xc2, 0x02, 0x0a, 0x1c, 0x4c, 0x6f, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f,
	0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12,
	0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x44, 0x0a, 0x10, 0x6c, 0x61,
	0x73, 0x74, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x5f, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xca, 0x05, 0x0a, 0x1a, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x12, 0x53, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f,
	0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x75, 0x0a, 0x11, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x67,
	0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x45, 0x0a,
	0x11, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x11, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x62, 0x69,
	0x6c, 0x6c, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x42, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x69, 0x0a, 0x16, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x41, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x14, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x41, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x9d, 0x01, 0x0a, 0x0f, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x50, 0x45,
	0x45, 0x43, 0x48, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x4e, 0x44, 0x5f, 0x4f,
	0x46, 0x5f, 0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x5f, 0x55, 0x54, 0x54, 0x45, 0x52, 0x41, 0x4e,
	0x43, 0x45, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x50, 0x45, 0x45, 0x43, 0x48, 0x5f, 0x41,
	0x43, 0x54, 0x49, 0x56, 0x49, 0x54, 0x59, 0x5f, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x10, 0x02, 0x12,
	0x17, 0x0a, 0x13, 0x53, 0x50, 0x45, 0x45, 0x43, 0x48, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x49,
	0x54, 0x59, 0x5f, 0x45, 0x4e, 0x44, 0x10, 0x03, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x50, 0x45, 0x45,
	0x43, 0x48, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x49, 0x4d, 0x45,
	0x4f, 0x55, 0x54, 0x10, 0x04, 0x22, 0xc4, 0x02, 0x0a, 0x1a, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x5f, 0x0a, 0x0c, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6c, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x52, 0x0c, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x73, 0x5f, 0x66, 0x69, 0x6e, 0x61,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x69, 0x73, 0x46, 0x69, 0x6e, 0x61, 0x6c,
	0x12, 0x1c, 0x0a, 0x09, 0x73, 0x74, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x09, 0x73, 0x74, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x41,
	0x0a, 0x0f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x74, 0x61, 0x67,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x54,
	0x61, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x88, 0x02, 0x0a,
	0x17, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x5f, 0x0a, 0x0c, 0x61, 0x6c, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x41, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x52, 0x0c, 0x61, 0x6c, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x54, 0x61, 0x67, 0x12, 0x41, 0x0a, 0x0f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x28, 0x0a,
	0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x9d, 0x01, 0x0a, 0x1c, 0x53, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6c, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x3d, 0x0a, 0x05, 0x77, 0x6f, 0x72, 0x64,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31,
	0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x05, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x22, 0x80, 0x02, 0x0a, 0x08, 0x57, 0x6f, 0x72, 0x64,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x38, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x34,
	0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x65, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x26, 0x0a, 0x0b, 0x73, 0x70, 0x65, 0x61,
	0x6b, 0x65, 0x72, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x05, 0xe0,
	0x41, 0x03, 0x18, 0x01, 0x52, 0x0a, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x54, 0x61, 0x67,
	0x12, 0x28, 0x0a, 0x0d, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x5f, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x70,
	0x65, 0x61, 0x6b, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0x6e, 0x0a, 0x14, 0x53, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x41, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x2d, 0x0a, 0x12, 0x61, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11,
	0x61, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75,
	0x74, 0x12, 0x27, 0x0a, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x74, 0x69, 0x6d, 0x65,
	0x6f, 0x75, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x32, 0x82, 0x05, 0x0a, 0x06, 0x53,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x12, 0xa5, 0x01, 0x0a, 0x09, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e,
	0x69, 0x7a, 0x65, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x35, 0xda, 0x41, 0x0c, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x20, 0x3a, 0x01, 0x2a,
	0x22, 0x1b, 0x2f, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x3a, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x12, 0xf2, 0x01,
	0x0a, 0x14, 0x4c, 0x6f, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x7f, 0xca, 0x41, 0x3c, 0x0a, 0x1c, 0x4c, 0x6f, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1c, 0x4c, 0x6f, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x0c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x61, 0x75, 0x64, 0x69,
	0x6f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x3a, 0x01, 0x2a, 0x22, 0x26, 0x2f, 0x76, 0x31, 0x70,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x3a, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69,
	0x7a, 0x65, 0x12, 0x8f, 0x01, 0x0a, 0x12, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67,
	0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x28, 0x01, 0x30, 0x01, 0x1a, 0x49, 0xca, 0x41, 0x15, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42,
	0x73, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x42, 0x0b, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x39, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x70, 0x62, 0x3b, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x70, 0x62, 0xa2, 0x02,
	0x03, 0x47, 0x43, 0x53, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescOnce sync.Once
	file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescData = file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDesc
)

func file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescGZIP() []byte {
	file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescOnce.Do(func() {
		file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescData)
	})
	return file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDescData
}

var file_google_cloud_speech_v1p1beta1_cloud_speech_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_google_cloud_speech_v1p1beta1_cloud_speech_proto_goTypes = []any{
	(RecognitionConfig_AudioEncoding)(0),                    // 0: google.cloud.speech.v1p1beta1.RecognitionConfig.AudioEncoding
	(RecognitionMetadata_InteractionType)(0),                // 1: google.cloud.speech.v1p1beta1.RecognitionMetadata.InteractionType
	(RecognitionMetadata_MicrophoneDistance)(0),             // 2: google.cloud.speech.v1p1beta1.RecognitionMetadata.MicrophoneDistance
	(RecognitionMetadata_OriginalMediaType)(0),              // 3: google.cloud.speech.v1p1beta1.RecognitionMetadata.OriginalMediaType
	(RecognitionMetadata_RecordingDeviceType)(0),            // 4: google.cloud.speech.v1p1beta1.RecognitionMetadata.RecordingDeviceType
	(StreamingRecognizeResponse_SpeechEventType)(0),         // 5: google.cloud.speech.v1p1beta1.StreamingRecognizeResponse.SpeechEventType
	(*RecognizeRequest)(nil),                                // 6: google.cloud.speech.v1p1beta1.RecognizeRequest
	(*LongRunningRecognizeRequest)(nil),                     // 7: google.cloud.speech.v1p1beta1.LongRunningRecognizeRequest
	(*TranscriptOutputConfig)(nil),                          // 8: google.cloud.speech.v1p1beta1.TranscriptOutputConfig
	(*StreamingRecognizeRequest)(nil),                       // 9: google.cloud.speech.v1p1beta1.StreamingRecognizeRequest
	(*StreamingRecognitionConfig)(nil),                      // 10: google.cloud.speech.v1p1beta1.StreamingRecognitionConfig
	(*RecognitionConfig)(nil),                               // 11: google.cloud.speech.v1p1beta1.RecognitionConfig
	(*SpeakerDiarizationConfig)(nil),                        // 12: google.cloud.speech.v1p1beta1.SpeakerDiarizationConfig
	(*RecognitionMetadata)(nil),                             // 13: google.cloud.speech.v1p1beta1.RecognitionMetadata
	(*SpeechContext)(nil),                                   // 14: google.cloud.speech.v1p1beta1.SpeechContext
	(*RecognitionAudio)(nil),                                // 15: google.cloud.speech.v1p1beta1.RecognitionAudio
	(*RecognizeResponse)(nil),                               // 16: google.cloud.speech.v1p1beta1.RecognizeResponse
	(*LongRunningRecognizeResponse)(nil),                    // 17: google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse
	(*LongRunningRecognizeMetadata)(nil),                    // 18: google.cloud.speech.v1p1beta1.LongRunningRecognizeMetadata
	(*StreamingRecognizeResponse)(nil),                      // 19: google.cloud.speech.v1p1beta1.StreamingRecognizeResponse
	(*StreamingRecognitionResult)(nil),                      // 20: google.cloud.speech.v1p1beta1.StreamingRecognitionResult
	(*SpeechRecognitionResult)(nil),                         // 21: google.cloud.speech.v1p1beta1.SpeechRecognitionResult
	(*SpeechRecognitionAlternative)(nil),                    // 22: google.cloud.speech.v1p1beta1.SpeechRecognitionAlternative
	(*WordInfo)(nil),                                        // 23: google.cloud.speech.v1p1beta1.WordInfo
	(*SpeechAdaptationInfo)(nil),                            // 24: google.cloud.speech.v1p1beta1.SpeechAdaptationInfo
	(*StreamingRecognitionConfig_VoiceActivityTimeout)(nil), // 25: google.cloud.speech.v1p1beta1.StreamingRecognitionConfig.VoiceActivityTimeout
	(*SpeechAdaptation)(nil),                                // 26: google.cloud.speech.v1p1beta1.SpeechAdaptation
	(*TranscriptNormalization)(nil),                         // 27: google.cloud.speech.v1p1beta1.TranscriptNormalization
	(*wrapperspb.BoolValue)(nil),                            // 28: google.protobuf.BoolValue
	(*durationpb.Duration)(nil),                             // 29: google.protobuf.Duration
	(*status.Status)(nil),                                   // 30: google.rpc.Status
	(*timestamppb.Timestamp)(nil),                           // 31: google.protobuf.Timestamp
	(*longrunningpb.Operation)(nil),                         // 32: google.longrunning.Operation
}
var file_google_cloud_speech_v1p1beta1_cloud_speech_proto_depIdxs = []int32{
	11, // 0: google.cloud.speech.v1p1beta1.RecognizeRequest.config:type_name -> google.cloud.speech.v1p1beta1.RecognitionConfig
	15, // 1: google.cloud.speech.v1p1beta1.RecognizeRequest.audio:type_name -> google.cloud.speech.v1p1beta1.RecognitionAudio
	11, // 2: google.cloud.speech.v1p1beta1.LongRunningRecognizeRequest.config:type_name -> google.cloud.speech.v1p1beta1.RecognitionConfig
	15, // 3: google.cloud.speech.v1p1beta1.LongRunningRecognizeRequest.audio:type_name -> google.cloud.speech.v1p1beta1.RecognitionAudio
	8,  // 4: google.cloud.speech.v1p1beta1.LongRunningRecognizeRequest.output_config:type_name -> google.cloud.speech.v1p1beta1.TranscriptOutputConfig
	10, // 5: google.cloud.speech.v1p1beta1.StreamingRecognizeRequest.streaming_config:type_name -> google.cloud.speech.v1p1beta1.StreamingRecognitionConfig
	11, // 6: google.cloud.speech.v1p1beta1.StreamingRecognitionConfig.config:type_name -> google.cloud.speech.v1p1beta1.RecognitionConfig
	25, // 7: google.cloud.speech.v1p1beta1.StreamingRecognitionConfig.voice_activity_timeout:type_name -> google.cloud.speech.v1p1beta1.StreamingRecognitionConfig.VoiceActivityTimeout
	0,  // 8: google.cloud.speech.v1p1beta1.RecognitionConfig.encoding:type_name -> google.cloud.speech.v1p1beta1.RecognitionConfig.AudioEncoding
	26, // 9: google.cloud.speech.v1p1beta1.RecognitionConfig.adaptation:type_name -> google.cloud.speech.v1p1beta1.SpeechAdaptation
	27, // 10: google.cloud.speech.v1p1beta1.RecognitionConfig.transcript_normalization:type_name -> google.cloud.speech.v1p1beta1.TranscriptNormalization
	14, // 11: google.cloud.speech.v1p1beta1.RecognitionConfig.speech_contexts:type_name -> google.cloud.speech.v1p1beta1.SpeechContext
	28, // 12: google.cloud.speech.v1p1beta1.RecognitionConfig.enable_spoken_punctuation:type_name -> google.protobuf.BoolValue
	28, // 13: google.cloud.speech.v1p1beta1.RecognitionConfig.enable_spoken_emojis:type_name -> google.protobuf.BoolValue
	12, // 14: google.cloud.speech.v1p1beta1.RecognitionConfig.diarization_config:type_name -> google.cloud.speech.v1p1beta1.SpeakerDiarizationConfig
	13, // 15: google.cloud.speech.v1p1beta1.RecognitionConfig.metadata:type_name -> google.cloud.speech.v1p1beta1.RecognitionMetadata
	1,  // 16: google.cloud.speech.v1p1beta1.RecognitionMetadata.interaction_type:type_name -> google.cloud.speech.v1p1beta1.RecognitionMetadata.InteractionType
	2,  // 17: google.cloud.speech.v1p1beta1.RecognitionMetadata.microphone_distance:type_name -> google.cloud.speech.v1p1beta1.RecognitionMetadata.MicrophoneDistance
	3,  // 18: google.cloud.speech.v1p1beta1.RecognitionMetadata.original_media_type:type_name -> google.cloud.speech.v1p1beta1.RecognitionMetadata.OriginalMediaType
	4,  // 19: google.cloud.speech.v1p1beta1.RecognitionMetadata.recording_device_type:type_name -> google.cloud.speech.v1p1beta1.RecognitionMetadata.RecordingDeviceType
	21, // 20: google.cloud.speech.v1p1beta1.RecognizeResponse.results:type_name -> google.cloud.speech.v1p1beta1.SpeechRecognitionResult
	29, // 21: google.cloud.speech.v1p1beta1.RecognizeResponse.total_billed_time:type_name -> google.protobuf.Duration
	24, // 22: google.cloud.speech.v1p1beta1.RecognizeResponse.speech_adaptation_info:type_name -> google.cloud.speech.v1p1beta1.SpeechAdaptationInfo
	21, // 23: google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse.results:type_name -> google.cloud.speech.v1p1beta1.SpeechRecognitionResult
	29, // 24: google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse.total_billed_time:type_name -> google.protobuf.Duration
	8,  // 25: google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse.output_config:type_name -> google.cloud.speech.v1p1beta1.TranscriptOutputConfig
	30, // 26: google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse.output_error:type_name -> google.rpc.Status
	24, // 27: google.cloud.speech.v1p1beta1.LongRunningRecognizeResponse.speech_adaptation_info:type_name -> google.cloud.speech.v1p1beta1.SpeechAdaptationInfo
	31, // 28: google.cloud.speech.v1p1beta1.LongRunningRecognizeMetadata.start_time:type_name -> google.protobuf.Timestamp
	31, // 29: google.cloud.speech.v1p1beta1.LongRunningRecognizeMetadata.last_update_time:type_name -> google.protobuf.Timestamp
	8,  // 30: google.cloud.speech.v1p1beta1.LongRunningRecognizeMetadata.output_config:type_name -> google.cloud.speech.v1p1beta1.TranscriptOutputConfig
	30, // 31: google.cloud.speech.v1p1beta1.StreamingRecognizeResponse.error:type_name -> google.rpc.Status
	20, // 32: google.cloud.speech.v1p1beta1.StreamingRecognizeResponse.results:type_name -> google.cloud.speech.v1p1beta1.StreamingRecognitionResult
	5,  // 33: google.cloud.speech.v1p1beta1.StreamingRecognizeResponse.speech_event_type:type_name -> google.cloud.speech.v1p1beta1.StreamingRecognizeResponse.SpeechEventType
	29, // 34: google.cloud.speech.v1p1beta1.StreamingRecognizeResponse.speech_event_time:type_name -> google.protobuf.Duration
	29, // 35: google.cloud.speech.v1p1beta1.StreamingRecognizeResponse.total_billed_time:type_name -> google.protobuf.Duration
	24, // 36: google.cloud.speech.v1p1beta1.StreamingRecognizeResponse.speech_adaptation_info:type_name -> google.cloud.speech.v1p1beta1.SpeechAdaptationInfo
	22, // 37: google.cloud.speech.v1p1beta1.StreamingRecognitionResult.alternatives:type_name -> google.cloud.speech.v1p1beta1.SpeechRecognitionAlternative
	29, // 38: google.cloud.speech.v1p1beta1.StreamingRecognitionResult.result_end_time:type_name -> google.protobuf.Duration
	22, // 39: google.cloud.speech.v1p1beta1.SpeechRecognitionResult.alternatives:type_name -> google.cloud.speech.v1p1beta1.SpeechRecognitionAlternative
	29, // 40: google.cloud.speech.v1p1beta1.SpeechRecognitionResult.result_end_time:type_name -> google.protobuf.Duration
	23, // 41: google.cloud.speech.v1p1beta1.SpeechRecognitionAlternative.words:type_name -> google.cloud.speech.v1p1beta1.WordInfo
	29, // 42: google.cloud.speech.v1p1beta1.WordInfo.start_time:type_name -> google.protobuf.Duration
	29, // 43: google.cloud.speech.v1p1beta1.WordInfo.end_time:type_name -> google.protobuf.Duration
	29, // 44: google.cloud.speech.v1p1beta1.StreamingRecognitionConfig.VoiceActivityTimeout.speech_start_timeout:type_name -> google.protobuf.Duration
	29, // 45: google.cloud.speech.v1p1beta1.StreamingRecognitionConfig.VoiceActivityTimeout.speech_end_timeout:type_name -> google.protobuf.Duration
	6,  // 46: google.cloud.speech.v1p1beta1.Speech.Recognize:input_type -> google.cloud.speech.v1p1beta1.RecognizeRequest
	7,  // 47: google.cloud.speech.v1p1beta1.Speech.LongRunningRecognize:input_type -> google.cloud.speech.v1p1beta1.LongRunningRecognizeRequest
	9,  // 48: google.cloud.speech.v1p1beta1.Speech.StreamingRecognize:input_type -> google.cloud.speech.v1p1beta1.StreamingRecognizeRequest
	16, // 49: google.cloud.speech.v1p1beta1.Speech.Recognize:output_type -> google.cloud.speech.v1p1beta1.RecognizeResponse
	32, // 50: google.cloud.speech.v1p1beta1.Speech.LongRunningRecognize:output_type -> google.longrunning.Operation
	19, // 51: google.cloud.speech.v1p1beta1.Speech.StreamingRecognize:output_type -> google.cloud.speech.v1p1beta1.StreamingRecognizeResponse
	49, // [49:52] is the sub-list for method output_type
	46, // [46:49] is the sub-list for method input_type
	46, // [46:46] is the sub-list for extension type_name
	46, // [46:46] is the sub-list for extension extendee
	0,  // [0:46] is the sub-list for field type_name
}

func init() { file_google_cloud_speech_v1p1beta1_cloud_speech_proto_init() }
func file_google_cloud_speech_v1p1beta1_cloud_speech_proto_init() {
	if File_google_cloud_speech_v1p1beta1_cloud_speech_proto != nil {
		return
	}
	file_google_cloud_speech_v1p1beta1_resource_proto_init()
	file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[2].OneofWrappers = []any{
		(*TranscriptOutputConfig_GcsUri)(nil),
	}
	file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[3].OneofWrappers = []any{
		(*StreamingRecognizeRequest_StreamingConfig)(nil),
		(*StreamingRecognizeRequest_AudioContent)(nil),
	}
	file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes[9].OneofWrappers = []any{
		(*RecognitionAudio_Content)(nil),
		(*RecognitionAudio_Uri)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_speech_v1p1beta1_cloud_speech_proto_goTypes,
		DependencyIndexes: file_google_cloud_speech_v1p1beta1_cloud_speech_proto_depIdxs,
		EnumInfos:         file_google_cloud_speech_v1p1beta1_cloud_speech_proto_enumTypes,
		MessageInfos:      file_google_cloud_speech_v1p1beta1_cloud_speech_proto_msgTypes,
	}.Build()
	File_google_cloud_speech_v1p1beta1_cloud_speech_proto = out.File
	file_google_cloud_speech_v1p1beta1_cloud_speech_proto_rawDesc = nil
	file_google_cloud_speech_v1p1beta1_cloud_speech_proto_goTypes = nil
	file_google_cloud_speech_v1p1beta1_cloud_speech_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SpeechClient is the client API for Speech service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SpeechClient interface {
	// Performs synchronous speech recognition: receive results after all audio
	// has been sent and processed.
	Recognize(ctx context.Context, in *RecognizeRequest, opts ...grpc.CallOption) (*RecognizeResponse, error)
	// Performs asynchronous speech recognition: receive results via the
	// google.longrunning.Operations interface. Returns either an
	// `Operation.error` or an `Operation.response` which contains
	// a `LongRunningRecognizeResponse` message.
	// For more information on asynchronous speech recognition, see the
	// [how-to](https://cloud.google.com/speech-to-text/docs/async-recognize).
	LongRunningRecognize(ctx context.Context, in *LongRunningRecognizeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Performs bidirectional streaming speech recognition: receive results while
	// sending audio. This method is only available via the gRPC API (not REST).
	StreamingRecognize(ctx context.Context, opts ...grpc.CallOption) (Speech_StreamingRecognizeClient, error)
}

type speechClient struct {
	cc grpc.ClientConnInterface
}

func NewSpeechClient(cc grpc.ClientConnInterface) SpeechClient {
	return &speechClient{cc}
}

func (c *speechClient) Recognize(ctx context.Context, in *RecognizeRequest, opts ...grpc.CallOption) (*RecognizeResponse, error) {
	out := new(RecognizeResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.speech.v1p1beta1.Speech/Recognize", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) LongRunningRecognize(ctx context.Context, in *LongRunningRecognizeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.speech.v1p1beta1.Speech/LongRunningRecognize", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) StreamingRecognize(ctx context.Context, opts ...grpc.CallOption) (Speech_StreamingRecognizeClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Speech_serviceDesc.Streams[0], "/google.cloud.speech.v1p1beta1.Speech/StreamingRecognize", opts...)
	if err != nil {
		return nil, err
	}
	x := &speechStreamingRecognizeClient{stream}
	return x, nil
}

type Speech_StreamingRecognizeClient interface {
	Send(*StreamingRecognizeRequest) error
	Recv() (*StreamingRecognizeResponse, error)
	grpc.ClientStream
}

type speechStreamingRecognizeClient struct {
	grpc.ClientStream
}

func (x *speechStreamingRecognizeClient) Send(m *StreamingRecognizeRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *speechStreamingRecognizeClient) Recv() (*StreamingRecognizeResponse, error) {
	m := new(StreamingRecognizeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SpeechServer is the server API for Speech service.
type SpeechServer interface {
	// Performs synchronous speech recognition: receive results after all audio
	// has been sent and processed.
	Recognize(context.Context, *RecognizeRequest) (*RecognizeResponse, error)
	// Performs asynchronous speech recognition: receive results via the
	// google.longrunning.Operations interface. Returns either an
	// `Operation.error` or an `Operation.response` which contains
	// a `LongRunningRecognizeResponse` message.
	// For more information on asynchronous speech recognition, see the
	// [how-to](https://cloud.google.com/speech-to-text/docs/async-recognize).
	LongRunningRecognize(context.Context, *LongRunningRecognizeRequest) (*longrunningpb.Operation, error)
	// Performs bidirectional streaming speech recognition: receive results while
	// sending audio. This method is only available via the gRPC API (not REST).
	StreamingRecognize(Speech_StreamingRecognizeServer) error
}

// UnimplementedSpeechServer can be embedded to have forward compatible implementations.
type UnimplementedSpeechServer struct {
}

func (*UnimplementedSpeechServer) Recognize(context.Context, *RecognizeRequest) (*RecognizeResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method Recognize not implemented")
}
func (*UnimplementedSpeechServer) LongRunningRecognize(context.Context, *LongRunningRecognizeRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method LongRunningRecognize not implemented")
}
func (*UnimplementedSpeechServer) StreamingRecognize(Speech_StreamingRecognizeServer) error {
	return status1.Errorf(codes.Unimplemented, "method StreamingRecognize not implemented")
}

func RegisterSpeechServer(s *grpc.Server, srv SpeechServer) {
	s.RegisterService(&_Speech_serviceDesc, srv)
}

func _Speech_Recognize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RecognizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).Recognize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.speech.v1p1beta1.Speech/Recognize",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).Recognize(ctx, req.(*RecognizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_LongRunningRecognize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LongRunningRecognizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).LongRunningRecognize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.speech.v1p1beta1.Speech/LongRunningRecognize",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).LongRunningRecognize(ctx, req.(*LongRunningRecognizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_StreamingRecognize_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SpeechServer).StreamingRecognize(&speechStreamingRecognizeServer{stream})
}

type Speech_StreamingRecognizeServer interface {
	Send(*StreamingRecognizeResponse) error
	Recv() (*StreamingRecognizeRequest, error)
	grpc.ServerStream
}

type speechStreamingRecognizeServer struct {
	grpc.ServerStream
}

func (x *speechStreamingRecognizeServer) Send(m *StreamingRecognizeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *speechStreamingRecognizeServer) Recv() (*StreamingRecognizeRequest, error) {
	m := new(StreamingRecognizeRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Speech_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.speech.v1p1beta1.Speech",
	HandlerType: (*SpeechServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Recognize",
			Handler:    _Speech_Recognize_Handler,
		},
		{
			MethodName: "LongRunningRecognize",
			Handler:    _Speech_LongRunningRecognize_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingRecognize",
			Handler:       _Speech_StreamingRecognize_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/speech/v1p1beta1/cloud_speech.proto",
}
