// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.25.3
// source: google/cloud/recommendationengine/v1beta1/user_event.proto

package recommendationenginepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// User event source.
type UserEvent_EventSource int32

const (
	// Unspecified event source.
	UserEvent_EVENT_SOURCE_UNSPECIFIED UserEvent_EventSource = 0
	// The event is ingested via a javascript pixel or Recommendations AI Tag
	// through automl datalayer or JS Macros.
	UserEvent_AUTOML UserEvent_EventSource = 1
	// The event is ingested via Recommendations AI Tag through Enhanced
	// Ecommerce datalayer.
	UserEvent_ECOMMERCE UserEvent_EventSource = 2
	// The event is ingested via Import user events API.
	UserEvent_BATCH_UPLOAD UserEvent_EventSource = 3
)

// Enum value maps for UserEvent_EventSource.
var (
	UserEvent_EventSource_name = map[int32]string{
		0: "EVENT_SOURCE_UNSPECIFIED",
		1: "AUTOML",
		2: "ECOMMERCE",
		3: "BATCH_UPLOAD",
	}
	UserEvent_EventSource_value = map[string]int32{
		"EVENT_SOURCE_UNSPECIFIED": 0,
		"AUTOML":                   1,
		"ECOMMERCE":                2,
		"BATCH_UPLOAD":             3,
	}
)

func (x UserEvent_EventSource) Enum() *UserEvent_EventSource {
	p := new(UserEvent_EventSource)
	*p = x
	return p
}

func (x UserEvent_EventSource) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UserEvent_EventSource) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recommendationengine_v1beta1_user_event_proto_enumTypes[0].Descriptor()
}

func (UserEvent_EventSource) Type() protoreflect.EnumType {
	return &file_google_cloud_recommendationengine_v1beta1_user_event_proto_enumTypes[0]
}

func (x UserEvent_EventSource) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UserEvent_EventSource.Descriptor instead.
func (UserEvent_EventSource) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recommendationengine_v1beta1_user_event_proto_rawDescGZIP(), []int{0, 0}
}

// UserEvent captures all metadata information recommendation engine needs to
// know about how end users interact with customers' website.
type UserEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. User event type. Allowed values are:
	//
	//   - `add-to-cart` Products being added to cart.
	//   - `add-to-list` Items being added to a list (shopping list, favorites
	//     etc).
	//   - `category-page-view` Special pages such as sale or promotion pages
	//     viewed.
	//   - `checkout-start` User starting a checkout process.
	//   - `detail-page-view` Products detail page viewed.
	//   - `home-page-view` Homepage viewed.
	//   - `page-visit` Generic page visits not included in the event types above.
	//   - `purchase-complete` User finishing a purchase.
	//   - `refund` Purchased items being refunded or returned.
	//   - `remove-from-cart` Products being removed from cart.
	//   - `remove-from-list` Items being removed from a list.
	//   - `search` Product search.
	//   - `shopping-cart-page-view` User viewing a shopping cart.
	//   - `impression` List of items displayed. Used by Google Tag Manager.
	EventType string `protobuf:"bytes,1,opt,name=event_type,json=eventType,proto3" json:"event_type,omitempty"`
	// Required. User information.
	UserInfo *UserInfo `protobuf:"bytes,2,opt,name=user_info,json=userInfo,proto3" json:"user_info,omitempty"`
	// Optional. User event detailed information common across different
	// recommendation types.
	EventDetail *EventDetail `protobuf:"bytes,3,opt,name=event_detail,json=eventDetail,proto3" json:"event_detail,omitempty"`
	// Optional. Retail product specific user event metadata.
	//
	// This field is required for the following event types:
	//
	// * `add-to-cart`
	// * `add-to-list`
	// * `category-page-view`
	// * `checkout-start`
	// * `detail-page-view`
	// * `purchase-complete`
	// * `refund`
	// * `remove-from-cart`
	// * `remove-from-list`
	// * `search`
	//
	// This field is optional for the following event types:
	//
	//   - `page-visit`
	//   - `shopping-cart-page-view` - note that 'product_event_detail' should be
	//     set for this unless the shopping cart is empty.
	//
	// This field is not allowed for the following event types:
	//
	// * `home-page-view`
	ProductEventDetail *ProductEventDetail `protobuf:"bytes,4,opt,name=product_event_detail,json=productEventDetail,proto3" json:"product_event_detail,omitempty"`
	// Optional. Only required for ImportUserEvents method. Timestamp of user
	// event created.
	EventTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=event_time,json=eventTime,proto3" json:"event_time,omitempty"`
	// Optional. This field should *not* be set when using JavaScript pixel
	// or the Recommendations AI Tag. Defaults to `EVENT_SOURCE_UNSPECIFIED`.
	EventSource UserEvent_EventSource `protobuf:"varint,6,opt,name=event_source,json=eventSource,proto3,enum=google.cloud.recommendationengine.v1beta1.UserEvent_EventSource" json:"event_source,omitempty"`
}

func (x *UserEvent) Reset() {
	*x = UserEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recommendationengine_v1beta1_user_event_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserEvent) ProtoMessage() {}

func (x *UserEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recommendationengine_v1beta1_user_event_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserEvent.ProtoReflect.Descriptor instead.
func (*UserEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_recommendationengine_v1beta1_user_event_proto_rawDescGZIP(), []int{0}
}

func (x *UserEvent) GetEventType() string {
	if x != nil {
		return x.EventType
	}
	return ""
}

func (x *UserEvent) GetUserInfo() *UserInfo {
	if x != nil {
		return x.UserInfo
	}
	return nil
}

func (x *UserEvent) GetEventDetail() *EventDetail {
	if x != nil {
		return x.EventDetail
	}
	return nil
}

func (x *UserEvent) GetProductEventDetail() *ProductEventDetail {
	if x != nil {
		return x.ProductEventDetail
	}
	return nil
}

func (x *UserEvent) GetEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EventTime
	}
	return nil
}

func (x *UserEvent) GetEventSource() UserEvent_EventSource {
	if x != nil {
		return x.EventSource
	}
	return UserEvent_EVENT_SOURCE_UNSPECIFIED
}

// Information of end users.
type UserInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A unique identifier for tracking visitors with a length limit of
	// 128 bytes.
	//
	// For example, this could be implemented with a http cookie, which should be
	// able to uniquely identify a visitor on a single device. This unique
	// identifier should not change if the visitor log in/out of the website.
	// Maximum length 128 bytes. Cannot be empty.
	VisitorId string `protobuf:"bytes,1,opt,name=visitor_id,json=visitorId,proto3" json:"visitor_id,omitempty"`
	// Optional. Unique identifier for logged-in user with a length limit of 128
	// bytes. Required only for logged-in users.
	UserId string `protobuf:"bytes,2,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Optional. IP address of the user. This could be either IPv4 (e.g. 104.133.9.80) or
	// IPv6 (e.g. 2001:0db8:85a3:0000:0000:8a2e:0370:7334). This should *not* be
	// set when using the javascript pixel or if `direct_user_request` is set.
	// Used to extract location information for personalization.
	IpAddress string `protobuf:"bytes,3,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	// Optional. User agent as included in the HTTP header. UTF-8 encoded string
	// with a length limit of 1 KiB.
	//
	// This should *not* be set when using the JavaScript pixel or if
	// `directUserRequest` is set.
	UserAgent string `protobuf:"bytes,4,opt,name=user_agent,json=userAgent,proto3" json:"user_agent,omitempty"`
	// Optional. Indicates if the request is made directly from the end user
	// in which case the user_agent and ip_address fields can be populated
	// from the HTTP request. This should *not* be set when using the javascript
	// pixel. This flag should be set only if the API request is made directly
	// from the end user such as a mobile app (and not if a gateway or a server is
	// processing and pushing the user events).
	DirectUserRequest bool `protobuf:"varint,5,opt,name=direct_user_request,json=directUserRequest,proto3" json:"direct_user_request,omitempty"`
}

func (x *UserInfo) Reset() {
	*x = UserInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recommendationengine_v1beta1_user_event_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserInfo) ProtoMessage() {}

func (x *UserInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recommendationengine_v1beta1_user_event_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserInfo.ProtoReflect.Descriptor instead.
func (*UserInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_recommendationengine_v1beta1_user_event_proto_rawDescGZIP(), []int{1}
}

func (x *UserInfo) GetVisitorId() string {
	if x != nil {
		return x.VisitorId
	}
	return ""
}

func (x *UserInfo) GetUserId() string {
	if x != nil {
		return x.UserId
	}
	return ""
}

func (x *UserInfo) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

func (x *UserInfo) GetUserAgent() string {
	if x != nil {
		return x.UserAgent
	}
	return ""
}

func (x *UserInfo) GetDirectUserRequest() bool {
	if x != nil {
		return x.DirectUserRequest
	}
	return false
}

// User event details shared by all recommendation types.
type EventDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Complete url (window.location.href) of the user's current page.
	// When using the JavaScript pixel, this value is filled in automatically.
	// Maximum length 5KB.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// Optional. The referrer url of the current page. When using
	// the JavaScript pixel, this value is filled in automatically.
	ReferrerUri string `protobuf:"bytes,6,opt,name=referrer_uri,json=referrerUri,proto3" json:"referrer_uri,omitempty"`
	// Optional. A unique id of a web page view.
	// This should be kept the same for all user events triggered from the same
	// pageview. For example, an item detail page view could trigger multiple
	// events as the user is browsing the page.
	// The `pageViewId` property should be kept the same for all these events so
	// that they can be grouped together properly. This `pageViewId` will be
	// automatically generated if using the JavaScript pixel.
	PageViewId string `protobuf:"bytes,2,opt,name=page_view_id,json=pageViewId,proto3" json:"page_view_id,omitempty"`
	// Optional. A list of identifiers for the independent experiment groups
	// this user event belongs to. This is used to distinguish between user events
	// associated with different experiment setups (e.g. using Recommendation
	// Engine system, using different recommendation models).
	ExperimentIds []string `protobuf:"bytes,3,rep,name=experiment_ids,json=experimentIds,proto3" json:"experiment_ids,omitempty"`
	// Optional. Recommendation token included in the recommendation prediction
	// response.
	//
	// This field enables accurate attribution of recommendation model
	// performance.
	//
	// This token enables us to accurately attribute page view or purchase back to
	// the event and the particular predict response containing this
	// clicked/purchased item. If user clicks on product K in the recommendation
	// results, pass the `PredictResponse.recommendationToken` property as a url
	// parameter to product K's page. When recording events on product K's page,
	// log the PredictResponse.recommendation_token to this field.
	//
	// Optional, but highly encouraged for user events that are the result of a
	// recommendation prediction query.
	RecommendationToken string `protobuf:"bytes,4,opt,name=recommendation_token,json=recommendationToken,proto3" json:"recommendation_token,omitempty"`
	// Optional. Extra user event features to include in the recommendation
	// model.
	//
	// For product recommendation, an example of extra user information is
	// traffic_channel, i.e. how user arrives at the site. Users can arrive
	// at the site by coming to the site directly, or coming through Google
	// search, and etc.
	EventAttributes *FeatureMap `protobuf:"bytes,5,opt,name=event_attributes,json=eventAttributes,proto3" json:"event_attributes,omitempty"`
}

func (x *EventDetail) Reset() {
	*x = EventDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recommendationengine_v1beta1_user_event_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventDetail) ProtoMessage() {}

func (x *EventDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recommendationengine_v1beta1_user_event_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventDetail.ProtoReflect.Descriptor instead.
func (*EventDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_recommendationengine_v1beta1_user_event_proto_rawDescGZIP(), []int{2}
}

func (x *EventDetail) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *EventDetail) GetReferrerUri() string {
	if x != nil {
		return x.ReferrerUri
	}
	return ""
}

func (x *EventDetail) GetPageViewId() string {
	if x != nil {
		return x.PageViewId
	}
	return ""
}

func (x *EventDetail) GetExperimentIds() []string {
	if x != nil {
		return x.ExperimentIds
	}
	return nil
}

func (x *EventDetail) GetRecommendationToken() string {
	if x != nil {
		return x.RecommendationToken
	}
	return ""
}

func (x *EventDetail) GetEventAttributes() *FeatureMap {
	if x != nil {
		return x.EventAttributes
	}
	return nil
}

// ProductEventDetail captures user event information specific to retail
// products.
type ProductEventDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required for `search` events. Other event types should not set this field.
	// The user's search query as UTF-8 encoded text with a length limit of 5 KiB.
	SearchQuery string `protobuf:"bytes,1,opt,name=search_query,json=searchQuery,proto3" json:"search_query,omitempty"`
	// Required for `category-page-view` events. Other event types should not set
	// this field.
	// The categories associated with a category page.
	// Category pages include special pages such as sales or promotions. For
	// instance, a special sale page may have the category hierarchy:
	// categories : ["Sales", "2017 Black Friday Deals"].
	PageCategories []*CatalogItem_CategoryHierarchy `protobuf:"bytes,2,rep,name=page_categories,json=pageCategories,proto3" json:"page_categories,omitempty"`
	// The main product details related to the event.
	//
	// This field is required for the following event types:
	//
	// * `add-to-cart`
	// * `add-to-list`
	// * `checkout-start`
	// * `detail-page-view`
	// * `purchase-complete`
	// * `refund`
	// * `remove-from-cart`
	// * `remove-from-list`
	//
	// This field is optional for the following event types:
	//
	//   - `page-visit`
	//   - `shopping-cart-page-view` - note that 'product_details' should be set for
	//     this unless the shopping cart is empty.
	//
	// This field is not allowed for the following event types:
	//
	// * `category-page-view`
	// * `home-page-view`
	// * `search`
	ProductDetails []*ProductDetail `protobuf:"bytes,3,rep,name=product_details,json=productDetails,proto3" json:"product_details,omitempty"`
	// Required for `add-to-list` and `remove-from-list` events. The id or name of
	// the list that the item is being added to or removed from. Other event types
	// should not set this field.
	ListId string `protobuf:"bytes,4,opt,name=list_id,json=listId,proto3" json:"list_id,omitempty"`
	// Optional. The id or name of the associated shopping cart. This id is used
	// to associate multiple items added or present in the cart before purchase.
	//
	// This can only be set for `add-to-cart`, `remove-from-cart`,
	// `checkout-start`, `purchase-complete`, or `shopping-cart-page-view` events.
	CartId string `protobuf:"bytes,5,opt,name=cart_id,json=cartId,proto3" json:"cart_id,omitempty"`
	// Optional. A transaction represents the entire purchase transaction.
	// Required for `purchase-complete` events. Optional for `checkout-start`
	// events. Other event types should not set this field.
	PurchaseTransaction *PurchaseTransaction `protobuf:"bytes,6,opt,name=purchase_transaction,json=purchaseTransaction,proto3" json:"purchase_transaction,omitempty"`
}

func (x *ProductEventDetail) Reset() {
	*x = ProductEventDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recommendationengine_v1beta1_user_event_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductEventDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductEventDetail) ProtoMessage() {}

func (x *ProductEventDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recommendationengine_v1beta1_user_event_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductEventDetail.ProtoReflect.Descriptor instead.
func (*ProductEventDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_recommendationengine_v1beta1_user_event_proto_rawDescGZIP(), []int{3}
}

func (x *ProductEventDetail) GetSearchQuery() string {
	if x != nil {
		return x.SearchQuery
	}
	return ""
}

func (x *ProductEventDetail) GetPageCategories() []*CatalogItem_CategoryHierarchy {
	if x != nil {
		return x.PageCategories
	}
	return nil
}

func (x *ProductEventDetail) GetProductDetails() []*ProductDetail {
	if x != nil {
		return x.ProductDetails
	}
	return nil
}

func (x *ProductEventDetail) GetListId() string {
	if x != nil {
		return x.ListId
	}
	return ""
}

func (x *ProductEventDetail) GetCartId() string {
	if x != nil {
		return x.CartId
	}
	return ""
}

func (x *ProductEventDetail) GetPurchaseTransaction() *PurchaseTransaction {
	if x != nil {
		return x.PurchaseTransaction
	}
	return nil
}

// A transaction represents the entire purchase transaction.
type PurchaseTransaction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The transaction ID with a length limit of 128 bytes.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Required. Total revenue or grand total associated with the transaction.
	// This value include shipping, tax, or other adjustments to total revenue
	// that you want to include as part of your revenue calculations. This field
	// is not required if the event type is `refund`.
	Revenue float32 `protobuf:"fixed32,2,opt,name=revenue,proto3" json:"revenue,omitempty"`
	// Optional. All the taxes associated with the transaction.
	Taxes map[string]float32 `protobuf:"bytes,3,rep,name=taxes,proto3" json:"taxes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed32,2,opt,name=value,proto3"`
	// Optional. All the costs associated with the product. These can be
	// manufacturing costs, shipping expenses not borne by the end user, or any
	// other costs.
	//
	// Total product cost such that
	//
	//	profit = revenue - (sum(taxes) + sum(costs))
	//
	// If product_cost is not set, then
	//
	//	profit = revenue - tax - shipping - sum(CatalogItem.costs).
	//
	// If CatalogItem.cost is not specified for one of the items, CatalogItem.cost
	// based profit *cannot* be calculated for this Transaction.
	Costs map[string]float32 `protobuf:"bytes,4,rep,name=costs,proto3" json:"costs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed32,2,opt,name=value,proto3"`
	// Required. Currency code. Use three-character ISO-4217 code. This field
	// is not required if the event type is `refund`.
	CurrencyCode string `protobuf:"bytes,6,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
}

func (x *PurchaseTransaction) Reset() {
	*x = PurchaseTransaction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recommendationengine_v1beta1_user_event_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PurchaseTransaction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PurchaseTransaction) ProtoMessage() {}

func (x *PurchaseTransaction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recommendationengine_v1beta1_user_event_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PurchaseTransaction.ProtoReflect.Descriptor instead.
func (*PurchaseTransaction) Descriptor() ([]byte, []int) {
	return file_google_cloud_recommendationengine_v1beta1_user_event_proto_rawDescGZIP(), []int{4}
}

func (x *PurchaseTransaction) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *PurchaseTransaction) GetRevenue() float32 {
	if x != nil {
		return x.Revenue
	}
	return 0
}

func (x *PurchaseTransaction) GetTaxes() map[string]float32 {
	if x != nil {
		return x.Taxes
	}
	return nil
}

func (x *PurchaseTransaction) GetCosts() map[string]float32 {
	if x != nil {
		return x.Costs
	}
	return nil
}

func (x *PurchaseTransaction) GetCurrencyCode() string {
	if x != nil {
		return x.CurrencyCode
	}
	return ""
}

// Detailed product information associated with a user event.
type ProductDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Catalog item ID. UTF-8 encoded string with a length limit of 128
	// characters.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Optional. Currency code for price/costs. Use three-character ISO-4217
	// code. Required only if originalPrice or displayPrice is set.
	CurrencyCode string `protobuf:"bytes,2,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// Optional. Original price of the product. If provided, this will override
	// the original price in Catalog for this product.
	OriginalPrice float32 `protobuf:"fixed32,3,opt,name=original_price,json=originalPrice,proto3" json:"original_price,omitempty"`
	// Optional. Display price of the product (e.g. discounted price). If
	// provided, this will override the display price in Catalog for this product.
	DisplayPrice float32 `protobuf:"fixed32,4,opt,name=display_price,json=displayPrice,proto3" json:"display_price,omitempty"`
	// Optional. Item stock state. If provided, this overrides the stock state
	// in Catalog for items in this event.
	StockState ProductCatalogItem_StockState `protobuf:"varint,5,opt,name=stock_state,json=stockState,proto3,enum=google.cloud.recommendationengine.v1beta1.ProductCatalogItem_StockState" json:"stock_state,omitempty"`
	// Optional. Quantity of the product associated with the user event. For
	// example, this field will be 2 if two products are added to the shopping
	// cart for `add-to-cart` event. Required for `add-to-cart`, `add-to-list`,
	// `remove-from-cart`, `checkout-start`, `purchase-complete`, `refund` event
	// types.
	Quantity int32 `protobuf:"varint,6,opt,name=quantity,proto3" json:"quantity,omitempty"`
	// Optional. Quantity of the products in stock when a user event happens.
	// Optional. If provided, this overrides the available quantity in Catalog for
	// this event. and can only be set if `stock_status` is set to `IN_STOCK`.
	//
	// Note that if an item is out of stock, you must set the `stock_state` field
	// to be `OUT_OF_STOCK`. Leaving this field unspecified / as zero is not
	// sufficient to mark the item out of stock.
	AvailableQuantity int32 `protobuf:"varint,7,opt,name=available_quantity,json=availableQuantity,proto3" json:"available_quantity,omitempty"`
	// Optional. Extra features associated with a product in the user event.
	ItemAttributes *FeatureMap `protobuf:"bytes,8,opt,name=item_attributes,json=itemAttributes,proto3" json:"item_attributes,omitempty"`
}

func (x *ProductDetail) Reset() {
	*x = ProductDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recommendationengine_v1beta1_user_event_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductDetail) ProtoMessage() {}

func (x *ProductDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recommendationengine_v1beta1_user_event_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductDetail.ProtoReflect.Descriptor instead.
func (*ProductDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_recommendationengine_v1beta1_user_event_proto_rawDescGZIP(), []int{5}
}

func (x *ProductDetail) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ProductDetail) GetCurrencyCode() string {
	if x != nil {
		return x.CurrencyCode
	}
	return ""
}

func (x *ProductDetail) GetOriginalPrice() float32 {
	if x != nil {
		return x.OriginalPrice
	}
	return 0
}

func (x *ProductDetail) GetDisplayPrice() float32 {
	if x != nil {
		return x.DisplayPrice
	}
	return 0
}

func (x *ProductDetail) GetStockState() ProductCatalogItem_StockState {
	if x != nil {
		return x.StockState
	}
	return ProductCatalogItem_STOCK_STATE_UNSPECIFIED
}

func (x *ProductDetail) GetQuantity() int32 {
	if x != nil {
		return x.Quantity
	}
	return 0
}

func (x *ProductDetail) GetAvailableQuantity() int32 {
	if x != nil {
		return x.AvailableQuantity
	}
	return 0
}

func (x *ProductDetail) GetItemAttributes() *FeatureMap {
	if x != nil {
		return x.ItemAttributes
	}
	return nil
}

var File_google_cloud_recommendationengine_v1beta1_user_event_proto protoreflect.FileDescriptor

var file_google_cloud_recommendationengine_v1beta1_user_event_proto_rawDesc = []byte{
	0x0a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x29, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe0, 0x04, 0x0a, 0x09, 0x55,
	0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x55, 0x0a, 0x09,
	0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x5e, 0x0a, 0x0c, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x12, 0x74, 0x0a, 0x14, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x3e, 0x0a, 0x0a, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x68, 0x0a, 0x0c, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x22, 0x58, 0x0a, 0x0b, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x4f, 0x55, 0x52,
	0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0a, 0x0a, 0x06, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x4c, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09,
	0x45, 0x43, 0x4f, 0x4d, 0x4d, 0x45, 0x52, 0x43, 0x45, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x42,
	0x41, 0x54, 0x43, 0x48, 0x5f, 0x55, 0x50, 0x4c, 0x4f, 0x41, 0x44, 0x10, 0x03, 0x22, 0xc9, 0x01,
	0x0a, 0x08, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x22, 0x0a, 0x0a, 0x76, 0x69,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x76, 0x69, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x49, 0x64, 0x12, 0x1c,
	0x0a, 0x07, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a,
	0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x12, 0x22, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x12, 0x33, 0x0a, 0x13, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x55, 0x73,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0xbe, 0x02, 0x0a, 0x0b, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x69,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x03, 0x75, 0x72, 0x69,
	0x12, 0x26, 0x0a, 0x0c, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x72, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x72, 0x65, 0x72, 0x55, 0x72, 0x69, 0x12, 0x25, 0x0a, 0x0c, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x56, 0x69, 0x65, 0x77, 0x49, 0x64, 0x12,
	0x2a, 0x0a, 0x0e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x73, 0x12, 0x36, 0x0a, 0x14, 0x72,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13,
	0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x65, 0x0a, 0x10, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x4d, 0x61, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x22, 0xbc, 0x03, 0x0a, 0x12, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x12, 0x71, 0x0a, 0x0f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x49, 0x74, 0x65, 0x6d, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x48, 0x69,
	0x65, 0x72, 0x61, 0x72, 0x63, 0x68, 0x79, 0x52, 0x0e, 0x70, 0x61, 0x67, 0x65, 0x43, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x61, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x17, 0x0a, 0x07, 0x6c, 0x69,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6c, 0x69, 0x73,
	0x74, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x07, 0x63, 0x61, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x63, 0x61, 0x72, 0x74, 0x49,
	0x64, 0x12, 0x76, 0x0a, 0x14, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x72, 0x63,
	0x68, 0x61, 0x73, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb3, 0x03, 0x0a, 0x13, 0x50, 0x75,
	0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1d, 0x0a, 0x07, 0x72, 0x65, 0x76, 0x65, 0x6e, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x72, 0x65,
	0x76, 0x65, 0x6e, 0x75, 0x65, 0x12, 0x64, 0x0a, 0x05, 0x74, 0x61, 0x78, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x61, 0x78, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x74, 0x61, 0x78, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x05, 0x63,
	0x6f, 0x73, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x73, 0x74, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x63, 0x6f, 0x73, 0x74,
	0x73, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x1a, 0x38, 0x0a, 0x0a, 0x54,
	0x61, 0x78, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x38, 0x0a, 0x0a, 0x43, 0x6f, 0x73, 0x74, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0xce, 0x03, 0x0a, 0x0d, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x02, 0x69, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x64, 0x65,
	0x12, 0x2a, 0x0a, 0x0e, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x72, 0x69,
	0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6f,
	0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x50, 0x72, 0x69, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x0d,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x50, 0x72, 0x69, 0x63, 0x65, 0x12, 0x6e, 0x0a, 0x0b, 0x73, 0x74, 0x6f, 0x63, 0x6b, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x49, 0x74, 0x65, 0x6d, 0x2e, 0x53, 0x74, 0x6f, 0x63, 0x6b,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x73, 0x74, 0x6f, 0x63,
	0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x71,
	0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x32, 0x0a, 0x12, 0x61, 0x76, 0x61, 0x69, 0x6c,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61,
	0x62, 0x6c, 0x65, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x63, 0x0a, 0x0f, 0x69,
	0x74, 0x65, 0x6d, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4d, 0x61, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0e, 0x69, 0x74, 0x65, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x42, 0xa3, 0x02, 0x0a, 0x2d, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x50, 0x01, 0x5a, 0x61, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62,
	0x3b, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0xa2, 0x02, 0x05, 0x52, 0x45, 0x43, 0x41, 0x49, 0xaa,
	0x02, 0x29, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x52,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x29, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x52, 0x65, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c,
	0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x2c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_recommendationengine_v1beta1_user_event_proto_rawDescOnce sync.Once
	file_google_cloud_recommendationengine_v1beta1_user_event_proto_rawDescData = file_google_cloud_recommendationengine_v1beta1_user_event_proto_rawDesc
)

func file_google_cloud_recommendationengine_v1beta1_user_event_proto_rawDescGZIP() []byte {
	file_google_cloud_recommendationengine_v1beta1_user_event_proto_rawDescOnce.Do(func() {
		file_google_cloud_recommendationengine_v1beta1_user_event_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_recommendationengine_v1beta1_user_event_proto_rawDescData)
	})
	return file_google_cloud_recommendationengine_v1beta1_user_event_proto_rawDescData
}

var file_google_cloud_recommendationengine_v1beta1_user_event_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_recommendationengine_v1beta1_user_event_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_recommendationengine_v1beta1_user_event_proto_goTypes = []interface{}{
	(UserEvent_EventSource)(0),            // 0: google.cloud.recommendationengine.v1beta1.UserEvent.EventSource
	(*UserEvent)(nil),                     // 1: google.cloud.recommendationengine.v1beta1.UserEvent
	(*UserInfo)(nil),                      // 2: google.cloud.recommendationengine.v1beta1.UserInfo
	(*EventDetail)(nil),                   // 3: google.cloud.recommendationengine.v1beta1.EventDetail
	(*ProductEventDetail)(nil),            // 4: google.cloud.recommendationengine.v1beta1.ProductEventDetail
	(*PurchaseTransaction)(nil),           // 5: google.cloud.recommendationengine.v1beta1.PurchaseTransaction
	(*ProductDetail)(nil),                 // 6: google.cloud.recommendationengine.v1beta1.ProductDetail
	nil,                                   // 7: google.cloud.recommendationengine.v1beta1.PurchaseTransaction.TaxesEntry
	nil,                                   // 8: google.cloud.recommendationengine.v1beta1.PurchaseTransaction.CostsEntry
	(*timestamppb.Timestamp)(nil),         // 9: google.protobuf.Timestamp
	(*FeatureMap)(nil),                    // 10: google.cloud.recommendationengine.v1beta1.FeatureMap
	(*CatalogItem_CategoryHierarchy)(nil), // 11: google.cloud.recommendationengine.v1beta1.CatalogItem.CategoryHierarchy
	(ProductCatalogItem_StockState)(0),    // 12: google.cloud.recommendationengine.v1beta1.ProductCatalogItem.StockState
}
var file_google_cloud_recommendationengine_v1beta1_user_event_proto_depIdxs = []int32{
	2,  // 0: google.cloud.recommendationengine.v1beta1.UserEvent.user_info:type_name -> google.cloud.recommendationengine.v1beta1.UserInfo
	3,  // 1: google.cloud.recommendationengine.v1beta1.UserEvent.event_detail:type_name -> google.cloud.recommendationengine.v1beta1.EventDetail
	4,  // 2: google.cloud.recommendationengine.v1beta1.UserEvent.product_event_detail:type_name -> google.cloud.recommendationengine.v1beta1.ProductEventDetail
	9,  // 3: google.cloud.recommendationengine.v1beta1.UserEvent.event_time:type_name -> google.protobuf.Timestamp
	0,  // 4: google.cloud.recommendationengine.v1beta1.UserEvent.event_source:type_name -> google.cloud.recommendationengine.v1beta1.UserEvent.EventSource
	10, // 5: google.cloud.recommendationengine.v1beta1.EventDetail.event_attributes:type_name -> google.cloud.recommendationengine.v1beta1.FeatureMap
	11, // 6: google.cloud.recommendationengine.v1beta1.ProductEventDetail.page_categories:type_name -> google.cloud.recommendationengine.v1beta1.CatalogItem.CategoryHierarchy
	6,  // 7: google.cloud.recommendationengine.v1beta1.ProductEventDetail.product_details:type_name -> google.cloud.recommendationengine.v1beta1.ProductDetail
	5,  // 8: google.cloud.recommendationengine.v1beta1.ProductEventDetail.purchase_transaction:type_name -> google.cloud.recommendationengine.v1beta1.PurchaseTransaction
	7,  // 9: google.cloud.recommendationengine.v1beta1.PurchaseTransaction.taxes:type_name -> google.cloud.recommendationengine.v1beta1.PurchaseTransaction.TaxesEntry
	8,  // 10: google.cloud.recommendationengine.v1beta1.PurchaseTransaction.costs:type_name -> google.cloud.recommendationengine.v1beta1.PurchaseTransaction.CostsEntry
	12, // 11: google.cloud.recommendationengine.v1beta1.ProductDetail.stock_state:type_name -> google.cloud.recommendationengine.v1beta1.ProductCatalogItem.StockState
	10, // 12: google.cloud.recommendationengine.v1beta1.ProductDetail.item_attributes:type_name -> google.cloud.recommendationengine.v1beta1.FeatureMap
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_cloud_recommendationengine_v1beta1_user_event_proto_init() }
func file_google_cloud_recommendationengine_v1beta1_user_event_proto_init() {
	if File_google_cloud_recommendationengine_v1beta1_user_event_proto != nil {
		return
	}
	file_google_cloud_recommendationengine_v1beta1_catalog_proto_init()
	file_google_cloud_recommendationengine_v1beta1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_recommendationengine_v1beta1_user_event_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recommendationengine_v1beta1_user_event_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recommendationengine_v1beta1_user_event_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recommendationengine_v1beta1_user_event_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductEventDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recommendationengine_v1beta1_user_event_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PurchaseTransaction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recommendationengine_v1beta1_user_event_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_recommendationengine_v1beta1_user_event_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_recommendationengine_v1beta1_user_event_proto_goTypes,
		DependencyIndexes: file_google_cloud_recommendationengine_v1beta1_user_event_proto_depIdxs,
		EnumInfos:         file_google_cloud_recommendationengine_v1beta1_user_event_proto_enumTypes,
		MessageInfos:      file_google_cloud_recommendationengine_v1beta1_user_event_proto_msgTypes,
	}.Build()
	File_google_cloud_recommendationengine_v1beta1_user_event_proto = out.File
	file_google_cloud_recommendationengine_v1beta1_user_event_proto_rawDesc = nil
	file_google_cloud_recommendationengine_v1beta1_user_event_proto_goTypes = nil
	file_google_cloud_recommendationengine_v1beta1_user_event_proto_depIdxs = nil
}
