// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/networkmanagement/v1/vpc_flow_logs.proto

package networkmanagementpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	VpcFlowLogsService_ListVpcFlowLogsConfigs_FullMethodName  = "/google.cloud.networkmanagement.v1.VpcFlowLogsService/ListVpcFlowLogsConfigs"
	VpcFlowLogsService_GetVpcFlowLogsConfig_FullMethodName    = "/google.cloud.networkmanagement.v1.VpcFlowLogsService/GetVpcFlowLogsConfig"
	VpcFlowLogsService_CreateVpcFlowLogsConfig_FullMethodName = "/google.cloud.networkmanagement.v1.VpcFlowLogsService/CreateVpcFlowLogsConfig"
	VpcFlowLogsService_UpdateVpcFlowLogsConfig_FullMethodName = "/google.cloud.networkmanagement.v1.VpcFlowLogsService/UpdateVpcFlowLogsConfig"
	VpcFlowLogsService_DeleteVpcFlowLogsConfig_FullMethodName = "/google.cloud.networkmanagement.v1.VpcFlowLogsService/DeleteVpcFlowLogsConfig"
)

// VpcFlowLogsServiceClient is the client API for VpcFlowLogsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type VpcFlowLogsServiceClient interface {
	// Lists all `VpcFlowLogsConfigs` in a given project.
	ListVpcFlowLogsConfigs(ctx context.Context, in *ListVpcFlowLogsConfigsRequest, opts ...grpc.CallOption) (*ListVpcFlowLogsConfigsResponse, error)
	// Gets the details of a specific `VpcFlowLogsConfig`.
	GetVpcFlowLogsConfig(ctx context.Context, in *GetVpcFlowLogsConfigRequest, opts ...grpc.CallOption) (*VpcFlowLogsConfig, error)
	// Creates a new `VpcFlowLogsConfig`.
	// If a configuration with the exact same settings already exists (even if the
	// ID is different), the creation fails.
	// Notes:
	//
	//  1. Creating a configuration with state=DISABLED will fail
	//  2. The following fields are not considered as `settings` for the purpose
	//     of the check mentioned above, therefore - creating another configuration
	//     with the same fields but different values for the following fields will
	//     fail as well:
	//     * name
	//     * create_time
	//     * update_time
	//     * labels
	//     * description
	CreateVpcFlowLogsConfig(ctx context.Context, in *CreateVpcFlowLogsConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an existing `VpcFlowLogsConfig`.
	// If a configuration with the exact same settings already exists (even if the
	// ID is different), the creation fails.
	// Notes:
	//
	//  1. Updating a configuration with state=DISABLED will fail.
	//  2. The following fields are not considered as `settings` for the purpose
	//     of the check mentioned above, therefore - updating another configuration
	//     with the same fields but different values for the following fields will
	//     fail as well:
	//     * name
	//     * create_time
	//     * update_time
	//     * labels
	//     * description
	UpdateVpcFlowLogsConfig(ctx context.Context, in *UpdateVpcFlowLogsConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a specific `VpcFlowLogsConfig`.
	DeleteVpcFlowLogsConfig(ctx context.Context, in *DeleteVpcFlowLogsConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type vpcFlowLogsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewVpcFlowLogsServiceClient(cc grpc.ClientConnInterface) VpcFlowLogsServiceClient {
	return &vpcFlowLogsServiceClient{cc}
}

func (c *vpcFlowLogsServiceClient) ListVpcFlowLogsConfigs(ctx context.Context, in *ListVpcFlowLogsConfigsRequest, opts ...grpc.CallOption) (*ListVpcFlowLogsConfigsResponse, error) {
	out := new(ListVpcFlowLogsConfigsResponse)
	err := c.cc.Invoke(ctx, VpcFlowLogsService_ListVpcFlowLogsConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vpcFlowLogsServiceClient) GetVpcFlowLogsConfig(ctx context.Context, in *GetVpcFlowLogsConfigRequest, opts ...grpc.CallOption) (*VpcFlowLogsConfig, error) {
	out := new(VpcFlowLogsConfig)
	err := c.cc.Invoke(ctx, VpcFlowLogsService_GetVpcFlowLogsConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vpcFlowLogsServiceClient) CreateVpcFlowLogsConfig(ctx context.Context, in *CreateVpcFlowLogsConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VpcFlowLogsService_CreateVpcFlowLogsConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vpcFlowLogsServiceClient) UpdateVpcFlowLogsConfig(ctx context.Context, in *UpdateVpcFlowLogsConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VpcFlowLogsService_UpdateVpcFlowLogsConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vpcFlowLogsServiceClient) DeleteVpcFlowLogsConfig(ctx context.Context, in *DeleteVpcFlowLogsConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VpcFlowLogsService_DeleteVpcFlowLogsConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VpcFlowLogsServiceServer is the server API for VpcFlowLogsService service.
// All implementations should embed UnimplementedVpcFlowLogsServiceServer
// for forward compatibility
type VpcFlowLogsServiceServer interface {
	// Lists all `VpcFlowLogsConfigs` in a given project.
	ListVpcFlowLogsConfigs(context.Context, *ListVpcFlowLogsConfigsRequest) (*ListVpcFlowLogsConfigsResponse, error)
	// Gets the details of a specific `VpcFlowLogsConfig`.
	GetVpcFlowLogsConfig(context.Context, *GetVpcFlowLogsConfigRequest) (*VpcFlowLogsConfig, error)
	// Creates a new `VpcFlowLogsConfig`.
	// If a configuration with the exact same settings already exists (even if the
	// ID is different), the creation fails.
	// Notes:
	//
	//  1. Creating a configuration with state=DISABLED will fail
	//  2. The following fields are not considered as `settings` for the purpose
	//     of the check mentioned above, therefore - creating another configuration
	//     with the same fields but different values for the following fields will
	//     fail as well:
	//     * name
	//     * create_time
	//     * update_time
	//     * labels
	//     * description
	CreateVpcFlowLogsConfig(context.Context, *CreateVpcFlowLogsConfigRequest) (*longrunningpb.Operation, error)
	// Updates an existing `VpcFlowLogsConfig`.
	// If a configuration with the exact same settings already exists (even if the
	// ID is different), the creation fails.
	// Notes:
	//
	//  1. Updating a configuration with state=DISABLED will fail.
	//  2. The following fields are not considered as `settings` for the purpose
	//     of the check mentioned above, therefore - updating another configuration
	//     with the same fields but different values for the following fields will
	//     fail as well:
	//     * name
	//     * create_time
	//     * update_time
	//     * labels
	//     * description
	UpdateVpcFlowLogsConfig(context.Context, *UpdateVpcFlowLogsConfigRequest) (*longrunningpb.Operation, error)
	// Deletes a specific `VpcFlowLogsConfig`.
	DeleteVpcFlowLogsConfig(context.Context, *DeleteVpcFlowLogsConfigRequest) (*longrunningpb.Operation, error)
}

// UnimplementedVpcFlowLogsServiceServer should be embedded to have forward compatible implementations.
type UnimplementedVpcFlowLogsServiceServer struct {
}

func (UnimplementedVpcFlowLogsServiceServer) ListVpcFlowLogsConfigs(context.Context, *ListVpcFlowLogsConfigsRequest) (*ListVpcFlowLogsConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVpcFlowLogsConfigs not implemented")
}
func (UnimplementedVpcFlowLogsServiceServer) GetVpcFlowLogsConfig(context.Context, *GetVpcFlowLogsConfigRequest) (*VpcFlowLogsConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVpcFlowLogsConfig not implemented")
}
func (UnimplementedVpcFlowLogsServiceServer) CreateVpcFlowLogsConfig(context.Context, *CreateVpcFlowLogsConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVpcFlowLogsConfig not implemented")
}
func (UnimplementedVpcFlowLogsServiceServer) UpdateVpcFlowLogsConfig(context.Context, *UpdateVpcFlowLogsConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateVpcFlowLogsConfig not implemented")
}
func (UnimplementedVpcFlowLogsServiceServer) DeleteVpcFlowLogsConfig(context.Context, *DeleteVpcFlowLogsConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteVpcFlowLogsConfig not implemented")
}

// UnsafeVpcFlowLogsServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to VpcFlowLogsServiceServer will
// result in compilation errors.
type UnsafeVpcFlowLogsServiceServer interface {
	mustEmbedUnimplementedVpcFlowLogsServiceServer()
}

func RegisterVpcFlowLogsServiceServer(s grpc.ServiceRegistrar, srv VpcFlowLogsServiceServer) {
	s.RegisterService(&VpcFlowLogsService_ServiceDesc, srv)
}

func _VpcFlowLogsService_ListVpcFlowLogsConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVpcFlowLogsConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VpcFlowLogsServiceServer).ListVpcFlowLogsConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VpcFlowLogsService_ListVpcFlowLogsConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VpcFlowLogsServiceServer).ListVpcFlowLogsConfigs(ctx, req.(*ListVpcFlowLogsConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VpcFlowLogsService_GetVpcFlowLogsConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVpcFlowLogsConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VpcFlowLogsServiceServer).GetVpcFlowLogsConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VpcFlowLogsService_GetVpcFlowLogsConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VpcFlowLogsServiceServer).GetVpcFlowLogsConfig(ctx, req.(*GetVpcFlowLogsConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VpcFlowLogsService_CreateVpcFlowLogsConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVpcFlowLogsConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VpcFlowLogsServiceServer).CreateVpcFlowLogsConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VpcFlowLogsService_CreateVpcFlowLogsConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VpcFlowLogsServiceServer).CreateVpcFlowLogsConfig(ctx, req.(*CreateVpcFlowLogsConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VpcFlowLogsService_UpdateVpcFlowLogsConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVpcFlowLogsConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VpcFlowLogsServiceServer).UpdateVpcFlowLogsConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VpcFlowLogsService_UpdateVpcFlowLogsConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VpcFlowLogsServiceServer).UpdateVpcFlowLogsConfig(ctx, req.(*UpdateVpcFlowLogsConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VpcFlowLogsService_DeleteVpcFlowLogsConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVpcFlowLogsConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VpcFlowLogsServiceServer).DeleteVpcFlowLogsConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VpcFlowLogsService_DeleteVpcFlowLogsConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VpcFlowLogsServiceServer).DeleteVpcFlowLogsConfig(ctx, req.(*DeleteVpcFlowLogsConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// VpcFlowLogsService_ServiceDesc is the grpc.ServiceDesc for VpcFlowLogsService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var VpcFlowLogsService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.networkmanagement.v1.VpcFlowLogsService",
	HandlerType: (*VpcFlowLogsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListVpcFlowLogsConfigs",
			Handler:    _VpcFlowLogsService_ListVpcFlowLogsConfigs_Handler,
		},
		{
			MethodName: "GetVpcFlowLogsConfig",
			Handler:    _VpcFlowLogsService_GetVpcFlowLogsConfig_Handler,
		},
		{
			MethodName: "CreateVpcFlowLogsConfig",
			Handler:    _VpcFlowLogsService_CreateVpcFlowLogsConfig_Handler,
		},
		{
			MethodName: "UpdateVpcFlowLogsConfig",
			Handler:    _VpcFlowLogsService_UpdateVpcFlowLogsConfig_Handler,
		},
		{
			MethodName: "DeleteVpcFlowLogsConfig",
			Handler:    _VpcFlowLogsService_DeleteVpcFlowLogsConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/networkmanagement/v1/vpc_flow_logs.proto",
}
