// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/networkconnectivity/v1/internal_range.proto

package networkconnectivitypb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Possible usage of an internal range.
type InternalRange_Usage int32

const (
	// Unspecified usage is allowed in calls which identify the resource by
	// other fields and do not need Usage set to complete. These are, i.e.:
	// GetInternalRange and DeleteInternalRange.
	// Usage needs to be specified explicitly in CreateInternalRange
	// or UpdateInternalRange calls.
	InternalRange_USAGE_UNSPECIFIED InternalRange_Usage = 0
	// A VPC resource can use the reserved CIDR block by associating it with the
	// internal range resource if usage is set to FOR_VPC.
	InternalRange_FOR_VPC InternalRange_Usage = 1
	// Ranges created with EXTERNAL_TO_VPC cannot be associated with VPC
	// resources and are meant to block out address ranges for various use
	// cases, like for example, usage on-prem, with dynamic route announcements
	// via interconnect.
	InternalRange_EXTERNAL_TO_VPC InternalRange_Usage = 2
	// Ranges created FOR_MIGRATION can be used to lock a CIDR range between a
	// source and target subnet. If usage is set to FOR_MIGRATION, the peering
	// value has to be set to FOR_SELF or default to FOR_SELF when unset.
	InternalRange_FOR_MIGRATION InternalRange_Usage = 3
)

// Enum value maps for InternalRange_Usage.
var (
	InternalRange_Usage_name = map[int32]string{
		0: "USAGE_UNSPECIFIED",
		1: "FOR_VPC",
		2: "EXTERNAL_TO_VPC",
		3: "FOR_MIGRATION",
	}
	InternalRange_Usage_value = map[string]int32{
		"USAGE_UNSPECIFIED": 0,
		"FOR_VPC":           1,
		"EXTERNAL_TO_VPC":   2,
		"FOR_MIGRATION":     3,
	}
)

func (x InternalRange_Usage) Enum() *InternalRange_Usage {
	p := new(InternalRange_Usage)
	*p = x
	return p
}

func (x InternalRange_Usage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InternalRange_Usage) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_internal_range_proto_enumTypes[0].Descriptor()
}

func (InternalRange_Usage) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_internal_range_proto_enumTypes[0]
}

func (x InternalRange_Usage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InternalRange_Usage.Descriptor instead.
func (InternalRange_Usage) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDescGZIP(), []int{0, 0}
}

// Peering type.
type InternalRange_Peering int32

const (
	// If Peering is left unspecified in CreateInternalRange or
	// UpdateInternalRange, it will be defaulted to FOR_SELF.
	InternalRange_PEERING_UNSPECIFIED InternalRange_Peering = 0
	// This is the default behavior and represents the case that this
	// internal range is intended to be used in the VPC in which it is created
	// and is accessible from its peers. This implies that peers or
	// peers-of-peers cannot use this range.
	InternalRange_FOR_SELF InternalRange_Peering = 1
	// This behavior can be set when the internal range is being reserved for
	// usage by peers. This means that no resource within the VPC in which
	// it is being created can use this to associate with a VPC resource, but
	// one of the peers can. This represents donating a range for peers to
	// use.
	InternalRange_FOR_PEER InternalRange_Peering = 2
	// This behavior can be set when the internal range is being reserved for
	// usage by the VPC in which it is created, but not shared with peers.
	// In a sense, it is local to the VPC. This can be used to create internal
	// ranges for various purposes like HTTP_INTERNAL_LOAD_BALANCER or for
	// Interconnect routes that are not shared with peers. This also implies
	// that peers cannot use this range in a way that is visible to this VPC,
	// but can re-use this range as long as it is NOT_SHARED from the peer VPC,
	// too.
	InternalRange_NOT_SHARED InternalRange_Peering = 3
)

// Enum value maps for InternalRange_Peering.
var (
	InternalRange_Peering_name = map[int32]string{
		0: "PEERING_UNSPECIFIED",
		1: "FOR_SELF",
		2: "FOR_PEER",
		3: "NOT_SHARED",
	}
	InternalRange_Peering_value = map[string]int32{
		"PEERING_UNSPECIFIED": 0,
		"FOR_SELF":            1,
		"FOR_PEER":            2,
		"NOT_SHARED":          3,
	}
)

func (x InternalRange_Peering) Enum() *InternalRange_Peering {
	p := new(InternalRange_Peering)
	*p = x
	return p
}

func (x InternalRange_Peering) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InternalRange_Peering) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_internal_range_proto_enumTypes[1].Descriptor()
}

func (InternalRange_Peering) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_internal_range_proto_enumTypes[1]
}

func (x InternalRange_Peering) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InternalRange_Peering.Descriptor instead.
func (InternalRange_Peering) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDescGZIP(), []int{0, 1}
}

// Overlap specifications.
type InternalRange_Overlap int32

const (
	// No overlap overrides.
	InternalRange_OVERLAP_UNSPECIFIED InternalRange_Overlap = 0
	// Allow creation of static routes more specific that the current
	// internal range.
	InternalRange_OVERLAP_ROUTE_RANGE InternalRange_Overlap = 1
	// Allow creation of internal ranges that overlap with existing subnets.
	InternalRange_OVERLAP_EXISTING_SUBNET_RANGE InternalRange_Overlap = 2
)

// Enum value maps for InternalRange_Overlap.
var (
	InternalRange_Overlap_name = map[int32]string{
		0: "OVERLAP_UNSPECIFIED",
		1: "OVERLAP_ROUTE_RANGE",
		2: "OVERLAP_EXISTING_SUBNET_RANGE",
	}
	InternalRange_Overlap_value = map[string]int32{
		"OVERLAP_UNSPECIFIED":           0,
		"OVERLAP_ROUTE_RANGE":           1,
		"OVERLAP_EXISTING_SUBNET_RANGE": 2,
	}
)

func (x InternalRange_Overlap) Enum() *InternalRange_Overlap {
	p := new(InternalRange_Overlap)
	*p = x
	return p
}

func (x InternalRange_Overlap) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InternalRange_Overlap) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_internal_range_proto_enumTypes[2].Descriptor()
}

func (InternalRange_Overlap) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_internal_range_proto_enumTypes[2]
}

func (x InternalRange_Overlap) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InternalRange_Overlap.Descriptor instead.
func (InternalRange_Overlap) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDescGZIP(), []int{0, 2}
}

// Enumeration of range auto-allocation strategies
type InternalRange_AllocationStrategy int32

const (
	// Unspecified is the only valid option when the range is specified
	// explicitly by ip_cidr_range field. Otherwise unspefified means using the
	// default strategy.
	InternalRange_ALLOCATION_STRATEGY_UNSPECIFIED InternalRange_AllocationStrategy = 0
	// Random strategy, the legacy algorithm, used for backwards compatibility.
	// This allocation strategy remains efficient in the case of concurrent
	// allocation requests in the same peered network space and doesn't require
	// providing the level of concurrency in an explicit parameter, but it is
	// prone to fragmenting available address space.
	InternalRange_RANDOM InternalRange_AllocationStrategy = 1
	// Pick the first available address range. This strategy is deterministic
	// and the result is easy to predict.
	InternalRange_FIRST_AVAILABLE InternalRange_AllocationStrategy = 2
	// Pick an arbitrary range out of the first N available ones. The N will be
	// set in the first_available_ranges_lookup_size field. This strategy should
	// be used when concurrent allocation requests are made in the same space of
	// peered networks while the fragmentation of the addrress space is reduced.
	InternalRange_RANDOM_FIRST_N_AVAILABLE InternalRange_AllocationStrategy = 3
	// Pick the smallest but fitting available range. This deterministic
	// strategy minimizes fragmentation of the address space.
	InternalRange_FIRST_SMALLEST_FITTING InternalRange_AllocationStrategy = 4
)

// Enum value maps for InternalRange_AllocationStrategy.
var (
	InternalRange_AllocationStrategy_name = map[int32]string{
		0: "ALLOCATION_STRATEGY_UNSPECIFIED",
		1: "RANDOM",
		2: "FIRST_AVAILABLE",
		3: "RANDOM_FIRST_N_AVAILABLE",
		4: "FIRST_SMALLEST_FITTING",
	}
	InternalRange_AllocationStrategy_value = map[string]int32{
		"ALLOCATION_STRATEGY_UNSPECIFIED": 0,
		"RANDOM":                          1,
		"FIRST_AVAILABLE":                 2,
		"RANDOM_FIRST_N_AVAILABLE":        3,
		"FIRST_SMALLEST_FITTING":          4,
	}
)

func (x InternalRange_AllocationStrategy) Enum() *InternalRange_AllocationStrategy {
	p := new(InternalRange_AllocationStrategy)
	*p = x
	return p
}

func (x InternalRange_AllocationStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InternalRange_AllocationStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_internal_range_proto_enumTypes[3].Descriptor()
}

func (InternalRange_AllocationStrategy) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_internal_range_proto_enumTypes[3]
}

func (x InternalRange_AllocationStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InternalRange_AllocationStrategy.Descriptor instead.
func (InternalRange_AllocationStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDescGZIP(), []int{0, 3}
}

// The internal range resource for IPAM operations within a VPC network.
// Used to represent a private address range along with behavioral
// characteristics of that range (its usage and peering behavior).
// Networking resources can link to this range if they are created
// as belonging to it.
type InternalRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of an internal range.
	// Format:
	// projects/{project}/locations/{location}/internalRanges/{internal_range}
	// See: https://google.aip.dev/122#fields-representing-resource-names
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Time when the internal range was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Time when the internal range was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-defined labels.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. A description of this resource.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The IP range that this internal range defines.
	// NOTE: IPv6 ranges are limited to usage=EXTERNAL_TO_VPC and
	// peering=FOR_SELF.
	// NOTE: For IPv6 Ranges this field is compulsory, i.e. the address range must
	// be specified explicitly.
	IpCidrRange string `protobuf:"bytes,6,opt,name=ip_cidr_range,json=ipCidrRange,proto3" json:"ip_cidr_range,omitempty"`
	// Immutable. The URL or resource ID of the network in which to reserve the
	// internal range. The network cannot be deleted if there are any reserved
	// internal ranges referring to it. Legacy networks are not supported. For
	// example:
	//
	//	https://www.googleapis.com/compute/v1/projects/{project}/locations/global/networks/{network}
	//	projects/{project}/locations/global/networks/{network}
	//	{network}
	Network string `protobuf:"bytes,7,opt,name=network,proto3" json:"network,omitempty"`
	// Optional. The type of usage set for this InternalRange.
	Usage InternalRange_Usage `protobuf:"varint,8,opt,name=usage,proto3,enum=google.cloud.networkconnectivity.v1.InternalRange_Usage" json:"usage,omitempty"`
	// Optional. The type of peering set for this internal range.
	Peering InternalRange_Peering `protobuf:"varint,9,opt,name=peering,proto3,enum=google.cloud.networkconnectivity.v1.InternalRange_Peering" json:"peering,omitempty"`
	// Optional. An alternate to ip_cidr_range. Can be set when trying to create
	// an IPv4 reservation that automatically finds a free range of the given
	// size. If both ip_cidr_range and prefix_length are set, there is an error if
	// the range sizes do not match. Can also be used during updates to change the
	// range size.
	// NOTE: For IPv6 this field only works if ip_cidr_range is set as well, and
	// both fields must match. In other words, with IPv6 this field only works as
	// a redundant parameter.
	PrefixLength int32 `protobuf:"varint,10,opt,name=prefix_length,json=prefixLength,proto3" json:"prefix_length,omitempty"`
	// Optional. Can be set to narrow down or pick a different address space while
	// searching for a free range. If not set, defaults to the "10.0.0.0/8"
	// address space. This can be used to search in other rfc-1918 address
	// spaces like "172.16.0.0/12" and "192.168.0.0/16" or non-rfc-1918
	// address spaces used in the VPC.
	TargetCidrRange []string `protobuf:"bytes,11,rep,name=target_cidr_range,json=targetCidrRange,proto3" json:"target_cidr_range,omitempty"`
	// Output only. The list of resources that refer to this internal range.
	// Resources that use the internal range for their range allocation
	// are referred to as users of the range. Other resources mark themselves
	// as users while doing so by creating a reference to this internal range.
	// Having a user, based on this reference, prevents deletion of the
	// internal range referred to. Can be empty.
	Users []string `protobuf:"bytes,12,rep,name=users,proto3" json:"users,omitempty"`
	// Optional. Types of resources that are allowed to overlap with the current
	// internal range.
	Overlaps []InternalRange_Overlap `protobuf:"varint,13,rep,packed,name=overlaps,proto3,enum=google.cloud.networkconnectivity.v1.InternalRange_Overlap" json:"overlaps,omitempty"`
	// Optional. Must be present if usage is set to FOR_MIGRATION.
	Migration *InternalRange_Migration `protobuf:"bytes,14,opt,name=migration,proto3" json:"migration,omitempty"`
	// Optional. Immutable ranges cannot have their fields modified, except for
	// labels and description.
	Immutable bool `protobuf:"varint,15,opt,name=immutable,proto3" json:"immutable,omitempty"`
	// Optional. Range auto-allocation options, may be set only when
	// auto-allocation is selected by not setting ip_cidr_range (and setting
	// prefix_length).
	AllocationOptions *InternalRange_AllocationOptions `protobuf:"bytes,16,opt,name=allocation_options,json=allocationOptions,proto3" json:"allocation_options,omitempty"`
	// Optional. ExcludeCidrRanges flag. Specifies a set of CIDR blocks that
	// allows exclusion of particular CIDR ranges from the auto-allocation
	// process, without having to reserve these blocks
	ExcludeCidrRanges []string `protobuf:"bytes,17,rep,name=exclude_cidr_ranges,json=excludeCidrRanges,proto3" json:"exclude_cidr_ranges,omitempty"`
}

func (x *InternalRange) Reset() {
	*x = InternalRange{}
	mi := &file_google_cloud_networkconnectivity_v1_internal_range_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InternalRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InternalRange) ProtoMessage() {}

func (x *InternalRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_internal_range_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InternalRange.ProtoReflect.Descriptor instead.
func (*InternalRange) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDescGZIP(), []int{0}
}

func (x *InternalRange) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *InternalRange) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *InternalRange) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *InternalRange) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *InternalRange) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *InternalRange) GetIpCidrRange() string {
	if x != nil {
		return x.IpCidrRange
	}
	return ""
}

func (x *InternalRange) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *InternalRange) GetUsage() InternalRange_Usage {
	if x != nil {
		return x.Usage
	}
	return InternalRange_USAGE_UNSPECIFIED
}

func (x *InternalRange) GetPeering() InternalRange_Peering {
	if x != nil {
		return x.Peering
	}
	return InternalRange_PEERING_UNSPECIFIED
}

func (x *InternalRange) GetPrefixLength() int32 {
	if x != nil {
		return x.PrefixLength
	}
	return 0
}

func (x *InternalRange) GetTargetCidrRange() []string {
	if x != nil {
		return x.TargetCidrRange
	}
	return nil
}

func (x *InternalRange) GetUsers() []string {
	if x != nil {
		return x.Users
	}
	return nil
}

func (x *InternalRange) GetOverlaps() []InternalRange_Overlap {
	if x != nil {
		return x.Overlaps
	}
	return nil
}

func (x *InternalRange) GetMigration() *InternalRange_Migration {
	if x != nil {
		return x.Migration
	}
	return nil
}

func (x *InternalRange) GetImmutable() bool {
	if x != nil {
		return x.Immutable
	}
	return false
}

func (x *InternalRange) GetAllocationOptions() *InternalRange_AllocationOptions {
	if x != nil {
		return x.AllocationOptions
	}
	return nil
}

func (x *InternalRange) GetExcludeCidrRanges() []string {
	if x != nil {
		return x.ExcludeCidrRanges
	}
	return nil
}

// Request for InternalRangeService.ListInternalRanges
type ListInternalRangesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource's name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results per page that should be returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters the results listed in the response.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sort the results by a certain order.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListInternalRangesRequest) Reset() {
	*x = ListInternalRangesRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_internal_range_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListInternalRangesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInternalRangesRequest) ProtoMessage() {}

func (x *ListInternalRangesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_internal_range_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInternalRangesRequest.ProtoReflect.Descriptor instead.
func (*ListInternalRangesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDescGZIP(), []int{1}
}

func (x *ListInternalRangesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListInternalRangesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListInternalRangesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListInternalRangesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListInternalRangesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for InternalRange.ListInternalRanges
type ListInternalRangesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Internal ranges to be returned.
	InternalRanges []*InternalRange `protobuf:"bytes,1,rep,name=internal_ranges,json=internalRanges,proto3" json:"internal_ranges,omitempty"`
	// The next pagination token in the List response. It should be used as
	// page_token for the following request. An empty value means no more result.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListInternalRangesResponse) Reset() {
	*x = ListInternalRangesResponse{}
	mi := &file_google_cloud_networkconnectivity_v1_internal_range_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListInternalRangesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInternalRangesResponse) ProtoMessage() {}

func (x *ListInternalRangesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_internal_range_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInternalRangesResponse.ProtoReflect.Descriptor instead.
func (*ListInternalRangesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDescGZIP(), []int{2}
}

func (x *ListInternalRangesResponse) GetInternalRanges() []*InternalRange {
	if x != nil {
		return x.InternalRanges
	}
	return nil
}

func (x *ListInternalRangesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListInternalRangesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for InternalRangeService.GetInternalRange
type GetInternalRangeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the InternalRange to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetInternalRangeRequest) Reset() {
	*x = GetInternalRangeRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_internal_range_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetInternalRangeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInternalRangeRequest) ProtoMessage() {}

func (x *GetInternalRangeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_internal_range_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInternalRangeRequest.ProtoReflect.Descriptor instead.
func (*GetInternalRangeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDescGZIP(), []int{3}
}

func (x *GetInternalRangeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for InternalRangeService.CreateInternalRange
type CreateInternalRangeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource's name of the internal range.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Resource ID
	// (i.e. 'foo' in '[...]/projects/p/locations/l/internalRanges/foo')
	// See https://google.aip.dev/122#resource-id-segments
	// Unique per location.
	InternalRangeId string `protobuf:"bytes,2,opt,name=internal_range_id,json=internalRangeId,proto3" json:"internal_range_id,omitempty"`
	// Required. Initial values for a new internal range
	InternalRange *InternalRange `protobuf:"bytes,3,opt,name=internal_range,json=internalRange,proto3" json:"internal_range,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateInternalRangeRequest) Reset() {
	*x = CreateInternalRangeRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_internal_range_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateInternalRangeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateInternalRangeRequest) ProtoMessage() {}

func (x *CreateInternalRangeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_internal_range_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateInternalRangeRequest.ProtoReflect.Descriptor instead.
func (*CreateInternalRangeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDescGZIP(), []int{4}
}

func (x *CreateInternalRangeRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateInternalRangeRequest) GetInternalRangeId() string {
	if x != nil {
		return x.InternalRangeId
	}
	return ""
}

func (x *CreateInternalRangeRequest) GetInternalRange() *InternalRange {
	if x != nil {
		return x.InternalRange
	}
	return nil
}

func (x *CreateInternalRangeRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for InternalRangeService.UpdateInternalRange
type UpdateInternalRangeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Field mask is used to specify the fields to be overwritten in the
	// InternalRange resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. New values to be patched into the resource.
	InternalRange *InternalRange `protobuf:"bytes,2,opt,name=internal_range,json=internalRange,proto3" json:"internal_range,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateInternalRangeRequest) Reset() {
	*x = UpdateInternalRangeRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_internal_range_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateInternalRangeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateInternalRangeRequest) ProtoMessage() {}

func (x *UpdateInternalRangeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_internal_range_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateInternalRangeRequest.ProtoReflect.Descriptor instead.
func (*UpdateInternalRangeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateInternalRangeRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateInternalRangeRequest) GetInternalRange() *InternalRange {
	if x != nil {
		return x.InternalRange
	}
	return nil
}

func (x *UpdateInternalRangeRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for InternalRangeService.DeleteInternalRange
type DeleteInternalRangeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the internal range to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteInternalRangeRequest) Reset() {
	*x = DeleteInternalRangeRequest{}
	mi := &file_google_cloud_networkconnectivity_v1_internal_range_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteInternalRangeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteInternalRangeRequest) ProtoMessage() {}

func (x *DeleteInternalRangeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_internal_range_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteInternalRangeRequest.ProtoReflect.Descriptor instead.
func (*DeleteInternalRangeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteInternalRangeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteInternalRangeRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Specification for migration with source and target resource names.
type InternalRange_Migration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. Resource path as an URI of the source resource, for example a
	// subnet. The project for the source resource should match the project for
	// the InternalRange. An example:
	//
	//	/projects/{project}/regions/{region}/subnetworks/{subnet}
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// Immutable. Resource path of the target resource. The target project can
	// be different, as in the cases when migrating to peer networks. For
	// example:
	//
	//	/projects/{project}/regions/{region}/subnetworks/{subnet}
	Target string `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
}

func (x *InternalRange_Migration) Reset() {
	*x = InternalRange_Migration{}
	mi := &file_google_cloud_networkconnectivity_v1_internal_range_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InternalRange_Migration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InternalRange_Migration) ProtoMessage() {}

func (x *InternalRange_Migration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_internal_range_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InternalRange_Migration.ProtoReflect.Descriptor instead.
func (*InternalRange_Migration) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDescGZIP(), []int{0, 0}
}

func (x *InternalRange_Migration) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *InternalRange_Migration) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

// Range auto-allocation options, to be optionally used when CIDR block is not
// explicitly set.
type InternalRange_AllocationOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Allocation strategy Not setting this field when the allocation
	// is requested means an implementation defined strategy is used.
	AllocationStrategy InternalRange_AllocationStrategy `protobuf:"varint,1,opt,name=allocation_strategy,json=allocationStrategy,proto3,enum=google.cloud.networkconnectivity.v1.InternalRange_AllocationStrategy" json:"allocation_strategy,omitempty"`
	// Optional. This field must be set only when allocation_strategy is set to
	// RANDOM_FIRST_N_AVAILABLE.
	// The value should be the maximum expected parallelism of range creation
	// requests issued to the same space of peered netwroks.
	FirstAvailableRangesLookupSize int32 `protobuf:"varint,2,opt,name=first_available_ranges_lookup_size,json=firstAvailableRangesLookupSize,proto3" json:"first_available_ranges_lookup_size,omitempty"`
}

func (x *InternalRange_AllocationOptions) Reset() {
	*x = InternalRange_AllocationOptions{}
	mi := &file_google_cloud_networkconnectivity_v1_internal_range_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InternalRange_AllocationOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InternalRange_AllocationOptions) ProtoMessage() {}

func (x *InternalRange_AllocationOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_internal_range_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InternalRange_AllocationOptions.ProtoReflect.Descriptor instead.
func (*InternalRange_AllocationOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDescGZIP(), []int{0, 1}
}

func (x *InternalRange_AllocationOptions) GetAllocationStrategy() InternalRange_AllocationStrategy {
	if x != nil {
		return x.AllocationStrategy
	}
	return InternalRange_ALLOCATION_STRATEGY_UNSPECIFIED
}

func (x *InternalRange_AllocationOptions) GetFirstAvailableRangesLookupSize() int32 {
	if x != nil {
		return x.FirstAvailableRangesLookupSize
	}
	return 0
}

var File_google_cloud_networkconnectivity_v1_internal_range_proto protoreflect.FileDescriptor

var file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDesc = []byte{
	0x0a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x72,
	0x61, 0x6e, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa1, 0x0f, 0x0a, 0x0d, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x56,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a,
	0x0d, 0x69, 0x70, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x69, 0x70, 0x43, 0x69, 0x64,
	0x72, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x07, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x53, 0x0a, 0x05, 0x75, 0x73, 0x61, 0x67, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x55, 0x73, 0x61, 0x67, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x05, 0x75, 0x73, 0x61, 0x67, 0x65, 0x12, 0x59, 0x0a, 0x07, 0x70, 0x65,
	0x65, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x2e,
	0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x70, 0x65,
	0x65, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f,
	0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12,
	0x2f, 0x0a, 0x11, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x72,
	0x61, 0x6e, 0x67, 0x65, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x69, 0x64, 0x72, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x19, 0x0a, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73, 0x12, 0x5b, 0x0a, 0x08, 0x6f,
	0x76, 0x65, 0x72, 0x6c, 0x61, 0x70, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x2e, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x6f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x70, 0x73, 0x12, 0x5f, 0x0a, 0x09, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x2e,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x09, 0x69, 0x6d, 0x6d,
	0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x69, 0x6d, 0x6d, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x78, 0x0a, 0x12,
	0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x41, 0x6c, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x33, 0x0a, 0x13, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x11, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x43, 0x69, 0x64, 0x72, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x1a, 0x45, 0x0a, 0x09, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x06, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x1a, 0xe1, 0x01, 0x0a, 0x11, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x7b, 0x0a, 0x13, 0x61, 0x6c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72,
	0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x4f, 0x0a, 0x22, 0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x61,
	0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x5f,
	0x6c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1e, 0x66, 0x69, 0x72, 0x73, 0x74, 0x41, 0x76, 0x61,
	0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x4c, 0x6f, 0x6f, 0x6b,
	0x75, 0x70, 0x53, 0x69, 0x7a, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x53, 0x0a, 0x05, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x55, 0x53,
	0x41, 0x47, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x4f, 0x52, 0x5f, 0x56, 0x50, 0x43, 0x10, 0x01, 0x12, 0x13,
	0x0a, 0x0f, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x54, 0x4f, 0x5f, 0x56, 0x50,
	0x43, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x46, 0x4f, 0x52, 0x5f, 0x4d, 0x49, 0x47, 0x52, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x22, 0x4e, 0x0a, 0x07, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x46, 0x4f,
	0x52, 0x5f, 0x53, 0x45, 0x4c, 0x46, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x46, 0x4f, 0x52, 0x5f,
	0x50, 0x45, 0x45, 0x52, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x4e, 0x4f, 0x54, 0x5f, 0x53, 0x48,
	0x41, 0x52, 0x45, 0x44, 0x10, 0x03, 0x22, 0x5e, 0x0a, 0x07, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61,
	0x70, 0x12, 0x17, 0x0a, 0x13, 0x4f, 0x56, 0x45, 0x52, 0x4c, 0x41, 0x50, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x4f, 0x56,
	0x45, 0x52, 0x4c, 0x41, 0x50, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x52, 0x41, 0x4e, 0x47,
	0x45, 0x10, 0x01, 0x12, 0x21, 0x0a, 0x1d, 0x4f, 0x56, 0x45, 0x52, 0x4c, 0x41, 0x50, 0x5f, 0x45,
	0x58, 0x49, 0x53, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x55, 0x42, 0x4e, 0x45, 0x54, 0x5f, 0x52,
	0x41, 0x4e, 0x47, 0x45, 0x10, 0x02, 0x22, 0x94, 0x01, 0x0a, 0x12, 0x41, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x23, 0x0a,
	0x1f, 0x41, 0x4c, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x52, 0x41,
	0x54, 0x45, 0x47, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x41, 0x4e, 0x44, 0x4f, 0x4d, 0x10, 0x01, 0x12, 0x13,
	0x0a, 0x0f, 0x46, 0x49, 0x52, 0x53, 0x54, 0x5f, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c,
	0x45, 0x10, 0x02, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x41, 0x4e, 0x44, 0x4f, 0x4d, 0x5f, 0x46, 0x49,
	0x52, 0x53, 0x54, 0x5f, 0x4e, 0x5f, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10,
	0x03, 0x12, 0x1a, 0x0a, 0x16, 0x46, 0x49, 0x52, 0x53, 0x54, 0x5f, 0x53, 0x4d, 0x41, 0x4c, 0x4c,
	0x45, 0x53, 0x54, 0x5f, 0x46, 0x49, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x3a, 0x7e, 0xea,
	0x41, 0x7b, 0x0a, 0x30, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x47, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x7d, 0x22, 0xcd, 0x01,
	0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xc3, 0x01,
	0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a, 0x0f,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x0e, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x22, 0x67, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa3, 0x02, 0x0a,
	0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x32, 0x12, 0x30, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x0a,
	0x11, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x49, 0x64, 0x12, 0x5e,
	0x0a, 0x0e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x22, 0xe2, 0x01, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x12, 0x5e, 0x0a, 0x0e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f,
	0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x8e, 0x01, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x32, 0xa7, 0x0a, 0x0a, 0x14, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0xda, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0xc7,
	0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x22, 0x41, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x91, 0x02, 0x0a, 0x13, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x99, 0x01, 0xca, 0x41, 0x22, 0x0a, 0x0d, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x27, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65,
	0x2c, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f,
	0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x0e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x93, 0x02, 0x0a,
	0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9b, 0x01, 0xca, 0x41, 0x22, 0x0a, 0x0d, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1a, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53, 0x3a,
	0x0e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x32,
	0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x72,
	0x61, 0x6e, 0x67, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xe5, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6e, 0xca, 0x41, 0x2a, 0x0a,
	0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x2a, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x56, 0xca, 0x41, 0x22, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x42, 0x8f, 0x02, 0x0a, 0x27, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x42, 0x12,
	0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x59, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x70, 0x62, 0x3b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x70, 0x62, 0xaa,
	0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x26, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDescOnce sync.Once
	file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDescData = file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDesc
)

func file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDescGZIP() []byte {
	file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDescOnce.Do(func() {
		file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDescData)
	})
	return file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDescData
}

var file_google_cloud_networkconnectivity_v1_internal_range_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_networkconnectivity_v1_internal_range_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_networkconnectivity_v1_internal_range_proto_goTypes = []any{
	(InternalRange_Usage)(0),                // 0: google.cloud.networkconnectivity.v1.InternalRange.Usage
	(InternalRange_Peering)(0),              // 1: google.cloud.networkconnectivity.v1.InternalRange.Peering
	(InternalRange_Overlap)(0),              // 2: google.cloud.networkconnectivity.v1.InternalRange.Overlap
	(InternalRange_AllocationStrategy)(0),   // 3: google.cloud.networkconnectivity.v1.InternalRange.AllocationStrategy
	(*InternalRange)(nil),                   // 4: google.cloud.networkconnectivity.v1.InternalRange
	(*ListInternalRangesRequest)(nil),       // 5: google.cloud.networkconnectivity.v1.ListInternalRangesRequest
	(*ListInternalRangesResponse)(nil),      // 6: google.cloud.networkconnectivity.v1.ListInternalRangesResponse
	(*GetInternalRangeRequest)(nil),         // 7: google.cloud.networkconnectivity.v1.GetInternalRangeRequest
	(*CreateInternalRangeRequest)(nil),      // 8: google.cloud.networkconnectivity.v1.CreateInternalRangeRequest
	(*UpdateInternalRangeRequest)(nil),      // 9: google.cloud.networkconnectivity.v1.UpdateInternalRangeRequest
	(*DeleteInternalRangeRequest)(nil),      // 10: google.cloud.networkconnectivity.v1.DeleteInternalRangeRequest
	(*InternalRange_Migration)(nil),         // 11: google.cloud.networkconnectivity.v1.InternalRange.Migration
	(*InternalRange_AllocationOptions)(nil), // 12: google.cloud.networkconnectivity.v1.InternalRange.AllocationOptions
	nil,                                     // 13: google.cloud.networkconnectivity.v1.InternalRange.LabelsEntry
	(*timestamppb.Timestamp)(nil),           // 14: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),           // 15: google.protobuf.FieldMask
	(*longrunningpb.Operation)(nil),         // 16: google.longrunning.Operation
}
var file_google_cloud_networkconnectivity_v1_internal_range_proto_depIdxs = []int32{
	14, // 0: google.cloud.networkconnectivity.v1.InternalRange.create_time:type_name -> google.protobuf.Timestamp
	14, // 1: google.cloud.networkconnectivity.v1.InternalRange.update_time:type_name -> google.protobuf.Timestamp
	13, // 2: google.cloud.networkconnectivity.v1.InternalRange.labels:type_name -> google.cloud.networkconnectivity.v1.InternalRange.LabelsEntry
	0,  // 3: google.cloud.networkconnectivity.v1.InternalRange.usage:type_name -> google.cloud.networkconnectivity.v1.InternalRange.Usage
	1,  // 4: google.cloud.networkconnectivity.v1.InternalRange.peering:type_name -> google.cloud.networkconnectivity.v1.InternalRange.Peering
	2,  // 5: google.cloud.networkconnectivity.v1.InternalRange.overlaps:type_name -> google.cloud.networkconnectivity.v1.InternalRange.Overlap
	11, // 6: google.cloud.networkconnectivity.v1.InternalRange.migration:type_name -> google.cloud.networkconnectivity.v1.InternalRange.Migration
	12, // 7: google.cloud.networkconnectivity.v1.InternalRange.allocation_options:type_name -> google.cloud.networkconnectivity.v1.InternalRange.AllocationOptions
	4,  // 8: google.cloud.networkconnectivity.v1.ListInternalRangesResponse.internal_ranges:type_name -> google.cloud.networkconnectivity.v1.InternalRange
	4,  // 9: google.cloud.networkconnectivity.v1.CreateInternalRangeRequest.internal_range:type_name -> google.cloud.networkconnectivity.v1.InternalRange
	15, // 10: google.cloud.networkconnectivity.v1.UpdateInternalRangeRequest.update_mask:type_name -> google.protobuf.FieldMask
	4,  // 11: google.cloud.networkconnectivity.v1.UpdateInternalRangeRequest.internal_range:type_name -> google.cloud.networkconnectivity.v1.InternalRange
	3,  // 12: google.cloud.networkconnectivity.v1.InternalRange.AllocationOptions.allocation_strategy:type_name -> google.cloud.networkconnectivity.v1.InternalRange.AllocationStrategy
	5,  // 13: google.cloud.networkconnectivity.v1.InternalRangeService.ListInternalRanges:input_type -> google.cloud.networkconnectivity.v1.ListInternalRangesRequest
	7,  // 14: google.cloud.networkconnectivity.v1.InternalRangeService.GetInternalRange:input_type -> google.cloud.networkconnectivity.v1.GetInternalRangeRequest
	8,  // 15: google.cloud.networkconnectivity.v1.InternalRangeService.CreateInternalRange:input_type -> google.cloud.networkconnectivity.v1.CreateInternalRangeRequest
	9,  // 16: google.cloud.networkconnectivity.v1.InternalRangeService.UpdateInternalRange:input_type -> google.cloud.networkconnectivity.v1.UpdateInternalRangeRequest
	10, // 17: google.cloud.networkconnectivity.v1.InternalRangeService.DeleteInternalRange:input_type -> google.cloud.networkconnectivity.v1.DeleteInternalRangeRequest
	6,  // 18: google.cloud.networkconnectivity.v1.InternalRangeService.ListInternalRanges:output_type -> google.cloud.networkconnectivity.v1.ListInternalRangesResponse
	4,  // 19: google.cloud.networkconnectivity.v1.InternalRangeService.GetInternalRange:output_type -> google.cloud.networkconnectivity.v1.InternalRange
	16, // 20: google.cloud.networkconnectivity.v1.InternalRangeService.CreateInternalRange:output_type -> google.longrunning.Operation
	16, // 21: google.cloud.networkconnectivity.v1.InternalRangeService.UpdateInternalRange:output_type -> google.longrunning.Operation
	16, // 22: google.cloud.networkconnectivity.v1.InternalRangeService.DeleteInternalRange:output_type -> google.longrunning.Operation
	18, // [18:23] is the sub-list for method output_type
	13, // [13:18] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_cloud_networkconnectivity_v1_internal_range_proto_init() }
func file_google_cloud_networkconnectivity_v1_internal_range_proto_init() {
	if File_google_cloud_networkconnectivity_v1_internal_range_proto != nil {
		return
	}
	file_google_cloud_networkconnectivity_v1_common_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_networkconnectivity_v1_internal_range_proto_goTypes,
		DependencyIndexes: file_google_cloud_networkconnectivity_v1_internal_range_proto_depIdxs,
		EnumInfos:         file_google_cloud_networkconnectivity_v1_internal_range_proto_enumTypes,
		MessageInfos:      file_google_cloud_networkconnectivity_v1_internal_range_proto_msgTypes,
	}.Build()
	File_google_cloud_networkconnectivity_v1_internal_range_proto = out.File
	file_google_cloud_networkconnectivity_v1_internal_range_proto_rawDesc = nil
	file_google_cloud_networkconnectivity_v1_internal_range_proto_goTypes = nil
	file_google_cloud_networkconnectivity_v1_internal_range_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// InternalRangeServiceClient is the client API for InternalRangeService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type InternalRangeServiceClient interface {
	// Lists internal ranges in a given project and location.
	ListInternalRanges(ctx context.Context, in *ListInternalRangesRequest, opts ...grpc.CallOption) (*ListInternalRangesResponse, error)
	// Gets details of a single internal range.
	GetInternalRange(ctx context.Context, in *GetInternalRangeRequest, opts ...grpc.CallOption) (*InternalRange, error)
	// Creates a new internal range in a given project and location.
	CreateInternalRange(ctx context.Context, in *CreateInternalRangeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single internal range.
	UpdateInternalRange(ctx context.Context, in *UpdateInternalRangeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single internal range.
	DeleteInternalRange(ctx context.Context, in *DeleteInternalRangeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type internalRangeServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewInternalRangeServiceClient(cc grpc.ClientConnInterface) InternalRangeServiceClient {
	return &internalRangeServiceClient{cc}
}

func (c *internalRangeServiceClient) ListInternalRanges(ctx context.Context, in *ListInternalRangesRequest, opts ...grpc.CallOption) (*ListInternalRangesResponse, error) {
	out := new(ListInternalRangesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.InternalRangeService/ListInternalRanges", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *internalRangeServiceClient) GetInternalRange(ctx context.Context, in *GetInternalRangeRequest, opts ...grpc.CallOption) (*InternalRange, error) {
	out := new(InternalRange)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.InternalRangeService/GetInternalRange", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *internalRangeServiceClient) CreateInternalRange(ctx context.Context, in *CreateInternalRangeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.InternalRangeService/CreateInternalRange", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *internalRangeServiceClient) UpdateInternalRange(ctx context.Context, in *UpdateInternalRangeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.InternalRangeService/UpdateInternalRange", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *internalRangeServiceClient) DeleteInternalRange(ctx context.Context, in *DeleteInternalRangeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.InternalRangeService/DeleteInternalRange", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InternalRangeServiceServer is the server API for InternalRangeService service.
type InternalRangeServiceServer interface {
	// Lists internal ranges in a given project and location.
	ListInternalRanges(context.Context, *ListInternalRangesRequest) (*ListInternalRangesResponse, error)
	// Gets details of a single internal range.
	GetInternalRange(context.Context, *GetInternalRangeRequest) (*InternalRange, error)
	// Creates a new internal range in a given project and location.
	CreateInternalRange(context.Context, *CreateInternalRangeRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single internal range.
	UpdateInternalRange(context.Context, *UpdateInternalRangeRequest) (*longrunningpb.Operation, error)
	// Deletes a single internal range.
	DeleteInternalRange(context.Context, *DeleteInternalRangeRequest) (*longrunningpb.Operation, error)
}

// UnimplementedInternalRangeServiceServer can be embedded to have forward compatible implementations.
type UnimplementedInternalRangeServiceServer struct {
}

func (*UnimplementedInternalRangeServiceServer) ListInternalRanges(context.Context, *ListInternalRangesRequest) (*ListInternalRangesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInternalRanges not implemented")
}
func (*UnimplementedInternalRangeServiceServer) GetInternalRange(context.Context, *GetInternalRangeRequest) (*InternalRange, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInternalRange not implemented")
}
func (*UnimplementedInternalRangeServiceServer) CreateInternalRange(context.Context, *CreateInternalRangeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInternalRange not implemented")
}
func (*UnimplementedInternalRangeServiceServer) UpdateInternalRange(context.Context, *UpdateInternalRangeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInternalRange not implemented")
}
func (*UnimplementedInternalRangeServiceServer) DeleteInternalRange(context.Context, *DeleteInternalRangeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInternalRange not implemented")
}

func RegisterInternalRangeServiceServer(s *grpc.Server, srv InternalRangeServiceServer) {
	s.RegisterService(&_InternalRangeService_serviceDesc, srv)
}

func _InternalRangeService_ListInternalRanges_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInternalRangesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InternalRangeServiceServer).ListInternalRanges(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.InternalRangeService/ListInternalRanges",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InternalRangeServiceServer).ListInternalRanges(ctx, req.(*ListInternalRangesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InternalRangeService_GetInternalRange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInternalRangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InternalRangeServiceServer).GetInternalRange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.InternalRangeService/GetInternalRange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InternalRangeServiceServer).GetInternalRange(ctx, req.(*GetInternalRangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InternalRangeService_CreateInternalRange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInternalRangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InternalRangeServiceServer).CreateInternalRange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.InternalRangeService/CreateInternalRange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InternalRangeServiceServer).CreateInternalRange(ctx, req.(*CreateInternalRangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InternalRangeService_UpdateInternalRange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInternalRangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InternalRangeServiceServer).UpdateInternalRange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.InternalRangeService/UpdateInternalRange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InternalRangeServiceServer).UpdateInternalRange(ctx, req.(*UpdateInternalRangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InternalRangeService_DeleteInternalRange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInternalRangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InternalRangeServiceServer).DeleteInternalRange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.InternalRangeService/DeleteInternalRange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InternalRangeServiceServer).DeleteInternalRange(ctx, req.(*DeleteInternalRangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _InternalRangeService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.networkconnectivity.v1.InternalRangeService",
	HandlerType: (*InternalRangeServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInternalRanges",
			Handler:    _InternalRangeService_ListInternalRanges_Handler,
		},
		{
			MethodName: "GetInternalRange",
			Handler:    _InternalRangeService_GetInternalRange_Handler,
		},
		{
			MethodName: "CreateInternalRange",
			Handler:    _InternalRangeService_CreateInternalRange_Handler,
		},
		{
			MethodName: "UpdateInternalRange",
			Handler:    _InternalRangeService_UpdateInternalRange_Handler,
		},
		{
			MethodName: "DeleteInternalRange",
			Handler:    _InternalRangeService_DeleteInternalRange_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/networkconnectivity/v1/internal_range.proto",
}
