// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/kms/inventory/v1/key_dashboard_service.proto

package inventorypb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	KeyDashboardService_ListCryptoKeys_FullMethodName = "/google.cloud.kms.inventory.v1.KeyDashboardService/ListCryptoKeys"
)

// KeyDashboardServiceClient is the client API for KeyDashboardService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type KeyDashboardServiceClient interface {
	// Returns cryptographic keys managed by Cloud KMS in a given Cloud project.
	// Note that this data is sourced from snapshots, meaning it may not
	// completely reflect the actual state of key metadata at call time.
	ListCryptoKeys(ctx context.Context, in *ListCryptoKeysRequest, opts ...grpc.CallOption) (*ListCryptoKeysResponse, error)
}

type keyDashboardServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewKeyDashboardServiceClient(cc grpc.ClientConnInterface) KeyDashboardServiceClient {
	return &keyDashboardServiceClient{cc}
}

func (c *keyDashboardServiceClient) ListCryptoKeys(ctx context.Context, in *ListCryptoKeysRequest, opts ...grpc.CallOption) (*ListCryptoKeysResponse, error) {
	out := new(ListCryptoKeysResponse)
	err := c.cc.Invoke(ctx, KeyDashboardService_ListCryptoKeys_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// KeyDashboardServiceServer is the server API for KeyDashboardService service.
// All implementations should embed UnimplementedKeyDashboardServiceServer
// for forward compatibility
type KeyDashboardServiceServer interface {
	// Returns cryptographic keys managed by Cloud KMS in a given Cloud project.
	// Note that this data is sourced from snapshots, meaning it may not
	// completely reflect the actual state of key metadata at call time.
	ListCryptoKeys(context.Context, *ListCryptoKeysRequest) (*ListCryptoKeysResponse, error)
}

// UnimplementedKeyDashboardServiceServer should be embedded to have forward compatible implementations.
type UnimplementedKeyDashboardServiceServer struct {
}

func (UnimplementedKeyDashboardServiceServer) ListCryptoKeys(context.Context, *ListCryptoKeysRequest) (*ListCryptoKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCryptoKeys not implemented")
}

// UnsafeKeyDashboardServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to KeyDashboardServiceServer will
// result in compilation errors.
type UnsafeKeyDashboardServiceServer interface {
	mustEmbedUnimplementedKeyDashboardServiceServer()
}

func RegisterKeyDashboardServiceServer(s grpc.ServiceRegistrar, srv KeyDashboardServiceServer) {
	s.RegisterService(&KeyDashboardService_ServiceDesc, srv)
}

func _KeyDashboardService_ListCryptoKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCryptoKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyDashboardServiceServer).ListCryptoKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyDashboardService_ListCryptoKeys_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyDashboardServiceServer).ListCryptoKeys(ctx, req.(*ListCryptoKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// KeyDashboardService_ServiceDesc is the grpc.ServiceDesc for KeyDashboardService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var KeyDashboardService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.kms.inventory.v1.KeyDashboardService",
	HandlerType: (*KeyDashboardServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListCryptoKeys",
			Handler:    _KeyDashboardService_ListCryptoKeys_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/kms/inventory/v1/key_dashboard_service.proto",
}
