// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/gkebackup/v1/backup.proto

package gkebackuppb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// State
type Backup_State int32

const (
	// The Backup resource is in the process of being created.
	Backup_STATE_UNSPECIFIED Backup_State = 0
	// The Backup resource has been created and the associated BackupJob
	// Kubernetes resource has been injected into the source cluster.
	Backup_CREATING Backup_State = 1
	// The gkebackup agent in the cluster has begun executing the backup
	// operation.
	Backup_IN_PROGRESS Backup_State = 2
	// The backup operation has completed successfully.
	Backup_SUCCEEDED Backup_State = 3
	// The backup operation has failed.
	Backup_FAILED Backup_State = 4
	// This Backup resource (and its associated artifacts) is in the process
	// of being deleted.
	Backup_DELETING Backup_State = 5
)

// Enum value maps for Backup_State.
var (
	Backup_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "IN_PROGRESS",
		3: "SUCCEEDED",
		4: "FAILED",
		5: "DELETING",
	}
	Backup_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"IN_PROGRESS":       2,
		"SUCCEEDED":         3,
		"FAILED":            4,
		"DELETING":          5,
	}
)

func (x Backup_State) Enum() *Backup_State {
	p := new(Backup_State)
	*p = x
	return p
}

func (x Backup_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Backup_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkebackup_v1_backup_proto_enumTypes[0].Descriptor()
}

func (Backup_State) Type() protoreflect.EnumType {
	return &file_google_cloud_gkebackup_v1_backup_proto_enumTypes[0]
}

func (x Backup_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Backup_State.Descriptor instead.
func (Backup_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_backup_proto_rawDescGZIP(), []int{0, 0}
}

// Represents a request to perform a single point-in-time capture of
// some portion of the state of a GKE cluster, the record of the backup
// operation itself, and an anchor for the underlying artifacts that
// comprise the Backup (the config backup and VolumeBackups).
type Backup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The fully qualified name of the Backup.
	// `projects/*/locations/*/backupPlans/*/backups/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Server generated global unique identifier of
	// [UUID4](https://en.wikipedia.org/wiki/Universally_unique_identifier)
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The timestamp when this Backup resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when this Backup resource was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. This flag indicates whether this Backup resource was created
	// manually by a user or via a schedule in the BackupPlan. A value of True
	// means that the Backup was created manually.
	Manual bool `protobuf:"varint,5,opt,name=manual,proto3" json:"manual,omitempty"`
	// Optional. A set of custom labels supplied by user.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Minimum age for this Backup (in days). If this field is set to a
	// non-zero value, the Backup will be "locked" against deletion (either manual
	// or automatic deletion) for the number of days provided (measured from the
	// creation time of the Backup).  MUST be an integer value between 0-90
	// (inclusive).
	//
	// Defaults to parent BackupPlan's
	// [backup_delete_lock_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_delete_lock_days]
	// setting and may only be increased
	// (either at creation time or in a subsequent update).
	DeleteLockDays int32 `protobuf:"varint,7,opt,name=delete_lock_days,json=deleteLockDays,proto3" json:"delete_lock_days,omitempty"`
	// Output only. The time at which an existing delete lock will expire for this
	// backup (calculated from create_time +
	// [delete_lock_days][google.cloud.gkebackup.v1.Backup.delete_lock_days]).
	DeleteLockExpireTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=delete_lock_expire_time,json=deleteLockExpireTime,proto3" json:"delete_lock_expire_time,omitempty"`
	// Optional. The age (in days) after which this Backup will be automatically
	// deleted. Must be an integer value >= 0:
	//
	// - If 0, no automatic deletion will occur for this Backup.
	// - If not 0, this must be >=
	// [delete_lock_days][google.cloud.gkebackup.v1.Backup.delete_lock_days] and
	// <= 365.
	//
	// Once a Backup is created, this value may only be increased.
	//
	// Defaults to the parent BackupPlan's
	// [backup_retain_days][google.cloud.gkebackup.v1.BackupPlan.RetentionPolicy.backup_retain_days]
	// value.
	RetainDays int32 `protobuf:"varint,9,opt,name=retain_days,json=retainDays,proto3" json:"retain_days,omitempty"`
	// Output only. The time at which this Backup will be automatically deleted
	// (calculated from create_time +
	// [retain_days][google.cloud.gkebackup.v1.Backup.retain_days]).
	RetainExpireTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=retain_expire_time,json=retainExpireTime,proto3" json:"retain_expire_time,omitempty"`
	// Output only. The customer managed encryption key that was used to encrypt
	// the Backup's artifacts.  Inherited from the parent BackupPlan's
	// [encryption_key][google.cloud.gkebackup.v1.BackupPlan.BackupConfig.encryption_key]
	// value.
	EncryptionKey *EncryptionKey `protobuf:"bytes,11,opt,name=encryption_key,json=encryptionKey,proto3" json:"encryption_key,omitempty"`
	// Defines the "scope" of the Backup - which namespaced resources in the
	// cluster were included in the Backup.  Inherited from the parent
	// BackupPlan's
	// [backup_scope][google.cloud.gkebackup.v1.BackupPlan.BackupConfig.backup_scope]
	// value.
	//
	// Types that are assignable to BackupScope:
	//
	//	*Backup_AllNamespaces
	//	*Backup_SelectedNamespaces
	//	*Backup_SelectedApplications
	BackupScope isBackup_BackupScope `protobuf_oneof:"backup_scope"`
	// Output only. Whether or not the Backup contains volume data.  Controlled by
	// the parent BackupPlan's
	// [include_volume_data][google.cloud.gkebackup.v1.BackupPlan.BackupConfig.include_volume_data]
	// value.
	ContainsVolumeData bool `protobuf:"varint,15,opt,name=contains_volume_data,json=containsVolumeData,proto3" json:"contains_volume_data,omitempty"`
	// Output only. Whether or not the Backup contains Kubernetes Secrets.
	// Controlled by the parent BackupPlan's
	// [include_secrets][google.cloud.gkebackup.v1.BackupPlan.BackupConfig.include_secrets]
	// value.
	ContainsSecrets bool `protobuf:"varint,16,opt,name=contains_secrets,json=containsSecrets,proto3" json:"contains_secrets,omitempty"`
	// Output only. Information about the GKE cluster from which this Backup was
	// created.
	ClusterMetadata *Backup_ClusterMetadata `protobuf:"bytes,17,opt,name=cluster_metadata,json=clusterMetadata,proto3" json:"cluster_metadata,omitempty"`
	// Output only. Current state of the Backup
	State Backup_State `protobuf:"varint,18,opt,name=state,proto3,enum=google.cloud.gkebackup.v1.Backup_State" json:"state,omitempty"`
	// Output only. Human-readable description of why the backup is in the current
	// `state`.
	StateReason string `protobuf:"bytes,19,opt,name=state_reason,json=stateReason,proto3" json:"state_reason,omitempty"`
	// Output only. Completion time of the Backup
	CompleteTime *timestamppb.Timestamp `protobuf:"bytes,20,opt,name=complete_time,json=completeTime,proto3" json:"complete_time,omitempty"`
	// Output only. The total number of Kubernetes resources included in the
	// Backup.
	ResourceCount int32 `protobuf:"varint,21,opt,name=resource_count,json=resourceCount,proto3" json:"resource_count,omitempty"`
	// Output only. The total number of volume backups contained in the Backup.
	VolumeCount int32 `protobuf:"varint,22,opt,name=volume_count,json=volumeCount,proto3" json:"volume_count,omitempty"`
	// Output only. The total size of the Backup in bytes = config backup size +
	// sum(volume backup sizes)
	SizeBytes int64 `protobuf:"varint,23,opt,name=size_bytes,json=sizeBytes,proto3" json:"size_bytes,omitempty"`
	// Output only. `etag` is used for optimistic concurrency control as a way to
	// help prevent simultaneous updates of a backup from overwriting each other.
	// It is strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform backup updates in order to avoid
	// race conditions: An `etag` is returned in the response to `GetBackup`,
	// and systems are expected to put that etag in the request to
	// `UpdateBackup` or `DeleteBackup` to ensure that their change will be
	// applied to the same version of the resource.
	Etag string `protobuf:"bytes,24,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. User specified descriptive string for this Backup.
	Description string `protobuf:"bytes,25,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The total number of Kubernetes Pods contained in the Backup.
	PodCount int32 `protobuf:"varint,26,opt,name=pod_count,json=podCount,proto3" json:"pod_count,omitempty"`
	// Output only. The size of the config backup in bytes.
	ConfigBackupSizeBytes int64 `protobuf:"varint,27,opt,name=config_backup_size_bytes,json=configBackupSizeBytes,proto3" json:"config_backup_size_bytes,omitempty"`
	// Output only. If false, Backup will fail when Backup for GKE detects
	// Kubernetes configuration that is non-standard or
	// requires additional setup to restore.
	//
	// Inherited from the parent BackupPlan's
	// [permissive_mode][google.cloud.gkebackup.v1.BackupPlan.BackupConfig.permissive_mode]
	// value.
	PermissiveMode bool `protobuf:"varint,28,opt,name=permissive_mode,json=permissiveMode,proto3" json:"permissive_mode,omitempty"`
}

func (x *Backup) Reset() {
	*x = Backup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_backup_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Backup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Backup) ProtoMessage() {}

func (x *Backup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_backup_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Backup.ProtoReflect.Descriptor instead.
func (*Backup) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_backup_proto_rawDescGZIP(), []int{0}
}

func (x *Backup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Backup) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Backup) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Backup) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Backup) GetManual() bool {
	if x != nil {
		return x.Manual
	}
	return false
}

func (x *Backup) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Backup) GetDeleteLockDays() int32 {
	if x != nil {
		return x.DeleteLockDays
	}
	return 0
}

func (x *Backup) GetDeleteLockExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteLockExpireTime
	}
	return nil
}

func (x *Backup) GetRetainDays() int32 {
	if x != nil {
		return x.RetainDays
	}
	return 0
}

func (x *Backup) GetRetainExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RetainExpireTime
	}
	return nil
}

func (x *Backup) GetEncryptionKey() *EncryptionKey {
	if x != nil {
		return x.EncryptionKey
	}
	return nil
}

func (m *Backup) GetBackupScope() isBackup_BackupScope {
	if m != nil {
		return m.BackupScope
	}
	return nil
}

func (x *Backup) GetAllNamespaces() bool {
	if x, ok := x.GetBackupScope().(*Backup_AllNamespaces); ok {
		return x.AllNamespaces
	}
	return false
}

func (x *Backup) GetSelectedNamespaces() *Namespaces {
	if x, ok := x.GetBackupScope().(*Backup_SelectedNamespaces); ok {
		return x.SelectedNamespaces
	}
	return nil
}

func (x *Backup) GetSelectedApplications() *NamespacedNames {
	if x, ok := x.GetBackupScope().(*Backup_SelectedApplications); ok {
		return x.SelectedApplications
	}
	return nil
}

func (x *Backup) GetContainsVolumeData() bool {
	if x != nil {
		return x.ContainsVolumeData
	}
	return false
}

func (x *Backup) GetContainsSecrets() bool {
	if x != nil {
		return x.ContainsSecrets
	}
	return false
}

func (x *Backup) GetClusterMetadata() *Backup_ClusterMetadata {
	if x != nil {
		return x.ClusterMetadata
	}
	return nil
}

func (x *Backup) GetState() Backup_State {
	if x != nil {
		return x.State
	}
	return Backup_STATE_UNSPECIFIED
}

func (x *Backup) GetStateReason() string {
	if x != nil {
		return x.StateReason
	}
	return ""
}

func (x *Backup) GetCompleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CompleteTime
	}
	return nil
}

func (x *Backup) GetResourceCount() int32 {
	if x != nil {
		return x.ResourceCount
	}
	return 0
}

func (x *Backup) GetVolumeCount() int32 {
	if x != nil {
		return x.VolumeCount
	}
	return 0
}

func (x *Backup) GetSizeBytes() int64 {
	if x != nil {
		return x.SizeBytes
	}
	return 0
}

func (x *Backup) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Backup) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Backup) GetPodCount() int32 {
	if x != nil {
		return x.PodCount
	}
	return 0
}

func (x *Backup) GetConfigBackupSizeBytes() int64 {
	if x != nil {
		return x.ConfigBackupSizeBytes
	}
	return 0
}

func (x *Backup) GetPermissiveMode() bool {
	if x != nil {
		return x.PermissiveMode
	}
	return false
}

type isBackup_BackupScope interface {
	isBackup_BackupScope()
}

type Backup_AllNamespaces struct {
	// Output only. If True, all namespaces were included in the Backup.
	AllNamespaces bool `protobuf:"varint,12,opt,name=all_namespaces,json=allNamespaces,proto3,oneof"`
}

type Backup_SelectedNamespaces struct {
	// Output only. If set, the list of namespaces that were included in the
	// Backup.
	SelectedNamespaces *Namespaces `protobuf:"bytes,13,opt,name=selected_namespaces,json=selectedNamespaces,proto3,oneof"`
}

type Backup_SelectedApplications struct {
	// Output only. If set, the list of ProtectedApplications whose resources
	// were included in the Backup.
	SelectedApplications *NamespacedNames `protobuf:"bytes,14,opt,name=selected_applications,json=selectedApplications,proto3,oneof"`
}

func (*Backup_AllNamespaces) isBackup_BackupScope() {}

func (*Backup_SelectedNamespaces) isBackup_BackupScope() {}

func (*Backup_SelectedApplications) isBackup_BackupScope() {}

// Information about the GKE cluster from which this Backup was created.
type Backup_ClusterMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The source cluster from which this Backup was created.
	// Valid formats:
	//
	//   - `projects/*/locations/*/clusters/*`
	//   - `projects/*/zones/*/clusters/*`
	//
	// This is inherited from the parent BackupPlan's
	// [cluster][google.cloud.gkebackup.v1.BackupPlan.cluster] field.
	Cluster string `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Output only. The Kubernetes server version of the source cluster.
	K8SVersion string `protobuf:"bytes,2,opt,name=k8s_version,json=k8sVersion,proto3" json:"k8s_version,omitempty"`
	// Output only. A list of the Backup for GKE CRD versions found in the
	// cluster.
	BackupCrdVersions map[string]string `protobuf:"bytes,3,rep,name=backup_crd_versions,json=backupCrdVersions,proto3" json:"backup_crd_versions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Platform-specific version
	//
	// Types that are assignable to PlatformVersion:
	//
	//	*Backup_ClusterMetadata_GkeVersion
	//	*Backup_ClusterMetadata_AnthosVersion
	PlatformVersion isBackup_ClusterMetadata_PlatformVersion `protobuf_oneof:"platform_version"`
}

func (x *Backup_ClusterMetadata) Reset() {
	*x = Backup_ClusterMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_backup_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Backup_ClusterMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Backup_ClusterMetadata) ProtoMessage() {}

func (x *Backup_ClusterMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_backup_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Backup_ClusterMetadata.ProtoReflect.Descriptor instead.
func (*Backup_ClusterMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_backup_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Backup_ClusterMetadata) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

func (x *Backup_ClusterMetadata) GetK8SVersion() string {
	if x != nil {
		return x.K8SVersion
	}
	return ""
}

func (x *Backup_ClusterMetadata) GetBackupCrdVersions() map[string]string {
	if x != nil {
		return x.BackupCrdVersions
	}
	return nil
}

func (m *Backup_ClusterMetadata) GetPlatformVersion() isBackup_ClusterMetadata_PlatformVersion {
	if m != nil {
		return m.PlatformVersion
	}
	return nil
}

func (x *Backup_ClusterMetadata) GetGkeVersion() string {
	if x, ok := x.GetPlatformVersion().(*Backup_ClusterMetadata_GkeVersion); ok {
		return x.GkeVersion
	}
	return ""
}

func (x *Backup_ClusterMetadata) GetAnthosVersion() string {
	if x, ok := x.GetPlatformVersion().(*Backup_ClusterMetadata_AnthosVersion); ok {
		return x.AnthosVersion
	}
	return ""
}

type isBackup_ClusterMetadata_PlatformVersion interface {
	isBackup_ClusterMetadata_PlatformVersion()
}

type Backup_ClusterMetadata_GkeVersion struct {
	// Output only. GKE version
	GkeVersion string `protobuf:"bytes,4,opt,name=gke_version,json=gkeVersion,proto3,oneof"`
}

type Backup_ClusterMetadata_AnthosVersion struct {
	// Output only. Anthos version
	AnthosVersion string `protobuf:"bytes,5,opt,name=anthos_version,json=anthosVersion,proto3,oneof"`
}

func (*Backup_ClusterMetadata_GkeVersion) isBackup_ClusterMetadata_PlatformVersion() {}

func (*Backup_ClusterMetadata_AnthosVersion) isBackup_ClusterMetadata_PlatformVersion() {}

var File_google_cloud_gkebackup_v1_backup_proto protoreflect.FileDescriptor

var file_google_cloud_gkebackup_v1_backup_proto_rawDesc = []byte{
	0x0a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe3, 0x11, 0x0a, 0x06, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03,
	0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03,
	0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x6d, 0x61, 0x6e, 0x75, 0x61,
	0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x6d, 0x61,
	0x6e, 0x75, 0x61, 0x6c, 0x12, 0x4a, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x2d, 0x0a, 0x10, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x6b, 0x5f,
	0x64, 0x61, 0x79, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c, 0x6f, 0x63, 0x6b, 0x44, 0x61, 0x79, 0x73, 0x12,
	0x56, 0x0a, 0x17, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x14, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c, 0x6f, 0x63, 0x6b, 0x45, 0x78, 0x70,
	0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x72, 0x65, 0x74, 0x61, 0x69,
	0x6e, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x44, 0x61, 0x79, 0x73, 0x12, 0x4d, 0x0a,
	0x12, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6e, 0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x0e,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0d, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b,
	0x65, 0x79, 0x12, 0x2c, 0x0a, 0x0e, 0x61, 0x6c, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x00, 0x52, 0x0d, 0x61, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73,
	0x12, 0x5d, 0x0a, 0x13, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x12, 0x73, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12,
	0x66, 0x0a, 0x15, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x00, 0x52, 0x14, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x35, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x73, 0x5f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x73, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x44, 0x61, 0x74, 0x61, 0x12, 0x2e,
	0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x12, 0x61,
	0x0a, 0x10, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x42, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x72,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x44, 0x0a,
	0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x14,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x15, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x26, 0x0a, 0x0c, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x16, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x76, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x69, 0x7a, 0x65, 0x5f,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x17, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x09, 0x73, 0x69, 0x7a, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x18, 0x18, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x19, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x6f, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x08, 0x70, 0x6f, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3c, 0x0a,
	0x18, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x03, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x70,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x1c,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x70, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x76, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x1a, 0x85, 0x03, 0x0a, 0x0f, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1d, 0x0a,
	0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x24, 0x0a, 0x0b,
	0x6b, 0x38, 0x73, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6b, 0x38, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x7d, 0x0a, 0x13, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63, 0x72, 0x64,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x72, 0x64, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x72, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x26, 0x0a, 0x0b, 0x67, 0x6b, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0a, 0x67,
	0x6b, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x0e, 0x61, 0x6e, 0x74,
	0x68, 0x6f, 0x73, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0d, 0x61, 0x6e, 0x74, 0x68, 0x6f, 0x73,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x44, 0x0a, 0x16, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x43, 0x72, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x12, 0x0a,
	0x10, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x66, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08,
	0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e,
	0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53,
	0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41,
	0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x05, 0x3a, 0x78, 0xea, 0x41, 0x75, 0x0a, 0x1f, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x52, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f,
	0x7b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x7d, 0x2f, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x7d, 0x42, 0x0e,
	0x0a, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x42, 0xc2,
	0x01, 0x0a, 0x1d, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31,
	0x42, 0x0b, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x70, 0x62,
	0x3b, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x70, 0x62, 0xaa, 0x02, 0x19, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x47, 0x6b, 0x65, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x47, 0x6b, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x47, 0x6b, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x3a,
	0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkebackup_v1_backup_proto_rawDescOnce sync.Once
	file_google_cloud_gkebackup_v1_backup_proto_rawDescData = file_google_cloud_gkebackup_v1_backup_proto_rawDesc
)

func file_google_cloud_gkebackup_v1_backup_proto_rawDescGZIP() []byte {
	file_google_cloud_gkebackup_v1_backup_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkebackup_v1_backup_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkebackup_v1_backup_proto_rawDescData)
	})
	return file_google_cloud_gkebackup_v1_backup_proto_rawDescData
}

var file_google_cloud_gkebackup_v1_backup_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_gkebackup_v1_backup_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_cloud_gkebackup_v1_backup_proto_goTypes = []interface{}{
	(Backup_State)(0),              // 0: google.cloud.gkebackup.v1.Backup.State
	(*Backup)(nil),                 // 1: google.cloud.gkebackup.v1.Backup
	(*Backup_ClusterMetadata)(nil), // 2: google.cloud.gkebackup.v1.Backup.ClusterMetadata
	nil,                            // 3: google.cloud.gkebackup.v1.Backup.LabelsEntry
	nil,                            // 4: google.cloud.gkebackup.v1.Backup.ClusterMetadata.BackupCrdVersionsEntry
	(*timestamppb.Timestamp)(nil),  // 5: google.protobuf.Timestamp
	(*EncryptionKey)(nil),          // 6: google.cloud.gkebackup.v1.EncryptionKey
	(*Namespaces)(nil),             // 7: google.cloud.gkebackup.v1.Namespaces
	(*NamespacedNames)(nil),        // 8: google.cloud.gkebackup.v1.NamespacedNames
}
var file_google_cloud_gkebackup_v1_backup_proto_depIdxs = []int32{
	5,  // 0: google.cloud.gkebackup.v1.Backup.create_time:type_name -> google.protobuf.Timestamp
	5,  // 1: google.cloud.gkebackup.v1.Backup.update_time:type_name -> google.protobuf.Timestamp
	3,  // 2: google.cloud.gkebackup.v1.Backup.labels:type_name -> google.cloud.gkebackup.v1.Backup.LabelsEntry
	5,  // 3: google.cloud.gkebackup.v1.Backup.delete_lock_expire_time:type_name -> google.protobuf.Timestamp
	5,  // 4: google.cloud.gkebackup.v1.Backup.retain_expire_time:type_name -> google.protobuf.Timestamp
	6,  // 5: google.cloud.gkebackup.v1.Backup.encryption_key:type_name -> google.cloud.gkebackup.v1.EncryptionKey
	7,  // 6: google.cloud.gkebackup.v1.Backup.selected_namespaces:type_name -> google.cloud.gkebackup.v1.Namespaces
	8,  // 7: google.cloud.gkebackup.v1.Backup.selected_applications:type_name -> google.cloud.gkebackup.v1.NamespacedNames
	2,  // 8: google.cloud.gkebackup.v1.Backup.cluster_metadata:type_name -> google.cloud.gkebackup.v1.Backup.ClusterMetadata
	0,  // 9: google.cloud.gkebackup.v1.Backup.state:type_name -> google.cloud.gkebackup.v1.Backup.State
	5,  // 10: google.cloud.gkebackup.v1.Backup.complete_time:type_name -> google.protobuf.Timestamp
	4,  // 11: google.cloud.gkebackup.v1.Backup.ClusterMetadata.backup_crd_versions:type_name -> google.cloud.gkebackup.v1.Backup.ClusterMetadata.BackupCrdVersionsEntry
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_gkebackup_v1_backup_proto_init() }
func file_google_cloud_gkebackup_v1_backup_proto_init() {
	if File_google_cloud_gkebackup_v1_backup_proto != nil {
		return
	}
	file_google_cloud_gkebackup_v1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gkebackup_v1_backup_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Backup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_backup_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Backup_ClusterMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_gkebackup_v1_backup_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Backup_AllNamespaces)(nil),
		(*Backup_SelectedNamespaces)(nil),
		(*Backup_SelectedApplications)(nil),
	}
	file_google_cloud_gkebackup_v1_backup_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*Backup_ClusterMetadata_GkeVersion)(nil),
		(*Backup_ClusterMetadata_AnthosVersion)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkebackup_v1_backup_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_gkebackup_v1_backup_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkebackup_v1_backup_proto_depIdxs,
		EnumInfos:         file_google_cloud_gkebackup_v1_backup_proto_enumTypes,
		MessageInfos:      file_google_cloud_gkebackup_v1_backup_proto_msgTypes,
	}.Build()
	File_google_cloud_gkebackup_v1_backup_proto = out.File
	file_google_cloud_gkebackup_v1_backup_proto_rawDesc = nil
	file_google_cloud_gkebackup_v1_backup_proto_goTypes = nil
	file_google_cloud_gkebackup_v1_backup_proto_depIdxs = nil
}
