// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/cx/v3/generator.proto

package cxpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Generators_ListGenerators_FullMethodName  = "/google.cloud.dialogflow.cx.v3.Generators/ListGenerators"
	Generators_GetGenerator_FullMethodName    = "/google.cloud.dialogflow.cx.v3.Generators/GetGenerator"
	Generators_CreateGenerator_FullMethodName = "/google.cloud.dialogflow.cx.v3.Generators/CreateGenerator"
	Generators_UpdateGenerator_FullMethodName = "/google.cloud.dialogflow.cx.v3.Generators/UpdateGenerator"
	Generators_DeleteGenerator_FullMethodName = "/google.cloud.dialogflow.cx.v3.Generators/DeleteGenerator"
)

// GeneratorsClient is the client API for Generators service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GeneratorsClient interface {
	// Returns the list of all generators in the specified agent.
	ListGenerators(ctx context.Context, in *ListGeneratorsRequest, opts ...grpc.CallOption) (*ListGeneratorsResponse, error)
	// Retrieves the specified generator.
	GetGenerator(ctx context.Context, in *GetGeneratorRequest, opts ...grpc.CallOption) (*Generator, error)
	// Creates a generator in the specified agent.
	CreateGenerator(ctx context.Context, in *CreateGeneratorRequest, opts ...grpc.CallOption) (*Generator, error)
	// Update the specified generator.
	UpdateGenerator(ctx context.Context, in *UpdateGeneratorRequest, opts ...grpc.CallOption) (*Generator, error)
	// Deletes the specified generators.
	DeleteGenerator(ctx context.Context, in *DeleteGeneratorRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type generatorsClient struct {
	cc grpc.ClientConnInterface
}

func NewGeneratorsClient(cc grpc.ClientConnInterface) GeneratorsClient {
	return &generatorsClient{cc}
}

func (c *generatorsClient) ListGenerators(ctx context.Context, in *ListGeneratorsRequest, opts ...grpc.CallOption) (*ListGeneratorsResponse, error) {
	out := new(ListGeneratorsResponse)
	err := c.cc.Invoke(ctx, Generators_ListGenerators_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generatorsClient) GetGenerator(ctx context.Context, in *GetGeneratorRequest, opts ...grpc.CallOption) (*Generator, error) {
	out := new(Generator)
	err := c.cc.Invoke(ctx, Generators_GetGenerator_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generatorsClient) CreateGenerator(ctx context.Context, in *CreateGeneratorRequest, opts ...grpc.CallOption) (*Generator, error) {
	out := new(Generator)
	err := c.cc.Invoke(ctx, Generators_CreateGenerator_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generatorsClient) UpdateGenerator(ctx context.Context, in *UpdateGeneratorRequest, opts ...grpc.CallOption) (*Generator, error) {
	out := new(Generator)
	err := c.cc.Invoke(ctx, Generators_UpdateGenerator_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generatorsClient) DeleteGenerator(ctx context.Context, in *DeleteGeneratorRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Generators_DeleteGenerator_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GeneratorsServer is the server API for Generators service.
// All implementations should embed UnimplementedGeneratorsServer
// for forward compatibility
type GeneratorsServer interface {
	// Returns the list of all generators in the specified agent.
	ListGenerators(context.Context, *ListGeneratorsRequest) (*ListGeneratorsResponse, error)
	// Retrieves the specified generator.
	GetGenerator(context.Context, *GetGeneratorRequest) (*Generator, error)
	// Creates a generator in the specified agent.
	CreateGenerator(context.Context, *CreateGeneratorRequest) (*Generator, error)
	// Update the specified generator.
	UpdateGenerator(context.Context, *UpdateGeneratorRequest) (*Generator, error)
	// Deletes the specified generators.
	DeleteGenerator(context.Context, *DeleteGeneratorRequest) (*emptypb.Empty, error)
}

// UnimplementedGeneratorsServer should be embedded to have forward compatible implementations.
type UnimplementedGeneratorsServer struct {
}

func (UnimplementedGeneratorsServer) ListGenerators(context.Context, *ListGeneratorsRequest) (*ListGeneratorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGenerators not implemented")
}
func (UnimplementedGeneratorsServer) GetGenerator(context.Context, *GetGeneratorRequest) (*Generator, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGenerator not implemented")
}
func (UnimplementedGeneratorsServer) CreateGenerator(context.Context, *CreateGeneratorRequest) (*Generator, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGenerator not implemented")
}
func (UnimplementedGeneratorsServer) UpdateGenerator(context.Context, *UpdateGeneratorRequest) (*Generator, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGenerator not implemented")
}
func (UnimplementedGeneratorsServer) DeleteGenerator(context.Context, *DeleteGeneratorRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGenerator not implemented")
}

// UnsafeGeneratorsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GeneratorsServer will
// result in compilation errors.
type UnsafeGeneratorsServer interface {
	mustEmbedUnimplementedGeneratorsServer()
}

func RegisterGeneratorsServer(s grpc.ServiceRegistrar, srv GeneratorsServer) {
	s.RegisterService(&Generators_ServiceDesc, srv)
}

func _Generators_ListGenerators_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGeneratorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GeneratorsServer).ListGenerators(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Generators_ListGenerators_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GeneratorsServer).ListGenerators(ctx, req.(*ListGeneratorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Generators_GetGenerator_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGeneratorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GeneratorsServer).GetGenerator(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Generators_GetGenerator_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GeneratorsServer).GetGenerator(ctx, req.(*GetGeneratorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Generators_CreateGenerator_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGeneratorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GeneratorsServer).CreateGenerator(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Generators_CreateGenerator_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GeneratorsServer).CreateGenerator(ctx, req.(*CreateGeneratorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Generators_UpdateGenerator_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGeneratorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GeneratorsServer).UpdateGenerator(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Generators_UpdateGenerator_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GeneratorsServer).UpdateGenerator(ctx, req.(*UpdateGeneratorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Generators_DeleteGenerator_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGeneratorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GeneratorsServer).DeleteGenerator(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Generators_DeleteGenerator_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GeneratorsServer).DeleteGenerator(ctx, req.(*DeleteGeneratorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Generators_ServiceDesc is the grpc.ServiceDesc for Generators service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Generators_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3.Generators",
	HandlerType: (*GeneratorsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListGenerators",
			Handler:    _Generators_ListGenerators_Handler,
		},
		{
			MethodName: "GetGenerator",
			Handler:    _Generators_GetGenerator_Handler,
		},
		{
			MethodName: "CreateGenerator",
			Handler:    _Generators_CreateGenerator_Handler,
		},
		{
			MethodName: "UpdateGenerator",
			Handler:    _Generators_UpdateGenerator_Handler,
		},
		{
			MethodName: "DeleteGenerator",
			Handler:    _Generators_DeleteGenerator_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3/generator.proto",
}
