// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.25.3
// source: google/cloud/dataplex/v1/resources.proto

package dataplexpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// State of a resource.
type State int32

const (
	// State is not specified.
	State_STATE_UNSPECIFIED State = 0
	// Resource is active, i.e., ready to use.
	State_ACTIVE State = 1
	// Resource is under creation.
	State_CREATING State = 2
	// Resource is under deletion.
	State_DELETING State = 3
	// Resource is active but has unresolved actions.
	State_ACTION_REQUIRED State = 4
)

// Enum value maps for State.
var (
	State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
		3: "DELETING",
		4: "ACTION_REQUIRED",
	}
	State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
		"DELETING":          3,
		"ACTION_REQUIRED":   4,
	}
)

func (x State) Enum() *State {
	p := new(State)
	*p = x
	return p
}

func (x State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_resources_proto_enumTypes[0].Descriptor()
}

func (State) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_resources_proto_enumTypes[0]
}

func (x State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use State.Descriptor instead.
func (State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{0}
}

// Current state of association.
type Lake_MetastoreStatus_State int32

const (
	// Unspecified.
	Lake_MetastoreStatus_STATE_UNSPECIFIED Lake_MetastoreStatus_State = 0
	// A Metastore service instance is not associated with the lake.
	Lake_MetastoreStatus_NONE Lake_MetastoreStatus_State = 1
	// A Metastore service instance is attached to the lake.
	Lake_MetastoreStatus_READY Lake_MetastoreStatus_State = 2
	// Attach/detach is in progress.
	Lake_MetastoreStatus_UPDATING Lake_MetastoreStatus_State = 3
	// Attach/detach could not be done due to errors.
	Lake_MetastoreStatus_ERROR Lake_MetastoreStatus_State = 4
)

// Enum value maps for Lake_MetastoreStatus_State.
var (
	Lake_MetastoreStatus_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "NONE",
		2: "READY",
		3: "UPDATING",
		4: "ERROR",
	}
	Lake_MetastoreStatus_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"NONE":              1,
		"READY":             2,
		"UPDATING":          3,
		"ERROR":             4,
	}
)

func (x Lake_MetastoreStatus_State) Enum() *Lake_MetastoreStatus_State {
	p := new(Lake_MetastoreStatus_State)
	*p = x
	return p
}

func (x Lake_MetastoreStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Lake_MetastoreStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_resources_proto_enumTypes[1].Descriptor()
}

func (Lake_MetastoreStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_resources_proto_enumTypes[1]
}

func (x Lake_MetastoreStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Lake_MetastoreStatus_State.Descriptor instead.
func (Lake_MetastoreStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{0, 1, 0}
}

// Type of zone.
type Zone_Type int32

const (
	// Zone type not specified.
	Zone_TYPE_UNSPECIFIED Zone_Type = 0
	// A zone that contains data that needs further processing before it is
	// considered generally ready for consumption and analytics workloads.
	Zone_RAW Zone_Type = 1
	// A zone that contains data that is considered to be ready for broader
	// consumption and analytics workloads. Curated structured data stored in
	// Cloud Storage must conform to certain file formats (parquet, avro and
	// orc) and organized in a hive-compatible directory layout.
	Zone_CURATED Zone_Type = 2
)

// Enum value maps for Zone_Type.
var (
	Zone_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "RAW",
		2: "CURATED",
	}
	Zone_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"RAW":              1,
		"CURATED":          2,
	}
)

func (x Zone_Type) Enum() *Zone_Type {
	p := new(Zone_Type)
	*p = x
	return p
}

func (x Zone_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Zone_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_resources_proto_enumTypes[2].Descriptor()
}

func (Zone_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_resources_proto_enumTypes[2]
}

func (x Zone_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Zone_Type.Descriptor instead.
func (Zone_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{2, 0}
}

// Location type of the resources attached to a zone.
type Zone_ResourceSpec_LocationType int32

const (
	// Unspecified location type.
	Zone_ResourceSpec_LOCATION_TYPE_UNSPECIFIED Zone_ResourceSpec_LocationType = 0
	// Resources that are associated with a single region.
	Zone_ResourceSpec_SINGLE_REGION Zone_ResourceSpec_LocationType = 1
	// Resources that are associated with a multi-region location.
	Zone_ResourceSpec_MULTI_REGION Zone_ResourceSpec_LocationType = 2
)

// Enum value maps for Zone_ResourceSpec_LocationType.
var (
	Zone_ResourceSpec_LocationType_name = map[int32]string{
		0: "LOCATION_TYPE_UNSPECIFIED",
		1: "SINGLE_REGION",
		2: "MULTI_REGION",
	}
	Zone_ResourceSpec_LocationType_value = map[string]int32{
		"LOCATION_TYPE_UNSPECIFIED": 0,
		"SINGLE_REGION":             1,
		"MULTI_REGION":              2,
	}
)

func (x Zone_ResourceSpec_LocationType) Enum() *Zone_ResourceSpec_LocationType {
	p := new(Zone_ResourceSpec_LocationType)
	*p = x
	return p
}

func (x Zone_ResourceSpec_LocationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Zone_ResourceSpec_LocationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_resources_proto_enumTypes[3].Descriptor()
}

func (Zone_ResourceSpec_LocationType) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_resources_proto_enumTypes[3]
}

func (x Zone_ResourceSpec_LocationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Zone_ResourceSpec_LocationType.Descriptor instead.
func (Zone_ResourceSpec_LocationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{2, 0, 0}
}

// The category of issues.
type Action_Category int32

const (
	// Unspecified category.
	Action_CATEGORY_UNSPECIFIED Action_Category = 0
	// Resource management related issues.
	Action_RESOURCE_MANAGEMENT Action_Category = 1
	// Security policy related issues.
	Action_SECURITY_POLICY Action_Category = 2
	// Data and discovery related issues.
	Action_DATA_DISCOVERY Action_Category = 3
)

// Enum value maps for Action_Category.
var (
	Action_Category_name = map[int32]string{
		0: "CATEGORY_UNSPECIFIED",
		1: "RESOURCE_MANAGEMENT",
		2: "SECURITY_POLICY",
		3: "DATA_DISCOVERY",
	}
	Action_Category_value = map[string]int32{
		"CATEGORY_UNSPECIFIED": 0,
		"RESOURCE_MANAGEMENT":  1,
		"SECURITY_POLICY":      2,
		"DATA_DISCOVERY":       3,
	}
)

func (x Action_Category) Enum() *Action_Category {
	p := new(Action_Category)
	*p = x
	return p
}

func (x Action_Category) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Action_Category) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_resources_proto_enumTypes[4].Descriptor()
}

func (Action_Category) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_resources_proto_enumTypes[4]
}

func (x Action_Category) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Action_Category.Descriptor instead.
func (Action_Category) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{3, 0}
}

// Whether the action relates to a schema that is incompatible or modified.
type Action_IncompatibleDataSchema_SchemaChange int32

const (
	// Schema change unspecified.
	Action_IncompatibleDataSchema_SCHEMA_CHANGE_UNSPECIFIED Action_IncompatibleDataSchema_SchemaChange = 0
	// Newly discovered schema is incompatible with existing schema.
	Action_IncompatibleDataSchema_INCOMPATIBLE Action_IncompatibleDataSchema_SchemaChange = 1
	// Newly discovered schema has changed from existing schema for data in a
	// curated zone.
	Action_IncompatibleDataSchema_MODIFIED Action_IncompatibleDataSchema_SchemaChange = 2
)

// Enum value maps for Action_IncompatibleDataSchema_SchemaChange.
var (
	Action_IncompatibleDataSchema_SchemaChange_name = map[int32]string{
		0: "SCHEMA_CHANGE_UNSPECIFIED",
		1: "INCOMPATIBLE",
		2: "MODIFIED",
	}
	Action_IncompatibleDataSchema_SchemaChange_value = map[string]int32{
		"SCHEMA_CHANGE_UNSPECIFIED": 0,
		"INCOMPATIBLE":              1,
		"MODIFIED":                  2,
	}
)

func (x Action_IncompatibleDataSchema_SchemaChange) Enum() *Action_IncompatibleDataSchema_SchemaChange {
	p := new(Action_IncompatibleDataSchema_SchemaChange)
	*p = x
	return p
}

func (x Action_IncompatibleDataSchema_SchemaChange) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Action_IncompatibleDataSchema_SchemaChange) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_resources_proto_enumTypes[5].Descriptor()
}

func (Action_IncompatibleDataSchema_SchemaChange) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_resources_proto_enumTypes[5]
}

func (x Action_IncompatibleDataSchema_SchemaChange) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Action_IncompatibleDataSchema_SchemaChange.Descriptor instead.
func (Action_IncompatibleDataSchema_SchemaChange) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{3, 4, 0}
}

// The expected partition structure.
type Action_InvalidDataPartition_PartitionStructure int32

const (
	// PartitionStructure unspecified.
	Action_InvalidDataPartition_PARTITION_STRUCTURE_UNSPECIFIED Action_InvalidDataPartition_PartitionStructure = 0
	// Consistent hive-style partition definition (both raw and curated zone).
	Action_InvalidDataPartition_CONSISTENT_KEYS Action_InvalidDataPartition_PartitionStructure = 1
	// Hive style partition definition (curated zone only).
	Action_InvalidDataPartition_HIVE_STYLE_KEYS Action_InvalidDataPartition_PartitionStructure = 2
)

// Enum value maps for Action_InvalidDataPartition_PartitionStructure.
var (
	Action_InvalidDataPartition_PartitionStructure_name = map[int32]string{
		0: "PARTITION_STRUCTURE_UNSPECIFIED",
		1: "CONSISTENT_KEYS",
		2: "HIVE_STYLE_KEYS",
	}
	Action_InvalidDataPartition_PartitionStructure_value = map[string]int32{
		"PARTITION_STRUCTURE_UNSPECIFIED": 0,
		"CONSISTENT_KEYS":                 1,
		"HIVE_STYLE_KEYS":                 2,
	}
)

func (x Action_InvalidDataPartition_PartitionStructure) Enum() *Action_InvalidDataPartition_PartitionStructure {
	p := new(Action_InvalidDataPartition_PartitionStructure)
	*p = x
	return p
}

func (x Action_InvalidDataPartition_PartitionStructure) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Action_InvalidDataPartition_PartitionStructure) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_resources_proto_enumTypes[6].Descriptor()
}

func (Action_InvalidDataPartition_PartitionStructure) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_resources_proto_enumTypes[6]
}

func (x Action_InvalidDataPartition_PartitionStructure) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Action_InvalidDataPartition_PartitionStructure.Descriptor instead.
func (Action_InvalidDataPartition_PartitionStructure) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{3, 5, 0}
}

// The state of the security policy.
type Asset_SecurityStatus_State int32

const (
	// State unspecified.
	Asset_SecurityStatus_STATE_UNSPECIFIED Asset_SecurityStatus_State = 0
	// Security policy has been successfully applied to the attached resource.
	Asset_SecurityStatus_READY Asset_SecurityStatus_State = 1
	// Security policy is in the process of being applied to the attached
	// resource.
	Asset_SecurityStatus_APPLYING Asset_SecurityStatus_State = 2
	// Security policy could not be applied to the attached resource due to
	// errors.
	Asset_SecurityStatus_ERROR Asset_SecurityStatus_State = 3
)

// Enum value maps for Asset_SecurityStatus_State.
var (
	Asset_SecurityStatus_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "READY",
		2: "APPLYING",
		3: "ERROR",
	}
	Asset_SecurityStatus_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"READY":             1,
		"APPLYING":          2,
		"ERROR":             3,
	}
)

func (x Asset_SecurityStatus_State) Enum() *Asset_SecurityStatus_State {
	p := new(Asset_SecurityStatus_State)
	*p = x
	return p
}

func (x Asset_SecurityStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Asset_SecurityStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_resources_proto_enumTypes[7].Descriptor()
}

func (Asset_SecurityStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_resources_proto_enumTypes[7]
}

func (x Asset_SecurityStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Asset_SecurityStatus_State.Descriptor instead.
func (Asset_SecurityStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{4, 0, 0}
}

// Type of resource.
type Asset_ResourceSpec_Type int32

const (
	// Type not specified.
	Asset_ResourceSpec_TYPE_UNSPECIFIED Asset_ResourceSpec_Type = 0
	// Cloud Storage bucket.
	Asset_ResourceSpec_STORAGE_BUCKET Asset_ResourceSpec_Type = 1
	// BigQuery dataset.
	Asset_ResourceSpec_BIGQUERY_DATASET Asset_ResourceSpec_Type = 2
)

// Enum value maps for Asset_ResourceSpec_Type.
var (
	Asset_ResourceSpec_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "STORAGE_BUCKET",
		2: "BIGQUERY_DATASET",
	}
	Asset_ResourceSpec_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"STORAGE_BUCKET":   1,
		"BIGQUERY_DATASET": 2,
	}
)

func (x Asset_ResourceSpec_Type) Enum() *Asset_ResourceSpec_Type {
	p := new(Asset_ResourceSpec_Type)
	*p = x
	return p
}

func (x Asset_ResourceSpec_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Asset_ResourceSpec_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_resources_proto_enumTypes[8].Descriptor()
}

func (Asset_ResourceSpec_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_resources_proto_enumTypes[8]
}

func (x Asset_ResourceSpec_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Asset_ResourceSpec_Type.Descriptor instead.
func (Asset_ResourceSpec_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{4, 2, 0}
}

// Access Mode determines how data stored within the resource is read. This
// is only applicable to storage bucket assets.
type Asset_ResourceSpec_AccessMode int32

const (
	// Access mode unspecified.
	Asset_ResourceSpec_ACCESS_MODE_UNSPECIFIED Asset_ResourceSpec_AccessMode = 0
	// Default. Data is accessed directly using storage APIs.
	Asset_ResourceSpec_DIRECT Asset_ResourceSpec_AccessMode = 1
	// Data is accessed through a managed interface using BigQuery APIs.
	Asset_ResourceSpec_MANAGED Asset_ResourceSpec_AccessMode = 2
)

// Enum value maps for Asset_ResourceSpec_AccessMode.
var (
	Asset_ResourceSpec_AccessMode_name = map[int32]string{
		0: "ACCESS_MODE_UNSPECIFIED",
		1: "DIRECT",
		2: "MANAGED",
	}
	Asset_ResourceSpec_AccessMode_value = map[string]int32{
		"ACCESS_MODE_UNSPECIFIED": 0,
		"DIRECT":                  1,
		"MANAGED":                 2,
	}
)

func (x Asset_ResourceSpec_AccessMode) Enum() *Asset_ResourceSpec_AccessMode {
	p := new(Asset_ResourceSpec_AccessMode)
	*p = x
	return p
}

func (x Asset_ResourceSpec_AccessMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Asset_ResourceSpec_AccessMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_resources_proto_enumTypes[9].Descriptor()
}

func (Asset_ResourceSpec_AccessMode) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_resources_proto_enumTypes[9]
}

func (x Asset_ResourceSpec_AccessMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Asset_ResourceSpec_AccessMode.Descriptor instead.
func (Asset_ResourceSpec_AccessMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{4, 2, 1}
}

// The state of a resource.
type Asset_ResourceStatus_State int32

const (
	// State unspecified.
	Asset_ResourceStatus_STATE_UNSPECIFIED Asset_ResourceStatus_State = 0
	// Resource does not have any errors.
	Asset_ResourceStatus_READY Asset_ResourceStatus_State = 1
	// Resource has errors.
	Asset_ResourceStatus_ERROR Asset_ResourceStatus_State = 2
)

// Enum value maps for Asset_ResourceStatus_State.
var (
	Asset_ResourceStatus_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "READY",
		2: "ERROR",
	}
	Asset_ResourceStatus_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"READY":             1,
		"ERROR":             2,
	}
)

func (x Asset_ResourceStatus_State) Enum() *Asset_ResourceStatus_State {
	p := new(Asset_ResourceStatus_State)
	*p = x
	return p
}

func (x Asset_ResourceStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Asset_ResourceStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_resources_proto_enumTypes[10].Descriptor()
}

func (Asset_ResourceStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_resources_proto_enumTypes[10]
}

func (x Asset_ResourceStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Asset_ResourceStatus_State.Descriptor instead.
func (Asset_ResourceStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{4, 3, 0}
}

// Current state of discovery.
type Asset_DiscoveryStatus_State int32

const (
	// State is unspecified.
	Asset_DiscoveryStatus_STATE_UNSPECIFIED Asset_DiscoveryStatus_State = 0
	// Discovery for the asset is scheduled.
	Asset_DiscoveryStatus_SCHEDULED Asset_DiscoveryStatus_State = 1
	// Discovery for the asset is running.
	Asset_DiscoveryStatus_IN_PROGRESS Asset_DiscoveryStatus_State = 2
	// Discovery for the asset is currently paused (e.g. due to a lack
	// of available resources). It will be automatically resumed.
	Asset_DiscoveryStatus_PAUSED Asset_DiscoveryStatus_State = 3
	// Discovery for the asset is disabled.
	Asset_DiscoveryStatus_DISABLED Asset_DiscoveryStatus_State = 5
)

// Enum value maps for Asset_DiscoveryStatus_State.
var (
	Asset_DiscoveryStatus_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "SCHEDULED",
		2: "IN_PROGRESS",
		3: "PAUSED",
		5: "DISABLED",
	}
	Asset_DiscoveryStatus_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"SCHEDULED":         1,
		"IN_PROGRESS":       2,
		"PAUSED":            3,
		"DISABLED":          5,
	}
)

func (x Asset_DiscoveryStatus_State) Enum() *Asset_DiscoveryStatus_State {
	p := new(Asset_DiscoveryStatus_State)
	*p = x
	return p
}

func (x Asset_DiscoveryStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Asset_DiscoveryStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_resources_proto_enumTypes[11].Descriptor()
}

func (Asset_DiscoveryStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_resources_proto_enumTypes[11]
}

func (x Asset_DiscoveryStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Asset_DiscoveryStatus_State.Descriptor instead.
func (Asset_DiscoveryStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{4, 4, 0}
}

// A lake is a centralized repository for managing enterprise data across the
// organization distributed across many cloud projects, and stored in a variety
// of storage services such as Google Cloud Storage and BigQuery. The resources
// attached to a lake are referred to as managed resources. Data within these
// managed resources can be structured or unstructured. A lake provides data
// admins with tools to organize, secure and manage their data at scale, and
// provides data scientists and data engineers an integrated experience to
// easily search, discover, analyze and transform data and associated metadata.
type Lake struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The relative resource name of the lake, of the form:
	// `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. User friendly display name.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. System generated globally unique ID for the lake. This ID will
	// be different if the lake is deleted and re-created with the same name.
	Uid string `protobuf:"bytes,3,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The time when the lake was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the lake was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. User-defined labels for the lake.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Description of the lake.
	Description string `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Current state of the lake.
	State State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.dataplex.v1.State" json:"state,omitempty"`
	// Output only. Service account associated with this lake. This service
	// account must be authorized to access or operate on resources managed by the
	// lake.
	ServiceAccount string `protobuf:"bytes,9,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Optional. Settings to manage lake and Dataproc Metastore service instance
	// association.
	Metastore *Lake_Metastore `protobuf:"bytes,102,opt,name=metastore,proto3" json:"metastore,omitempty"`
	// Output only. Aggregated status of the underlying assets of the lake.
	AssetStatus *AssetStatus `protobuf:"bytes,103,opt,name=asset_status,json=assetStatus,proto3" json:"asset_status,omitempty"`
	// Output only. Metastore status of the lake.
	MetastoreStatus *Lake_MetastoreStatus `protobuf:"bytes,104,opt,name=metastore_status,json=metastoreStatus,proto3" json:"metastore_status,omitempty"`
}

func (x *Lake) Reset() {
	*x = Lake{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Lake) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Lake) ProtoMessage() {}

func (x *Lake) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Lake.ProtoReflect.Descriptor instead.
func (*Lake) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{0}
}

func (x *Lake) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Lake) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Lake) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Lake) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Lake) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Lake) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Lake) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Lake) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

func (x *Lake) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *Lake) GetMetastore() *Lake_Metastore {
	if x != nil {
		return x.Metastore
	}
	return nil
}

func (x *Lake) GetAssetStatus() *AssetStatus {
	if x != nil {
		return x.AssetStatus
	}
	return nil
}

func (x *Lake) GetMetastoreStatus() *Lake_MetastoreStatus {
	if x != nil {
		return x.MetastoreStatus
	}
	return nil
}

// Aggregated status of the underlying assets of a lake or zone.
type AssetStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Last update time of the status.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Number of active assets.
	ActiveAssets int32 `protobuf:"varint,2,opt,name=active_assets,json=activeAssets,proto3" json:"active_assets,omitempty"`
	// Number of assets that are in process of updating the security policy on
	// attached resources.
	SecurityPolicyApplyingAssets int32 `protobuf:"varint,3,opt,name=security_policy_applying_assets,json=securityPolicyApplyingAssets,proto3" json:"security_policy_applying_assets,omitempty"`
}

func (x *AssetStatus) Reset() {
	*x = AssetStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AssetStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssetStatus) ProtoMessage() {}

func (x *AssetStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssetStatus.ProtoReflect.Descriptor instead.
func (*AssetStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{1}
}

func (x *AssetStatus) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *AssetStatus) GetActiveAssets() int32 {
	if x != nil {
		return x.ActiveAssets
	}
	return 0
}

func (x *AssetStatus) GetSecurityPolicyApplyingAssets() int32 {
	if x != nil {
		return x.SecurityPolicyApplyingAssets
	}
	return 0
}

// A zone represents a logical group of related assets within a lake. A zone can
// be used to map to organizational structure or represent stages of data
// readiness from raw to curated. It provides managing behavior that is shared
// or inherited by all contained assets.
type Zone struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The relative resource name of the zone, of the form:
	// `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. User friendly display name.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. System generated globally unique ID for the zone. This ID will
	// be different if the zone is deleted and re-created with the same name.
	Uid string `protobuf:"bytes,3,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The time when the zone was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the zone was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. User defined labels for the zone.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Description of the zone.
	Description string `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Current state of the zone.
	State State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.dataplex.v1.State" json:"state,omitempty"`
	// Required. Immutable. The type of the zone.
	Type Zone_Type `protobuf:"varint,9,opt,name=type,proto3,enum=google.cloud.dataplex.v1.Zone_Type" json:"type,omitempty"`
	// Optional. Specification of the discovery feature applied to data in this
	// zone.
	DiscoverySpec *Zone_DiscoverySpec `protobuf:"bytes,103,opt,name=discovery_spec,json=discoverySpec,proto3" json:"discovery_spec,omitempty"`
	// Required. Specification of the resources that are referenced by the assets
	// within this zone.
	ResourceSpec *Zone_ResourceSpec `protobuf:"bytes,104,opt,name=resource_spec,json=resourceSpec,proto3" json:"resource_spec,omitempty"`
	// Output only. Aggregated status of the underlying assets of the zone.
	AssetStatus *AssetStatus `protobuf:"bytes,105,opt,name=asset_status,json=assetStatus,proto3" json:"asset_status,omitempty"`
}

func (x *Zone) Reset() {
	*x = Zone{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Zone) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Zone) ProtoMessage() {}

func (x *Zone) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Zone.ProtoReflect.Descriptor instead.
func (*Zone) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{2}
}

func (x *Zone) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Zone) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Zone) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Zone) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Zone) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Zone) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Zone) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Zone) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

func (x *Zone) GetType() Zone_Type {
	if x != nil {
		return x.Type
	}
	return Zone_TYPE_UNSPECIFIED
}

func (x *Zone) GetDiscoverySpec() *Zone_DiscoverySpec {
	if x != nil {
		return x.DiscoverySpec
	}
	return nil
}

func (x *Zone) GetResourceSpec() *Zone_ResourceSpec {
	if x != nil {
		return x.ResourceSpec
	}
	return nil
}

func (x *Zone) GetAssetStatus() *AssetStatus {
	if x != nil {
		return x.AssetStatus
	}
	return nil
}

// Action represents an issue requiring administrator action for resolution.
type Action struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The category of issue associated with the action.
	Category Action_Category `protobuf:"varint,1,opt,name=category,proto3,enum=google.cloud.dataplex.v1.Action_Category" json:"category,omitempty"`
	// Detailed description of the issue requiring action.
	Issue string `protobuf:"bytes,2,opt,name=issue,proto3" json:"issue,omitempty"`
	// The time that the issue was detected.
	DetectTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=detect_time,json=detectTime,proto3" json:"detect_time,omitempty"`
	// Output only. The relative resource name of the action, of the form:
	// `projects/{project}/locations/{location}/lakes/{lake}/actions/{action}`
	// `projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/actions/{action}`
	// `projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/assets/{asset}/actions/{action}`.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The relative resource name of the lake, of the form:
	// `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
	Lake string `protobuf:"bytes,6,opt,name=lake,proto3" json:"lake,omitempty"`
	// Output only. The relative resource name of the zone, of the form:
	// `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
	Zone string `protobuf:"bytes,7,opt,name=zone,proto3" json:"zone,omitempty"`
	// Output only. The relative resource name of the asset, of the form:
	// `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}`.
	Asset string `protobuf:"bytes,8,opt,name=asset,proto3" json:"asset,omitempty"`
	// The list of data locations associated with this action. Cloud Storage
	// locations are represented as URI paths(E.g.
	// `gs://bucket/table1/year=2020/month=Jan/`). BigQuery locations refer to
	// resource names(E.g.
	// `bigquery.googleapis.com/projects/project-id/datasets/dataset-id`).
	DataLocations []string `protobuf:"bytes,9,rep,name=data_locations,json=dataLocations,proto3" json:"data_locations,omitempty"`
	// Additional details about the action based on the action category.
	//
	// Types that are assignable to Details:
	//
	//	*Action_InvalidDataFormat_
	//	*Action_IncompatibleDataSchema_
	//	*Action_InvalidDataPartition_
	//	*Action_MissingData_
	//	*Action_MissingResource_
	//	*Action_UnauthorizedResource_
	//	*Action_FailedSecurityPolicyApply_
	//	*Action_InvalidDataOrganization_
	Details isAction_Details `protobuf_oneof:"details"`
}

func (x *Action) Reset() {
	*x = Action{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action) ProtoMessage() {}

func (x *Action) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action.ProtoReflect.Descriptor instead.
func (*Action) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{3}
}

func (x *Action) GetCategory() Action_Category {
	if x != nil {
		return x.Category
	}
	return Action_CATEGORY_UNSPECIFIED
}

func (x *Action) GetIssue() string {
	if x != nil {
		return x.Issue
	}
	return ""
}

func (x *Action) GetDetectTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DetectTime
	}
	return nil
}

func (x *Action) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Action) GetLake() string {
	if x != nil {
		return x.Lake
	}
	return ""
}

func (x *Action) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *Action) GetAsset() string {
	if x != nil {
		return x.Asset
	}
	return ""
}

func (x *Action) GetDataLocations() []string {
	if x != nil {
		return x.DataLocations
	}
	return nil
}

func (m *Action) GetDetails() isAction_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (x *Action) GetInvalidDataFormat() *Action_InvalidDataFormat {
	if x, ok := x.GetDetails().(*Action_InvalidDataFormat_); ok {
		return x.InvalidDataFormat
	}
	return nil
}

func (x *Action) GetIncompatibleDataSchema() *Action_IncompatibleDataSchema {
	if x, ok := x.GetDetails().(*Action_IncompatibleDataSchema_); ok {
		return x.IncompatibleDataSchema
	}
	return nil
}

func (x *Action) GetInvalidDataPartition() *Action_InvalidDataPartition {
	if x, ok := x.GetDetails().(*Action_InvalidDataPartition_); ok {
		return x.InvalidDataPartition
	}
	return nil
}

func (x *Action) GetMissingData() *Action_MissingData {
	if x, ok := x.GetDetails().(*Action_MissingData_); ok {
		return x.MissingData
	}
	return nil
}

func (x *Action) GetMissingResource() *Action_MissingResource {
	if x, ok := x.GetDetails().(*Action_MissingResource_); ok {
		return x.MissingResource
	}
	return nil
}

func (x *Action) GetUnauthorizedResource() *Action_UnauthorizedResource {
	if x, ok := x.GetDetails().(*Action_UnauthorizedResource_); ok {
		return x.UnauthorizedResource
	}
	return nil
}

func (x *Action) GetFailedSecurityPolicyApply() *Action_FailedSecurityPolicyApply {
	if x, ok := x.GetDetails().(*Action_FailedSecurityPolicyApply_); ok {
		return x.FailedSecurityPolicyApply
	}
	return nil
}

func (x *Action) GetInvalidDataOrganization() *Action_InvalidDataOrganization {
	if x, ok := x.GetDetails().(*Action_InvalidDataOrganization_); ok {
		return x.InvalidDataOrganization
	}
	return nil
}

type isAction_Details interface {
	isAction_Details()
}

type Action_InvalidDataFormat_ struct {
	// Details for issues related to invalid or unsupported data formats.
	InvalidDataFormat *Action_InvalidDataFormat `protobuf:"bytes,10,opt,name=invalid_data_format,json=invalidDataFormat,proto3,oneof"`
}

type Action_IncompatibleDataSchema_ struct {
	// Details for issues related to incompatible schemas detected within data.
	IncompatibleDataSchema *Action_IncompatibleDataSchema `protobuf:"bytes,11,opt,name=incompatible_data_schema,json=incompatibleDataSchema,proto3,oneof"`
}

type Action_InvalidDataPartition_ struct {
	// Details for issues related to invalid or unsupported data partition
	// structure.
	InvalidDataPartition *Action_InvalidDataPartition `protobuf:"bytes,12,opt,name=invalid_data_partition,json=invalidDataPartition,proto3,oneof"`
}

type Action_MissingData_ struct {
	// Details for issues related to absence of data within managed resources.
	MissingData *Action_MissingData `protobuf:"bytes,13,opt,name=missing_data,json=missingData,proto3,oneof"`
}

type Action_MissingResource_ struct {
	// Details for issues related to absence of a managed resource.
	MissingResource *Action_MissingResource `protobuf:"bytes,14,opt,name=missing_resource,json=missingResource,proto3,oneof"`
}

type Action_UnauthorizedResource_ struct {
	// Details for issues related to lack of permissions to access data
	// resources.
	UnauthorizedResource *Action_UnauthorizedResource `protobuf:"bytes,15,opt,name=unauthorized_resource,json=unauthorizedResource,proto3,oneof"`
}

type Action_FailedSecurityPolicyApply_ struct {
	// Details for issues related to applying security policy.
	FailedSecurityPolicyApply *Action_FailedSecurityPolicyApply `protobuf:"bytes,21,opt,name=failed_security_policy_apply,json=failedSecurityPolicyApply,proto3,oneof"`
}

type Action_InvalidDataOrganization_ struct {
	// Details for issues related to invalid data arrangement.
	InvalidDataOrganization *Action_InvalidDataOrganization `protobuf:"bytes,22,opt,name=invalid_data_organization,json=invalidDataOrganization,proto3,oneof"`
}

func (*Action_InvalidDataFormat_) isAction_Details() {}

func (*Action_IncompatibleDataSchema_) isAction_Details() {}

func (*Action_InvalidDataPartition_) isAction_Details() {}

func (*Action_MissingData_) isAction_Details() {}

func (*Action_MissingResource_) isAction_Details() {}

func (*Action_UnauthorizedResource_) isAction_Details() {}

func (*Action_FailedSecurityPolicyApply_) isAction_Details() {}

func (*Action_InvalidDataOrganization_) isAction_Details() {}

// An asset represents a cloud resource that is being managed within a lake as a
// member of a zone.
type Asset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The relative resource name of the asset, of the form:
	// `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. User friendly display name.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. System generated globally unique ID for the asset. This ID
	// will be different if the asset is deleted and re-created with the same
	// name.
	Uid string `protobuf:"bytes,3,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The time when the asset was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the asset was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. User defined labels for the asset.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Description of the asset.
	Description string `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Current state of the asset.
	State State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.dataplex.v1.State" json:"state,omitempty"`
	// Required. Specification of the resource that is referenced by this asset.
	ResourceSpec *Asset_ResourceSpec `protobuf:"bytes,100,opt,name=resource_spec,json=resourceSpec,proto3" json:"resource_spec,omitempty"`
	// Output only. Status of the resource referenced by this asset.
	ResourceStatus *Asset_ResourceStatus `protobuf:"bytes,101,opt,name=resource_status,json=resourceStatus,proto3" json:"resource_status,omitempty"`
	// Output only. Status of the security policy applied to resource referenced
	// by this asset.
	SecurityStatus *Asset_SecurityStatus `protobuf:"bytes,103,opt,name=security_status,json=securityStatus,proto3" json:"security_status,omitempty"`
	// Optional. Specification of the discovery feature applied to data referenced
	// by this asset. When this spec is left unset, the asset will use the spec
	// set on the parent zone.
	DiscoverySpec *Asset_DiscoverySpec `protobuf:"bytes,106,opt,name=discovery_spec,json=discoverySpec,proto3" json:"discovery_spec,omitempty"`
	// Output only. Status of the discovery feature applied to data referenced by
	// this asset.
	DiscoveryStatus *Asset_DiscoveryStatus `protobuf:"bytes,107,opt,name=discovery_status,json=discoveryStatus,proto3" json:"discovery_status,omitempty"`
}

func (x *Asset) Reset() {
	*x = Asset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Asset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Asset) ProtoMessage() {}

func (x *Asset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Asset.ProtoReflect.Descriptor instead.
func (*Asset) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{4}
}

func (x *Asset) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Asset) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Asset) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Asset) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Asset) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Asset) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Asset) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Asset) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

func (x *Asset) GetResourceSpec() *Asset_ResourceSpec {
	if x != nil {
		return x.ResourceSpec
	}
	return nil
}

func (x *Asset) GetResourceStatus() *Asset_ResourceStatus {
	if x != nil {
		return x.ResourceStatus
	}
	return nil
}

func (x *Asset) GetSecurityStatus() *Asset_SecurityStatus {
	if x != nil {
		return x.SecurityStatus
	}
	return nil
}

func (x *Asset) GetDiscoverySpec() *Asset_DiscoverySpec {
	if x != nil {
		return x.DiscoverySpec
	}
	return nil
}

func (x *Asset) GetDiscoveryStatus() *Asset_DiscoveryStatus {
	if x != nil {
		return x.DiscoveryStatus
	}
	return nil
}

// Settings to manage association of Dataproc Metastore with a lake.
type Lake_Metastore struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A relative reference to the Dataproc Metastore
	// (https://cloud.google.com/dataproc-metastore/docs) service associated
	// with the lake:
	// `projects/{project_id}/locations/{location_id}/services/{service_id}`
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
}

func (x *Lake_Metastore) Reset() {
	*x = Lake_Metastore{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Lake_Metastore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Lake_Metastore) ProtoMessage() {}

func (x *Lake_Metastore) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Lake_Metastore.ProtoReflect.Descriptor instead.
func (*Lake_Metastore) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Lake_Metastore) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

// Status of Lake and Dataproc Metastore service instance association.
type Lake_MetastoreStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Current state of association.
	State Lake_MetastoreStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.dataplex.v1.Lake_MetastoreStatus_State" json:"state,omitempty"`
	// Additional information about the current status.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// Last update time of the metastore status of the lake.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The URI of the endpoint used to access the Metastore service.
	Endpoint string `protobuf:"bytes,4,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
}

func (x *Lake_MetastoreStatus) Reset() {
	*x = Lake_MetastoreStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Lake_MetastoreStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Lake_MetastoreStatus) ProtoMessage() {}

func (x *Lake_MetastoreStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Lake_MetastoreStatus.ProtoReflect.Descriptor instead.
func (*Lake_MetastoreStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Lake_MetastoreStatus) GetState() Lake_MetastoreStatus_State {
	if x != nil {
		return x.State
	}
	return Lake_MetastoreStatus_STATE_UNSPECIFIED
}

func (x *Lake_MetastoreStatus) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *Lake_MetastoreStatus) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Lake_MetastoreStatus) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

// Settings for resources attached as assets within a zone.
type Zone_ResourceSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. The location type of the resources that are allowed
	// to be attached to the assets within this zone.
	LocationType Zone_ResourceSpec_LocationType `protobuf:"varint,1,opt,name=location_type,json=locationType,proto3,enum=google.cloud.dataplex.v1.Zone_ResourceSpec_LocationType" json:"location_type,omitempty"`
}

func (x *Zone_ResourceSpec) Reset() {
	*x = Zone_ResourceSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Zone_ResourceSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Zone_ResourceSpec) ProtoMessage() {}

func (x *Zone_ResourceSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Zone_ResourceSpec.ProtoReflect.Descriptor instead.
func (*Zone_ResourceSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{2, 0}
}

func (x *Zone_ResourceSpec) GetLocationType() Zone_ResourceSpec_LocationType {
	if x != nil {
		return x.LocationType
	}
	return Zone_ResourceSpec_LOCATION_TYPE_UNSPECIFIED
}

// Settings to manage the metadata discovery and publishing in a zone.
type Zone_DiscoverySpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Whether discovery is enabled.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Optional. The list of patterns to apply for selecting data to include
	// during discovery if only a subset of the data should considered. For
	// Cloud Storage bucket assets, these are interpreted as glob patterns used
	// to match object names. For BigQuery dataset assets, these are interpreted
	// as patterns to match table names.
	IncludePatterns []string `protobuf:"bytes,2,rep,name=include_patterns,json=includePatterns,proto3" json:"include_patterns,omitempty"`
	// Optional. The list of patterns to apply for selecting data to exclude
	// during discovery.  For Cloud Storage bucket assets, these are interpreted
	// as glob patterns used to match object names. For BigQuery dataset assets,
	// these are interpreted as patterns to match table names.
	ExcludePatterns []string `protobuf:"bytes,3,rep,name=exclude_patterns,json=excludePatterns,proto3" json:"exclude_patterns,omitempty"`
	// Optional. Configuration for CSV data.
	CsvOptions *Zone_DiscoverySpec_CsvOptions `protobuf:"bytes,4,opt,name=csv_options,json=csvOptions,proto3" json:"csv_options,omitempty"`
	// Optional. Configuration for Json data.
	JsonOptions *Zone_DiscoverySpec_JsonOptions `protobuf:"bytes,5,opt,name=json_options,json=jsonOptions,proto3" json:"json_options,omitempty"`
	// Determines when discovery is triggered.
	//
	// Types that are assignable to Trigger:
	//
	//	*Zone_DiscoverySpec_Schedule
	Trigger isZone_DiscoverySpec_Trigger `protobuf_oneof:"trigger"`
}

func (x *Zone_DiscoverySpec) Reset() {
	*x = Zone_DiscoverySpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Zone_DiscoverySpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Zone_DiscoverySpec) ProtoMessage() {}

func (x *Zone_DiscoverySpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Zone_DiscoverySpec.ProtoReflect.Descriptor instead.
func (*Zone_DiscoverySpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{2, 1}
}

func (x *Zone_DiscoverySpec) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *Zone_DiscoverySpec) GetIncludePatterns() []string {
	if x != nil {
		return x.IncludePatterns
	}
	return nil
}

func (x *Zone_DiscoverySpec) GetExcludePatterns() []string {
	if x != nil {
		return x.ExcludePatterns
	}
	return nil
}

func (x *Zone_DiscoverySpec) GetCsvOptions() *Zone_DiscoverySpec_CsvOptions {
	if x != nil {
		return x.CsvOptions
	}
	return nil
}

func (x *Zone_DiscoverySpec) GetJsonOptions() *Zone_DiscoverySpec_JsonOptions {
	if x != nil {
		return x.JsonOptions
	}
	return nil
}

func (m *Zone_DiscoverySpec) GetTrigger() isZone_DiscoverySpec_Trigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

func (x *Zone_DiscoverySpec) GetSchedule() string {
	if x, ok := x.GetTrigger().(*Zone_DiscoverySpec_Schedule); ok {
		return x.Schedule
	}
	return ""
}

type isZone_DiscoverySpec_Trigger interface {
	isZone_DiscoverySpec_Trigger()
}

type Zone_DiscoverySpec_Schedule struct {
	// Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for
	// running discovery periodically. Successive discovery runs must be
	// scheduled at least 60 minutes apart. The default value is to run
	// discovery every 60 minutes. To explicitly set a timezone to the cron
	// tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or
	// TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string
	// from IANA time zone database. For example, `CRON_TZ=America/New_York 1
	// * * * *`, or `TZ=America/New_York 1 * * * *`.
	Schedule string `protobuf:"bytes,10,opt,name=schedule,proto3,oneof"`
}

func (*Zone_DiscoverySpec_Schedule) isZone_DiscoverySpec_Trigger() {}

// Describe CSV and similar semi-structured data formats.
type Zone_DiscoverySpec_CsvOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The number of rows to interpret as header rows that should be
	// skipped when reading data rows.
	HeaderRows int32 `protobuf:"varint,1,opt,name=header_rows,json=headerRows,proto3" json:"header_rows,omitempty"`
	// Optional. The delimiter being used to separate values. This defaults to
	// ','.
	Delimiter string `protobuf:"bytes,2,opt,name=delimiter,proto3" json:"delimiter,omitempty"`
	// Optional. The character encoding of the data. The default is UTF-8.
	Encoding string `protobuf:"bytes,3,opt,name=encoding,proto3" json:"encoding,omitempty"`
	// Optional. Whether to disable the inference of data type for CSV data.
	// If true, all columns will be registered as strings.
	DisableTypeInference bool `protobuf:"varint,4,opt,name=disable_type_inference,json=disableTypeInference,proto3" json:"disable_type_inference,omitempty"`
}

func (x *Zone_DiscoverySpec_CsvOptions) Reset() {
	*x = Zone_DiscoverySpec_CsvOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Zone_DiscoverySpec_CsvOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Zone_DiscoverySpec_CsvOptions) ProtoMessage() {}

func (x *Zone_DiscoverySpec_CsvOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Zone_DiscoverySpec_CsvOptions.ProtoReflect.Descriptor instead.
func (*Zone_DiscoverySpec_CsvOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{2, 1, 0}
}

func (x *Zone_DiscoverySpec_CsvOptions) GetHeaderRows() int32 {
	if x != nil {
		return x.HeaderRows
	}
	return 0
}

func (x *Zone_DiscoverySpec_CsvOptions) GetDelimiter() string {
	if x != nil {
		return x.Delimiter
	}
	return ""
}

func (x *Zone_DiscoverySpec_CsvOptions) GetEncoding() string {
	if x != nil {
		return x.Encoding
	}
	return ""
}

func (x *Zone_DiscoverySpec_CsvOptions) GetDisableTypeInference() bool {
	if x != nil {
		return x.DisableTypeInference
	}
	return false
}

// Describe JSON data format.
type Zone_DiscoverySpec_JsonOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The character encoding of the data. The default is UTF-8.
	Encoding string `protobuf:"bytes,1,opt,name=encoding,proto3" json:"encoding,omitempty"`
	// Optional. Whether to disable the inference of data type for Json data.
	// If true, all columns will be registered as their primitive types
	// (strings, number or boolean).
	DisableTypeInference bool `protobuf:"varint,2,opt,name=disable_type_inference,json=disableTypeInference,proto3" json:"disable_type_inference,omitempty"`
}

func (x *Zone_DiscoverySpec_JsonOptions) Reset() {
	*x = Zone_DiscoverySpec_JsonOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Zone_DiscoverySpec_JsonOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Zone_DiscoverySpec_JsonOptions) ProtoMessage() {}

func (x *Zone_DiscoverySpec_JsonOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Zone_DiscoverySpec_JsonOptions.ProtoReflect.Descriptor instead.
func (*Zone_DiscoverySpec_JsonOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{2, 1, 1}
}

func (x *Zone_DiscoverySpec_JsonOptions) GetEncoding() string {
	if x != nil {
		return x.Encoding
	}
	return ""
}

func (x *Zone_DiscoverySpec_JsonOptions) GetDisableTypeInference() bool {
	if x != nil {
		return x.DisableTypeInference
	}
	return false
}

// Action details for resource references in assets that cannot be located.
type Action_MissingResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Action_MissingResource) Reset() {
	*x = Action_MissingResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_MissingResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_MissingResource) ProtoMessage() {}

func (x *Action_MissingResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_MissingResource.ProtoReflect.Descriptor instead.
func (*Action_MissingResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{3, 0}
}

// Action details for unauthorized resource issues raised to indicate that the
// service account associated with the lake instance is not authorized to
// access or manage the resource associated with an asset.
type Action_UnauthorizedResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Action_UnauthorizedResource) Reset() {
	*x = Action_UnauthorizedResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_UnauthorizedResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_UnauthorizedResource) ProtoMessage() {}

func (x *Action_UnauthorizedResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_UnauthorizedResource.ProtoReflect.Descriptor instead.
func (*Action_UnauthorizedResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{3, 1}
}

// Failed to apply security policy to the managed resource(s) under a
// lake, zone or an asset. For a lake or zone resource, one or more underlying
// assets has a failure applying security policy to the associated managed
// resource.
type Action_FailedSecurityPolicyApply struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of one of the assets with failing security policy
	// application. Populated for a lake or zone resource only.
	Asset string `protobuf:"bytes,1,opt,name=asset,proto3" json:"asset,omitempty"`
}

func (x *Action_FailedSecurityPolicyApply) Reset() {
	*x = Action_FailedSecurityPolicyApply{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_FailedSecurityPolicyApply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_FailedSecurityPolicyApply) ProtoMessage() {}

func (x *Action_FailedSecurityPolicyApply) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_FailedSecurityPolicyApply.ProtoReflect.Descriptor instead.
func (*Action_FailedSecurityPolicyApply) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{3, 2}
}

func (x *Action_FailedSecurityPolicyApply) GetAsset() string {
	if x != nil {
		return x.Asset
	}
	return ""
}

// Action details for invalid or unsupported data files detected by discovery.
type Action_InvalidDataFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of data locations sampled and used for format/schema
	// inference.
	SampledDataLocations []string `protobuf:"bytes,1,rep,name=sampled_data_locations,json=sampledDataLocations,proto3" json:"sampled_data_locations,omitempty"`
	// The expected data format of the entity.
	ExpectedFormat string `protobuf:"bytes,2,opt,name=expected_format,json=expectedFormat,proto3" json:"expected_format,omitempty"`
	// The new unexpected data format within the entity.
	NewFormat string `protobuf:"bytes,3,opt,name=new_format,json=newFormat,proto3" json:"new_format,omitempty"`
}

func (x *Action_InvalidDataFormat) Reset() {
	*x = Action_InvalidDataFormat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_InvalidDataFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_InvalidDataFormat) ProtoMessage() {}

func (x *Action_InvalidDataFormat) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_InvalidDataFormat.ProtoReflect.Descriptor instead.
func (*Action_InvalidDataFormat) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{3, 3}
}

func (x *Action_InvalidDataFormat) GetSampledDataLocations() []string {
	if x != nil {
		return x.SampledDataLocations
	}
	return nil
}

func (x *Action_InvalidDataFormat) GetExpectedFormat() string {
	if x != nil {
		return x.ExpectedFormat
	}
	return ""
}

func (x *Action_InvalidDataFormat) GetNewFormat() string {
	if x != nil {
		return x.NewFormat
	}
	return ""
}

// Action details for incompatible schemas detected by discovery.
type Action_IncompatibleDataSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the table containing invalid data.
	Table string `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	// The existing and expected schema of the table. The schema is provided as
	// a JSON formatted structure listing columns and data types.
	ExistingSchema string `protobuf:"bytes,2,opt,name=existing_schema,json=existingSchema,proto3" json:"existing_schema,omitempty"`
	// The new and incompatible schema within the table. The schema is provided
	// as a JSON formatted structured listing columns and data types.
	NewSchema string `protobuf:"bytes,3,opt,name=new_schema,json=newSchema,proto3" json:"new_schema,omitempty"`
	// The list of data locations sampled and used for format/schema
	// inference.
	SampledDataLocations []string `protobuf:"bytes,4,rep,name=sampled_data_locations,json=sampledDataLocations,proto3" json:"sampled_data_locations,omitempty"`
	// Whether the action relates to a schema that is incompatible or modified.
	SchemaChange Action_IncompatibleDataSchema_SchemaChange `protobuf:"varint,5,opt,name=schema_change,json=schemaChange,proto3,enum=google.cloud.dataplex.v1.Action_IncompatibleDataSchema_SchemaChange" json:"schema_change,omitempty"`
}

func (x *Action_IncompatibleDataSchema) Reset() {
	*x = Action_IncompatibleDataSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_IncompatibleDataSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_IncompatibleDataSchema) ProtoMessage() {}

func (x *Action_IncompatibleDataSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_IncompatibleDataSchema.ProtoReflect.Descriptor instead.
func (*Action_IncompatibleDataSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{3, 4}
}

func (x *Action_IncompatibleDataSchema) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *Action_IncompatibleDataSchema) GetExistingSchema() string {
	if x != nil {
		return x.ExistingSchema
	}
	return ""
}

func (x *Action_IncompatibleDataSchema) GetNewSchema() string {
	if x != nil {
		return x.NewSchema
	}
	return ""
}

func (x *Action_IncompatibleDataSchema) GetSampledDataLocations() []string {
	if x != nil {
		return x.SampledDataLocations
	}
	return nil
}

func (x *Action_IncompatibleDataSchema) GetSchemaChange() Action_IncompatibleDataSchema_SchemaChange {
	if x != nil {
		return x.SchemaChange
	}
	return Action_IncompatibleDataSchema_SCHEMA_CHANGE_UNSPECIFIED
}

// Action details for invalid or unsupported partitions detected by discovery.
type Action_InvalidDataPartition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The issue type of InvalidDataPartition.
	ExpectedStructure Action_InvalidDataPartition_PartitionStructure `protobuf:"varint,1,opt,name=expected_structure,json=expectedStructure,proto3,enum=google.cloud.dataplex.v1.Action_InvalidDataPartition_PartitionStructure" json:"expected_structure,omitempty"`
}

func (x *Action_InvalidDataPartition) Reset() {
	*x = Action_InvalidDataPartition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_InvalidDataPartition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_InvalidDataPartition) ProtoMessage() {}

func (x *Action_InvalidDataPartition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_InvalidDataPartition.ProtoReflect.Descriptor instead.
func (*Action_InvalidDataPartition) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{3, 5}
}

func (x *Action_InvalidDataPartition) GetExpectedStructure() Action_InvalidDataPartition_PartitionStructure {
	if x != nil {
		return x.ExpectedStructure
	}
	return Action_InvalidDataPartition_PARTITION_STRUCTURE_UNSPECIFIED
}

// Action details for absence of data detected by discovery.
type Action_MissingData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Action_MissingData) Reset() {
	*x = Action_MissingData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_MissingData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_MissingData) ProtoMessage() {}

func (x *Action_MissingData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_MissingData.ProtoReflect.Descriptor instead.
func (*Action_MissingData) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{3, 6}
}

// Action details for invalid data arrangement.
type Action_InvalidDataOrganization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Action_InvalidDataOrganization) Reset() {
	*x = Action_InvalidDataOrganization{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_InvalidDataOrganization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_InvalidDataOrganization) ProtoMessage() {}

func (x *Action_InvalidDataOrganization) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_InvalidDataOrganization.ProtoReflect.Descriptor instead.
func (*Action_InvalidDataOrganization) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{3, 7}
}

// Security policy status of the asset. Data security policy, i.e., readers,
// writers & owners, should be specified in the lake/zone/asset IAM policy.
type Asset_SecurityStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The current state of the security policy applied to the attached
	// resource.
	State Asset_SecurityStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.dataplex.v1.Asset_SecurityStatus_State" json:"state,omitempty"`
	// Additional information about the current state.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// Last update time of the status.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *Asset_SecurityStatus) Reset() {
	*x = Asset_SecurityStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Asset_SecurityStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Asset_SecurityStatus) ProtoMessage() {}

func (x *Asset_SecurityStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Asset_SecurityStatus.ProtoReflect.Descriptor instead.
func (*Asset_SecurityStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{4, 0}
}

func (x *Asset_SecurityStatus) GetState() Asset_SecurityStatus_State {
	if x != nil {
		return x.State
	}
	return Asset_SecurityStatus_STATE_UNSPECIFIED
}

func (x *Asset_SecurityStatus) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *Asset_SecurityStatus) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Settings to manage the metadata discovery and publishing for an asset.
type Asset_DiscoverySpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether discovery is enabled.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Optional. The list of patterns to apply for selecting data to include
	// during discovery if only a subset of the data should considered.  For
	// Cloud Storage bucket assets, these are interpreted as glob patterns used
	// to match object names. For BigQuery dataset assets, these are interpreted
	// as patterns to match table names.
	IncludePatterns []string `protobuf:"bytes,2,rep,name=include_patterns,json=includePatterns,proto3" json:"include_patterns,omitempty"`
	// Optional. The list of patterns to apply for selecting data to exclude
	// during discovery.  For Cloud Storage bucket assets, these are interpreted
	// as glob patterns used to match object names. For BigQuery dataset assets,
	// these are interpreted as patterns to match table names.
	ExcludePatterns []string `protobuf:"bytes,3,rep,name=exclude_patterns,json=excludePatterns,proto3" json:"exclude_patterns,omitempty"`
	// Optional. Configuration for CSV data.
	CsvOptions *Asset_DiscoverySpec_CsvOptions `protobuf:"bytes,4,opt,name=csv_options,json=csvOptions,proto3" json:"csv_options,omitempty"`
	// Optional. Configuration for Json data.
	JsonOptions *Asset_DiscoverySpec_JsonOptions `protobuf:"bytes,5,opt,name=json_options,json=jsonOptions,proto3" json:"json_options,omitempty"`
	// Determines when discovery is triggered.
	//
	// Types that are assignable to Trigger:
	//
	//	*Asset_DiscoverySpec_Schedule
	Trigger isAsset_DiscoverySpec_Trigger `protobuf_oneof:"trigger"`
}

func (x *Asset_DiscoverySpec) Reset() {
	*x = Asset_DiscoverySpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Asset_DiscoverySpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Asset_DiscoverySpec) ProtoMessage() {}

func (x *Asset_DiscoverySpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Asset_DiscoverySpec.ProtoReflect.Descriptor instead.
func (*Asset_DiscoverySpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{4, 1}
}

func (x *Asset_DiscoverySpec) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *Asset_DiscoverySpec) GetIncludePatterns() []string {
	if x != nil {
		return x.IncludePatterns
	}
	return nil
}

func (x *Asset_DiscoverySpec) GetExcludePatterns() []string {
	if x != nil {
		return x.ExcludePatterns
	}
	return nil
}

func (x *Asset_DiscoverySpec) GetCsvOptions() *Asset_DiscoverySpec_CsvOptions {
	if x != nil {
		return x.CsvOptions
	}
	return nil
}

func (x *Asset_DiscoverySpec) GetJsonOptions() *Asset_DiscoverySpec_JsonOptions {
	if x != nil {
		return x.JsonOptions
	}
	return nil
}

func (m *Asset_DiscoverySpec) GetTrigger() isAsset_DiscoverySpec_Trigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

func (x *Asset_DiscoverySpec) GetSchedule() string {
	if x, ok := x.GetTrigger().(*Asset_DiscoverySpec_Schedule); ok {
		return x.Schedule
	}
	return ""
}

type isAsset_DiscoverySpec_Trigger interface {
	isAsset_DiscoverySpec_Trigger()
}

type Asset_DiscoverySpec_Schedule struct {
	// Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for
	// running discovery periodically. Successive discovery runs must be
	// scheduled at least 60 minutes apart. The default value is to run
	// discovery every 60 minutes. To explicitly set a timezone to the cron
	// tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or
	// TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string
	// from IANA time zone database. For example, `CRON_TZ=America/New_York 1
	// * * * *`, or `TZ=America/New_York 1 * * * *`.
	Schedule string `protobuf:"bytes,10,opt,name=schedule,proto3,oneof"`
}

func (*Asset_DiscoverySpec_Schedule) isAsset_DiscoverySpec_Trigger() {}

// Identifies the cloud resource that is referenced by this asset.
type Asset_ResourceSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. Relative name of the cloud resource that contains the data
	// that is being managed within a lake. For example:
	//
	//	`projects/{project_number}/buckets/{bucket_id}`
	//	`projects/{project_number}/datasets/{dataset_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. Type of resource.
	Type Asset_ResourceSpec_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.dataplex.v1.Asset_ResourceSpec_Type" json:"type,omitempty"`
	// Optional. Determines how read permissions are handled for each asset and
	// their associated tables. Only available to storage buckets assets.
	ReadAccessMode Asset_ResourceSpec_AccessMode `protobuf:"varint,5,opt,name=read_access_mode,json=readAccessMode,proto3,enum=google.cloud.dataplex.v1.Asset_ResourceSpec_AccessMode" json:"read_access_mode,omitempty"`
}

func (x *Asset_ResourceSpec) Reset() {
	*x = Asset_ResourceSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Asset_ResourceSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Asset_ResourceSpec) ProtoMessage() {}

func (x *Asset_ResourceSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Asset_ResourceSpec.ProtoReflect.Descriptor instead.
func (*Asset_ResourceSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{4, 2}
}

func (x *Asset_ResourceSpec) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Asset_ResourceSpec) GetType() Asset_ResourceSpec_Type {
	if x != nil {
		return x.Type
	}
	return Asset_ResourceSpec_TYPE_UNSPECIFIED
}

func (x *Asset_ResourceSpec) GetReadAccessMode() Asset_ResourceSpec_AccessMode {
	if x != nil {
		return x.ReadAccessMode
	}
	return Asset_ResourceSpec_ACCESS_MODE_UNSPECIFIED
}

// Status of the resource referenced by an asset.
type Asset_ResourceStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The current state of the managed resource.
	State Asset_ResourceStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.dataplex.v1.Asset_ResourceStatus_State" json:"state,omitempty"`
	// Additional information about the current state.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// Last update time of the status.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Service account associated with the BigQuery Connection.
	ManagedAccessIdentity string `protobuf:"bytes,4,opt,name=managed_access_identity,json=managedAccessIdentity,proto3" json:"managed_access_identity,omitempty"`
}

func (x *Asset_ResourceStatus) Reset() {
	*x = Asset_ResourceStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Asset_ResourceStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Asset_ResourceStatus) ProtoMessage() {}

func (x *Asset_ResourceStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Asset_ResourceStatus.ProtoReflect.Descriptor instead.
func (*Asset_ResourceStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{4, 3}
}

func (x *Asset_ResourceStatus) GetState() Asset_ResourceStatus_State {
	if x != nil {
		return x.State
	}
	return Asset_ResourceStatus_STATE_UNSPECIFIED
}

func (x *Asset_ResourceStatus) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *Asset_ResourceStatus) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Asset_ResourceStatus) GetManagedAccessIdentity() string {
	if x != nil {
		return x.ManagedAccessIdentity
	}
	return ""
}

// Status of discovery for an asset.
type Asset_DiscoveryStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The current status of the discovery feature.
	State Asset_DiscoveryStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.dataplex.v1.Asset_DiscoveryStatus_State" json:"state,omitempty"`
	// Additional information about the current state.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// Last update time of the status.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The start time of the last discovery run.
	LastRunTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=last_run_time,json=lastRunTime,proto3" json:"last_run_time,omitempty"`
	// Data Stats of the asset reported by discovery.
	Stats *Asset_DiscoveryStatus_Stats `protobuf:"bytes,6,opt,name=stats,proto3" json:"stats,omitempty"`
	// The duration of the last discovery run.
	LastRunDuration *durationpb.Duration `protobuf:"bytes,7,opt,name=last_run_duration,json=lastRunDuration,proto3" json:"last_run_duration,omitempty"`
}

func (x *Asset_DiscoveryStatus) Reset() {
	*x = Asset_DiscoveryStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Asset_DiscoveryStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Asset_DiscoveryStatus) ProtoMessage() {}

func (x *Asset_DiscoveryStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Asset_DiscoveryStatus.ProtoReflect.Descriptor instead.
func (*Asset_DiscoveryStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{4, 4}
}

func (x *Asset_DiscoveryStatus) GetState() Asset_DiscoveryStatus_State {
	if x != nil {
		return x.State
	}
	return Asset_DiscoveryStatus_STATE_UNSPECIFIED
}

func (x *Asset_DiscoveryStatus) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *Asset_DiscoveryStatus) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Asset_DiscoveryStatus) GetLastRunTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastRunTime
	}
	return nil
}

func (x *Asset_DiscoveryStatus) GetStats() *Asset_DiscoveryStatus_Stats {
	if x != nil {
		return x.Stats
	}
	return nil
}

func (x *Asset_DiscoveryStatus) GetLastRunDuration() *durationpb.Duration {
	if x != nil {
		return x.LastRunDuration
	}
	return nil
}

// Describe CSV and similar semi-structured data formats.
type Asset_DiscoverySpec_CsvOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The number of rows to interpret as header rows that should be
	// skipped when reading data rows.
	HeaderRows int32 `protobuf:"varint,1,opt,name=header_rows,json=headerRows,proto3" json:"header_rows,omitempty"`
	// Optional. The delimiter being used to separate values. This defaults to
	// ','.
	Delimiter string `protobuf:"bytes,2,opt,name=delimiter,proto3" json:"delimiter,omitempty"`
	// Optional. The character encoding of the data. The default is UTF-8.
	Encoding string `protobuf:"bytes,3,opt,name=encoding,proto3" json:"encoding,omitempty"`
	// Optional. Whether to disable the inference of data type for CSV data.
	// If true, all columns will be registered as strings.
	DisableTypeInference bool `protobuf:"varint,4,opt,name=disable_type_inference,json=disableTypeInference,proto3" json:"disable_type_inference,omitempty"`
}

func (x *Asset_DiscoverySpec_CsvOptions) Reset() {
	*x = Asset_DiscoverySpec_CsvOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Asset_DiscoverySpec_CsvOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Asset_DiscoverySpec_CsvOptions) ProtoMessage() {}

func (x *Asset_DiscoverySpec_CsvOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Asset_DiscoverySpec_CsvOptions.ProtoReflect.Descriptor instead.
func (*Asset_DiscoverySpec_CsvOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{4, 1, 0}
}

func (x *Asset_DiscoverySpec_CsvOptions) GetHeaderRows() int32 {
	if x != nil {
		return x.HeaderRows
	}
	return 0
}

func (x *Asset_DiscoverySpec_CsvOptions) GetDelimiter() string {
	if x != nil {
		return x.Delimiter
	}
	return ""
}

func (x *Asset_DiscoverySpec_CsvOptions) GetEncoding() string {
	if x != nil {
		return x.Encoding
	}
	return ""
}

func (x *Asset_DiscoverySpec_CsvOptions) GetDisableTypeInference() bool {
	if x != nil {
		return x.DisableTypeInference
	}
	return false
}

// Describe JSON data format.
type Asset_DiscoverySpec_JsonOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The character encoding of the data. The default is UTF-8.
	Encoding string `protobuf:"bytes,1,opt,name=encoding,proto3" json:"encoding,omitempty"`
	// Optional. Whether to disable the inference of data type for Json data.
	// If true, all columns will be registered as their primitive types
	// (strings, number or boolean).
	DisableTypeInference bool `protobuf:"varint,2,opt,name=disable_type_inference,json=disableTypeInference,proto3" json:"disable_type_inference,omitempty"`
}

func (x *Asset_DiscoverySpec_JsonOptions) Reset() {
	*x = Asset_DiscoverySpec_JsonOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Asset_DiscoverySpec_JsonOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Asset_DiscoverySpec_JsonOptions) ProtoMessage() {}

func (x *Asset_DiscoverySpec_JsonOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Asset_DiscoverySpec_JsonOptions.ProtoReflect.Descriptor instead.
func (*Asset_DiscoverySpec_JsonOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{4, 1, 1}
}

func (x *Asset_DiscoverySpec_JsonOptions) GetEncoding() string {
	if x != nil {
		return x.Encoding
	}
	return ""
}

func (x *Asset_DiscoverySpec_JsonOptions) GetDisableTypeInference() bool {
	if x != nil {
		return x.DisableTypeInference
	}
	return false
}

// The aggregated data statistics for the asset reported by discovery.
type Asset_DiscoveryStatus_Stats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The count of data items within the referenced resource.
	DataItems int64 `protobuf:"varint,1,opt,name=data_items,json=dataItems,proto3" json:"data_items,omitempty"`
	// The number of stored data bytes within the referenced resource.
	DataSize int64 `protobuf:"varint,2,opt,name=data_size,json=dataSize,proto3" json:"data_size,omitempty"`
	// The count of table entities within the referenced resource.
	Tables int64 `protobuf:"varint,3,opt,name=tables,proto3" json:"tables,omitempty"`
	// The count of fileset entities within the referenced resource.
	Filesets int64 `protobuf:"varint,4,opt,name=filesets,proto3" json:"filesets,omitempty"`
}

func (x *Asset_DiscoveryStatus_Stats) Reset() {
	*x = Asset_DiscoveryStatus_Stats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Asset_DiscoveryStatus_Stats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Asset_DiscoveryStatus_Stats) ProtoMessage() {}

func (x *Asset_DiscoveryStatus_Stats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_resources_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Asset_DiscoveryStatus_Stats.ProtoReflect.Descriptor instead.
func (*Asset_DiscoveryStatus_Stats) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP(), []int{4, 4, 0}
}

func (x *Asset_DiscoveryStatus_Stats) GetDataItems() int64 {
	if x != nil {
		return x.DataItems
	}
	return 0
}

func (x *Asset_DiscoveryStatus_Stats) GetDataSize() int64 {
	if x != nil {
		return x.DataSize
	}
	return 0
}

func (x *Asset_DiscoveryStatus_Stats) GetTables() int64 {
	if x != nil {
		return x.Tables
	}
	return 0
}

func (x *Asset_DiscoveryStatus_Stats) GetFilesets() int64 {
	if x != nil {
		return x.Filesets
	}
	return 0
}

var File_google_cloud_dataplex_v1_resources_proto protoreflect.FileDescriptor

var file_google_cloud_dataplex_v1_resources_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xba, 0x09, 0x0a, 0x04, 0x4c, 0x61, 0x6b, 0x65, 0x12, 0x38, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x1e,
	0x0a, 0x1c, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x61, 0x6b, 0x65, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03,
	0x75, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03,
	0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x61, 0x6b, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x4b, 0x0a, 0x09, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x66,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x61, 0x6b, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x4d,
	0x0a, 0x0c, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x67,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x5e, 0x0a,
	0x10, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x68, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x61, 0x6b, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x6d, 0x65,
	0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0x2a, 0x0a,
	0x09, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x1a, 0x9e, 0x02, 0x0a, 0x0f, 0x4d, 0x65,
	0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x4a, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x61, 0x6b, 0x65, 0x2e, 0x4d, 0x65, 0x74,
	0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x1a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x22, 0x4c, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04,
	0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10,
	0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12,
	0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x04, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x57, 0xea, 0x41, 0x54, 0x0a, 0x1c, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x61, 0x6b, 0x65, 0x12, 0x34, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x6c, 0x61, 0x6b, 0x65, 0x73, 0x2f, 0x7b, 0x6c, 0x61, 0x6b, 0x65, 0x7d, 0x22, 0xb6,
	0x01, 0x0a, 0x0b, 0x41, 0x73, 0x73, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x3b,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0c, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73,
	0x12, 0x45, 0x0a, 0x1f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x1c, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x69, 0x6e,
	0x67, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x22, 0xb0, 0x0e, 0x0a, 0x04, 0x5a, 0x6f, 0x6e, 0x65,
	0x12, 0x38, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24,
	0xe0, 0x41, 0x03, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x5a, 0x6f, 0x6e, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x47, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x5a, 0x6f, 0x6e, 0x65, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3f, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x5a, 0x6f, 0x6e, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x06, 0xe0, 0x41,
	0x02, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x58, 0x0a, 0x0e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x67, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x5a, 0x6f,
	0x6e, 0x65, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x53, 0x70, 0x65, 0x63,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x55, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x68, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x5a, 0x6f, 0x6e, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x4d, 0x0a, 0x0c, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x69, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0xc9, 0x01, 0x0a, 0x0c, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x65, 0x0a, 0x0d, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x5a, 0x6f,
	0x6e, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x06, 0xe0, 0x41,
	0x02, 0xe0, 0x41, 0x05, 0x52, 0x0c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x22, 0x52, 0x0a, 0x0c, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x5f, 0x52, 0x45, 0x47, 0x49,
	0x4f, 0x4e, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x5f, 0x52, 0x45,
	0x47, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x1a, 0x9c, 0x05, 0x0a, 0x0d, 0x44, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1d, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x2e, 0x0a, 0x10, 0x69, 0x6e, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x50,
	0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x73, 0x12, 0x2e, 0x0a, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x50,
	0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x73, 0x12, 0x5d, 0x0a, 0x0b, 0x63, 0x73, 0x76, 0x5f, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x5a, 0x6f, 0x6e, 0x65, 0x2e, 0x44, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43, 0x73, 0x76, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x63, 0x73, 0x76, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x60, 0x0a, 0x0c, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x5a, 0x6f, 0x6e, 0x65, 0x2e, 0x44, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4a, 0x73, 0x6f, 0x6e, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6a, 0x73, 0x6f,
	0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x21, 0x0a, 0x08, 0x73, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x00, 0x52, 0x08, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x1a, 0xb1, 0x01, 0x0a, 0x0a,
	0x43, 0x73, 0x76, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x24, 0x0a, 0x0b, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x5f, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x6f, 0x77, 0x73,
	0x12, 0x21, 0x0a, 0x09, 0x64, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x64, 0x65, 0x6c, 0x69, 0x6d, 0x69,
	0x74, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x65, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x12, 0x39, 0x0a, 0x16, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x64, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x49, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x1a,
	0x69, 0x0a, 0x0b, 0x4a, 0x73, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1f,
	0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12,
	0x39, 0x0a, 0x16, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f,
	0x69, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x49, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x74, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x32, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07,
	0x0a, 0x03, 0x52, 0x41, 0x57, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x55, 0x52, 0x41, 0x54,
	0x45, 0x44, 0x10, 0x02, 0x3a, 0x64, 0xea, 0x41, 0x61, 0x0a, 0x1c, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x6c, 0x61, 0x6b, 0x65, 0x73, 0x2f, 0x7b, 0x6c, 0x61, 0x6b, 0x65, 0x7d, 0x2f, 0x7a, 0x6f,
	0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x22, 0xab, 0x14, 0x0a, 0x06, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f,
	0x72, 0x79, 0x52, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0,
	0x41, 0x03, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x38, 0x0a, 0x04, 0x6c,
	0x61, 0x6b, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x03, 0xfa, 0x41,
	0x1e, 0x0a, 0x1c, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x61, 0x6b, 0x65, 0x52,
	0x04, 0x6c, 0x61, 0x6b, 0x65, 0x12, 0x38, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x5a, 0x6f, 0x6e, 0x65, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12,
	0x3b, 0x0a, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25,
	0xe0, 0x41, 0x03, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x12, 0x25, 0x0a, 0x0e,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x64, 0x0a, 0x13, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x44, 0x61, 0x74, 0x61, 0x46, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x48, 0x00, 0x52, 0x11, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x44,
	0x61, 0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x73, 0x0a, 0x18, 0x69, 0x6e, 0x63,
	0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e,
	0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x48, 0x00, 0x52, 0x16, 0x69, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74,
	0x69, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x6d,
	0x0a, 0x16, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x44, 0x61, 0x74, 0x61, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x14, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x44, 0x61, 0x74, 0x61, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a,
	0x0c, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74,
	0x61, 0x48, 0x00, 0x52, 0x0b, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61,
	0x12, 0x5d, 0x0a, 0x10, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x69, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0f,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x6c, 0x0a, 0x15, 0x75, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x55, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x14, 0x75, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x7d, 0x0a,
	0x1c, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x18, 0x15, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x48,
	0x00, 0x52, 0x19, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x12, 0x76, 0x0a, 0x19,
	0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x17, 0x69, 0x6e, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x11, 0x0a, 0x0f, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x1a, 0x16, 0x0a, 0x14, 0x55, 0x6e, 0x61, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x1a,
	0x31, 0x0a, 0x19, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x1a, 0x91, 0x01, 0x0a, 0x11, 0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x44, 0x61,
	0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x34, 0x0a, 0x16, 0x73, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x64, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x27,
	0x0a, 0x0f, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65,
	0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x65, 0x77, 0x5f, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x65, 0x77,
	0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x1a, 0xe6, 0x02, 0x0a, 0x16, 0x49, 0x6e, 0x63, 0x6f, 0x6d,
	0x70, 0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x65, 0x78, 0x69, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x65, 0x77, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x65, 0x77, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12,
	0x34, 0x0a, 0x16, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x14, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x69, 0x0a, 0x0d, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49,
	0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x52, 0x0c, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x22, 0x4d, 0x0a, 0x0c, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x1d, 0x0a, 0x19, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x41, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x10, 0x0a, 0x0c, 0x49, 0x4e, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x54, 0x49, 0x42, 0x4c, 0x45, 0x10,
	0x01, 0x12, 0x0c, 0x0a, 0x08, 0x4d, 0x4f, 0x44, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x02, 0x1a,
	0xf4, 0x01, 0x0a, 0x14, 0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x44, 0x61, 0x74, 0x61, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x77, 0x0a, 0x12, 0x65, 0x78, 0x70, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x44, 0x61,
	0x74, 0x61, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x52, 0x11,
	0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72,
	0x65, 0x22, 0x63, 0x0a, 0x12, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x50, 0x41, 0x52, 0x54, 0x49,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x52, 0x55, 0x43, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f,
	0x43, 0x4f, 0x4e, 0x53, 0x49, 0x53, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x4b, 0x45, 0x59, 0x53, 0x10,
	0x01, 0x12, 0x13, 0x0a, 0x0f, 0x48, 0x49, 0x56, 0x45, 0x5f, 0x53, 0x54, 0x59, 0x4c, 0x45, 0x5f,
	0x4b, 0x45, 0x59, 0x53, 0x10, 0x02, 0x1a, 0x0d, 0x0a, 0x0b, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e,
	0x67, 0x44, 0x61, 0x74, 0x61, 0x1a, 0x19, 0x0a, 0x17, 0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x44, 0x61, 0x74, 0x61, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x66, 0x0a, 0x08, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x18, 0x0a, 0x14,
	0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52,
	0x43, 0x45, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12,
	0x13, 0x0a, 0x0f, 0x53, 0x45, 0x43, 0x55, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x50, 0x4f, 0x4c, 0x49,
	0x43, 0x59, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x44, 0x49, 0x53,
	0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x10, 0x03, 0x3a, 0xa2, 0x02, 0xea, 0x41, 0x9e, 0x02, 0x0a,
	0x1e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x45, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x61, 0x6b, 0x65, 0x73, 0x2f, 0x7b,
	0x6c, 0x61, 0x6b, 0x65, 0x7d, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x12, 0x52, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x6c, 0x61, 0x6b, 0x65, 0x73, 0x2f, 0x7b, 0x6c, 0x61, 0x6b, 0x65, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e,
	0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x12, 0x61, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x61, 0x6b, 0x65, 0x73, 0x2f, 0x7b, 0x6c, 0x61, 0x6b, 0x65, 0x7d,
	0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x7d, 0x2f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x42, 0x09, 0x0a,
	0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xc3, 0x19, 0x0a, 0x05, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x25, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x48, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x3a, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x56, 0x0a,
	0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x64,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x70,
	0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5c, 0x0a, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x5c, 0x0a, 0x0f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x67, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x53, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x59, 0x0a, 0x0e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x18, 0x6a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5f, 0x0a, 0x10,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x6b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0xf7, 0x01,
	0x0a, 0x0e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x4a, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x22, 0x42, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x01, 0x12, 0x0c,
	0x0a, 0x08, 0x41, 0x50, 0x50, 0x4c, 0x59, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05,
	0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x03, 0x1a, 0x9e, 0x05, 0x0a, 0x0d, 0x44, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1d, 0x0a, 0x07, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x2e, 0x0a, 0x10, 0x69, 0x6e, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x73, 0x12, 0x2e, 0x0a, 0x10, 0x65, 0x78, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x73, 0x12, 0x5e, 0x0a, 0x0b, 0x63, 0x73, 0x76, 0x5f,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x44,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43, 0x73, 0x76,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x63, 0x73,
	0x76, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x61, 0x0a, 0x0c, 0x6a, 0x73, 0x6f, 0x6e,
	0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4a, 0x73,
	0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x6a, 0x73, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x21, 0x0a, 0x08, 0x73,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x00, 0x52, 0x08, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x1a, 0xb1,
	0x01, 0x0a, 0x0a, 0x43, 0x73, 0x76, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x24, 0x0a,
	0x0b, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52,
	0x6f, 0x77, 0x73, 0x12, 0x21, 0x0a, 0x09, 0x64, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x64, 0x65, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x65,
	0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x39, 0x0a, 0x16, 0x64, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x49, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x1a, 0x69, 0x0a, 0x0b, 0x4a, 0x73, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x1f, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x12, 0x39, 0x0a, 0x16, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x49, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x09, 0x0a,
	0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x1a, 0xea, 0x02, 0x0a, 0x0c, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x66, 0x0a, 0x10, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x72, 0x65, 0x61, 0x64, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x6f, 0x64, 0x65, 0x22, 0x46, 0x0a, 0x04, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x54, 0x4f, 0x52, 0x41,
	0x47, 0x45, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x42,
	0x49, 0x47, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x53, 0x45, 0x54, 0x10,
	0x02, 0x22, 0x42, 0x0a, 0x0a, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x6f, 0x64, 0x65, 0x12,
	0x1b, 0x0a, 0x17, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06,
	0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x41, 0x4e, 0x41,
	0x47, 0x45, 0x44, 0x10, 0x02, 0x1a, 0xa6, 0x02, 0x0a, 0x0e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x4a, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3b,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x17, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x15, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x22, 0x34, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44,
	0x59, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x02, 0x1a, 0xdc,
	0x04, 0x0a, 0x0f, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x4b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0d, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x72,
	0x75, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x6c, 0x61, 0x73, 0x74, 0x52,
	0x75, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x73, 0x12, 0x45, 0x0a, 0x11, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x72, 0x75, 0x6e, 0x5f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x6c, 0x61, 0x73, 0x74, 0x52,
	0x75, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x77, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x74, 0x65, 0x6d,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65,
	0x6d, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x16, 0x0a, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x73,
	0x65, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x73,
	0x65, 0x74, 0x73, 0x22, 0x58, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x44,
	0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53,
	0x53, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x41, 0x55, 0x53, 0x45, 0x44, 0x10, 0x03, 0x12,
	0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x1a, 0x39, 0x0a,
	0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x74, 0xea, 0x41, 0x71, 0x0a, 0x1d, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x50, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x61, 0x6b, 0x65, 0x73, 0x2f, 0x7b, 0x6c, 0x61, 0x6b,
	0x65, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x7d, 0x2a, 0x5b,
	0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a,
	0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52,
	0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x10, 0x04, 0x42, 0x6a, 0x0a, 0x1c, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x42, 0x0e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dataplex_v1_resources_proto_rawDescOnce sync.Once
	file_google_cloud_dataplex_v1_resources_proto_rawDescData = file_google_cloud_dataplex_v1_resources_proto_rawDesc
)

func file_google_cloud_dataplex_v1_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_dataplex_v1_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataplex_v1_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataplex_v1_resources_proto_rawDescData)
	})
	return file_google_cloud_dataplex_v1_resources_proto_rawDescData
}

var file_google_cloud_dataplex_v1_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 12)
var file_google_cloud_dataplex_v1_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 30)
var file_google_cloud_dataplex_v1_resources_proto_goTypes = []interface{}{
	(State)(0),                                          // 0: google.cloud.dataplex.v1.State
	(Lake_MetastoreStatus_State)(0),                     // 1: google.cloud.dataplex.v1.Lake.MetastoreStatus.State
	(Zone_Type)(0),                                      // 2: google.cloud.dataplex.v1.Zone.Type
	(Zone_ResourceSpec_LocationType)(0),                 // 3: google.cloud.dataplex.v1.Zone.ResourceSpec.LocationType
	(Action_Category)(0),                                // 4: google.cloud.dataplex.v1.Action.Category
	(Action_IncompatibleDataSchema_SchemaChange)(0),     // 5: google.cloud.dataplex.v1.Action.IncompatibleDataSchema.SchemaChange
	(Action_InvalidDataPartition_PartitionStructure)(0), // 6: google.cloud.dataplex.v1.Action.InvalidDataPartition.PartitionStructure
	(Asset_SecurityStatus_State)(0),                     // 7: google.cloud.dataplex.v1.Asset.SecurityStatus.State
	(Asset_ResourceSpec_Type)(0),                        // 8: google.cloud.dataplex.v1.Asset.ResourceSpec.Type
	(Asset_ResourceSpec_AccessMode)(0),                  // 9: google.cloud.dataplex.v1.Asset.ResourceSpec.AccessMode
	(Asset_ResourceStatus_State)(0),                     // 10: google.cloud.dataplex.v1.Asset.ResourceStatus.State
	(Asset_DiscoveryStatus_State)(0),                    // 11: google.cloud.dataplex.v1.Asset.DiscoveryStatus.State
	(*Lake)(nil),                                        // 12: google.cloud.dataplex.v1.Lake
	(*AssetStatus)(nil),                                 // 13: google.cloud.dataplex.v1.AssetStatus
	(*Zone)(nil),                                        // 14: google.cloud.dataplex.v1.Zone
	(*Action)(nil),                                      // 15: google.cloud.dataplex.v1.Action
	(*Asset)(nil),                                       // 16: google.cloud.dataplex.v1.Asset
	(*Lake_Metastore)(nil),                              // 17: google.cloud.dataplex.v1.Lake.Metastore
	(*Lake_MetastoreStatus)(nil),                        // 18: google.cloud.dataplex.v1.Lake.MetastoreStatus
	nil,                                                 // 19: google.cloud.dataplex.v1.Lake.LabelsEntry
	(*Zone_ResourceSpec)(nil),                           // 20: google.cloud.dataplex.v1.Zone.ResourceSpec
	(*Zone_DiscoverySpec)(nil),                          // 21: google.cloud.dataplex.v1.Zone.DiscoverySpec
	nil,                                                 // 22: google.cloud.dataplex.v1.Zone.LabelsEntry
	(*Zone_DiscoverySpec_CsvOptions)(nil),               // 23: google.cloud.dataplex.v1.Zone.DiscoverySpec.CsvOptions
	(*Zone_DiscoverySpec_JsonOptions)(nil),              // 24: google.cloud.dataplex.v1.Zone.DiscoverySpec.JsonOptions
	(*Action_MissingResource)(nil),                      // 25: google.cloud.dataplex.v1.Action.MissingResource
	(*Action_UnauthorizedResource)(nil),                 // 26: google.cloud.dataplex.v1.Action.UnauthorizedResource
	(*Action_FailedSecurityPolicyApply)(nil),            // 27: google.cloud.dataplex.v1.Action.FailedSecurityPolicyApply
	(*Action_InvalidDataFormat)(nil),                    // 28: google.cloud.dataplex.v1.Action.InvalidDataFormat
	(*Action_IncompatibleDataSchema)(nil),               // 29: google.cloud.dataplex.v1.Action.IncompatibleDataSchema
	(*Action_InvalidDataPartition)(nil),                 // 30: google.cloud.dataplex.v1.Action.InvalidDataPartition
	(*Action_MissingData)(nil),                          // 31: google.cloud.dataplex.v1.Action.MissingData
	(*Action_InvalidDataOrganization)(nil),              // 32: google.cloud.dataplex.v1.Action.InvalidDataOrganization
	(*Asset_SecurityStatus)(nil),                        // 33: google.cloud.dataplex.v1.Asset.SecurityStatus
	(*Asset_DiscoverySpec)(nil),                         // 34: google.cloud.dataplex.v1.Asset.DiscoverySpec
	(*Asset_ResourceSpec)(nil),                          // 35: google.cloud.dataplex.v1.Asset.ResourceSpec
	(*Asset_ResourceStatus)(nil),                        // 36: google.cloud.dataplex.v1.Asset.ResourceStatus
	(*Asset_DiscoveryStatus)(nil),                       // 37: google.cloud.dataplex.v1.Asset.DiscoveryStatus
	nil,                                                 // 38: google.cloud.dataplex.v1.Asset.LabelsEntry
	(*Asset_DiscoverySpec_CsvOptions)(nil),              // 39: google.cloud.dataplex.v1.Asset.DiscoverySpec.CsvOptions
	(*Asset_DiscoverySpec_JsonOptions)(nil),             // 40: google.cloud.dataplex.v1.Asset.DiscoverySpec.JsonOptions
	(*Asset_DiscoveryStatus_Stats)(nil),                 // 41: google.cloud.dataplex.v1.Asset.DiscoveryStatus.Stats
	(*timestamppb.Timestamp)(nil),                       // 42: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                         // 43: google.protobuf.Duration
}
var file_google_cloud_dataplex_v1_resources_proto_depIdxs = []int32{
	42, // 0: google.cloud.dataplex.v1.Lake.create_time:type_name -> google.protobuf.Timestamp
	42, // 1: google.cloud.dataplex.v1.Lake.update_time:type_name -> google.protobuf.Timestamp
	19, // 2: google.cloud.dataplex.v1.Lake.labels:type_name -> google.cloud.dataplex.v1.Lake.LabelsEntry
	0,  // 3: google.cloud.dataplex.v1.Lake.state:type_name -> google.cloud.dataplex.v1.State
	17, // 4: google.cloud.dataplex.v1.Lake.metastore:type_name -> google.cloud.dataplex.v1.Lake.Metastore
	13, // 5: google.cloud.dataplex.v1.Lake.asset_status:type_name -> google.cloud.dataplex.v1.AssetStatus
	18, // 6: google.cloud.dataplex.v1.Lake.metastore_status:type_name -> google.cloud.dataplex.v1.Lake.MetastoreStatus
	42, // 7: google.cloud.dataplex.v1.AssetStatus.update_time:type_name -> google.protobuf.Timestamp
	42, // 8: google.cloud.dataplex.v1.Zone.create_time:type_name -> google.protobuf.Timestamp
	42, // 9: google.cloud.dataplex.v1.Zone.update_time:type_name -> google.protobuf.Timestamp
	22, // 10: google.cloud.dataplex.v1.Zone.labels:type_name -> google.cloud.dataplex.v1.Zone.LabelsEntry
	0,  // 11: google.cloud.dataplex.v1.Zone.state:type_name -> google.cloud.dataplex.v1.State
	2,  // 12: google.cloud.dataplex.v1.Zone.type:type_name -> google.cloud.dataplex.v1.Zone.Type
	21, // 13: google.cloud.dataplex.v1.Zone.discovery_spec:type_name -> google.cloud.dataplex.v1.Zone.DiscoverySpec
	20, // 14: google.cloud.dataplex.v1.Zone.resource_spec:type_name -> google.cloud.dataplex.v1.Zone.ResourceSpec
	13, // 15: google.cloud.dataplex.v1.Zone.asset_status:type_name -> google.cloud.dataplex.v1.AssetStatus
	4,  // 16: google.cloud.dataplex.v1.Action.category:type_name -> google.cloud.dataplex.v1.Action.Category
	42, // 17: google.cloud.dataplex.v1.Action.detect_time:type_name -> google.protobuf.Timestamp
	28, // 18: google.cloud.dataplex.v1.Action.invalid_data_format:type_name -> google.cloud.dataplex.v1.Action.InvalidDataFormat
	29, // 19: google.cloud.dataplex.v1.Action.incompatible_data_schema:type_name -> google.cloud.dataplex.v1.Action.IncompatibleDataSchema
	30, // 20: google.cloud.dataplex.v1.Action.invalid_data_partition:type_name -> google.cloud.dataplex.v1.Action.InvalidDataPartition
	31, // 21: google.cloud.dataplex.v1.Action.missing_data:type_name -> google.cloud.dataplex.v1.Action.MissingData
	25, // 22: google.cloud.dataplex.v1.Action.missing_resource:type_name -> google.cloud.dataplex.v1.Action.MissingResource
	26, // 23: google.cloud.dataplex.v1.Action.unauthorized_resource:type_name -> google.cloud.dataplex.v1.Action.UnauthorizedResource
	27, // 24: google.cloud.dataplex.v1.Action.failed_security_policy_apply:type_name -> google.cloud.dataplex.v1.Action.FailedSecurityPolicyApply
	32, // 25: google.cloud.dataplex.v1.Action.invalid_data_organization:type_name -> google.cloud.dataplex.v1.Action.InvalidDataOrganization
	42, // 26: google.cloud.dataplex.v1.Asset.create_time:type_name -> google.protobuf.Timestamp
	42, // 27: google.cloud.dataplex.v1.Asset.update_time:type_name -> google.protobuf.Timestamp
	38, // 28: google.cloud.dataplex.v1.Asset.labels:type_name -> google.cloud.dataplex.v1.Asset.LabelsEntry
	0,  // 29: google.cloud.dataplex.v1.Asset.state:type_name -> google.cloud.dataplex.v1.State
	35, // 30: google.cloud.dataplex.v1.Asset.resource_spec:type_name -> google.cloud.dataplex.v1.Asset.ResourceSpec
	36, // 31: google.cloud.dataplex.v1.Asset.resource_status:type_name -> google.cloud.dataplex.v1.Asset.ResourceStatus
	33, // 32: google.cloud.dataplex.v1.Asset.security_status:type_name -> google.cloud.dataplex.v1.Asset.SecurityStatus
	34, // 33: google.cloud.dataplex.v1.Asset.discovery_spec:type_name -> google.cloud.dataplex.v1.Asset.DiscoverySpec
	37, // 34: google.cloud.dataplex.v1.Asset.discovery_status:type_name -> google.cloud.dataplex.v1.Asset.DiscoveryStatus
	1,  // 35: google.cloud.dataplex.v1.Lake.MetastoreStatus.state:type_name -> google.cloud.dataplex.v1.Lake.MetastoreStatus.State
	42, // 36: google.cloud.dataplex.v1.Lake.MetastoreStatus.update_time:type_name -> google.protobuf.Timestamp
	3,  // 37: google.cloud.dataplex.v1.Zone.ResourceSpec.location_type:type_name -> google.cloud.dataplex.v1.Zone.ResourceSpec.LocationType
	23, // 38: google.cloud.dataplex.v1.Zone.DiscoverySpec.csv_options:type_name -> google.cloud.dataplex.v1.Zone.DiscoverySpec.CsvOptions
	24, // 39: google.cloud.dataplex.v1.Zone.DiscoverySpec.json_options:type_name -> google.cloud.dataplex.v1.Zone.DiscoverySpec.JsonOptions
	5,  // 40: google.cloud.dataplex.v1.Action.IncompatibleDataSchema.schema_change:type_name -> google.cloud.dataplex.v1.Action.IncompatibleDataSchema.SchemaChange
	6,  // 41: google.cloud.dataplex.v1.Action.InvalidDataPartition.expected_structure:type_name -> google.cloud.dataplex.v1.Action.InvalidDataPartition.PartitionStructure
	7,  // 42: google.cloud.dataplex.v1.Asset.SecurityStatus.state:type_name -> google.cloud.dataplex.v1.Asset.SecurityStatus.State
	42, // 43: google.cloud.dataplex.v1.Asset.SecurityStatus.update_time:type_name -> google.protobuf.Timestamp
	39, // 44: google.cloud.dataplex.v1.Asset.DiscoverySpec.csv_options:type_name -> google.cloud.dataplex.v1.Asset.DiscoverySpec.CsvOptions
	40, // 45: google.cloud.dataplex.v1.Asset.DiscoverySpec.json_options:type_name -> google.cloud.dataplex.v1.Asset.DiscoverySpec.JsonOptions
	8,  // 46: google.cloud.dataplex.v1.Asset.ResourceSpec.type:type_name -> google.cloud.dataplex.v1.Asset.ResourceSpec.Type
	9,  // 47: google.cloud.dataplex.v1.Asset.ResourceSpec.read_access_mode:type_name -> google.cloud.dataplex.v1.Asset.ResourceSpec.AccessMode
	10, // 48: google.cloud.dataplex.v1.Asset.ResourceStatus.state:type_name -> google.cloud.dataplex.v1.Asset.ResourceStatus.State
	42, // 49: google.cloud.dataplex.v1.Asset.ResourceStatus.update_time:type_name -> google.protobuf.Timestamp
	11, // 50: google.cloud.dataplex.v1.Asset.DiscoveryStatus.state:type_name -> google.cloud.dataplex.v1.Asset.DiscoveryStatus.State
	42, // 51: google.cloud.dataplex.v1.Asset.DiscoveryStatus.update_time:type_name -> google.protobuf.Timestamp
	42, // 52: google.cloud.dataplex.v1.Asset.DiscoveryStatus.last_run_time:type_name -> google.protobuf.Timestamp
	41, // 53: google.cloud.dataplex.v1.Asset.DiscoveryStatus.stats:type_name -> google.cloud.dataplex.v1.Asset.DiscoveryStatus.Stats
	43, // 54: google.cloud.dataplex.v1.Asset.DiscoveryStatus.last_run_duration:type_name -> google.protobuf.Duration
	55, // [55:55] is the sub-list for method output_type
	55, // [55:55] is the sub-list for method input_type
	55, // [55:55] is the sub-list for extension type_name
	55, // [55:55] is the sub-list for extension extendee
	0,  // [0:55] is the sub-list for field type_name
}

func init() { file_google_cloud_dataplex_v1_resources_proto_init() }
func file_google_cloud_dataplex_v1_resources_proto_init() {
	if File_google_cloud_dataplex_v1_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Lake); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AssetStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Zone); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Asset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Lake_Metastore); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Lake_MetastoreStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Zone_ResourceSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Zone_DiscoverySpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Zone_DiscoverySpec_CsvOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Zone_DiscoverySpec_JsonOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action_MissingResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action_UnauthorizedResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action_FailedSecurityPolicyApply); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action_InvalidDataFormat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action_IncompatibleDataSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action_InvalidDataPartition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action_MissingData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action_InvalidDataOrganization); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Asset_SecurityStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Asset_DiscoverySpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Asset_ResourceSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Asset_ResourceStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Asset_DiscoveryStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Asset_DiscoverySpec_CsvOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Asset_DiscoverySpec_JsonOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_resources_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Asset_DiscoveryStatus_Stats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dataplex_v1_resources_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*Action_InvalidDataFormat_)(nil),
		(*Action_IncompatibleDataSchema_)(nil),
		(*Action_InvalidDataPartition_)(nil),
		(*Action_MissingData_)(nil),
		(*Action_MissingResource_)(nil),
		(*Action_UnauthorizedResource_)(nil),
		(*Action_FailedSecurityPolicyApply_)(nil),
		(*Action_InvalidDataOrganization_)(nil),
	}
	file_google_cloud_dataplex_v1_resources_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*Zone_DiscoverySpec_Schedule)(nil),
	}
	file_google_cloud_dataplex_v1_resources_proto_msgTypes[22].OneofWrappers = []interface{}{
		(*Asset_DiscoverySpec_Schedule)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataplex_v1_resources_proto_rawDesc,
			NumEnums:      12,
			NumMessages:   30,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dataplex_v1_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataplex_v1_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_dataplex_v1_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_dataplex_v1_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_dataplex_v1_resources_proto = out.File
	file_google_cloud_dataplex_v1_resources_proto_rawDesc = nil
	file_google_cloud_dataplex_v1_resources_proto_goTypes = nil
	file_google_cloud_dataplex_v1_resources_proto_depIdxs = nil
}
