// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.25.3
// source: google/cloud/dataplex/v1/catalog.proto

package dataplexpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// View for controlling which parts of an entry are to be returned.
type EntryView int32

const (
	// Unspecified EntryView. Defaults to FULL.
	EntryView_ENTRY_VIEW_UNSPECIFIED EntryView = 0
	// Returns entry only, without aspects.
	EntryView_BASIC EntryView = 1
	// Returns all required aspects as well as the keys of all non-required
	// aspects.
	EntryView_FULL EntryView = 2
	// Returns aspects matching custom fields in GetEntryRequest. If the number of
	// aspects would exceed 100, the first 100 will be returned.
	EntryView_CUSTOM EntryView = 3
	// Returns all aspects. If the number of aspects would exceed 100, the first
	// 100 will be returned.
	EntryView_ALL EntryView = 4
)

// Enum value maps for EntryView.
var (
	EntryView_name = map[int32]string{
		0: "ENTRY_VIEW_UNSPECIFIED",
		1: "BASIC",
		2: "FULL",
		3: "CUSTOM",
		4: "ALL",
	}
	EntryView_value = map[string]int32{
		"ENTRY_VIEW_UNSPECIFIED": 0,
		"BASIC":                  1,
		"FULL":                   2,
		"CUSTOM":                 3,
		"ALL":                    4,
	}
)

func (x EntryView) Enum() *EntryView {
	p := new(EntryView)
	*p = x
	return p
}

func (x EntryView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EntryView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_catalog_proto_enumTypes[0].Descriptor()
}

func (EntryView) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_catalog_proto_enumTypes[0]
}

func (x EntryView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EntryView.Descriptor instead.
func (EntryView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{0}
}

// Denotes the transfer status of a resource. It is unspecified for resources
// created from Dataplex API.
type TransferStatus int32

const (
	// The default value. It is set for resources that were not subject for
	// migration from Data Catalog service.
	TransferStatus_TRANSFER_STATUS_UNSPECIFIED TransferStatus = 0
	// Indicates that a resource was migrated from Data Catalog service but it
	// hasn't been transferred yet. In particular the resource cannot be updated
	// from Dataplex API.
	TransferStatus_TRANSFER_STATUS_MIGRATED TransferStatus = 1
	// Indicates that a resource was transferred from Data Catalog service. The
	// resource can only be updated from Dataplex API.
	TransferStatus_TRANSFER_STATUS_TRANSFERRED TransferStatus = 2
)

// Enum value maps for TransferStatus.
var (
	TransferStatus_name = map[int32]string{
		0: "TRANSFER_STATUS_UNSPECIFIED",
		1: "TRANSFER_STATUS_MIGRATED",
		2: "TRANSFER_STATUS_TRANSFERRED",
	}
	TransferStatus_value = map[string]int32{
		"TRANSFER_STATUS_UNSPECIFIED": 0,
		"TRANSFER_STATUS_MIGRATED":    1,
		"TRANSFER_STATUS_TRANSFERRED": 2,
	}
)

func (x TransferStatus) Enum() *TransferStatus {
	p := new(TransferStatus)
	*p = x
	return p
}

func (x TransferStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransferStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_catalog_proto_enumTypes[1].Descriptor()
}

func (TransferStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_catalog_proto_enumTypes[1]
}

func (x TransferStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransferStatus.Descriptor instead.
func (TransferStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{1}
}

// Aspect Type is a template for creating Aspects, and represents the
// JSON-schema for a given Entry, e.g., BigQuery Table Schema.
type AspectType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The relative resource name of the AspectType, of the form:
	// projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. System generated globally unique ID for the AspectType. This
	// ID will be different if the AspectType is deleted and re-created with the
	// same name.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The time when the AspectType was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the AspectType was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Description of the AspectType.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. User friendly display name.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. User-defined labels for the AspectType.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// This checksum is computed by the server based on the value of other
	// fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,8,opt,name=etag,proto3" json:"etag,omitempty"`
	// Immutable. Authorization defined for this type.
	Authorization *AspectType_Authorization `protobuf:"bytes,52,opt,name=authorization,proto3" json:"authorization,omitempty"`
	// Required. MetadataTemplate of the aspect.
	MetadataTemplate *AspectType_MetadataTemplate `protobuf:"bytes,53,opt,name=metadata_template,json=metadataTemplate,proto3" json:"metadata_template,omitempty"`
	// Output only. Denotes the transfer status of the Aspect Type. It is
	// unspecified for Aspect Types created from Dataplex API.
	TransferStatus TransferStatus `protobuf:"varint,202,opt,name=transfer_status,json=transferStatus,proto3,enum=google.cloud.dataplex.v1.TransferStatus" json:"transfer_status,omitempty"`
}

func (x *AspectType) Reset() {
	*x = AspectType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AspectType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AspectType) ProtoMessage() {}

func (x *AspectType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AspectType.ProtoReflect.Descriptor instead.
func (*AspectType) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{0}
}

func (x *AspectType) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AspectType) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *AspectType) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AspectType) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *AspectType) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *AspectType) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AspectType) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *AspectType) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *AspectType) GetAuthorization() *AspectType_Authorization {
	if x != nil {
		return x.Authorization
	}
	return nil
}

func (x *AspectType) GetMetadataTemplate() *AspectType_MetadataTemplate {
	if x != nil {
		return x.MetadataTemplate
	}
	return nil
}

func (x *AspectType) GetTransferStatus() TransferStatus {
	if x != nil {
		return x.TransferStatus
	}
	return TransferStatus_TRANSFER_STATUS_UNSPECIFIED
}

// An Entry Group represents a logical grouping of one or more Entries.
type EntryGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The relative resource name of the EntryGroup, of the form:
	// projects/{project_number}/locations/{location_id}/entryGroups/{entry_group_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. System generated globally unique ID for the EntryGroup. This
	// ID will be different if the EntryGroup is deleted and re-created with the
	// same name.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The time when the EntryGroup was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the EntryGroup was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Description of the EntryGroup.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. User friendly display name.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. User-defined labels for the EntryGroup.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// This checksum is computed by the server based on the value of other
	// fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,8,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. Denotes the transfer status of the Entry Group. It is
	// unspecified for Entry Group created from Dataplex API.
	TransferStatus TransferStatus `protobuf:"varint,202,opt,name=transfer_status,json=transferStatus,proto3,enum=google.cloud.dataplex.v1.TransferStatus" json:"transfer_status,omitempty"`
}

func (x *EntryGroup) Reset() {
	*x = EntryGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntryGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntryGroup) ProtoMessage() {}

func (x *EntryGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntryGroup.ProtoReflect.Descriptor instead.
func (*EntryGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{1}
}

func (x *EntryGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EntryGroup) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *EntryGroup) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *EntryGroup) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *EntryGroup) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *EntryGroup) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *EntryGroup) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *EntryGroup) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *EntryGroup) GetTransferStatus() TransferStatus {
	if x != nil {
		return x.TransferStatus
	}
	return TransferStatus_TRANSFER_STATUS_UNSPECIFIED
}

// Entry Type is a template for creating Entries.
type EntryType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The relative resource name of the EntryType, of the form:
	// projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. System generated globally unique ID for the EntryType. This ID
	// will be different if the EntryType is deleted and re-created with the same
	// name.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The time when the EntryType was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the EntryType was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Description of the EntryType.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. User friendly display name.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. User-defined labels for the EntryType.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. This checksum is computed by the server based on the value of
	// other fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,8,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. Indicates the class this Entry Type belongs to, for example,
	// TABLE, DATABASE, MODEL.
	TypeAliases []string `protobuf:"bytes,9,rep,name=type_aliases,json=typeAliases,proto3" json:"type_aliases,omitempty"`
	// Optional. The platform that Entries of this type belongs to.
	Platform string `protobuf:"bytes,10,opt,name=platform,proto3" json:"platform,omitempty"`
	// Optional. The system that Entries of this type belongs to. Examples include
	// CloudSQL, MariaDB etc
	System string `protobuf:"bytes,11,opt,name=system,proto3" json:"system,omitempty"`
	// AspectInfo for the entry type.
	RequiredAspects []*EntryType_AspectInfo `protobuf:"bytes,50,rep,name=required_aspects,json=requiredAspects,proto3" json:"required_aspects,omitempty"`
	// Immutable. Authorization defined for this type.
	Authorization *EntryType_Authorization `protobuf:"bytes,51,opt,name=authorization,proto3" json:"authorization,omitempty"`
}

func (x *EntryType) Reset() {
	*x = EntryType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntryType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntryType) ProtoMessage() {}

func (x *EntryType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntryType.ProtoReflect.Descriptor instead.
func (*EntryType) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{2}
}

func (x *EntryType) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EntryType) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *EntryType) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *EntryType) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *EntryType) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *EntryType) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *EntryType) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *EntryType) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *EntryType) GetTypeAliases() []string {
	if x != nil {
		return x.TypeAliases
	}
	return nil
}

func (x *EntryType) GetPlatform() string {
	if x != nil {
		return x.Platform
	}
	return ""
}

func (x *EntryType) GetSystem() string {
	if x != nil {
		return x.System
	}
	return ""
}

func (x *EntryType) GetRequiredAspects() []*EntryType_AspectInfo {
	if x != nil {
		return x.RequiredAspects
	}
	return nil
}

func (x *EntryType) GetAuthorization() *EntryType_Authorization {
	if x != nil {
		return x.Authorization
	}
	return nil
}

// An aspect is a single piece of metadata describing an entry.
type Aspect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the type used to create this Aspect.
	AspectType string `protobuf:"bytes,1,opt,name=aspect_type,json=aspectType,proto3" json:"aspect_type,omitempty"`
	// Output only. The path in the entry under which the aspect is attached.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	// Output only. The time when the Aspect was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the Aspect was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. The content of the aspect, according to its aspect type schema.
	// This will replace `content`.
	// The maximum size of the field is 120KB (encoded as UTF-8).
	Data         *structpb.Struct `protobuf:"bytes,8,opt,name=data,proto3" json:"data,omitempty"`
	AspectSource *AspectSource    `protobuf:"bytes,9,opt,name=aspect_source,json=aspectSource,proto3" json:"aspect_source,omitempty"`
}

func (x *Aspect) Reset() {
	*x = Aspect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Aspect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Aspect) ProtoMessage() {}

func (x *Aspect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Aspect.ProtoReflect.Descriptor instead.
func (*Aspect) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{3}
}

func (x *Aspect) GetAspectType() string {
	if x != nil {
		return x.AspectType
	}
	return ""
}

func (x *Aspect) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *Aspect) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Aspect) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Aspect) GetData() *structpb.Struct {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *Aspect) GetAspectSource() *AspectSource {
	if x != nil {
		return x.AspectSource
	}
	return nil
}

// AspectSource contains source system related information for the
// aspect.
type AspectSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The create time of the aspect in the source system.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The update time of the aspect in the source system.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *AspectSource) Reset() {
	*x = AspectSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AspectSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AspectSource) ProtoMessage() {}

func (x *AspectSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AspectSource.ProtoReflect.Descriptor instead.
func (*AspectSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{4}
}

func (x *AspectSource) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AspectSource) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// An entry is a representation of a data asset which can be described by
// various metadata.
type Entry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The relative resource name of the Entry, of the form:
	// projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. The resource name of the EntryType used to create this
	// Entry.
	EntryType string `protobuf:"bytes,4,opt,name=entry_type,json=entryType,proto3" json:"entry_type,omitempty"`
	// Output only. The time when the Entry was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the Entry was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. The Aspects attached to the Entry.
	// The format for the key can be one of the following:
	// 1. {projectId}.{locationId}.{aspectTypeId} (if the aspect is attached
	// directly to the entry)
	// 2. {projectId}.{locationId}.{aspectTypeId}@{path} (if the aspect is
	// attached to an entry's path)
	Aspects map[string]*Aspect `protobuf:"bytes,9,rep,name=aspects,proto3" json:"aspects,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Immutable. The resource name of the parent entry.
	ParentEntry string `protobuf:"bytes,10,opt,name=parent_entry,json=parentEntry,proto3" json:"parent_entry,omitempty"`
	// Optional. A name for the entry that can reference it in an external system.
	// The maximum size of the field is 4000 characters.
	FullyQualifiedName string `protobuf:"bytes,12,opt,name=fully_qualified_name,json=fullyQualifiedName,proto3" json:"fully_qualified_name,omitempty"`
	// Optional. Source system related information for an entry.
	EntrySource *EntrySource `protobuf:"bytes,15,opt,name=entry_source,json=entrySource,proto3" json:"entry_source,omitempty"`
}

func (x *Entry) Reset() {
	*x = Entry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Entry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entry) ProtoMessage() {}

func (x *Entry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entry.ProtoReflect.Descriptor instead.
func (*Entry) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{5}
}

func (x *Entry) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Entry) GetEntryType() string {
	if x != nil {
		return x.EntryType
	}
	return ""
}

func (x *Entry) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Entry) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Entry) GetAspects() map[string]*Aspect {
	if x != nil {
		return x.Aspects
	}
	return nil
}

func (x *Entry) GetParentEntry() string {
	if x != nil {
		return x.ParentEntry
	}
	return ""
}

func (x *Entry) GetFullyQualifiedName() string {
	if x != nil {
		return x.FullyQualifiedName
	}
	return ""
}

func (x *Entry) GetEntrySource() *EntrySource {
	if x != nil {
		return x.EntrySource
	}
	return nil
}

// EntrySource contains source system related information for the
// entry.
type EntrySource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the resource in the source system.
	// The maximum size of the field is 4000 characters.
	Resource string `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	// The name of the source system.
	// The maximum size of the field is 64 characters.
	System string `protobuf:"bytes,2,opt,name=system,proto3" json:"system,omitempty"`
	// The platform containing the source system.
	// The maximum size of the field is 64 characters.
	Platform string `protobuf:"bytes,3,opt,name=platform,proto3" json:"platform,omitempty"`
	// User friendly display name.
	// The maximum size of the field is 500 characters.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Description of the Entry.
	// The maximum size of the field is 2000 characters.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// User-defined labels.
	// The maximum size of keys and values is 128 characters each.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Immutable. The ancestors of the Entry in the source system.
	Ancestors []*EntrySource_Ancestor `protobuf:"bytes,9,rep,name=ancestors,proto3" json:"ancestors,omitempty"`
	// The create time of the resource in the source system.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The update time of the resource in the source system.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *EntrySource) Reset() {
	*x = EntrySource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntrySource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntrySource) ProtoMessage() {}

func (x *EntrySource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntrySource.ProtoReflect.Descriptor instead.
func (*EntrySource) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{6}
}

func (x *EntrySource) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *EntrySource) GetSystem() string {
	if x != nil {
		return x.System
	}
	return ""
}

func (x *EntrySource) GetPlatform() string {
	if x != nil {
		return x.Platform
	}
	return ""
}

func (x *EntrySource) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *EntrySource) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *EntrySource) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *EntrySource) GetAncestors() []*EntrySource_Ancestor {
	if x != nil {
		return x.Ancestors
	}
	return nil
}

func (x *EntrySource) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *EntrySource) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Create EntryGroup Request
type CreateEntryGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the entryGroup, of the form:
	// projects/{project_number}/locations/{location_id}
	// where `location_id` refers to a GCP region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. EntryGroup identifier.
	EntryGroupId string `protobuf:"bytes,2,opt,name=entry_group_id,json=entryGroupId,proto3" json:"entry_group_id,omitempty"`
	// Required. EntryGroup Resource
	EntryGroup *EntryGroup `protobuf:"bytes,3,opt,name=entry_group,json=entryGroup,proto3" json:"entry_group,omitempty"`
	// Optional. Only validate the request, but do not perform mutations.
	// The default is false.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateEntryGroupRequest) Reset() {
	*x = CreateEntryGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateEntryGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEntryGroupRequest) ProtoMessage() {}

func (x *CreateEntryGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEntryGroupRequest.ProtoReflect.Descriptor instead.
func (*CreateEntryGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{7}
}

func (x *CreateEntryGroupRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEntryGroupRequest) GetEntryGroupId() string {
	if x != nil {
		return x.EntryGroupId
	}
	return ""
}

func (x *CreateEntryGroupRequest) GetEntryGroup() *EntryGroup {
	if x != nil {
		return x.EntryGroup
	}
	return nil
}

func (x *CreateEntryGroupRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Update EntryGroup Request
type UpdateEntryGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. EntryGroup Resource
	EntryGroup *EntryGroup `protobuf:"bytes,1,opt,name=entry_group,json=entryGroup,proto3" json:"entry_group,omitempty"`
	// Required. Mask of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. Only validate the request, but do not perform mutations.
	// The default is false.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateEntryGroupRequest) Reset() {
	*x = UpdateEntryGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateEntryGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEntryGroupRequest) ProtoMessage() {}

func (x *UpdateEntryGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEntryGroupRequest.ProtoReflect.Descriptor instead.
func (*UpdateEntryGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{8}
}

func (x *UpdateEntryGroupRequest) GetEntryGroup() *EntryGroup {
	if x != nil {
		return x.EntryGroup
	}
	return nil
}

func (x *UpdateEntryGroupRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateEntryGroupRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Delele EntryGroup Request
type DeleteEntryGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the EntryGroup:
	// `projects/{project_number}/locations/{location_id}/entryGroups/{entry_group_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If the client provided etag value does not match the current etag
	// value, the DeleteEntryGroupRequest method returns an ABORTED error response
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteEntryGroupRequest) Reset() {
	*x = DeleteEntryGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteEntryGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEntryGroupRequest) ProtoMessage() {}

func (x *DeleteEntryGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEntryGroupRequest.ProtoReflect.Descriptor instead.
func (*DeleteEntryGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{9}
}

func (x *DeleteEntryGroupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteEntryGroupRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// List entryGroups request.
type ListEntryGroupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the entryGroup location, of the form:
	// `projects/{project_number}/locations/{location_id}`
	// where `location_id` refers to a GCP region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of EntryGroups to return. The service may return
	// fewer than this value. If unspecified, at most 10 EntryGroups will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous `ListEntryGroups` call.
	// Provide this to retrieve the subsequent page. When paginating, all other
	// parameters provided to `ListEntryGroups` must match the call that provided
	// the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter request.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Order by fields for the result.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListEntryGroupsRequest) Reset() {
	*x = ListEntryGroupsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntryGroupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntryGroupsRequest) ProtoMessage() {}

func (x *ListEntryGroupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntryGroupsRequest.ProtoReflect.Descriptor instead.
func (*ListEntryGroupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{10}
}

func (x *ListEntryGroupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEntryGroupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEntryGroupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListEntryGroupsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListEntryGroupsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// List ListEntryGroups response.
type ListEntryGroupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ListEntryGroups under the given parent location.
	EntryGroups []*EntryGroup `protobuf:"bytes,1,rep,name=entry_groups,json=entryGroups,proto3" json:"entry_groups,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	UnreachableLocations []string `protobuf:"bytes,3,rep,name=unreachable_locations,json=unreachableLocations,proto3" json:"unreachable_locations,omitempty"`
}

func (x *ListEntryGroupsResponse) Reset() {
	*x = ListEntryGroupsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntryGroupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntryGroupsResponse) ProtoMessage() {}

func (x *ListEntryGroupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntryGroupsResponse.ProtoReflect.Descriptor instead.
func (*ListEntryGroupsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{11}
}

func (x *ListEntryGroupsResponse) GetEntryGroups() []*EntryGroup {
	if x != nil {
		return x.EntryGroups
	}
	return nil
}

func (x *ListEntryGroupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListEntryGroupsResponse) GetUnreachableLocations() []string {
	if x != nil {
		return x.UnreachableLocations
	}
	return nil
}

// Get EntryGroup request.
type GetEntryGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the EntryGroup:
	// `projects/{project_number}/locations/{location_id}/entryGroups/{entry_group_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEntryGroupRequest) Reset() {
	*x = GetEntryGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEntryGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntryGroupRequest) ProtoMessage() {}

func (x *GetEntryGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntryGroupRequest.ProtoReflect.Descriptor instead.
func (*GetEntryGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{12}
}

func (x *GetEntryGroupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Create EntryType Request
type CreateEntryTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the EntryType, of the form:
	// projects/{project_number}/locations/{location_id}
	// where `location_id` refers to a GCP region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. EntryType identifier.
	EntryTypeId string `protobuf:"bytes,2,opt,name=entry_type_id,json=entryTypeId,proto3" json:"entry_type_id,omitempty"`
	// Required. EntryType Resource
	EntryType *EntryType `protobuf:"bytes,3,opt,name=entry_type,json=entryType,proto3" json:"entry_type,omitempty"`
	// Optional. Only validate the request, but do not perform mutations.
	// The default is false.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateEntryTypeRequest) Reset() {
	*x = CreateEntryTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateEntryTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEntryTypeRequest) ProtoMessage() {}

func (x *CreateEntryTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEntryTypeRequest.ProtoReflect.Descriptor instead.
func (*CreateEntryTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{13}
}

func (x *CreateEntryTypeRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEntryTypeRequest) GetEntryTypeId() string {
	if x != nil {
		return x.EntryTypeId
	}
	return ""
}

func (x *CreateEntryTypeRequest) GetEntryType() *EntryType {
	if x != nil {
		return x.EntryType
	}
	return nil
}

func (x *CreateEntryTypeRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Update EntryType Request
type UpdateEntryTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. EntryType Resource
	EntryType *EntryType `protobuf:"bytes,1,opt,name=entry_type,json=entryType,proto3" json:"entry_type,omitempty"`
	// Required. Mask of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. Only validate the request, but do not perform mutations.
	// The default is false.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateEntryTypeRequest) Reset() {
	*x = UpdateEntryTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateEntryTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEntryTypeRequest) ProtoMessage() {}

func (x *UpdateEntryTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEntryTypeRequest.ProtoReflect.Descriptor instead.
func (*UpdateEntryTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{14}
}

func (x *UpdateEntryTypeRequest) GetEntryType() *EntryType {
	if x != nil {
		return x.EntryType
	}
	return nil
}

func (x *UpdateEntryTypeRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateEntryTypeRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Delele EntryType Request
type DeleteEntryTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the EntryType:
	// `projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If the client provided etag value does not match the current etag
	// value, the DeleteEntryTypeRequest method returns an ABORTED error response
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteEntryTypeRequest) Reset() {
	*x = DeleteEntryTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteEntryTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEntryTypeRequest) ProtoMessage() {}

func (x *DeleteEntryTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEntryTypeRequest.ProtoReflect.Descriptor instead.
func (*DeleteEntryTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{15}
}

func (x *DeleteEntryTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteEntryTypeRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// List EntryTypes request
type ListEntryTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the EntryType location, of the form:
	// `projects/{project_number}/locations/{location_id}`
	// where `location_id` refers to a GCP region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of EntryTypes to return. The service may return
	// fewer than this value. If unspecified, at most 10 EntryTypes will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous `ListEntryTypes` call.
	// Provide this to retrieve the subsequent page. When paginating, all other
	// parameters provided to `ListEntryTypes` must match the call that provided
	// the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter request. Filters are case-sensitive.
	// The following formats are supported:
	//
	// labels.key1 = "value1"
	// labels:key1
	// name = "value"
	// These restrictions can be coinjoined with AND, OR and NOT conjunctions.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Order by fields (`name` or `create_time`) for the result.
	// If not specified, the ordering is undefined.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListEntryTypesRequest) Reset() {
	*x = ListEntryTypesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntryTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntryTypesRequest) ProtoMessage() {}

func (x *ListEntryTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntryTypesRequest.ProtoReflect.Descriptor instead.
func (*ListEntryTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{16}
}

func (x *ListEntryTypesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEntryTypesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEntryTypesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListEntryTypesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListEntryTypesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// List EntryTypes response
type ListEntryTypesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ListEntryTypes under the given parent location.
	EntryTypes []*EntryType `protobuf:"bytes,1,rep,name=entry_types,json=entryTypes,proto3" json:"entry_types,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	UnreachableLocations []string `protobuf:"bytes,3,rep,name=unreachable_locations,json=unreachableLocations,proto3" json:"unreachable_locations,omitempty"`
}

func (x *ListEntryTypesResponse) Reset() {
	*x = ListEntryTypesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntryTypesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntryTypesResponse) ProtoMessage() {}

func (x *ListEntryTypesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntryTypesResponse.ProtoReflect.Descriptor instead.
func (*ListEntryTypesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{17}
}

func (x *ListEntryTypesResponse) GetEntryTypes() []*EntryType {
	if x != nil {
		return x.EntryTypes
	}
	return nil
}

func (x *ListEntryTypesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListEntryTypesResponse) GetUnreachableLocations() []string {
	if x != nil {
		return x.UnreachableLocations
	}
	return nil
}

// Get EntryType request
type GetEntryTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the EntryType:
	// `projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEntryTypeRequest) Reset() {
	*x = GetEntryTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEntryTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntryTypeRequest) ProtoMessage() {}

func (x *GetEntryTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntryTypeRequest.ProtoReflect.Descriptor instead.
func (*GetEntryTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{18}
}

func (x *GetEntryTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Create AspectType Request
type CreateAspectTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the AspectType, of the form:
	// projects/{project_number}/locations/{location_id}
	// where `location_id` refers to a GCP region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. AspectType identifier.
	AspectTypeId string `protobuf:"bytes,2,opt,name=aspect_type_id,json=aspectTypeId,proto3" json:"aspect_type_id,omitempty"`
	// Required. AspectType Resource
	AspectType *AspectType `protobuf:"bytes,3,opt,name=aspect_type,json=aspectType,proto3" json:"aspect_type,omitempty"`
	// Optional. Only validate the request, but do not perform mutations.
	// The default is false.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateAspectTypeRequest) Reset() {
	*x = CreateAspectTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAspectTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAspectTypeRequest) ProtoMessage() {}

func (x *CreateAspectTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAspectTypeRequest.ProtoReflect.Descriptor instead.
func (*CreateAspectTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{19}
}

func (x *CreateAspectTypeRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAspectTypeRequest) GetAspectTypeId() string {
	if x != nil {
		return x.AspectTypeId
	}
	return ""
}

func (x *CreateAspectTypeRequest) GetAspectType() *AspectType {
	if x != nil {
		return x.AspectType
	}
	return nil
}

func (x *CreateAspectTypeRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Update AspectType Request
type UpdateAspectTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. AspectType Resource
	AspectType *AspectType `protobuf:"bytes,1,opt,name=aspect_type,json=aspectType,proto3" json:"aspect_type,omitempty"`
	// Required. Mask of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. Only validate the request, but do not perform mutations.
	// The default is false.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateAspectTypeRequest) Reset() {
	*x = UpdateAspectTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAspectTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAspectTypeRequest) ProtoMessage() {}

func (x *UpdateAspectTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAspectTypeRequest.ProtoReflect.Descriptor instead.
func (*UpdateAspectTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{20}
}

func (x *UpdateAspectTypeRequest) GetAspectType() *AspectType {
	if x != nil {
		return x.AspectType
	}
	return nil
}

func (x *UpdateAspectTypeRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateAspectTypeRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Delele AspectType Request
type DeleteAspectTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the AspectType:
	// `projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If the client provided etag value does not match the current etag
	// value, the DeleteAspectTypeRequest method returns an ABORTED error response
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteAspectTypeRequest) Reset() {
	*x = DeleteAspectTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAspectTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAspectTypeRequest) ProtoMessage() {}

func (x *DeleteAspectTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAspectTypeRequest.ProtoReflect.Descriptor instead.
func (*DeleteAspectTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{21}
}

func (x *DeleteAspectTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteAspectTypeRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// List AspectTypes request
type ListAspectTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the AspectType location, of the form:
	// `projects/{project_number}/locations/{location_id}`
	// where `location_id` refers to a GCP region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of AspectTypes to return. The service may return
	// fewer than this value. If unspecified, at most 10 AspectTypes will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous `ListAspectTypes` call.
	// Provide this to retrieve the subsequent page. When paginating, all other
	// parameters provided to `ListAspectTypes` must match the call that provided
	// the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter request. Filters are case-sensitive.
	// The following formats are supported:
	//
	// labels.key1 = "value1"
	// labels:key1
	// name = "value"
	// These restrictions can be coinjoined with AND, OR and NOT conjunctions.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Order by fields (`name` or `create_time`) for the result.
	// If not specified, the ordering is undefined.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListAspectTypesRequest) Reset() {
	*x = ListAspectTypesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAspectTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAspectTypesRequest) ProtoMessage() {}

func (x *ListAspectTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAspectTypesRequest.ProtoReflect.Descriptor instead.
func (*ListAspectTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{22}
}

func (x *ListAspectTypesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAspectTypesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAspectTypesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAspectTypesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAspectTypesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// List AspectTypes response
type ListAspectTypesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ListAspectTypes under the given parent location.
	AspectTypes []*AspectType `protobuf:"bytes,1,rep,name=aspect_types,json=aspectTypes,proto3" json:"aspect_types,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	UnreachableLocations []string `protobuf:"bytes,3,rep,name=unreachable_locations,json=unreachableLocations,proto3" json:"unreachable_locations,omitempty"`
}

func (x *ListAspectTypesResponse) Reset() {
	*x = ListAspectTypesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAspectTypesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAspectTypesResponse) ProtoMessage() {}

func (x *ListAspectTypesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAspectTypesResponse.ProtoReflect.Descriptor instead.
func (*ListAspectTypesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{23}
}

func (x *ListAspectTypesResponse) GetAspectTypes() []*AspectType {
	if x != nil {
		return x.AspectTypes
	}
	return nil
}

func (x *ListAspectTypesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListAspectTypesResponse) GetUnreachableLocations() []string {
	if x != nil {
		return x.UnreachableLocations
	}
	return nil
}

// Get AspectType request
type GetAspectTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the AspectType:
	// `projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAspectTypeRequest) Reset() {
	*x = GetAspectTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAspectTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAspectTypeRequest) ProtoMessage() {}

func (x *GetAspectTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAspectTypeRequest.ProtoReflect.Descriptor instead.
func (*GetAspectTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{24}
}

func (x *GetAspectTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type CreateEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent Entry Group:
	// `projects/{project}/locations/{location}/entryGroups/{entry_group}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Entry identifier. It has to be unique within an Entry Group.
	//
	// Entries corresponding to Google Cloud resources use Entry ID format based
	// on Full Resource Names
	// (https://cloud.google.com/apis/design/resource_names#full_resource_name).
	// The format is a Full Resource Name of the resource without the
	// prefix double slashes in the API Service Name part of Full Resource Name.
	// This allows retrieval of entries using their associated resource name.
	//
	// For example if the Full Resource Name of a resource is
	// `//library.googleapis.com/shelves/shelf1/books/book2`,
	// then the suggested entry_id is
	// `library.googleapis.com/shelves/shelf1/books/book2`.
	//
	// It is also suggested to follow the same convention for entries
	// corresponding to resources from other providers or systems than Google
	// Cloud.
	//
	// The maximum size of the field is 4000 characters.
	EntryId string `protobuf:"bytes,2,opt,name=entry_id,json=entryId,proto3" json:"entry_id,omitempty"`
	// Required. Entry resource.
	Entry *Entry `protobuf:"bytes,3,opt,name=entry,proto3" json:"entry,omitempty"`
}

func (x *CreateEntryRequest) Reset() {
	*x = CreateEntryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEntryRequest) ProtoMessage() {}

func (x *CreateEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEntryRequest.ProtoReflect.Descriptor instead.
func (*CreateEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{25}
}

func (x *CreateEntryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEntryRequest) GetEntryId() string {
	if x != nil {
		return x.EntryId
	}
	return ""
}

func (x *CreateEntryRequest) GetEntry() *Entry {
	if x != nil {
		return x.Entry
	}
	return nil
}

type UpdateEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Entry resource.
	Entry *Entry `protobuf:"bytes,1,opt,name=entry,proto3" json:"entry,omitempty"`
	// Optional. Mask of fields to update. To update Aspects, the update_mask must
	// contain the value "aspects".
	//
	// If the update_mask is empty, all modifiable fields present in the request
	// will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. If set to true and the entry does not exist, it will be created.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// Optional. If set to true and the aspect_keys specify aspect ranges, any
	// existing aspects from that range not provided in the request will be
	// deleted.
	DeleteMissingAspects bool `protobuf:"varint,4,opt,name=delete_missing_aspects,json=deleteMissingAspects,proto3" json:"delete_missing_aspects,omitempty"`
	// Optional. The map keys of the Aspects which should be modified. Supports
	// the following syntaxes:
	// * <aspect_type_reference> - matches aspect on given type and empty path
	// * <aspect_type_reference>@path - matches aspect on given type and specified
	// path
	// * <aspect_type_reference>* - matches aspects on given type for all paths
	// * *@path - matches aspects of all types on the given path
	//
	// Existing aspects matching the syntax will not be removed unless
	// `delete_missing_aspects` is set to true.
	//
	// If this field is left empty, it will be treated as specifying exactly those
	// Aspects present in the request.
	AspectKeys []string `protobuf:"bytes,5,rep,name=aspect_keys,json=aspectKeys,proto3" json:"aspect_keys,omitempty"`
}

func (x *UpdateEntryRequest) Reset() {
	*x = UpdateEntryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEntryRequest) ProtoMessage() {}

func (x *UpdateEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEntryRequest.ProtoReflect.Descriptor instead.
func (*UpdateEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{26}
}

func (x *UpdateEntryRequest) GetEntry() *Entry {
	if x != nil {
		return x.Entry
	}
	return nil
}

func (x *UpdateEntryRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateEntryRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *UpdateEntryRequest) GetDeleteMissingAspects() bool {
	if x != nil {
		return x.DeleteMissingAspects
	}
	return false
}

func (x *UpdateEntryRequest) GetAspectKeys() []string {
	if x != nil {
		return x.AspectKeys
	}
	return nil
}

type DeleteEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Entry:
	// `projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteEntryRequest) Reset() {
	*x = DeleteEntryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEntryRequest) ProtoMessage() {}

func (x *DeleteEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEntryRequest.ProtoReflect.Descriptor instead.
func (*DeleteEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{27}
}

func (x *DeleteEntryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type ListEntriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent Entry Group:
	// `projects/{project}/locations/{location}/entryGroups/{entry_group}`.
	Parent   string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	PageSize int32  `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The pagination token returned by a previous request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A filter on the entries to return.
	// Filters are case-sensitive.
	// The request can be filtered by the following fields:
	// entry_type, entry_source.display_name.
	// The comparison operators are =, !=, <, >, <=, >= (strings are compared
	// according to lexical order)
	// The logical operators AND, OR, NOT can be used
	// in the filter. Wildcard "*" can be used, but for entry_type the full
	// project id or number needs to be provided. Example filter expressions:
	// "entry_source.display_name=AnExampleDisplayName"
	// "entry_type=projects/example-project/locations/global/entryTypes/example-entry_type"
	// "entry_type=projects/example-project/locations/us/entryTypes/a* OR
	//
	//	entry_type=projects/another-project/locations/*"
	//
	// "NOT entry_source.display_name=AnotherExampleDisplayName"
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListEntriesRequest) Reset() {
	*x = ListEntriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntriesRequest) ProtoMessage() {}

func (x *ListEntriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntriesRequest.ProtoReflect.Descriptor instead.
func (*ListEntriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{28}
}

func (x *ListEntriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEntriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEntriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListEntriesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

type ListEntriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of entries.
	Entries []*Entry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	// Pagination token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEntriesResponse) Reset() {
	*x = ListEntriesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntriesResponse) ProtoMessage() {}

func (x *ListEntriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntriesResponse.ProtoReflect.Descriptor instead.
func (*ListEntriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{29}
}

func (x *ListEntriesResponse) GetEntries() []*Entry {
	if x != nil {
		return x.Entries
	}
	return nil
}

func (x *ListEntriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type GetEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Entry:
	// `projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. View for controlling which parts of an entry are to be returned.
	View EntryView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.dataplex.v1.EntryView" json:"view,omitempty"`
	// Optional. Limits the aspects returned to the provided aspect types.
	// Only works if the CUSTOM view is selected.
	AspectTypes []string `protobuf:"bytes,3,rep,name=aspect_types,json=aspectTypes,proto3" json:"aspect_types,omitempty"`
	// Optional. Limits the aspects returned to those associated with the provided
	// paths within the Entry. Only works if the CUSTOM view is selected.
	Paths []string `protobuf:"bytes,4,rep,name=paths,proto3" json:"paths,omitempty"`
}

func (x *GetEntryRequest) Reset() {
	*x = GetEntryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntryRequest) ProtoMessage() {}

func (x *GetEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntryRequest.ProtoReflect.Descriptor instead.
func (*GetEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{30}
}

func (x *GetEntryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetEntryRequest) GetView() EntryView {
	if x != nil {
		return x.View
	}
	return EntryView_ENTRY_VIEW_UNSPECIFIED
}

func (x *GetEntryRequest) GetAspectTypes() []string {
	if x != nil {
		return x.AspectTypes
	}
	return nil
}

func (x *GetEntryRequest) GetPaths() []string {
	if x != nil {
		return x.Paths
	}
	return nil
}

type LookupEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project to which the request should be attributed in the
	// following form: `projects/{project}/locations/{location}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. View for controlling which parts of an entry are to be returned.
	View EntryView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.dataplex.v1.EntryView" json:"view,omitempty"`
	// Optional. Limits the aspects returned to the provided aspect types.
	// Only works if the CUSTOM view is selected.
	AspectTypes []string `protobuf:"bytes,3,rep,name=aspect_types,json=aspectTypes,proto3" json:"aspect_types,omitempty"`
	// Optional. Limits the aspects returned to those associated with the provided
	// paths within the Entry. Only works if the CUSTOM view is selected.
	Paths []string `protobuf:"bytes,4,rep,name=paths,proto3" json:"paths,omitempty"`
	// Required. The resource name of the Entry:
	// `projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}`.
	Entry string `protobuf:"bytes,5,opt,name=entry,proto3" json:"entry,omitempty"`
}

func (x *LookupEntryRequest) Reset() {
	*x = LookupEntryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LookupEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LookupEntryRequest) ProtoMessage() {}

func (x *LookupEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LookupEntryRequest.ProtoReflect.Descriptor instead.
func (*LookupEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{31}
}

func (x *LookupEntryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LookupEntryRequest) GetView() EntryView {
	if x != nil {
		return x.View
	}
	return EntryView_ENTRY_VIEW_UNSPECIFIED
}

func (x *LookupEntryRequest) GetAspectTypes() []string {
	if x != nil {
		return x.AspectTypes
	}
	return nil
}

func (x *LookupEntryRequest) GetPaths() []string {
	if x != nil {
		return x.Paths
	}
	return nil
}

func (x *LookupEntryRequest) GetEntry() string {
	if x != nil {
		return x.Entry
	}
	return ""
}

type SearchEntriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project to which the request should be attributed in the
	// following form: `projects/{project}/locations/{location}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The query against which entries in scope should be matched.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. Pagination.
	PageSize  int32  `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Ordering of the results. Supported options to be added later.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. The scope under which the search should be operating. Should
	// either be organizations/<org_id> or projects/<project_ref>. If left
	// unspecified, it will default to the organization where the project provided
	// in `name` is located.
	Scope string `protobuf:"bytes,7,opt,name=scope,proto3" json:"scope,omitempty"`
}

func (x *SearchEntriesRequest) Reset() {
	*x = SearchEntriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchEntriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchEntriesRequest) ProtoMessage() {}

func (x *SearchEntriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchEntriesRequest.ProtoReflect.Descriptor instead.
func (*SearchEntriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{32}
}

func (x *SearchEntriesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SearchEntriesRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchEntriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchEntriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchEntriesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *SearchEntriesRequest) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

// A single result of a SearchEntries request.
type SearchEntriesResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Linked resource name.
	LinkedResource string `protobuf:"bytes,8,opt,name=linked_resource,json=linkedResource,proto3" json:"linked_resource,omitempty"`
	// Entry format of the result.
	DataplexEntry *Entry `protobuf:"bytes,9,opt,name=dataplex_entry,json=dataplexEntry,proto3" json:"dataplex_entry,omitempty"`
	// Snippets.
	Snippets *SearchEntriesResult_Snippets `protobuf:"bytes,12,opt,name=snippets,proto3" json:"snippets,omitempty"`
}

func (x *SearchEntriesResult) Reset() {
	*x = SearchEntriesResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchEntriesResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchEntriesResult) ProtoMessage() {}

func (x *SearchEntriesResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchEntriesResult.ProtoReflect.Descriptor instead.
func (*SearchEntriesResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{33}
}

func (x *SearchEntriesResult) GetLinkedResource() string {
	if x != nil {
		return x.LinkedResource
	}
	return ""
}

func (x *SearchEntriesResult) GetDataplexEntry() *Entry {
	if x != nil {
		return x.DataplexEntry
	}
	return nil
}

func (x *SearchEntriesResult) GetSnippets() *SearchEntriesResult_Snippets {
	if x != nil {
		return x.Snippets
	}
	return nil
}

type SearchEntriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The results matching the search query.
	Results []*SearchEntriesResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// The estimated total number of matching entries. Not guaranteed to be
	// accurate.
	TotalSize int32 `protobuf:"varint,2,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	// Pagination token.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Unreachable locations. Search results don't include data from those
	// locations.
	Unreachable []string `protobuf:"bytes,4,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *SearchEntriesResponse) Reset() {
	*x = SearchEntriesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchEntriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchEntriesResponse) ProtoMessage() {}

func (x *SearchEntriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchEntriesResponse.ProtoReflect.Descriptor instead.
func (*SearchEntriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{34}
}

func (x *SearchEntriesResponse) GetResults() []*SearchEntriesResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *SearchEntriesResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

func (x *SearchEntriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *SearchEntriesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Autorization for an Aspect Type.
type AspectType_Authorization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The IAM permission grantable on the Entry Group to allow
	// access to instantiate Aspects of Dataplex owned Aspect Types, only
	// settable for Dataplex owned Types.
	AlternateUsePermission string `protobuf:"bytes,1,opt,name=alternate_use_permission,json=alternateUsePermission,proto3" json:"alternate_use_permission,omitempty"`
}

func (x *AspectType_Authorization) Reset() {
	*x = AspectType_Authorization{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AspectType_Authorization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AspectType_Authorization) ProtoMessage() {}

func (x *AspectType_Authorization) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AspectType_Authorization.ProtoReflect.Descriptor instead.
func (*AspectType_Authorization) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{0, 0}
}

func (x *AspectType_Authorization) GetAlternateUsePermission() string {
	if x != nil {
		return x.AlternateUsePermission
	}
	return ""
}

// MetadataTemplate definition for AspectType
type AspectType_MetadataTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Index is used to encode Template messages. The value of index
	// can range between 1 and 2,147,483,647. Index must be unique within all
	// fields in a Template. (Nested Templates can reuse indexes). Once a
	// Template is defined, the index cannot be changed, because it identifies
	// the field in the actual storage format. Index is a mandatory field, but
	// it is optional for top level fields, and map/array "values" definitions.
	Index int32 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	// Required. The name of the field.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The datatype of this field. The following values are supported:
	// Primitive types (string, integer, boolean, double, datetime); datetime
	// must be of the format RFC3339 UTC "Zulu" (Examples:
	// "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z"). Complex
	// types (enum, array, map, record).
	Type string `protobuf:"bytes,5,opt,name=type,proto3" json:"type,omitempty"`
	// Optional. Field definition, needs to be specified if the type is record.
	// Defines the nested fields.
	RecordFields []*AspectType_MetadataTemplate `protobuf:"bytes,6,rep,name=record_fields,json=recordFields,proto3" json:"record_fields,omitempty"`
	// Optional. The list of values for an enum type. Needs to be defined if the
	// type is enum.
	EnumValues []*AspectType_MetadataTemplate_EnumValue `protobuf:"bytes,8,rep,name=enum_values,json=enumValues,proto3" json:"enum_values,omitempty"`
	// Optional. map_items needs to be set if the type is map. map_items can
	// refer to a primitive field or a complex (record only) field. To specify a
	// primitive field, just name and type needs to be set in the nested
	// MetadataTemplate. The recommended value for the name field is item, as
	// this is not used in the actual payload.
	MapItems *AspectType_MetadataTemplate `protobuf:"bytes,10,opt,name=map_items,json=mapItems,proto3" json:"map_items,omitempty"`
	// Optional. array_items needs to be set if the type is array. array_items
	// can refer to a primitive field or a complex (record only) field. To
	// specify a primitive field, just name and type needs to be set in the
	// nested MetadataTemplate. The recommended value for the name field is
	// item, as this is not used in the actual payload.
	ArrayItems *AspectType_MetadataTemplate `protobuf:"bytes,11,opt,name=array_items,json=arrayItems,proto3" json:"array_items,omitempty"`
	// Optional. Id can be used if this definition of the field needs to be
	// reused later. Id needs to be unique across the entire template. Id can
	// only be specified if the field type is record.
	TypeId string `protobuf:"bytes,12,opt,name=type_id,json=typeId,proto3" json:"type_id,omitempty"`
	// Optional. A reference to another field definition (instead of an inline
	// definition). The value must be equal to the value of an id field defined
	// elsewhere in the MetadataTemplate. Only fields with type as record can
	// refer to other fields.
	TypeRef string `protobuf:"bytes,13,opt,name=type_ref,json=typeRef,proto3" json:"type_ref,omitempty"`
	// Optional. Specifies the constraints on this field.
	Constraints *AspectType_MetadataTemplate_Constraints `protobuf:"bytes,50,opt,name=constraints,proto3" json:"constraints,omitempty"`
	// Optional. Specifies annotations on this field.
	Annotations *AspectType_MetadataTemplate_Annotations `protobuf:"bytes,51,opt,name=annotations,proto3" json:"annotations,omitempty"`
}

func (x *AspectType_MetadataTemplate) Reset() {
	*x = AspectType_MetadataTemplate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AspectType_MetadataTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AspectType_MetadataTemplate) ProtoMessage() {}

func (x *AspectType_MetadataTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AspectType_MetadataTemplate.ProtoReflect.Descriptor instead.
func (*AspectType_MetadataTemplate) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{0, 1}
}

func (x *AspectType_MetadataTemplate) GetIndex() int32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *AspectType_MetadataTemplate) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AspectType_MetadataTemplate) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *AspectType_MetadataTemplate) GetRecordFields() []*AspectType_MetadataTemplate {
	if x != nil {
		return x.RecordFields
	}
	return nil
}

func (x *AspectType_MetadataTemplate) GetEnumValues() []*AspectType_MetadataTemplate_EnumValue {
	if x != nil {
		return x.EnumValues
	}
	return nil
}

func (x *AspectType_MetadataTemplate) GetMapItems() *AspectType_MetadataTemplate {
	if x != nil {
		return x.MapItems
	}
	return nil
}

func (x *AspectType_MetadataTemplate) GetArrayItems() *AspectType_MetadataTemplate {
	if x != nil {
		return x.ArrayItems
	}
	return nil
}

func (x *AspectType_MetadataTemplate) GetTypeId() string {
	if x != nil {
		return x.TypeId
	}
	return ""
}

func (x *AspectType_MetadataTemplate) GetTypeRef() string {
	if x != nil {
		return x.TypeRef
	}
	return ""
}

func (x *AspectType_MetadataTemplate) GetConstraints() *AspectType_MetadataTemplate_Constraints {
	if x != nil {
		return x.Constraints
	}
	return nil
}

func (x *AspectType_MetadataTemplate) GetAnnotations() *AspectType_MetadataTemplate_Annotations {
	if x != nil {
		return x.Annotations
	}
	return nil
}

// Definition of Enumvalue (to be used by enum fields)
type AspectType_MetadataTemplate_EnumValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Index for the enum. Cannot be modified.
	Index int32 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	// Required. Name of the enumvalue. This is the actual value that the
	// aspect will contain.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Optional deprecation message to be set if an enum value needs
	// to be deprecated.
	Deprecated string `protobuf:"bytes,3,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
}

func (x *AspectType_MetadataTemplate_EnumValue) Reset() {
	*x = AspectType_MetadataTemplate_EnumValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AspectType_MetadataTemplate_EnumValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AspectType_MetadataTemplate_EnumValue) ProtoMessage() {}

func (x *AspectType_MetadataTemplate_EnumValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AspectType_MetadataTemplate_EnumValue.ProtoReflect.Descriptor instead.
func (*AspectType_MetadataTemplate_EnumValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *AspectType_MetadataTemplate_EnumValue) GetIndex() int32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *AspectType_MetadataTemplate_EnumValue) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AspectType_MetadataTemplate_EnumValue) GetDeprecated() string {
	if x != nil {
		return x.Deprecated
	}
	return ""
}

// Definition of the constraints of a field
type AspectType_MetadataTemplate_Constraints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Marks this as an optional/required field.
	Required bool `protobuf:"varint,1,opt,name=required,proto3" json:"required,omitempty"`
}

func (x *AspectType_MetadataTemplate_Constraints) Reset() {
	*x = AspectType_MetadataTemplate_Constraints{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AspectType_MetadataTemplate_Constraints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AspectType_MetadataTemplate_Constraints) ProtoMessage() {}

func (x *AspectType_MetadataTemplate_Constraints) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AspectType_MetadataTemplate_Constraints.ProtoReflect.Descriptor instead.
func (*AspectType_MetadataTemplate_Constraints) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{0, 1, 1}
}

func (x *AspectType_MetadataTemplate_Constraints) GetRequired() bool {
	if x != nil {
		return x.Required
	}
	return false
}

// Definition of the annotations of a field
type AspectType_MetadataTemplate_Annotations struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Marks a field as deprecated, a deprecation message can be
	// included.
	Deprecated string `protobuf:"bytes,1,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
	// Optional. Specify a displayname for a field.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Specify a description for a field
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Specify a display order for a field. Display order can be
	// used to reorder where a field is rendered
	DisplayOrder int32 `protobuf:"varint,4,opt,name=display_order,json=displayOrder,proto3" json:"display_order,omitempty"`
	// Optional. String Type annotations can be used to specify special
	// meaning to string fields. The following values are supported: richText:
	// The field must be interpreted as a rich text field. url: A fully
	// qualified url link. resource: A service qualified resource reference.
	StringType string `protobuf:"bytes,6,opt,name=string_type,json=stringType,proto3" json:"string_type,omitempty"`
	// Optional. Suggested hints for string fields. These can be used to
	// suggest values to users, through an UI for example.
	StringValues []string `protobuf:"bytes,7,rep,name=string_values,json=stringValues,proto3" json:"string_values,omitempty"`
}

func (x *AspectType_MetadataTemplate_Annotations) Reset() {
	*x = AspectType_MetadataTemplate_Annotations{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AspectType_MetadataTemplate_Annotations) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AspectType_MetadataTemplate_Annotations) ProtoMessage() {}

func (x *AspectType_MetadataTemplate_Annotations) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AspectType_MetadataTemplate_Annotations.ProtoReflect.Descriptor instead.
func (*AspectType_MetadataTemplate_Annotations) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{0, 1, 2}
}

func (x *AspectType_MetadataTemplate_Annotations) GetDeprecated() string {
	if x != nil {
		return x.Deprecated
	}
	return ""
}

func (x *AspectType_MetadataTemplate_Annotations) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AspectType_MetadataTemplate_Annotations) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *AspectType_MetadataTemplate_Annotations) GetDisplayOrder() int32 {
	if x != nil {
		return x.DisplayOrder
	}
	return 0
}

func (x *AspectType_MetadataTemplate_Annotations) GetStringType() string {
	if x != nil {
		return x.StringType
	}
	return ""
}

func (x *AspectType_MetadataTemplate_Annotations) GetStringValues() []string {
	if x != nil {
		return x.StringValues
	}
	return nil
}

type EntryType_AspectInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required aspect type for the entry type.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *EntryType_AspectInfo) Reset() {
	*x = EntryType_AspectInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntryType_AspectInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntryType_AspectInfo) ProtoMessage() {}

func (x *EntryType_AspectInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntryType_AspectInfo.ProtoReflect.Descriptor instead.
func (*EntryType_AspectInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{2, 0}
}

func (x *EntryType_AspectInfo) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// Authorization for an Entry Type.
type EntryType_Authorization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The IAM permission grantable on the Entry Group to allow
	// access to instantiate Entries of Dataplex owned Entry Types, only
	// settable for Dataplex owned Types.
	AlternateUsePermission string `protobuf:"bytes,1,opt,name=alternate_use_permission,json=alternateUsePermission,proto3" json:"alternate_use_permission,omitempty"`
}

func (x *EntryType_Authorization) Reset() {
	*x = EntryType_Authorization{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntryType_Authorization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntryType_Authorization) ProtoMessage() {}

func (x *EntryType_Authorization) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntryType_Authorization.ProtoReflect.Descriptor instead.
func (*EntryType_Authorization) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{2, 1}
}

func (x *EntryType_Authorization) GetAlternateUsePermission() string {
	if x != nil {
		return x.AlternateUsePermission
	}
	return ""
}

// Ancestor contains information about individual items in the hierarchy of
// an Entry.
type EntrySource_Ancestor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of the ancestor resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The type of the ancestor resource.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *EntrySource_Ancestor) Reset() {
	*x = EntrySource_Ancestor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntrySource_Ancestor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntrySource_Ancestor) ProtoMessage() {}

func (x *EntrySource_Ancestor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntrySource_Ancestor.ProtoReflect.Descriptor instead.
func (*EntrySource_Ancestor) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{6, 0}
}

func (x *EntrySource_Ancestor) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EntrySource_Ancestor) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// Snippets for the entry, contains HTML-style highlighting for
// matched tokens, will be used in UI.
type SearchEntriesResult_Snippets struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Entry
	DataplexEntry *Entry `protobuf:"bytes,1,opt,name=dataplex_entry,json=dataplexEntry,proto3" json:"dataplex_entry,omitempty"`
}

func (x *SearchEntriesResult_Snippets) Reset() {
	*x = SearchEntriesResult_Snippets{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchEntriesResult_Snippets) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchEntriesResult_Snippets) ProtoMessage() {}

func (x *SearchEntriesResult_Snippets) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchEntriesResult_Snippets.ProtoReflect.Descriptor instead.
func (*SearchEntriesResult_Snippets) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{33, 0}
}

func (x *SearchEntriesResult_Snippets) GetDataplexEntry() *Entry {
	if x != nil {
		return x.DataplexEntry
	}
	return nil
}

var File_google_cloud_dataplex_v1_catalog_proto protoreflect.FileDescriptor

var file_google_cloud_dataplex_v1_catalog_proto_rawDesc = []byte{
	0x0a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xd2, 0x10, 0x0a, 0x0a, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0,
	0x41, 0x03, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x5d, 0x0a, 0x0d,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x34, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0d, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x0a, 0x11, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x18, 0x35, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x10, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x12, 0x57, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0xca, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0x4e, 0x0a,
	0x0d, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d,
	0x0a, 0x18, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x5f,
	0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x16, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x65,
	0x55, 0x73, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x83, 0x09,
	0x0a, 0x10, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x5f, 0x0a, 0x0d, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73,
	0x12, 0x65, 0x0a, 0x0b, 0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18,
	0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x45, 0x6e, 0x75,
	0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x65, 0x6e, 0x75,
	0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x57, 0x0a, 0x09, 0x6d, 0x61, 0x70, 0x5f, 0x69,
	0x74, 0x65, 0x6d, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6d, 0x61, 0x70, 0x49, 0x74, 0x65, 0x6d, 0x73,
	0x12, 0x5b, 0x0a, 0x0b, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x61, 0x72, 0x72, 0x61, 0x79, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x1c, 0x0a,
	0x07, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x06, 0x74, 0x79, 0x70, 0x65, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x08, 0x74,
	0x79, 0x70, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x07, 0x74, 0x79, 0x70, 0x65, 0x52, 0x65, 0x66, 0x12, 0x68, 0x0a, 0x0b, 0x63,
	0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x32, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x68, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x33, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a,
	0x64, 0x0a, 0x09, 0x45, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x19, 0x0a, 0x05,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x23, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65,
	0x63, 0x61, 0x74, 0x65, 0x64, 0x1a, 0x2e, 0x0a, 0x0b, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x74, 0x73, 0x12, 0x1f, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x72, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x64, 0x1a, 0xfb, 0x01, 0x0a, 0x0b, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x23, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61,
	0x74, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a,
	0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x72,
	0x64, 0x65, 0x72, 0x12, 0x24, 0x0a, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x73,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x84,
	0x01, 0xea, 0x41, 0x80, 0x01, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x7b,
	0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x7d, 0x2a, 0x0b, 0x61, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x32, 0x0a, 0x61, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x22, 0xb4, 0x05, 0x0a, 0x0a, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4d,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x12, 0x0a,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x12, 0x57, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0xca, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x84, 0x01, 0xea, 0x41, 0x80, 0x01, 0x0a, 0x22, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x7d, 0x2a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x32, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x90, 0x08, 0x0a,
	0x09, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x4c, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x26, 0x0a, 0x0c, 0x74, 0x79,
	0x70, 0x65, 0x5f, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x74, 0x79, 0x70, 0x65, 0x41, 0x6c, 0x69, 0x61, 0x73,
	0x65, 0x73, 0x12, 0x1f, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x12, 0x59, 0x0a, 0x10, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x73, 0x18, 0x32, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x2e,
	0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0f, 0x72, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x64, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x73, 0x12, 0x5c, 0x0a, 0x0d, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x33, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0d, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x49, 0x0a, 0x0a, 0x41, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3b, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x1a, 0x4e, 0x0a, 0x0d, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x18, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x74, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x16, 0x61, 0x6c,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a,
	0x7e, 0xea, 0x41, 0x7b, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x7d, 0x2a, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x73, 0x32, 0x09, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x22,
	0xcf, 0x02, 0x0a, 0x06, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x30, 0x0a,
	0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x50, 0x0a, 0x0d, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x22, 0x88, 0x01, 0x0a, 0x0c, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xb0, 0x05, 0x0a,
	0x05, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x25, 0x0a, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x09, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x07, 0x61, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x41, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07,
	0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x73, 0x12, 0x29, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0,
	0x41, 0x01, 0xe0, 0x41, 0x05, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x35, 0x0a, 0x14, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x5f, 0x71, 0x75, 0x61, 0x6c,
	0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x51, 0x75, 0x61, 0x6c,
	0x69, 0x66, 0x69, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x0c, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x1a, 0x5c, 0x0a, 0x0c, 0x41, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x36, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x86, 0x01, 0xea, 0x41, 0x82, 0x01, 0x0a, 0x1d, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x51, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x7d, 0x2f,
	0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x7d, 0x2a,
	0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x32, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x22,
	0xb3, 0x04, 0x0a, 0x0b, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x1a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x07,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12,
	0x51, 0x0a, 0x09, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x09, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x41, 0x6e, 0x63, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x09, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x3c, 0x0a, 0x08,
	0x41, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xfd, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x0e, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x12,
	0x4a, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x28, 0x0a, 0x0d, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xd1, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4a, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12,
	0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x72, 0x0a, 0x17, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0xde, 0x01,
	0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xbf,
	0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x0c, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x33, 0x0a, 0x15, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0x56, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xf7, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x27, 0x0a, 0x0d, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x49, 0x64, 0x12,
	0x47, 0x0a, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e,
	0x6c, 0x79, 0x22, 0xcd, 0x01, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a,
	0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e,
	0x6c, 0x79, 0x22, 0x70, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x22, 0xdd, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x42, 0x79, 0x22, 0xbb, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x44, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x33, 0x0a,
	0x15, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x22, 0x54, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xfd, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x0e, 0x61, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x49, 0x64, 0x12, 0x4a, 0x0a, 0x0b, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x28,
	0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xd1, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x0b, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f,
	0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x72, 0x0a, 0x17,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x22, 0xde, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x22, 0xbf, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a,
	0x0c, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x61, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x33,
	0x0a, 0x15, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x22, 0x56, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb4, 0x01, 0x0a, 0x12,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x49, 0x64, 0x12, 0x3a, 0x0a, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x22, 0x9d, 0x02, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x05, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e,
	0x67, 0x12, 0x39, 0x0a, 0x16, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x5f, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x69,
	0x73, 0x73, 0x69, 0x6e, 0x67, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x73, 0x12, 0x24, 0x0a, 0x0b,
	0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x4b, 0x65,
	0x79, 0x73, 0x22, 0x4f, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xbb, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x22, 0x78, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x39, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xcd, 0x01, 0x0a, 0x0f,
	0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3c, 0x0a, 0x04, 0x76, 0x69,
	0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x12, 0x19, 0x0a, 0x05, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x70, 0x61, 0x74, 0x68, 0x73, 0x22, 0xeb, 0x01, 0x0a, 0x12,
	0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3c, 0x0a, 0x04, 0x76,
	0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x12, 0x19, 0x0a, 0x05, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x70, 0x61, 0x74, 0x68, 0x73, 0x12, 0x3b, 0x0a, 0x05,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x22, 0xcb, 0x01, 0x0a, 0x14, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1e, 0x0a, 0x08,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x19, 0x0a, 0x05,
	0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x22, 0xae, 0x02, 0x0a, 0x13, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12,
	0x27, 0x0a, 0x0f, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x46, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x52, 0x0a, 0x08, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x73, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x2e, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x73, 0x52, 0x08, 0x73, 0x6e, 0x69, 0x70,
	0x70, 0x65, 0x74, 0x73, 0x1a, 0x52, 0x0a, 0x08, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x73,
	0x12, 0x46, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x5f, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x22, 0xc9, 0x01, 0x0a, 0x15, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x47, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x2a, 0x51, 0x0a, 0x09, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x56, 0x69, 0x65,
	0x77, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x4e, 0x54, 0x52, 0x59, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a,
	0x05, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c, 0x4c,
	0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x10, 0x03, 0x12, 0x07,
	0x0a, 0x03, 0x41, 0x4c, 0x4c, 0x10, 0x04, 0x2a, 0x70, 0x0a, 0x0e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1f, 0x0a, 0x1b, 0x54, 0x52, 0x41,
	0x4e, 0x53, 0x46, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x54, 0x52,
	0x41, 0x4e, 0x53, 0x46, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x4d, 0x49,
	0x47, 0x52, 0x41, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b, 0x54, 0x52, 0x41, 0x4e,
	0x53, 0x46, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x54, 0x52, 0x41, 0x4e,
	0x53, 0x46, 0x45, 0x52, 0x52, 0x45, 0x44, 0x10, 0x02, 0x32, 0x82, 0x23, 0x0a, 0x0e, 0x43, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xea, 0x01, 0x0a,
	0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x85, 0x01, 0xca, 0x41, 0x1e, 0x0a, 0x09, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x0a, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0xec, 0x01, 0x0a, 0x0f, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x87,
	0x01, 0xca, 0x41, 0x1e, 0x0a, 0x09, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x16, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x47, 0x3a, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x32, 0x39, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xce, 0x01, 0x0a, 0x0f, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6a, 0xca,
	0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x2a, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb4, 0x01, 0x0a, 0x0e, 0x4c, 0x69,
	0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x3f, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30,
	0x12, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x12, 0xa1, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x22, 0x3d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf1, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8a, 0x01, 0xca, 0x41,
	0x1f, 0x0a, 0x0a, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x2c, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a, 0x0b, 0x61, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0xf3, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x8c, 0x01, 0xca, 0x41, 0x1f, 0x0a, 0x0a, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x17, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x4a, 0x3a, 0x0b, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x32, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd1,
	0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6b, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xb8, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0xa5, 0x01,
	0x0a, 0x0d, 0x47, 0x65, 0x74, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf1, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8a, 0x01, 0xca,
	0x41, 0x1f, 0x0a, 0x0a, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a, 0x0b, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0xf3, 0x01, 0x0a, 0x10, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x8c, 0x01, 0xca, 0x41, 0x1f, 0x0a, 0x0a, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x17, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x3a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x32, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xd1, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6b, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xb8, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0xa5,
	0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbe, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x60, 0xda, 0x41, 0x15, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x39, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0xc1, 0x01, 0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x63, 0xda, 0x41, 0x11, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x49, 0x3a, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x32, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f,
	0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2a, 0x7d, 0x12, 0xa7, 0x01, 0x0a, 0x0b,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x49, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x2a, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2a, 0x7d, 0x12, 0xb6, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e,
	0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x4a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0xa1,
	0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x49, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x2a, 0x7d, 0x12, 0x93, 0x01, 0x0a, 0x0b, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f,
	0x6f, 0x6b, 0x75, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x22, 0x35, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c, 0x6f, 0x6f,
	0x6b, 0x75, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0xb6, 0x01, 0x0a, 0x0d, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x44, 0xda, 0x41, 0x0a,
	0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31,
	0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x1a, 0x4b, 0xca, 0x41, 0x17, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xbc,
	0x01, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x42,
	0x0c, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x70, 0x62, 0x3b, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x70, 0x62, 0xaa, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x44, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x5c, 0x56, 0x31, 0xea,
	0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x44, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dataplex_v1_catalog_proto_rawDescOnce sync.Once
	file_google_cloud_dataplex_v1_catalog_proto_rawDescData = file_google_cloud_dataplex_v1_catalog_proto_rawDesc
)

func file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP() []byte {
	file_google_cloud_dataplex_v1_catalog_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataplex_v1_catalog_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataplex_v1_catalog_proto_rawDescData)
	})
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescData
}

var file_google_cloud_dataplex_v1_catalog_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_dataplex_v1_catalog_proto_msgTypes = make([]protoimpl.MessageInfo, 49)
var file_google_cloud_dataplex_v1_catalog_proto_goTypes = []interface{}{
	(EntryView)(0),                                  // 0: google.cloud.dataplex.v1.EntryView
	(TransferStatus)(0),                             // 1: google.cloud.dataplex.v1.TransferStatus
	(*AspectType)(nil),                              // 2: google.cloud.dataplex.v1.AspectType
	(*EntryGroup)(nil),                              // 3: google.cloud.dataplex.v1.EntryGroup
	(*EntryType)(nil),                               // 4: google.cloud.dataplex.v1.EntryType
	(*Aspect)(nil),                                  // 5: google.cloud.dataplex.v1.Aspect
	(*AspectSource)(nil),                            // 6: google.cloud.dataplex.v1.AspectSource
	(*Entry)(nil),                                   // 7: google.cloud.dataplex.v1.Entry
	(*EntrySource)(nil),                             // 8: google.cloud.dataplex.v1.EntrySource
	(*CreateEntryGroupRequest)(nil),                 // 9: google.cloud.dataplex.v1.CreateEntryGroupRequest
	(*UpdateEntryGroupRequest)(nil),                 // 10: google.cloud.dataplex.v1.UpdateEntryGroupRequest
	(*DeleteEntryGroupRequest)(nil),                 // 11: google.cloud.dataplex.v1.DeleteEntryGroupRequest
	(*ListEntryGroupsRequest)(nil),                  // 12: google.cloud.dataplex.v1.ListEntryGroupsRequest
	(*ListEntryGroupsResponse)(nil),                 // 13: google.cloud.dataplex.v1.ListEntryGroupsResponse
	(*GetEntryGroupRequest)(nil),                    // 14: google.cloud.dataplex.v1.GetEntryGroupRequest
	(*CreateEntryTypeRequest)(nil),                  // 15: google.cloud.dataplex.v1.CreateEntryTypeRequest
	(*UpdateEntryTypeRequest)(nil),                  // 16: google.cloud.dataplex.v1.UpdateEntryTypeRequest
	(*DeleteEntryTypeRequest)(nil),                  // 17: google.cloud.dataplex.v1.DeleteEntryTypeRequest
	(*ListEntryTypesRequest)(nil),                   // 18: google.cloud.dataplex.v1.ListEntryTypesRequest
	(*ListEntryTypesResponse)(nil),                  // 19: google.cloud.dataplex.v1.ListEntryTypesResponse
	(*GetEntryTypeRequest)(nil),                     // 20: google.cloud.dataplex.v1.GetEntryTypeRequest
	(*CreateAspectTypeRequest)(nil),                 // 21: google.cloud.dataplex.v1.CreateAspectTypeRequest
	(*UpdateAspectTypeRequest)(nil),                 // 22: google.cloud.dataplex.v1.UpdateAspectTypeRequest
	(*DeleteAspectTypeRequest)(nil),                 // 23: google.cloud.dataplex.v1.DeleteAspectTypeRequest
	(*ListAspectTypesRequest)(nil),                  // 24: google.cloud.dataplex.v1.ListAspectTypesRequest
	(*ListAspectTypesResponse)(nil),                 // 25: google.cloud.dataplex.v1.ListAspectTypesResponse
	(*GetAspectTypeRequest)(nil),                    // 26: google.cloud.dataplex.v1.GetAspectTypeRequest
	(*CreateEntryRequest)(nil),                      // 27: google.cloud.dataplex.v1.CreateEntryRequest
	(*UpdateEntryRequest)(nil),                      // 28: google.cloud.dataplex.v1.UpdateEntryRequest
	(*DeleteEntryRequest)(nil),                      // 29: google.cloud.dataplex.v1.DeleteEntryRequest
	(*ListEntriesRequest)(nil),                      // 30: google.cloud.dataplex.v1.ListEntriesRequest
	(*ListEntriesResponse)(nil),                     // 31: google.cloud.dataplex.v1.ListEntriesResponse
	(*GetEntryRequest)(nil),                         // 32: google.cloud.dataplex.v1.GetEntryRequest
	(*LookupEntryRequest)(nil),                      // 33: google.cloud.dataplex.v1.LookupEntryRequest
	(*SearchEntriesRequest)(nil),                    // 34: google.cloud.dataplex.v1.SearchEntriesRequest
	(*SearchEntriesResult)(nil),                     // 35: google.cloud.dataplex.v1.SearchEntriesResult
	(*SearchEntriesResponse)(nil),                   // 36: google.cloud.dataplex.v1.SearchEntriesResponse
	(*AspectType_Authorization)(nil),                // 37: google.cloud.dataplex.v1.AspectType.Authorization
	(*AspectType_MetadataTemplate)(nil),             // 38: google.cloud.dataplex.v1.AspectType.MetadataTemplate
	nil,                                             // 39: google.cloud.dataplex.v1.AspectType.LabelsEntry
	(*AspectType_MetadataTemplate_EnumValue)(nil),   // 40: google.cloud.dataplex.v1.AspectType.MetadataTemplate.EnumValue
	(*AspectType_MetadataTemplate_Constraints)(nil), // 41: google.cloud.dataplex.v1.AspectType.MetadataTemplate.Constraints
	(*AspectType_MetadataTemplate_Annotations)(nil), // 42: google.cloud.dataplex.v1.AspectType.MetadataTemplate.Annotations
	nil,                                  // 43: google.cloud.dataplex.v1.EntryGroup.LabelsEntry
	(*EntryType_AspectInfo)(nil),         // 44: google.cloud.dataplex.v1.EntryType.AspectInfo
	(*EntryType_Authorization)(nil),      // 45: google.cloud.dataplex.v1.EntryType.Authorization
	nil,                                  // 46: google.cloud.dataplex.v1.EntryType.LabelsEntry
	nil,                                  // 47: google.cloud.dataplex.v1.Entry.AspectsEntry
	(*EntrySource_Ancestor)(nil),         // 48: google.cloud.dataplex.v1.EntrySource.Ancestor
	nil,                                  // 49: google.cloud.dataplex.v1.EntrySource.LabelsEntry
	(*SearchEntriesResult_Snippets)(nil), // 50: google.cloud.dataplex.v1.SearchEntriesResult.Snippets
	(*timestamppb.Timestamp)(nil),        // 51: google.protobuf.Timestamp
	(*structpb.Struct)(nil),              // 52: google.protobuf.Struct
	(*fieldmaskpb.FieldMask)(nil),        // 53: google.protobuf.FieldMask
	(*longrunningpb.Operation)(nil),      // 54: google.longrunning.Operation
}
var file_google_cloud_dataplex_v1_catalog_proto_depIdxs = []int32{
	51, // 0: google.cloud.dataplex.v1.AspectType.create_time:type_name -> google.protobuf.Timestamp
	51, // 1: google.cloud.dataplex.v1.AspectType.update_time:type_name -> google.protobuf.Timestamp
	39, // 2: google.cloud.dataplex.v1.AspectType.labels:type_name -> google.cloud.dataplex.v1.AspectType.LabelsEntry
	37, // 3: google.cloud.dataplex.v1.AspectType.authorization:type_name -> google.cloud.dataplex.v1.AspectType.Authorization
	38, // 4: google.cloud.dataplex.v1.AspectType.metadata_template:type_name -> google.cloud.dataplex.v1.AspectType.MetadataTemplate
	1,  // 5: google.cloud.dataplex.v1.AspectType.transfer_status:type_name -> google.cloud.dataplex.v1.TransferStatus
	51, // 6: google.cloud.dataplex.v1.EntryGroup.create_time:type_name -> google.protobuf.Timestamp
	51, // 7: google.cloud.dataplex.v1.EntryGroup.update_time:type_name -> google.protobuf.Timestamp
	43, // 8: google.cloud.dataplex.v1.EntryGroup.labels:type_name -> google.cloud.dataplex.v1.EntryGroup.LabelsEntry
	1,  // 9: google.cloud.dataplex.v1.EntryGroup.transfer_status:type_name -> google.cloud.dataplex.v1.TransferStatus
	51, // 10: google.cloud.dataplex.v1.EntryType.create_time:type_name -> google.protobuf.Timestamp
	51, // 11: google.cloud.dataplex.v1.EntryType.update_time:type_name -> google.protobuf.Timestamp
	46, // 12: google.cloud.dataplex.v1.EntryType.labels:type_name -> google.cloud.dataplex.v1.EntryType.LabelsEntry
	44, // 13: google.cloud.dataplex.v1.EntryType.required_aspects:type_name -> google.cloud.dataplex.v1.EntryType.AspectInfo
	45, // 14: google.cloud.dataplex.v1.EntryType.authorization:type_name -> google.cloud.dataplex.v1.EntryType.Authorization
	51, // 15: google.cloud.dataplex.v1.Aspect.create_time:type_name -> google.protobuf.Timestamp
	51, // 16: google.cloud.dataplex.v1.Aspect.update_time:type_name -> google.protobuf.Timestamp
	52, // 17: google.cloud.dataplex.v1.Aspect.data:type_name -> google.protobuf.Struct
	6,  // 18: google.cloud.dataplex.v1.Aspect.aspect_source:type_name -> google.cloud.dataplex.v1.AspectSource
	51, // 19: google.cloud.dataplex.v1.AspectSource.create_time:type_name -> google.protobuf.Timestamp
	51, // 20: google.cloud.dataplex.v1.AspectSource.update_time:type_name -> google.protobuf.Timestamp
	51, // 21: google.cloud.dataplex.v1.Entry.create_time:type_name -> google.protobuf.Timestamp
	51, // 22: google.cloud.dataplex.v1.Entry.update_time:type_name -> google.protobuf.Timestamp
	47, // 23: google.cloud.dataplex.v1.Entry.aspects:type_name -> google.cloud.dataplex.v1.Entry.AspectsEntry
	8,  // 24: google.cloud.dataplex.v1.Entry.entry_source:type_name -> google.cloud.dataplex.v1.EntrySource
	49, // 25: google.cloud.dataplex.v1.EntrySource.labels:type_name -> google.cloud.dataplex.v1.EntrySource.LabelsEntry
	48, // 26: google.cloud.dataplex.v1.EntrySource.ancestors:type_name -> google.cloud.dataplex.v1.EntrySource.Ancestor
	51, // 27: google.cloud.dataplex.v1.EntrySource.create_time:type_name -> google.protobuf.Timestamp
	51, // 28: google.cloud.dataplex.v1.EntrySource.update_time:type_name -> google.protobuf.Timestamp
	3,  // 29: google.cloud.dataplex.v1.CreateEntryGroupRequest.entry_group:type_name -> google.cloud.dataplex.v1.EntryGroup
	3,  // 30: google.cloud.dataplex.v1.UpdateEntryGroupRequest.entry_group:type_name -> google.cloud.dataplex.v1.EntryGroup
	53, // 31: google.cloud.dataplex.v1.UpdateEntryGroupRequest.update_mask:type_name -> google.protobuf.FieldMask
	3,  // 32: google.cloud.dataplex.v1.ListEntryGroupsResponse.entry_groups:type_name -> google.cloud.dataplex.v1.EntryGroup
	4,  // 33: google.cloud.dataplex.v1.CreateEntryTypeRequest.entry_type:type_name -> google.cloud.dataplex.v1.EntryType
	4,  // 34: google.cloud.dataplex.v1.UpdateEntryTypeRequest.entry_type:type_name -> google.cloud.dataplex.v1.EntryType
	53, // 35: google.cloud.dataplex.v1.UpdateEntryTypeRequest.update_mask:type_name -> google.protobuf.FieldMask
	4,  // 36: google.cloud.dataplex.v1.ListEntryTypesResponse.entry_types:type_name -> google.cloud.dataplex.v1.EntryType
	2,  // 37: google.cloud.dataplex.v1.CreateAspectTypeRequest.aspect_type:type_name -> google.cloud.dataplex.v1.AspectType
	2,  // 38: google.cloud.dataplex.v1.UpdateAspectTypeRequest.aspect_type:type_name -> google.cloud.dataplex.v1.AspectType
	53, // 39: google.cloud.dataplex.v1.UpdateAspectTypeRequest.update_mask:type_name -> google.protobuf.FieldMask
	2,  // 40: google.cloud.dataplex.v1.ListAspectTypesResponse.aspect_types:type_name -> google.cloud.dataplex.v1.AspectType
	7,  // 41: google.cloud.dataplex.v1.CreateEntryRequest.entry:type_name -> google.cloud.dataplex.v1.Entry
	7,  // 42: google.cloud.dataplex.v1.UpdateEntryRequest.entry:type_name -> google.cloud.dataplex.v1.Entry
	53, // 43: google.cloud.dataplex.v1.UpdateEntryRequest.update_mask:type_name -> google.protobuf.FieldMask
	7,  // 44: google.cloud.dataplex.v1.ListEntriesResponse.entries:type_name -> google.cloud.dataplex.v1.Entry
	0,  // 45: google.cloud.dataplex.v1.GetEntryRequest.view:type_name -> google.cloud.dataplex.v1.EntryView
	0,  // 46: google.cloud.dataplex.v1.LookupEntryRequest.view:type_name -> google.cloud.dataplex.v1.EntryView
	7,  // 47: google.cloud.dataplex.v1.SearchEntriesResult.dataplex_entry:type_name -> google.cloud.dataplex.v1.Entry
	50, // 48: google.cloud.dataplex.v1.SearchEntriesResult.snippets:type_name -> google.cloud.dataplex.v1.SearchEntriesResult.Snippets
	35, // 49: google.cloud.dataplex.v1.SearchEntriesResponse.results:type_name -> google.cloud.dataplex.v1.SearchEntriesResult
	38, // 50: google.cloud.dataplex.v1.AspectType.MetadataTemplate.record_fields:type_name -> google.cloud.dataplex.v1.AspectType.MetadataTemplate
	40, // 51: google.cloud.dataplex.v1.AspectType.MetadataTemplate.enum_values:type_name -> google.cloud.dataplex.v1.AspectType.MetadataTemplate.EnumValue
	38, // 52: google.cloud.dataplex.v1.AspectType.MetadataTemplate.map_items:type_name -> google.cloud.dataplex.v1.AspectType.MetadataTemplate
	38, // 53: google.cloud.dataplex.v1.AspectType.MetadataTemplate.array_items:type_name -> google.cloud.dataplex.v1.AspectType.MetadataTemplate
	41, // 54: google.cloud.dataplex.v1.AspectType.MetadataTemplate.constraints:type_name -> google.cloud.dataplex.v1.AspectType.MetadataTemplate.Constraints
	42, // 55: google.cloud.dataplex.v1.AspectType.MetadataTemplate.annotations:type_name -> google.cloud.dataplex.v1.AspectType.MetadataTemplate.Annotations
	5,  // 56: google.cloud.dataplex.v1.Entry.AspectsEntry.value:type_name -> google.cloud.dataplex.v1.Aspect
	7,  // 57: google.cloud.dataplex.v1.SearchEntriesResult.Snippets.dataplex_entry:type_name -> google.cloud.dataplex.v1.Entry
	15, // 58: google.cloud.dataplex.v1.CatalogService.CreateEntryType:input_type -> google.cloud.dataplex.v1.CreateEntryTypeRequest
	16, // 59: google.cloud.dataplex.v1.CatalogService.UpdateEntryType:input_type -> google.cloud.dataplex.v1.UpdateEntryTypeRequest
	17, // 60: google.cloud.dataplex.v1.CatalogService.DeleteEntryType:input_type -> google.cloud.dataplex.v1.DeleteEntryTypeRequest
	18, // 61: google.cloud.dataplex.v1.CatalogService.ListEntryTypes:input_type -> google.cloud.dataplex.v1.ListEntryTypesRequest
	20, // 62: google.cloud.dataplex.v1.CatalogService.GetEntryType:input_type -> google.cloud.dataplex.v1.GetEntryTypeRequest
	21, // 63: google.cloud.dataplex.v1.CatalogService.CreateAspectType:input_type -> google.cloud.dataplex.v1.CreateAspectTypeRequest
	22, // 64: google.cloud.dataplex.v1.CatalogService.UpdateAspectType:input_type -> google.cloud.dataplex.v1.UpdateAspectTypeRequest
	23, // 65: google.cloud.dataplex.v1.CatalogService.DeleteAspectType:input_type -> google.cloud.dataplex.v1.DeleteAspectTypeRequest
	24, // 66: google.cloud.dataplex.v1.CatalogService.ListAspectTypes:input_type -> google.cloud.dataplex.v1.ListAspectTypesRequest
	26, // 67: google.cloud.dataplex.v1.CatalogService.GetAspectType:input_type -> google.cloud.dataplex.v1.GetAspectTypeRequest
	9,  // 68: google.cloud.dataplex.v1.CatalogService.CreateEntryGroup:input_type -> google.cloud.dataplex.v1.CreateEntryGroupRequest
	10, // 69: google.cloud.dataplex.v1.CatalogService.UpdateEntryGroup:input_type -> google.cloud.dataplex.v1.UpdateEntryGroupRequest
	11, // 70: google.cloud.dataplex.v1.CatalogService.DeleteEntryGroup:input_type -> google.cloud.dataplex.v1.DeleteEntryGroupRequest
	12, // 71: google.cloud.dataplex.v1.CatalogService.ListEntryGroups:input_type -> google.cloud.dataplex.v1.ListEntryGroupsRequest
	14, // 72: google.cloud.dataplex.v1.CatalogService.GetEntryGroup:input_type -> google.cloud.dataplex.v1.GetEntryGroupRequest
	27, // 73: google.cloud.dataplex.v1.CatalogService.CreateEntry:input_type -> google.cloud.dataplex.v1.CreateEntryRequest
	28, // 74: google.cloud.dataplex.v1.CatalogService.UpdateEntry:input_type -> google.cloud.dataplex.v1.UpdateEntryRequest
	29, // 75: google.cloud.dataplex.v1.CatalogService.DeleteEntry:input_type -> google.cloud.dataplex.v1.DeleteEntryRequest
	30, // 76: google.cloud.dataplex.v1.CatalogService.ListEntries:input_type -> google.cloud.dataplex.v1.ListEntriesRequest
	32, // 77: google.cloud.dataplex.v1.CatalogService.GetEntry:input_type -> google.cloud.dataplex.v1.GetEntryRequest
	33, // 78: google.cloud.dataplex.v1.CatalogService.LookupEntry:input_type -> google.cloud.dataplex.v1.LookupEntryRequest
	34, // 79: google.cloud.dataplex.v1.CatalogService.SearchEntries:input_type -> google.cloud.dataplex.v1.SearchEntriesRequest
	54, // 80: google.cloud.dataplex.v1.CatalogService.CreateEntryType:output_type -> google.longrunning.Operation
	54, // 81: google.cloud.dataplex.v1.CatalogService.UpdateEntryType:output_type -> google.longrunning.Operation
	54, // 82: google.cloud.dataplex.v1.CatalogService.DeleteEntryType:output_type -> google.longrunning.Operation
	19, // 83: google.cloud.dataplex.v1.CatalogService.ListEntryTypes:output_type -> google.cloud.dataplex.v1.ListEntryTypesResponse
	4,  // 84: google.cloud.dataplex.v1.CatalogService.GetEntryType:output_type -> google.cloud.dataplex.v1.EntryType
	54, // 85: google.cloud.dataplex.v1.CatalogService.CreateAspectType:output_type -> google.longrunning.Operation
	54, // 86: google.cloud.dataplex.v1.CatalogService.UpdateAspectType:output_type -> google.longrunning.Operation
	54, // 87: google.cloud.dataplex.v1.CatalogService.DeleteAspectType:output_type -> google.longrunning.Operation
	25, // 88: google.cloud.dataplex.v1.CatalogService.ListAspectTypes:output_type -> google.cloud.dataplex.v1.ListAspectTypesResponse
	2,  // 89: google.cloud.dataplex.v1.CatalogService.GetAspectType:output_type -> google.cloud.dataplex.v1.AspectType
	54, // 90: google.cloud.dataplex.v1.CatalogService.CreateEntryGroup:output_type -> google.longrunning.Operation
	54, // 91: google.cloud.dataplex.v1.CatalogService.UpdateEntryGroup:output_type -> google.longrunning.Operation
	54, // 92: google.cloud.dataplex.v1.CatalogService.DeleteEntryGroup:output_type -> google.longrunning.Operation
	13, // 93: google.cloud.dataplex.v1.CatalogService.ListEntryGroups:output_type -> google.cloud.dataplex.v1.ListEntryGroupsResponse
	3,  // 94: google.cloud.dataplex.v1.CatalogService.GetEntryGroup:output_type -> google.cloud.dataplex.v1.EntryGroup
	7,  // 95: google.cloud.dataplex.v1.CatalogService.CreateEntry:output_type -> google.cloud.dataplex.v1.Entry
	7,  // 96: google.cloud.dataplex.v1.CatalogService.UpdateEntry:output_type -> google.cloud.dataplex.v1.Entry
	7,  // 97: google.cloud.dataplex.v1.CatalogService.DeleteEntry:output_type -> google.cloud.dataplex.v1.Entry
	31, // 98: google.cloud.dataplex.v1.CatalogService.ListEntries:output_type -> google.cloud.dataplex.v1.ListEntriesResponse
	7,  // 99: google.cloud.dataplex.v1.CatalogService.GetEntry:output_type -> google.cloud.dataplex.v1.Entry
	7,  // 100: google.cloud.dataplex.v1.CatalogService.LookupEntry:output_type -> google.cloud.dataplex.v1.Entry
	36, // 101: google.cloud.dataplex.v1.CatalogService.SearchEntries:output_type -> google.cloud.dataplex.v1.SearchEntriesResponse
	80, // [80:102] is the sub-list for method output_type
	58, // [58:80] is the sub-list for method input_type
	58, // [58:58] is the sub-list for extension type_name
	58, // [58:58] is the sub-list for extension extendee
	0,  // [0:58] is the sub-list for field type_name
}

func init() { file_google_cloud_dataplex_v1_catalog_proto_init() }
func file_google_cloud_dataplex_v1_catalog_proto_init() {
	if File_google_cloud_dataplex_v1_catalog_proto != nil {
		return
	}
	file_google_cloud_dataplex_v1_service_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AspectType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntryGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntryType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Aspect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AspectSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Entry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntrySource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateEntryGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateEntryGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteEntryGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEntryGroupsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEntryGroupsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEntryGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateEntryTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateEntryTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteEntryTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEntryTypesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEntryTypesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEntryTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAspectTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAspectTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAspectTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAspectTypesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAspectTypesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAspectTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateEntryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateEntryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteEntryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEntriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEntriesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEntryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LookupEntryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchEntriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchEntriesResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchEntriesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AspectType_Authorization); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AspectType_MetadataTemplate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AspectType_MetadataTemplate_EnumValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AspectType_MetadataTemplate_Constraints); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AspectType_MetadataTemplate_Annotations); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntryType_AspectInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntryType_Authorization); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntrySource_Ancestor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_catalog_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchEntriesResult_Snippets); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataplex_v1_catalog_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   49,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dataplex_v1_catalog_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataplex_v1_catalog_proto_depIdxs,
		EnumInfos:         file_google_cloud_dataplex_v1_catalog_proto_enumTypes,
		MessageInfos:      file_google_cloud_dataplex_v1_catalog_proto_msgTypes,
	}.Build()
	File_google_cloud_dataplex_v1_catalog_proto = out.File
	file_google_cloud_dataplex_v1_catalog_proto_rawDesc = nil
	file_google_cloud_dataplex_v1_catalog_proto_goTypes = nil
	file_google_cloud_dataplex_v1_catalog_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CatalogServiceClient is the client API for CatalogService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CatalogServiceClient interface {
	// Creates an EntryType
	CreateEntryType(ctx context.Context, in *CreateEntryTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a EntryType resource.
	UpdateEntryType(ctx context.Context, in *UpdateEntryTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a EntryType resource.
	DeleteEntryType(ctx context.Context, in *DeleteEntryTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists EntryType resources in a project and location.
	ListEntryTypes(ctx context.Context, in *ListEntryTypesRequest, opts ...grpc.CallOption) (*ListEntryTypesResponse, error)
	// Retrieves a EntryType resource.
	GetEntryType(ctx context.Context, in *GetEntryTypeRequest, opts ...grpc.CallOption) (*EntryType, error)
	// Creates an AspectType
	CreateAspectType(ctx context.Context, in *CreateAspectTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a AspectType resource.
	UpdateAspectType(ctx context.Context, in *UpdateAspectTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a AspectType resource.
	DeleteAspectType(ctx context.Context, in *DeleteAspectTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists AspectType resources in a project and location.
	ListAspectTypes(ctx context.Context, in *ListAspectTypesRequest, opts ...grpc.CallOption) (*ListAspectTypesResponse, error)
	// Retrieves a AspectType resource.
	GetAspectType(ctx context.Context, in *GetAspectTypeRequest, opts ...grpc.CallOption) (*AspectType, error)
	// Creates an EntryGroup
	CreateEntryGroup(ctx context.Context, in *CreateEntryGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a EntryGroup resource.
	UpdateEntryGroup(ctx context.Context, in *UpdateEntryGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a EntryGroup resource.
	DeleteEntryGroup(ctx context.Context, in *DeleteEntryGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists EntryGroup resources in a project and location.
	ListEntryGroups(ctx context.Context, in *ListEntryGroupsRequest, opts ...grpc.CallOption) (*ListEntryGroupsResponse, error)
	// Retrieves a EntryGroup resource.
	GetEntryGroup(ctx context.Context, in *GetEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error)
	// Creates an Entry.
	CreateEntry(ctx context.Context, in *CreateEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Updates an Entry.
	UpdateEntry(ctx context.Context, in *UpdateEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Deletes an Entry.
	DeleteEntry(ctx context.Context, in *DeleteEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Lists entries within an entry group.
	ListEntries(ctx context.Context, in *ListEntriesRequest, opts ...grpc.CallOption) (*ListEntriesResponse, error)
	// Gets a single entry.
	GetEntry(ctx context.Context, in *GetEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Looks up a single entry.
	LookupEntry(ctx context.Context, in *LookupEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Searches for entries matching given query and scope.
	SearchEntries(ctx context.Context, in *SearchEntriesRequest, opts ...grpc.CallOption) (*SearchEntriesResponse, error)
}

type catalogServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCatalogServiceClient(cc grpc.ClientConnInterface) CatalogServiceClient {
	return &catalogServiceClient{cc}
}

func (c *catalogServiceClient) CreateEntryType(ctx context.Context, in *CreateEntryTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.CatalogService/CreateEntryType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) UpdateEntryType(ctx context.Context, in *UpdateEntryTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.CatalogService/UpdateEntryType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) DeleteEntryType(ctx context.Context, in *DeleteEntryTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.CatalogService/DeleteEntryType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) ListEntryTypes(ctx context.Context, in *ListEntryTypesRequest, opts ...grpc.CallOption) (*ListEntryTypesResponse, error) {
	out := new(ListEntryTypesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.CatalogService/ListEntryTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) GetEntryType(ctx context.Context, in *GetEntryTypeRequest, opts ...grpc.CallOption) (*EntryType, error) {
	out := new(EntryType)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.CatalogService/GetEntryType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) CreateAspectType(ctx context.Context, in *CreateAspectTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.CatalogService/CreateAspectType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) UpdateAspectType(ctx context.Context, in *UpdateAspectTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.CatalogService/UpdateAspectType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) DeleteAspectType(ctx context.Context, in *DeleteAspectTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.CatalogService/DeleteAspectType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) ListAspectTypes(ctx context.Context, in *ListAspectTypesRequest, opts ...grpc.CallOption) (*ListAspectTypesResponse, error) {
	out := new(ListAspectTypesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.CatalogService/ListAspectTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) GetAspectType(ctx context.Context, in *GetAspectTypeRequest, opts ...grpc.CallOption) (*AspectType, error) {
	out := new(AspectType)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.CatalogService/GetAspectType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) CreateEntryGroup(ctx context.Context, in *CreateEntryGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.CatalogService/CreateEntryGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) UpdateEntryGroup(ctx context.Context, in *UpdateEntryGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.CatalogService/UpdateEntryGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) DeleteEntryGroup(ctx context.Context, in *DeleteEntryGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.CatalogService/DeleteEntryGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) ListEntryGroups(ctx context.Context, in *ListEntryGroupsRequest, opts ...grpc.CallOption) (*ListEntryGroupsResponse, error) {
	out := new(ListEntryGroupsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.CatalogService/ListEntryGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) GetEntryGroup(ctx context.Context, in *GetEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error) {
	out := new(EntryGroup)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.CatalogService/GetEntryGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) CreateEntry(ctx context.Context, in *CreateEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.CatalogService/CreateEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) UpdateEntry(ctx context.Context, in *UpdateEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.CatalogService/UpdateEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) DeleteEntry(ctx context.Context, in *DeleteEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.CatalogService/DeleteEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) ListEntries(ctx context.Context, in *ListEntriesRequest, opts ...grpc.CallOption) (*ListEntriesResponse, error) {
	out := new(ListEntriesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.CatalogService/ListEntries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) GetEntry(ctx context.Context, in *GetEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.CatalogService/GetEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) LookupEntry(ctx context.Context, in *LookupEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.CatalogService/LookupEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) SearchEntries(ctx context.Context, in *SearchEntriesRequest, opts ...grpc.CallOption) (*SearchEntriesResponse, error) {
	out := new(SearchEntriesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.CatalogService/SearchEntries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CatalogServiceServer is the server API for CatalogService service.
type CatalogServiceServer interface {
	// Creates an EntryType
	CreateEntryType(context.Context, *CreateEntryTypeRequest) (*longrunningpb.Operation, error)
	// Updates a EntryType resource.
	UpdateEntryType(context.Context, *UpdateEntryTypeRequest) (*longrunningpb.Operation, error)
	// Deletes a EntryType resource.
	DeleteEntryType(context.Context, *DeleteEntryTypeRequest) (*longrunningpb.Operation, error)
	// Lists EntryType resources in a project and location.
	ListEntryTypes(context.Context, *ListEntryTypesRequest) (*ListEntryTypesResponse, error)
	// Retrieves a EntryType resource.
	GetEntryType(context.Context, *GetEntryTypeRequest) (*EntryType, error)
	// Creates an AspectType
	CreateAspectType(context.Context, *CreateAspectTypeRequest) (*longrunningpb.Operation, error)
	// Updates a AspectType resource.
	UpdateAspectType(context.Context, *UpdateAspectTypeRequest) (*longrunningpb.Operation, error)
	// Deletes a AspectType resource.
	DeleteAspectType(context.Context, *DeleteAspectTypeRequest) (*longrunningpb.Operation, error)
	// Lists AspectType resources in a project and location.
	ListAspectTypes(context.Context, *ListAspectTypesRequest) (*ListAspectTypesResponse, error)
	// Retrieves a AspectType resource.
	GetAspectType(context.Context, *GetAspectTypeRequest) (*AspectType, error)
	// Creates an EntryGroup
	CreateEntryGroup(context.Context, *CreateEntryGroupRequest) (*longrunningpb.Operation, error)
	// Updates a EntryGroup resource.
	UpdateEntryGroup(context.Context, *UpdateEntryGroupRequest) (*longrunningpb.Operation, error)
	// Deletes a EntryGroup resource.
	DeleteEntryGroup(context.Context, *DeleteEntryGroupRequest) (*longrunningpb.Operation, error)
	// Lists EntryGroup resources in a project and location.
	ListEntryGroups(context.Context, *ListEntryGroupsRequest) (*ListEntryGroupsResponse, error)
	// Retrieves a EntryGroup resource.
	GetEntryGroup(context.Context, *GetEntryGroupRequest) (*EntryGroup, error)
	// Creates an Entry.
	CreateEntry(context.Context, *CreateEntryRequest) (*Entry, error)
	// Updates an Entry.
	UpdateEntry(context.Context, *UpdateEntryRequest) (*Entry, error)
	// Deletes an Entry.
	DeleteEntry(context.Context, *DeleteEntryRequest) (*Entry, error)
	// Lists entries within an entry group.
	ListEntries(context.Context, *ListEntriesRequest) (*ListEntriesResponse, error)
	// Gets a single entry.
	GetEntry(context.Context, *GetEntryRequest) (*Entry, error)
	// Looks up a single entry.
	LookupEntry(context.Context, *LookupEntryRequest) (*Entry, error)
	// Searches for entries matching given query and scope.
	SearchEntries(context.Context, *SearchEntriesRequest) (*SearchEntriesResponse, error)
}

// UnimplementedCatalogServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCatalogServiceServer struct {
}

func (*UnimplementedCatalogServiceServer) CreateEntryType(context.Context, *CreateEntryTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntryType not implemented")
}
func (*UnimplementedCatalogServiceServer) UpdateEntryType(context.Context, *UpdateEntryTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntryType not implemented")
}
func (*UnimplementedCatalogServiceServer) DeleteEntryType(context.Context, *DeleteEntryTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntryType not implemented")
}
func (*UnimplementedCatalogServiceServer) ListEntryTypes(context.Context, *ListEntryTypesRequest) (*ListEntryTypesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntryTypes not implemented")
}
func (*UnimplementedCatalogServiceServer) GetEntryType(context.Context, *GetEntryTypeRequest) (*EntryType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntryType not implemented")
}
func (*UnimplementedCatalogServiceServer) CreateAspectType(context.Context, *CreateAspectTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAspectType not implemented")
}
func (*UnimplementedCatalogServiceServer) UpdateAspectType(context.Context, *UpdateAspectTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAspectType not implemented")
}
func (*UnimplementedCatalogServiceServer) DeleteAspectType(context.Context, *DeleteAspectTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAspectType not implemented")
}
func (*UnimplementedCatalogServiceServer) ListAspectTypes(context.Context, *ListAspectTypesRequest) (*ListAspectTypesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAspectTypes not implemented")
}
func (*UnimplementedCatalogServiceServer) GetAspectType(context.Context, *GetAspectTypeRequest) (*AspectType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAspectType not implemented")
}
func (*UnimplementedCatalogServiceServer) CreateEntryGroup(context.Context, *CreateEntryGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntryGroup not implemented")
}
func (*UnimplementedCatalogServiceServer) UpdateEntryGroup(context.Context, *UpdateEntryGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntryGroup not implemented")
}
func (*UnimplementedCatalogServiceServer) DeleteEntryGroup(context.Context, *DeleteEntryGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntryGroup not implemented")
}
func (*UnimplementedCatalogServiceServer) ListEntryGroups(context.Context, *ListEntryGroupsRequest) (*ListEntryGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntryGroups not implemented")
}
func (*UnimplementedCatalogServiceServer) GetEntryGroup(context.Context, *GetEntryGroupRequest) (*EntryGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntryGroup not implemented")
}
func (*UnimplementedCatalogServiceServer) CreateEntry(context.Context, *CreateEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntry not implemented")
}
func (*UnimplementedCatalogServiceServer) UpdateEntry(context.Context, *UpdateEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntry not implemented")
}
func (*UnimplementedCatalogServiceServer) DeleteEntry(context.Context, *DeleteEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntry not implemented")
}
func (*UnimplementedCatalogServiceServer) ListEntries(context.Context, *ListEntriesRequest) (*ListEntriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntries not implemented")
}
func (*UnimplementedCatalogServiceServer) GetEntry(context.Context, *GetEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntry not implemented")
}
func (*UnimplementedCatalogServiceServer) LookupEntry(context.Context, *LookupEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupEntry not implemented")
}
func (*UnimplementedCatalogServiceServer) SearchEntries(context.Context, *SearchEntriesRequest) (*SearchEntriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchEntries not implemented")
}

func RegisterCatalogServiceServer(s *grpc.Server, srv CatalogServiceServer) {
	s.RegisterService(&_CatalogService_serviceDesc, srv)
}

func _CatalogService_CreateEntryType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntryTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).CreateEntryType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.CatalogService/CreateEntryType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).CreateEntryType(ctx, req.(*CreateEntryTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_UpdateEntryType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntryTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).UpdateEntryType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.CatalogService/UpdateEntryType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).UpdateEntryType(ctx, req.(*UpdateEntryTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_DeleteEntryType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntryTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).DeleteEntryType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.CatalogService/DeleteEntryType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).DeleteEntryType(ctx, req.(*DeleteEntryTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_ListEntryTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntryTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).ListEntryTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.CatalogService/ListEntryTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).ListEntryTypes(ctx, req.(*ListEntryTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_GetEntryType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntryTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).GetEntryType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.CatalogService/GetEntryType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).GetEntryType(ctx, req.(*GetEntryTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_CreateAspectType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAspectTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).CreateAspectType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.CatalogService/CreateAspectType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).CreateAspectType(ctx, req.(*CreateAspectTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_UpdateAspectType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAspectTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).UpdateAspectType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.CatalogService/UpdateAspectType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).UpdateAspectType(ctx, req.(*UpdateAspectTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_DeleteAspectType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAspectTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).DeleteAspectType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.CatalogService/DeleteAspectType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).DeleteAspectType(ctx, req.(*DeleteAspectTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_ListAspectTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAspectTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).ListAspectTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.CatalogService/ListAspectTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).ListAspectTypes(ctx, req.(*ListAspectTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_GetAspectType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAspectTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).GetAspectType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.CatalogService/GetAspectType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).GetAspectType(ctx, req.(*GetAspectTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_CreateEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).CreateEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.CatalogService/CreateEntryGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).CreateEntryGroup(ctx, req.(*CreateEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_UpdateEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).UpdateEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.CatalogService/UpdateEntryGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).UpdateEntryGroup(ctx, req.(*UpdateEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_DeleteEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).DeleteEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.CatalogService/DeleteEntryGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).DeleteEntryGroup(ctx, req.(*DeleteEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_ListEntryGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntryGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).ListEntryGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.CatalogService/ListEntryGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).ListEntryGroups(ctx, req.(*ListEntryGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_GetEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).GetEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.CatalogService/GetEntryGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).GetEntryGroup(ctx, req.(*GetEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_CreateEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).CreateEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.CatalogService/CreateEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).CreateEntry(ctx, req.(*CreateEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_UpdateEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).UpdateEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.CatalogService/UpdateEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).UpdateEntry(ctx, req.(*UpdateEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_DeleteEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).DeleteEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.CatalogService/DeleteEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).DeleteEntry(ctx, req.(*DeleteEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_ListEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).ListEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.CatalogService/ListEntries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).ListEntries(ctx, req.(*ListEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_GetEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).GetEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.CatalogService/GetEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).GetEntry(ctx, req.(*GetEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_LookupEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).LookupEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.CatalogService/LookupEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).LookupEntry(ctx, req.(*LookupEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_SearchEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).SearchEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.CatalogService/SearchEntries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).SearchEntries(ctx, req.(*SearchEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CatalogService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataplex.v1.CatalogService",
	HandlerType: (*CatalogServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateEntryType",
			Handler:    _CatalogService_CreateEntryType_Handler,
		},
		{
			MethodName: "UpdateEntryType",
			Handler:    _CatalogService_UpdateEntryType_Handler,
		},
		{
			MethodName: "DeleteEntryType",
			Handler:    _CatalogService_DeleteEntryType_Handler,
		},
		{
			MethodName: "ListEntryTypes",
			Handler:    _CatalogService_ListEntryTypes_Handler,
		},
		{
			MethodName: "GetEntryType",
			Handler:    _CatalogService_GetEntryType_Handler,
		},
		{
			MethodName: "CreateAspectType",
			Handler:    _CatalogService_CreateAspectType_Handler,
		},
		{
			MethodName: "UpdateAspectType",
			Handler:    _CatalogService_UpdateAspectType_Handler,
		},
		{
			MethodName: "DeleteAspectType",
			Handler:    _CatalogService_DeleteAspectType_Handler,
		},
		{
			MethodName: "ListAspectTypes",
			Handler:    _CatalogService_ListAspectTypes_Handler,
		},
		{
			MethodName: "GetAspectType",
			Handler:    _CatalogService_GetAspectType_Handler,
		},
		{
			MethodName: "CreateEntryGroup",
			Handler:    _CatalogService_CreateEntryGroup_Handler,
		},
		{
			MethodName: "UpdateEntryGroup",
			Handler:    _CatalogService_UpdateEntryGroup_Handler,
		},
		{
			MethodName: "DeleteEntryGroup",
			Handler:    _CatalogService_DeleteEntryGroup_Handler,
		},
		{
			MethodName: "ListEntryGroups",
			Handler:    _CatalogService_ListEntryGroups_Handler,
		},
		{
			MethodName: "GetEntryGroup",
			Handler:    _CatalogService_GetEntryGroup_Handler,
		},
		{
			MethodName: "CreateEntry",
			Handler:    _CatalogService_CreateEntry_Handler,
		},
		{
			MethodName: "UpdateEntry",
			Handler:    _CatalogService_UpdateEntry_Handler,
		},
		{
			MethodName: "DeleteEntry",
			Handler:    _CatalogService_DeleteEntry_Handler,
		},
		{
			MethodName: "ListEntries",
			Handler:    _CatalogService_ListEntries_Handler,
		},
		{
			MethodName: "GetEntry",
			Handler:    _CatalogService_GetEntry_Handler,
		},
		{
			MethodName: "LookupEntry",
			Handler:    _CatalogService_LookupEntry_Handler,
		},
		{
			MethodName: "SearchEntries",
			Handler:    _CatalogService_SearchEntries_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataplex/v1/catalog.proto",
}
