// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dataplex/v1/service.proto

package dataplexpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DataplexService_CreateLake_FullMethodName        = "/google.cloud.dataplex.v1.DataplexService/CreateLake"
	DataplexService_UpdateLake_FullMethodName        = "/google.cloud.dataplex.v1.DataplexService/UpdateLake"
	DataplexService_DeleteLake_FullMethodName        = "/google.cloud.dataplex.v1.DataplexService/DeleteLake"
	DataplexService_ListLakes_FullMethodName         = "/google.cloud.dataplex.v1.DataplexService/ListLakes"
	DataplexService_GetLake_FullMethodName           = "/google.cloud.dataplex.v1.DataplexService/GetLake"
	DataplexService_ListLakeActions_FullMethodName   = "/google.cloud.dataplex.v1.DataplexService/ListLakeActions"
	DataplexService_CreateZone_FullMethodName        = "/google.cloud.dataplex.v1.DataplexService/CreateZone"
	DataplexService_UpdateZone_FullMethodName        = "/google.cloud.dataplex.v1.DataplexService/UpdateZone"
	DataplexService_DeleteZone_FullMethodName        = "/google.cloud.dataplex.v1.DataplexService/DeleteZone"
	DataplexService_ListZones_FullMethodName         = "/google.cloud.dataplex.v1.DataplexService/ListZones"
	DataplexService_GetZone_FullMethodName           = "/google.cloud.dataplex.v1.DataplexService/GetZone"
	DataplexService_ListZoneActions_FullMethodName   = "/google.cloud.dataplex.v1.DataplexService/ListZoneActions"
	DataplexService_CreateAsset_FullMethodName       = "/google.cloud.dataplex.v1.DataplexService/CreateAsset"
	DataplexService_UpdateAsset_FullMethodName       = "/google.cloud.dataplex.v1.DataplexService/UpdateAsset"
	DataplexService_DeleteAsset_FullMethodName       = "/google.cloud.dataplex.v1.DataplexService/DeleteAsset"
	DataplexService_ListAssets_FullMethodName        = "/google.cloud.dataplex.v1.DataplexService/ListAssets"
	DataplexService_GetAsset_FullMethodName          = "/google.cloud.dataplex.v1.DataplexService/GetAsset"
	DataplexService_ListAssetActions_FullMethodName  = "/google.cloud.dataplex.v1.DataplexService/ListAssetActions"
	DataplexService_CreateTask_FullMethodName        = "/google.cloud.dataplex.v1.DataplexService/CreateTask"
	DataplexService_UpdateTask_FullMethodName        = "/google.cloud.dataplex.v1.DataplexService/UpdateTask"
	DataplexService_DeleteTask_FullMethodName        = "/google.cloud.dataplex.v1.DataplexService/DeleteTask"
	DataplexService_ListTasks_FullMethodName         = "/google.cloud.dataplex.v1.DataplexService/ListTasks"
	DataplexService_GetTask_FullMethodName           = "/google.cloud.dataplex.v1.DataplexService/GetTask"
	DataplexService_ListJobs_FullMethodName          = "/google.cloud.dataplex.v1.DataplexService/ListJobs"
	DataplexService_RunTask_FullMethodName           = "/google.cloud.dataplex.v1.DataplexService/RunTask"
	DataplexService_GetJob_FullMethodName            = "/google.cloud.dataplex.v1.DataplexService/GetJob"
	DataplexService_CancelJob_FullMethodName         = "/google.cloud.dataplex.v1.DataplexService/CancelJob"
	DataplexService_CreateEnvironment_FullMethodName = "/google.cloud.dataplex.v1.DataplexService/CreateEnvironment"
	DataplexService_UpdateEnvironment_FullMethodName = "/google.cloud.dataplex.v1.DataplexService/UpdateEnvironment"
	DataplexService_DeleteEnvironment_FullMethodName = "/google.cloud.dataplex.v1.DataplexService/DeleteEnvironment"
	DataplexService_ListEnvironments_FullMethodName  = "/google.cloud.dataplex.v1.DataplexService/ListEnvironments"
	DataplexService_GetEnvironment_FullMethodName    = "/google.cloud.dataplex.v1.DataplexService/GetEnvironment"
	DataplexService_ListSessions_FullMethodName      = "/google.cloud.dataplex.v1.DataplexService/ListSessions"
)

// DataplexServiceClient is the client API for DataplexService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DataplexServiceClient interface {
	// Creates a lake resource.
	CreateLake(ctx context.Context, in *CreateLakeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a lake resource.
	UpdateLake(ctx context.Context, in *UpdateLakeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a lake resource. All zones within the lake must be deleted before
	// the lake can be deleted.
	DeleteLake(ctx context.Context, in *DeleteLakeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists lake resources in a project and location.
	ListLakes(ctx context.Context, in *ListLakesRequest, opts ...grpc.CallOption) (*ListLakesResponse, error)
	// Retrieves a lake resource.
	GetLake(ctx context.Context, in *GetLakeRequest, opts ...grpc.CallOption) (*Lake, error)
	// Lists action resources in a lake.
	ListLakeActions(ctx context.Context, in *ListLakeActionsRequest, opts ...grpc.CallOption) (*ListActionsResponse, error)
	// Creates a zone resource within a lake.
	CreateZone(ctx context.Context, in *CreateZoneRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a zone resource.
	UpdateZone(ctx context.Context, in *UpdateZoneRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a zone resource. All assets within a zone must be deleted before
	// the zone can be deleted.
	DeleteZone(ctx context.Context, in *DeleteZoneRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists zone resources in a lake.
	ListZones(ctx context.Context, in *ListZonesRequest, opts ...grpc.CallOption) (*ListZonesResponse, error)
	// Retrieves a zone resource.
	GetZone(ctx context.Context, in *GetZoneRequest, opts ...grpc.CallOption) (*Zone, error)
	// Lists action resources in a zone.
	ListZoneActions(ctx context.Context, in *ListZoneActionsRequest, opts ...grpc.CallOption) (*ListActionsResponse, error)
	// Creates an asset resource.
	CreateAsset(ctx context.Context, in *CreateAssetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an asset resource.
	UpdateAsset(ctx context.Context, in *UpdateAssetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an asset resource. The referenced storage resource is detached
	// (default) or deleted based on the associated Lifecycle policy.
	DeleteAsset(ctx context.Context, in *DeleteAssetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists asset resources in a zone.
	ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error)
	// Retrieves an asset resource.
	GetAsset(ctx context.Context, in *GetAssetRequest, opts ...grpc.CallOption) (*Asset, error)
	// Lists action resources in an asset.
	ListAssetActions(ctx context.Context, in *ListAssetActionsRequest, opts ...grpc.CallOption) (*ListActionsResponse, error)
	// Creates a task resource within a lake.
	CreateTask(ctx context.Context, in *CreateTaskRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Update the task resource.
	UpdateTask(ctx context.Context, in *UpdateTaskRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Delete the task resource.
	DeleteTask(ctx context.Context, in *DeleteTaskRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists tasks under the given lake.
	ListTasks(ctx context.Context, in *ListTasksRequest, opts ...grpc.CallOption) (*ListTasksResponse, error)
	// Get task resource.
	GetTask(ctx context.Context, in *GetTaskRequest, opts ...grpc.CallOption) (*Task, error)
	// Lists Jobs under the given task.
	ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error)
	// Run an on demand execution of a Task.
	RunTask(ctx context.Context, in *RunTaskRequest, opts ...grpc.CallOption) (*RunTaskResponse, error)
	// Get job resource.
	GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Cancel jobs running for the task resource.
	CancelJob(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Create an environment resource.
	CreateEnvironment(ctx context.Context, in *CreateEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Update the environment resource.
	UpdateEnvironment(ctx context.Context, in *UpdateEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Delete the environment resource. All the child resources must have been
	// deleted before environment deletion can be initiated.
	DeleteEnvironment(ctx context.Context, in *DeleteEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists environments under the given lake.
	ListEnvironments(ctx context.Context, in *ListEnvironmentsRequest, opts ...grpc.CallOption) (*ListEnvironmentsResponse, error)
	// Get environment resource.
	GetEnvironment(ctx context.Context, in *GetEnvironmentRequest, opts ...grpc.CallOption) (*Environment, error)
	// Lists session resources in an environment.
	ListSessions(ctx context.Context, in *ListSessionsRequest, opts ...grpc.CallOption) (*ListSessionsResponse, error)
}

type dataplexServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDataplexServiceClient(cc grpc.ClientConnInterface) DataplexServiceClient {
	return &dataplexServiceClient{cc}
}

func (c *dataplexServiceClient) CreateLake(ctx context.Context, in *CreateLakeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataplexService_CreateLake_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) UpdateLake(ctx context.Context, in *UpdateLakeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataplexService_UpdateLake_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) DeleteLake(ctx context.Context, in *DeleteLakeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataplexService_DeleteLake_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) ListLakes(ctx context.Context, in *ListLakesRequest, opts ...grpc.CallOption) (*ListLakesResponse, error) {
	out := new(ListLakesResponse)
	err := c.cc.Invoke(ctx, DataplexService_ListLakes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) GetLake(ctx context.Context, in *GetLakeRequest, opts ...grpc.CallOption) (*Lake, error) {
	out := new(Lake)
	err := c.cc.Invoke(ctx, DataplexService_GetLake_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) ListLakeActions(ctx context.Context, in *ListLakeActionsRequest, opts ...grpc.CallOption) (*ListActionsResponse, error) {
	out := new(ListActionsResponse)
	err := c.cc.Invoke(ctx, DataplexService_ListLakeActions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) CreateZone(ctx context.Context, in *CreateZoneRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataplexService_CreateZone_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) UpdateZone(ctx context.Context, in *UpdateZoneRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataplexService_UpdateZone_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) DeleteZone(ctx context.Context, in *DeleteZoneRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataplexService_DeleteZone_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) ListZones(ctx context.Context, in *ListZonesRequest, opts ...grpc.CallOption) (*ListZonesResponse, error) {
	out := new(ListZonesResponse)
	err := c.cc.Invoke(ctx, DataplexService_ListZones_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) GetZone(ctx context.Context, in *GetZoneRequest, opts ...grpc.CallOption) (*Zone, error) {
	out := new(Zone)
	err := c.cc.Invoke(ctx, DataplexService_GetZone_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) ListZoneActions(ctx context.Context, in *ListZoneActionsRequest, opts ...grpc.CallOption) (*ListActionsResponse, error) {
	out := new(ListActionsResponse)
	err := c.cc.Invoke(ctx, DataplexService_ListZoneActions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) CreateAsset(ctx context.Context, in *CreateAssetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataplexService_CreateAsset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) UpdateAsset(ctx context.Context, in *UpdateAssetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataplexService_UpdateAsset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) DeleteAsset(ctx context.Context, in *DeleteAssetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataplexService_DeleteAsset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error) {
	out := new(ListAssetsResponse)
	err := c.cc.Invoke(ctx, DataplexService_ListAssets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) GetAsset(ctx context.Context, in *GetAssetRequest, opts ...grpc.CallOption) (*Asset, error) {
	out := new(Asset)
	err := c.cc.Invoke(ctx, DataplexService_GetAsset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) ListAssetActions(ctx context.Context, in *ListAssetActionsRequest, opts ...grpc.CallOption) (*ListActionsResponse, error) {
	out := new(ListActionsResponse)
	err := c.cc.Invoke(ctx, DataplexService_ListAssetActions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) CreateTask(ctx context.Context, in *CreateTaskRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataplexService_CreateTask_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) UpdateTask(ctx context.Context, in *UpdateTaskRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataplexService_UpdateTask_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) DeleteTask(ctx context.Context, in *DeleteTaskRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataplexService_DeleteTask_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) ListTasks(ctx context.Context, in *ListTasksRequest, opts ...grpc.CallOption) (*ListTasksResponse, error) {
	out := new(ListTasksResponse)
	err := c.cc.Invoke(ctx, DataplexService_ListTasks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) GetTask(ctx context.Context, in *GetTaskRequest, opts ...grpc.CallOption) (*Task, error) {
	out := new(Task)
	err := c.cc.Invoke(ctx, DataplexService_GetTask_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error) {
	out := new(ListJobsResponse)
	err := c.cc.Invoke(ctx, DataplexService_ListJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) RunTask(ctx context.Context, in *RunTaskRequest, opts ...grpc.CallOption) (*RunTaskResponse, error) {
	out := new(RunTaskResponse)
	err := c.cc.Invoke(ctx, DataplexService_RunTask_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, DataplexService_GetJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) CancelJob(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataplexService_CancelJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) CreateEnvironment(ctx context.Context, in *CreateEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataplexService_CreateEnvironment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) UpdateEnvironment(ctx context.Context, in *UpdateEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataplexService_UpdateEnvironment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) DeleteEnvironment(ctx context.Context, in *DeleteEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataplexService_DeleteEnvironment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) ListEnvironments(ctx context.Context, in *ListEnvironmentsRequest, opts ...grpc.CallOption) (*ListEnvironmentsResponse, error) {
	out := new(ListEnvironmentsResponse)
	err := c.cc.Invoke(ctx, DataplexService_ListEnvironments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) GetEnvironment(ctx context.Context, in *GetEnvironmentRequest, opts ...grpc.CallOption) (*Environment, error) {
	out := new(Environment)
	err := c.cc.Invoke(ctx, DataplexService_GetEnvironment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataplexServiceClient) ListSessions(ctx context.Context, in *ListSessionsRequest, opts ...grpc.CallOption) (*ListSessionsResponse, error) {
	out := new(ListSessionsResponse)
	err := c.cc.Invoke(ctx, DataplexService_ListSessions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataplexServiceServer is the server API for DataplexService service.
// All implementations should embed UnimplementedDataplexServiceServer
// for forward compatibility
type DataplexServiceServer interface {
	// Creates a lake resource.
	CreateLake(context.Context, *CreateLakeRequest) (*longrunningpb.Operation, error)
	// Updates a lake resource.
	UpdateLake(context.Context, *UpdateLakeRequest) (*longrunningpb.Operation, error)
	// Deletes a lake resource. All zones within the lake must be deleted before
	// the lake can be deleted.
	DeleteLake(context.Context, *DeleteLakeRequest) (*longrunningpb.Operation, error)
	// Lists lake resources in a project and location.
	ListLakes(context.Context, *ListLakesRequest) (*ListLakesResponse, error)
	// Retrieves a lake resource.
	GetLake(context.Context, *GetLakeRequest) (*Lake, error)
	// Lists action resources in a lake.
	ListLakeActions(context.Context, *ListLakeActionsRequest) (*ListActionsResponse, error)
	// Creates a zone resource within a lake.
	CreateZone(context.Context, *CreateZoneRequest) (*longrunningpb.Operation, error)
	// Updates a zone resource.
	UpdateZone(context.Context, *UpdateZoneRequest) (*longrunningpb.Operation, error)
	// Deletes a zone resource. All assets within a zone must be deleted before
	// the zone can be deleted.
	DeleteZone(context.Context, *DeleteZoneRequest) (*longrunningpb.Operation, error)
	// Lists zone resources in a lake.
	ListZones(context.Context, *ListZonesRequest) (*ListZonesResponse, error)
	// Retrieves a zone resource.
	GetZone(context.Context, *GetZoneRequest) (*Zone, error)
	// Lists action resources in a zone.
	ListZoneActions(context.Context, *ListZoneActionsRequest) (*ListActionsResponse, error)
	// Creates an asset resource.
	CreateAsset(context.Context, *CreateAssetRequest) (*longrunningpb.Operation, error)
	// Updates an asset resource.
	UpdateAsset(context.Context, *UpdateAssetRequest) (*longrunningpb.Operation, error)
	// Deletes an asset resource. The referenced storage resource is detached
	// (default) or deleted based on the associated Lifecycle policy.
	DeleteAsset(context.Context, *DeleteAssetRequest) (*longrunningpb.Operation, error)
	// Lists asset resources in a zone.
	ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error)
	// Retrieves an asset resource.
	GetAsset(context.Context, *GetAssetRequest) (*Asset, error)
	// Lists action resources in an asset.
	ListAssetActions(context.Context, *ListAssetActionsRequest) (*ListActionsResponse, error)
	// Creates a task resource within a lake.
	CreateTask(context.Context, *CreateTaskRequest) (*longrunningpb.Operation, error)
	// Update the task resource.
	UpdateTask(context.Context, *UpdateTaskRequest) (*longrunningpb.Operation, error)
	// Delete the task resource.
	DeleteTask(context.Context, *DeleteTaskRequest) (*longrunningpb.Operation, error)
	// Lists tasks under the given lake.
	ListTasks(context.Context, *ListTasksRequest) (*ListTasksResponse, error)
	// Get task resource.
	GetTask(context.Context, *GetTaskRequest) (*Task, error)
	// Lists Jobs under the given task.
	ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error)
	// Run an on demand execution of a Task.
	RunTask(context.Context, *RunTaskRequest) (*RunTaskResponse, error)
	// Get job resource.
	GetJob(context.Context, *GetJobRequest) (*Job, error)
	// Cancel jobs running for the task resource.
	CancelJob(context.Context, *CancelJobRequest) (*emptypb.Empty, error)
	// Create an environment resource.
	CreateEnvironment(context.Context, *CreateEnvironmentRequest) (*longrunningpb.Operation, error)
	// Update the environment resource.
	UpdateEnvironment(context.Context, *UpdateEnvironmentRequest) (*longrunningpb.Operation, error)
	// Delete the environment resource. All the child resources must have been
	// deleted before environment deletion can be initiated.
	DeleteEnvironment(context.Context, *DeleteEnvironmentRequest) (*longrunningpb.Operation, error)
	// Lists environments under the given lake.
	ListEnvironments(context.Context, *ListEnvironmentsRequest) (*ListEnvironmentsResponse, error)
	// Get environment resource.
	GetEnvironment(context.Context, *GetEnvironmentRequest) (*Environment, error)
	// Lists session resources in an environment.
	ListSessions(context.Context, *ListSessionsRequest) (*ListSessionsResponse, error)
}

// UnimplementedDataplexServiceServer should be embedded to have forward compatible implementations.
type UnimplementedDataplexServiceServer struct {
}

func (UnimplementedDataplexServiceServer) CreateLake(context.Context, *CreateLakeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateLake not implemented")
}
func (UnimplementedDataplexServiceServer) UpdateLake(context.Context, *UpdateLakeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateLake not implemented")
}
func (UnimplementedDataplexServiceServer) DeleteLake(context.Context, *DeleteLakeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteLake not implemented")
}
func (UnimplementedDataplexServiceServer) ListLakes(context.Context, *ListLakesRequest) (*ListLakesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLakes not implemented")
}
func (UnimplementedDataplexServiceServer) GetLake(context.Context, *GetLakeRequest) (*Lake, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLake not implemented")
}
func (UnimplementedDataplexServiceServer) ListLakeActions(context.Context, *ListLakeActionsRequest) (*ListActionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLakeActions not implemented")
}
func (UnimplementedDataplexServiceServer) CreateZone(context.Context, *CreateZoneRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateZone not implemented")
}
func (UnimplementedDataplexServiceServer) UpdateZone(context.Context, *UpdateZoneRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateZone not implemented")
}
func (UnimplementedDataplexServiceServer) DeleteZone(context.Context, *DeleteZoneRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteZone not implemented")
}
func (UnimplementedDataplexServiceServer) ListZones(context.Context, *ListZonesRequest) (*ListZonesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListZones not implemented")
}
func (UnimplementedDataplexServiceServer) GetZone(context.Context, *GetZoneRequest) (*Zone, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetZone not implemented")
}
func (UnimplementedDataplexServiceServer) ListZoneActions(context.Context, *ListZoneActionsRequest) (*ListActionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListZoneActions not implemented")
}
func (UnimplementedDataplexServiceServer) CreateAsset(context.Context, *CreateAssetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAsset not implemented")
}
func (UnimplementedDataplexServiceServer) UpdateAsset(context.Context, *UpdateAssetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAsset not implemented")
}
func (UnimplementedDataplexServiceServer) DeleteAsset(context.Context, *DeleteAssetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAsset not implemented")
}
func (UnimplementedDataplexServiceServer) ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAssets not implemented")
}
func (UnimplementedDataplexServiceServer) GetAsset(context.Context, *GetAssetRequest) (*Asset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAsset not implemented")
}
func (UnimplementedDataplexServiceServer) ListAssetActions(context.Context, *ListAssetActionsRequest) (*ListActionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAssetActions not implemented")
}
func (UnimplementedDataplexServiceServer) CreateTask(context.Context, *CreateTaskRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTask not implemented")
}
func (UnimplementedDataplexServiceServer) UpdateTask(context.Context, *UpdateTaskRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTask not implemented")
}
func (UnimplementedDataplexServiceServer) DeleteTask(context.Context, *DeleteTaskRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTask not implemented")
}
func (UnimplementedDataplexServiceServer) ListTasks(context.Context, *ListTasksRequest) (*ListTasksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTasks not implemented")
}
func (UnimplementedDataplexServiceServer) GetTask(context.Context, *GetTaskRequest) (*Task, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTask not implemented")
}
func (UnimplementedDataplexServiceServer) ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListJobs not implemented")
}
func (UnimplementedDataplexServiceServer) RunTask(context.Context, *RunTaskRequest) (*RunTaskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunTask not implemented")
}
func (UnimplementedDataplexServiceServer) GetJob(context.Context, *GetJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJob not implemented")
}
func (UnimplementedDataplexServiceServer) CancelJob(context.Context, *CancelJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelJob not implemented")
}
func (UnimplementedDataplexServiceServer) CreateEnvironment(context.Context, *CreateEnvironmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEnvironment not implemented")
}
func (UnimplementedDataplexServiceServer) UpdateEnvironment(context.Context, *UpdateEnvironmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEnvironment not implemented")
}
func (UnimplementedDataplexServiceServer) DeleteEnvironment(context.Context, *DeleteEnvironmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEnvironment not implemented")
}
func (UnimplementedDataplexServiceServer) ListEnvironments(context.Context, *ListEnvironmentsRequest) (*ListEnvironmentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEnvironments not implemented")
}
func (UnimplementedDataplexServiceServer) GetEnvironment(context.Context, *GetEnvironmentRequest) (*Environment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEnvironment not implemented")
}
func (UnimplementedDataplexServiceServer) ListSessions(context.Context, *ListSessionsRequest) (*ListSessionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSessions not implemented")
}

// UnsafeDataplexServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DataplexServiceServer will
// result in compilation errors.
type UnsafeDataplexServiceServer interface {
	mustEmbedUnimplementedDataplexServiceServer()
}

func RegisterDataplexServiceServer(s grpc.ServiceRegistrar, srv DataplexServiceServer) {
	s.RegisterService(&DataplexService_ServiceDesc, srv)
}

func _DataplexService_CreateLake_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateLakeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).CreateLake(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_CreateLake_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).CreateLake(ctx, req.(*CreateLakeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_UpdateLake_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateLakeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).UpdateLake(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_UpdateLake_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).UpdateLake(ctx, req.(*UpdateLakeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_DeleteLake_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteLakeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).DeleteLake(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_DeleteLake_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).DeleteLake(ctx, req.(*DeleteLakeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_ListLakes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLakesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).ListLakes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_ListLakes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).ListLakes(ctx, req.(*ListLakesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_GetLake_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLakeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).GetLake(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_GetLake_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).GetLake(ctx, req.(*GetLakeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_ListLakeActions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLakeActionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).ListLakeActions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_ListLakeActions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).ListLakeActions(ctx, req.(*ListLakeActionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_CreateZone_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateZoneRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).CreateZone(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_CreateZone_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).CreateZone(ctx, req.(*CreateZoneRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_UpdateZone_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateZoneRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).UpdateZone(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_UpdateZone_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).UpdateZone(ctx, req.(*UpdateZoneRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_DeleteZone_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteZoneRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).DeleteZone(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_DeleteZone_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).DeleteZone(ctx, req.(*DeleteZoneRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_ListZones_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListZonesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).ListZones(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_ListZones_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).ListZones(ctx, req.(*ListZonesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_GetZone_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetZoneRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).GetZone(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_GetZone_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).GetZone(ctx, req.(*GetZoneRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_ListZoneActions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListZoneActionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).ListZoneActions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_ListZoneActions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).ListZoneActions(ctx, req.(*ListZoneActionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_CreateAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).CreateAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_CreateAsset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).CreateAsset(ctx, req.(*CreateAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_UpdateAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).UpdateAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_UpdateAsset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).UpdateAsset(ctx, req.(*UpdateAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_DeleteAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).DeleteAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_DeleteAsset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).DeleteAsset(ctx, req.(*DeleteAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_ListAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).ListAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_ListAssets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).ListAssets(ctx, req.(*ListAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_GetAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).GetAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_GetAsset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).GetAsset(ctx, req.(*GetAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_ListAssetActions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAssetActionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).ListAssetActions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_ListAssetActions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).ListAssetActions(ctx, req.(*ListAssetActionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_CreateTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).CreateTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_CreateTask_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).CreateTask(ctx, req.(*CreateTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_UpdateTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).UpdateTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_UpdateTask_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).UpdateTask(ctx, req.(*UpdateTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_DeleteTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).DeleteTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_DeleteTask_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).DeleteTask(ctx, req.(*DeleteTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_ListTasks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTasksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).ListTasks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_ListTasks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).ListTasks(ctx, req.(*ListTasksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_GetTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).GetTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_GetTask_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).GetTask(ctx, req.(*GetTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_ListJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).ListJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_ListJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).ListJobs(ctx, req.(*ListJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_RunTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).RunTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_RunTask_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).RunTask(ctx, req.(*RunTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_GetJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).GetJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_GetJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).GetJob(ctx, req.(*GetJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_CancelJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).CancelJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_CancelJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).CancelJob(ctx, req.(*CancelJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_CreateEnvironment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEnvironmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).CreateEnvironment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_CreateEnvironment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).CreateEnvironment(ctx, req.(*CreateEnvironmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_UpdateEnvironment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEnvironmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).UpdateEnvironment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_UpdateEnvironment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).UpdateEnvironment(ctx, req.(*UpdateEnvironmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_DeleteEnvironment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEnvironmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).DeleteEnvironment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_DeleteEnvironment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).DeleteEnvironment(ctx, req.(*DeleteEnvironmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_ListEnvironments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEnvironmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).ListEnvironments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_ListEnvironments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).ListEnvironments(ctx, req.(*ListEnvironmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_GetEnvironment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEnvironmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).GetEnvironment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_GetEnvironment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).GetEnvironment(ctx, req.(*GetEnvironmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataplexService_ListSessions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSessionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataplexServiceServer).ListSessions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataplexService_ListSessions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataplexServiceServer).ListSessions(ctx, req.(*ListSessionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DataplexService_ServiceDesc is the grpc.ServiceDesc for DataplexService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DataplexService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataplex.v1.DataplexService",
	HandlerType: (*DataplexServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateLake",
			Handler:    _DataplexService_CreateLake_Handler,
		},
		{
			MethodName: "UpdateLake",
			Handler:    _DataplexService_UpdateLake_Handler,
		},
		{
			MethodName: "DeleteLake",
			Handler:    _DataplexService_DeleteLake_Handler,
		},
		{
			MethodName: "ListLakes",
			Handler:    _DataplexService_ListLakes_Handler,
		},
		{
			MethodName: "GetLake",
			Handler:    _DataplexService_GetLake_Handler,
		},
		{
			MethodName: "ListLakeActions",
			Handler:    _DataplexService_ListLakeActions_Handler,
		},
		{
			MethodName: "CreateZone",
			Handler:    _DataplexService_CreateZone_Handler,
		},
		{
			MethodName: "UpdateZone",
			Handler:    _DataplexService_UpdateZone_Handler,
		},
		{
			MethodName: "DeleteZone",
			Handler:    _DataplexService_DeleteZone_Handler,
		},
		{
			MethodName: "ListZones",
			Handler:    _DataplexService_ListZones_Handler,
		},
		{
			MethodName: "GetZone",
			Handler:    _DataplexService_GetZone_Handler,
		},
		{
			MethodName: "ListZoneActions",
			Handler:    _DataplexService_ListZoneActions_Handler,
		},
		{
			MethodName: "CreateAsset",
			Handler:    _DataplexService_CreateAsset_Handler,
		},
		{
			MethodName: "UpdateAsset",
			Handler:    _DataplexService_UpdateAsset_Handler,
		},
		{
			MethodName: "DeleteAsset",
			Handler:    _DataplexService_DeleteAsset_Handler,
		},
		{
			MethodName: "ListAssets",
			Handler:    _DataplexService_ListAssets_Handler,
		},
		{
			MethodName: "GetAsset",
			Handler:    _DataplexService_GetAsset_Handler,
		},
		{
			MethodName: "ListAssetActions",
			Handler:    _DataplexService_ListAssetActions_Handler,
		},
		{
			MethodName: "CreateTask",
			Handler:    _DataplexService_CreateTask_Handler,
		},
		{
			MethodName: "UpdateTask",
			Handler:    _DataplexService_UpdateTask_Handler,
		},
		{
			MethodName: "DeleteTask",
			Handler:    _DataplexService_DeleteTask_Handler,
		},
		{
			MethodName: "ListTasks",
			Handler:    _DataplexService_ListTasks_Handler,
		},
		{
			MethodName: "GetTask",
			Handler:    _DataplexService_GetTask_Handler,
		},
		{
			MethodName: "ListJobs",
			Handler:    _DataplexService_ListJobs_Handler,
		},
		{
			MethodName: "RunTask",
			Handler:    _DataplexService_RunTask_Handler,
		},
		{
			MethodName: "GetJob",
			Handler:    _DataplexService_GetJob_Handler,
		},
		{
			MethodName: "CancelJob",
			Handler:    _DataplexService_CancelJob_Handler,
		},
		{
			MethodName: "CreateEnvironment",
			Handler:    _DataplexService_CreateEnvironment_Handler,
		},
		{
			MethodName: "UpdateEnvironment",
			Handler:    _DataplexService_UpdateEnvironment_Handler,
		},
		{
			MethodName: "DeleteEnvironment",
			Handler:    _DataplexService_DeleteEnvironment_Handler,
		},
		{
			MethodName: "ListEnvironments",
			Handler:    _DataplexService_ListEnvironments_Handler,
		},
		{
			MethodName: "GetEnvironment",
			Handler:    _DataplexService_GetEnvironment_Handler,
		},
		{
			MethodName: "ListSessions",
			Handler:    _DataplexService_ListSessions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataplex/v1/service.proto",
}
