// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/alert"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/meta"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/predicate"
)

// MetaUpdate is the builder for updating Meta entities.
type MetaUpdate struct {
	config
	hooks    []Hook
	mutation *MetaMutation
}

// Where appends a list predicates to the MetaUpdate builder.
func (mu *MetaUpdate) Where(ps ...predicate.Meta) *MetaUpdate {
	mu.mutation.Where(ps...)
	return mu
}

// SetUpdatedAt sets the "updated_at" field.
func (mu *MetaUpdate) SetUpdatedAt(t time.Time) *MetaUpdate {
	mu.mutation.SetUpdatedAt(t)
	return mu
}

// SetAlertMetas sets the "alert_metas" field.
func (mu *MetaUpdate) SetAlertMetas(i int) *MetaUpdate {
	mu.mutation.SetAlertMetas(i)
	return mu
}

// SetNillableAlertMetas sets the "alert_metas" field if the given value is not nil.
func (mu *MetaUpdate) SetNillableAlertMetas(i *int) *MetaUpdate {
	if i != nil {
		mu.SetAlertMetas(*i)
	}
	return mu
}

// ClearAlertMetas clears the value of the "alert_metas" field.
func (mu *MetaUpdate) ClearAlertMetas() *MetaUpdate {
	mu.mutation.ClearAlertMetas()
	return mu
}

// SetOwnerID sets the "owner" edge to the Alert entity by ID.
func (mu *MetaUpdate) SetOwnerID(id int) *MetaUpdate {
	mu.mutation.SetOwnerID(id)
	return mu
}

// SetNillableOwnerID sets the "owner" edge to the Alert entity by ID if the given value is not nil.
func (mu *MetaUpdate) SetNillableOwnerID(id *int) *MetaUpdate {
	if id != nil {
		mu = mu.SetOwnerID(*id)
	}
	return mu
}

// SetOwner sets the "owner" edge to the Alert entity.
func (mu *MetaUpdate) SetOwner(a *Alert) *MetaUpdate {
	return mu.SetOwnerID(a.ID)
}

// Mutation returns the MetaMutation object of the builder.
func (mu *MetaUpdate) Mutation() *MetaMutation {
	return mu.mutation
}

// ClearOwner clears the "owner" edge to the Alert entity.
func (mu *MetaUpdate) ClearOwner() *MetaUpdate {
	mu.mutation.ClearOwner()
	return mu
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (mu *MetaUpdate) Save(ctx context.Context) (int, error) {
	mu.defaults()
	return withHooks(ctx, mu.sqlSave, mu.mutation, mu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (mu *MetaUpdate) SaveX(ctx context.Context) int {
	affected, err := mu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (mu *MetaUpdate) Exec(ctx context.Context) error {
	_, err := mu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (mu *MetaUpdate) ExecX(ctx context.Context) {
	if err := mu.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (mu *MetaUpdate) defaults() {
	if _, ok := mu.mutation.UpdatedAt(); !ok {
		v := meta.UpdateDefaultUpdatedAt()
		mu.mutation.SetUpdatedAt(v)
	}
}

func (mu *MetaUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(meta.Table, meta.Columns, sqlgraph.NewFieldSpec(meta.FieldID, field.TypeInt))
	if ps := mu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := mu.mutation.UpdatedAt(); ok {
		_spec.SetField(meta.FieldUpdatedAt, field.TypeTime, value)
	}
	if mu.mutation.OwnerCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   meta.OwnerTable,
			Columns: []string{meta.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(alert.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := mu.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   meta.OwnerTable,
			Columns: []string{meta.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(alert.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if n, err = sqlgraph.UpdateNodes(ctx, mu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{meta.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	mu.mutation.done = true
	return n, nil
}

// MetaUpdateOne is the builder for updating a single Meta entity.
type MetaUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *MetaMutation
}

// SetUpdatedAt sets the "updated_at" field.
func (muo *MetaUpdateOne) SetUpdatedAt(t time.Time) *MetaUpdateOne {
	muo.mutation.SetUpdatedAt(t)
	return muo
}

// SetAlertMetas sets the "alert_metas" field.
func (muo *MetaUpdateOne) SetAlertMetas(i int) *MetaUpdateOne {
	muo.mutation.SetAlertMetas(i)
	return muo
}

// SetNillableAlertMetas sets the "alert_metas" field if the given value is not nil.
func (muo *MetaUpdateOne) SetNillableAlertMetas(i *int) *MetaUpdateOne {
	if i != nil {
		muo.SetAlertMetas(*i)
	}
	return muo
}

// ClearAlertMetas clears the value of the "alert_metas" field.
func (muo *MetaUpdateOne) ClearAlertMetas() *MetaUpdateOne {
	muo.mutation.ClearAlertMetas()
	return muo
}

// SetOwnerID sets the "owner" edge to the Alert entity by ID.
func (muo *MetaUpdateOne) SetOwnerID(id int) *MetaUpdateOne {
	muo.mutation.SetOwnerID(id)
	return muo
}

// SetNillableOwnerID sets the "owner" edge to the Alert entity by ID if the given value is not nil.
func (muo *MetaUpdateOne) SetNillableOwnerID(id *int) *MetaUpdateOne {
	if id != nil {
		muo = muo.SetOwnerID(*id)
	}
	return muo
}

// SetOwner sets the "owner" edge to the Alert entity.
func (muo *MetaUpdateOne) SetOwner(a *Alert) *MetaUpdateOne {
	return muo.SetOwnerID(a.ID)
}

// Mutation returns the MetaMutation object of the builder.
func (muo *MetaUpdateOne) Mutation() *MetaMutation {
	return muo.mutation
}

// ClearOwner clears the "owner" edge to the Alert entity.
func (muo *MetaUpdateOne) ClearOwner() *MetaUpdateOne {
	muo.mutation.ClearOwner()
	return muo
}

// Where appends a list predicates to the MetaUpdate builder.
func (muo *MetaUpdateOne) Where(ps ...predicate.Meta) *MetaUpdateOne {
	muo.mutation.Where(ps...)
	return muo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (muo *MetaUpdateOne) Select(field string, fields ...string) *MetaUpdateOne {
	muo.fields = append([]string{field}, fields...)
	return muo
}

// Save executes the query and returns the updated Meta entity.
func (muo *MetaUpdateOne) Save(ctx context.Context) (*Meta, error) {
	muo.defaults()
	return withHooks(ctx, muo.sqlSave, muo.mutation, muo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (muo *MetaUpdateOne) SaveX(ctx context.Context) *Meta {
	node, err := muo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (muo *MetaUpdateOne) Exec(ctx context.Context) error {
	_, err := muo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (muo *MetaUpdateOne) ExecX(ctx context.Context) {
	if err := muo.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (muo *MetaUpdateOne) defaults() {
	if _, ok := muo.mutation.UpdatedAt(); !ok {
		v := meta.UpdateDefaultUpdatedAt()
		muo.mutation.SetUpdatedAt(v)
	}
}

func (muo *MetaUpdateOne) sqlSave(ctx context.Context) (_node *Meta, err error) {
	_spec := sqlgraph.NewUpdateSpec(meta.Table, meta.Columns, sqlgraph.NewFieldSpec(meta.FieldID, field.TypeInt))
	id, ok := muo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`ent: missing "Meta.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := muo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, meta.FieldID)
		for _, f := range fields {
			if !meta.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
			}
			if f != meta.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := muo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := muo.mutation.UpdatedAt(); ok {
		_spec.SetField(meta.FieldUpdatedAt, field.TypeTime, value)
	}
	if muo.mutation.OwnerCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   meta.OwnerTable,
			Columns: []string{meta.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(alert.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := muo.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   meta.OwnerTable,
			Columns: []string{meta.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(alert.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_node = &Meta{config: muo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, muo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{meta.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	muo.mutation.done = true
	return _node, nil
}
