// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/aiplatform/v1/study.proto

package aiplatform

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Describes the Study state.
type Study_State int32

const (
	// The study state is unspecified.
	Study_STATE_UNSPECIFIED Study_State = 0
	// The study is active.
	Study_ACTIVE Study_State = 1
	// The study is stopped due to an internal error.
	Study_INACTIVE Study_State = 2
	// The study is done when the service exhausts the parameter search space
	// or max_trial_count is reached.
	Study_COMPLETED Study_State = 3
)

// Enum value maps for Study_State.
var (
	Study_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "INACTIVE",
		3: "COMPLETED",
	}
	Study_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"INACTIVE":          2,
		"COMPLETED":         3,
	}
)

func (x Study_State) Enum() *Study_State {
	p := new(Study_State)
	*p = x
	return p
}

func (x Study_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Study_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_study_proto_enumTypes[0].Descriptor()
}

func (Study_State) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_study_proto_enumTypes[0]
}

func (x Study_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Study_State.Descriptor instead.
func (Study_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{0, 0}
}

// Describes a Trial state.
type Trial_State int32

const (
	// The Trial state is unspecified.
	Trial_STATE_UNSPECIFIED Trial_State = 0
	// Indicates that a specific Trial has been requested, but it has not yet
	// been suggested by the service.
	Trial_REQUESTED Trial_State = 1
	// Indicates that the Trial has been suggested.
	Trial_ACTIVE Trial_State = 2
	// Indicates that the Trial should stop according to the service.
	Trial_STOPPING Trial_State = 3
	// Indicates that the Trial is completed successfully.
	Trial_SUCCEEDED Trial_State = 4
	// Indicates that the Trial should not be attempted again.
	// The service will set a Trial to INFEASIBLE when it's done but missing
	// the final_measurement.
	Trial_INFEASIBLE Trial_State = 5
)

// Enum value maps for Trial_State.
var (
	Trial_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "REQUESTED",
		2: "ACTIVE",
		3: "STOPPING",
		4: "SUCCEEDED",
		5: "INFEASIBLE",
	}
	Trial_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"REQUESTED":         1,
		"ACTIVE":            2,
		"STOPPING":          3,
		"SUCCEEDED":         4,
		"INFEASIBLE":        5,
	}
)

func (x Trial_State) Enum() *Trial_State {
	p := new(Trial_State)
	*p = x
	return p
}

func (x Trial_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Trial_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_study_proto_enumTypes[1].Descriptor()
}

func (Trial_State) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_study_proto_enumTypes[1]
}

func (x Trial_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Trial_State.Descriptor instead.
func (Trial_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{1, 0}
}

// The available search algorithms for the Study.
type StudySpec_Algorithm int32

const (
	// The default algorithm used by Vertex AI for [hyperparameter
	// tuning](https://cloud.google.com/vertex-ai/docs/training/hyperparameter-tuning-overview)
	// and [Vertex Vizier](https://cloud.google.com/vertex-ai/docs/vizier).
	StudySpec_ALGORITHM_UNSPECIFIED StudySpec_Algorithm = 0
	// Simple grid search within the feasible space. To use grid search,
	// all parameters must be `INTEGER`, `CATEGORICAL`, or `DISCRETE`.
	StudySpec_GRID_SEARCH StudySpec_Algorithm = 2
	// Simple random search within the feasible space.
	StudySpec_RANDOM_SEARCH StudySpec_Algorithm = 3
)

// Enum value maps for StudySpec_Algorithm.
var (
	StudySpec_Algorithm_name = map[int32]string{
		0: "ALGORITHM_UNSPECIFIED",
		2: "GRID_SEARCH",
		3: "RANDOM_SEARCH",
	}
	StudySpec_Algorithm_value = map[string]int32{
		"ALGORITHM_UNSPECIFIED": 0,
		"GRID_SEARCH":           2,
		"RANDOM_SEARCH":         3,
	}
)

func (x StudySpec_Algorithm) Enum() *StudySpec_Algorithm {
	p := new(StudySpec_Algorithm)
	*p = x
	return p
}

func (x StudySpec_Algorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StudySpec_Algorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_study_proto_enumTypes[2].Descriptor()
}

func (StudySpec_Algorithm) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_study_proto_enumTypes[2]
}

func (x StudySpec_Algorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StudySpec_Algorithm.Descriptor instead.
func (StudySpec_Algorithm) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{2, 0}
}

// Describes the noise level of the repeated observations.
//
// "Noisy" means that the repeated observations with the same Trial parameters
// may lead to different metric evaluations.
type StudySpec_ObservationNoise int32

const (
	// The default noise level chosen by Vertex AI.
	StudySpec_OBSERVATION_NOISE_UNSPECIFIED StudySpec_ObservationNoise = 0
	// Vertex AI assumes that the objective function is (nearly)
	// perfectly reproducible, and will never repeat the same Trial
	// parameters.
	StudySpec_LOW StudySpec_ObservationNoise = 1
	// Vertex AI will estimate the amount of noise in metric
	// evaluations, it may repeat the same Trial parameters more than once.
	StudySpec_HIGH StudySpec_ObservationNoise = 2
)

// Enum value maps for StudySpec_ObservationNoise.
var (
	StudySpec_ObservationNoise_name = map[int32]string{
		0: "OBSERVATION_NOISE_UNSPECIFIED",
		1: "LOW",
		2: "HIGH",
	}
	StudySpec_ObservationNoise_value = map[string]int32{
		"OBSERVATION_NOISE_UNSPECIFIED": 0,
		"LOW":                           1,
		"HIGH":                          2,
	}
)

func (x StudySpec_ObservationNoise) Enum() *StudySpec_ObservationNoise {
	p := new(StudySpec_ObservationNoise)
	*p = x
	return p
}

func (x StudySpec_ObservationNoise) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StudySpec_ObservationNoise) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_study_proto_enumTypes[3].Descriptor()
}

func (StudySpec_ObservationNoise) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_study_proto_enumTypes[3]
}

func (x StudySpec_ObservationNoise) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StudySpec_ObservationNoise.Descriptor instead.
func (StudySpec_ObservationNoise) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{2, 1}
}

// This indicates which measurement to use if/when the service automatically
// selects the final measurement from previously reported intermediate
// measurements. Choose this based on two considerations:
//  A) Do you expect your measurements to monotonically improve?
//     If so, choose LAST_MEASUREMENT. On the other hand, if you're in a
//     situation where your system can "over-train" and you expect the
//     performance to get better for a while but then start declining,
//     choose BEST_MEASUREMENT.
//  B) Are your measurements significantly noisy and/or irreproducible?
//     If so, BEST_MEASUREMENT will tend to be over-optimistic, and it
//     may be better to choose LAST_MEASUREMENT.
//  If both or neither of (A) and (B) apply, it doesn't matter which
//  selection type is chosen.
type StudySpec_MeasurementSelectionType int32

const (
	// Will be treated as LAST_MEASUREMENT.
	StudySpec_MEASUREMENT_SELECTION_TYPE_UNSPECIFIED StudySpec_MeasurementSelectionType = 0
	// Use the last measurement reported.
	StudySpec_LAST_MEASUREMENT StudySpec_MeasurementSelectionType = 1
	// Use the best measurement reported.
	StudySpec_BEST_MEASUREMENT StudySpec_MeasurementSelectionType = 2
)

// Enum value maps for StudySpec_MeasurementSelectionType.
var (
	StudySpec_MeasurementSelectionType_name = map[int32]string{
		0: "MEASUREMENT_SELECTION_TYPE_UNSPECIFIED",
		1: "LAST_MEASUREMENT",
		2: "BEST_MEASUREMENT",
	}
	StudySpec_MeasurementSelectionType_value = map[string]int32{
		"MEASUREMENT_SELECTION_TYPE_UNSPECIFIED": 0,
		"LAST_MEASUREMENT":                       1,
		"BEST_MEASUREMENT":                       2,
	}
)

func (x StudySpec_MeasurementSelectionType) Enum() *StudySpec_MeasurementSelectionType {
	p := new(StudySpec_MeasurementSelectionType)
	*p = x
	return p
}

func (x StudySpec_MeasurementSelectionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StudySpec_MeasurementSelectionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_study_proto_enumTypes[4].Descriptor()
}

func (StudySpec_MeasurementSelectionType) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_study_proto_enumTypes[4]
}

func (x StudySpec_MeasurementSelectionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StudySpec_MeasurementSelectionType.Descriptor instead.
func (StudySpec_MeasurementSelectionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{2, 2}
}

// The available types of optimization goals.
type StudySpec_MetricSpec_GoalType int32

const (
	// Goal Type will default to maximize.
	StudySpec_MetricSpec_GOAL_TYPE_UNSPECIFIED StudySpec_MetricSpec_GoalType = 0
	// Maximize the goal metric.
	StudySpec_MetricSpec_MAXIMIZE StudySpec_MetricSpec_GoalType = 1
	// Minimize the goal metric.
	StudySpec_MetricSpec_MINIMIZE StudySpec_MetricSpec_GoalType = 2
)

// Enum value maps for StudySpec_MetricSpec_GoalType.
var (
	StudySpec_MetricSpec_GoalType_name = map[int32]string{
		0: "GOAL_TYPE_UNSPECIFIED",
		1: "MAXIMIZE",
		2: "MINIMIZE",
	}
	StudySpec_MetricSpec_GoalType_value = map[string]int32{
		"GOAL_TYPE_UNSPECIFIED": 0,
		"MAXIMIZE":              1,
		"MINIMIZE":              2,
	}
)

func (x StudySpec_MetricSpec_GoalType) Enum() *StudySpec_MetricSpec_GoalType {
	p := new(StudySpec_MetricSpec_GoalType)
	*p = x
	return p
}

func (x StudySpec_MetricSpec_GoalType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StudySpec_MetricSpec_GoalType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_study_proto_enumTypes[5].Descriptor()
}

func (StudySpec_MetricSpec_GoalType) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_study_proto_enumTypes[5]
}

func (x StudySpec_MetricSpec_GoalType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StudySpec_MetricSpec_GoalType.Descriptor instead.
func (StudySpec_MetricSpec_GoalType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{2, 0, 0}
}

// The type of scaling that should be applied to this parameter.
type StudySpec_ParameterSpec_ScaleType int32

const (
	// By default, no scaling is applied.
	StudySpec_ParameterSpec_SCALE_TYPE_UNSPECIFIED StudySpec_ParameterSpec_ScaleType = 0
	// Scales the feasible space to (0, 1) linearly.
	StudySpec_ParameterSpec_UNIT_LINEAR_SCALE StudySpec_ParameterSpec_ScaleType = 1
	// Scales the feasible space logarithmically to (0, 1). The entire
	// feasible space must be strictly positive.
	StudySpec_ParameterSpec_UNIT_LOG_SCALE StudySpec_ParameterSpec_ScaleType = 2
	// Scales the feasible space "reverse" logarithmically to (0, 1). The
	// result is that values close to the top of the feasible space are spread
	// out more than points near the bottom. The entire feasible space must be
	// strictly positive.
	StudySpec_ParameterSpec_UNIT_REVERSE_LOG_SCALE StudySpec_ParameterSpec_ScaleType = 3
)

// Enum value maps for StudySpec_ParameterSpec_ScaleType.
var (
	StudySpec_ParameterSpec_ScaleType_name = map[int32]string{
		0: "SCALE_TYPE_UNSPECIFIED",
		1: "UNIT_LINEAR_SCALE",
		2: "UNIT_LOG_SCALE",
		3: "UNIT_REVERSE_LOG_SCALE",
	}
	StudySpec_ParameterSpec_ScaleType_value = map[string]int32{
		"SCALE_TYPE_UNSPECIFIED": 0,
		"UNIT_LINEAR_SCALE":      1,
		"UNIT_LOG_SCALE":         2,
		"UNIT_REVERSE_LOG_SCALE": 3,
	}
)

func (x StudySpec_ParameterSpec_ScaleType) Enum() *StudySpec_ParameterSpec_ScaleType {
	p := new(StudySpec_ParameterSpec_ScaleType)
	*p = x
	return p
}

func (x StudySpec_ParameterSpec_ScaleType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StudySpec_ParameterSpec_ScaleType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_study_proto_enumTypes[6].Descriptor()
}

func (StudySpec_ParameterSpec_ScaleType) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_study_proto_enumTypes[6]
}

func (x StudySpec_ParameterSpec_ScaleType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StudySpec_ParameterSpec_ScaleType.Descriptor instead.
func (StudySpec_ParameterSpec_ScaleType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{2, 1, 0}
}

// A message representing a Study.
type Study struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of a study. The study's globally unique identifier.
	// Format: `projects/{project}/locations/{location}/studies/{study}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Describes the Study, default value is empty string.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Configuration of the Study.
	StudySpec *StudySpec `protobuf:"bytes,3,opt,name=study_spec,json=studySpec,proto3" json:"study_spec,omitempty"`
	// Output only. The detailed state of a Study.
	State Study_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.aiplatform.v1.Study_State" json:"state,omitempty"`
	// Output only. Time at which the study was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. A human readable reason why the Study is inactive.
	// This should be empty if a study is ACTIVE or COMPLETED.
	InactiveReason string `protobuf:"bytes,6,opt,name=inactive_reason,json=inactiveReason,proto3" json:"inactive_reason,omitempty"`
}

func (x *Study) Reset() {
	*x = Study{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Study) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Study) ProtoMessage() {}

func (x *Study) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Study.ProtoReflect.Descriptor instead.
func (*Study) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{0}
}

func (x *Study) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Study) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Study) GetStudySpec() *StudySpec {
	if x != nil {
		return x.StudySpec
	}
	return nil
}

func (x *Study) GetState() Study_State {
	if x != nil {
		return x.State
	}
	return Study_STATE_UNSPECIFIED
}

func (x *Study) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Study) GetInactiveReason() string {
	if x != nil {
		return x.InactiveReason
	}
	return ""
}

// A message representing a Trial. A Trial contains a unique set of Parameters
// that has been or will be evaluated, along with the objective metrics got by
// running the Trial.
type Trial struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of the Trial assigned by the service.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The identifier of the Trial assigned by the service.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. The detailed state of the Trial.
	State Trial_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.aiplatform.v1.Trial_State" json:"state,omitempty"`
	// Output only. The parameters of the Trial.
	Parameters []*Trial_Parameter `protobuf:"bytes,4,rep,name=parameters,proto3" json:"parameters,omitempty"`
	// Output only. The final measurement containing the objective value.
	FinalMeasurement *Measurement `protobuf:"bytes,5,opt,name=final_measurement,json=finalMeasurement,proto3" json:"final_measurement,omitempty"`
	// Output only. A list of measurements that are strictly lexicographically
	// ordered by their induced tuples (steps, elapsed_duration).
	// These are used for early stopping computations.
	Measurements []*Measurement `protobuf:"bytes,6,rep,name=measurements,proto3" json:"measurements,omitempty"`
	// Output only. Time when the Trial was started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Time when the Trial's status changed to `SUCCEEDED` or `INFEASIBLE`.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The identifier of the client that originally requested this Trial.
	// Each client is identified by a unique client_id. When a client
	// asks for a suggestion, Vizier will assign it a Trial. The client should
	// evaluate the Trial, complete it, and report back to Vizier.
	// If suggestion is asked again by same client_id before the Trial is
	// completed, the same Trial will be returned. Multiple clients with
	// different client_ids can ask for suggestions simultaneously, each of them
	// will get their own Trial.
	ClientId string `protobuf:"bytes,9,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	// Output only. A human readable string describing why the Trial is
	// infeasible. This is set only if Trial state is `INFEASIBLE`.
	InfeasibleReason string `protobuf:"bytes,10,opt,name=infeasible_reason,json=infeasibleReason,proto3" json:"infeasible_reason,omitempty"`
	// Output only. The CustomJob name linked to the Trial.
	// It's set for a HyperparameterTuningJob's Trial.
	CustomJob string `protobuf:"bytes,11,opt,name=custom_job,json=customJob,proto3" json:"custom_job,omitempty"`
	// Output only. URIs for accessing [interactive
	// shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
	// (one URI for each training node). Only available if this trial is part of
	// a [HyperparameterTuningJob][google.cloud.aiplatform.v1.HyperparameterTuningJob] and the job's
	// [trial_job_spec.enable_web_access][google.cloud.aiplatform.v1.CustomJobSpec.enable_web_access] field
	// is `true`.
	//
	// The keys are names of each node used for the trial; for example,
	// `workerpool0-0` for the primary node, `workerpool1-0` for the first node in
	// the second worker pool, and `workerpool1-1` for the second node in the
	// second worker pool.
	//
	// The values are the URIs for each node's interactive shell.
	WebAccessUris map[string]string `protobuf:"bytes,12,rep,name=web_access_uris,json=webAccessUris,proto3" json:"web_access_uris,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Trial) Reset() {
	*x = Trial{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trial) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trial) ProtoMessage() {}

func (x *Trial) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trial.ProtoReflect.Descriptor instead.
func (*Trial) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{1}
}

func (x *Trial) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Trial) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Trial) GetState() Trial_State {
	if x != nil {
		return x.State
	}
	return Trial_STATE_UNSPECIFIED
}

func (x *Trial) GetParameters() []*Trial_Parameter {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *Trial) GetFinalMeasurement() *Measurement {
	if x != nil {
		return x.FinalMeasurement
	}
	return nil
}

func (x *Trial) GetMeasurements() []*Measurement {
	if x != nil {
		return x.Measurements
	}
	return nil
}

func (x *Trial) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Trial) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Trial) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

func (x *Trial) GetInfeasibleReason() string {
	if x != nil {
		return x.InfeasibleReason
	}
	return ""
}

func (x *Trial) GetCustomJob() string {
	if x != nil {
		return x.CustomJob
	}
	return ""
}

func (x *Trial) GetWebAccessUris() map[string]string {
	if x != nil {
		return x.WebAccessUris
	}
	return nil
}

// Represents specification of a Study.
type StudySpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to AutomatedStoppingSpec:
	//	*StudySpec_DecayCurveStoppingSpec
	//	*StudySpec_MedianAutomatedStoppingSpec_
	AutomatedStoppingSpec isStudySpec_AutomatedStoppingSpec `protobuf_oneof:"automated_stopping_spec"`
	// Required. Metric specs for the Study.
	Metrics []*StudySpec_MetricSpec `protobuf:"bytes,1,rep,name=metrics,proto3" json:"metrics,omitempty"`
	// Required. The set of parameters to tune.
	Parameters []*StudySpec_ParameterSpec `protobuf:"bytes,2,rep,name=parameters,proto3" json:"parameters,omitempty"`
	// The search algorithm specified for the Study.
	Algorithm StudySpec_Algorithm `protobuf:"varint,3,opt,name=algorithm,proto3,enum=google.cloud.aiplatform.v1.StudySpec_Algorithm" json:"algorithm,omitempty"`
	// The observation noise level of the study.
	// Currently only supported by the Vizier service. Not supported by
	// HyperparamterTuningJob or TrainingPipeline.
	ObservationNoise StudySpec_ObservationNoise `protobuf:"varint,6,opt,name=observation_noise,json=observationNoise,proto3,enum=google.cloud.aiplatform.v1.StudySpec_ObservationNoise" json:"observation_noise,omitempty"`
	// Describe which measurement selection type will be used
	MeasurementSelectionType StudySpec_MeasurementSelectionType `protobuf:"varint,7,opt,name=measurement_selection_type,json=measurementSelectionType,proto3,enum=google.cloud.aiplatform.v1.StudySpec_MeasurementSelectionType" json:"measurement_selection_type,omitempty"`
}

func (x *StudySpec) Reset() {
	*x = StudySpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StudySpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StudySpec) ProtoMessage() {}

func (x *StudySpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StudySpec.ProtoReflect.Descriptor instead.
func (*StudySpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{2}
}

func (m *StudySpec) GetAutomatedStoppingSpec() isStudySpec_AutomatedStoppingSpec {
	if m != nil {
		return m.AutomatedStoppingSpec
	}
	return nil
}

func (x *StudySpec) GetDecayCurveStoppingSpec() *StudySpec_DecayCurveAutomatedStoppingSpec {
	if x, ok := x.GetAutomatedStoppingSpec().(*StudySpec_DecayCurveStoppingSpec); ok {
		return x.DecayCurveStoppingSpec
	}
	return nil
}

func (x *StudySpec) GetMedianAutomatedStoppingSpec() *StudySpec_MedianAutomatedStoppingSpec {
	if x, ok := x.GetAutomatedStoppingSpec().(*StudySpec_MedianAutomatedStoppingSpec_); ok {
		return x.MedianAutomatedStoppingSpec
	}
	return nil
}

func (x *StudySpec) GetMetrics() []*StudySpec_MetricSpec {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *StudySpec) GetParameters() []*StudySpec_ParameterSpec {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *StudySpec) GetAlgorithm() StudySpec_Algorithm {
	if x != nil {
		return x.Algorithm
	}
	return StudySpec_ALGORITHM_UNSPECIFIED
}

func (x *StudySpec) GetObservationNoise() StudySpec_ObservationNoise {
	if x != nil {
		return x.ObservationNoise
	}
	return StudySpec_OBSERVATION_NOISE_UNSPECIFIED
}

func (x *StudySpec) GetMeasurementSelectionType() StudySpec_MeasurementSelectionType {
	if x != nil {
		return x.MeasurementSelectionType
	}
	return StudySpec_MEASUREMENT_SELECTION_TYPE_UNSPECIFIED
}

type isStudySpec_AutomatedStoppingSpec interface {
	isStudySpec_AutomatedStoppingSpec()
}

type StudySpec_DecayCurveStoppingSpec struct {
	// The automated early stopping spec using decay curve rule.
	DecayCurveStoppingSpec *StudySpec_DecayCurveAutomatedStoppingSpec `protobuf:"bytes,4,opt,name=decay_curve_stopping_spec,json=decayCurveStoppingSpec,proto3,oneof"`
}

type StudySpec_MedianAutomatedStoppingSpec_ struct {
	// The automated early stopping spec using median rule.
	MedianAutomatedStoppingSpec *StudySpec_MedianAutomatedStoppingSpec `protobuf:"bytes,5,opt,name=median_automated_stopping_spec,json=medianAutomatedStoppingSpec,proto3,oneof"`
}

func (*StudySpec_DecayCurveStoppingSpec) isStudySpec_AutomatedStoppingSpec() {}

func (*StudySpec_MedianAutomatedStoppingSpec_) isStudySpec_AutomatedStoppingSpec() {}

// A message representing a Measurement of a Trial. A Measurement contains
// the Metrics got by executing a Trial using suggested hyperparameter
// values.
type Measurement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Time that the Trial has been running at the point of this Measurement.
	ElapsedDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=elapsed_duration,json=elapsedDuration,proto3" json:"elapsed_duration,omitempty"`
	// Output only. The number of steps the machine learning model has been trained for.
	// Must be non-negative.
	StepCount int64 `protobuf:"varint,2,opt,name=step_count,json=stepCount,proto3" json:"step_count,omitempty"`
	// Output only. A list of metrics got by evaluating the objective functions using suggested
	// Parameter values.
	Metrics []*Measurement_Metric `protobuf:"bytes,3,rep,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *Measurement) Reset() {
	*x = Measurement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Measurement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Measurement) ProtoMessage() {}

func (x *Measurement) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Measurement.ProtoReflect.Descriptor instead.
func (*Measurement) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{3}
}

func (x *Measurement) GetElapsedDuration() *durationpb.Duration {
	if x != nil {
		return x.ElapsedDuration
	}
	return nil
}

func (x *Measurement) GetStepCount() int64 {
	if x != nil {
		return x.StepCount
	}
	return 0
}

func (x *Measurement) GetMetrics() []*Measurement_Metric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// A message representing a parameter to be tuned.
type Trial_Parameter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The ID of the parameter. The parameter should be defined in
	// [StudySpec's Parameters][google.cloud.aiplatform.v1.StudySpec.parameters].
	ParameterId string `protobuf:"bytes,1,opt,name=parameter_id,json=parameterId,proto3" json:"parameter_id,omitempty"`
	// Output only. The value of the parameter.
	// `number_value` will be set if a parameter defined in StudySpec is
	// in type 'INTEGER', 'DOUBLE' or 'DISCRETE'.
	// `string_value` will be set if a parameter defined in StudySpec is
	// in type 'CATEGORICAL'.
	Value *structpb.Value `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Trial_Parameter) Reset() {
	*x = Trial_Parameter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trial_Parameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trial_Parameter) ProtoMessage() {}

func (x *Trial_Parameter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trial_Parameter.ProtoReflect.Descriptor instead.
func (*Trial_Parameter) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{1, 0}
}

func (x *Trial_Parameter) GetParameterId() string {
	if x != nil {
		return x.ParameterId
	}
	return ""
}

func (x *Trial_Parameter) GetValue() *structpb.Value {
	if x != nil {
		return x.Value
	}
	return nil
}

// Represents a metric to optimize.
type StudySpec_MetricSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the metric. Must not contain whitespaces and must be unique
	// amongst all MetricSpecs.
	MetricId string `protobuf:"bytes,1,opt,name=metric_id,json=metricId,proto3" json:"metric_id,omitempty"`
	// Required. The optimization goal of the metric.
	Goal StudySpec_MetricSpec_GoalType `protobuf:"varint,2,opt,name=goal,proto3,enum=google.cloud.aiplatform.v1.StudySpec_MetricSpec_GoalType" json:"goal,omitempty"`
}

func (x *StudySpec_MetricSpec) Reset() {
	*x = StudySpec_MetricSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StudySpec_MetricSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StudySpec_MetricSpec) ProtoMessage() {}

func (x *StudySpec_MetricSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StudySpec_MetricSpec.ProtoReflect.Descriptor instead.
func (*StudySpec_MetricSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{2, 0}
}

func (x *StudySpec_MetricSpec) GetMetricId() string {
	if x != nil {
		return x.MetricId
	}
	return ""
}

func (x *StudySpec_MetricSpec) GetGoal() StudySpec_MetricSpec_GoalType {
	if x != nil {
		return x.Goal
	}
	return StudySpec_MetricSpec_GOAL_TYPE_UNSPECIFIED
}

// Represents a single parameter to optimize.
type StudySpec_ParameterSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to ParameterValueSpec:
	//	*StudySpec_ParameterSpec_DoubleValueSpec_
	//	*StudySpec_ParameterSpec_IntegerValueSpec_
	//	*StudySpec_ParameterSpec_CategoricalValueSpec_
	//	*StudySpec_ParameterSpec_DiscreteValueSpec_
	ParameterValueSpec isStudySpec_ParameterSpec_ParameterValueSpec `protobuf_oneof:"parameter_value_spec"`
	// Required. The ID of the parameter. Must not contain whitespaces and must be unique
	// amongst all ParameterSpecs.
	ParameterId string `protobuf:"bytes,1,opt,name=parameter_id,json=parameterId,proto3" json:"parameter_id,omitempty"`
	// How the parameter should be scaled.
	// Leave unset for `CATEGORICAL` parameters.
	ScaleType StudySpec_ParameterSpec_ScaleType `protobuf:"varint,6,opt,name=scale_type,json=scaleType,proto3,enum=google.cloud.aiplatform.v1.StudySpec_ParameterSpec_ScaleType" json:"scale_type,omitempty"`
	// A conditional parameter node is active if the parameter's value matches
	// the conditional node's parent_value_condition.
	//
	// If two items in conditional_parameter_specs have the same name, they
	// must have disjoint parent_value_condition.
	ConditionalParameterSpecs []*StudySpec_ParameterSpec_ConditionalParameterSpec `protobuf:"bytes,10,rep,name=conditional_parameter_specs,json=conditionalParameterSpecs,proto3" json:"conditional_parameter_specs,omitempty"`
}

func (x *StudySpec_ParameterSpec) Reset() {
	*x = StudySpec_ParameterSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StudySpec_ParameterSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StudySpec_ParameterSpec) ProtoMessage() {}

func (x *StudySpec_ParameterSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StudySpec_ParameterSpec.ProtoReflect.Descriptor instead.
func (*StudySpec_ParameterSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{2, 1}
}

func (m *StudySpec_ParameterSpec) GetParameterValueSpec() isStudySpec_ParameterSpec_ParameterValueSpec {
	if m != nil {
		return m.ParameterValueSpec
	}
	return nil
}

func (x *StudySpec_ParameterSpec) GetDoubleValueSpec() *StudySpec_ParameterSpec_DoubleValueSpec {
	if x, ok := x.GetParameterValueSpec().(*StudySpec_ParameterSpec_DoubleValueSpec_); ok {
		return x.DoubleValueSpec
	}
	return nil
}

func (x *StudySpec_ParameterSpec) GetIntegerValueSpec() *StudySpec_ParameterSpec_IntegerValueSpec {
	if x, ok := x.GetParameterValueSpec().(*StudySpec_ParameterSpec_IntegerValueSpec_); ok {
		return x.IntegerValueSpec
	}
	return nil
}

func (x *StudySpec_ParameterSpec) GetCategoricalValueSpec() *StudySpec_ParameterSpec_CategoricalValueSpec {
	if x, ok := x.GetParameterValueSpec().(*StudySpec_ParameterSpec_CategoricalValueSpec_); ok {
		return x.CategoricalValueSpec
	}
	return nil
}

func (x *StudySpec_ParameterSpec) GetDiscreteValueSpec() *StudySpec_ParameterSpec_DiscreteValueSpec {
	if x, ok := x.GetParameterValueSpec().(*StudySpec_ParameterSpec_DiscreteValueSpec_); ok {
		return x.DiscreteValueSpec
	}
	return nil
}

func (x *StudySpec_ParameterSpec) GetParameterId() string {
	if x != nil {
		return x.ParameterId
	}
	return ""
}

func (x *StudySpec_ParameterSpec) GetScaleType() StudySpec_ParameterSpec_ScaleType {
	if x != nil {
		return x.ScaleType
	}
	return StudySpec_ParameterSpec_SCALE_TYPE_UNSPECIFIED
}

func (x *StudySpec_ParameterSpec) GetConditionalParameterSpecs() []*StudySpec_ParameterSpec_ConditionalParameterSpec {
	if x != nil {
		return x.ConditionalParameterSpecs
	}
	return nil
}

type isStudySpec_ParameterSpec_ParameterValueSpec interface {
	isStudySpec_ParameterSpec_ParameterValueSpec()
}

type StudySpec_ParameterSpec_DoubleValueSpec_ struct {
	// The value spec for a 'DOUBLE' parameter.
	DoubleValueSpec *StudySpec_ParameterSpec_DoubleValueSpec `protobuf:"bytes,2,opt,name=double_value_spec,json=doubleValueSpec,proto3,oneof"`
}

type StudySpec_ParameterSpec_IntegerValueSpec_ struct {
	// The value spec for an 'INTEGER' parameter.
	IntegerValueSpec *StudySpec_ParameterSpec_IntegerValueSpec `protobuf:"bytes,3,opt,name=integer_value_spec,json=integerValueSpec,proto3,oneof"`
}

type StudySpec_ParameterSpec_CategoricalValueSpec_ struct {
	// The value spec for a 'CATEGORICAL' parameter.
	CategoricalValueSpec *StudySpec_ParameterSpec_CategoricalValueSpec `protobuf:"bytes,4,opt,name=categorical_value_spec,json=categoricalValueSpec,proto3,oneof"`
}

type StudySpec_ParameterSpec_DiscreteValueSpec_ struct {
	// The value spec for a 'DISCRETE' parameter.
	DiscreteValueSpec *StudySpec_ParameterSpec_DiscreteValueSpec `protobuf:"bytes,5,opt,name=discrete_value_spec,json=discreteValueSpec,proto3,oneof"`
}

func (*StudySpec_ParameterSpec_DoubleValueSpec_) isStudySpec_ParameterSpec_ParameterValueSpec() {}

func (*StudySpec_ParameterSpec_IntegerValueSpec_) isStudySpec_ParameterSpec_ParameterValueSpec() {}

func (*StudySpec_ParameterSpec_CategoricalValueSpec_) isStudySpec_ParameterSpec_ParameterValueSpec() {
}

func (*StudySpec_ParameterSpec_DiscreteValueSpec_) isStudySpec_ParameterSpec_ParameterValueSpec() {}

// The decay curve automated stopping rule builds a Gaussian Process
// Regressor to predict the final objective value of a Trial based on the
// already completed Trials and the intermediate measurements of the current
// Trial. Early stopping is requested for the current Trial if there is very
// low probability to exceed the optimal value found so far.
type StudySpec_DecayCurveAutomatedStoppingSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True if [Measurement.elapsed_duration][google.cloud.aiplatform.v1.Measurement.elapsed_duration] is used as the x-axis of each
	// Trials Decay Curve. Otherwise, [Measurement.step_count][google.cloud.aiplatform.v1.Measurement.step_count] will be used
	// as the x-axis.
	UseElapsedDuration bool `protobuf:"varint,1,opt,name=use_elapsed_duration,json=useElapsedDuration,proto3" json:"use_elapsed_duration,omitempty"`
}

func (x *StudySpec_DecayCurveAutomatedStoppingSpec) Reset() {
	*x = StudySpec_DecayCurveAutomatedStoppingSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StudySpec_DecayCurveAutomatedStoppingSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StudySpec_DecayCurveAutomatedStoppingSpec) ProtoMessage() {}

func (x *StudySpec_DecayCurveAutomatedStoppingSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StudySpec_DecayCurveAutomatedStoppingSpec.ProtoReflect.Descriptor instead.
func (*StudySpec_DecayCurveAutomatedStoppingSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{2, 2}
}

func (x *StudySpec_DecayCurveAutomatedStoppingSpec) GetUseElapsedDuration() bool {
	if x != nil {
		return x.UseElapsedDuration
	}
	return false
}

// The median automated stopping rule stops a pending Trial if the Trial's
// best objective_value is strictly below the median 'performance' of all
// completed Trials reported up to the Trial's last measurement.
// Currently, 'performance' refers to the running average of the objective
// values reported by the Trial in each measurement.
type StudySpec_MedianAutomatedStoppingSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True if median automated stopping rule applies on
	// [Measurement.elapsed_duration][google.cloud.aiplatform.v1.Measurement.elapsed_duration]. It means that elapsed_duration
	// field of latest measurement of current Trial is used to compute median
	// objective value for each completed Trials.
	UseElapsedDuration bool `protobuf:"varint,1,opt,name=use_elapsed_duration,json=useElapsedDuration,proto3" json:"use_elapsed_duration,omitempty"`
}

func (x *StudySpec_MedianAutomatedStoppingSpec) Reset() {
	*x = StudySpec_MedianAutomatedStoppingSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StudySpec_MedianAutomatedStoppingSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StudySpec_MedianAutomatedStoppingSpec) ProtoMessage() {}

func (x *StudySpec_MedianAutomatedStoppingSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StudySpec_MedianAutomatedStoppingSpec.ProtoReflect.Descriptor instead.
func (*StudySpec_MedianAutomatedStoppingSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{2, 3}
}

func (x *StudySpec_MedianAutomatedStoppingSpec) GetUseElapsedDuration() bool {
	if x != nil {
		return x.UseElapsedDuration
	}
	return false
}

// Value specification for a parameter in `DOUBLE` type.
type StudySpec_ParameterSpec_DoubleValueSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Inclusive minimum value of the parameter.
	MinValue float64 `protobuf:"fixed64,1,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// Required. Inclusive maximum value of the parameter.
	MaxValue float64 `protobuf:"fixed64,2,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
	// A default value for a `DOUBLE` parameter that is assumed to be a
	// relatively good starting point.  Unset value signals that there is no
	// offered starting point.
	//
	// Currently only supported by the Vizier service. Not supported by
	// HyperparamterTuningJob or TrainingPipeline.
	DefaultValue *float64 `protobuf:"fixed64,4,opt,name=default_value,json=defaultValue,proto3,oneof" json:"default_value,omitempty"`
}

func (x *StudySpec_ParameterSpec_DoubleValueSpec) Reset() {
	*x = StudySpec_ParameterSpec_DoubleValueSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StudySpec_ParameterSpec_DoubleValueSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StudySpec_ParameterSpec_DoubleValueSpec) ProtoMessage() {}

func (x *StudySpec_ParameterSpec_DoubleValueSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StudySpec_ParameterSpec_DoubleValueSpec.ProtoReflect.Descriptor instead.
func (*StudySpec_ParameterSpec_DoubleValueSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{2, 1, 0}
}

func (x *StudySpec_ParameterSpec_DoubleValueSpec) GetMinValue() float64 {
	if x != nil {
		return x.MinValue
	}
	return 0
}

func (x *StudySpec_ParameterSpec_DoubleValueSpec) GetMaxValue() float64 {
	if x != nil {
		return x.MaxValue
	}
	return 0
}

func (x *StudySpec_ParameterSpec_DoubleValueSpec) GetDefaultValue() float64 {
	if x != nil && x.DefaultValue != nil {
		return *x.DefaultValue
	}
	return 0
}

// Value specification for a parameter in `INTEGER` type.
type StudySpec_ParameterSpec_IntegerValueSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Inclusive minimum value of the parameter.
	MinValue int64 `protobuf:"varint,1,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// Required. Inclusive maximum value of the parameter.
	MaxValue int64 `protobuf:"varint,2,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
	// A default value for an `INTEGER` parameter that is assumed to be a
	// relatively good starting point.  Unset value signals that there is no
	// offered starting point.
	//
	// Currently only supported by the Vizier service. Not supported by
	// HyperparamterTuningJob or TrainingPipeline.
	DefaultValue *int64 `protobuf:"varint,4,opt,name=default_value,json=defaultValue,proto3,oneof" json:"default_value,omitempty"`
}

func (x *StudySpec_ParameterSpec_IntegerValueSpec) Reset() {
	*x = StudySpec_ParameterSpec_IntegerValueSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StudySpec_ParameterSpec_IntegerValueSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StudySpec_ParameterSpec_IntegerValueSpec) ProtoMessage() {}

func (x *StudySpec_ParameterSpec_IntegerValueSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StudySpec_ParameterSpec_IntegerValueSpec.ProtoReflect.Descriptor instead.
func (*StudySpec_ParameterSpec_IntegerValueSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{2, 1, 1}
}

func (x *StudySpec_ParameterSpec_IntegerValueSpec) GetMinValue() int64 {
	if x != nil {
		return x.MinValue
	}
	return 0
}

func (x *StudySpec_ParameterSpec_IntegerValueSpec) GetMaxValue() int64 {
	if x != nil {
		return x.MaxValue
	}
	return 0
}

func (x *StudySpec_ParameterSpec_IntegerValueSpec) GetDefaultValue() int64 {
	if x != nil && x.DefaultValue != nil {
		return *x.DefaultValue
	}
	return 0
}

// Value specification for a parameter in `CATEGORICAL` type.
type StudySpec_ParameterSpec_CategoricalValueSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The list of possible categories.
	Values []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	// A default value for a `CATEGORICAL` parameter that is assumed to be a
	// relatively good starting point.  Unset value signals that there is no
	// offered starting point.
	//
	// Currently only supported by the Vizier service. Not supported by
	// HyperparamterTuningJob or TrainingPipeline.
	DefaultValue *string `protobuf:"bytes,3,opt,name=default_value,json=defaultValue,proto3,oneof" json:"default_value,omitempty"`
}

func (x *StudySpec_ParameterSpec_CategoricalValueSpec) Reset() {
	*x = StudySpec_ParameterSpec_CategoricalValueSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StudySpec_ParameterSpec_CategoricalValueSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StudySpec_ParameterSpec_CategoricalValueSpec) ProtoMessage() {}

func (x *StudySpec_ParameterSpec_CategoricalValueSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StudySpec_ParameterSpec_CategoricalValueSpec.ProtoReflect.Descriptor instead.
func (*StudySpec_ParameterSpec_CategoricalValueSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{2, 1, 2}
}

func (x *StudySpec_ParameterSpec_CategoricalValueSpec) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *StudySpec_ParameterSpec_CategoricalValueSpec) GetDefaultValue() string {
	if x != nil && x.DefaultValue != nil {
		return *x.DefaultValue
	}
	return ""
}

// Value specification for a parameter in `DISCRETE` type.
type StudySpec_ParameterSpec_DiscreteValueSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of possible values.
	// The list should be in increasing order and at least 1e-10 apart.
	// For instance, this parameter might have possible settings of 1.5, 2.5,
	// and 4.0. This list should not contain more than 1,000 values.
	Values []float64 `protobuf:"fixed64,1,rep,packed,name=values,proto3" json:"values,omitempty"`
	// A default value for a `DISCRETE` parameter that is assumed to be a
	// relatively good starting point.  Unset value signals that there is no
	// offered starting point.  It automatically rounds to the
	// nearest feasible discrete point.
	//
	// Currently only supported by the Vizier service. Not supported by
	// HyperparamterTuningJob or TrainingPipeline.
	DefaultValue *float64 `protobuf:"fixed64,3,opt,name=default_value,json=defaultValue,proto3,oneof" json:"default_value,omitempty"`
}

func (x *StudySpec_ParameterSpec_DiscreteValueSpec) Reset() {
	*x = StudySpec_ParameterSpec_DiscreteValueSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StudySpec_ParameterSpec_DiscreteValueSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StudySpec_ParameterSpec_DiscreteValueSpec) ProtoMessage() {}

func (x *StudySpec_ParameterSpec_DiscreteValueSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StudySpec_ParameterSpec_DiscreteValueSpec.ProtoReflect.Descriptor instead.
func (*StudySpec_ParameterSpec_DiscreteValueSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{2, 1, 3}
}

func (x *StudySpec_ParameterSpec_DiscreteValueSpec) GetValues() []float64 {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *StudySpec_ParameterSpec_DiscreteValueSpec) GetDefaultValue() float64 {
	if x != nil && x.DefaultValue != nil {
		return *x.DefaultValue
	}
	return 0
}

// Represents a parameter spec with condition from its parent parameter.
type StudySpec_ParameterSpec_ConditionalParameterSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A set of parameter values from the parent ParameterSpec's feasible
	// space.
	//
	// Types that are assignable to ParentValueCondition:
	//	*StudySpec_ParameterSpec_ConditionalParameterSpec_ParentDiscreteValues
	//	*StudySpec_ParameterSpec_ConditionalParameterSpec_ParentIntValues
	//	*StudySpec_ParameterSpec_ConditionalParameterSpec_ParentCategoricalValues
	ParentValueCondition isStudySpec_ParameterSpec_ConditionalParameterSpec_ParentValueCondition `protobuf_oneof:"parent_value_condition"`
	// Required. The spec for a conditional parameter.
	ParameterSpec *StudySpec_ParameterSpec `protobuf:"bytes,1,opt,name=parameter_spec,json=parameterSpec,proto3" json:"parameter_spec,omitempty"`
}

func (x *StudySpec_ParameterSpec_ConditionalParameterSpec) Reset() {
	*x = StudySpec_ParameterSpec_ConditionalParameterSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StudySpec_ParameterSpec_ConditionalParameterSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StudySpec_ParameterSpec_ConditionalParameterSpec) ProtoMessage() {}

func (x *StudySpec_ParameterSpec_ConditionalParameterSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StudySpec_ParameterSpec_ConditionalParameterSpec.ProtoReflect.Descriptor instead.
func (*StudySpec_ParameterSpec_ConditionalParameterSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{2, 1, 4}
}

func (m *StudySpec_ParameterSpec_ConditionalParameterSpec) GetParentValueCondition() isStudySpec_ParameterSpec_ConditionalParameterSpec_ParentValueCondition {
	if m != nil {
		return m.ParentValueCondition
	}
	return nil
}

func (x *StudySpec_ParameterSpec_ConditionalParameterSpec) GetParentDiscreteValues() *StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition {
	if x, ok := x.GetParentValueCondition().(*StudySpec_ParameterSpec_ConditionalParameterSpec_ParentDiscreteValues); ok {
		return x.ParentDiscreteValues
	}
	return nil
}

func (x *StudySpec_ParameterSpec_ConditionalParameterSpec) GetParentIntValues() *StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition {
	if x, ok := x.GetParentValueCondition().(*StudySpec_ParameterSpec_ConditionalParameterSpec_ParentIntValues); ok {
		return x.ParentIntValues
	}
	return nil
}

func (x *StudySpec_ParameterSpec_ConditionalParameterSpec) GetParentCategoricalValues() *StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition {
	if x, ok := x.GetParentValueCondition().(*StudySpec_ParameterSpec_ConditionalParameterSpec_ParentCategoricalValues); ok {
		return x.ParentCategoricalValues
	}
	return nil
}

func (x *StudySpec_ParameterSpec_ConditionalParameterSpec) GetParameterSpec() *StudySpec_ParameterSpec {
	if x != nil {
		return x.ParameterSpec
	}
	return nil
}

type isStudySpec_ParameterSpec_ConditionalParameterSpec_ParentValueCondition interface {
	isStudySpec_ParameterSpec_ConditionalParameterSpec_ParentValueCondition()
}

type StudySpec_ParameterSpec_ConditionalParameterSpec_ParentDiscreteValues struct {
	// The spec for matching values from a parent parameter of
	// `DISCRETE` type.
	ParentDiscreteValues *StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition `protobuf:"bytes,2,opt,name=parent_discrete_values,json=parentDiscreteValues,proto3,oneof"`
}

type StudySpec_ParameterSpec_ConditionalParameterSpec_ParentIntValues struct {
	// The spec for matching values from a parent parameter of `INTEGER`
	// type.
	ParentIntValues *StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition `protobuf:"bytes,3,opt,name=parent_int_values,json=parentIntValues,proto3,oneof"`
}

type StudySpec_ParameterSpec_ConditionalParameterSpec_ParentCategoricalValues struct {
	// The spec for matching values from a parent parameter of
	// `CATEGORICAL` type.
	ParentCategoricalValues *StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition `protobuf:"bytes,4,opt,name=parent_categorical_values,json=parentCategoricalValues,proto3,oneof"`
}

func (*StudySpec_ParameterSpec_ConditionalParameterSpec_ParentDiscreteValues) isStudySpec_ParameterSpec_ConditionalParameterSpec_ParentValueCondition() {
}

func (*StudySpec_ParameterSpec_ConditionalParameterSpec_ParentIntValues) isStudySpec_ParameterSpec_ConditionalParameterSpec_ParentValueCondition() {
}

func (*StudySpec_ParameterSpec_ConditionalParameterSpec_ParentCategoricalValues) isStudySpec_ParameterSpec_ConditionalParameterSpec_ParentValueCondition() {
}

// Represents the spec to match discrete values from parent parameter.
type StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Matches values of the parent parameter of 'DISCRETE' type.
	// All values must exist in `discrete_value_spec` of parent parameter.
	//
	// The Epsilon of the value matching is 1e-10.
	Values []float64 `protobuf:"fixed64,1,rep,packed,name=values,proto3" json:"values,omitempty"`
}

func (x *StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition) Reset() {
	*x = StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition) ProtoMessage() {}

func (x *StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition.ProtoReflect.Descriptor instead.
func (*StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{2, 1, 4, 0}
}

func (x *StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition) GetValues() []float64 {
	if x != nil {
		return x.Values
	}
	return nil
}

// Represents the spec to match integer values from parent parameter.
type StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Matches values of the parent parameter of 'INTEGER' type.
	// All values must lie in `integer_value_spec` of parent parameter.
	Values []int64 `protobuf:"varint,1,rep,packed,name=values,proto3" json:"values,omitempty"`
}

func (x *StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition) Reset() {
	*x = StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition) ProtoMessage() {}

func (x *StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition.ProtoReflect.Descriptor instead.
func (*StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{2, 1, 4, 1}
}

func (x *StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition) GetValues() []int64 {
	if x != nil {
		return x.Values
	}
	return nil
}

// Represents the spec to match categorical values from parent parameter.
type StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Matches values of the parent parameter of 'CATEGORICAL' type.
	// All values must exist in `categorical_value_spec` of parent
	// parameter.
	Values []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition) Reset() {
	*x = StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition) ProtoMessage() {}

func (x *StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition.ProtoReflect.Descriptor instead.
func (*StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{2, 1, 4, 2}
}

func (x *StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// A message representing a metric in the measurement.
type Measurement_Metric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The ID of the Metric. The Metric should be defined in
	// [StudySpec's Metrics][google.cloud.aiplatform.v1.StudySpec.metrics].
	MetricId string `protobuf:"bytes,1,opt,name=metric_id,json=metricId,proto3" json:"metric_id,omitempty"`
	// Output only. The value for this metric.
	Value float64 `protobuf:"fixed64,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Measurement_Metric) Reset() {
	*x = Measurement_Metric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Measurement_Metric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Measurement_Metric) ProtoMessage() {}

func (x *Measurement_Metric) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_study_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Measurement_Metric.ProtoReflect.Descriptor instead.
func (*Measurement_Metric) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP(), []int{3, 0}
}

func (x *Measurement_Metric) GetMetricId() string {
	if x != nil {
		return x.MetricId
	}
	return ""
}

func (x *Measurement_Metric) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

var File_google_cloud_aiplatform_v1_study_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_study_proto_rawDesc = []byte{
	0x0a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x74, 0x75,
	0x64, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xef, 0x03,
	0x0a, 0x05, 0x53, 0x74, 0x75, 0x64, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x0a, 0x73, 0x74, 0x75, 0x64,
	0x79, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64, 0x79, 0x53,
	0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x73, 0x74, 0x75, 0x64, 0x79, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x42, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x74, 0x75, 0x64, 0x79, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x69, 0x6e, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x69, 0x6e, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x22, 0x47, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56,
	0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10,
	0x02, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x03,
	0x3a, 0x5d, 0xea, 0x41, 0x5a, 0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x74, 0x75, 0x64, 0x79, 0x12, 0x37, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x73, 0x74, 0x75, 0x64, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x74, 0x75, 0x64, 0x79, 0x7d, 0x22,
	0xf7, 0x08, 0x0a, 0x05, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x42, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x50, 0x0a, 0x0a, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69,
	0x61, 0x6c, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x59, 0x0a,
	0x11, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x4d, 0x65, 0x61,
	0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x0c, 0x6d, 0x65, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x6d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65,
	0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x11, 0x69, 0x6e, 0x66, 0x65,
	0x61, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x69, 0x6e, 0x66, 0x65, 0x61, 0x73,
	0x69, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x0a, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b,
	0xe0, 0x41, 0x03, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4a, 0x6f, 0x62, 0x52, 0x09, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4a, 0x6f, 0x62, 0x12, 0x61, 0x0a, 0x0f, 0x77, 0x65, 0x62, 0x5f, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69,
	0x61, 0x6c, 0x2e, 0x57, 0x65, 0x62, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x55, 0x72, 0x69, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x77, 0x65, 0x62, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x55, 0x72, 0x69, 0x73, 0x1a, 0x66, 0x0a, 0x09, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x26, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x31,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x1a, 0x40, 0x0a, 0x12, 0x57, 0x65, 0x62, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x55, 0x72,
	0x69, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x66, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x45, 0x44,
	0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0c,
	0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09,
	0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x49,
	0x4e, 0x46, 0x45, 0x41, 0x53, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x05, 0x3a, 0x6c, 0xea, 0x41, 0x69,
	0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x69, 0x61,
	0x6c, 0x12, 0x46, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x74, 0x75, 0x64, 0x69,
	0x65, 0x73, 0x2f, 0x7b, 0x73, 0x74, 0x75, 0x64, 0x79, 0x7d, 0x2f, 0x74, 0x72, 0x69, 0x61, 0x6c,
	0x73, 0x2f, 0x7b, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x7d, 0x22, 0xb6, 0x1c, 0x0a, 0x09, 0x53, 0x74,
	0x75, 0x64, 0x79, 0x53, 0x70, 0x65, 0x63, 0x12, 0x82, 0x01, 0x0a, 0x19, 0x64, 0x65, 0x63, 0x61,
	0x79, 0x5f, 0x63, 0x75, 0x72, 0x76, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64, 0x79, 0x53, 0x70,
	0x65, 0x63, 0x2e, 0x44, 0x65, 0x63, 0x61, 0x79, 0x43, 0x75, 0x72, 0x76, 0x65, 0x41, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x70,
	0x65, 0x63, 0x48, 0x00, 0x52, 0x16, 0x64, 0x65, 0x63, 0x61, 0x79, 0x43, 0x75, 0x72, 0x76, 0x65,
	0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x12, 0x88, 0x01, 0x0a,
	0x1e, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x6e, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x73, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64, 0x79, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x65, 0x64,
	0x69, 0x61, 0x6e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x53, 0x74, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x1b, 0x6d, 0x65, 0x64, 0x69,
	0x61, 0x6e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x53, 0x74, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x12, 0x4f, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64, 0x79, 0x53, 0x70, 0x65, 0x63, 0x2e,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x58, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64, 0x79, 0x53,
	0x70, 0x65, 0x63, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65,
	0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x12, 0x4d, 0x0a, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64, 0x79, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x41, 0x6c, 0x67,
	0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x52, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68,
	0x6d, 0x12, 0x63, 0x0a, 0x11, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6e, 0x6f, 0x69, 0x73, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64, 0x79, 0x53,
	0x70, 0x65, 0x63, 0x2e, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e,
	0x6f, 0x69, 0x73, 0x65, 0x52, 0x10, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4e, 0x6f, 0x69, 0x73, 0x65, 0x12, 0x7c, 0x0a, 0x1a, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64, 0x79, 0x53, 0x70, 0x65,
	0x63, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x18, 0x6d, 0x65, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x1a, 0xc5, 0x01, 0x0a, 0x0a, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x49, 0x64, 0x12, 0x52, 0x0a, 0x04, 0x67, 0x6f, 0x61, 0x6c, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x74, 0x75, 0x64, 0x79, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x47, 0x6f, 0x61, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x04, 0x67, 0x6f, 0x61, 0x6c, 0x22, 0x41, 0x0a, 0x08, 0x47, 0x6f, 0x61,
	0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x47, 0x4f, 0x41, 0x4c, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0c, 0x0a, 0x08, 0x4d, 0x41, 0x58, 0x49, 0x4d, 0x49, 0x5a, 0x45, 0x10, 0x01, 0x12, 0x0c,
	0x0a, 0x08, 0x4d, 0x49, 0x4e, 0x49, 0x4d, 0x49, 0x5a, 0x45, 0x10, 0x02, 0x1a, 0xa8, 0x11, 0x0a,
	0x0d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12, 0x71,
	0x0a, 0x11, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64, 0x79, 0x53, 0x70, 0x65, 0x63,
	0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x44,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00,
	0x52, 0x0f, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x74, 0x0a, 0x12, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64, 0x79,
	0x53, 0x70, 0x65, 0x63, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70,
	0x65, 0x63, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53,
	0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x10, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x80, 0x01, 0x0a, 0x16, 0x63, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64, 0x79, 0x53, 0x70, 0x65, 0x63, 0x2e,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x70,
	0x65, 0x63, 0x48, 0x00, 0x52, 0x14, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61,
	0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x77, 0x0a, 0x13, 0x64, 0x69,
	0x73, 0x63, 0x72, 0x65, 0x74, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64, 0x79, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x44, 0x69, 0x73,
	0x63, 0x72, 0x65, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00,
	0x52, 0x11, 0x64, 0x69, 0x73, 0x63, 0x72, 0x65, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x26, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x5c, 0x0a, 0x0a, 0x73,
	0x63, 0x61, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x75,
	0x64, 0x79, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x53, 0x70, 0x65, 0x63, 0x2e, 0x53, 0x63, 0x61, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09,
	0x73, 0x63, 0x61, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x8c, 0x01, 0x0a, 0x1b, 0x63, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x75,
	0x64, 0x79, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x53, 0x70, 0x65, 0x63, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x52, 0x19, 0x63,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x73, 0x1a, 0x91, 0x01, 0x0a, 0x0f, 0x44, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x20, 0x0a, 0x09,
	0x6d, 0x69, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x20,
	0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x01, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x28, 0x0a, 0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x0c, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x92, 0x01, 0x0a,
	0x10, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6d, 0x61, 0x78,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0c,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x42,
	0x10, 0x0a, 0x0e, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x1a, 0x6f, 0x0a, 0x14, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1b, 0x0a, 0x06, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x0c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01,
	0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x1a, 0x6c, 0x0a, 0x11, 0x44, 0x69, 0x73, 0x63, 0x72, 0x65, 0x74, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1b, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x0c, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x42, 0x10,
	0x0a, 0x0e, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x1a, 0x8c, 0x06, 0x0a, 0x18, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12, 0x9b, 0x01,
	0x0a, 0x16, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x72, 0x65, 0x74,
	0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x63,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64,
	0x79, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53,
	0x70, 0x65, 0x63, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x44, 0x69, 0x73,
	0x63, 0x72, 0x65, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x14, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73,
	0x63, 0x72, 0x65, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x8c, 0x01, 0x0a, 0x11,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64, 0x79, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x49, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x49, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0xa4, 0x01, 0x0a, 0x19, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61,
	0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x66,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64,
	0x79, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53,
	0x70, 0x65, 0x63, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x17, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x12, 0x5f, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64, 0x79, 0x53, 0x70, 0x65, 0x63,
	0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70,
	0x65, 0x63, 0x1a, 0x35, 0x0a, 0x16, 0x44, 0x69, 0x73, 0x63, 0x72, 0x65, 0x74, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x06,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x30, 0x0a, 0x11, 0x49, 0x6e, 0x74,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b,
	0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x03, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x38, 0x0a, 0x19, 0x43,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0x18, 0x0a, 0x16, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x6e, 0x0a, 0x09, 0x53, 0x63, 0x61, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16,
	0x53, 0x43, 0x41, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x55, 0x4e, 0x49, 0x54,
	0x5f, 0x4c, 0x49, 0x4e, 0x45, 0x41, 0x52, 0x5f, 0x53, 0x43, 0x41, 0x4c, 0x45, 0x10, 0x01, 0x12,
	0x12, 0x0a, 0x0e, 0x55, 0x4e, 0x49, 0x54, 0x5f, 0x4c, 0x4f, 0x47, 0x5f, 0x53, 0x43, 0x41, 0x4c,
	0x45, 0x10, 0x02, 0x12, 0x1a, 0x0a, 0x16, 0x55, 0x4e, 0x49, 0x54, 0x5f, 0x52, 0x45, 0x56, 0x45,
	0x52, 0x53, 0x45, 0x5f, 0x4c, 0x4f, 0x47, 0x5f, 0x53, 0x43, 0x41, 0x4c, 0x45, 0x10, 0x03, 0x42,
	0x16, 0x0a, 0x14, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x1a, 0x53, 0x0a, 0x1f, 0x44, 0x65, 0x63, 0x61, 0x79,
	0x43, 0x75, 0x72, 0x76, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x53, 0x74,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x12, 0x30, 0x0a, 0x14, 0x75, 0x73,
	0x65, 0x5f, 0x65, 0x6c, 0x61, 0x70, 0x73, 0x65, 0x64, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x75, 0x73, 0x65, 0x45, 0x6c, 0x61,
	0x70, 0x73, 0x65, 0x64, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x4f, 0x0a, 0x1b,
	0x4d, 0x65, 0x64, 0x69, 0x61, 0x6e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x53,
	0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x12, 0x30, 0x0a, 0x14, 0x75,
	0x73, 0x65, 0x5f, 0x65, 0x6c, 0x61, 0x70, 0x73, 0x65, 0x64, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x75, 0x73, 0x65, 0x45, 0x6c,
	0x61, 0x70, 0x73, 0x65, 0x64, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4a, 0x0a,
	0x09, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x19, 0x0a, 0x15, 0x41, 0x4c,
	0x47, 0x4f, 0x52, 0x49, 0x54, 0x48, 0x4d, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x47, 0x52, 0x49, 0x44, 0x5f, 0x53, 0x45,
	0x41, 0x52, 0x43, 0x48, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x41, 0x4e, 0x44, 0x4f, 0x4d,
	0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x10, 0x03, 0x22, 0x48, 0x0a, 0x10, 0x4f, 0x62, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x69, 0x73, 0x65, 0x12, 0x21, 0x0a,
	0x1d, 0x4f, 0x42, 0x53, 0x45, 0x52, 0x56, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4e, 0x4f, 0x49,
	0x53, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x07, 0x0a, 0x03, 0x4c, 0x4f, 0x57, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x49, 0x47,
	0x48, 0x10, 0x02, 0x22, 0x72, 0x0a, 0x18, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x2a, 0x0a, 0x26, 0x4d, 0x45, 0x41, 0x53, 0x55, 0x52, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x53,
	0x45, 0x4c, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x4c,
	0x41, 0x53, 0x54, 0x5f, 0x4d, 0x45, 0x41, 0x53, 0x55, 0x52, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x10,
	0x01, 0x12, 0x14, 0x0a, 0x10, 0x42, 0x45, 0x53, 0x54, 0x5f, 0x4d, 0x45, 0x41, 0x53, 0x55, 0x52,
	0x45, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x42, 0x19, 0x0a, 0x17, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x22, 0x92, 0x02, 0x0a, 0x0b, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x49, 0x0a, 0x10, 0x65, 0x6c, 0x61, 0x70, 0x73, 0x65, 0x64, 0x5f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x65, 0x6c,
	0x61, 0x70, 0x73, 0x65, 0x64, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a,
	0x0a, 0x73, 0x74, 0x65, 0x70, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x65, 0x70, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x4d, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x1a, 0x45, 0x0a, 0x06, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0xce, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x42, 0x0a, 0x53, 0x74, 0x75, 0x64,
	0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x76, 0x31, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0xaa, 0x02,
	0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49,
	0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1_study_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_study_proto_rawDescData = file_google_cloud_aiplatform_v1_study_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_study_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_study_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_study_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_study_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_study_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_study_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_google_cloud_aiplatform_v1_study_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_google_cloud_aiplatform_v1_study_proto_goTypes = []interface{}{
	(Study_State)(0),                                         // 0: google.cloud.aiplatform.v1.Study.State
	(Trial_State)(0),                                         // 1: google.cloud.aiplatform.v1.Trial.State
	(StudySpec_Algorithm)(0),                                 // 2: google.cloud.aiplatform.v1.StudySpec.Algorithm
	(StudySpec_ObservationNoise)(0),                          // 3: google.cloud.aiplatform.v1.StudySpec.ObservationNoise
	(StudySpec_MeasurementSelectionType)(0),                  // 4: google.cloud.aiplatform.v1.StudySpec.MeasurementSelectionType
	(StudySpec_MetricSpec_GoalType)(0),                       // 5: google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType
	(StudySpec_ParameterSpec_ScaleType)(0),                   // 6: google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType
	(*Study)(nil),                                            // 7: google.cloud.aiplatform.v1.Study
	(*Trial)(nil),                                            // 8: google.cloud.aiplatform.v1.Trial
	(*StudySpec)(nil),                                        // 9: google.cloud.aiplatform.v1.StudySpec
	(*Measurement)(nil),                                      // 10: google.cloud.aiplatform.v1.Measurement
	(*Trial_Parameter)(nil),                                  // 11: google.cloud.aiplatform.v1.Trial.Parameter
	nil,                                                      // 12: google.cloud.aiplatform.v1.Trial.WebAccessUrisEntry
	(*StudySpec_MetricSpec)(nil),                             // 13: google.cloud.aiplatform.v1.StudySpec.MetricSpec
	(*StudySpec_ParameterSpec)(nil),                          // 14: google.cloud.aiplatform.v1.StudySpec.ParameterSpec
	(*StudySpec_DecayCurveAutomatedStoppingSpec)(nil),        // 15: google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
	(*StudySpec_MedianAutomatedStoppingSpec)(nil),            // 16: google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec
	(*StudySpec_ParameterSpec_DoubleValueSpec)(nil),          // 17: google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
	(*StudySpec_ParameterSpec_IntegerValueSpec)(nil),         // 18: google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
	(*StudySpec_ParameterSpec_CategoricalValueSpec)(nil),     // 19: google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
	(*StudySpec_ParameterSpec_DiscreteValueSpec)(nil),        // 20: google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
	(*StudySpec_ParameterSpec_ConditionalParameterSpec)(nil), // 21: google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
	(*StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition)(nil),    // 22: google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition
	(*StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition)(nil),         // 23: google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition
	(*StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition)(nil), // 24: google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition
	(*Measurement_Metric)(nil),    // 25: google.cloud.aiplatform.v1.Measurement.Metric
	(*timestamppb.Timestamp)(nil), // 26: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),   // 27: google.protobuf.Duration
	(*structpb.Value)(nil),        // 28: google.protobuf.Value
}
var file_google_cloud_aiplatform_v1_study_proto_depIdxs = []int32{
	9,  // 0: google.cloud.aiplatform.v1.Study.study_spec:type_name -> google.cloud.aiplatform.v1.StudySpec
	0,  // 1: google.cloud.aiplatform.v1.Study.state:type_name -> google.cloud.aiplatform.v1.Study.State
	26, // 2: google.cloud.aiplatform.v1.Study.create_time:type_name -> google.protobuf.Timestamp
	1,  // 3: google.cloud.aiplatform.v1.Trial.state:type_name -> google.cloud.aiplatform.v1.Trial.State
	11, // 4: google.cloud.aiplatform.v1.Trial.parameters:type_name -> google.cloud.aiplatform.v1.Trial.Parameter
	10, // 5: google.cloud.aiplatform.v1.Trial.final_measurement:type_name -> google.cloud.aiplatform.v1.Measurement
	10, // 6: google.cloud.aiplatform.v1.Trial.measurements:type_name -> google.cloud.aiplatform.v1.Measurement
	26, // 7: google.cloud.aiplatform.v1.Trial.start_time:type_name -> google.protobuf.Timestamp
	26, // 8: google.cloud.aiplatform.v1.Trial.end_time:type_name -> google.protobuf.Timestamp
	12, // 9: google.cloud.aiplatform.v1.Trial.web_access_uris:type_name -> google.cloud.aiplatform.v1.Trial.WebAccessUrisEntry
	15, // 10: google.cloud.aiplatform.v1.StudySpec.decay_curve_stopping_spec:type_name -> google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
	16, // 11: google.cloud.aiplatform.v1.StudySpec.median_automated_stopping_spec:type_name -> google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec
	13, // 12: google.cloud.aiplatform.v1.StudySpec.metrics:type_name -> google.cloud.aiplatform.v1.StudySpec.MetricSpec
	14, // 13: google.cloud.aiplatform.v1.StudySpec.parameters:type_name -> google.cloud.aiplatform.v1.StudySpec.ParameterSpec
	2,  // 14: google.cloud.aiplatform.v1.StudySpec.algorithm:type_name -> google.cloud.aiplatform.v1.StudySpec.Algorithm
	3,  // 15: google.cloud.aiplatform.v1.StudySpec.observation_noise:type_name -> google.cloud.aiplatform.v1.StudySpec.ObservationNoise
	4,  // 16: google.cloud.aiplatform.v1.StudySpec.measurement_selection_type:type_name -> google.cloud.aiplatform.v1.StudySpec.MeasurementSelectionType
	27, // 17: google.cloud.aiplatform.v1.Measurement.elapsed_duration:type_name -> google.protobuf.Duration
	25, // 18: google.cloud.aiplatform.v1.Measurement.metrics:type_name -> google.cloud.aiplatform.v1.Measurement.Metric
	28, // 19: google.cloud.aiplatform.v1.Trial.Parameter.value:type_name -> google.protobuf.Value
	5,  // 20: google.cloud.aiplatform.v1.StudySpec.MetricSpec.goal:type_name -> google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType
	17, // 21: google.cloud.aiplatform.v1.StudySpec.ParameterSpec.double_value_spec:type_name -> google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
	18, // 22: google.cloud.aiplatform.v1.StudySpec.ParameterSpec.integer_value_spec:type_name -> google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
	19, // 23: google.cloud.aiplatform.v1.StudySpec.ParameterSpec.categorical_value_spec:type_name -> google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
	20, // 24: google.cloud.aiplatform.v1.StudySpec.ParameterSpec.discrete_value_spec:type_name -> google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
	6,  // 25: google.cloud.aiplatform.v1.StudySpec.ParameterSpec.scale_type:type_name -> google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType
	21, // 26: google.cloud.aiplatform.v1.StudySpec.ParameterSpec.conditional_parameter_specs:type_name -> google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
	22, // 27: google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.parent_discrete_values:type_name -> google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition
	23, // 28: google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.parent_int_values:type_name -> google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition
	24, // 29: google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.parent_categorical_values:type_name -> google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition
	14, // 30: google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.parameter_spec:type_name -> google.cloud.aiplatform.v1.StudySpec.ParameterSpec
	31, // [31:31] is the sub-list for method output_type
	31, // [31:31] is the sub-list for method input_type
	31, // [31:31] is the sub-list for extension type_name
	31, // [31:31] is the sub-list for extension extendee
	0,  // [0:31] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_study_proto_init() }
func file_google_cloud_aiplatform_v1_study_proto_init() {
	if File_google_cloud_aiplatform_v1_study_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1_study_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Study); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_study_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trial); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_study_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StudySpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_study_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Measurement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_study_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trial_Parameter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_study_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StudySpec_MetricSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_study_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StudySpec_ParameterSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_study_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StudySpec_DecayCurveAutomatedStoppingSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_study_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StudySpec_MedianAutomatedStoppingSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_study_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StudySpec_ParameterSpec_DoubleValueSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_study_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StudySpec_ParameterSpec_IntegerValueSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_study_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StudySpec_ParameterSpec_CategoricalValueSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_study_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StudySpec_ParameterSpec_DiscreteValueSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_study_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StudySpec_ParameterSpec_ConditionalParameterSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_study_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_study_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_study_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_study_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Measurement_Metric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1_study_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*StudySpec_DecayCurveStoppingSpec)(nil),
		(*StudySpec_MedianAutomatedStoppingSpec_)(nil),
	}
	file_google_cloud_aiplatform_v1_study_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*StudySpec_ParameterSpec_DoubleValueSpec_)(nil),
		(*StudySpec_ParameterSpec_IntegerValueSpec_)(nil),
		(*StudySpec_ParameterSpec_CategoricalValueSpec_)(nil),
		(*StudySpec_ParameterSpec_DiscreteValueSpec_)(nil),
	}
	file_google_cloud_aiplatform_v1_study_proto_msgTypes[10].OneofWrappers = []interface{}{}
	file_google_cloud_aiplatform_v1_study_proto_msgTypes[11].OneofWrappers = []interface{}{}
	file_google_cloud_aiplatform_v1_study_proto_msgTypes[12].OneofWrappers = []interface{}{}
	file_google_cloud_aiplatform_v1_study_proto_msgTypes[13].OneofWrappers = []interface{}{}
	file_google_cloud_aiplatform_v1_study_proto_msgTypes[14].OneofWrappers = []interface{}{
		(*StudySpec_ParameterSpec_ConditionalParameterSpec_ParentDiscreteValues)(nil),
		(*StudySpec_ParameterSpec_ConditionalParameterSpec_ParentIntValues)(nil),
		(*StudySpec_ParameterSpec_ConditionalParameterSpec_ParentCategoricalValues)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_study_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_study_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_study_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1_study_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1_study_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_study_proto = out.File
	file_google_cloud_aiplatform_v1_study_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_study_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_study_proto_depIdxs = nil
}
