// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/resourcemanager/v3/organizations.proto

package resourcemanagerpb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Organizations_GetOrganization_FullMethodName     = "/google.cloud.resourcemanager.v3.Organizations/GetOrganization"
	Organizations_SearchOrganizations_FullMethodName = "/google.cloud.resourcemanager.v3.Organizations/SearchOrganizations"
	Organizations_GetIamPolicy_FullMethodName        = "/google.cloud.resourcemanager.v3.Organizations/GetIamPolicy"
	Organizations_SetIamPolicy_FullMethodName        = "/google.cloud.resourcemanager.v3.Organizations/SetIamPolicy"
	Organizations_TestIamPermissions_FullMethodName  = "/google.cloud.resourcemanager.v3.Organizations/TestIamPermissions"
)

// OrganizationsClient is the client API for Organizations service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type OrganizationsClient interface {
	// Fetches an organization resource identified by the specified resource name.
	GetOrganization(ctx context.Context, in *GetOrganizationRequest, opts ...grpc.CallOption) (*Organization, error)
	// Searches organization resources that are visible to the user and satisfy
	// the specified filter. This method returns organizations in an unspecified
	// order. New organizations do not necessarily appear at the end of the
	// results, and may take a small amount of time to appear.
	//
	// Search will only return organizations on which the user has the permission
	// `resourcemanager.organizations.get`
	SearchOrganizations(ctx context.Context, in *SearchOrganizationsRequest, opts ...grpc.CallOption) (*SearchOrganizationsResponse, error)
	// Gets the access control policy for an organization resource. The policy may
	// be empty if no such policy or resource exists. The `resource` field should
	// be the organization's resource name, for example: "organizations/123".
	//
	// Authorization requires the IAM permission
	// `resourcemanager.organizations.getIamPolicy` on the specified organization.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Sets the access control policy on an organization resource. Replaces any
	// existing policy. The `resource` field should be the organization's resource
	// name, for example: "organizations/123".
	//
	// Authorization requires the IAM permission
	// `resourcemanager.organizations.setIamPolicy` on the specified organization.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns the permissions that a caller has on the specified organization.
	// The `resource` field should be the organization's resource name,
	// for example: "organizations/123".
	//
	// There are no permissions required for making this API call.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
}

type organizationsClient struct {
	cc grpc.ClientConnInterface
}

func NewOrganizationsClient(cc grpc.ClientConnInterface) OrganizationsClient {
	return &organizationsClient{cc}
}

func (c *organizationsClient) GetOrganization(ctx context.Context, in *GetOrganizationRequest, opts ...grpc.CallOption) (*Organization, error) {
	out := new(Organization)
	err := c.cc.Invoke(ctx, Organizations_GetOrganization_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *organizationsClient) SearchOrganizations(ctx context.Context, in *SearchOrganizationsRequest, opts ...grpc.CallOption) (*SearchOrganizationsResponse, error) {
	out := new(SearchOrganizationsResponse)
	err := c.cc.Invoke(ctx, Organizations_SearchOrganizations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *organizationsClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, Organizations_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *organizationsClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, Organizations_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *organizationsClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, Organizations_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// OrganizationsServer is the server API for Organizations service.
// All implementations should embed UnimplementedOrganizationsServer
// for forward compatibility
type OrganizationsServer interface {
	// Fetches an organization resource identified by the specified resource name.
	GetOrganization(context.Context, *GetOrganizationRequest) (*Organization, error)
	// Searches organization resources that are visible to the user and satisfy
	// the specified filter. This method returns organizations in an unspecified
	// order. New organizations do not necessarily appear at the end of the
	// results, and may take a small amount of time to appear.
	//
	// Search will only return organizations on which the user has the permission
	// `resourcemanager.organizations.get`
	SearchOrganizations(context.Context, *SearchOrganizationsRequest) (*SearchOrganizationsResponse, error)
	// Gets the access control policy for an organization resource. The policy may
	// be empty if no such policy or resource exists. The `resource` field should
	// be the organization's resource name, for example: "organizations/123".
	//
	// Authorization requires the IAM permission
	// `resourcemanager.organizations.getIamPolicy` on the specified organization.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Sets the access control policy on an organization resource. Replaces any
	// existing policy. The `resource` field should be the organization's resource
	// name, for example: "organizations/123".
	//
	// Authorization requires the IAM permission
	// `resourcemanager.organizations.setIamPolicy` on the specified organization.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Returns the permissions that a caller has on the specified organization.
	// The `resource` field should be the organization's resource name,
	// for example: "organizations/123".
	//
	// There are no permissions required for making this API call.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
}

// UnimplementedOrganizationsServer should be embedded to have forward compatible implementations.
type UnimplementedOrganizationsServer struct {
}

func (UnimplementedOrganizationsServer) GetOrganization(context.Context, *GetOrganizationRequest) (*Organization, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOrganization not implemented")
}
func (UnimplementedOrganizationsServer) SearchOrganizations(context.Context, *SearchOrganizationsRequest) (*SearchOrganizationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchOrganizations not implemented")
}
func (UnimplementedOrganizationsServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedOrganizationsServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedOrganizationsServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeOrganizationsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to OrganizationsServer will
// result in compilation errors.
type UnsafeOrganizationsServer interface {
	mustEmbedUnimplementedOrganizationsServer()
}

func RegisterOrganizationsServer(s grpc.ServiceRegistrar, srv OrganizationsServer) {
	s.RegisterService(&Organizations_ServiceDesc, srv)
}

func _Organizations_GetOrganization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOrganizationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrganizationsServer).GetOrganization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Organizations_GetOrganization_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrganizationsServer).GetOrganization(ctx, req.(*GetOrganizationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Organizations_SearchOrganizations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchOrganizationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrganizationsServer).SearchOrganizations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Organizations_SearchOrganizations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrganizationsServer).SearchOrganizations(ctx, req.(*SearchOrganizationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Organizations_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrganizationsServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Organizations_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrganizationsServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Organizations_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrganizationsServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Organizations_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrganizationsServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Organizations_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrganizationsServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Organizations_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrganizationsServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Organizations_ServiceDesc is the grpc.ServiceDesc for Organizations service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Organizations_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.resourcemanager.v3.Organizations",
	HandlerType: (*OrganizationsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetOrganization",
			Handler:    _Organizations_GetOrganization_Handler,
		},
		{
			MethodName: "SearchOrganizations",
			Handler:    _Organizations_SearchOrganizations_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _Organizations_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _Organizations_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _Organizations_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/resourcemanager/v3/organizations.proto",
}
