package main

import (
	"context"
	"log"

	"github.com/owenthereal/tmux"
)

func main() {
	ctx := context.Background()

	t, err := tmux.Default()
	if err != nil {
		log.Fatal(err)
	}

	session, err := t.New(ctx)
	if err != nil {
		log.Fatal(err)
	}

	// create new window
	window, err := session.New(ctx)
	if err != nil {
		log.Fatal(err)
	}

	// move the window to index 10
	err = window.Move(ctx, session.Name, 10)
	if err != nil {
		log.Fatal(err)
	}

	// list windows
	windows, err := session.ListWindows(ctx)
	if err != nil {
		log.Fatal(err)
	}

	// toggle selection
	for _, w := range windows {
		if !w.Active {
			err = w.Select(ctx)
			if err != nil {
				log.Fatal(err)
			}
			break
		}
	}

	// set layout
	err = window.SelectLayout(ctx, tmux.WindowLayoutEvenVertical)
	if err != nil {
		log.Fatal(err)
	}
}
