// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package firebaseml provides access to the Firebase ML API.
//
// For product documentation, see: https://firebase.google.com
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/firebaseml/v2beta"
//	...
//	ctx := context.Background()
//	firebasemlService, err := firebaseml.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	firebasemlService, err := firebaseml.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	firebasemlService, err := firebaseml.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package firebaseml // import "google.golang.org/api/firebaseml/v2beta"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "firebaseml:v2beta"
const apiName = "firebaseml"
const apiVersion = "v2beta"
const basePath = "https://firebaseml.googleapis.com/"
const basePathTemplate = "https://firebaseml.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://firebaseml.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Publishers = NewProjectsLocationsPublishersService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Publishers *ProjectsLocationsPublishersService
}

func NewProjectsLocationsPublishersService(s *Service) *ProjectsLocationsPublishersService {
	rs := &ProjectsLocationsPublishersService{s: s}
	rs.Models = NewProjectsLocationsPublishersModelsService(s)
	return rs
}

type ProjectsLocationsPublishersService struct {
	s *Service

	Models *ProjectsLocationsPublishersModelsService
}

func NewProjectsLocationsPublishersModelsService(s *Service) *ProjectsLocationsPublishersModelsService {
	rs := &ProjectsLocationsPublishersModelsService{s: s}
	return rs
}

type ProjectsLocationsPublishersModelsService struct {
	s *Service
}

// Date: Represents a whole or partial calendar date, such as a birthday. The
// time of day and time zone are either specified elsewhere or are
// insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type Date struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Date) MarshalJSON() ([]byte, error) {
	type NoMethod Date
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ApiAuth: The generic reusable api auth config.
// Deprecated. Please use AuthConfig
// (google/cloud/aiplatform/master/auth.proto) instead.
type GoogleCloudAiplatformV1beta1ApiAuth struct {
	// ApiKeyConfig: The API secret.
	ApiKeyConfig *GoogleCloudAiplatformV1beta1ApiAuthApiKeyConfig `json:"apiKeyConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKeyConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeyConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ApiAuth) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ApiAuth
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ApiAuthApiKeyConfig: The API secret.
type GoogleCloudAiplatformV1beta1ApiAuthApiKeyConfig struct {
	// ApiKeySecretVersion: Required. The SecretManager secret version resource
	// name storing API key. e.g.
	// projects/{project}/secrets/{secret}/versions/{version}
	ApiKeySecretVersion string `json:"apiKeySecretVersion,omitempty"`
	// ApiKeyString: The API key string. Either this or `api_key_secret_version`
	// must be set.
	ApiKeyString string `json:"apiKeyString,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKeySecretVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeySecretVersion") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ApiAuthApiKeyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ApiAuthApiKeyConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AuthConfig: Auth configuration to run the
// extension.
type GoogleCloudAiplatformV1beta1AuthConfig struct {
	// ApiKeyConfig: Config for API key auth.
	ApiKeyConfig *GoogleCloudAiplatformV1beta1AuthConfigApiKeyConfig `json:"apiKeyConfig,omitempty"`
	// AuthType: Type of auth scheme.
	//
	// Possible values:
	//   "AUTH_TYPE_UNSPECIFIED"
	//   "NO_AUTH" - No Auth.
	//   "API_KEY_AUTH" - API Key Auth.
	//   "HTTP_BASIC_AUTH" - HTTP Basic Auth.
	//   "GOOGLE_SERVICE_ACCOUNT_AUTH" - Google Service Account Auth.
	//   "OAUTH" - OAuth auth.
	//   "OIDC_AUTH" - OpenID Connect (OIDC) Auth.
	AuthType string `json:"authType,omitempty"`
	// GoogleServiceAccountConfig: Config for Google Service Account auth.
	GoogleServiceAccountConfig *GoogleCloudAiplatformV1beta1AuthConfigGoogleServiceAccountConfig `json:"googleServiceAccountConfig,omitempty"`
	// HttpBasicAuthConfig: Config for HTTP Basic auth.
	HttpBasicAuthConfig *GoogleCloudAiplatformV1beta1AuthConfigHttpBasicAuthConfig `json:"httpBasicAuthConfig,omitempty"`
	// OauthConfig: Config for user oauth.
	OauthConfig *GoogleCloudAiplatformV1beta1AuthConfigOauthConfig `json:"oauthConfig,omitempty"`
	// OidcConfig: Config for user OIDC auth.
	OidcConfig *GoogleCloudAiplatformV1beta1AuthConfigOidcConfig `json:"oidcConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKeyConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeyConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AuthConfigApiKeyConfig: Config for
// authentication with API key.
type GoogleCloudAiplatformV1beta1AuthConfigApiKeyConfig struct {
	// ApiKeySecret: Optional. The name of the SecretManager secret version
	// resource storing the API key. Format:
	// `projects/{project}/secrets/{secrete}/versions/{version}` - If both
	// `api_key_secret` and `api_key_string` are specified, this field takes
	// precedence over `api_key_string`. - If specified, the
	// `secretmanager.versions.access` permission should be granted to Vertex AI
	// Extension Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// on the specified resource.
	ApiKeySecret string `json:"apiKeySecret,omitempty"`
	// ApiKeyString: Optional. The API key to be used in the request directly.
	ApiKeyString string `json:"apiKeyString,omitempty"`
	// HttpElementLocation: Optional. The location of the API key.
	//
	// Possible values:
	//   "HTTP_IN_UNSPECIFIED"
	//   "HTTP_IN_QUERY" - Element is in the HTTP request query.
	//   "HTTP_IN_HEADER" - Element is in the HTTP request header.
	//   "HTTP_IN_PATH" - Element is in the HTTP request path.
	//   "HTTP_IN_BODY" - Element is in the HTTP request body.
	//   "HTTP_IN_COOKIE" - Element is in the HTTP request cookie.
	HttpElementLocation string `json:"httpElementLocation,omitempty"`
	// Name: Optional. The parameter name of the API key. E.g. If the API request
	// is "https://example.com/act?api_key=", "api_key" would be the parameter
	// name.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKeySecret") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeySecret") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AuthConfigApiKeyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AuthConfigApiKeyConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AuthConfigGoogleServiceAccountConfig: Config for
// Google Service Account Authentication.
type GoogleCloudAiplatformV1beta1AuthConfigGoogleServiceAccountConfig struct {
	// ServiceAccount: Optional. The service account that the extension execution
	// service runs as. - If the service account is specified, the
	// `iam.serviceAccounts.getAccessToken` permission should be granted to Vertex
	// AI Extension Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// on the specified service account. - If not specified, the Vertex AI
	// Extension Service Agent will be used to execute the Extension.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceAccount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceAccount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AuthConfigGoogleServiceAccountConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AuthConfigGoogleServiceAccountConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AuthConfigHttpBasicAuthConfig: Config for HTTP
// Basic Authentication.
type GoogleCloudAiplatformV1beta1AuthConfigHttpBasicAuthConfig struct {
	// CredentialSecret: Required. The name of the SecretManager secret version
	// resource storing the base64 encoded credentials. Format:
	// `projects/{project}/secrets/{secrete}/versions/{version}` - If specified,
	// the `secretmanager.versions.access` permission should be granted to Vertex
	// AI Extension Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// on the specified resource.
	CredentialSecret string `json:"credentialSecret,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CredentialSecret") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CredentialSecret") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AuthConfigHttpBasicAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AuthConfigHttpBasicAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AuthConfigOauthConfig: Config for user oauth.
type GoogleCloudAiplatformV1beta1AuthConfigOauthConfig struct {
	// AccessToken: Access token for extension endpoint. Only used to propagate
	// token from [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
	AccessToken string `json:"accessToken,omitempty"`
	// ServiceAccount: The service account used to generate access tokens for
	// executing the Extension. - If the service account is specified, the
	// `iam.serviceAccounts.getAccessToken` permission should be granted to Vertex
	// AI Extension Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// on the provided service account.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AuthConfigOauthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AuthConfigOauthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AuthConfigOidcConfig: Config for user OIDC auth.
type GoogleCloudAiplatformV1beta1AuthConfigOidcConfig struct {
	// IdToken: OpenID Connect formatted ID token for extension endpoint. Only used
	// to propagate token from [[ExecuteExtensionRequest.runtime_auth_config]] at
	// request time.
	IdToken string `json:"idToken,omitempty"`
	// ServiceAccount: The service account used to generate an OpenID Connect
	// (OIDC)-compatible JWT token signed by the Google OIDC Provider
	// (accounts.google.com) for extension endpoint
	// (https://cloud.google.com/iam/docs/create-short-lived-credentials-direct#sa-credentials-oidc).
	// - The audience for the token will be set to the URL in the server url
	// defined in the OpenApi spec. - If the service account is provided, the
	// service account should grant `iam.serviceAccounts.getOpenIdToken` permission
	// to Vertex AI Extension Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents).
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IdToken") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IdToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AuthConfigOidcConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AuthConfigOidcConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Blob: A content blob. A Blob contains data of a
// specific media type. It is used to represent images, audio, and video.
type GoogleCloudAiplatformV1beta1Blob struct {
	// Data: Required. The raw bytes of the data.
	Data string `json:"data,omitempty"`
	// DisplayName: Optional. The display name of the blob. Used to provide a label
	// or filename to distinguish blobs. This field is only returned in
	// `PromptMessage` for prompt management. It is used in the Gemini calls only
	// when server-side tools (`code_execution`, `google_search`, and
	// `url_context`) are enabled.
	DisplayName string `json:"displayName,omitempty"`
	// MimeType: Required. The IANA standard MIME type of the source data.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Data") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Data") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Blob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Blob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Candidate: A response candidate generated from
// the model.
type GoogleCloudAiplatformV1beta1Candidate struct {
	// AvgLogprobs: Output only. The average log probability of the tokens in this
	// candidate. This is a length-normalized score that can be used to compare the
	// quality of candidates of different lengths. A higher average log probability
	// suggests a more confident and coherent response.
	AvgLogprobs float64 `json:"avgLogprobs,omitempty"`
	// CitationMetadata: Output only. A collection of citations that apply to the
	// generated content.
	CitationMetadata *GoogleCloudAiplatformV1beta1CitationMetadata `json:"citationMetadata,omitempty"`
	// Content: Output only. The content of the candidate.
	Content *GoogleCloudAiplatformV1beta1Content `json:"content,omitempty"`
	// FinishMessage: Output only. Describes the reason the model stopped
	// generating tokens in more detail. This field is returned only when
	// `finish_reason` is set.
	FinishMessage string `json:"finishMessage,omitempty"`
	// FinishReason: Output only. The reason why the model stopped generating
	// tokens. If empty, the model has not stopped generating.
	//
	// Possible values:
	//   "FINISH_REASON_UNSPECIFIED" - The finish reason is unspecified.
	//   "STOP" - The model reached a natural stopping point or a configured stop
	// sequence.
	//   "MAX_TOKENS" - The model generated the maximum number of tokens allowed by
	// the `max_output_tokens` parameter.
	//   "SAFETY" - The model stopped generating because the content potentially
	// violates safety policies. NOTE: When streaming, the `content` field is empty
	// if content filters block the output.
	//   "RECITATION" - The model stopped generating because the content may be a
	// recitation from a source.
	//   "OTHER" - The model stopped generating for a reason not otherwise
	// specified.
	//   "BLOCKLIST" - The model stopped generating because the content contains a
	// term from a configured blocklist.
	//   "PROHIBITED_CONTENT" - The model stopped generating because the content
	// may be prohibited.
	//   "SPII" - The model stopped generating because the content may contain
	// sensitive personally identifiable information (SPII).
	//   "MALFORMED_FUNCTION_CALL" - The model generated a function call that is
	// syntactically invalid and can't be parsed.
	//   "MODEL_ARMOR" - The model response was blocked by Model Armor.
	//   "IMAGE_SAFETY" - The generated image potentially violates safety policies.
	//   "IMAGE_PROHIBITED_CONTENT" - The generated image may contain prohibited
	// content.
	//   "IMAGE_RECITATION" - The generated image may be a recitation from a
	// source.
	//   "IMAGE_OTHER" - The image generation stopped for a reason not otherwise
	// specified.
	//   "UNEXPECTED_TOOL_CALL" - The model generated a function call that is
	// semantically invalid. This can happen, for example, if function calling is
	// not enabled or the generated function is not in the function declaration.
	//   "NO_IMAGE" - The model was expected to generate an image, but didn't.
	FinishReason string `json:"finishReason,omitempty"`
	// GroundingMetadata: Output only. Metadata returned when grounding is enabled.
	// It contains the sources used to ground the generated content.
	GroundingMetadata *GoogleCloudAiplatformV1beta1GroundingMetadata `json:"groundingMetadata,omitempty"`
	// Index: Output only. The 0-based index of this candidate in the list of
	// generated responses. This is useful for distinguishing between multiple
	// candidates when `candidate_count` > 1.
	Index int64 `json:"index,omitempty"`
	// LogprobsResult: Output only. The detailed log probability information for
	// the tokens in this candidate. This is useful for debugging, understanding
	// model uncertainty, and identifying potential "hallucinations".
	LogprobsResult *GoogleCloudAiplatformV1beta1LogprobsResult `json:"logprobsResult,omitempty"`
	// SafetyRatings: Output only. A list of ratings for the safety of a response
	// candidate. There is at most one rating per category.
	SafetyRatings []*GoogleCloudAiplatformV1beta1SafetyRating `json:"safetyRatings,omitempty"`
	// UrlContextMetadata: Output only. Metadata returned when the model uses the
	// `url_context` tool to get information from a user-provided URL.
	UrlContextMetadata *GoogleCloudAiplatformV1beta1UrlContextMetadata `json:"urlContextMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AvgLogprobs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AvgLogprobs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Candidate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Candidate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1Candidate) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1Candidate
	var s1 struct {
		AvgLogprobs gensupport.JSONFloat64 `json:"avgLogprobs"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AvgLogprobs = float64(s1.AvgLogprobs)
	return nil
}

// GoogleCloudAiplatformV1beta1Citation: A citation for a piece of
// generatedcontent.
type GoogleCloudAiplatformV1beta1Citation struct {
	// EndIndex: Output only. The end index of the citation in the content.
	EndIndex int64 `json:"endIndex,omitempty"`
	// License: Output only. The license of the source of the citation.
	License string `json:"license,omitempty"`
	// PublicationDate: Output only. The publication date of the source of the
	// citation.
	PublicationDate *Date `json:"publicationDate,omitempty"`
	// StartIndex: Output only. The start index of the citation in the content.
	StartIndex int64 `json:"startIndex,omitempty"`
	// Title: Output only. The title of the source of the citation.
	Title string `json:"title,omitempty"`
	// Uri: Output only. The URI of the source of the citation.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Citation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Citation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CitationMetadata: A collection of citations that
// apply to a piece of generated content.
type GoogleCloudAiplatformV1beta1CitationMetadata struct {
	// Citations: Output only. A list of citations for the content.
	Citations []*GoogleCloudAiplatformV1beta1Citation `json:"citations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Citations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Citations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CitationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CitationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CodeExecutionResult: Result of executing the
// [ExecutableCode]. Only generated when using the [CodeExecution] tool, and
// always follows a `part` containing the [ExecutableCode].
type GoogleCloudAiplatformV1beta1CodeExecutionResult struct {
	// Outcome: Required. Outcome of the code execution.
	//
	// Possible values:
	//   "OUTCOME_UNSPECIFIED" - Unspecified status. This value should not be used.
	//   "OUTCOME_OK" - Code execution completed successfully.
	//   "OUTCOME_FAILED" - Code execution finished but with a failure. `stderr`
	// should contain the reason.
	//   "OUTCOME_DEADLINE_EXCEEDED" - Code execution ran for too long, and was
	// cancelled. There may or may not be a partial output present.
	Outcome string `json:"outcome,omitempty"`
	// Output: Optional. Contains stdout when code execution is successful, stderr
	// or other description otherwise.
	Output string `json:"output,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Outcome") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Outcome") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CodeExecutionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CodeExecutionResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Content: The structured data content of a
// message. A Content message contains a `role` field, which indicates the
// producer of the content, and a `parts` field, which contains the multi-part
// data of the message.
type GoogleCloudAiplatformV1beta1Content struct {
	// Parts: Required. A list of Part objects that make up a single message. Parts
	// of a message can have different MIME types. A Content message must have at
	// least one Part.
	Parts []*GoogleCloudAiplatformV1beta1Part `json:"parts,omitempty"`
	// Role: Optional. The producer of the content. Must be either 'user' or
	// 'model'. If not set, the service will default to 'user'.
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parts") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Content) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Content
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CountTokensRequest: Request message for
// PredictionService.CountTokens.
type GoogleCloudAiplatformV1beta1CountTokensRequest struct {
	// Contents: Optional. Input content.
	Contents []*GoogleCloudAiplatformV1beta1Content `json:"contents,omitempty"`
	// GenerationConfig: Optional. Generation config that the model will use to
	// generate the response.
	GenerationConfig *GoogleCloudAiplatformV1beta1GenerationConfig `json:"generationConfig,omitempty"`
	// Instances: Optional. The instances that are the input to token counting
	// call. Schema is identical to the prediction schema of the underlying model.
	Instances []interface{} `json:"instances,omitempty"`
	// Model: Optional. The name of the publisher model requested to serve the
	// prediction. Format:
	// `projects/{project}/locations/{location}/publishers/*/models/*`
	Model string `json:"model,omitempty"`
	// SystemInstruction: Optional. The user provided system instructions for the
	// model. Note: only text should be used in parts and content in each part will
	// be in a separate paragraph.
	SystemInstruction *GoogleCloudAiplatformV1beta1Content `json:"systemInstruction,omitempty"`
	// Tools: Optional. A list of `Tools` the model may use to generate the next
	// response. A `Tool` is a piece of code that enables the system to interact
	// with external systems to perform an action, or set of actions, outside of
	// knowledge and scope of the model.
	Tools []*GoogleCloudAiplatformV1beta1Tool `json:"tools,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CountTokensRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CountTokensRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CountTokensResponse: Response message for
// PredictionService.CountTokens.
type GoogleCloudAiplatformV1beta1CountTokensResponse struct {
	// PromptTokensDetails: Output only. List of modalities that were processed in
	// the request input.
	PromptTokensDetails []*GoogleCloudAiplatformV1beta1ModalityTokenCount `json:"promptTokensDetails,omitempty"`
	// TotalBillableCharacters: The total number of billable characters counted
	// across all instances from the request.
	TotalBillableCharacters int64 `json:"totalBillableCharacters,omitempty"`
	// TotalTokens: The total number of tokens counted across all instances from
	// the request.
	TotalTokens int64 `json:"totalTokens,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "PromptTokensDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PromptTokensDetails") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CountTokensResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CountTokensResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DynamicRetrievalConfig: Describes the options to
// customize dynamic retrieval.
type GoogleCloudAiplatformV1beta1DynamicRetrievalConfig struct {
	// DynamicThreshold: Optional. The threshold to be used in dynamic retrieval.
	// If not set, a system default value is used.
	DynamicThreshold float64 `json:"dynamicThreshold,omitempty"`
	// Mode: The mode of the predictor to be used in dynamic retrieval.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Always trigger retrieval.
	//   "MODE_DYNAMIC" - Run retrieval only when system decides it is necessary.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DynamicThreshold") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DynamicThreshold") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DynamicRetrievalConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DynamicRetrievalConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1DynamicRetrievalConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1DynamicRetrievalConfig
	var s1 struct {
		DynamicThreshold gensupport.JSONFloat64 `json:"dynamicThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DynamicThreshold = float64(s1.DynamicThreshold)
	return nil
}

// GoogleCloudAiplatformV1beta1EnterpriseWebSearch: Tool to search public web
// data, powered by Vertex AI Search and Sec4 compliance.
type GoogleCloudAiplatformV1beta1EnterpriseWebSearch struct {
	// BlockingConfidence: Optional. Sites with confidence level chosen & above
	// this value will be blocked from the search results.
	//
	// Possible values:
	//   "PHISH_BLOCK_THRESHOLD_UNSPECIFIED" - Defaults to unspecified.
	//   "BLOCK_LOW_AND_ABOVE" - Blocks Low and above confidence URL that is risky.
	//   "BLOCK_MEDIUM_AND_ABOVE" - Blocks Medium and above confidence URL that is
	// risky.
	//   "BLOCK_HIGH_AND_ABOVE" - Blocks High and above confidence URL that is
	// risky.
	//   "BLOCK_HIGHER_AND_ABOVE" - Blocks Higher and above confidence URL that is
	// risky.
	//   "BLOCK_VERY_HIGH_AND_ABOVE" - Blocks Very high and above confidence URL
	// that is risky.
	//   "BLOCK_ONLY_EXTREMELY_HIGH" - Blocks Extremely high confidence URL that is
	// risky.
	BlockingConfidence string `json:"blockingConfidence,omitempty"`
	// ExcludeDomains: Optional. List of domains to be excluded from the search
	// results. The default limit is 2000 domains.
	ExcludeDomains []string `json:"excludeDomains,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlockingConfidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockingConfidence") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1EnterpriseWebSearch) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1EnterpriseWebSearch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExecutableCode: Code generated by the model that
// is meant to be executed, and the result returned to the model. Generated
// when using the [CodeExecution] tool, in which the code will be automatically
// executed, and a corresponding [CodeExecutionResult] will also be generated.
type GoogleCloudAiplatformV1beta1ExecutableCode struct {
	// Code: Required. The code to be executed.
	Code string `json:"code,omitempty"`
	// Language: Required. Programming language of the `code`.
	//
	// Possible values:
	//   "LANGUAGE_UNSPECIFIED" - Unspecified language. This value should not be
	// used.
	//   "PYTHON" - Python >= 3.10, with numpy and simpy available.
	Language string `json:"language,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExecutableCode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExecutableCode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExternalApi: Retrieve from data source powered
// by external API for grounding. The external API is not owned by Google, but
// need to follow the pre-defined API spec.
type GoogleCloudAiplatformV1beta1ExternalApi struct {
	// ApiAuth: The authentication config to access the API. Deprecated. Please use
	// auth_config instead.
	ApiAuth *GoogleCloudAiplatformV1beta1ApiAuth `json:"apiAuth,omitempty"`
	// ApiSpec: The API spec that the external API implements.
	//
	// Possible values:
	//   "API_SPEC_UNSPECIFIED" - Unspecified API spec. This value should not be
	// used.
	//   "SIMPLE_SEARCH" - Simple search API spec.
	//   "ELASTIC_SEARCH" - Elastic search API spec.
	ApiSpec string `json:"apiSpec,omitempty"`
	// AuthConfig: The authentication config to access the API.
	AuthConfig *GoogleCloudAiplatformV1beta1AuthConfig `json:"authConfig,omitempty"`
	// ElasticSearchParams: Parameters for the elastic search API.
	ElasticSearchParams *GoogleCloudAiplatformV1beta1ExternalApiElasticSearchParams `json:"elasticSearchParams,omitempty"`
	// Endpoint: The endpoint of the external API. The system will call the API at
	// this endpoint to retrieve the data for grounding. Example:
	// https://acme.com:443/search
	Endpoint string `json:"endpoint,omitempty"`
	// SimpleSearchParams: Parameters for the simple search API.
	SimpleSearchParams *GoogleCloudAiplatformV1beta1ExternalApiSimpleSearchParams `json:"simpleSearchParams,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiAuth") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiAuth") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExternalApi) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExternalApi
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExternalApiElasticSearchParams: The search
// parameters to use for the ELASTIC_SEARCH spec.
type GoogleCloudAiplatformV1beta1ExternalApiElasticSearchParams struct {
	// Index: The ElasticSearch index to use.
	Index string `json:"index,omitempty"`
	// NumHits: Optional. Number of hits (chunks) to request. When specified, it is
	// passed to Elasticsearch as the `num_hits` param.
	NumHits int64 `json:"numHits,omitempty"`
	// SearchTemplate: The ElasticSearch search template to use.
	SearchTemplate string `json:"searchTemplate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Index") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Index") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExternalApiElasticSearchParams) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExternalApiElasticSearchParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExternalApiSimpleSearchParams: The search
// parameters to use for SIMPLE_SEARCH spec.
type GoogleCloudAiplatformV1beta1ExternalApiSimpleSearchParams struct {
}

// GoogleCloudAiplatformV1beta1FileData: URI-based data. A FileData message
// contains a URI pointing to data of a specific media type. It is used to
// represent images, audio, and video stored in Google Cloud Storage.
type GoogleCloudAiplatformV1beta1FileData struct {
	// DisplayName: Optional. The display name of the file. Used to provide a label
	// or filename to distinguish files. This field is only returned in
	// `PromptMessage` for prompt management. It is used in the Gemini calls only
	// when server side tools (`code_execution`, `google_search`, and
	// `url_context`) are enabled.
	DisplayName string `json:"displayName,omitempty"`
	// FileUri: Required. The URI of the file in Google Cloud Storage.
	FileUri string `json:"fileUri,omitempty"`
	// MimeType: Required. The IANA standard MIME type of the source data.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FileData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FileData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FunctionCall: A predicted [FunctionCall]
// returned from the model that contains a string representing the
// [FunctionDeclaration.name] and a structured JSON object containing the
// parameters and their values.
type GoogleCloudAiplatformV1beta1FunctionCall struct {
	// Args: Optional. The function parameters and values in JSON object format.
	// See [FunctionDeclaration.parameters] for parameter details.
	Args googleapi.RawMessage `json:"args,omitempty"`
	// Id: Optional. The unique id of the function call. If populated, the client
	// to execute the `function_call` and return the response with the matching
	// `id`.
	Id string `json:"id,omitempty"`
	// Name: Optional. The name of the function to call. Matches
	// [FunctionDeclaration.name].
	Name string `json:"name,omitempty"`
	// PartialArgs: Optional. The partial argument value of the function call. If
	// provided, represents the arguments/fields that are streamed incrementally.
	PartialArgs []*GoogleCloudAiplatformV1beta1PartialArg `json:"partialArgs,omitempty"`
	// WillContinue: Optional. Whether this is the last part of the FunctionCall.
	// If true, another partial message for the current FunctionCall is expected to
	// follow.
	WillContinue bool `json:"willContinue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Args") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Args") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FunctionCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FunctionCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FunctionCallingConfig: Function calling config.
type GoogleCloudAiplatformV1beta1FunctionCallingConfig struct {
	// AllowedFunctionNames: Optional. Function names to call. Only set when the
	// Mode is ANY. Function names should match [FunctionDeclaration.name]. With
	// mode set to ANY, model will predict a function call from the set of function
	// names provided.
	AllowedFunctionNames []string `json:"allowedFunctionNames,omitempty"`
	// Mode: Optional. Function calling mode.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Unspecified function calling mode. This value should
	// not be used.
	//   "AUTO" - Default model behavior, model decides to predict either function
	// calls or natural language response.
	//   "ANY" - Model is constrained to always predicting function calls only. If
	// "allowed_function_names" are set, the predicted function calls will be
	// limited to any one of "allowed_function_names", else the predicted function
	// calls will be any one of the provided "function_declarations".
	//   "NONE" - Model will not predict any function calls. Model behavior is same
	// as when not passing any function declarations.
	//   "VALIDATED" - Model is constrained to predict either function calls or
	// natural language response. If "allowed_function_names" are set, the
	// predicted function calls will be limited to any one of
	// "allowed_function_names", else the predicted function calls will be any one
	// of the provided "function_declarations".
	Mode string `json:"mode,omitempty"`
	// StreamFunctionCallArguments: Optional. When set to true, arguments of a
	// single function call will be streamed out in multiple
	// parts/contents/responses. Partial parameter results will be returned in the
	// [FunctionCall.partial_args] field.
	StreamFunctionCallArguments bool `json:"streamFunctionCallArguments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedFunctionNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedFunctionNames") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FunctionCallingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FunctionCallingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FunctionDeclaration: Structured representation
// of a function declaration as defined by the OpenAPI 3.0 specification
// (https://spec.openapis.org/oas/v3.0.3). Included in this declaration are the
// function name, description, parameters and response type. This
// FunctionDeclaration is a representation of a block of code that can be used
// as a `Tool` by the model and executed by the client.
type GoogleCloudAiplatformV1beta1FunctionDeclaration struct {
	// Description: Optional. Description and purpose of the function. Model uses
	// it to decide how and whether to call the function.
	Description string `json:"description,omitempty"`
	// Name: Required. The name of the function to call. Must start with a letter
	// or an underscore. Must be a-z, A-Z, 0-9, or contain underscores, dots,
	// colons and dashes, with a maximum length of 64.
	Name string `json:"name,omitempty"`
	// Parameters: Optional. Describes the parameters to this function in JSON
	// Schema Object format. Reflects the Open API 3.03 Parameter Object. string
	// Key: the name of the parameter. Parameter names are case sensitive. Schema
	// Value: the Schema defining the type used for the parameter. For function
	// with no parameters, this can be left unset. Parameter names must start with
	// a letter or an underscore and must only contain chars a-z, A-Z, 0-9, or
	// underscores with a maximum length of 64. Example with 1 required and 1
	// optional parameter: type: OBJECT properties: param1: type: STRING param2:
	// type: INTEGER required: - param1
	Parameters *GoogleCloudAiplatformV1beta1Schema `json:"parameters,omitempty"`
	// ParametersJsonSchema: Optional. Describes the parameters to the function in
	// JSON Schema format. The schema must describe an object where the properties
	// are the parameters to the function. For example: ``` { "type": "object",
	// "properties": { "name": { "type": "string" }, "age": { "type": "integer" }
	// }, "additionalProperties": false, "required": ["name", "age"],
	// "propertyOrdering": ["name", "age"] } ``` This field is mutually exclusive
	// with `parameters`.
	ParametersJsonSchema interface{} `json:"parametersJsonSchema,omitempty"`
	// Response: Optional. Describes the output from this function in JSON Schema
	// format. Reflects the Open API 3.03 Response Object. The Schema defines the
	// type used for the response value of the function.
	Response *GoogleCloudAiplatformV1beta1Schema `json:"response,omitempty"`
	// ResponseJsonSchema: Optional. Describes the output from this function in
	// JSON Schema format. The value specified by the schema is the response value
	// of the function. This field is mutually exclusive with `response`.
	ResponseJsonSchema interface{} `json:"responseJsonSchema,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FunctionDeclaration) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FunctionDeclaration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FunctionResponse: The result output from a
// [FunctionCall] that contains a string representing the
// [FunctionDeclaration.name] and a structured JSON object containing any
// output from the function is used as context to the model. This should
// contain the result of a [FunctionCall] made based on model prediction.
type GoogleCloudAiplatformV1beta1FunctionResponse struct {
	// Id: Optional. The id of the function call this response is for. Populated by
	// the client to match the corresponding function call `id`.
	Id string `json:"id,omitempty"`
	// Name: Required. The name of the function to call. Matches
	// [FunctionDeclaration.name] and [FunctionCall.name].
	Name string `json:"name,omitempty"`
	// Parts: Optional. Ordered `Parts` that constitute a function response. Parts
	// may have different IANA MIME types.
	Parts []*GoogleCloudAiplatformV1beta1FunctionResponsePart `json:"parts,omitempty"`
	// Response: Required. The function response in JSON object format. Use
	// "output" key to specify function output and "error" key to specify error
	// details (if any). If "output" and "error" keys are not specified, then whole
	// "response" is treated as function output.
	Response googleapi.RawMessage `json:"response,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FunctionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FunctionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FunctionResponseBlob: Raw media bytes for
// function response. Text should not be sent as raw bytes, use the 'text'
// field.
type GoogleCloudAiplatformV1beta1FunctionResponseBlob struct {
	// Data: Required. Raw bytes.
	Data string `json:"data,omitempty"`
	// DisplayName: Optional. Display name of the blob. Used to provide a label or
	// filename to distinguish blobs. This field is only returned in PromptMessage
	// for prompt management. It is currently used in the Gemini GenerateContent
	// calls only when server side tools (code_execution, google_search, and
	// url_context) are enabled.
	DisplayName string `json:"displayName,omitempty"`
	// MimeType: Required. The IANA standard MIME type of the source data.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Data") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Data") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FunctionResponseBlob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FunctionResponseBlob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FunctionResponseFileData: URI based data for
// function response.
type GoogleCloudAiplatformV1beta1FunctionResponseFileData struct {
	// DisplayName: Optional. Display name of the file data. Used to provide a
	// label or filename to distinguish file datas. This field is only returned in
	// PromptMessage for prompt management. It is currently used in the Gemini
	// GenerateContent calls only when server side tools (code_execution,
	// google_search, and url_context) are enabled.
	DisplayName string `json:"displayName,omitempty"`
	// FileUri: Required. URI.
	FileUri string `json:"fileUri,omitempty"`
	// MimeType: Required. The IANA standard MIME type of the source data.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FunctionResponseFileData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FunctionResponseFileData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FunctionResponsePart: A datatype containing
// media that is part of a `FunctionResponse` message. A `FunctionResponsePart`
// consists of data which has an associated datatype. A `FunctionResponsePart`
// can only contain one of the accepted types in `FunctionResponsePart.data`. A
// `FunctionResponsePart` must have a fixed IANA MIME type identifying the type
// and subtype of the media if the `inline_data` field is filled with raw
// bytes.
type GoogleCloudAiplatformV1beta1FunctionResponsePart struct {
	// FileData: URI based data.
	FileData *GoogleCloudAiplatformV1beta1FunctionResponseFileData `json:"fileData,omitempty"`
	// InlineData: Inline media bytes.
	InlineData *GoogleCloudAiplatformV1beta1FunctionResponseBlob `json:"inlineData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FunctionResponsePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FunctionResponsePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenerateContentRequest: Request message for
// [PredictionService.GenerateContent].
type GoogleCloudAiplatformV1beta1GenerateContentRequest struct {
	// CachedContent: Optional. The name of the cached content used as context to
	// serve the prediction. Note: only used in explicit caching, where users can
	// have control over caching (e.g. what content to cache) and enjoy guaranteed
	// cost savings. Format:
	// `projects/{project}/locations/{location}/cachedContents/{cachedContent}`
	CachedContent string `json:"cachedContent,omitempty"`
	// Contents: Required. The content of the current conversation with the model.
	// For single-turn queries, this is a single instance. For multi-turn queries,
	// this is a repeated field that contains conversation history + latest
	// request.
	Contents []*GoogleCloudAiplatformV1beta1Content `json:"contents,omitempty"`
	// GenerationConfig: Optional. Generation config.
	GenerationConfig *GoogleCloudAiplatformV1beta1GenerationConfig `json:"generationConfig,omitempty"`
	// Labels: Optional. The labels with user-defined metadata for the request. It
	// is used for billing and reporting only. Label keys and values can be no
	// longer than 63 characters (Unicode codepoints) and can only contain
	// lowercase letters, numeric characters, underscores, and dashes.
	// International characters are allowed. Label values are optional. Label keys
	// must start with a letter.
	Labels map[string]string `json:"labels,omitempty"`
	// ModelArmorConfig: Optional. Settings for prompt and response sanitization
	// using the Model Armor service. If supplied, safety_settings must not be
	// supplied.
	ModelArmorConfig *GoogleCloudAiplatformV1beta1ModelArmorConfig `json:"modelArmorConfig,omitempty"`
	// SafetySettings: Optional. Per request settings for blocking unsafe content.
	// Enforced on GenerateContentResponse.candidates.
	SafetySettings []*GoogleCloudAiplatformV1beta1SafetySetting `json:"safetySettings,omitempty"`
	// SystemInstruction: Optional. The user provided system instructions for the
	// model. Note: only text should be used in parts and content in each part will
	// be in a separate paragraph.
	SystemInstruction *GoogleCloudAiplatformV1beta1Content `json:"systemInstruction,omitempty"`
	// ToolConfig: Optional. Tool config. This config is shared for all tools
	// provided in the request.
	ToolConfig *GoogleCloudAiplatformV1beta1ToolConfig `json:"toolConfig,omitempty"`
	// Tools: Optional. A list of `Tools` the model may use to generate the next
	// response. A `Tool` is a piece of code that enables the system to interact
	// with external systems to perform an action, or set of actions, outside of
	// knowledge and scope of the model.
	Tools []*GoogleCloudAiplatformV1beta1Tool `json:"tools,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CachedContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CachedContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenerateContentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenerateContentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenerateContentResponse: Response message for
// [PredictionService.GenerateContent].
type GoogleCloudAiplatformV1beta1GenerateContentResponse struct {
	// Candidates: Output only. Generated candidates.
	Candidates []*GoogleCloudAiplatformV1beta1Candidate `json:"candidates,omitempty"`
	// CreateTime: Output only. Timestamp when the request is made to the server.
	CreateTime string `json:"createTime,omitempty"`
	// ModelVersion: Output only. The model version used to generate the response.
	ModelVersion string `json:"modelVersion,omitempty"`
	// PromptFeedback: Output only. Content filter results for a prompt sent in the
	// request. Note: Sent only in the first stream chunk. Only happens when no
	// candidates were generated due to content violations.
	PromptFeedback *GoogleCloudAiplatformV1beta1GenerateContentResponsePromptFeedback `json:"promptFeedback,omitempty"`
	// ResponseId: Output only. response_id is used to identify each response. It
	// is the encoding of the event_id.
	ResponseId string `json:"responseId,omitempty"`
	// UsageMetadata: Usage metadata about the response(s).
	UsageMetadata *GoogleCloudAiplatformV1beta1GenerateContentResponseUsageMetadata `json:"usageMetadata,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Candidates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Candidates") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenerateContentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenerateContentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenerateContentResponsePromptFeedback: Content
// filter results for a prompt sent in the request. Note: This is sent only in
// the first stream chunk and only if no candidates were generated due to
// content violations.
type GoogleCloudAiplatformV1beta1GenerateContentResponsePromptFeedback struct {
	// BlockReason: Output only. The reason why the prompt was blocked.
	//
	// Possible values:
	//   "BLOCKED_REASON_UNSPECIFIED" - The blocked reason is unspecified.
	//   "SAFETY" - The prompt was blocked for safety reasons.
	//   "OTHER" - The prompt was blocked for other reasons. For example, it may be
	// due to the prompt's language, or because it contains other harmful content.
	//   "BLOCKLIST" - The prompt was blocked because it contains a term from the
	// terminology blocklist.
	//   "PROHIBITED_CONTENT" - The prompt was blocked because it contains
	// prohibited content.
	//   "MODEL_ARMOR" - The prompt was blocked by Model Armor.
	//   "IMAGE_SAFETY" - The prompt was blocked because it contains content that
	// is unsafe for image generation.
	//   "JAILBREAK" - The prompt was blocked as a jailbreak attempt.
	BlockReason string `json:"blockReason,omitempty"`
	// BlockReasonMessage: Output only. A readable message that explains the reason
	// why the prompt was blocked.
	BlockReasonMessage string `json:"blockReasonMessage,omitempty"`
	// SafetyRatings: Output only. A list of safety ratings for the prompt. There
	// is one rating per category.
	SafetyRatings []*GoogleCloudAiplatformV1beta1SafetyRating `json:"safetyRatings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlockReason") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockReason") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenerateContentResponsePromptFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenerateContentResponsePromptFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenerateContentResponseUsageMetadata: Usage
// metadata about the content generation request and response. This message
// provides a detailed breakdown of token usage and other relevant metrics.
type GoogleCloudAiplatformV1beta1GenerateContentResponseUsageMetadata struct {
	// CacheTokensDetails: Output only. A detailed breakdown of the token count for
	// each modality in the cached content.
	CacheTokensDetails []*GoogleCloudAiplatformV1beta1ModalityTokenCount `json:"cacheTokensDetails,omitempty"`
	// CachedContentTokenCount: Output only. The number of tokens in the cached
	// content that was used for this request.
	CachedContentTokenCount int64 `json:"cachedContentTokenCount,omitempty"`
	// CandidatesTokenCount: The total number of tokens in the generated
	// candidates.
	CandidatesTokenCount int64 `json:"candidatesTokenCount,omitempty"`
	// CandidatesTokensDetails: Output only. A detailed breakdown of the token
	// count for each modality in the generated candidates.
	CandidatesTokensDetails []*GoogleCloudAiplatformV1beta1ModalityTokenCount `json:"candidatesTokensDetails,omitempty"`
	// PromptTokenCount: The total number of tokens in the prompt. This includes
	// any text, images, or other media provided in the request. When
	// `cached_content` is set, this also includes the number of tokens in the
	// cached content.
	PromptTokenCount int64 `json:"promptTokenCount,omitempty"`
	// PromptTokensDetails: Output only. A detailed breakdown of the token count
	// for each modality in the prompt.
	PromptTokensDetails []*GoogleCloudAiplatformV1beta1ModalityTokenCount `json:"promptTokensDetails,omitempty"`
	// ThoughtsTokenCount: Output only. The number of tokens that were part of the
	// model's generated "thoughts" output, if applicable.
	ThoughtsTokenCount int64 `json:"thoughtsTokenCount,omitempty"`
	// ToolUsePromptTokenCount: Output only. The number of tokens in the results
	// from tool executions, which are provided back to the model as input, if
	// applicable.
	ToolUsePromptTokenCount int64 `json:"toolUsePromptTokenCount,omitempty"`
	// ToolUsePromptTokensDetails: Output only. A detailed breakdown by modality of
	// the token counts from the results of tool executions, which are provided
	// back to the model as input.
	ToolUsePromptTokensDetails []*GoogleCloudAiplatformV1beta1ModalityTokenCount `json:"toolUsePromptTokensDetails,omitempty"`
	// TotalTokenCount: The total number of tokens for the entire request. This is
	// the sum of `prompt_token_count`, `candidates_token_count`,
	// `tool_use_prompt_token_count`, and `thoughts_token_count`.
	TotalTokenCount int64 `json:"totalTokenCount,omitempty"`
	// TrafficType: Output only. The traffic type for this request.
	//
	// Possible values:
	//   "TRAFFIC_TYPE_UNSPECIFIED" - Unspecified request traffic type.
	//   "ON_DEMAND" - The request was processed using Pay-As-You-Go quota.
	//   "PROVISIONED_THROUGHPUT" - Type for Provisioned Throughput traffic.
	TrafficType string `json:"trafficType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CacheTokensDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CacheTokensDetails") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenerateContentResponseUsageMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenerateContentResponseUsageMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenerationConfig: Configuration for content
// generation. This message contains all the parameters that control how the
// model generates content. It allows you to influence the randomness, length,
// and structure of the output.
type GoogleCloudAiplatformV1beta1GenerationConfig struct {
	// AudioTimestamp: Optional. If enabled, audio timestamps will be included in
	// the request to the model. This can be useful for synchronizing audio with
	// other modalities in the response.
	AudioTimestamp bool `json:"audioTimestamp,omitempty"`
	// CandidateCount: Optional. The number of candidate responses to generate. A
	// higher `candidate_count` can provide more options to choose from, but it
	// also consumes more resources. This can be useful for generating a variety of
	// responses and selecting the best one.
	CandidateCount int64 `json:"candidateCount,omitempty"`
	// EnableAffectiveDialog: Optional. If enabled, the model will detect emotions
	// and adapt its responses accordingly. For example, if the model detects that
	// the user is frustrated, it may provide a more empathetic response.
	EnableAffectiveDialog bool `json:"enableAffectiveDialog,omitempty"`
	// FrequencyPenalty: Optional. Penalizes tokens based on their frequency in the
	// generated text. A positive value helps to reduce the repetition of words and
	// phrases. Valid values can range from [-2.0, 2.0].
	FrequencyPenalty float64 `json:"frequencyPenalty,omitempty"`
	// ImageConfig: Optional. Config for image generation features.
	ImageConfig *GoogleCloudAiplatformV1beta1ImageConfig `json:"imageConfig,omitempty"`
	// Logprobs: Optional. The number of top log probabilities to return for each
	// token. This can be used to see which other tokens were considered likely
	// candidates for a given position. A higher value will return more options,
	// but it will also increase the size of the response.
	Logprobs int64 `json:"logprobs,omitempty"`
	// MaxOutputTokens: Optional. The maximum number of tokens to generate in the
	// response. A token is approximately four characters. The default value varies
	// by model. This parameter can be used to control the length of the generated
	// text and prevent overly long responses.
	MaxOutputTokens int64 `json:"maxOutputTokens,omitempty"`
	// MediaResolution: Optional. The token resolution at which input media content
	// is sampled. This is used to control the trade-off between the quality of the
	// response and the number of tokens used to represent the media. A higher
	// resolution allows the model to perceive more detail, which can lead to a
	// more nuanced response, but it will also use more tokens. This does not
	// affect the image dimensions sent to the model.
	//
	// Possible values:
	//   "MEDIA_RESOLUTION_UNSPECIFIED" - Media resolution has not been set.
	//   "MEDIA_RESOLUTION_LOW" - Media resolution set to low (64 tokens).
	//   "MEDIA_RESOLUTION_MEDIUM" - Media resolution set to medium (256 tokens).
	//   "MEDIA_RESOLUTION_HIGH" - Media resolution set to high (zoomed reframing
	// with 256 tokens).
	MediaResolution string `json:"mediaResolution,omitempty"`
	// ModelConfig: Optional. Config for model selection.
	ModelConfig *GoogleCloudAiplatformV1beta1GenerationConfigModelConfig `json:"modelConfig,omitempty"`
	// PresencePenalty: Optional. Penalizes tokens that have already appeared in
	// the generated text. A positive value encourages the model to generate more
	// diverse and less repetitive text. Valid values can range from [-2.0, 2.0].
	PresencePenalty float64 `json:"presencePenalty,omitempty"`
	// ResponseJsonSchema: Optional. When this field is set, response_schema must
	// be omitted and response_mime_type must be set to `application/json`.
	ResponseJsonSchema interface{} `json:"responseJsonSchema,omitempty"`
	// ResponseLogprobs: Optional. If set to true, the log probabilities of the
	// output tokens are returned. Log probabilities are the logarithm of the
	// probability of a token appearing in the output. A higher log probability
	// means the token is more likely to be generated. This can be useful for
	// analyzing the model's confidence in its own output and for debugging.
	ResponseLogprobs bool `json:"responseLogprobs,omitempty"`
	// ResponseMimeType: Optional. The IANA standard MIME type of the response. The
	// model will generate output that conforms to this MIME type. Supported values
	// include 'text/plain' (default) and 'application/json'. The model needs to be
	// prompted to output the appropriate response type, otherwise the behavior is
	// undefined. This is a preview feature.
	ResponseMimeType string `json:"responseMimeType,omitempty"`
	// ResponseModalities: Optional. The modalities of the response. The model will
	// generate a response that includes all the specified modalities. For example,
	// if this is set to `[TEXT, IMAGE]`, the response will include both text and
	// an image.
	//
	// Possible values:
	//   "MODALITY_UNSPECIFIED" - Unspecified modality. Will be processed as text.
	//   "TEXT" - Text modality.
	//   "IMAGE" - Image modality.
	//   "AUDIO" - Audio modality.
	ResponseModalities []string `json:"responseModalities,omitempty"`
	// ResponseSchema: Optional. Lets you to specify a schema for the model's
	// response, ensuring that the output conforms to a particular structure. This
	// is useful for generating structured data such as JSON. The schema is a
	// subset of the OpenAPI 3.0 schema object
	// (https://spec.openapis.org/oas/v3.0.3#schema) object. When this field is
	// set, you must also set the `response_mime_type` to `application/json`.
	ResponseSchema *GoogleCloudAiplatformV1beta1Schema `json:"responseSchema,omitempty"`
	// RoutingConfig: Optional. Routing configuration.
	RoutingConfig *GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfig `json:"routingConfig,omitempty"`
	// Seed: Optional. A seed for the random number generator. By setting a seed,
	// you can make the model's output mostly deterministic. For a given prompt and
	// parameters (like temperature, top_p, etc.), the model will produce the same
	// response every time. However, it's not a guaranteed absolute deterministic
	// behavior. This is different from parameters like `temperature`, which
	// control the *level* of randomness. `seed` ensures that the "random" choices
	// the model makes are the same on every run, making it essential for testing
	// and ensuring reproducible results.
	Seed int64 `json:"seed,omitempty"`
	// SpeechConfig: Optional. The speech generation config.
	SpeechConfig *GoogleCloudAiplatformV1beta1SpeechConfig `json:"speechConfig,omitempty"`
	// StopSequences: Optional. A list of character sequences that will stop the
	// model from generating further tokens. If a stop sequence is generated, the
	// output will end at that point. This is useful for controlling the length and
	// structure of the output. For example, you can use ["\n", "###"] to stop
	// generation at a new line or a specific marker.
	StopSequences []string `json:"stopSequences,omitempty"`
	// Temperature: Optional. Controls the randomness of the output. A higher
	// temperature results in more creative and diverse responses, while a lower
	// temperature makes the output more predictable and focused. The valid range
	// is (0.0, 2.0].
	Temperature float64 `json:"temperature,omitempty"`
	// ThinkingConfig: Optional. Configuration for thinking features. An error will
	// be returned if this field is set for models that don't support thinking.
	ThinkingConfig *GoogleCloudAiplatformV1beta1GenerationConfigThinkingConfig `json:"thinkingConfig,omitempty"`
	// TopK: Optional. Specifies the top-k sampling threshold. The model considers
	// only the top k most probable tokens for the next token. This can be useful
	// for generating more coherent and less random text. For example, a `top_k` of
	// 40 means the model will choose the next word from the 40 most likely words.
	TopK float64 `json:"topK,omitempty"`
	// TopP: Optional. Specifies the nucleus sampling threshold. The model
	// considers only the smallest set of tokens whose cumulative probability is at
	// least `top_p`. This helps generate more diverse and less repetitive
	// responses. For example, a `top_p` of 0.9 means the model considers tokens
	// until the cumulative probability of the tokens to select from reaches 0.9.
	// It's recommended to adjust either temperature or `top_p`, but not both.
	TopP float64 `json:"topP,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioTimestamp") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioTimestamp") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenerationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenerationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1GenerationConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1GenerationConfig
	var s1 struct {
		FrequencyPenalty gensupport.JSONFloat64 `json:"frequencyPenalty"`
		PresencePenalty  gensupport.JSONFloat64 `json:"presencePenalty"`
		Temperature      gensupport.JSONFloat64 `json:"temperature"`
		TopK             gensupport.JSONFloat64 `json:"topK"`
		TopP             gensupport.JSONFloat64 `json:"topP"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FrequencyPenalty = float64(s1.FrequencyPenalty)
	s.PresencePenalty = float64(s1.PresencePenalty)
	s.Temperature = float64(s1.Temperature)
	s.TopK = float64(s1.TopK)
	s.TopP = float64(s1.TopP)
	return nil
}

// GoogleCloudAiplatformV1beta1GenerationConfigModelConfig: Config for model
// selection.
type GoogleCloudAiplatformV1beta1GenerationConfigModelConfig struct {
	// FeatureSelectionPreference: Required. Feature selection preference.
	//
	// Possible values:
	//   "FEATURE_SELECTION_PREFERENCE_UNSPECIFIED" - Unspecified feature selection
	// preference.
	//   "PRIORITIZE_QUALITY" - Prefer higher quality over lower cost.
	//   "BALANCED" - Balanced feature selection preference.
	//   "PRIORITIZE_COST" - Prefer lower cost over higher quality.
	FeatureSelectionPreference string `json:"featureSelectionPreference,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FeatureSelectionPreference")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeatureSelectionPreference") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenerationConfigModelConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenerationConfigModelConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfig: The configuration
// for routing the request to a specific model. This can be used to control
// which model is used for the generation, either automatically or by
// specifying a model name.
type GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfig struct {
	// AutoMode: In this mode, the model is selected automatically based on the
	// content of the request.
	AutoMode *GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigAutoRoutingMode `json:"autoMode,omitempty"`
	// ManualMode: In this mode, the model is specified manually.
	ManualMode *GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigManualRoutingMode `json:"manualMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoMode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigAutoRoutingMode:
// The configuration for automated routing. When automated routing is
// specified, the routing will be determined by the pretrained routing model
// and customer provided model routing preference.
type GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigAutoRoutingMode struct {
	// ModelRoutingPreference: The model routing preference.
	//
	// Possible values:
	//   "UNKNOWN" - Unspecified model routing preference.
	//   "PRIORITIZE_QUALITY" - The model will be selected to prioritize the
	// quality of the response.
	//   "BALANCED" - The model will be selected to balance quality and cost.
	//   "PRIORITIZE_COST" - The model will be selected to prioritize the cost of
	// the request.
	ModelRoutingPreference string `json:"modelRoutingPreference,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelRoutingPreference") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelRoutingPreference") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigAutoRoutingMode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigAutoRoutingMode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigManualRoutingMode:
// The configuration for manual routing. When manual routing is specified, the
// model will be selected based on the model name provided.
type GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigManualRoutingMode struct {
	// ModelName: The name of the model to use. Only public LLM models are
	// accepted.
	ModelName string `json:"modelName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigManualRoutingMode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigManualRoutingMode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenerationConfigThinkingConfig: Configuration
// for the model's thinking features. "Thinking" is a process where the model
// breaks down a complex task into smaller, manageable steps. This allows the
// model to reason about the task, plan its approach, and execute the plan to
// generate a high-quality response.
type GoogleCloudAiplatformV1beta1GenerationConfigThinkingConfig struct {
	// IncludeThoughts: Optional. If true, the model will include its thoughts in
	// the response. "Thoughts" are the intermediate steps the model takes to
	// arrive at the final response. They can provide insights into the model's
	// reasoning process and help with debugging. If this is true, thoughts are
	// returned only when available.
	IncludeThoughts bool `json:"includeThoughts,omitempty"`
	// ThinkingBudget: Optional. The token budget for the model's thinking process.
	// The model will make a best effort to stay within this budget. This can be
	// used to control the trade-off between response quality and latency.
	ThinkingBudget int64 `json:"thinkingBudget,omitempty"`
	// ThinkingLevel: Optional. The number of thoughts tokens that the model should
	// generate.
	//
	// Possible values:
	//   "THINKING_LEVEL_UNSPECIFIED" - Unspecified thinking level.
	//   "LOW" - Low thinking level.
	//   "HIGH" - High thinking level.
	ThinkingLevel string `json:"thinkingLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IncludeThoughts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IncludeThoughts") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenerationConfigThinkingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenerationConfigThinkingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GoogleMaps: Tool to retrieve public maps data
// for grounding, powered by Google.
type GoogleCloudAiplatformV1beta1GoogleMaps struct {
	// EnableWidget: Optional. If true, include the widget context token in the
	// response.
	EnableWidget bool `json:"enableWidget,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableWidget") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableWidget") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GoogleMaps) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GoogleMaps
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GoogleSearchRetrieval: Tool to retrieve public
// web data for grounding, powered by Google.
type GoogleCloudAiplatformV1beta1GoogleSearchRetrieval struct {
	// DynamicRetrievalConfig: Specifies the dynamic retrieval configuration for
	// the given source.
	DynamicRetrievalConfig *GoogleCloudAiplatformV1beta1DynamicRetrievalConfig `json:"dynamicRetrievalConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DynamicRetrievalConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DynamicRetrievalConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GoogleSearchRetrieval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GoogleSearchRetrieval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GroundingChunk: A piece of evidence that
// supports a claim made by the model. This is used to show a citation for a
// claim made by the model. When grounding is enabled, the model returns a
// `GroundingChunk` that contains a reference to the source of the information.
type GoogleCloudAiplatformV1beta1GroundingChunk struct {
	// Maps: A grounding chunk from Google Maps. See the `Maps` message for
	// details.
	Maps *GoogleCloudAiplatformV1beta1GroundingChunkMaps `json:"maps,omitempty"`
	// RetrievedContext: A grounding chunk from a data source retrieved by a
	// retrieval tool, such as Vertex AI Search. See the `RetrievedContext` message
	// for details
	RetrievedContext *GoogleCloudAiplatformV1beta1GroundingChunkRetrievedContext `json:"retrievedContext,omitempty"`
	// Web: A grounding chunk from a web page, typically from Google Search. See
	// the `Web` message for details.
	Web *GoogleCloudAiplatformV1beta1GroundingChunkWeb `json:"web,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Maps") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Maps") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GroundingChunk) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GroundingChunk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GroundingChunkMaps: A `Maps` chunk is a piece of
// evidence that comes from Google Maps. It contains information about a place,
// such as its name, address, and reviews. This is used to provide the user
// with rich, location-based information.
type GoogleCloudAiplatformV1beta1GroundingChunkMaps struct {
	// PlaceAnswerSources: The sources that were used to generate the place answer.
	// This includes review snippets and photos that were used to generate the
	// answer, as well as URIs to flag content.
	PlaceAnswerSources *GoogleCloudAiplatformV1beta1GroundingChunkMapsPlaceAnswerSources `json:"placeAnswerSources,omitempty"`
	// PlaceId: This Place's resource name, in `places/{place_id}` format. This can
	// be used to look up the place in the Google Maps API.
	PlaceId string `json:"placeId,omitempty"`
	// Text: The text of the place answer.
	Text string `json:"text,omitempty"`
	// Title: The title of the place.
	Title string `json:"title,omitempty"`
	// Uri: The URI of the place.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PlaceAnswerSources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PlaceAnswerSources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GroundingChunkMaps) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GroundingChunkMaps
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GroundingChunkMapsPlaceAnswerSources: The
// sources that were used to generate the place answer. This includes review
// snippets and photos that were used to generate the answer, as well as URIs
// to flag content.
type GoogleCloudAiplatformV1beta1GroundingChunkMapsPlaceAnswerSources struct {
	// ReviewSnippets: Snippets of reviews that were used to generate the answer.
	ReviewSnippets []*GoogleCloudAiplatformV1beta1GroundingChunkMapsPlaceAnswerSourcesReviewSnippet `json:"reviewSnippets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReviewSnippets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReviewSnippets") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GroundingChunkMapsPlaceAnswerSources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GroundingChunkMapsPlaceAnswerSources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GroundingChunkMapsPlaceAnswerSourcesReviewSnippet
// : A review snippet that is used to generate the answer.
type GoogleCloudAiplatformV1beta1GroundingChunkMapsPlaceAnswerSourcesReviewSnippet struct {
	// GoogleMapsUri: A link to show the review on Google Maps.
	GoogleMapsUri string `json:"googleMapsUri,omitempty"`
	// ReviewId: The ID of the review that is being referenced.
	ReviewId string `json:"reviewId,omitempty"`
	// Title: The title of the review.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GoogleMapsUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GoogleMapsUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GroundingChunkMapsPlaceAnswerSourcesReviewSnippet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GroundingChunkMapsPlaceAnswerSourcesReviewSnippet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GroundingChunkRetrievedContext: Context
// retrieved from a data source to ground the model's response. This is used
// when a retrieval tool fetches information from a user-provided corpus or a
// public dataset.
type GoogleCloudAiplatformV1beta1GroundingChunkRetrievedContext struct {
	// DocumentName: Output only. The full resource name of the referenced Vertex
	// AI Search document. This is used to identify the specific document that was
	// retrieved. The format is
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/branches/{branch}/documents/{document}`.
	DocumentName string `json:"documentName,omitempty"`
	// RagChunk: Additional context for a Retrieval-Augmented Generation (RAG)
	// retrieval result. This is populated only when the RAG retrieval tool is
	// used.
	RagChunk *GoogleCloudAiplatformV1beta1RagChunk `json:"ragChunk,omitempty"`
	// Text: The content of the retrieved data source.
	Text string `json:"text,omitempty"`
	// Title: The title of the retrieved data source.
	Title string `json:"title,omitempty"`
	// Uri: The URI of the retrieved data source.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GroundingChunkRetrievedContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GroundingChunkRetrievedContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GroundingChunkWeb: A `Web` chunk is a piece of
// evidence that comes from a web page. It contains the URI of the web page,
// the title of the page, and the domain of the page. This is used to provide
// the user with a link to the source of the information.
type GoogleCloudAiplatformV1beta1GroundingChunkWeb struct {
	// Domain: The domain of the web page that contains the evidence. This can be
	// used to filter out low-quality sources.
	Domain string `json:"domain,omitempty"`
	// Title: The title of the web page that contains the evidence.
	Title string `json:"title,omitempty"`
	// Uri: The URI of the web page that contains the evidence.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Domain") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Domain") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GroundingChunkWeb) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GroundingChunkWeb
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GroundingMetadata: Information about the sources
// that support the content of a response. When grounding is enabled, the model
// returns citations for claims in the response. This object contains the
// retrieved sources.
type GoogleCloudAiplatformV1beta1GroundingMetadata struct {
	// GoogleMapsWidgetContextToken: Optional. Output only. A token that can be
	// used to render a Google Maps widget with the contextual data. This field is
	// populated only when the grounding source is Google Maps.
	GoogleMapsWidgetContextToken string `json:"googleMapsWidgetContextToken,omitempty"`
	// GroundingChunks: A list of supporting references retrieved from the
	// grounding source. This field is populated when the grounding source is
	// Google Search, Vertex AI Search, or Google Maps.
	GroundingChunks []*GoogleCloudAiplatformV1beta1GroundingChunk `json:"groundingChunks,omitempty"`
	// GroundingSupports: Optional. A list of grounding supports that connect the
	// generated content to the grounding chunks. This field is populated when the
	// grounding source is Google Search or Vertex AI Search.
	GroundingSupports []*GoogleCloudAiplatformV1beta1GroundingSupport `json:"groundingSupports,omitempty"`
	// RetrievalMetadata: Optional. Output only. Metadata related to the retrieval
	// grounding source.
	RetrievalMetadata *GoogleCloudAiplatformV1beta1RetrievalMetadata `json:"retrievalMetadata,omitempty"`
	// RetrievalQueries: Optional. The queries that were executed by the retrieval
	// tools. This field is populated only when the grounding source is a retrieval
	// tool, such as Vertex AI Search.
	RetrievalQueries []string `json:"retrievalQueries,omitempty"`
	// SearchEntryPoint: Optional. A web search entry point that can be used to
	// display search results. This field is populated only when the grounding
	// source is Google Search.
	SearchEntryPoint *GoogleCloudAiplatformV1beta1SearchEntryPoint `json:"searchEntryPoint,omitempty"`
	// SourceFlaggingUris: Optional. Output only. A list of URIs that can be used
	// to flag a place or review for inappropriate content. This field is populated
	// only when the grounding source is Google Maps.
	SourceFlaggingUris []*GoogleCloudAiplatformV1beta1GroundingMetadataSourceFlaggingUri `json:"sourceFlaggingUris,omitempty"`
	// WebSearchQueries: Optional. The web search queries that were used to
	// generate the content. This field is populated only when the grounding source
	// is Google Search.
	WebSearchQueries []string `json:"webSearchQueries,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "GoogleMapsWidgetContextToken") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GoogleMapsWidgetContextToken") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GroundingMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GroundingMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GroundingMetadataSourceFlaggingUri: A URI that
// can be used to flag a place or review for inappropriate content. This is
// populated only when the grounding source is Google Maps.
type GoogleCloudAiplatformV1beta1GroundingMetadataSourceFlaggingUri struct {
	// FlagContentUri: The URI that can be used to flag the content.
	FlagContentUri string `json:"flagContentUri,omitempty"`
	// SourceId: The ID of the place or review.
	SourceId string `json:"sourceId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FlagContentUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FlagContentUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GroundingMetadataSourceFlaggingUri) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GroundingMetadataSourceFlaggingUri
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GroundingSupport: A collection of supporting
// references for a segment of the model's response.
type GoogleCloudAiplatformV1beta1GroundingSupport struct {
	// ConfidenceScores: The confidence scores for the support references. This
	// list is parallel to the `grounding_chunk_indices` list. A score is a value
	// between 0.0 and 1.0, with a higher score indicating a higher confidence that
	// the reference supports the claim. For Gemini 2.0 and before, this list has
	// the same size as `grounding_chunk_indices`. For Gemini 2.5 and later, this
	// list is empty and should be ignored.
	ConfidenceScores []float64 `json:"confidenceScores,omitempty"`
	// GroundingChunkIndices: A list of indices into the `grounding_chunks` field
	// of the `GroundingMetadata` message. These indices specify which grounding
	// chunks support the claim made in the content segment. For example, if this
	// field has the values `[1, 3]`, it means that `grounding_chunks[1]` and
	// `grounding_chunks[3]` are the sources for the claim in the content segment.
	GroundingChunkIndices []int64 `json:"groundingChunkIndices,omitempty"`
	// Segment: The content segment that this support message applies to.
	Segment *GoogleCloudAiplatformV1beta1Segment `json:"segment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScores") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GroundingSupport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GroundingSupport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1GroundingSupport) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1GroundingSupport
	var s1 struct {
		ConfidenceScores []gensupport.JSONFloat64 `json:"confidenceScores"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScores = make([]float64, len(s1.ConfidenceScores))
	for i := range s1.ConfidenceScores {
		s.ConfidenceScores[i] = float64(s1.ConfidenceScores[i])
	}
	return nil
}

// GoogleCloudAiplatformV1beta1ImageConfig: Configuration for image generation.
// This message allows you to control various aspects of image generation, such
// as the output format, aspect ratio, and whether the model can generate
// images of people.
type GoogleCloudAiplatformV1beta1ImageConfig struct {
	// AspectRatio: Optional. The desired aspect ratio for the generated images.
	// The following aspect ratios are supported: "1:1" "2:3", "3:2" "3:4", "4:3"
	// "4:5", "5:4" "9:16", "16:9" "21:9"
	AspectRatio string `json:"aspectRatio,omitempty"`
	// ImageOutputOptions: Optional. The image output format for generated images.
	ImageOutputOptions *GoogleCloudAiplatformV1beta1ImageConfigImageOutputOptions `json:"imageOutputOptions,omitempty"`
	// ImageSize: Optional. Specifies the size of generated images. Supported
	// values are `1K`, `2K`, `4K`. If not specified, the model will use default
	// value `1K`.
	ImageSize string `json:"imageSize,omitempty"`
	// PersonGeneration: Optional. Controls whether the model can generate people.
	//
	// Possible values:
	//   "PERSON_GENERATION_UNSPECIFIED" - The default behavior is unspecified. The
	// model will decide whether to generate images of people.
	//   "ALLOW_ALL" - Allows the model to generate images of people, including
	// adults and children.
	//   "ALLOW_ADULT" - Allows the model to generate images of adults, but not
	// children.
	//   "ALLOW_NONE" - Prevents the model from generating images of people.
	PersonGeneration string `json:"personGeneration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AspectRatio") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AspectRatio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ImageConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ImageConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ImageConfigImageOutputOptions: The image output
// format for generated images.
type GoogleCloudAiplatformV1beta1ImageConfigImageOutputOptions struct {
	// CompressionQuality: Optional. The compression quality of the output image.
	CompressionQuality int64 `json:"compressionQuality,omitempty"`
	// MimeType: Optional. The image format that the output should be saved as.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompressionQuality") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompressionQuality") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ImageConfigImageOutputOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ImageConfigImageOutputOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1LogprobsResult: The log probabilities of the
// tokens generated by the model. This is useful for understanding the model's
// confidence in its predictions and for debugging. For example, you can use
// log probabilities to identify when the model is making a less confident
// prediction or to explore alternative responses that the model considered. A
// low log probability can also indicate that the model is "hallucinating" or
// generating factually incorrect information.
type GoogleCloudAiplatformV1beta1LogprobsResult struct {
	// ChosenCandidates: A list of the chosen candidate tokens at each decoding
	// step. The length of this list is equal to the total number of decoding
	// steps. Note that the chosen candidate might not be in `top_candidates`.
	ChosenCandidates []*GoogleCloudAiplatformV1beta1LogprobsResultCandidate `json:"chosenCandidates,omitempty"`
	// TopCandidates: A list of the top candidate tokens at each decoding step. The
	// length of this list is equal to the total number of decoding steps.
	TopCandidates []*GoogleCloudAiplatformV1beta1LogprobsResultTopCandidates `json:"topCandidates,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChosenCandidates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChosenCandidates") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1LogprobsResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1LogprobsResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1LogprobsResultCandidate: A single token and its
// associated log probability.
type GoogleCloudAiplatformV1beta1LogprobsResultCandidate struct {
	// LogProbability: The log probability of this token. A higher value indicates
	// that the model was more confident in this token. The log probability can be
	// used to assess the relative likelihood of different tokens and to identify
	// when the model is uncertain.
	LogProbability float64 `json:"logProbability,omitempty"`
	// Token: The token's string representation.
	Token string `json:"token,omitempty"`
	// TokenId: The token's numerical ID. While the `token` field provides the
	// string representation of the token, the `token_id` is the numerical
	// representation that the model uses internally. This can be useful for
	// developers who want to build custom logic based on the model's vocabulary.
	TokenId int64 `json:"tokenId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LogProbability") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LogProbability") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1LogprobsResultCandidate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1LogprobsResultCandidate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1LogprobsResultCandidate) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1LogprobsResultCandidate
	var s1 struct {
		LogProbability gensupport.JSONFloat64 `json:"logProbability"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.LogProbability = float64(s1.LogProbability)
	return nil
}

// GoogleCloudAiplatformV1beta1LogprobsResultTopCandidates: A list of the top
// candidate tokens and their log probabilities at each decoding step. This can
// be used to see what other tokens the model considered.
type GoogleCloudAiplatformV1beta1LogprobsResultTopCandidates struct {
	// Candidates: The list of candidate tokens, sorted by log probability in
	// descending order.
	Candidates []*GoogleCloudAiplatformV1beta1LogprobsResultCandidate `json:"candidates,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Candidates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Candidates") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1LogprobsResultTopCandidates) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1LogprobsResultTopCandidates
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ModalityTokenCount: Represents a breakdown of
// token usage by modality. This message is used in CountTokensResponse and
// GenerateContentResponse.UsageMetadata to provide a detailed view of how many
// tokens are used by each modality (e.g., text, image, video) in a request.
// This is particularly useful for multimodal models, allowing you to track and
// manage token consumption for billing and quota purposes.
type GoogleCloudAiplatformV1beta1ModalityTokenCount struct {
	// Modality: The modality that this token count applies to.
	//
	// Possible values:
	//   "MODALITY_UNSPECIFIED" - When a modality is not specified, it is treated
	// as `TEXT`.
	//   "TEXT" - The `Part` contains plain text.
	//   "IMAGE" - The `Part` contains an image.
	//   "VIDEO" - The `Part` contains a video.
	//   "AUDIO" - The `Part` contains audio.
	//   "DOCUMENT" - The `Part` contains a document, such as a PDF.
	Modality string `json:"modality,omitempty"`
	// TokenCount: The number of tokens counted for this modality.
	TokenCount int64 `json:"tokenCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Modality") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Modality") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ModalityTokenCount) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ModalityTokenCount
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ModelArmorConfig: Configuration for Model Armor.
// Model Armor is a Google Cloud service that provides safety and security
// filtering for prompts and responses. It helps protect your AI applications
// from risks such as harmful content, sensitive data leakage, and prompt
// injection attacks.
type GoogleCloudAiplatformV1beta1ModelArmorConfig struct {
	// PromptTemplateName: Optional. The resource name of the Model Armor template
	// to use for prompt screening. A Model Armor template is a set of customized
	// filters and thresholds that define how Model Armor screens content. If
	// specified, Model Armor will use this template to check the user's prompt for
	// safety and security risks before it is sent to the model. The name must be
	// in the format
	// `projects/{project}/locations/{location}/templates/{template}`.
	PromptTemplateName string `json:"promptTemplateName,omitempty"`
	// ResponseTemplateName: Optional. The resource name of the Model Armor
	// template to use for response screening. A Model Armor template is a set of
	// customized filters and thresholds that define how Model Armor screens
	// content. If specified, Model Armor will use this template to check the
	// model's response for safety and security risks before it is returned to the
	// user. The name must be in the format
	// `projects/{project}/locations/{location}/templates/{template}`.
	ResponseTemplateName string `json:"responseTemplateName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PromptTemplateName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PromptTemplateName") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ModelArmorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ModelArmorConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1MultiSpeakerVoiceConfig: Configuration for a
// multi-speaker text-to-speech request.
type GoogleCloudAiplatformV1beta1MultiSpeakerVoiceConfig struct {
	// SpeakerVoiceConfigs: Required. A list of configurations for the voices of
	// the speakers. Exactly two speaker voice configurations must be provided.
	SpeakerVoiceConfigs []*GoogleCloudAiplatformV1beta1SpeakerVoiceConfig `json:"speakerVoiceConfigs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SpeakerVoiceConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SpeakerVoiceConfigs") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1MultiSpeakerVoiceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1MultiSpeakerVoiceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Part: A datatype containing media that is part
// of a multi-part Content message. A `Part` consists of data which has an
// associated datatype. A `Part` can only contain one of the accepted types in
// `Part.data`. For media types that are not text, `Part` must have a fixed
// IANA MIME type identifying the type and subtype of the media if
// `inline_data` or `file_data` field is filled with raw bytes.
type GoogleCloudAiplatformV1beta1Part struct {
	// CodeExecutionResult: Optional. The result of executing the ExecutableCode.
	CodeExecutionResult *GoogleCloudAiplatformV1beta1CodeExecutionResult `json:"codeExecutionResult,omitempty"`
	// ExecutableCode: Optional. Code generated by the model that is intended to be
	// executed.
	ExecutableCode *GoogleCloudAiplatformV1beta1ExecutableCode `json:"executableCode,omitempty"`
	// FileData: Optional. The URI-based data of the part. This can be used to
	// include files from Google Cloud Storage.
	FileData *GoogleCloudAiplatformV1beta1FileData `json:"fileData,omitempty"`
	// FunctionCall: Optional. A predicted function call returned from the model.
	// This contains the name of the function to call and the arguments to pass to
	// the function.
	FunctionCall *GoogleCloudAiplatformV1beta1FunctionCall `json:"functionCall,omitempty"`
	// FunctionResponse: Optional. The result of a function call. This is used to
	// provide the model with the result of a function call that it predicted.
	FunctionResponse *GoogleCloudAiplatformV1beta1FunctionResponse `json:"functionResponse,omitempty"`
	// InlineData: Optional. The inline data content of the part. This can be used
	// to include images, audio, or video in a request.
	InlineData *GoogleCloudAiplatformV1beta1Blob `json:"inlineData,omitempty"`
	// MediaResolution: per part media resolution. Media resolution for the input
	// media.
	MediaResolution *GoogleCloudAiplatformV1beta1PartMediaResolution `json:"mediaResolution,omitempty"`
	// Text: Optional. The text content of the part.
	Text string `json:"text,omitempty"`
	// Thought: Optional. Indicates whether the `part` represents the model's
	// thought process or reasoning.
	Thought bool `json:"thought,omitempty"`
	// ThoughtSignature: Optional. An opaque signature for the thought so it can be
	// reused in subsequent requests.
	ThoughtSignature string `json:"thoughtSignature,omitempty"`
	// VideoMetadata: Optional. Video metadata. The metadata should only be
	// specified while the video data is presented in inline_data or file_data.
	VideoMetadata *GoogleCloudAiplatformV1beta1VideoMetadata `json:"videoMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CodeExecutionResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CodeExecutionResult") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Part) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Part
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1PartMediaResolution: per part media resolution.
// Media resolution for the input media.
type GoogleCloudAiplatformV1beta1PartMediaResolution struct {
	// Level: The tokenization quality used for given media.
	//
	// Possible values:
	//   "MEDIA_RESOLUTION_UNSPECIFIED" - Media resolution has not been set.
	//   "MEDIA_RESOLUTION_LOW" - Media resolution set to low.
	//   "MEDIA_RESOLUTION_MEDIUM" - Media resolution set to medium.
	//   "MEDIA_RESOLUTION_HIGH" - Media resolution set to high.
	Level string `json:"level,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Level") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Level") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1PartMediaResolution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1PartMediaResolution
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1PartialArg: Partial argument value of the
// function call.
type GoogleCloudAiplatformV1beta1PartialArg struct {
	// BoolValue: Optional. Represents a boolean value.
	BoolValue bool `json:"boolValue,omitempty"`
	// JsonPath: Required. A JSON Path (RFC 9535) to the argument being streamed.
	// https://datatracker.ietf.org/doc/html/rfc9535. e.g. "$.foo.bar[0].data".
	JsonPath string `json:"jsonPath,omitempty"`
	// NullValue: Optional. Represents a null value.
	//
	// Possible values:
	//   "NULL_VALUE" - Null value.
	NullValue string `json:"nullValue,omitempty"`
	// NumberValue: Optional. Represents a double value.
	NumberValue float64 `json:"numberValue,omitempty"`
	// StringValue: Optional. Represents a string value.
	StringValue string `json:"stringValue,omitempty"`
	// WillContinue: Optional. Whether this is not the last part of the same
	// json_path. If true, another PartialArg message for the current json_path is
	// expected to follow.
	WillContinue bool `json:"willContinue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoolValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoolValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1PartialArg) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1PartialArg
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1PartialArg) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1PartialArg
	var s1 struct {
		NumberValue gensupport.JSONFloat64 `json:"numberValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NumberValue = float64(s1.NumberValue)
	return nil
}

// GoogleCloudAiplatformV1beta1PrebuiltVoiceConfig: Configuration for a
// prebuilt voice.
type GoogleCloudAiplatformV1beta1PrebuiltVoiceConfig struct {
	// VoiceName: The name of the prebuilt voice to use.
	VoiceName string `json:"voiceName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "VoiceName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "VoiceName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1PrebuiltVoiceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1PrebuiltVoiceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1RagChunk: A RagChunk includes the content of a
// chunk of a RagFile, and associated metadata.
type GoogleCloudAiplatformV1beta1RagChunk struct {
	// PageSpan: If populated, represents where the chunk starts and ends in the
	// document.
	PageSpan *GoogleCloudAiplatformV1beta1RagChunkPageSpan `json:"pageSpan,omitempty"`
	// Text: The content of the chunk.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageSpan") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageSpan") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1RagChunk) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1RagChunk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1RagChunkPageSpan: Represents where the chunk
// starts and ends in the document.
type GoogleCloudAiplatformV1beta1RagChunkPageSpan struct {
	// FirstPage: Page where chunk starts in the document. Inclusive. 1-indexed.
	FirstPage int64 `json:"firstPage,omitempty"`
	// LastPage: Page where chunk ends in the document. Inclusive. 1-indexed.
	LastPage int64 `json:"lastPage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FirstPage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FirstPage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1RagChunkPageSpan) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1RagChunkPageSpan
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1RagRetrievalConfig: Specifies the context
// retrieval config.
type GoogleCloudAiplatformV1beta1RagRetrievalConfig struct {
	// Filter: Optional. Config for filters.
	Filter *GoogleCloudAiplatformV1beta1RagRetrievalConfigFilter `json:"filter,omitempty"`
	// HybridSearch: Optional. Config for Hybrid Search.
	HybridSearch *GoogleCloudAiplatformV1beta1RagRetrievalConfigHybridSearch `json:"hybridSearch,omitempty"`
	// Ranking: Optional. Config for ranking and reranking.
	Ranking *GoogleCloudAiplatformV1beta1RagRetrievalConfigRanking `json:"ranking,omitempty"`
	// TopK: Optional. The number of contexts to retrieve.
	TopK int64 `json:"topK,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1RagRetrievalConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1RagRetrievalConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1RagRetrievalConfigFilter: Config for filters.
type GoogleCloudAiplatformV1beta1RagRetrievalConfigFilter struct {
	// MetadataFilter: Optional. String for metadata filtering.
	MetadataFilter string `json:"metadataFilter,omitempty"`
	// VectorDistanceThreshold: Optional. Only returns contexts with vector
	// distance smaller than the threshold.
	VectorDistanceThreshold float64 `json:"vectorDistanceThreshold,omitempty"`
	// VectorSimilarityThreshold: Optional. Only returns contexts with vector
	// similarity larger than the threshold.
	VectorSimilarityThreshold float64 `json:"vectorSimilarityThreshold,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MetadataFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MetadataFilter") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1RagRetrievalConfigFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1RagRetrievalConfigFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1RagRetrievalConfigFilter) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1RagRetrievalConfigFilter
	var s1 struct {
		VectorDistanceThreshold   gensupport.JSONFloat64 `json:"vectorDistanceThreshold"`
		VectorSimilarityThreshold gensupport.JSONFloat64 `json:"vectorSimilarityThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.VectorDistanceThreshold = float64(s1.VectorDistanceThreshold)
	s.VectorSimilarityThreshold = float64(s1.VectorSimilarityThreshold)
	return nil
}

// GoogleCloudAiplatformV1beta1RagRetrievalConfigHybridSearch: Config for
// Hybrid Search.
type GoogleCloudAiplatformV1beta1RagRetrievalConfigHybridSearch struct {
	// Alpha: Optional. Alpha value controls the weight between dense and sparse
	// vector search results. The range is [0, 1], while 0 means sparse vector
	// search only and 1 means dense vector search only. The default value is 0.5
	// which balances sparse and dense vector search equally.
	Alpha float64 `json:"alpha,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alpha") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alpha") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1RagRetrievalConfigHybridSearch) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1RagRetrievalConfigHybridSearch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1RagRetrievalConfigHybridSearch) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1RagRetrievalConfigHybridSearch
	var s1 struct {
		Alpha gensupport.JSONFloat64 `json:"alpha"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Alpha = float64(s1.Alpha)
	return nil
}

// GoogleCloudAiplatformV1beta1RagRetrievalConfigRanking: Config for ranking
// and reranking.
type GoogleCloudAiplatformV1beta1RagRetrievalConfigRanking struct {
	// LlmRanker: Optional. Config for LlmRanker.
	LlmRanker *GoogleCloudAiplatformV1beta1RagRetrievalConfigRankingLlmRanker `json:"llmRanker,omitempty"`
	// RankService: Optional. Config for Rank Service.
	RankService *GoogleCloudAiplatformV1beta1RagRetrievalConfigRankingRankService `json:"rankService,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LlmRanker") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LlmRanker") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1RagRetrievalConfigRanking) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1RagRetrievalConfigRanking
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1RagRetrievalConfigRankingLlmRanker: Config for
// LlmRanker.
type GoogleCloudAiplatformV1beta1RagRetrievalConfigRankingLlmRanker struct {
	// ModelName: Optional. The model name used for ranking. See Supported models
	// (https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/inference#supported-models).
	ModelName string `json:"modelName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1RagRetrievalConfigRankingLlmRanker) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1RagRetrievalConfigRankingLlmRanker
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1RagRetrievalConfigRankingRankService: Config for
// Rank Service.
type GoogleCloudAiplatformV1beta1RagRetrievalConfigRankingRankService struct {
	// ModelName: Optional. The model name of the rank service. Format:
	// `semantic-ranker-512@latest`
	ModelName string `json:"modelName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1RagRetrievalConfigRankingRankService) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1RagRetrievalConfigRankingRankService
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ReplicatedVoiceConfig: The configuration for the
// replicated voice to use.
type GoogleCloudAiplatformV1beta1ReplicatedVoiceConfig struct {
	// MimeType: Optional. The mimetype of the voice sample. Currently only
	// mime_type=audio/pcm is supported, which is raw mono 16-bit signed
	// little-endian pcm data, with 24k sampling rate.
	MimeType string `json:"mimeType,omitempty"`
	// VoiceSampleAudio: Optional. The sample of the custom voice.
	VoiceSampleAudio string `json:"voiceSampleAudio,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MimeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MimeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ReplicatedVoiceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ReplicatedVoiceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Retrieval: Defines a retrieval tool that model
// can call to access external knowledge.
type GoogleCloudAiplatformV1beta1Retrieval struct {
	// DisableAttribution: Optional. Deprecated. This option is no longer
	// supported.
	DisableAttribution bool `json:"disableAttribution,omitempty"`
	// ExternalApi: Use data source powered by external API for grounding.
	ExternalApi *GoogleCloudAiplatformV1beta1ExternalApi `json:"externalApi,omitempty"`
	// VertexAiSearch: Set to use data source powered by Vertex AI Search.
	VertexAiSearch *GoogleCloudAiplatformV1beta1VertexAISearch `json:"vertexAiSearch,omitempty"`
	// VertexRagStore: Set to use data source powered by Vertex RAG store. User
	// data is uploaded via the VertexRagDataService.
	VertexRagStore *GoogleCloudAiplatformV1beta1VertexRagStore `json:"vertexRagStore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisableAttribution") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisableAttribution") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Retrieval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Retrieval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1RetrievalConfig: Retrieval config.
type GoogleCloudAiplatformV1beta1RetrievalConfig struct {
	// LanguageCode: The language code of the user.
	LanguageCode string `json:"languageCode,omitempty"`
	// LatLng: The location of the user.
	LatLng *LatLng `json:"latLng,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1RetrievalConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1RetrievalConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1RetrievalMetadata: Metadata related to the
// retrieval grounding source. This is part of the `GroundingMetadata` returned
// when grounding is enabled.
type GoogleCloudAiplatformV1beta1RetrievalMetadata struct {
	// GoogleSearchDynamicRetrievalScore: Optional. A score indicating how likely
	// it is that a Google Search query could help answer the prompt. The score is
	// in the range of `[0, 1]`. A score of 1 means the model is confident that a
	// search will be helpful, and 0 means it is not. This score is populated only
	// when Google Search grounding and dynamic retrieval are enabled. The score is
	// used to determine whether to trigger a search.
	GoogleSearchDynamicRetrievalScore float64 `json:"googleSearchDynamicRetrievalScore,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "GoogleSearchDynamicRetrievalScore") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "GoogleSearchDynamicRetrievalScore") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1RetrievalMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1RetrievalMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1RetrievalMetadata) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1RetrievalMetadata
	var s1 struct {
		GoogleSearchDynamicRetrievalScore gensupport.JSONFloat64 `json:"googleSearchDynamicRetrievalScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.GoogleSearchDynamicRetrievalScore = float64(s1.GoogleSearchDynamicRetrievalScore)
	return nil
}

// GoogleCloudAiplatformV1beta1SafetyRating: A safety rating for a piece of
// content. The safety rating contains the harm category and the harm
// probability level.
type GoogleCloudAiplatformV1beta1SafetyRating struct {
	// Blocked: Output only. Indicates whether the content was blocked because of
	// this rating.
	Blocked bool `json:"blocked,omitempty"`
	// Category: Output only. The harm category of this rating.
	//
	// Possible values:
	//   "HARM_CATEGORY_UNSPECIFIED" - Default value. This value is unused.
	//   "HARM_CATEGORY_HATE_SPEECH" - Content that promotes violence or incites
	// hatred against individuals or groups based on certain attributes.
	//   "HARM_CATEGORY_DANGEROUS_CONTENT" - Content that promotes, facilitates, or
	// enables dangerous activities.
	//   "HARM_CATEGORY_HARASSMENT" - Abusive, threatening, or content intended to
	// bully, torment, or ridicule.
	//   "HARM_CATEGORY_SEXUALLY_EXPLICIT" - Content that contains sexually
	// explicit material.
	//   "HARM_CATEGORY_CIVIC_INTEGRITY" - Deprecated: Election filter is not
	// longer supported. The harm category is civic integrity.
	//   "HARM_CATEGORY_IMAGE_HATE" - Images that contain hate speech.
	//   "HARM_CATEGORY_IMAGE_DANGEROUS_CONTENT" - Images that contain dangerous
	// content.
	//   "HARM_CATEGORY_IMAGE_HARASSMENT" - Images that contain harassment.
	//   "HARM_CATEGORY_IMAGE_SEXUALLY_EXPLICIT" - Images that contain sexually
	// explicit content.
	//   "HARM_CATEGORY_JAILBREAK" - Prompts designed to bypass safety filters.
	Category string `json:"category,omitempty"`
	// OverwrittenThreshold: Output only. The overwritten threshold for the safety
	// category of Gemini 2.0 image out. If minors are detected in the output
	// image, the threshold of each safety category will be overwritten if user
	// sets a lower threshold.
	//
	// Possible values:
	//   "HARM_BLOCK_THRESHOLD_UNSPECIFIED" - The harm block threshold is
	// unspecified.
	//   "BLOCK_LOW_AND_ABOVE" - Block content with a low harm probability or
	// higher.
	//   "BLOCK_MEDIUM_AND_ABOVE" - Block content with a medium harm probability or
	// higher.
	//   "BLOCK_ONLY_HIGH" - Block content with a high harm probability.
	//   "BLOCK_NONE" - Do not block any content, regardless of its harm
	// probability.
	//   "OFF" - Turn off the safety filter entirely.
	OverwrittenThreshold string `json:"overwrittenThreshold,omitempty"`
	// Probability: Output only. The probability of harm for this category.
	//
	// Possible values:
	//   "HARM_PROBABILITY_UNSPECIFIED" - The harm probability is unspecified.
	//   "NEGLIGIBLE" - The harm probability is negligible.
	//   "LOW" - The harm probability is low.
	//   "MEDIUM" - The harm probability is medium.
	//   "HIGH" - The harm probability is high.
	Probability string `json:"probability,omitempty"`
	// ProbabilityScore: Output only. The probability score of harm for this
	// category.
	ProbabilityScore float64 `json:"probabilityScore,omitempty"`
	// Severity: Output only. The severity of harm for this category.
	//
	// Possible values:
	//   "HARM_SEVERITY_UNSPECIFIED" - The harm severity is unspecified.
	//   "HARM_SEVERITY_NEGLIGIBLE" - The harm severity is negligible.
	//   "HARM_SEVERITY_LOW" - The harm severity is low.
	//   "HARM_SEVERITY_MEDIUM" - The harm severity is medium.
	//   "HARM_SEVERITY_HIGH" - The harm severity is high.
	Severity string `json:"severity,omitempty"`
	// SeverityScore: Output only. The severity score of harm for this category.
	SeverityScore float64 `json:"severityScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Blocked") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Blocked") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1SafetyRating) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1SafetyRating
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1SafetyRating) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1SafetyRating
	var s1 struct {
		ProbabilityScore gensupport.JSONFloat64 `json:"probabilityScore"`
		SeverityScore    gensupport.JSONFloat64 `json:"severityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ProbabilityScore = float64(s1.ProbabilityScore)
	s.SeverityScore = float64(s1.SeverityScore)
	return nil
}

// GoogleCloudAiplatformV1beta1SafetySetting: A safety setting that affects the
// safety-blocking behavior. A SafetySetting consists of a harm category and a
// threshold for that category.
type GoogleCloudAiplatformV1beta1SafetySetting struct {
	// Category: Required. The harm category to be blocked.
	//
	// Possible values:
	//   "HARM_CATEGORY_UNSPECIFIED" - Default value. This value is unused.
	//   "HARM_CATEGORY_HATE_SPEECH" - Content that promotes violence or incites
	// hatred against individuals or groups based on certain attributes.
	//   "HARM_CATEGORY_DANGEROUS_CONTENT" - Content that promotes, facilitates, or
	// enables dangerous activities.
	//   "HARM_CATEGORY_HARASSMENT" - Abusive, threatening, or content intended to
	// bully, torment, or ridicule.
	//   "HARM_CATEGORY_SEXUALLY_EXPLICIT" - Content that contains sexually
	// explicit material.
	//   "HARM_CATEGORY_CIVIC_INTEGRITY" - Deprecated: Election filter is not
	// longer supported. The harm category is civic integrity.
	//   "HARM_CATEGORY_IMAGE_HATE" - Images that contain hate speech.
	//   "HARM_CATEGORY_IMAGE_DANGEROUS_CONTENT" - Images that contain dangerous
	// content.
	//   "HARM_CATEGORY_IMAGE_HARASSMENT" - Images that contain harassment.
	//   "HARM_CATEGORY_IMAGE_SEXUALLY_EXPLICIT" - Images that contain sexually
	// explicit content.
	//   "HARM_CATEGORY_JAILBREAK" - Prompts designed to bypass safety filters.
	Category string `json:"category,omitempty"`
	// Method: Optional. The method for blocking content. If not specified, the
	// default behavior is to use the probability score.
	//
	// Possible values:
	//   "HARM_BLOCK_METHOD_UNSPECIFIED" - The harm block method is unspecified.
	//   "SEVERITY" - The harm block method uses both probability and severity
	// scores.
	//   "PROBABILITY" - The harm block method uses the probability score.
	Method string `json:"method,omitempty"`
	// Threshold: Required. The threshold for blocking content. If the harm
	// probability exceeds this threshold, the content will be blocked.
	//
	// Possible values:
	//   "HARM_BLOCK_THRESHOLD_UNSPECIFIED" - The harm block threshold is
	// unspecified.
	//   "BLOCK_LOW_AND_ABOVE" - Block content with a low harm probability or
	// higher.
	//   "BLOCK_MEDIUM_AND_ABOVE" - Block content with a medium harm probability or
	// higher.
	//   "BLOCK_ONLY_HIGH" - Block content with a high harm probability.
	//   "BLOCK_NONE" - Do not block any content, regardless of its harm
	// probability.
	//   "OFF" - Turn off the safety filter entirely.
	Threshold string `json:"threshold,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Category") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1SafetySetting) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1SafetySetting
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Schema: Schema is used to define the format of
// input/output data. Represents a select subset of an OpenAPI 3.0 schema
// object (https://spec.openapis.org/oas/v3.0.3#schema-object). More fields may
// be added in the future as needed.
type GoogleCloudAiplatformV1beta1Schema struct {
	// AdditionalProperties: Optional. Can either be a boolean or an object;
	// controls the presence of additional properties.
	AdditionalProperties interface{} `json:"additionalProperties,omitempty"`
	// AnyOf: Optional. The value should be validated against any (one or more) of
	// the subschemas in the list.
	AnyOf []*GoogleCloudAiplatformV1beta1Schema `json:"anyOf,omitempty"`
	// Default: Optional. Default value of the data.
	Default interface{} `json:"default,omitempty"`
	// Defs: Optional. A map of definitions for use by `ref` Only allowed at the
	// root of the schema.
	Defs map[string]GoogleCloudAiplatformV1beta1Schema `json:"defs,omitempty"`
	// Description: Optional. The description of the data.
	Description string `json:"description,omitempty"`
	// Enum: Optional. Possible values of the element of primitive type with enum
	// format. Examples: 1. We can define direction as : {type:STRING, format:enum,
	// enum:["EAST", NORTH", "SOUTH", "WEST"]} 2. We can define apartment number as
	// : {type:INTEGER, format:enum, enum:["101", "201", "301"]}
	Enum []string `json:"enum,omitempty"`
	// Example: Optional. Example of the object. Will only populated when the
	// object is the root.
	Example interface{} `json:"example,omitempty"`
	// Format: Optional. The format of the data. Supported formats: for NUMBER
	// type: "float", "double" for INTEGER type: "int32", "int64" for STRING type:
	// "email", "byte", etc
	Format string `json:"format,omitempty"`
	// Items: Optional. SCHEMA FIELDS FOR TYPE ARRAY Schema of the elements of
	// Type.ARRAY.
	Items *GoogleCloudAiplatformV1beta1Schema `json:"items,omitempty"`
	// MaxItems: Optional. Maximum number of the elements for Type.ARRAY.
	MaxItems int64 `json:"maxItems,omitempty,string"`
	// MaxLength: Optional. Maximum length of the Type.STRING
	MaxLength int64 `json:"maxLength,omitempty,string"`
	// MaxProperties: Optional. Maximum number of the properties for Type.OBJECT.
	MaxProperties int64 `json:"maxProperties,omitempty,string"`
	// Maximum: Optional. Maximum value of the Type.INTEGER and Type.NUMBER
	Maximum float64 `json:"maximum,omitempty"`
	// MinItems: Optional. Minimum number of the elements for Type.ARRAY.
	MinItems int64 `json:"minItems,omitempty,string"`
	// MinLength: Optional. SCHEMA FIELDS FOR TYPE STRING Minimum length of the
	// Type.STRING
	MinLength int64 `json:"minLength,omitempty,string"`
	// MinProperties: Optional. Minimum number of the properties for Type.OBJECT.
	MinProperties int64 `json:"minProperties,omitempty,string"`
	// Minimum: Optional. SCHEMA FIELDS FOR TYPE INTEGER and NUMBER Minimum value
	// of the Type.INTEGER and Type.NUMBER
	Minimum float64 `json:"minimum,omitempty"`
	// Nullable: Optional. Indicates if the value may be null.
	Nullable bool `json:"nullable,omitempty"`
	// Pattern: Optional. Pattern of the Type.STRING to restrict a string to a
	// regular expression.
	Pattern string `json:"pattern,omitempty"`
	// Properties: Optional. SCHEMA FIELDS FOR TYPE OBJECT Properties of
	// Type.OBJECT.
	Properties map[string]GoogleCloudAiplatformV1beta1Schema `json:"properties,omitempty"`
	// PropertyOrdering: Optional. The order of the properties. Not a standard
	// field in open api spec. Only used to support the order of the properties.
	PropertyOrdering []string `json:"propertyOrdering,omitempty"`
	// Ref: Optional. Allows indirect references between schema nodes. The value
	// should be a valid reference to a child of the root `defs`. For example, the
	// following schema defines a reference to a schema node named "Pet": type:
	// object properties: pet: ref: #/defs/Pet defs: Pet: type: object properties:
	// name: type: string The value of the "pet" property is a reference to the
	// schema node named "Pet". See details in
	// https://json-schema.org/understanding-json-schema/structuring
	Ref string `json:"ref,omitempty"`
	// Required: Optional. Required properties of Type.OBJECT.
	Required []string `json:"required,omitempty"`
	// Title: Optional. The title of the Schema.
	Title string `json:"title,omitempty"`
	// Type: Optional. The type of the data.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Not specified, should not be used.
	//   "STRING" - OpenAPI string type
	//   "NUMBER" - OpenAPI number type
	//   "INTEGER" - OpenAPI integer type
	//   "BOOLEAN" - OpenAPI boolean type
	//   "ARRAY" - OpenAPI array type
	//   "OBJECT" - OpenAPI object type
	//   "NULL" - Null type
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalProperties") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalProperties") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Schema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Schema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1Schema) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1Schema
	var s1 struct {
		Maximum gensupport.JSONFloat64 `json:"maximum"`
		Minimum gensupport.JSONFloat64 `json:"minimum"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Maximum = float64(s1.Maximum)
	s.Minimum = float64(s1.Minimum)
	return nil
}

// GoogleCloudAiplatformV1beta1SearchEntryPoint: An entry point for displaying
// Google Search results. A `SearchEntryPoint` is populated when the grounding
// source for a model's response is Google Search. It provides information that
// you can use to display the search results in your application.
type GoogleCloudAiplatformV1beta1SearchEntryPoint struct {
	// RenderedContent: Optional. An HTML snippet that can be embedded in a web
	// page or an application's webview. This snippet displays a search result,
	// including the title, URL, and a brief description of the search result.
	RenderedContent string `json:"renderedContent,omitempty"`
	// SdkBlob: Optional. A base64-encoded JSON object that contains a list of
	// search queries and their corresponding search URLs. This information can be
	// used to build a custom search UI.
	SdkBlob string `json:"sdkBlob,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RenderedContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RenderedContent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1SearchEntryPoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1SearchEntryPoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Segment: A segment of the content.
type GoogleCloudAiplatformV1beta1Segment struct {
	// EndIndex: Output only. The end index of the segment in the `Part`, measured
	// in bytes. This marks the end of the segment and is exclusive, meaning the
	// segment includes content up to, but not including, the byte at this index.
	EndIndex int64 `json:"endIndex,omitempty"`
	// PartIndex: Output only. The index of the `Part` object that this segment
	// belongs to. This is useful for associating the segment with a specific part
	// of the content.
	PartIndex int64 `json:"partIndex,omitempty"`
	// StartIndex: Output only. The start index of the segment in the `Part`,
	// measured in bytes. This marks the beginning of the segment and is inclusive,
	// meaning the byte at this index is the first byte of the segment.
	StartIndex int64 `json:"startIndex,omitempty"`
	// Text: Output only. The text of the segment.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Segment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Segment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1SpeakerVoiceConfig: Configuration for a single
// speaker in a multi-speaker setup.
type GoogleCloudAiplatformV1beta1SpeakerVoiceConfig struct {
	// Speaker: Required. The name of the speaker. This should be the same as the
	// speaker name used in the prompt.
	Speaker string `json:"speaker,omitempty"`
	// VoiceConfig: Required. The configuration for the voice of this speaker.
	VoiceConfig *GoogleCloudAiplatformV1beta1VoiceConfig `json:"voiceConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Speaker") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Speaker") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1SpeakerVoiceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1SpeakerVoiceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1SpeechConfig: Configuration for speech
// generation.
type GoogleCloudAiplatformV1beta1SpeechConfig struct {
	// LanguageCode: Optional. The language code (ISO 639-1) for the speech
	// synthesis.
	LanguageCode string `json:"languageCode,omitempty"`
	// MultiSpeakerVoiceConfig: The configuration for a multi-speaker
	// text-to-speech request. This field is mutually exclusive with
	// `voice_config`.
	MultiSpeakerVoiceConfig *GoogleCloudAiplatformV1beta1MultiSpeakerVoiceConfig `json:"multiSpeakerVoiceConfig,omitempty"`
	// VoiceConfig: The configuration for the voice to use.
	VoiceConfig *GoogleCloudAiplatformV1beta1VoiceConfig `json:"voiceConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1SpeechConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1SpeechConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Tool: Tool details that the model may use to
// generate response. A `Tool` is a piece of code that enables the system to
// interact with external systems to perform an action, or set of actions,
// outside of knowledge and scope of the model. A Tool object should contain
// exactly one type of Tool (e.g FunctionDeclaration, Retrieval or
// GoogleSearchRetrieval).
type GoogleCloudAiplatformV1beta1Tool struct {
	// CodeExecution: Optional. CodeExecution tool type. Enables the model to
	// execute code as part of generation.
	CodeExecution *GoogleCloudAiplatformV1beta1ToolCodeExecution `json:"codeExecution,omitempty"`
	// ComputerUse: Optional. Tool to support the model interacting directly with
	// the computer. If enabled, it automatically populates computer-use specific
	// Function Declarations.
	ComputerUse *GoogleCloudAiplatformV1beta1ToolComputerUse `json:"computerUse,omitempty"`
	// EnterpriseWebSearch: Optional. Tool to support searching public web data,
	// powered by Vertex AI Search and Sec4 compliance.
	EnterpriseWebSearch *GoogleCloudAiplatformV1beta1EnterpriseWebSearch `json:"enterpriseWebSearch,omitempty"`
	// FunctionDeclarations: Optional. Function tool type. One or more function
	// declarations to be passed to the model along with the current user query.
	// Model may decide to call a subset of these functions by populating
	// FunctionCall in the response. User should provide a FunctionResponse for
	// each function call in the next turn. Based on the function responses, Model
	// will generate the final response back to the user. Maximum 512 function
	// declarations can be provided.
	FunctionDeclarations []*GoogleCloudAiplatformV1beta1FunctionDeclaration `json:"functionDeclarations,omitempty"`
	// GoogleMaps: Optional. GoogleMaps tool type. Tool to support Google Maps in
	// Model.
	GoogleMaps *GoogleCloudAiplatformV1beta1GoogleMaps `json:"googleMaps,omitempty"`
	// GoogleSearch: Optional. GoogleSearch tool type. Tool to support Google
	// Search in Model. Powered by Google.
	GoogleSearch *GoogleCloudAiplatformV1beta1ToolGoogleSearch `json:"googleSearch,omitempty"`
	// GoogleSearchRetrieval: Optional. Specialized retrieval tool that is powered
	// by Google Search.
	GoogleSearchRetrieval *GoogleCloudAiplatformV1beta1GoogleSearchRetrieval `json:"googleSearchRetrieval,omitempty"`
	// Retrieval: Optional. Retrieval tool type. System will always execute the
	// provided retrieval tool(s) to get external knowledge to answer the prompt.
	// Retrieval results are presented to the model for generation.
	Retrieval *GoogleCloudAiplatformV1beta1Retrieval `json:"retrieval,omitempty"`
	// UrlContext: Optional. Tool to support URL context retrieval.
	UrlContext *GoogleCloudAiplatformV1beta1UrlContext `json:"urlContext,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CodeExecution") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CodeExecution") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Tool) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Tool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ToolCodeExecution: Tool that executes code
// generated by the model, and automatically returns the result to the model.
// See also [ExecutableCode]and [CodeExecutionResult] which are input and
// output to this tool.
type GoogleCloudAiplatformV1beta1ToolCodeExecution struct {
}

// GoogleCloudAiplatformV1beta1ToolComputerUse: Tool to support computer use.
type GoogleCloudAiplatformV1beta1ToolComputerUse struct {
	// Environment: Required. The environment being operated.
	//
	// Possible values:
	//   "ENVIRONMENT_UNSPECIFIED" - Defaults to browser.
	//   "ENVIRONMENT_BROWSER" - Operates in a web browser.
	Environment string `json:"environment,omitempty"`
	// ExcludedPredefinedFunctions: Optional. By default, predefined functions
	// (https://cloud.google.com/vertex-ai/generative-ai/docs/computer-use#supported-actions)
	// are included in the final model call. Some of them can be explicitly
	// excluded from being automatically included. This can serve two purposes: 1.
	// Using a more restricted / different action space. 2. Improving the
	// definitions / instructions of predefined functions.
	ExcludedPredefinedFunctions []string `json:"excludedPredefinedFunctions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Environment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Environment") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ToolComputerUse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ToolComputerUse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ToolConfig: Tool config. This config is shared
// for all tools provided in the request.
type GoogleCloudAiplatformV1beta1ToolConfig struct {
	// FunctionCallingConfig: Optional. Function calling config.
	FunctionCallingConfig *GoogleCloudAiplatformV1beta1FunctionCallingConfig `json:"functionCallingConfig,omitempty"`
	// RetrievalConfig: Optional. Retrieval config.
	RetrievalConfig *GoogleCloudAiplatformV1beta1RetrievalConfig `json:"retrievalConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FunctionCallingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FunctionCallingConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ToolConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ToolConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ToolGoogleSearch: GoogleSearch tool type. Tool
// to support Google Search in Model. Powered by Google.
type GoogleCloudAiplatformV1beta1ToolGoogleSearch struct {
	// BlockingConfidence: Optional. Sites with confidence level chosen & above
	// this value will be blocked from the search results.
	//
	// Possible values:
	//   "PHISH_BLOCK_THRESHOLD_UNSPECIFIED" - Defaults to unspecified.
	//   "BLOCK_LOW_AND_ABOVE" - Blocks Low and above confidence URL that is risky.
	//   "BLOCK_MEDIUM_AND_ABOVE" - Blocks Medium and above confidence URL that is
	// risky.
	//   "BLOCK_HIGH_AND_ABOVE" - Blocks High and above confidence URL that is
	// risky.
	//   "BLOCK_HIGHER_AND_ABOVE" - Blocks Higher and above confidence URL that is
	// risky.
	//   "BLOCK_VERY_HIGH_AND_ABOVE" - Blocks Very high and above confidence URL
	// that is risky.
	//   "BLOCK_ONLY_EXTREMELY_HIGH" - Blocks Extremely high confidence URL that is
	// risky.
	BlockingConfidence string `json:"blockingConfidence,omitempty"`
	// ExcludeDomains: Optional. List of domains to be excluded from the search
	// results. The default limit is 2000 domains. Example: ["amazon.com",
	// "facebook.com"].
	ExcludeDomains []string `json:"excludeDomains,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlockingConfidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockingConfidence") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ToolGoogleSearch) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ToolGoogleSearch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1UrlContext: Tool to support URL context.
type GoogleCloudAiplatformV1beta1UrlContext struct {
}

// GoogleCloudAiplatformV1beta1UrlContextMetadata: Metadata returned when the
// model uses the `url_context` tool to get information from a user-provided
// URL.
type GoogleCloudAiplatformV1beta1UrlContextMetadata struct {
	// UrlMetadata: Output only. A list of URL metadata, with one entry for each
	// URL retrieved by the tool.
	UrlMetadata []*GoogleCloudAiplatformV1beta1UrlMetadata `json:"urlMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UrlMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UrlMetadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1UrlContextMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1UrlContextMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1UrlMetadata: The metadata for a single URL
// retrieval.
type GoogleCloudAiplatformV1beta1UrlMetadata struct {
	// RetrievedUrl: The URL retrieved by the tool.
	RetrievedUrl string `json:"retrievedUrl,omitempty"`
	// UrlRetrievalStatus: The status of the URL retrieval.
	//
	// Possible values:
	//   "URL_RETRIEVAL_STATUS_UNSPECIFIED" - Default value. This value is unused.
	//   "URL_RETRIEVAL_STATUS_SUCCESS" - The URL was retrieved successfully.
	//   "URL_RETRIEVAL_STATUS_ERROR" - The URL retrieval failed.
	UrlRetrievalStatus string `json:"urlRetrievalStatus,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RetrievedUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RetrievedUrl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1UrlMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1UrlMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1VertexAISearch: Retrieve from Vertex AI Search
// datastore or engine for grounding. datastore and engine are mutually
// exclusive. See https://cloud.google.com/products/agent-builder
type GoogleCloudAiplatformV1beta1VertexAISearch struct {
	// DataStoreSpecs: Specifications that define the specific DataStores to be
	// searched, along with configurations for those data stores. This is only
	// considered for Engines with multiple data stores. It should only be set if
	// engine is used.
	DataStoreSpecs []*GoogleCloudAiplatformV1beta1VertexAISearchDataStoreSpec `json:"dataStoreSpecs,omitempty"`
	// Datastore: Optional. Fully-qualified Vertex AI Search data store resource
	// ID. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {dataStore}`
	Datastore string `json:"datastore,omitempty"`
	// Engine: Optional. Fully-qualified Vertex AI Search engine resource ID.
	// Format:
	// `projects/{project}/locations/{location}/collections/{collection}/engines/{en
	// gine}`
	Engine string `json:"engine,omitempty"`
	// Filter: Optional. Filter strings to be passed to the search API.
	Filter string `json:"filter,omitempty"`
	// MaxResults: Optional. Number of search results to return per query. The
	// default value is 10. The maximumm allowed value is 10.
	MaxResults int64 `json:"maxResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStoreSpecs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStoreSpecs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1VertexAISearch) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1VertexAISearch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1VertexAISearchDataStoreSpec: Define data stores
// within engine to filter on in a search call and configurations for those
// data stores. For more information, see
// https://cloud.google.com/generative-ai-app-builder/docs/reference/rpc/google.cloud.discoveryengine.v1#datastorespec
type GoogleCloudAiplatformV1beta1VertexAISearchDataStoreSpec struct {
	// DataStore: Full resource name of DataStore, such as Format:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {dataStore}`
	DataStore string `json:"dataStore,omitempty"`
	// Filter: Optional. Filter specification to filter documents in the data store
	// specified by data_store field. For more information on filtering, see
	// Filtering
	// (https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1VertexAISearchDataStoreSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1VertexAISearchDataStoreSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1VertexRagStore: Retrieve from Vertex RAG Store
// for grounding.
type GoogleCloudAiplatformV1beta1VertexRagStore struct {
	// RagCorpora: Optional. Deprecated. Please use rag_resources instead.
	RagCorpora []string `json:"ragCorpora,omitempty"`
	// RagResources: Optional. The representation of the rag source. It can be used
	// to specify corpus only or ragfiles. Currently only support one corpus or
	// multiple files from one corpus. In the future we may open up multiple
	// corpora support.
	RagResources []*GoogleCloudAiplatformV1beta1VertexRagStoreRagResource `json:"ragResources,omitempty"`
	// RagRetrievalConfig: Optional. The retrieval config for the Rag query.
	RagRetrievalConfig *GoogleCloudAiplatformV1beta1RagRetrievalConfig `json:"ragRetrievalConfig,omitempty"`
	// SimilarityTopK: Optional. Number of top k results to return from the
	// selected corpora.
	SimilarityTopK int64 `json:"similarityTopK,omitempty"`
	// StoreContext: Optional. Currently only supported for Gemini Multimodal Live
	// API. In Gemini Multimodal Live API, if `store_context` bool is specified,
	// Gemini will leverage it to automatically memorize the interactions between
	// the client and Gemini, and retrieve context when needed to augment the
	// response generation for users' ongoing and future interactions.
	StoreContext bool `json:"storeContext,omitempty"`
	// VectorDistanceThreshold: Optional. Only return results with vector distance
	// smaller than the threshold.
	VectorDistanceThreshold float64 `json:"vectorDistanceThreshold,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RagCorpora") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RagCorpora") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1VertexRagStore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1VertexRagStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1VertexRagStore) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1VertexRagStore
	var s1 struct {
		VectorDistanceThreshold gensupport.JSONFloat64 `json:"vectorDistanceThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.VectorDistanceThreshold = float64(s1.VectorDistanceThreshold)
	return nil
}

// GoogleCloudAiplatformV1beta1VertexRagStoreRagResource: The definition of the
// Rag resource.
type GoogleCloudAiplatformV1beta1VertexRagStoreRagResource struct {
	// RagCorpus: Optional. RagCorpora resource name. Format:
	// `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
	RagCorpus string `json:"ragCorpus,omitempty"`
	// RagFileIds: Optional. rag_file_id. The files should be in the same
	// rag_corpus set in rag_corpus field.
	RagFileIds []string `json:"ragFileIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RagCorpus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RagCorpus") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1VertexRagStoreRagResource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1VertexRagStoreRagResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1VideoMetadata: Provides metadata for a video,
// including the start and end offsets for clipping and the frame rate.
type GoogleCloudAiplatformV1beta1VideoMetadata struct {
	// EndOffset: Optional. The end offset of the video.
	EndOffset string `json:"endOffset,omitempty"`
	// Fps: Optional. The frame rate of the video sent to the model. If not
	// specified, the default value is 1.0. The valid range is (0.0, 24.0].
	Fps float64 `json:"fps,omitempty"`
	// StartOffset: Optional. The start offset of the video.
	StartOffset string `json:"startOffset,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndOffset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndOffset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1VideoMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1VideoMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1VideoMetadata) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1VideoMetadata
	var s1 struct {
		Fps gensupport.JSONFloat64 `json:"fps"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Fps = float64(s1.Fps)
	return nil
}

// GoogleCloudAiplatformV1beta1VoiceConfig: Configuration for a voice.
type GoogleCloudAiplatformV1beta1VoiceConfig struct {
	// PrebuiltVoiceConfig: The configuration for a prebuilt voice.
	PrebuiltVoiceConfig *GoogleCloudAiplatformV1beta1PrebuiltVoiceConfig `json:"prebuiltVoiceConfig,omitempty"`
	// ReplicatedVoiceConfig: Optional. The configuration for a replicated voice.
	// This enables users to replicate a voice from an audio sample.
	ReplicatedVoiceConfig *GoogleCloudAiplatformV1beta1ReplicatedVoiceConfig `json:"replicatedVoiceConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PrebuiltVoiceConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PrebuiltVoiceConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1VoiceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1VoiceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LatLng: An object that represents a latitude/longitude pair. This is
// expressed as a pair of doubles to represent degrees latitude and degrees
// longitude. Unless specified otherwise, this object must conform to the WGS84
// standard. Values must be within normalized ranges.
type LatLng struct {
	// Latitude: The latitude in degrees. It must be in the range [-90.0, +90.0].
	Latitude float64 `json:"latitude,omitempty"`
	// Longitude: The longitude in degrees. It must be in the range [-180.0,
	// +180.0].
	Longitude float64 `json:"longitude,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Latitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Latitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LatLng) MarshalJSON() ([]byte, error) {
	type NoMethod LatLng
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *LatLng) UnmarshalJSON(data []byte) error {
	type NoMethod LatLng
	var s1 struct {
		Latitude  gensupport.JSONFloat64 `json:"latitude"`
		Longitude gensupport.JSONFloat64 `json:"longitude"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Latitude = float64(s1.Latitude)
	s.Longitude = float64(s1.Longitude)
	return nil
}

// ModelOperationMetadata: This is returned in the longrunning operations for
// create/update.
type ModelOperationMetadata struct {
	// Possible values:
	//   "BASIC_OPERATION_STATUS_UNSPECIFIED" - The status is unspecified
	//   "BASIC_OPERATION_STATUS_UPLOADING" - The model file is being uploaded
	//   "BASIC_OPERATION_STATUS_VERIFYING" - The model file is being verified
	BasicOperationStatus string `json:"basicOperationStatus,omitempty"`
	// Name: The name of the model we are creating/updating The name must have the
	// form `projects/{project_id}/models/{model_id}`
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicOperationStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicOperationStatus") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod ModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsLocationsPublishersModelsCountTokensCall struct {
	s                                              *Service
	endpoint                                       string
	googlecloudaiplatformv1beta1counttokensrequest *GoogleCloudAiplatformV1beta1CountTokensRequest
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// CountTokens: Perform a token counting.
//
//   - endpoint: The name of the Endpoint requested to perform token counting.
//     Format: `projects/{project}/locations/{location}/endpoints/{endpoint}`.
func (r *ProjectsLocationsPublishersModelsService) CountTokens(endpoint string, googlecloudaiplatformv1beta1counttokensrequest *GoogleCloudAiplatformV1beta1CountTokensRequest) *ProjectsLocationsPublishersModelsCountTokensCall {
	c := &ProjectsLocationsPublishersModelsCountTokensCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.endpoint = endpoint
	c.googlecloudaiplatformv1beta1counttokensrequest = googlecloudaiplatformv1beta1counttokensrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPublishersModelsCountTokensCall) Fields(s ...googleapi.Field) *ProjectsLocationsPublishersModelsCountTokensCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPublishersModelsCountTokensCall) Context(ctx context.Context) *ProjectsLocationsPublishersModelsCountTokensCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPublishersModelsCountTokensCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPublishersModelsCountTokensCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudaiplatformv1beta1counttokensrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2beta/{+endpoint}:countTokens")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"endpoint": c.endpoint,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseml.projects.locations.publishers.models.countTokens", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseml.projects.locations.publishers.models.countTokens" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudAiplatformV1beta1CountTokensResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPublishersModelsCountTokensCall) Do(opts ...googleapi.CallOption) (*GoogleCloudAiplatformV1beta1CountTokensResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudAiplatformV1beta1CountTokensResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseml.projects.locations.publishers.models.countTokens", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsPublishersModelsGenerateContentCall struct {
	s                                                  *Service
	model                                              string
	googlecloudaiplatformv1beta1generatecontentrequest *GoogleCloudAiplatformV1beta1GenerateContentRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// GenerateContent: Generate content with multimodal inputs.
//
//   - model: The fully qualified name of the publisher model or tuned model
//     endpoint to use. Publisher model format:
//     `projects/{project}/locations/{location}/publishers/*/models/*` Tuned
//     model endpoint format:
//     `projects/{project}/locations/{location}/endpoints/{endpoint}`.
func (r *ProjectsLocationsPublishersModelsService) GenerateContent(model string, googlecloudaiplatformv1beta1generatecontentrequest *GoogleCloudAiplatformV1beta1GenerateContentRequest) *ProjectsLocationsPublishersModelsGenerateContentCall {
	c := &ProjectsLocationsPublishersModelsGenerateContentCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.model = model
	c.googlecloudaiplatformv1beta1generatecontentrequest = googlecloudaiplatformv1beta1generatecontentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPublishersModelsGenerateContentCall) Fields(s ...googleapi.Field) *ProjectsLocationsPublishersModelsGenerateContentCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPublishersModelsGenerateContentCall) Context(ctx context.Context) *ProjectsLocationsPublishersModelsGenerateContentCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPublishersModelsGenerateContentCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPublishersModelsGenerateContentCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudaiplatformv1beta1generatecontentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2beta/{+model}:generateContent")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"model": c.model,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseml.projects.locations.publishers.models.generateContent", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseml.projects.locations.publishers.models.generateContent" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudAiplatformV1beta1GenerateContentResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPublishersModelsGenerateContentCall) Do(opts ...googleapi.CallOption) (*GoogleCloudAiplatformV1beta1GenerateContentResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudAiplatformV1beta1GenerateContentResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseml.projects.locations.publishers.models.generateContent", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsPublishersModelsStreamGenerateContentCall struct {
	s                                                  *Service
	model                                              string
	googlecloudaiplatformv1beta1generatecontentrequest *GoogleCloudAiplatformV1beta1GenerateContentRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// StreamGenerateContent: Generate content with multimodal inputs with
// streaming support.
//
//   - model: The fully qualified name of the publisher model or tuned model
//     endpoint to use. Publisher model format:
//     `projects/{project}/locations/{location}/publishers/*/models/*` Tuned
//     model endpoint format:
//     `projects/{project}/locations/{location}/endpoints/{endpoint}`.
func (r *ProjectsLocationsPublishersModelsService) StreamGenerateContent(model string, googlecloudaiplatformv1beta1generatecontentrequest *GoogleCloudAiplatformV1beta1GenerateContentRequest) *ProjectsLocationsPublishersModelsStreamGenerateContentCall {
	c := &ProjectsLocationsPublishersModelsStreamGenerateContentCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.model = model
	c.googlecloudaiplatformv1beta1generatecontentrequest = googlecloudaiplatformv1beta1generatecontentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPublishersModelsStreamGenerateContentCall) Fields(s ...googleapi.Field) *ProjectsLocationsPublishersModelsStreamGenerateContentCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPublishersModelsStreamGenerateContentCall) Context(ctx context.Context) *ProjectsLocationsPublishersModelsStreamGenerateContentCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPublishersModelsStreamGenerateContentCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPublishersModelsStreamGenerateContentCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudaiplatformv1beta1generatecontentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2beta/{+model}:streamGenerateContent")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"model": c.model,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseml.projects.locations.publishers.models.streamGenerateContent", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseml.projects.locations.publishers.models.streamGenerateContent" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudAiplatformV1beta1GenerateContentResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPublishersModelsStreamGenerateContentCall) Do(opts ...googleapi.CallOption) (*GoogleCloudAiplatformV1beta1GenerateContentResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudAiplatformV1beta1GenerateContentResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseml.projects.locations.publishers.models.streamGenerateContent", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
