// DO NOT EDIT: This file is autogenerated via the builtin command.

package sampledata

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 2,
					Line:   194,
				},
				File:   "sampledata.flux",
				Source: "package sampledata\n\n\nimport \"csv\"\n\n// start and stop constants provide start and stop times to be used with `range`\n// when `_start` and `_stop` columns are required to demonstrate a transformation.\n// All sample data points are between start and stop.\n//\nstart = 2021-01-01T00:00:00Z\nstop = 2021-01-01T00:01:00Z\n\n_numeric = (includeNull=false) => \"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,double\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,-2.18\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"10.92\") + \"\n,,0,2021-01-01T00:00:20Z,t1,7.35\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"17.53\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"15.23\") + \"\n,,0,2021-01-01T00:00:50Z,t1,4.43\n,,1,2021-01-01T00:00:00Z,t2,\" + (if includeNull then \"\" else \"19.85\") + \"\n,,1,2021-01-01T00:00:10Z,t2,4.97\n,,1,2021-01-01T00:00:20Z,t2,-3.75\n,,1,2021-01-01T00:00:30Z,t2,19.77\n,,1,2021-01-01T00:00:40Z,t2,\" + (if includeNull then \"\" else \"13.86\") + \"\n,,1,2021-01-01T00:00:50Z,t2,1.86\n\"\n\n_string = (includeNull=false) => \"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,string\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,smpl_g9qczs\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"smpl_0mgv9n\") + \"\n,,0,2021-01-01T00:00:20Z,t1,smpl_phw664\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"smpl_guvzy4\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"smpl_5v3cce\") + \"\n,,0,2021-01-01T00:00:50Z,t1,smpl_s9fmgy\n,,1,2021-01-01T00:00:00Z,t2,\" + (if includeNull then \"\" else \"smpl_b5eida\") + \"\n,,1,2021-01-01T00:00:10Z,t2,smpl_eu4oxp\n,,1,2021-01-01T00:00:20Z,t2,smpl_5g7tz4\n,,1,2021-01-01T00:00:30Z,t2,smpl_sox1ut\n,,1,2021-01-01T00:00:40Z,t2,\" + (if includeNull then \"\" else \"smpl_wfm757\") + \"\n,,1,2021-01-01T00:00:50Z,t2,smpl_dtn2bv\n\"\n\n_bool = (includeNull=false) => \"#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,boolean\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,true\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"true\") + \"\n,,0,2021-01-01T00:00:20Z,t1,false\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"true\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"false\") + \"\n,,0,2021-01-01T00:00:50Z,t1,false\n,,1,2021-01-01T00:00:00Z,t2,\" + (if includeNull then \"\" else \"false\") + \"\n,,1,2021-01-01T00:00:10Z,t2,true\n,,1,2021-01-01T00:00:20Z,t2,false\n,,1,2021-01-01T00:00:30Z,t2,true\n,,1,2021-01-01T00:00:40Z,t2,\" + (if includeNull then \"\" else \"true\") + \"\n,,1,2021-01-01T00:00:50Z,t2,false\n\"\n\n// float returns a sample data set with float values.\n//\n// ## Parameters\n//\n// - `includeNull` indicates whether or not to include null values in the returned dataset.\n//   Default is `false`.\n//\n// ## Output basic sample data with float values\n//\n// ```\n// import \"sampledata\"\n//\n// sampledata.float()\n// ```\n// \nfloat = (includeNull=false) => {\n    _csvData = _numeric(includeNull: includeNull)\n\n    return csv.from(csv: _csvData)\n}\n\n// int returns a sample data set with integer values.\n//\n// ## Parameters\n//\n// - `includeNull` indicates whether or not to include null values in the returned dataset.\n//   Default is `false`.\n//\n// ## Output basic sample data with integer values\n//\n// ```\n// import \"sampledata\"\n//\n// sampledata.int()\n// ```\n//\nint = (includeNull=false) => {\n    _csvData = _numeric(includeNull: includeNull)\n\n    return csv.from(csv: _csvData) |> toInt()\n}\n\n// uint returns a sample data set with unsigned integer values.\n//\n// ## Parameters\n//\n// - `includeNull` indicates whether or not to include null values in the returned dataset.\n//   Default is `false`.\n//\n// ## Output basic sample data with unsigned integer values\n//\n// ```\n// import \"sampledata\"\n//\n// sampledata.uint()\n// ```\n//\nuint = (includeNull=false) => {\n    _csvData = _numeric(includeNull: includeNull)\n\n    return csv.from(csv: _csvData) |> toUInt()\n}\n\n// string returns a sample data set with string values.\n//\n// ## Parameters\n//\n// - `includeNull` indicates whether or not to include null values in the returned dataset.\n//   Default is `false`.\n//\n// ## Output basic sample data with string values\n//\n// ```\n// import \"sampledata\"\n//\n// sampledata.string()\n// ```\n// \nstring = (includeNull=false) => {\n    _csvData = _string(includeNull: includeNull)\n\n    return csv.from(csv: _csvData)\n}\n\n// bool returns a sample data set with boolean values.\n//\n// ## Parameters\n//\n// - `includeNull` indicates whether or not to include null values in the returned dataset.\n//   Default is `false`.\n//\n// ## Output basic sample data with boolean values\n//\n// ```\n// import \"sampledata\"\n//\n// sampledata.bool()\n// ```\n// \nbool = (includeNull=false) => {\n    _csvData = _bool(includeNull: includeNull)\n\n    return csv.from(csv: _csvData)\n}\n\n// numericBool returns a sample data set with numeric (integer) boolean values.\n//\n// ## Parameters\n//\n// - `includeNull` indicates whether or not to include null values in the returned dataset.\n//   Default is `false`.\n//\n// ## Output basic sample data with numeric boolean values\n//\n// ```\n// import \"sampledata\"\n//\n// sampledata.numericBool()\n// ```\n// \nnumericBool = (includeNull=false) => {\n    _csvData = _bool(includeNull: includeNull)\n\n    return csv.from(csv: _csvData) |> toInt()\n}",
				Start: ast.Position{
					Column: 1,
					Line:   2,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 29,
						Line:   11,
					},
					File:   "sampledata.flux",
					Source: "start = 2021-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   11,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// start and stop constants provide start and stop times to be used with `range`\n"}, ast.Comment{Text: "// when `_start` and `_stop` columns are required to demonstrate a transformation.\n"}, ast.Comment{Text: "// All sample data points are between start and stop.\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   11,
						},
						File:   "sampledata.flux",
						Source: "start",
						Start: ast.Position{
							Column: 1,
							Line:   11,
						},
					},
				},
				Name: "start",
			},
			Init: &ast.DateTimeLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 29,
							Line:   11,
						},
						File:   "sampledata.flux",
						Source: "2021-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 9,
							Line:   11,
						},
					},
				},
				Value: parser.MustParseTime("2021-01-01T00:00:00Z"),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 28,
						Line:   12,
					},
					File:   "sampledata.flux",
					Source: "stop = 2021-01-01T00:01:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   12,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   12,
						},
						File:   "sampledata.flux",
						Source: "stop",
						Start: ast.Position{
							Column: 1,
							Line:   12,
						},
					},
				},
				Name: "stop",
			},
			Init: &ast.DateTimeLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 28,
							Line:   12,
						},
						File:   "sampledata.flux",
						Source: "2021-01-01T00:01:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   12,
						},
					},
				},
				Value: parser.MustParseTime("2021-01-01T00:01:00Z"),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   31,
					},
					File:   "sampledata.flux",
					Source: "_numeric = (includeNull=false) => \"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,double\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,-2.18\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"10.92\") + \"\n,,0,2021-01-01T00:00:20Z,t1,7.35\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"17.53\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"15.23\") + \"\n,,0,2021-01-01T00:00:50Z,t1,4.43\n,,1,2021-01-01T00:00:00Z,t2,\" + (if includeNull then \"\" else \"19.85\") + \"\n,,1,2021-01-01T00:00:10Z,t2,4.97\n,,1,2021-01-01T00:00:20Z,t2,-3.75\n,,1,2021-01-01T00:00:30Z,t2,19.77\n,,1,2021-01-01T00:00:40Z,t2,\" + (if includeNull then \"\" else \"13.86\") + \"\n,,1,2021-01-01T00:00:50Z,t2,1.86\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   14,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   14,
						},
						File:   "sampledata.flux",
						Source: "_numeric",
						Start: ast.Position{
							Column: 1,
							Line:   14,
						},
					},
				},
				Name: "_numeric",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   31,
						},
						File:   "sampledata.flux",
						Source: "(includeNull=false) => \"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,double\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,-2.18\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"10.92\") + \"\n,,0,2021-01-01T00:00:20Z,t1,7.35\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"17.53\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"15.23\") + \"\n,,0,2021-01-01T00:00:50Z,t1,4.43\n,,1,2021-01-01T00:00:00Z,t2,\" + (if includeNull then \"\" else \"19.85\") + \"\n,,1,2021-01-01T00:00:10Z,t2,4.97\n,,1,2021-01-01T00:00:20Z,t2,-3.75\n,,1,2021-01-01T00:00:30Z,t2,19.77\n,,1,2021-01-01T00:00:40Z,t2,\" + (if includeNull then \"\" else \"13.86\") + \"\n,,1,2021-01-01T00:00:50Z,t2,1.86\n\"",
						Start: ast.Position{
							Column: 12,
							Line:   14,
						},
					},
				},
				Body: &ast.BinaryExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   31,
							},
							File:   "sampledata.flux",
							Source: "\"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,double\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,-2.18\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"10.92\") + \"\n,,0,2021-01-01T00:00:20Z,t1,7.35\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"17.53\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"15.23\") + \"\n,,0,2021-01-01T00:00:50Z,t1,4.43\n,,1,2021-01-01T00:00:00Z,t2,\" + (if includeNull then \"\" else \"19.85\") + \"\n,,1,2021-01-01T00:00:10Z,t2,4.97\n,,1,2021-01-01T00:00:20Z,t2,-3.75\n,,1,2021-01-01T00:00:30Z,t2,19.77\n,,1,2021-01-01T00:00:40Z,t2,\" + (if includeNull then \"\" else \"13.86\") + \"\n,,1,2021-01-01T00:00:50Z,t2,1.86\n\"",
							Start: ast.Position{
								Column: 35,
								Line:   14,
							},
						},
					},
					Left: &ast.BinaryExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   29,
								},
								File:   "sampledata.flux",
								Source: "\"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,double\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,-2.18\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"10.92\") + \"\n,,0,2021-01-01T00:00:20Z,t1,7.35\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"17.53\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"15.23\") + \"\n,,0,2021-01-01T00:00:50Z,t1,4.43\n,,1,2021-01-01T00:00:00Z,t2,\" + (if includeNull then \"\" else \"19.85\") + \"\n,,1,2021-01-01T00:00:10Z,t2,4.97\n,,1,2021-01-01T00:00:20Z,t2,-3.75\n,,1,2021-01-01T00:00:30Z,t2,19.77\n,,1,2021-01-01T00:00:40Z,t2,\" + (if includeNull then \"\" else \"13.86\")",
								Start: ast.Position{
									Column: 35,
									Line:   14,
								},
							},
						},
						Left: &ast.BinaryExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   29,
									},
									File:   "sampledata.flux",
									Source: "\"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,double\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,-2.18\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"10.92\") + \"\n,,0,2021-01-01T00:00:20Z,t1,7.35\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"17.53\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"15.23\") + \"\n,,0,2021-01-01T00:00:50Z,t1,4.43\n,,1,2021-01-01T00:00:00Z,t2,\" + (if includeNull then \"\" else \"19.85\") + \"\n,,1,2021-01-01T00:00:10Z,t2,4.97\n,,1,2021-01-01T00:00:20Z,t2,-3.75\n,,1,2021-01-01T00:00:30Z,t2,19.77\n,,1,2021-01-01T00:00:40Z,t2,\"",
									Start: ast.Position{
										Column: 35,
										Line:   14,
									},
								},
							},
							Left: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   25,
										},
										File:   "sampledata.flux",
										Source: "\"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,double\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,-2.18\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"10.92\") + \"\n,,0,2021-01-01T00:00:20Z,t1,7.35\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"17.53\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"15.23\") + \"\n,,0,2021-01-01T00:00:50Z,t1,4.43\n,,1,2021-01-01T00:00:00Z,t2,\" + (if includeNull then \"\" else \"19.85\")",
										Start: ast.Position{
											Column: 35,
											Line:   14,
										},
									},
								},
								Left: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   25,
											},
											File:   "sampledata.flux",
											Source: "\"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,double\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,-2.18\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"10.92\") + \"\n,,0,2021-01-01T00:00:20Z,t1,7.35\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"17.53\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"15.23\") + \"\n,,0,2021-01-01T00:00:50Z,t1,4.43\n,,1,2021-01-01T00:00:00Z,t2,\"",
											Start: ast.Position{
												Column: 35,
												Line:   14,
											},
										},
									},
									Left: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   23,
												},
												File:   "sampledata.flux",
												Source: "\"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,double\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,-2.18\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"10.92\") + \"\n,,0,2021-01-01T00:00:20Z,t1,7.35\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"17.53\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"15.23\")",
												Start: ast.Position{
													Column: 35,
													Line:   14,
												},
											},
										},
										Left: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   23,
													},
													File:   "sampledata.flux",
													Source: "\"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,double\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,-2.18\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"10.92\") + \"\n,,0,2021-01-01T00:00:20Z,t1,7.35\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"17.53\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\"",
													Start: ast.Position{
														Column: 35,
														Line:   14,
													},
												},
											},
											Left: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   22,
														},
														File:   "sampledata.flux",
														Source: "\"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,double\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,-2.18\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"10.92\") + \"\n,,0,2021-01-01T00:00:20Z,t1,7.35\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"17.53\")",
														Start: ast.Position{
															Column: 35,
															Line:   14,
														},
													},
												},
												Left: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   22,
															},
															File:   "sampledata.flux",
															Source: "\"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,double\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,-2.18\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"10.92\") + \"\n,,0,2021-01-01T00:00:20Z,t1,7.35\n,,0,2021-01-01T00:00:30Z,t1,\"",
															Start: ast.Position{
																Column: 35,
																Line:   14,
															},
														},
													},
													Left: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 70,
																	Line:   20,
																},
																File:   "sampledata.flux",
																Source: "\"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,double\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,-2.18\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"10.92\")",
																Start: ast.Position{
																	Column: 35,
																	Line:   14,
																},
															},
														},
														Left: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 30,
																		Line:   20,
																	},
																	File:   "sampledata.flux",
																	Source: "\"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,double\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,-2.18\n,,0,2021-01-01T00:00:10Z,t1,\"",
																	Start: ast.Position{
																		Column: 35,
																		Line:   14,
																	},
																},
															},
															Value: "\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,double\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,-2.18\n,,0,2021-01-01T00:00:10Z,t1,",
														},
														Operator: 5,
														Right: &ast.ParenExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 70,
																		Line:   20,
																	},
																	File:   "sampledata.flux",
																	Source: "(if includeNull then \"\" else \"10.92\")",
																	Start: ast.Position{
																		Column: 33,
																		Line:   20,
																	},
																},
															},
															Expression: &ast.ConditionalExpression{
																Alternate: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 69,
																				Line:   20,
																			},
																			File:   "sampledata.flux",
																			Source: "\"10.92\"",
																			Start: ast.Position{
																				Column: 62,
																				Line:   20,
																			},
																		},
																	},
																	Value: "10.92",
																},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 69,
																			Line:   20,
																		},
																		File:   "sampledata.flux",
																		Source: "if includeNull then \"\" else \"10.92\"",
																		Start: ast.Position{
																			Column: 34,
																			Line:   20,
																		},
																	},
																},
																Consequent: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 56,
																				Line:   20,
																			},
																			File:   "sampledata.flux",
																			Source: "\"\"",
																			Start: ast.Position{
																				Column: 54,
																				Line:   20,
																			},
																		},
																	},
																	Value: "",
																},
																Test: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 48,
																				Line:   20,
																			},
																			File:   "sampledata.flux",
																			Source: "includeNull",
																			Start: ast.Position{
																				Column: 37,
																				Line:   20,
																			},
																		},
																	},
																	Name: "includeNull",
																},
																Tk_else: nil,
																Tk_if:   nil,
																Tk_then: nil,
															},
															Lparen: nil,
															Rparen: nil,
														},
													},
													Operator: 5,
													Right: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   22,
																},
																File:   "sampledata.flux",
																Source: "\"\n,,0,2021-01-01T00:00:20Z,t1,7.35\n,,0,2021-01-01T00:00:30Z,t1,\"",
																Start: ast.Position{
																	Column: 73,
																	Line:   20,
																},
															},
														},
														Value: "\n,,0,2021-01-01T00:00:20Z,t1,7.35\n,,0,2021-01-01T00:00:30Z,t1,",
													},
												},
												Operator: 5,
												Right: &ast.ParenExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 70,
																Line:   22,
															},
															File:   "sampledata.flux",
															Source: "(if includeNull then \"\" else \"17.53\")",
															Start: ast.Position{
																Column: 33,
																Line:   22,
															},
														},
													},
													Expression: &ast.ConditionalExpression{
														Alternate: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 69,
																		Line:   22,
																	},
																	File:   "sampledata.flux",
																	Source: "\"17.53\"",
																	Start: ast.Position{
																		Column: 62,
																		Line:   22,
																	},
																},
															},
															Value: "17.53",
														},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 69,
																	Line:   22,
																},
																File:   "sampledata.flux",
																Source: "if includeNull then \"\" else \"17.53\"",
																Start: ast.Position{
																	Column: 34,
																	Line:   22,
																},
															},
														},
														Consequent: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 56,
																		Line:   22,
																	},
																	File:   "sampledata.flux",
																	Source: "\"\"",
																	Start: ast.Position{
																		Column: 54,
																		Line:   22,
																	},
																},
															},
															Value: "",
														},
														Test: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   22,
																	},
																	File:   "sampledata.flux",
																	Source: "includeNull",
																	Start: ast.Position{
																		Column: 37,
																		Line:   22,
																	},
																},
															},
															Name: "includeNull",
														},
														Tk_else: nil,
														Tk_if:   nil,
														Tk_then: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											},
											Operator: 5,
											Right: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   23,
														},
														File:   "sampledata.flux",
														Source: "\"\n,,0,2021-01-01T00:00:40Z,t1,\"",
														Start: ast.Position{
															Column: 73,
															Line:   22,
														},
													},
												},
												Value: "\n,,0,2021-01-01T00:00:40Z,t1,",
											},
										},
										Operator: 5,
										Right: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   23,
													},
													File:   "sampledata.flux",
													Source: "(if includeNull then \"\" else \"15.23\")",
													Start: ast.Position{
														Column: 33,
														Line:   23,
													},
												},
											},
											Expression: &ast.ConditionalExpression{
												Alternate: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   23,
															},
															File:   "sampledata.flux",
															Source: "\"15.23\"",
															Start: ast.Position{
																Column: 62,
																Line:   23,
															},
														},
													},
													Value: "15.23",
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   23,
														},
														File:   "sampledata.flux",
														Source: "if includeNull then \"\" else \"15.23\"",
														Start: ast.Position{
															Column: 34,
															Line:   23,
														},
													},
												},
												Consequent: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   23,
															},
															File:   "sampledata.flux",
															Source: "\"\"",
															Start: ast.Position{
																Column: 54,
																Line:   23,
															},
														},
													},
													Value: "",
												},
												Test: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   23,
															},
															File:   "sampledata.flux",
															Source: "includeNull",
															Start: ast.Position{
																Column: 37,
																Line:   23,
															},
														},
													},
													Name: "includeNull",
												},
												Tk_else: nil,
												Tk_if:   nil,
												Tk_then: nil,
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									Operator: 5,
									Right: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   25,
												},
												File:   "sampledata.flux",
												Source: "\"\n,,0,2021-01-01T00:00:50Z,t1,4.43\n,,1,2021-01-01T00:00:00Z,t2,\"",
												Start: ast.Position{
													Column: 73,
													Line:   23,
												},
											},
										},
										Value: "\n,,0,2021-01-01T00:00:50Z,t1,4.43\n,,1,2021-01-01T00:00:00Z,t2,",
									},
								},
								Operator: 5,
								Right: &ast.ParenExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   25,
											},
											File:   "sampledata.flux",
											Source: "(if includeNull then \"\" else \"19.85\")",
											Start: ast.Position{
												Column: 33,
												Line:   25,
											},
										},
									},
									Expression: &ast.ConditionalExpression{
										Alternate: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   25,
													},
													File:   "sampledata.flux",
													Source: "\"19.85\"",
													Start: ast.Position{
														Column: 62,
														Line:   25,
													},
												},
											},
											Value: "19.85",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   25,
												},
												File:   "sampledata.flux",
												Source: "if includeNull then \"\" else \"19.85\"",
												Start: ast.Position{
													Column: 34,
													Line:   25,
												},
											},
										},
										Consequent: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 56,
														Line:   25,
													},
													File:   "sampledata.flux",
													Source: "\"\"",
													Start: ast.Position{
														Column: 54,
														Line:   25,
													},
												},
											},
											Value: "",
										},
										Test: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   25,
													},
													File:   "sampledata.flux",
													Source: "includeNull",
													Start: ast.Position{
														Column: 37,
														Line:   25,
													},
												},
											},
											Name: "includeNull",
										},
										Tk_else: nil,
										Tk_if:   nil,
										Tk_then: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							Operator: 5,
							Right: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   29,
										},
										File:   "sampledata.flux",
										Source: "\"\n,,1,2021-01-01T00:00:10Z,t2,4.97\n,,1,2021-01-01T00:00:20Z,t2,-3.75\n,,1,2021-01-01T00:00:30Z,t2,19.77\n,,1,2021-01-01T00:00:40Z,t2,\"",
										Start: ast.Position{
											Column: 73,
											Line:   25,
										},
									},
								},
								Value: "\n,,1,2021-01-01T00:00:10Z,t2,4.97\n,,1,2021-01-01T00:00:20Z,t2,-3.75\n,,1,2021-01-01T00:00:30Z,t2,19.77\n,,1,2021-01-01T00:00:40Z,t2,",
							},
						},
						Operator: 5,
						Right: &ast.ParenExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   29,
									},
									File:   "sampledata.flux",
									Source: "(if includeNull then \"\" else \"13.86\")",
									Start: ast.Position{
										Column: 33,
										Line:   29,
									},
								},
							},
							Expression: &ast.ConditionalExpression{
								Alternate: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   29,
											},
											File:   "sampledata.flux",
											Source: "\"13.86\"",
											Start: ast.Position{
												Column: 62,
												Line:   29,
											},
										},
									},
									Value: "13.86",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   29,
										},
										File:   "sampledata.flux",
										Source: "if includeNull then \"\" else \"13.86\"",
										Start: ast.Position{
											Column: 34,
											Line:   29,
										},
									},
								},
								Consequent: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 56,
												Line:   29,
											},
											File:   "sampledata.flux",
											Source: "\"\"",
											Start: ast.Position{
												Column: 54,
												Line:   29,
											},
										},
									},
									Value: "",
								},
								Test: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   29,
											},
											File:   "sampledata.flux",
											Source: "includeNull",
											Start: ast.Position{
												Column: 37,
												Line:   29,
											},
										},
									},
									Name: "includeNull",
								},
								Tk_else: nil,
								Tk_if:   nil,
								Tk_then: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Operator: 5,
					Right: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 2,
									Line:   31,
								},
								File:   "sampledata.flux",
								Source: "\"\n,,1,2021-01-01T00:00:50Z,t2,1.86\n\"",
								Start: ast.Position{
									Column: 73,
									Line:   29,
								},
							},
						},
						Value: "\n,,1,2021-01-01T00:00:50Z,t2,1.86\n",
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   14,
							},
							File:   "sampledata.flux",
							Source: "includeNull=false",
							Start: ast.Position{
								Column: 13,
								Line:   14,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   14,
								},
								File:   "sampledata.flux",
								Source: "includeNull",
								Start: ast.Position{
									Column: 13,
									Line:   14,
								},
							},
						},
						Name: "includeNull",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   14,
								},
								File:   "sampledata.flux",
								Source: "false",
								Start: ast.Position{
									Column: 25,
									Line:   14,
								},
							},
						},
						Name: "false",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   50,
					},
					File:   "sampledata.flux",
					Source: "_string = (includeNull=false) => \"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,string\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,smpl_g9qczs\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"smpl_0mgv9n\") + \"\n,,0,2021-01-01T00:00:20Z,t1,smpl_phw664\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"smpl_guvzy4\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"smpl_5v3cce\") + \"\n,,0,2021-01-01T00:00:50Z,t1,smpl_s9fmgy\n,,1,2021-01-01T00:00:00Z,t2,\" + (if includeNull then \"\" else \"smpl_b5eida\") + \"\n,,1,2021-01-01T00:00:10Z,t2,smpl_eu4oxp\n,,1,2021-01-01T00:00:20Z,t2,smpl_5g7tz4\n,,1,2021-01-01T00:00:30Z,t2,smpl_sox1ut\n,,1,2021-01-01T00:00:40Z,t2,\" + (if includeNull then \"\" else \"smpl_wfm757\") + \"\n,,1,2021-01-01T00:00:50Z,t2,smpl_dtn2bv\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   33,
						},
						File:   "sampledata.flux",
						Source: "_string",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "_string",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   50,
						},
						File:   "sampledata.flux",
						Source: "(includeNull=false) => \"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,string\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,smpl_g9qczs\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"smpl_0mgv9n\") + \"\n,,0,2021-01-01T00:00:20Z,t1,smpl_phw664\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"smpl_guvzy4\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"smpl_5v3cce\") + \"\n,,0,2021-01-01T00:00:50Z,t1,smpl_s9fmgy\n,,1,2021-01-01T00:00:00Z,t2,\" + (if includeNull then \"\" else \"smpl_b5eida\") + \"\n,,1,2021-01-01T00:00:10Z,t2,smpl_eu4oxp\n,,1,2021-01-01T00:00:20Z,t2,smpl_5g7tz4\n,,1,2021-01-01T00:00:30Z,t2,smpl_sox1ut\n,,1,2021-01-01T00:00:40Z,t2,\" + (if includeNull then \"\" else \"smpl_wfm757\") + \"\n,,1,2021-01-01T00:00:50Z,t2,smpl_dtn2bv\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   33,
						},
					},
				},
				Body: &ast.BinaryExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   50,
							},
							File:   "sampledata.flux",
							Source: "\"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,string\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,smpl_g9qczs\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"smpl_0mgv9n\") + \"\n,,0,2021-01-01T00:00:20Z,t1,smpl_phw664\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"smpl_guvzy4\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"smpl_5v3cce\") + \"\n,,0,2021-01-01T00:00:50Z,t1,smpl_s9fmgy\n,,1,2021-01-01T00:00:00Z,t2,\" + (if includeNull then \"\" else \"smpl_b5eida\") + \"\n,,1,2021-01-01T00:00:10Z,t2,smpl_eu4oxp\n,,1,2021-01-01T00:00:20Z,t2,smpl_5g7tz4\n,,1,2021-01-01T00:00:30Z,t2,smpl_sox1ut\n,,1,2021-01-01T00:00:40Z,t2,\" + (if includeNull then \"\" else \"smpl_wfm757\") + \"\n,,1,2021-01-01T00:00:50Z,t2,smpl_dtn2bv\n\"",
							Start: ast.Position{
								Column: 34,
								Line:   33,
							},
						},
					},
					Left: &ast.BinaryExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 76,
									Line:   48,
								},
								File:   "sampledata.flux",
								Source: "\"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,string\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,smpl_g9qczs\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"smpl_0mgv9n\") + \"\n,,0,2021-01-01T00:00:20Z,t1,smpl_phw664\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"smpl_guvzy4\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"smpl_5v3cce\") + \"\n,,0,2021-01-01T00:00:50Z,t1,smpl_s9fmgy\n,,1,2021-01-01T00:00:00Z,t2,\" + (if includeNull then \"\" else \"smpl_b5eida\") + \"\n,,1,2021-01-01T00:00:10Z,t2,smpl_eu4oxp\n,,1,2021-01-01T00:00:20Z,t2,smpl_5g7tz4\n,,1,2021-01-01T00:00:30Z,t2,smpl_sox1ut\n,,1,2021-01-01T00:00:40Z,t2,\" + (if includeNull then \"\" else \"smpl_wfm757\")",
								Start: ast.Position{
									Column: 34,
									Line:   33,
								},
							},
						},
						Left: &ast.BinaryExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   48,
									},
									File:   "sampledata.flux",
									Source: "\"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,string\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,smpl_g9qczs\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"smpl_0mgv9n\") + \"\n,,0,2021-01-01T00:00:20Z,t1,smpl_phw664\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"smpl_guvzy4\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"smpl_5v3cce\") + \"\n,,0,2021-01-01T00:00:50Z,t1,smpl_s9fmgy\n,,1,2021-01-01T00:00:00Z,t2,\" + (if includeNull then \"\" else \"smpl_b5eida\") + \"\n,,1,2021-01-01T00:00:10Z,t2,smpl_eu4oxp\n,,1,2021-01-01T00:00:20Z,t2,smpl_5g7tz4\n,,1,2021-01-01T00:00:30Z,t2,smpl_sox1ut\n,,1,2021-01-01T00:00:40Z,t2,\"",
									Start: ast.Position{
										Column: 34,
										Line:   33,
									},
								},
							},
							Left: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 76,
											Line:   44,
										},
										File:   "sampledata.flux",
										Source: "\"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,string\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,smpl_g9qczs\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"smpl_0mgv9n\") + \"\n,,0,2021-01-01T00:00:20Z,t1,smpl_phw664\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"smpl_guvzy4\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"smpl_5v3cce\") + \"\n,,0,2021-01-01T00:00:50Z,t1,smpl_s9fmgy\n,,1,2021-01-01T00:00:00Z,t2,\" + (if includeNull then \"\" else \"smpl_b5eida\")",
										Start: ast.Position{
											Column: 34,
											Line:   33,
										},
									},
								},
								Left: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   44,
											},
											File:   "sampledata.flux",
											Source: "\"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,string\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,smpl_g9qczs\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"smpl_0mgv9n\") + \"\n,,0,2021-01-01T00:00:20Z,t1,smpl_phw664\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"smpl_guvzy4\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"smpl_5v3cce\") + \"\n,,0,2021-01-01T00:00:50Z,t1,smpl_s9fmgy\n,,1,2021-01-01T00:00:00Z,t2,\"",
											Start: ast.Position{
												Column: 34,
												Line:   33,
											},
										},
									},
									Left: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 76,
													Line:   42,
												},
												File:   "sampledata.flux",
												Source: "\"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,string\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,smpl_g9qczs\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"smpl_0mgv9n\") + \"\n,,0,2021-01-01T00:00:20Z,t1,smpl_phw664\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"smpl_guvzy4\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"smpl_5v3cce\")",
												Start: ast.Position{
													Column: 34,
													Line:   33,
												},
											},
										},
										Left: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   42,
													},
													File:   "sampledata.flux",
													Source: "\"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,string\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,smpl_g9qczs\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"smpl_0mgv9n\") + \"\n,,0,2021-01-01T00:00:20Z,t1,smpl_phw664\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"smpl_guvzy4\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\"",
													Start: ast.Position{
														Column: 34,
														Line:   33,
													},
												},
											},
											Left: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 76,
															Line:   41,
														},
														File:   "sampledata.flux",
														Source: "\"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,string\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,smpl_g9qczs\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"smpl_0mgv9n\") + \"\n,,0,2021-01-01T00:00:20Z,t1,smpl_phw664\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"smpl_guvzy4\")",
														Start: ast.Position{
															Column: 34,
															Line:   33,
														},
													},
												},
												Left: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   41,
															},
															File:   "sampledata.flux",
															Source: "\"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,string\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,smpl_g9qczs\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"smpl_0mgv9n\") + \"\n,,0,2021-01-01T00:00:20Z,t1,smpl_phw664\n,,0,2021-01-01T00:00:30Z,t1,\"",
															Start: ast.Position{
																Column: 34,
																Line:   33,
															},
														},
													},
													Left: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 76,
																	Line:   39,
																},
																File:   "sampledata.flux",
																Source: "\"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,string\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,smpl_g9qczs\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"smpl_0mgv9n\")",
																Start: ast.Position{
																	Column: 34,
																	Line:   33,
																},
															},
														},
														Left: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 30,
																		Line:   39,
																	},
																	File:   "sampledata.flux",
																	Source: "\"\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,string\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,smpl_g9qczs\n,,0,2021-01-01T00:00:10Z,t1,\"",
																	Start: ast.Position{
																		Column: 34,
																		Line:   33,
																	},
																},
															},
															Value: "\n#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,string\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,smpl_g9qczs\n,,0,2021-01-01T00:00:10Z,t1,",
														},
														Operator: 5,
														Right: &ast.ParenExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 76,
																		Line:   39,
																	},
																	File:   "sampledata.flux",
																	Source: "(if includeNull then \"\" else \"smpl_0mgv9n\")",
																	Start: ast.Position{
																		Column: 33,
																		Line:   39,
																	},
																},
															},
															Expression: &ast.ConditionalExpression{
																Alternate: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 75,
																				Line:   39,
																			},
																			File:   "sampledata.flux",
																			Source: "\"smpl_0mgv9n\"",
																			Start: ast.Position{
																				Column: 62,
																				Line:   39,
																			},
																		},
																	},
																	Value: "smpl_0mgv9n",
																},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 75,
																			Line:   39,
																		},
																		File:   "sampledata.flux",
																		Source: "if includeNull then \"\" else \"smpl_0mgv9n\"",
																		Start: ast.Position{
																			Column: 34,
																			Line:   39,
																		},
																	},
																},
																Consequent: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 56,
																				Line:   39,
																			},
																			File:   "sampledata.flux",
																			Source: "\"\"",
																			Start: ast.Position{
																				Column: 54,
																				Line:   39,
																			},
																		},
																	},
																	Value: "",
																},
																Test: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 48,
																				Line:   39,
																			},
																			File:   "sampledata.flux",
																			Source: "includeNull",
																			Start: ast.Position{
																				Column: 37,
																				Line:   39,
																			},
																		},
																	},
																	Name: "includeNull",
																},
																Tk_else: nil,
																Tk_if:   nil,
																Tk_then: nil,
															},
															Lparen: nil,
															Rparen: nil,
														},
													},
													Operator: 5,
													Right: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   41,
																},
																File:   "sampledata.flux",
																Source: "\"\n,,0,2021-01-01T00:00:20Z,t1,smpl_phw664\n,,0,2021-01-01T00:00:30Z,t1,\"",
																Start: ast.Position{
																	Column: 79,
																	Line:   39,
																},
															},
														},
														Value: "\n,,0,2021-01-01T00:00:20Z,t1,smpl_phw664\n,,0,2021-01-01T00:00:30Z,t1,",
													},
												},
												Operator: 5,
												Right: &ast.ParenExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 76,
																Line:   41,
															},
															File:   "sampledata.flux",
															Source: "(if includeNull then \"\" else \"smpl_guvzy4\")",
															Start: ast.Position{
																Column: 33,
																Line:   41,
															},
														},
													},
													Expression: &ast.ConditionalExpression{
														Alternate: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 75,
																		Line:   41,
																	},
																	File:   "sampledata.flux",
																	Source: "\"smpl_guvzy4\"",
																	Start: ast.Position{
																		Column: 62,
																		Line:   41,
																	},
																},
															},
															Value: "smpl_guvzy4",
														},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 75,
																	Line:   41,
																},
																File:   "sampledata.flux",
																Source: "if includeNull then \"\" else \"smpl_guvzy4\"",
																Start: ast.Position{
																	Column: 34,
																	Line:   41,
																},
															},
														},
														Consequent: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 56,
																		Line:   41,
																	},
																	File:   "sampledata.flux",
																	Source: "\"\"",
																	Start: ast.Position{
																		Column: 54,
																		Line:   41,
																	},
																},
															},
															Value: "",
														},
														Test: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   41,
																	},
																	File:   "sampledata.flux",
																	Source: "includeNull",
																	Start: ast.Position{
																		Column: 37,
																		Line:   41,
																	},
																},
															},
															Name: "includeNull",
														},
														Tk_else: nil,
														Tk_if:   nil,
														Tk_then: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											},
											Operator: 5,
											Right: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   42,
														},
														File:   "sampledata.flux",
														Source: "\"\n,,0,2021-01-01T00:00:40Z,t1,\"",
														Start: ast.Position{
															Column: 79,
															Line:   41,
														},
													},
												},
												Value: "\n,,0,2021-01-01T00:00:40Z,t1,",
											},
										},
										Operator: 5,
										Right: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 76,
														Line:   42,
													},
													File:   "sampledata.flux",
													Source: "(if includeNull then \"\" else \"smpl_5v3cce\")",
													Start: ast.Position{
														Column: 33,
														Line:   42,
													},
												},
											},
											Expression: &ast.ConditionalExpression{
												Alternate: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 75,
																Line:   42,
															},
															File:   "sampledata.flux",
															Source: "\"smpl_5v3cce\"",
															Start: ast.Position{
																Column: 62,
																Line:   42,
															},
														},
													},
													Value: "smpl_5v3cce",
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 75,
															Line:   42,
														},
														File:   "sampledata.flux",
														Source: "if includeNull then \"\" else \"smpl_5v3cce\"",
														Start: ast.Position{
															Column: 34,
															Line:   42,
														},
													},
												},
												Consequent: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   42,
															},
															File:   "sampledata.flux",
															Source: "\"\"",
															Start: ast.Position{
																Column: 54,
																Line:   42,
															},
														},
													},
													Value: "",
												},
												Test: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   42,
															},
															File:   "sampledata.flux",
															Source: "includeNull",
															Start: ast.Position{
																Column: 37,
																Line:   42,
															},
														},
													},
													Name: "includeNull",
												},
												Tk_else: nil,
												Tk_if:   nil,
												Tk_then: nil,
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									Operator: 5,
									Right: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   44,
												},
												File:   "sampledata.flux",
												Source: "\"\n,,0,2021-01-01T00:00:50Z,t1,smpl_s9fmgy\n,,1,2021-01-01T00:00:00Z,t2,\"",
												Start: ast.Position{
													Column: 79,
													Line:   42,
												},
											},
										},
										Value: "\n,,0,2021-01-01T00:00:50Z,t1,smpl_s9fmgy\n,,1,2021-01-01T00:00:00Z,t2,",
									},
								},
								Operator: 5,
								Right: &ast.ParenExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   44,
											},
											File:   "sampledata.flux",
											Source: "(if includeNull then \"\" else \"smpl_b5eida\")",
											Start: ast.Position{
												Column: 33,
												Line:   44,
											},
										},
									},
									Expression: &ast.ConditionalExpression{
										Alternate: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 75,
														Line:   44,
													},
													File:   "sampledata.flux",
													Source: "\"smpl_b5eida\"",
													Start: ast.Position{
														Column: 62,
														Line:   44,
													},
												},
											},
											Value: "smpl_b5eida",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 75,
													Line:   44,
												},
												File:   "sampledata.flux",
												Source: "if includeNull then \"\" else \"smpl_b5eida\"",
												Start: ast.Position{
													Column: 34,
													Line:   44,
												},
											},
										},
										Consequent: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 56,
														Line:   44,
													},
													File:   "sampledata.flux",
													Source: "\"\"",
													Start: ast.Position{
														Column: 54,
														Line:   44,
													},
												},
											},
											Value: "",
										},
										Test: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   44,
													},
													File:   "sampledata.flux",
													Source: "includeNull",
													Start: ast.Position{
														Column: 37,
														Line:   44,
													},
												},
											},
											Name: "includeNull",
										},
										Tk_else: nil,
										Tk_if:   nil,
										Tk_then: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							Operator: 5,
							Right: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   48,
										},
										File:   "sampledata.flux",
										Source: "\"\n,,1,2021-01-01T00:00:10Z,t2,smpl_eu4oxp\n,,1,2021-01-01T00:00:20Z,t2,smpl_5g7tz4\n,,1,2021-01-01T00:00:30Z,t2,smpl_sox1ut\n,,1,2021-01-01T00:00:40Z,t2,\"",
										Start: ast.Position{
											Column: 79,
											Line:   44,
										},
									},
								},
								Value: "\n,,1,2021-01-01T00:00:10Z,t2,smpl_eu4oxp\n,,1,2021-01-01T00:00:20Z,t2,smpl_5g7tz4\n,,1,2021-01-01T00:00:30Z,t2,smpl_sox1ut\n,,1,2021-01-01T00:00:40Z,t2,",
							},
						},
						Operator: 5,
						Right: &ast.ParenExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 76,
										Line:   48,
									},
									File:   "sampledata.flux",
									Source: "(if includeNull then \"\" else \"smpl_wfm757\")",
									Start: ast.Position{
										Column: 33,
										Line:   48,
									},
								},
							},
							Expression: &ast.ConditionalExpression{
								Alternate: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 75,
												Line:   48,
											},
											File:   "sampledata.flux",
											Source: "\"smpl_wfm757\"",
											Start: ast.Position{
												Column: 62,
												Line:   48,
											},
										},
									},
									Value: "smpl_wfm757",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   48,
										},
										File:   "sampledata.flux",
										Source: "if includeNull then \"\" else \"smpl_wfm757\"",
										Start: ast.Position{
											Column: 34,
											Line:   48,
										},
									},
								},
								Consequent: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 56,
												Line:   48,
											},
											File:   "sampledata.flux",
											Source: "\"\"",
											Start: ast.Position{
												Column: 54,
												Line:   48,
											},
										},
									},
									Value: "",
								},
								Test: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   48,
											},
											File:   "sampledata.flux",
											Source: "includeNull",
											Start: ast.Position{
												Column: 37,
												Line:   48,
											},
										},
									},
									Name: "includeNull",
								},
								Tk_else: nil,
								Tk_if:   nil,
								Tk_then: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Operator: 5,
					Right: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 2,
									Line:   50,
								},
								File:   "sampledata.flux",
								Source: "\"\n,,1,2021-01-01T00:00:50Z,t2,smpl_dtn2bv\n\"",
								Start: ast.Position{
									Column: 79,
									Line:   48,
								},
							},
						},
						Value: "\n,,1,2021-01-01T00:00:50Z,t2,smpl_dtn2bv\n",
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   33,
							},
							File:   "sampledata.flux",
							Source: "includeNull=false",
							Start: ast.Position{
								Column: 12,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   33,
								},
								File:   "sampledata.flux",
								Source: "includeNull",
								Start: ast.Position{
									Column: 12,
									Line:   33,
								},
							},
						},
						Name: "includeNull",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   33,
								},
								File:   "sampledata.flux",
								Source: "false",
								Start: ast.Position{
									Column: 24,
									Line:   33,
								},
							},
						},
						Name: "false",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   68,
					},
					File:   "sampledata.flux",
					Source: "_bool = (includeNull=false) => \"#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,boolean\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,true\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"true\") + \"\n,,0,2021-01-01T00:00:20Z,t1,false\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"true\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"false\") + \"\n,,0,2021-01-01T00:00:50Z,t1,false\n,,1,2021-01-01T00:00:00Z,t2,\" + (if includeNull then \"\" else \"false\") + \"\n,,1,2021-01-01T00:00:10Z,t2,true\n,,1,2021-01-01T00:00:20Z,t2,false\n,,1,2021-01-01T00:00:30Z,t2,true\n,,1,2021-01-01T00:00:40Z,t2,\" + (if includeNull then \"\" else \"true\") + \"\n,,1,2021-01-01T00:00:50Z,t2,false\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   52,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   52,
						},
						File:   "sampledata.flux",
						Source: "_bool",
						Start: ast.Position{
							Column: 1,
							Line:   52,
						},
					},
				},
				Name: "_bool",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   68,
						},
						File:   "sampledata.flux",
						Source: "(includeNull=false) => \"#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,boolean\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,true\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"true\") + \"\n,,0,2021-01-01T00:00:20Z,t1,false\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"true\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"false\") + \"\n,,0,2021-01-01T00:00:50Z,t1,false\n,,1,2021-01-01T00:00:00Z,t2,\" + (if includeNull then \"\" else \"false\") + \"\n,,1,2021-01-01T00:00:10Z,t2,true\n,,1,2021-01-01T00:00:20Z,t2,false\n,,1,2021-01-01T00:00:30Z,t2,true\n,,1,2021-01-01T00:00:40Z,t2,\" + (if includeNull then \"\" else \"true\") + \"\n,,1,2021-01-01T00:00:50Z,t2,false\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   52,
						},
					},
				},
				Body: &ast.BinaryExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   68,
							},
							File:   "sampledata.flux",
							Source: "\"#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,boolean\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,true\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"true\") + \"\n,,0,2021-01-01T00:00:20Z,t1,false\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"true\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"false\") + \"\n,,0,2021-01-01T00:00:50Z,t1,false\n,,1,2021-01-01T00:00:00Z,t2,\" + (if includeNull then \"\" else \"false\") + \"\n,,1,2021-01-01T00:00:10Z,t2,true\n,,1,2021-01-01T00:00:20Z,t2,false\n,,1,2021-01-01T00:00:30Z,t2,true\n,,1,2021-01-01T00:00:40Z,t2,\" + (if includeNull then \"\" else \"true\") + \"\n,,1,2021-01-01T00:00:50Z,t2,false\n\"",
							Start: ast.Position{
								Column: 32,
								Line:   52,
							},
						},
					},
					Left: &ast.BinaryExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 69,
									Line:   66,
								},
								File:   "sampledata.flux",
								Source: "\"#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,boolean\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,true\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"true\") + \"\n,,0,2021-01-01T00:00:20Z,t1,false\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"true\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"false\") + \"\n,,0,2021-01-01T00:00:50Z,t1,false\n,,1,2021-01-01T00:00:00Z,t2,\" + (if includeNull then \"\" else \"false\") + \"\n,,1,2021-01-01T00:00:10Z,t2,true\n,,1,2021-01-01T00:00:20Z,t2,false\n,,1,2021-01-01T00:00:30Z,t2,true\n,,1,2021-01-01T00:00:40Z,t2,\" + (if includeNull then \"\" else \"true\")",
								Start: ast.Position{
									Column: 32,
									Line:   52,
								},
							},
						},
						Left: &ast.BinaryExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   66,
									},
									File:   "sampledata.flux",
									Source: "\"#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,boolean\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,true\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"true\") + \"\n,,0,2021-01-01T00:00:20Z,t1,false\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"true\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"false\") + \"\n,,0,2021-01-01T00:00:50Z,t1,false\n,,1,2021-01-01T00:00:00Z,t2,\" + (if includeNull then \"\" else \"false\") + \"\n,,1,2021-01-01T00:00:10Z,t2,true\n,,1,2021-01-01T00:00:20Z,t2,false\n,,1,2021-01-01T00:00:30Z,t2,true\n,,1,2021-01-01T00:00:40Z,t2,\"",
									Start: ast.Position{
										Column: 32,
										Line:   52,
									},
								},
							},
							Left: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   62,
										},
										File:   "sampledata.flux",
										Source: "\"#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,boolean\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,true\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"true\") + \"\n,,0,2021-01-01T00:00:20Z,t1,false\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"true\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"false\") + \"\n,,0,2021-01-01T00:00:50Z,t1,false\n,,1,2021-01-01T00:00:00Z,t2,\" + (if includeNull then \"\" else \"false\")",
										Start: ast.Position{
											Column: 32,
											Line:   52,
										},
									},
								},
								Left: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   62,
											},
											File:   "sampledata.flux",
											Source: "\"#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,boolean\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,true\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"true\") + \"\n,,0,2021-01-01T00:00:20Z,t1,false\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"true\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"false\") + \"\n,,0,2021-01-01T00:00:50Z,t1,false\n,,1,2021-01-01T00:00:00Z,t2,\"",
											Start: ast.Position{
												Column: 32,
												Line:   52,
											},
										},
									},
									Left: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   60,
												},
												File:   "sampledata.flux",
												Source: "\"#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,boolean\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,true\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"true\") + \"\n,,0,2021-01-01T00:00:20Z,t1,false\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"true\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\" + (if includeNull then \"\" else \"false\")",
												Start: ast.Position{
													Column: 32,
													Line:   52,
												},
											},
										},
										Left: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   60,
													},
													File:   "sampledata.flux",
													Source: "\"#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,boolean\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,true\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"true\") + \"\n,,0,2021-01-01T00:00:20Z,t1,false\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"true\") + \"\n,,0,2021-01-01T00:00:40Z,t1,\"",
													Start: ast.Position{
														Column: 32,
														Line:   52,
													},
												},
											},
											Left: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   59,
														},
														File:   "sampledata.flux",
														Source: "\"#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,boolean\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,true\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"true\") + \"\n,,0,2021-01-01T00:00:20Z,t1,false\n,,0,2021-01-01T00:00:30Z,t1,\" + (if includeNull then \"\" else \"true\")",
														Start: ast.Position{
															Column: 32,
															Line:   52,
														},
													},
												},
												Left: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   59,
															},
															File:   "sampledata.flux",
															Source: "\"#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,boolean\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,true\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"true\") + \"\n,,0,2021-01-01T00:00:20Z,t1,false\n,,0,2021-01-01T00:00:30Z,t1,\"",
															Start: ast.Position{
																Column: 32,
																Line:   52,
															},
														},
													},
													Left: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 69,
																	Line:   57,
																},
																File:   "sampledata.flux",
																Source: "\"#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,boolean\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,true\n,,0,2021-01-01T00:00:10Z,t1,\" + (if includeNull then \"\" else \"true\")",
																Start: ast.Position{
																	Column: 32,
																	Line:   52,
																},
															},
														},
														Left: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 30,
																		Line:   57,
																	},
																	File:   "sampledata.flux",
																	Source: "\"#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,boolean\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,true\n,,0,2021-01-01T00:00:10Z,t1,\"",
																	Start: ast.Position{
																		Column: 32,
																		Line:   52,
																	},
																},
															},
															Value: "#group,false,false,false,true,false\n#datatype,string,long,dateTime:RFC3339,string,boolean\n#default,_result,,,,\n,result,table,_time,tag,_value\n,,0,2021-01-01T00:00:00Z,t1,true\n,,0,2021-01-01T00:00:10Z,t1,",
														},
														Operator: 5,
														Right: &ast.ParenExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 69,
																		Line:   57,
																	},
																	File:   "sampledata.flux",
																	Source: "(if includeNull then \"\" else \"true\")",
																	Start: ast.Position{
																		Column: 33,
																		Line:   57,
																	},
																},
															},
															Expression: &ast.ConditionalExpression{
																Alternate: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 68,
																				Line:   57,
																			},
																			File:   "sampledata.flux",
																			Source: "\"true\"",
																			Start: ast.Position{
																				Column: 62,
																				Line:   57,
																			},
																		},
																	},
																	Value: "true",
																},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 68,
																			Line:   57,
																		},
																		File:   "sampledata.flux",
																		Source: "if includeNull then \"\" else \"true\"",
																		Start: ast.Position{
																			Column: 34,
																			Line:   57,
																		},
																	},
																},
																Consequent: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 56,
																				Line:   57,
																			},
																			File:   "sampledata.flux",
																			Source: "\"\"",
																			Start: ast.Position{
																				Column: 54,
																				Line:   57,
																			},
																		},
																	},
																	Value: "",
																},
																Test: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 48,
																				Line:   57,
																			},
																			File:   "sampledata.flux",
																			Source: "includeNull",
																			Start: ast.Position{
																				Column: 37,
																				Line:   57,
																			},
																		},
																	},
																	Name: "includeNull",
																},
																Tk_else: nil,
																Tk_if:   nil,
																Tk_then: nil,
															},
															Lparen: nil,
															Rparen: nil,
														},
													},
													Operator: 5,
													Right: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   59,
																},
																File:   "sampledata.flux",
																Source: "\"\n,,0,2021-01-01T00:00:20Z,t1,false\n,,0,2021-01-01T00:00:30Z,t1,\"",
																Start: ast.Position{
																	Column: 72,
																	Line:   57,
																},
															},
														},
														Value: "\n,,0,2021-01-01T00:00:20Z,t1,false\n,,0,2021-01-01T00:00:30Z,t1,",
													},
												},
												Operator: 5,
												Right: &ast.ParenExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   59,
															},
															File:   "sampledata.flux",
															Source: "(if includeNull then \"\" else \"true\")",
															Start: ast.Position{
																Column: 33,
																Line:   59,
															},
														},
													},
													Expression: &ast.ConditionalExpression{
														Alternate: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 68,
																		Line:   59,
																	},
																	File:   "sampledata.flux",
																	Source: "\"true\"",
																	Start: ast.Position{
																		Column: 62,
																		Line:   59,
																	},
																},
															},
															Value: "true",
														},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 68,
																	Line:   59,
																},
																File:   "sampledata.flux",
																Source: "if includeNull then \"\" else \"true\"",
																Start: ast.Position{
																	Column: 34,
																	Line:   59,
																},
															},
														},
														Consequent: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 56,
																		Line:   59,
																	},
																	File:   "sampledata.flux",
																	Source: "\"\"",
																	Start: ast.Position{
																		Column: 54,
																		Line:   59,
																	},
																},
															},
															Value: "",
														},
														Test: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   59,
																	},
																	File:   "sampledata.flux",
																	Source: "includeNull",
																	Start: ast.Position{
																		Column: 37,
																		Line:   59,
																	},
																},
															},
															Name: "includeNull",
														},
														Tk_else: nil,
														Tk_if:   nil,
														Tk_then: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											},
											Operator: 5,
											Right: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   60,
														},
														File:   "sampledata.flux",
														Source: "\"\n,,0,2021-01-01T00:00:40Z,t1,\"",
														Start: ast.Position{
															Column: 72,
															Line:   59,
														},
													},
												},
												Value: "\n,,0,2021-01-01T00:00:40Z,t1,",
											},
										},
										Operator: 5,
										Right: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   60,
													},
													File:   "sampledata.flux",
													Source: "(if includeNull then \"\" else \"false\")",
													Start: ast.Position{
														Column: 33,
														Line:   60,
													},
												},
											},
											Expression: &ast.ConditionalExpression{
												Alternate: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   60,
															},
															File:   "sampledata.flux",
															Source: "\"false\"",
															Start: ast.Position{
																Column: 62,
																Line:   60,
															},
														},
													},
													Value: "false",
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   60,
														},
														File:   "sampledata.flux",
														Source: "if includeNull then \"\" else \"false\"",
														Start: ast.Position{
															Column: 34,
															Line:   60,
														},
													},
												},
												Consequent: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   60,
															},
															File:   "sampledata.flux",
															Source: "\"\"",
															Start: ast.Position{
																Column: 54,
																Line:   60,
															},
														},
													},
													Value: "",
												},
												Test: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   60,
															},
															File:   "sampledata.flux",
															Source: "includeNull",
															Start: ast.Position{
																Column: 37,
																Line:   60,
															},
														},
													},
													Name: "includeNull",
												},
												Tk_else: nil,
												Tk_if:   nil,
												Tk_then: nil,
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									Operator: 5,
									Right: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   62,
												},
												File:   "sampledata.flux",
												Source: "\"\n,,0,2021-01-01T00:00:50Z,t1,false\n,,1,2021-01-01T00:00:00Z,t2,\"",
												Start: ast.Position{
													Column: 73,
													Line:   60,
												},
											},
										},
										Value: "\n,,0,2021-01-01T00:00:50Z,t1,false\n,,1,2021-01-01T00:00:00Z,t2,",
									},
								},
								Operator: 5,
								Right: &ast.ParenExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   62,
											},
											File:   "sampledata.flux",
											Source: "(if includeNull then \"\" else \"false\")",
											Start: ast.Position{
												Column: 33,
												Line:   62,
											},
										},
									},
									Expression: &ast.ConditionalExpression{
										Alternate: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   62,
													},
													File:   "sampledata.flux",
													Source: "\"false\"",
													Start: ast.Position{
														Column: 62,
														Line:   62,
													},
												},
											},
											Value: "false",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   62,
												},
												File:   "sampledata.flux",
												Source: "if includeNull then \"\" else \"false\"",
												Start: ast.Position{
													Column: 34,
													Line:   62,
												},
											},
										},
										Consequent: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 56,
														Line:   62,
													},
													File:   "sampledata.flux",
													Source: "\"\"",
													Start: ast.Position{
														Column: 54,
														Line:   62,
													},
												},
											},
											Value: "",
										},
										Test: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   62,
													},
													File:   "sampledata.flux",
													Source: "includeNull",
													Start: ast.Position{
														Column: 37,
														Line:   62,
													},
												},
											},
											Name: "includeNull",
										},
										Tk_else: nil,
										Tk_if:   nil,
										Tk_then: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							Operator: 5,
							Right: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   66,
										},
										File:   "sampledata.flux",
										Source: "\"\n,,1,2021-01-01T00:00:10Z,t2,true\n,,1,2021-01-01T00:00:20Z,t2,false\n,,1,2021-01-01T00:00:30Z,t2,true\n,,1,2021-01-01T00:00:40Z,t2,\"",
										Start: ast.Position{
											Column: 73,
											Line:   62,
										},
									},
								},
								Value: "\n,,1,2021-01-01T00:00:10Z,t2,true\n,,1,2021-01-01T00:00:20Z,t2,false\n,,1,2021-01-01T00:00:30Z,t2,true\n,,1,2021-01-01T00:00:40Z,t2,",
							},
						},
						Operator: 5,
						Right: &ast.ParenExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 69,
										Line:   66,
									},
									File:   "sampledata.flux",
									Source: "(if includeNull then \"\" else \"true\")",
									Start: ast.Position{
										Column: 33,
										Line:   66,
									},
								},
							},
							Expression: &ast.ConditionalExpression{
								Alternate: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   66,
											},
											File:   "sampledata.flux",
											Source: "\"true\"",
											Start: ast.Position{
												Column: 62,
												Line:   66,
											},
										},
									},
									Value: "true",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   66,
										},
										File:   "sampledata.flux",
										Source: "if includeNull then \"\" else \"true\"",
										Start: ast.Position{
											Column: 34,
											Line:   66,
										},
									},
								},
								Consequent: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 56,
												Line:   66,
											},
											File:   "sampledata.flux",
											Source: "\"\"",
											Start: ast.Position{
												Column: 54,
												Line:   66,
											},
										},
									},
									Value: "",
								},
								Test: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   66,
											},
											File:   "sampledata.flux",
											Source: "includeNull",
											Start: ast.Position{
												Column: 37,
												Line:   66,
											},
										},
									},
									Name: "includeNull",
								},
								Tk_else: nil,
								Tk_if:   nil,
								Tk_then: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Operator: 5,
					Right: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 2,
									Line:   68,
								},
								File:   "sampledata.flux",
								Source: "\"\n,,1,2021-01-01T00:00:50Z,t2,false\n\"",
								Start: ast.Position{
									Column: 72,
									Line:   66,
								},
							},
						},
						Value: "\n,,1,2021-01-01T00:00:50Z,t2,false\n",
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   52,
							},
							File:   "sampledata.flux",
							Source: "includeNull=false",
							Start: ast.Position{
								Column: 10,
								Line:   52,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   52,
								},
								File:   "sampledata.flux",
								Source: "includeNull",
								Start: ast.Position{
									Column: 10,
									Line:   52,
								},
							},
						},
						Name: "includeNull",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   52,
								},
								File:   "sampledata.flux",
								Source: "false",
								Start: ast.Position{
									Column: 22,
									Line:   52,
								},
							},
						},
						Name: "false",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   89,
					},
					File:   "sampledata.flux",
					Source: "float = (includeNull=false) => {\n    _csvData = _numeric(includeNull: includeNull)\n\n    return csv.from(csv: _csvData)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   85,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// float returns a sample data set with float values.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `includeNull` indicates whether or not to include null values in the returned dataset.\n"}, ast.Comment{Text: "//   Default is `false`.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Output basic sample data with float values\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"sampledata\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// sampledata.float()\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// \n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   85,
						},
						File:   "sampledata.flux",
						Source: "float",
						Start: ast.Position{
							Column: 1,
							Line:   85,
						},
					},
				},
				Name: "float",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   89,
						},
						File:   "sampledata.flux",
						Source: "(includeNull=false) => {\n    _csvData = _numeric(includeNull: includeNull)\n\n    return csv.from(csv: _csvData)\n}",
						Start: ast.Position{
							Column: 9,
							Line:   85,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   89,
							},
							File:   "sampledata.flux",
							Source: "{\n    _csvData = _numeric(includeNull: includeNull)\n\n    return csv.from(csv: _csvData)\n}",
							Start: ast.Position{
								Column: 32,
								Line:   85,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   86,
								},
								File:   "sampledata.flux",
								Source: "_csvData = _numeric(includeNull: includeNull)",
								Start: ast.Position{
									Column: 5,
									Line:   86,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   86,
									},
									File:   "sampledata.flux",
									Source: "_csvData",
									Start: ast.Position{
										Column: 5,
										Line:   86,
									},
								},
							},
							Name: "_csvData",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   86,
										},
										File:   "sampledata.flux",
										Source: "includeNull: includeNull",
										Start: ast.Position{
											Column: 25,
											Line:   86,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   86,
											},
											File:   "sampledata.flux",
											Source: "includeNull: includeNull",
											Start: ast.Position{
												Column: 25,
												Line:   86,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   86,
												},
												File:   "sampledata.flux",
												Source: "includeNull",
												Start: ast.Position{
													Column: 25,
													Line:   86,
												},
											},
										},
										Name: "includeNull",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   86,
												},
												File:   "sampledata.flux",
												Source: "includeNull",
												Start: ast.Position{
													Column: 38,
													Line:   86,
												},
											},
										},
										Name: "includeNull",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   86,
									},
									File:   "sampledata.flux",
									Source: "_numeric(includeNull: includeNull)",
									Start: ast.Position{
										Column: 16,
										Line:   86,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   86,
										},
										File:   "sampledata.flux",
										Source: "_numeric",
										Start: ast.Position{
											Column: 16,
											Line:   86,
										},
									},
								},
								Name: "_numeric",
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   88,
										},
										File:   "sampledata.flux",
										Source: "csv: _csvData",
										Start: ast.Position{
											Column: 21,
											Line:   88,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   88,
											},
											File:   "sampledata.flux",
											Source: "csv: _csvData",
											Start: ast.Position{
												Column: 21,
												Line:   88,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   88,
												},
												File:   "sampledata.flux",
												Source: "csv",
												Start: ast.Position{
													Column: 21,
													Line:   88,
												},
											},
										},
										Name: "csv",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   88,
												},
												File:   "sampledata.flux",
												Source: "_csvData",
												Start: ast.Position{
													Column: 26,
													Line:   88,
												},
											},
										},
										Name: "_csvData",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   88,
									},
									File:   "sampledata.flux",
									Source: "csv.from(csv: _csvData)",
									Start: ast.Position{
										Column: 12,
										Line:   88,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   88,
										},
										File:   "sampledata.flux",
										Source: "csv.from",
										Start: ast.Position{
											Column: 12,
											Line:   88,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   88,
											},
											File:   "sampledata.flux",
											Source: "csv",
											Start: ast.Position{
												Column: 12,
												Line:   88,
											},
										},
									},
									Name: "csv",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   88,
											},
											File:   "sampledata.flux",
											Source: "from",
											Start: ast.Position{
												Column: 16,
												Line:   88,
											},
										},
									},
									Name: "from",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   88,
								},
								File:   "sampledata.flux",
								Source: "return csv.from(csv: _csvData)",
								Start: ast.Position{
									Column: 5,
									Line:   88,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   85,
							},
							File:   "sampledata.flux",
							Source: "includeNull=false",
							Start: ast.Position{
								Column: 10,
								Line:   85,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   85,
								},
								File:   "sampledata.flux",
								Source: "includeNull",
								Start: ast.Position{
									Column: 10,
									Line:   85,
								},
							},
						},
						Name: "includeNull",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   85,
								},
								File:   "sampledata.flux",
								Source: "false",
								Start: ast.Position{
									Column: 22,
									Line:   85,
								},
							},
						},
						Name: "false",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   110,
					},
					File:   "sampledata.flux",
					Source: "int = (includeNull=false) => {\n    _csvData = _numeric(includeNull: includeNull)\n\n    return csv.from(csv: _csvData) |> toInt()\n}",
					Start: ast.Position{
						Column: 1,
						Line:   106,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// int returns a sample data set with integer values.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `includeNull` indicates whether or not to include null values in the returned dataset.\n"}, ast.Comment{Text: "//   Default is `false`.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Output basic sample data with integer values\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"sampledata\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// sampledata.int()\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   106,
						},
						File:   "sampledata.flux",
						Source: "int",
						Start: ast.Position{
							Column: 1,
							Line:   106,
						},
					},
				},
				Name: "int",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   110,
						},
						File:   "sampledata.flux",
						Source: "(includeNull=false) => {\n    _csvData = _numeric(includeNull: includeNull)\n\n    return csv.from(csv: _csvData) |> toInt()\n}",
						Start: ast.Position{
							Column: 7,
							Line:   106,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   110,
							},
							File:   "sampledata.flux",
							Source: "{\n    _csvData = _numeric(includeNull: includeNull)\n\n    return csv.from(csv: _csvData) |> toInt()\n}",
							Start: ast.Position{
								Column: 30,
								Line:   106,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   107,
								},
								File:   "sampledata.flux",
								Source: "_csvData = _numeric(includeNull: includeNull)",
								Start: ast.Position{
									Column: 5,
									Line:   107,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   107,
									},
									File:   "sampledata.flux",
									Source: "_csvData",
									Start: ast.Position{
										Column: 5,
										Line:   107,
									},
								},
							},
							Name: "_csvData",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   107,
										},
										File:   "sampledata.flux",
										Source: "includeNull: includeNull",
										Start: ast.Position{
											Column: 25,
											Line:   107,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   107,
											},
											File:   "sampledata.flux",
											Source: "includeNull: includeNull",
											Start: ast.Position{
												Column: 25,
												Line:   107,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   107,
												},
												File:   "sampledata.flux",
												Source: "includeNull",
												Start: ast.Position{
													Column: 25,
													Line:   107,
												},
											},
										},
										Name: "includeNull",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   107,
												},
												File:   "sampledata.flux",
												Source: "includeNull",
												Start: ast.Position{
													Column: 38,
													Line:   107,
												},
											},
										},
										Name: "includeNull",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   107,
									},
									File:   "sampledata.flux",
									Source: "_numeric(includeNull: includeNull)",
									Start: ast.Position{
										Column: 16,
										Line:   107,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   107,
										},
										File:   "sampledata.flux",
										Source: "_numeric",
										Start: ast.Position{
											Column: 16,
											Line:   107,
										},
									},
								},
								Name: "_numeric",
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   109,
											},
											File:   "sampledata.flux",
											Source: "csv: _csvData",
											Start: ast.Position{
												Column: 21,
												Line:   109,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   109,
												},
												File:   "sampledata.flux",
												Source: "csv: _csvData",
												Start: ast.Position{
													Column: 21,
													Line:   109,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   109,
													},
													File:   "sampledata.flux",
													Source: "csv",
													Start: ast.Position{
														Column: 21,
														Line:   109,
													},
												},
											},
											Name: "csv",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   109,
													},
													File:   "sampledata.flux",
													Source: "_csvData",
													Start: ast.Position{
														Column: 26,
														Line:   109,
													},
												},
											},
											Name: "_csvData",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   109,
										},
										File:   "sampledata.flux",
										Source: "csv.from(csv: _csvData)",
										Start: ast.Position{
											Column: 12,
											Line:   109,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   109,
											},
											File:   "sampledata.flux",
											Source: "csv.from",
											Start: ast.Position{
												Column: 12,
												Line:   109,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   109,
												},
												File:   "sampledata.flux",
												Source: "csv",
												Start: ast.Position{
													Column: 12,
													Line:   109,
												},
											},
										},
										Name: "csv",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   109,
												},
												File:   "sampledata.flux",
												Source: "from",
												Start: ast.Position{
													Column: 16,
													Line:   109,
												},
											},
										},
										Name: "from",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   109,
									},
									File:   "sampledata.flux",
									Source: "csv.from(csv: _csvData) |> toInt()",
									Start: ast.Position{
										Column: 12,
										Line:   109,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   109,
										},
										File:   "sampledata.flux",
										Source: "toInt()",
										Start: ast.Position{
											Column: 39,
											Line:   109,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   109,
											},
											File:   "sampledata.flux",
											Source: "toInt",
											Start: ast.Position{
												Column: 39,
												Line:   109,
											},
										},
									},
									Name: "toInt",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   109,
								},
								File:   "sampledata.flux",
								Source: "return csv.from(csv: _csvData) |> toInt()",
								Start: ast.Position{
									Column: 5,
									Line:   109,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   106,
							},
							File:   "sampledata.flux",
							Source: "includeNull=false",
							Start: ast.Position{
								Column: 8,
								Line:   106,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   106,
								},
								File:   "sampledata.flux",
								Source: "includeNull",
								Start: ast.Position{
									Column: 8,
									Line:   106,
								},
							},
						},
						Name: "includeNull",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   106,
								},
								File:   "sampledata.flux",
								Source: "false",
								Start: ast.Position{
									Column: 20,
									Line:   106,
								},
							},
						},
						Name: "false",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   131,
					},
					File:   "sampledata.flux",
					Source: "uint = (includeNull=false) => {\n    _csvData = _numeric(includeNull: includeNull)\n\n    return csv.from(csv: _csvData) |> toUInt()\n}",
					Start: ast.Position{
						Column: 1,
						Line:   127,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// uint returns a sample data set with unsigned integer values.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `includeNull` indicates whether or not to include null values in the returned dataset.\n"}, ast.Comment{Text: "//   Default is `false`.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Output basic sample data with unsigned integer values\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"sampledata\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// sampledata.uint()\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   127,
						},
						File:   "sampledata.flux",
						Source: "uint",
						Start: ast.Position{
							Column: 1,
							Line:   127,
						},
					},
				},
				Name: "uint",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   131,
						},
						File:   "sampledata.flux",
						Source: "(includeNull=false) => {\n    _csvData = _numeric(includeNull: includeNull)\n\n    return csv.from(csv: _csvData) |> toUInt()\n}",
						Start: ast.Position{
							Column: 8,
							Line:   127,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   131,
							},
							File:   "sampledata.flux",
							Source: "{\n    _csvData = _numeric(includeNull: includeNull)\n\n    return csv.from(csv: _csvData) |> toUInt()\n}",
							Start: ast.Position{
								Column: 31,
								Line:   127,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   128,
								},
								File:   "sampledata.flux",
								Source: "_csvData = _numeric(includeNull: includeNull)",
								Start: ast.Position{
									Column: 5,
									Line:   128,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   128,
									},
									File:   "sampledata.flux",
									Source: "_csvData",
									Start: ast.Position{
										Column: 5,
										Line:   128,
									},
								},
							},
							Name: "_csvData",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   128,
										},
										File:   "sampledata.flux",
										Source: "includeNull: includeNull",
										Start: ast.Position{
											Column: 25,
											Line:   128,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   128,
											},
											File:   "sampledata.flux",
											Source: "includeNull: includeNull",
											Start: ast.Position{
												Column: 25,
												Line:   128,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   128,
												},
												File:   "sampledata.flux",
												Source: "includeNull",
												Start: ast.Position{
													Column: 25,
													Line:   128,
												},
											},
										},
										Name: "includeNull",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   128,
												},
												File:   "sampledata.flux",
												Source: "includeNull",
												Start: ast.Position{
													Column: 38,
													Line:   128,
												},
											},
										},
										Name: "includeNull",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   128,
									},
									File:   "sampledata.flux",
									Source: "_numeric(includeNull: includeNull)",
									Start: ast.Position{
										Column: 16,
										Line:   128,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   128,
										},
										File:   "sampledata.flux",
										Source: "_numeric",
										Start: ast.Position{
											Column: 16,
											Line:   128,
										},
									},
								},
								Name: "_numeric",
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   130,
											},
											File:   "sampledata.flux",
											Source: "csv: _csvData",
											Start: ast.Position{
												Column: 21,
												Line:   130,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   130,
												},
												File:   "sampledata.flux",
												Source: "csv: _csvData",
												Start: ast.Position{
													Column: 21,
													Line:   130,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   130,
													},
													File:   "sampledata.flux",
													Source: "csv",
													Start: ast.Position{
														Column: 21,
														Line:   130,
													},
												},
											},
											Name: "csv",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   130,
													},
													File:   "sampledata.flux",
													Source: "_csvData",
													Start: ast.Position{
														Column: 26,
														Line:   130,
													},
												},
											},
											Name: "_csvData",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   130,
										},
										File:   "sampledata.flux",
										Source: "csv.from(csv: _csvData)",
										Start: ast.Position{
											Column: 12,
											Line:   130,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   130,
											},
											File:   "sampledata.flux",
											Source: "csv.from",
											Start: ast.Position{
												Column: 12,
												Line:   130,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   130,
												},
												File:   "sampledata.flux",
												Source: "csv",
												Start: ast.Position{
													Column: 12,
													Line:   130,
												},
											},
										},
										Name: "csv",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   130,
												},
												File:   "sampledata.flux",
												Source: "from",
												Start: ast.Position{
													Column: 16,
													Line:   130,
												},
											},
										},
										Name: "from",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   130,
									},
									File:   "sampledata.flux",
									Source: "csv.from(csv: _csvData) |> toUInt()",
									Start: ast.Position{
										Column: 12,
										Line:   130,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   130,
										},
										File:   "sampledata.flux",
										Source: "toUInt()",
										Start: ast.Position{
											Column: 39,
											Line:   130,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   130,
											},
											File:   "sampledata.flux",
											Source: "toUInt",
											Start: ast.Position{
												Column: 39,
												Line:   130,
											},
										},
									},
									Name: "toUInt",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   130,
								},
								File:   "sampledata.flux",
								Source: "return csv.from(csv: _csvData) |> toUInt()",
								Start: ast.Position{
									Column: 5,
									Line:   130,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   127,
							},
							File:   "sampledata.flux",
							Source: "includeNull=false",
							Start: ast.Position{
								Column: 9,
								Line:   127,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   127,
								},
								File:   "sampledata.flux",
								Source: "includeNull",
								Start: ast.Position{
									Column: 9,
									Line:   127,
								},
							},
						},
						Name: "includeNull",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   127,
								},
								File:   "sampledata.flux",
								Source: "false",
								Start: ast.Position{
									Column: 21,
									Line:   127,
								},
							},
						},
						Name: "false",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   152,
					},
					File:   "sampledata.flux",
					Source: "string = (includeNull=false) => {\n    _csvData = _string(includeNull: includeNull)\n\n    return csv.from(csv: _csvData)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   148,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// string returns a sample data set with string values.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `includeNull` indicates whether or not to include null values in the returned dataset.\n"}, ast.Comment{Text: "//   Default is `false`.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Output basic sample data with string values\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"sampledata\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// sampledata.string()\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// \n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   148,
						},
						File:   "sampledata.flux",
						Source: "string",
						Start: ast.Position{
							Column: 1,
							Line:   148,
						},
					},
				},
				Name: "string",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   152,
						},
						File:   "sampledata.flux",
						Source: "(includeNull=false) => {\n    _csvData = _string(includeNull: includeNull)\n\n    return csv.from(csv: _csvData)\n}",
						Start: ast.Position{
							Column: 10,
							Line:   148,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   152,
							},
							File:   "sampledata.flux",
							Source: "{\n    _csvData = _string(includeNull: includeNull)\n\n    return csv.from(csv: _csvData)\n}",
							Start: ast.Position{
								Column: 33,
								Line:   148,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   149,
								},
								File:   "sampledata.flux",
								Source: "_csvData = _string(includeNull: includeNull)",
								Start: ast.Position{
									Column: 5,
									Line:   149,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   149,
									},
									File:   "sampledata.flux",
									Source: "_csvData",
									Start: ast.Position{
										Column: 5,
										Line:   149,
									},
								},
							},
							Name: "_csvData",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   149,
										},
										File:   "sampledata.flux",
										Source: "includeNull: includeNull",
										Start: ast.Position{
											Column: 24,
											Line:   149,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   149,
											},
											File:   "sampledata.flux",
											Source: "includeNull: includeNull",
											Start: ast.Position{
												Column: 24,
												Line:   149,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   149,
												},
												File:   "sampledata.flux",
												Source: "includeNull",
												Start: ast.Position{
													Column: 24,
													Line:   149,
												},
											},
										},
										Name: "includeNull",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   149,
												},
												File:   "sampledata.flux",
												Source: "includeNull",
												Start: ast.Position{
													Column: 37,
													Line:   149,
												},
											},
										},
										Name: "includeNull",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   149,
									},
									File:   "sampledata.flux",
									Source: "_string(includeNull: includeNull)",
									Start: ast.Position{
										Column: 16,
										Line:   149,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   149,
										},
										File:   "sampledata.flux",
										Source: "_string",
										Start: ast.Position{
											Column: 16,
											Line:   149,
										},
									},
								},
								Name: "_string",
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   151,
										},
										File:   "sampledata.flux",
										Source: "csv: _csvData",
										Start: ast.Position{
											Column: 21,
											Line:   151,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   151,
											},
											File:   "sampledata.flux",
											Source: "csv: _csvData",
											Start: ast.Position{
												Column: 21,
												Line:   151,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   151,
												},
												File:   "sampledata.flux",
												Source: "csv",
												Start: ast.Position{
													Column: 21,
													Line:   151,
												},
											},
										},
										Name: "csv",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   151,
												},
												File:   "sampledata.flux",
												Source: "_csvData",
												Start: ast.Position{
													Column: 26,
													Line:   151,
												},
											},
										},
										Name: "_csvData",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   151,
									},
									File:   "sampledata.flux",
									Source: "csv.from(csv: _csvData)",
									Start: ast.Position{
										Column: 12,
										Line:   151,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   151,
										},
										File:   "sampledata.flux",
										Source: "csv.from",
										Start: ast.Position{
											Column: 12,
											Line:   151,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   151,
											},
											File:   "sampledata.flux",
											Source: "csv",
											Start: ast.Position{
												Column: 12,
												Line:   151,
											},
										},
									},
									Name: "csv",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   151,
											},
											File:   "sampledata.flux",
											Source: "from",
											Start: ast.Position{
												Column: 16,
												Line:   151,
											},
										},
									},
									Name: "from",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   151,
								},
								File:   "sampledata.flux",
								Source: "return csv.from(csv: _csvData)",
								Start: ast.Position{
									Column: 5,
									Line:   151,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   148,
							},
							File:   "sampledata.flux",
							Source: "includeNull=false",
							Start: ast.Position{
								Column: 11,
								Line:   148,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   148,
								},
								File:   "sampledata.flux",
								Source: "includeNull",
								Start: ast.Position{
									Column: 11,
									Line:   148,
								},
							},
						},
						Name: "includeNull",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   148,
								},
								File:   "sampledata.flux",
								Source: "false",
								Start: ast.Position{
									Column: 23,
									Line:   148,
								},
							},
						},
						Name: "false",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   173,
					},
					File:   "sampledata.flux",
					Source: "bool = (includeNull=false) => {\n    _csvData = _bool(includeNull: includeNull)\n\n    return csv.from(csv: _csvData)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   169,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// bool returns a sample data set with boolean values.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `includeNull` indicates whether or not to include null values in the returned dataset.\n"}, ast.Comment{Text: "//   Default is `false`.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Output basic sample data with boolean values\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"sampledata\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// sampledata.bool()\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// \n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   169,
						},
						File:   "sampledata.flux",
						Source: "bool",
						Start: ast.Position{
							Column: 1,
							Line:   169,
						},
					},
				},
				Name: "bool",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   173,
						},
						File:   "sampledata.flux",
						Source: "(includeNull=false) => {\n    _csvData = _bool(includeNull: includeNull)\n\n    return csv.from(csv: _csvData)\n}",
						Start: ast.Position{
							Column: 8,
							Line:   169,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   173,
							},
							File:   "sampledata.flux",
							Source: "{\n    _csvData = _bool(includeNull: includeNull)\n\n    return csv.from(csv: _csvData)\n}",
							Start: ast.Position{
								Column: 31,
								Line:   169,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   170,
								},
								File:   "sampledata.flux",
								Source: "_csvData = _bool(includeNull: includeNull)",
								Start: ast.Position{
									Column: 5,
									Line:   170,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   170,
									},
									File:   "sampledata.flux",
									Source: "_csvData",
									Start: ast.Position{
										Column: 5,
										Line:   170,
									},
								},
							},
							Name: "_csvData",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   170,
										},
										File:   "sampledata.flux",
										Source: "includeNull: includeNull",
										Start: ast.Position{
											Column: 22,
											Line:   170,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   170,
											},
											File:   "sampledata.flux",
											Source: "includeNull: includeNull",
											Start: ast.Position{
												Column: 22,
												Line:   170,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   170,
												},
												File:   "sampledata.flux",
												Source: "includeNull",
												Start: ast.Position{
													Column: 22,
													Line:   170,
												},
											},
										},
										Name: "includeNull",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   170,
												},
												File:   "sampledata.flux",
												Source: "includeNull",
												Start: ast.Position{
													Column: 35,
													Line:   170,
												},
											},
										},
										Name: "includeNull",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   170,
									},
									File:   "sampledata.flux",
									Source: "_bool(includeNull: includeNull)",
									Start: ast.Position{
										Column: 16,
										Line:   170,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   170,
										},
										File:   "sampledata.flux",
										Source: "_bool",
										Start: ast.Position{
											Column: 16,
											Line:   170,
										},
									},
								},
								Name: "_bool",
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   172,
										},
										File:   "sampledata.flux",
										Source: "csv: _csvData",
										Start: ast.Position{
											Column: 21,
											Line:   172,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   172,
											},
											File:   "sampledata.flux",
											Source: "csv: _csvData",
											Start: ast.Position{
												Column: 21,
												Line:   172,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   172,
												},
												File:   "sampledata.flux",
												Source: "csv",
												Start: ast.Position{
													Column: 21,
													Line:   172,
												},
											},
										},
										Name: "csv",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   172,
												},
												File:   "sampledata.flux",
												Source: "_csvData",
												Start: ast.Position{
													Column: 26,
													Line:   172,
												},
											},
										},
										Name: "_csvData",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   172,
									},
									File:   "sampledata.flux",
									Source: "csv.from(csv: _csvData)",
									Start: ast.Position{
										Column: 12,
										Line:   172,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   172,
										},
										File:   "sampledata.flux",
										Source: "csv.from",
										Start: ast.Position{
											Column: 12,
											Line:   172,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   172,
											},
											File:   "sampledata.flux",
											Source: "csv",
											Start: ast.Position{
												Column: 12,
												Line:   172,
											},
										},
									},
									Name: "csv",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   172,
											},
											File:   "sampledata.flux",
											Source: "from",
											Start: ast.Position{
												Column: 16,
												Line:   172,
											},
										},
									},
									Name: "from",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   172,
								},
								File:   "sampledata.flux",
								Source: "return csv.from(csv: _csvData)",
								Start: ast.Position{
									Column: 5,
									Line:   172,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   169,
							},
							File:   "sampledata.flux",
							Source: "includeNull=false",
							Start: ast.Position{
								Column: 9,
								Line:   169,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   169,
								},
								File:   "sampledata.flux",
								Source: "includeNull",
								Start: ast.Position{
									Column: 9,
									Line:   169,
								},
							},
						},
						Name: "includeNull",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   169,
								},
								File:   "sampledata.flux",
								Source: "false",
								Start: ast.Position{
									Column: 21,
									Line:   169,
								},
							},
						},
						Name: "false",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   194,
					},
					File:   "sampledata.flux",
					Source: "numericBool = (includeNull=false) => {\n    _csvData = _bool(includeNull: includeNull)\n\n    return csv.from(csv: _csvData) |> toInt()\n}",
					Start: ast.Position{
						Column: 1,
						Line:   190,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// numericBool returns a sample data set with numeric (integer) boolean values.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `includeNull` indicates whether or not to include null values in the returned dataset.\n"}, ast.Comment{Text: "//   Default is `false`.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Output basic sample data with numeric boolean values\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"sampledata\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// sampledata.numericBool()\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// \n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   190,
						},
						File:   "sampledata.flux",
						Source: "numericBool",
						Start: ast.Position{
							Column: 1,
							Line:   190,
						},
					},
				},
				Name: "numericBool",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   194,
						},
						File:   "sampledata.flux",
						Source: "(includeNull=false) => {\n    _csvData = _bool(includeNull: includeNull)\n\n    return csv.from(csv: _csvData) |> toInt()\n}",
						Start: ast.Position{
							Column: 15,
							Line:   190,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   194,
							},
							File:   "sampledata.flux",
							Source: "{\n    _csvData = _bool(includeNull: includeNull)\n\n    return csv.from(csv: _csvData) |> toInt()\n}",
							Start: ast.Position{
								Column: 38,
								Line:   190,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   191,
								},
								File:   "sampledata.flux",
								Source: "_csvData = _bool(includeNull: includeNull)",
								Start: ast.Position{
									Column: 5,
									Line:   191,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   191,
									},
									File:   "sampledata.flux",
									Source: "_csvData",
									Start: ast.Position{
										Column: 5,
										Line:   191,
									},
								},
							},
							Name: "_csvData",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   191,
										},
										File:   "sampledata.flux",
										Source: "includeNull: includeNull",
										Start: ast.Position{
											Column: 22,
											Line:   191,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   191,
											},
											File:   "sampledata.flux",
											Source: "includeNull: includeNull",
											Start: ast.Position{
												Column: 22,
												Line:   191,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   191,
												},
												File:   "sampledata.flux",
												Source: "includeNull",
												Start: ast.Position{
													Column: 22,
													Line:   191,
												},
											},
										},
										Name: "includeNull",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   191,
												},
												File:   "sampledata.flux",
												Source: "includeNull",
												Start: ast.Position{
													Column: 35,
													Line:   191,
												},
											},
										},
										Name: "includeNull",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   191,
									},
									File:   "sampledata.flux",
									Source: "_bool(includeNull: includeNull)",
									Start: ast.Position{
										Column: 16,
										Line:   191,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   191,
										},
										File:   "sampledata.flux",
										Source: "_bool",
										Start: ast.Position{
											Column: 16,
											Line:   191,
										},
									},
								},
								Name: "_bool",
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   193,
											},
											File:   "sampledata.flux",
											Source: "csv: _csvData",
											Start: ast.Position{
												Column: 21,
												Line:   193,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   193,
												},
												File:   "sampledata.flux",
												Source: "csv: _csvData",
												Start: ast.Position{
													Column: 21,
													Line:   193,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   193,
													},
													File:   "sampledata.flux",
													Source: "csv",
													Start: ast.Position{
														Column: 21,
														Line:   193,
													},
												},
											},
											Name: "csv",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   193,
													},
													File:   "sampledata.flux",
													Source: "_csvData",
													Start: ast.Position{
														Column: 26,
														Line:   193,
													},
												},
											},
											Name: "_csvData",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   193,
										},
										File:   "sampledata.flux",
										Source: "csv.from(csv: _csvData)",
										Start: ast.Position{
											Column: 12,
											Line:   193,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   193,
											},
											File:   "sampledata.flux",
											Source: "csv.from",
											Start: ast.Position{
												Column: 12,
												Line:   193,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   193,
												},
												File:   "sampledata.flux",
												Source: "csv",
												Start: ast.Position{
													Column: 12,
													Line:   193,
												},
											},
										},
										Name: "csv",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   193,
												},
												File:   "sampledata.flux",
												Source: "from",
												Start: ast.Position{
													Column: 16,
													Line:   193,
												},
											},
										},
										Name: "from",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   193,
									},
									File:   "sampledata.flux",
									Source: "csv.from(csv: _csvData) |> toInt()",
									Start: ast.Position{
										Column: 12,
										Line:   193,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   193,
										},
										File:   "sampledata.flux",
										Source: "toInt()",
										Start: ast.Position{
											Column: 39,
											Line:   193,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   193,
											},
											File:   "sampledata.flux",
											Source: "toInt",
											Start: ast.Position{
												Column: 39,
												Line:   193,
											},
										},
									},
									Name: "toInt",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   193,
								},
								File:   "sampledata.flux",
								Source: "return csv.from(csv: _csvData) |> toInt()",
								Start: ast.Position{
									Column: 5,
									Line:   193,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   190,
							},
							File:   "sampledata.flux",
							Source: "includeNull=false",
							Start: ast.Position{
								Column: 16,
								Line:   190,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   190,
								},
								File:   "sampledata.flux",
								Source: "includeNull",
								Start: ast.Position{
									Column: 16,
									Line:   190,
								},
							},
						},
						Name: "includeNull",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   190,
								},
								File:   "sampledata.flux",
								Source: "false",
								Start: ast.Position{
									Column: 28,
									Line:   190,
								},
							},
						},
						Name: "false",
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   5,
					},
					File:   "sampledata.flux",
					Source: "import \"csv\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   5,
						},
						File:   "sampledata.flux",
						Source: "\"csv\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "csv",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "sampledata.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Package sampledata provides functions that return basic sample datasets.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   2,
					},
					File:   "sampledata.flux",
					Source: "package sampledata",
					Start: ast.Position{
						Column: 1,
						Line:   2,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   2,
						},
						File:   "sampledata.flux",
						Source: "sampledata",
						Start: ast.Position{
							Column: 9,
							Line:   2,
						},
					},
				},
				Name: "sampledata",
			},
		},
	}},
	Package: "sampledata",
	Path:    "sampledata",
}
