// DO NOT EDIT: This file is autogenerated via the builtin command.

package influxdb

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 16,
					Line:   105,
				},
				File:   "influxdb.flux",
				Source: "package influxdb\n\n\n// cardinality returns the series cardinality of data stored in InfluxDB Cloud.\n//\n// ## Parameters\n// - `bucket` is the bucket to query cardinality\n// - `bucketID` is the String-encoded bucket ID to query cardinality from.\n// - `org` is the organization name\n// - `orgID` is the String-encoded organization ID to query cardinality from.\n// - `host` is the URL of the InfluxDB instance to query.\n//\n//      See InfluxDB Cloud regions or InfluxDB OSS URLs.\n//\n// - `token` is the InfluxDB authentication token.\n// - `start` is the earliest time to include when calculating cardinality.\n//\n//      The cardinality calculation includes points that match the specified start time.\n//      Use a relative duration or absolute time. For example, -1h or 2019-08-28T22:00:00Z.\n//      Durations are relative to now().\n//\n// - `stop` is the latest time to include when calculating cardinality.\n//\n//      The cardinality calculation excludes points that match the specified start time.\n//      Use a relative duration or absolute time. For example, -1h or 2019-08-28T22:00:00Z.\n//      Durations are relative to now(). Defaults to now().\n// - `predicate` is the predicate function that filters records. Defaults to (r) => true.\n//\n//\n// ## Query series cardinality in a bucket\n//\n// ```\n// import \"influxdata/influxdb\n//\n// influxdb.cardinality(\n//    bucket: \"example-bucket\",\n//    start: -1y\n// )\n// ```\n//\n// ## Query series cardinality in a measurement\n//\n// ```\n// import \"influxdata/influxdb\n//\n// influxdb.cardinality(\n//    bucket: \"example-bucket\",\n//    start: -1y\n//    predicate: (r) => r._measurement == \"example-measurement\"\n// )\n// ```\n//\n// ## Query series cardinality for a specific tag\n//\n// ```\n// import \"influxdata/influxdb\n//\n// influxdb.cardinality(\n//    bucket: \"example-bucket\",\n//    start: -1y\n//    predicate: (r) => r.exampleTag == \"foo\"\n// )\n// ```\n//\nbuiltin cardinality : (\n    ?bucket: string,\n    ?bucketID: string,\n    ?org: string,\n    ?orgID: string,\n    ?host: string,\n    ?token: string,\n    start: A,\n    ?stop: B,\n    ?predicate: (r: {T with _measurement: string, _field: string, _value: S}) => bool,\n) => [{_start: time, _stop: time, _value: int}] where\n    A: Timeable,\n    B: Timeable\n\nbuiltin from : (\n    ?bucket: string,\n    ?bucketID: string,\n    ?org: string,\n    ?orgID: string,\n    ?host: string,\n    ?token: string,\n) => [{B with _measurement: string, _field: string, _time: time, _value: A}]\n\nbuiltin to : (\n    <-tables: [A],\n    ?bucket: string,\n    ?bucketID: string,\n    ?org: string,\n    ?orgID: string,\n    ?host: string,\n    ?token: string,\n    ?timeColumn: string,\n    ?measurementColumn: string,\n    ?tagColumns: [string],\n    ?fieldFn: (r: A) => B,\n) => [A] where\n    A: Record,\n    B: Record\n\nbuiltin buckets",
				Start: ast.Position{
					Column: 1,
					Line:   2,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// cardinality returns the series cardinality of data stored in InfluxDB Cloud.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `bucket` is the bucket to query cardinality\n"}, ast.Comment{Text: "// - `bucketID` is the String-encoded bucket ID to query cardinality from.\n"}, ast.Comment{Text: "// - `org` is the organization name\n"}, ast.Comment{Text: "// - `orgID` is the String-encoded organization ID to query cardinality from.\n"}, ast.Comment{Text: "// - `host` is the URL of the InfluxDB instance to query.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      See InfluxDB Cloud regions or InfluxDB OSS URLs.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `token` is the InfluxDB authentication token.\n"}, ast.Comment{Text: "// - `start` is the earliest time to include when calculating cardinality.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      The cardinality calculation includes points that match the specified start time.\n"}, ast.Comment{Text: "//      Use a relative duration or absolute time. For example, -1h or 2019-08-28T22:00:00Z.\n"}, ast.Comment{Text: "//      Durations are relative to now().\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `stop` is the latest time to include when calculating cardinality.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      The cardinality calculation excludes points that match the specified start time.\n"}, ast.Comment{Text: "//      Use a relative duration or absolute time. For example, -1h or 2019-08-28T22:00:00Z.\n"}, ast.Comment{Text: "//      Durations are relative to now(). Defaults to now().\n"}, ast.Comment{Text: "// - `predicate` is the predicate function that filters records. Defaults to (r) => true.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Query series cardinality in a bucket\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"influxdata/influxdb\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// influxdb.cardinality(\n"}, ast.Comment{Text: "//    bucket: \"example-bucket\",\n"}, ast.Comment{Text: "//    start: -1y\n"}, ast.Comment{Text: "// )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Query series cardinality in a measurement\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"influxdata/influxdb\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// influxdb.cardinality(\n"}, ast.Comment{Text: "//    bucket: \"example-bucket\",\n"}, ast.Comment{Text: "//    start: -1y\n"}, ast.Comment{Text: "//    predicate: (r) => r._measurement == \"example-measurement\"\n"}, ast.Comment{Text: "// )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Query series cardinality for a specific tag\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"influxdata/influxdb\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// influxdb.cardinality(\n"}, ast.Comment{Text: "//    bucket: \"example-bucket\",\n"}, ast.Comment{Text: "//    start: -1y\n"}, ast.Comment{Text: "//    predicate: (r) => r.exampleTag == \"foo\"\n"}, ast.Comment{Text: "// )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   66,
					},
					File:   "influxdb.flux",
					Source: "builtin cardinality",
					Start: ast.Position{
						Column: 1,
						Line:   66,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   66,
						},
						File:   "influxdb.flux",
						Source: "cardinality",
						Start: ast.Position{
							Column: 9,
							Line:   66,
						},
					},
				},
				Name: "cardinality",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   78,
						},
						File:   "influxdb.flux",
						Source: "(\n    ?bucket: string,\n    ?bucketID: string,\n    ?org: string,\n    ?orgID: string,\n    ?host: string,\n    ?token: string,\n    start: A,\n    ?stop: B,\n    ?predicate: (r: {T with _measurement: string, _field: string, _value: S}) => bool,\n) => [{_start: time, _stop: time, _value: int}] where\n    A: Timeable,\n    B: Timeable",
						Start: ast.Position{
							Column: 23,
							Line:   66,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   77,
							},
							File:   "influxdb.flux",
							Source: "A: Timeable",
							Start: ast.Position{
								Column: 5,
								Line:   77,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   77,
								},
								File:   "influxdb.flux",
								Source: "Timeable",
								Start: ast.Position{
									Column: 8,
									Line:   77,
								},
							},
						},
						Name: "Timeable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   77,
								},
								File:   "influxdb.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   77,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   78,
							},
							File:   "influxdb.flux",
							Source: "B: Timeable",
							Start: ast.Position{
								Column: 5,
								Line:   78,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   78,
								},
								File:   "influxdb.flux",
								Source: "Timeable",
								Start: ast.Position{
									Column: 8,
									Line:   78,
								},
							},
						},
						Name: "Timeable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   78,
								},
								File:   "influxdb.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   78,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 48,
								Line:   76,
							},
							File:   "influxdb.flux",
							Source: "(\n    ?bucket: string,\n    ?bucketID: string,\n    ?org: string,\n    ?orgID: string,\n    ?host: string,\n    ?token: string,\n    start: A,\n    ?stop: B,\n    ?predicate: (r: {T with _measurement: string, _field: string, _value: S}) => bool,\n) => [{_start: time, _stop: time, _value: int}]",
							Start: ast.Position{
								Column: 23,
								Line:   66,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   67,
								},
								File:   "influxdb.flux",
								Source: "?bucket: string",
								Start: ast.Position{
									Column: 5,
									Line:   67,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   67,
									},
									File:   "influxdb.flux",
									Source: "bucket",
									Start: ast.Position{
										Column: 6,
										Line:   67,
									},
								},
							},
							Name: "bucket",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   67,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 14,
										Line:   67,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   67,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 14,
											Line:   67,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   68,
								},
								File:   "influxdb.flux",
								Source: "?bucketID: string",
								Start: ast.Position{
									Column: 5,
									Line:   68,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   68,
									},
									File:   "influxdb.flux",
									Source: "bucketID",
									Start: ast.Position{
										Column: 6,
										Line:   68,
									},
								},
							},
							Name: "bucketID",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   68,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 16,
										Line:   68,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   68,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 16,
											Line:   68,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   69,
								},
								File:   "influxdb.flux",
								Source: "?org: string",
								Start: ast.Position{
									Column: 5,
									Line:   69,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   69,
									},
									File:   "influxdb.flux",
									Source: "org",
									Start: ast.Position{
										Column: 6,
										Line:   69,
									},
								},
							},
							Name: "org",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   69,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 11,
										Line:   69,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   69,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 11,
											Line:   69,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   70,
								},
								File:   "influxdb.flux",
								Source: "?orgID: string",
								Start: ast.Position{
									Column: 5,
									Line:   70,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   70,
									},
									File:   "influxdb.flux",
									Source: "orgID",
									Start: ast.Position{
										Column: 6,
										Line:   70,
									},
								},
							},
							Name: "orgID",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   70,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 13,
										Line:   70,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   70,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 13,
											Line:   70,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   71,
								},
								File:   "influxdb.flux",
								Source: "?host: string",
								Start: ast.Position{
									Column: 5,
									Line:   71,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   71,
									},
									File:   "influxdb.flux",
									Source: "host",
									Start: ast.Position{
										Column: 6,
										Line:   71,
									},
								},
							},
							Name: "host",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   71,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 12,
										Line:   71,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   71,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 12,
											Line:   71,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   72,
								},
								File:   "influxdb.flux",
								Source: "?token: string",
								Start: ast.Position{
									Column: 5,
									Line:   72,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   72,
									},
									File:   "influxdb.flux",
									Source: "token",
									Start: ast.Position{
										Column: 6,
										Line:   72,
									},
								},
							},
							Name: "token",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   72,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 13,
										Line:   72,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   72,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 13,
											Line:   72,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   73,
								},
								File:   "influxdb.flux",
								Source: "start: A",
								Start: ast.Position{
									Column: 5,
									Line:   73,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   73,
									},
									File:   "influxdb.flux",
									Source: "start",
									Start: ast.Position{
										Column: 5,
										Line:   73,
									},
								},
							},
							Name: "start",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   73,
									},
									File:   "influxdb.flux",
									Source: "A",
									Start: ast.Position{
										Column: 12,
										Line:   73,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   73,
										},
										File:   "influxdb.flux",
										Source: "A",
										Start: ast.Position{
											Column: 12,
											Line:   73,
										},
									},
								},
								Name: "A",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   74,
								},
								File:   "influxdb.flux",
								Source: "?stop: B",
								Start: ast.Position{
									Column: 5,
									Line:   74,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   74,
									},
									File:   "influxdb.flux",
									Source: "stop",
									Start: ast.Position{
										Column: 6,
										Line:   74,
									},
								},
							},
							Name: "stop",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   74,
									},
									File:   "influxdb.flux",
									Source: "B",
									Start: ast.Position{
										Column: 12,
										Line:   74,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   74,
										},
										File:   "influxdb.flux",
										Source: "B",
										Start: ast.Position{
											Column: 12,
											Line:   74,
										},
									},
								},
								Name: "B",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   75,
								},
								File:   "influxdb.flux",
								Source: "?predicate: (r: {T with _measurement: string, _field: string, _value: S}) => bool",
								Start: ast.Position{
									Column: 5,
									Line:   75,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   75,
									},
									File:   "influxdb.flux",
									Source: "predicate",
									Start: ast.Position{
										Column: 6,
										Line:   75,
									},
								},
							},
							Name: "predicate",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 86,
										Line:   75,
									},
									File:   "influxdb.flux",
									Source: "(r: {T with _measurement: string, _field: string, _value: S}) => bool",
									Start: ast.Position{
										Column: 17,
										Line:   75,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   75,
										},
										File:   "influxdb.flux",
										Source: "r: {T with _measurement: string, _field: string, _value: S}",
										Start: ast.Position{
											Column: 18,
											Line:   75,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   75,
											},
											File:   "influxdb.flux",
											Source: "r",
											Start: ast.Position{
												Column: 18,
												Line:   75,
											},
										},
									},
									Name: "r",
								},
								Ty: &ast.RecordType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   75,
											},
											File:   "influxdb.flux",
											Source: "{T with _measurement: string, _field: string, _value: S}",
											Start: ast.Position{
												Column: 21,
												Line:   75,
											},
										},
									},
									Properties: []*ast.PropertyType{&ast.PropertyType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   75,
												},
												File:   "influxdb.flux",
												Source: "_measurement: string",
												Start: ast.Position{
													Column: 29,
													Line:   75,
												},
											},
										},
										Name: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   75,
													},
													File:   "influxdb.flux",
													Source: "_measurement",
													Start: ast.Position{
														Column: 29,
														Line:   75,
													},
												},
											},
											Name: "_measurement",
										},
										Ty: &ast.NamedType{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 49,
														Line:   75,
													},
													File:   "influxdb.flux",
													Source: "string",
													Start: ast.Position{
														Column: 43,
														Line:   75,
													},
												},
											},
											ID: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   75,
														},
														File:   "influxdb.flux",
														Source: "string",
														Start: ast.Position{
															Column: 43,
															Line:   75,
														},
													},
												},
												Name: "string",
											},
										},
									}, &ast.PropertyType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   75,
												},
												File:   "influxdb.flux",
												Source: "_field: string",
												Start: ast.Position{
													Column: 51,
													Line:   75,
												},
											},
										},
										Name: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 57,
														Line:   75,
													},
													File:   "influxdb.flux",
													Source: "_field",
													Start: ast.Position{
														Column: 51,
														Line:   75,
													},
												},
											},
											Name: "_field",
										},
										Ty: &ast.NamedType{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 65,
														Line:   75,
													},
													File:   "influxdb.flux",
													Source: "string",
													Start: ast.Position{
														Column: 59,
														Line:   75,
													},
												},
											},
											ID: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 65,
															Line:   75,
														},
														File:   "influxdb.flux",
														Source: "string",
														Start: ast.Position{
															Column: 59,
															Line:   75,
														},
													},
												},
												Name: "string",
											},
										},
									}, &ast.PropertyType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 76,
													Line:   75,
												},
												File:   "influxdb.flux",
												Source: "_value: S",
												Start: ast.Position{
													Column: 67,
													Line:   75,
												},
											},
										},
										Name: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 73,
														Line:   75,
													},
													File:   "influxdb.flux",
													Source: "_value",
													Start: ast.Position{
														Column: 67,
														Line:   75,
													},
												},
											},
											Name: "_value",
										},
										Ty: &ast.TvarType{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 76,
														Line:   75,
													},
													File:   "influxdb.flux",
													Source: "S",
													Start: ast.Position{
														Column: 75,
														Line:   75,
													},
												},
											},
											ID: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 76,
															Line:   75,
														},
														File:   "influxdb.flux",
														Source: "S",
														Start: ast.Position{
															Column: 75,
															Line:   75,
														},
													},
												},
												Name: "S",
											},
										},
									}},
									Tvar: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   75,
												},
												File:   "influxdb.flux",
												Source: "T",
												Start: ast.Position{
													Column: 22,
													Line:   75,
												},
											},
										},
										Name: "T",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 86,
											Line:   75,
										},
										File:   "influxdb.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 82,
											Line:   75,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 86,
												Line:   75,
											},
											File:   "influxdb.flux",
											Source: "bool",
											Start: ast.Position{
												Column: 82,
												Line:   75,
											},
										},
									},
									Name: "bool",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   76,
								},
								File:   "influxdb.flux",
								Source: "[{_start: time, _stop: time, _value: int}]",
								Start: ast.Position{
									Column: 6,
									Line:   76,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   76,
									},
									File:   "influxdb.flux",
									Source: "{_start: time, _stop: time, _value: int}",
									Start: ast.Position{
										Column: 7,
										Line:   76,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   76,
										},
										File:   "influxdb.flux",
										Source: "_start: time",
										Start: ast.Position{
											Column: 8,
											Line:   76,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   76,
											},
											File:   "influxdb.flux",
											Source: "_start",
											Start: ast.Position{
												Column: 8,
												Line:   76,
											},
										},
									},
									Name: "_start",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   76,
											},
											File:   "influxdb.flux",
											Source: "time",
											Start: ast.Position{
												Column: 16,
												Line:   76,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   76,
												},
												File:   "influxdb.flux",
												Source: "time",
												Start: ast.Position{
													Column: 16,
													Line:   76,
												},
											},
										},
										Name: "time",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   76,
										},
										File:   "influxdb.flux",
										Source: "_stop: time",
										Start: ast.Position{
											Column: 22,
											Line:   76,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   76,
											},
											File:   "influxdb.flux",
											Source: "_stop",
											Start: ast.Position{
												Column: 22,
												Line:   76,
											},
										},
									},
									Name: "_stop",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   76,
											},
											File:   "influxdb.flux",
											Source: "time",
											Start: ast.Position{
												Column: 29,
												Line:   76,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   76,
												},
												File:   "influxdb.flux",
												Source: "time",
												Start: ast.Position{
													Column: 29,
													Line:   76,
												},
											},
										},
										Name: "time",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   76,
										},
										File:   "influxdb.flux",
										Source: "_value: int",
										Start: ast.Position{
											Column: 35,
											Line:   76,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   76,
											},
											File:   "influxdb.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 35,
												Line:   76,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   76,
											},
											File:   "influxdb.flux",
											Source: "int",
											Start: ast.Position{
												Column: 43,
												Line:   76,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   76,
												},
												File:   "influxdb.flux",
												Source: "int",
												Start: ast.Position{
													Column: 43,
													Line:   76,
												},
											},
										},
										Name: "int",
									},
								},
							}},
							Tvar: nil,
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   80,
					},
					File:   "influxdb.flux",
					Source: "builtin from",
					Start: ast.Position{
						Column: 1,
						Line:   80,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   80,
						},
						File:   "influxdb.flux",
						Source: "from",
						Start: ast.Position{
							Column: 9,
							Line:   80,
						},
					},
				},
				Name: "from",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 77,
							Line:   87,
						},
						File:   "influxdb.flux",
						Source: "(\n    ?bucket: string,\n    ?bucketID: string,\n    ?org: string,\n    ?orgID: string,\n    ?host: string,\n    ?token: string,\n) => [{B with _measurement: string, _field: string, _time: time, _value: A}]",
						Start: ast.Position{
							Column: 16,
							Line:   80,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 77,
								Line:   87,
							},
							File:   "influxdb.flux",
							Source: "(\n    ?bucket: string,\n    ?bucketID: string,\n    ?org: string,\n    ?orgID: string,\n    ?host: string,\n    ?token: string,\n) => [{B with _measurement: string, _field: string, _time: time, _value: A}]",
							Start: ast.Position{
								Column: 16,
								Line:   80,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   81,
								},
								File:   "influxdb.flux",
								Source: "?bucket: string",
								Start: ast.Position{
									Column: 5,
									Line:   81,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   81,
									},
									File:   "influxdb.flux",
									Source: "bucket",
									Start: ast.Position{
										Column: 6,
										Line:   81,
									},
								},
							},
							Name: "bucket",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   81,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 14,
										Line:   81,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   81,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 14,
											Line:   81,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   82,
								},
								File:   "influxdb.flux",
								Source: "?bucketID: string",
								Start: ast.Position{
									Column: 5,
									Line:   82,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   82,
									},
									File:   "influxdb.flux",
									Source: "bucketID",
									Start: ast.Position{
										Column: 6,
										Line:   82,
									},
								},
							},
							Name: "bucketID",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   82,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 16,
										Line:   82,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   82,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 16,
											Line:   82,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   83,
								},
								File:   "influxdb.flux",
								Source: "?org: string",
								Start: ast.Position{
									Column: 5,
									Line:   83,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   83,
									},
									File:   "influxdb.flux",
									Source: "org",
									Start: ast.Position{
										Column: 6,
										Line:   83,
									},
								},
							},
							Name: "org",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   83,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 11,
										Line:   83,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   83,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 11,
											Line:   83,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   84,
								},
								File:   "influxdb.flux",
								Source: "?orgID: string",
								Start: ast.Position{
									Column: 5,
									Line:   84,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   84,
									},
									File:   "influxdb.flux",
									Source: "orgID",
									Start: ast.Position{
										Column: 6,
										Line:   84,
									},
								},
							},
							Name: "orgID",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   84,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 13,
										Line:   84,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   84,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 13,
											Line:   84,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   85,
								},
								File:   "influxdb.flux",
								Source: "?host: string",
								Start: ast.Position{
									Column: 5,
									Line:   85,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   85,
									},
									File:   "influxdb.flux",
									Source: "host",
									Start: ast.Position{
										Column: 6,
										Line:   85,
									},
								},
							},
							Name: "host",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   85,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 12,
										Line:   85,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   85,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 12,
											Line:   85,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   86,
								},
								File:   "influxdb.flux",
								Source: "?token: string",
								Start: ast.Position{
									Column: 5,
									Line:   86,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   86,
									},
									File:   "influxdb.flux",
									Source: "token",
									Start: ast.Position{
										Column: 6,
										Line:   86,
									},
								},
							},
							Name: "token",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   86,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 13,
										Line:   86,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   86,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 13,
											Line:   86,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 77,
									Line:   87,
								},
								File:   "influxdb.flux",
								Source: "[{B with _measurement: string, _field: string, _time: time, _value: A}]",
								Start: ast.Position{
									Column: 6,
									Line:   87,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 76,
										Line:   87,
									},
									File:   "influxdb.flux",
									Source: "{B with _measurement: string, _field: string, _time: time, _value: A}",
									Start: ast.Position{
										Column: 7,
										Line:   87,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   87,
										},
										File:   "influxdb.flux",
										Source: "_measurement: string",
										Start: ast.Position{
											Column: 15,
											Line:   87,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   87,
											},
											File:   "influxdb.flux",
											Source: "_measurement",
											Start: ast.Position{
												Column: 15,
												Line:   87,
											},
										},
									},
									Name: "_measurement",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   87,
											},
											File:   "influxdb.flux",
											Source: "string",
											Start: ast.Position{
												Column: 29,
												Line:   87,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   87,
												},
												File:   "influxdb.flux",
												Source: "string",
												Start: ast.Position{
													Column: 29,
													Line:   87,
												},
											},
										},
										Name: "string",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   87,
										},
										File:   "influxdb.flux",
										Source: "_field: string",
										Start: ast.Position{
											Column: 37,
											Line:   87,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   87,
											},
											File:   "influxdb.flux",
											Source: "_field",
											Start: ast.Position{
												Column: 37,
												Line:   87,
											},
										},
									},
									Name: "_field",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   87,
											},
											File:   "influxdb.flux",
											Source: "string",
											Start: ast.Position{
												Column: 45,
												Line:   87,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   87,
												},
												File:   "influxdb.flux",
												Source: "string",
												Start: ast.Position{
													Column: 45,
													Line:   87,
												},
											},
										},
										Name: "string",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   87,
										},
										File:   "influxdb.flux",
										Source: "_time: time",
										Start: ast.Position{
											Column: 53,
											Line:   87,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   87,
											},
											File:   "influxdb.flux",
											Source: "_time",
											Start: ast.Position{
												Column: 53,
												Line:   87,
											},
										},
									},
									Name: "_time",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 64,
												Line:   87,
											},
											File:   "influxdb.flux",
											Source: "time",
											Start: ast.Position{
												Column: 60,
												Line:   87,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 64,
													Line:   87,
												},
												File:   "influxdb.flux",
												Source: "time",
												Start: ast.Position{
													Column: 60,
													Line:   87,
												},
											},
										},
										Name: "time",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   87,
										},
										File:   "influxdb.flux",
										Source: "_value: A",
										Start: ast.Position{
											Column: 66,
											Line:   87,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 72,
												Line:   87,
											},
											File:   "influxdb.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 66,
												Line:   87,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 75,
												Line:   87,
											},
											File:   "influxdb.flux",
											Source: "A",
											Start: ast.Position{
												Column: 74,
												Line:   87,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 75,
													Line:   87,
												},
												File:   "influxdb.flux",
												Source: "A",
												Start: ast.Position{
													Column: 74,
													Line:   87,
												},
											},
										},
										Name: "A",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   87,
										},
										File:   "influxdb.flux",
										Source: "B",
										Start: ast.Position{
											Column: 8,
											Line:   87,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 11,
						Line:   89,
					},
					File:   "influxdb.flux",
					Source: "builtin to",
					Start: ast.Position{
						Column: 1,
						Line:   89,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   89,
						},
						File:   "influxdb.flux",
						Source: "to",
						Start: ast.Position{
							Column: 9,
							Line:   89,
						},
					},
				},
				Name: "to",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   103,
						},
						File:   "influxdb.flux",
						Source: "(\n    <-tables: [A],\n    ?bucket: string,\n    ?bucketID: string,\n    ?org: string,\n    ?orgID: string,\n    ?host: string,\n    ?token: string,\n    ?timeColumn: string,\n    ?measurementColumn: string,\n    ?tagColumns: [string],\n    ?fieldFn: (r: A) => B,\n) => [A] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 14,
							Line:   89,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   102,
							},
							File:   "influxdb.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   102,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   102,
								},
								File:   "influxdb.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   102,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   102,
								},
								File:   "influxdb.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   102,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   103,
							},
							File:   "influxdb.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   103,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   103,
								},
								File:   "influxdb.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   103,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   103,
								},
								File:   "influxdb.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   103,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   101,
							},
							File:   "influxdb.flux",
							Source: "(\n    <-tables: [A],\n    ?bucket: string,\n    ?bucketID: string,\n    ?org: string,\n    ?orgID: string,\n    ?host: string,\n    ?token: string,\n    ?timeColumn: string,\n    ?measurementColumn: string,\n    ?tagColumns: [string],\n    ?fieldFn: (r: A) => B,\n) => [A]",
							Start: ast.Position{
								Column: 14,
								Line:   89,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   90,
								},
								File:   "influxdb.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   90,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   90,
									},
									File:   "influxdb.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   90,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   90,
									},
									File:   "influxdb.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   90,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   90,
										},
										File:   "influxdb.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   90,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   90,
											},
											File:   "influxdb.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   90,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   91,
								},
								File:   "influxdb.flux",
								Source: "?bucket: string",
								Start: ast.Position{
									Column: 5,
									Line:   91,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   91,
									},
									File:   "influxdb.flux",
									Source: "bucket",
									Start: ast.Position{
										Column: 6,
										Line:   91,
									},
								},
							},
							Name: "bucket",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   91,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 14,
										Line:   91,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   91,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 14,
											Line:   91,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   92,
								},
								File:   "influxdb.flux",
								Source: "?bucketID: string",
								Start: ast.Position{
									Column: 5,
									Line:   92,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   92,
									},
									File:   "influxdb.flux",
									Source: "bucketID",
									Start: ast.Position{
										Column: 6,
										Line:   92,
									},
								},
							},
							Name: "bucketID",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   92,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 16,
										Line:   92,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   92,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 16,
											Line:   92,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   93,
								},
								File:   "influxdb.flux",
								Source: "?org: string",
								Start: ast.Position{
									Column: 5,
									Line:   93,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   93,
									},
									File:   "influxdb.flux",
									Source: "org",
									Start: ast.Position{
										Column: 6,
										Line:   93,
									},
								},
							},
							Name: "org",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   93,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 11,
										Line:   93,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   93,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 11,
											Line:   93,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   94,
								},
								File:   "influxdb.flux",
								Source: "?orgID: string",
								Start: ast.Position{
									Column: 5,
									Line:   94,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   94,
									},
									File:   "influxdb.flux",
									Source: "orgID",
									Start: ast.Position{
										Column: 6,
										Line:   94,
									},
								},
							},
							Name: "orgID",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   94,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 13,
										Line:   94,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   94,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 13,
											Line:   94,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   95,
								},
								File:   "influxdb.flux",
								Source: "?host: string",
								Start: ast.Position{
									Column: 5,
									Line:   95,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   95,
									},
									File:   "influxdb.flux",
									Source: "host",
									Start: ast.Position{
										Column: 6,
										Line:   95,
									},
								},
							},
							Name: "host",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   95,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 12,
										Line:   95,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   95,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 12,
											Line:   95,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   96,
								},
								File:   "influxdb.flux",
								Source: "?token: string",
								Start: ast.Position{
									Column: 5,
									Line:   96,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   96,
									},
									File:   "influxdb.flux",
									Source: "token",
									Start: ast.Position{
										Column: 6,
										Line:   96,
									},
								},
							},
							Name: "token",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   96,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 13,
										Line:   96,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   96,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 13,
											Line:   96,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   97,
								},
								File:   "influxdb.flux",
								Source: "?timeColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   97,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   97,
									},
									File:   "influxdb.flux",
									Source: "timeColumn",
									Start: ast.Position{
										Column: 6,
										Line:   97,
									},
								},
							},
							Name: "timeColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   97,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 18,
										Line:   97,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   97,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 18,
											Line:   97,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   98,
								},
								File:   "influxdb.flux",
								Source: "?measurementColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   98,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   98,
									},
									File:   "influxdb.flux",
									Source: "measurementColumn",
									Start: ast.Position{
										Column: 6,
										Line:   98,
									},
								},
							},
							Name: "measurementColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   98,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 25,
										Line:   98,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   98,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 25,
											Line:   98,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   99,
								},
								File:   "influxdb.flux",
								Source: "?tagColumns: [string]",
								Start: ast.Position{
									Column: 5,
									Line:   99,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   99,
									},
									File:   "influxdb.flux",
									Source: "tagColumns",
									Start: ast.Position{
										Column: 6,
										Line:   99,
									},
								},
							},
							Name: "tagColumns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   99,
									},
									File:   "influxdb.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 18,
										Line:   99,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   99,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 19,
											Line:   99,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   99,
											},
											File:   "influxdb.flux",
											Source: "string",
											Start: ast.Position{
												Column: 19,
												Line:   99,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   100,
								},
								File:   "influxdb.flux",
								Source: "?fieldFn: (r: A) => B",
								Start: ast.Position{
									Column: 5,
									Line:   100,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   100,
									},
									File:   "influxdb.flux",
									Source: "fieldFn",
									Start: ast.Position{
										Column: 6,
										Line:   100,
									},
								},
							},
							Name: "fieldFn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   100,
									},
									File:   "influxdb.flux",
									Source: "(r: A) => B",
									Start: ast.Position{
										Column: 15,
										Line:   100,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   100,
										},
										File:   "influxdb.flux",
										Source: "r: A",
										Start: ast.Position{
											Column: 16,
											Line:   100,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   100,
											},
											File:   "influxdb.flux",
											Source: "r",
											Start: ast.Position{
												Column: 16,
												Line:   100,
											},
										},
									},
									Name: "r",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   100,
											},
											File:   "influxdb.flux",
											Source: "A",
											Start: ast.Position{
												Column: 19,
												Line:   100,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   100,
												},
												File:   "influxdb.flux",
												Source: "A",
												Start: ast.Position{
													Column: 19,
													Line:   100,
												},
											},
										},
										Name: "A",
									},
								},
							}},
							Return: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   100,
										},
										File:   "influxdb.flux",
										Source: "B",
										Start: ast.Position{
											Column: 25,
											Line:   100,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   100,
											},
											File:   "influxdb.flux",
											Source: "B",
											Start: ast.Position{
												Column: 25,
												Line:   100,
											},
										},
									},
									Name: "B",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   101,
								},
								File:   "influxdb.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 6,
									Line:   101,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   101,
									},
									File:   "influxdb.flux",
									Source: "A",
									Start: ast.Position{
										Column: 7,
										Line:   101,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   101,
										},
										File:   "influxdb.flux",
										Source: "A",
										Start: ast.Position{
											Column: 7,
											Line:   101,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   105,
					},
					File:   "influxdb.flux",
					Source: "builtin buckets",
					Start: ast.Position{
						Column: 1,
						Line:   105,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   105,
						},
						File:   "influxdb.flux",
						Source: "buckets",
						Start: ast.Position{
							Column: 9,
							Line:   105,
						},
					},
				},
				Name: "buckets",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   116,
						},
						File:   "influxdb.flux",
						Source: "(\n    ?org: string,\n    ?orgID: string,\n    ?host: string,\n    ?token: string,\n) => [{\n    name: string,\n    id: string,\n    organizationID: string,\n    retentionPolicy: string,\n    retentionPeriod: int,\n}]",
						Start: ast.Position{
							Column: 19,
							Line:   105,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   116,
							},
							File:   "influxdb.flux",
							Source: "(\n    ?org: string,\n    ?orgID: string,\n    ?host: string,\n    ?token: string,\n) => [{\n    name: string,\n    id: string,\n    organizationID: string,\n    retentionPolicy: string,\n    retentionPeriod: int,\n}]",
							Start: ast.Position{
								Column: 19,
								Line:   105,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   106,
								},
								File:   "influxdb.flux",
								Source: "?org: string",
								Start: ast.Position{
									Column: 5,
									Line:   106,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   106,
									},
									File:   "influxdb.flux",
									Source: "org",
									Start: ast.Position{
										Column: 6,
										Line:   106,
									},
								},
							},
							Name: "org",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   106,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 11,
										Line:   106,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   106,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 11,
											Line:   106,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   107,
								},
								File:   "influxdb.flux",
								Source: "?orgID: string",
								Start: ast.Position{
									Column: 5,
									Line:   107,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   107,
									},
									File:   "influxdb.flux",
									Source: "orgID",
									Start: ast.Position{
										Column: 6,
										Line:   107,
									},
								},
							},
							Name: "orgID",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   107,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 13,
										Line:   107,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   107,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 13,
											Line:   107,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   108,
								},
								File:   "influxdb.flux",
								Source: "?host: string",
								Start: ast.Position{
									Column: 5,
									Line:   108,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   108,
									},
									File:   "influxdb.flux",
									Source: "host",
									Start: ast.Position{
										Column: 6,
										Line:   108,
									},
								},
							},
							Name: "host",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   108,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 12,
										Line:   108,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   108,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 12,
											Line:   108,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   109,
								},
								File:   "influxdb.flux",
								Source: "?token: string",
								Start: ast.Position{
									Column: 5,
									Line:   109,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   109,
									},
									File:   "influxdb.flux",
									Source: "token",
									Start: ast.Position{
										Column: 6,
										Line:   109,
									},
								},
							},
							Name: "token",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   109,
									},
									File:   "influxdb.flux",
									Source: "string",
									Start: ast.Position{
										Column: 13,
										Line:   109,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   109,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 13,
											Line:   109,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   116,
								},
								File:   "influxdb.flux",
								Source: "[{\n    name: string,\n    id: string,\n    organizationID: string,\n    retentionPolicy: string,\n    retentionPeriod: int,\n}]",
								Start: ast.Position{
									Column: 6,
									Line:   110,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   116,
									},
									File:   "influxdb.flux",
									Source: "{\n    name: string,\n    id: string,\n    organizationID: string,\n    retentionPolicy: string,\n    retentionPeriod: int,\n}",
									Start: ast.Position{
										Column: 7,
										Line:   110,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   111,
										},
										File:   "influxdb.flux",
										Source: "name: string",
										Start: ast.Position{
											Column: 5,
											Line:   111,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   111,
											},
											File:   "influxdb.flux",
											Source: "name",
											Start: ast.Position{
												Column: 5,
												Line:   111,
											},
										},
									},
									Name: "name",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   111,
											},
											File:   "influxdb.flux",
											Source: "string",
											Start: ast.Position{
												Column: 11,
												Line:   111,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   111,
												},
												File:   "influxdb.flux",
												Source: "string",
												Start: ast.Position{
													Column: 11,
													Line:   111,
												},
											},
										},
										Name: "string",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   112,
										},
										File:   "influxdb.flux",
										Source: "id: string",
										Start: ast.Position{
											Column: 5,
											Line:   112,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   112,
											},
											File:   "influxdb.flux",
											Source: "id",
											Start: ast.Position{
												Column: 5,
												Line:   112,
											},
										},
									},
									Name: "id",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   112,
											},
											File:   "influxdb.flux",
											Source: "string",
											Start: ast.Position{
												Column: 9,
												Line:   112,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   112,
												},
												File:   "influxdb.flux",
												Source: "string",
												Start: ast.Position{
													Column: 9,
													Line:   112,
												},
											},
										},
										Name: "string",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   113,
										},
										File:   "influxdb.flux",
										Source: "organizationID: string",
										Start: ast.Position{
											Column: 5,
											Line:   113,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   113,
											},
											File:   "influxdb.flux",
											Source: "organizationID",
											Start: ast.Position{
												Column: 5,
												Line:   113,
											},
										},
									},
									Name: "organizationID",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   113,
											},
											File:   "influxdb.flux",
											Source: "string",
											Start: ast.Position{
												Column: 21,
												Line:   113,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   113,
												},
												File:   "influxdb.flux",
												Source: "string",
												Start: ast.Position{
													Column: 21,
													Line:   113,
												},
											},
										},
										Name: "string",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   114,
										},
										File:   "influxdb.flux",
										Source: "retentionPolicy: string",
										Start: ast.Position{
											Column: 5,
											Line:   114,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   114,
											},
											File:   "influxdb.flux",
											Source: "retentionPolicy",
											Start: ast.Position{
												Column: 5,
												Line:   114,
											},
										},
									},
									Name: "retentionPolicy",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   114,
											},
											File:   "influxdb.flux",
											Source: "string",
											Start: ast.Position{
												Column: 22,
												Line:   114,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   114,
												},
												File:   "influxdb.flux",
												Source: "string",
												Start: ast.Position{
													Column: 22,
													Line:   114,
												},
											},
										},
										Name: "string",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   115,
										},
										File:   "influxdb.flux",
										Source: "retentionPeriod: int",
										Start: ast.Position{
											Column: 5,
											Line:   115,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   115,
											},
											File:   "influxdb.flux",
											Source: "retentionPeriod",
											Start: ast.Position{
												Column: 5,
												Line:   115,
											},
										},
									},
									Name: "retentionPeriod",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   115,
											},
											File:   "influxdb.flux",
											Source: "int",
											Start: ast.Position{
												Column: 22,
												Line:   115,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   115,
												},
												File:   "influxdb.flux",
												Source: "int",
												Start: ast.Position{
													Column: 22,
													Line:   115,
												},
											},
										},
										Name: "int",
									},
								},
							}},
							Tvar: nil,
						},
					},
				},
			},
		}},
		Eof:      nil,
		Imports:  nil,
		Metadata: "parser-type=rust",
		Name:     "influxdb.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Package influxdb provides functions for analyzing InfluxDB metadata.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   2,
					},
					File:   "influxdb.flux",
					Source: "package influxdb",
					Start: ast.Position{
						Column: 1,
						Line:   2,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   2,
						},
						File:   "influxdb.flux",
						Source: "influxdb",
						Start: ast.Position{
							Column: 9,
							Line:   2,
						},
					},
				},
				Name: "influxdb",
			},
		},
	}},
	Package: "influxdb",
	Path:    "influxdata/influxdb",
}
