// DO NOT EDIT: This file is autogenerated via the builtin command.

package geo

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 30,
					Line:   240,
				},
				File:   "geo.flux",
				Source: "package geo\n\n\nimport \"experimental\"\nimport \"influxdata/influxdb/v1\"\n\n// Units\noption units = {\n    distance: \"km\",\n}\n\n//\n// Builtin GIS functions\n//\n// Returns boolean whether the region contains specified geometry.\nbuiltin stContains : (region: A, geometry: B, units: {distance: string}) => bool where A: Record, B: Record\n\n// Returns distance from given region to specified geometry.\nbuiltin stDistance : (region: A, geometry: B, units: {distance: string}) => float where A: Record, B: Record\n\n// Returns length of a curve.\nbuiltin stLength : (geometry: A, units: {distance: string}) => float where A: Record\n\n//\n// Flux GIS ST functions\n//\nST_Contains = (region, geometry, units=units) => stContains(region: region, geometry: geometry, units: units)\nST_Distance = (region, geometry, units=units) => stDistance(region: region, geometry: geometry, units: units)\nST_DWithin = (region, geometry, distance, units=units) => stDistance(region: region, geometry: geometry, units: units) <= distance\nST_Intersects = (region, geometry, units=units) => stDistance(region: region, geometry: geometry, units: units) <= 0.0\nST_Length = (geometry, units=units) => stLength(geometry: geometry, units: units)\n\n// Non-standard\nST_LineString = (tables=<-) => tables\n    |> reduce(\n        fn: (r, accumulator) => ({\n            __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n            __count: accumulator.__count + 1,\n        }),\n        identity: {\n            __linestring: \"\",\n            __count: 0,\n        },\n    )\n    |> drop(columns: [\"__count\"])\n    |> rename(columns: {__linestring: \"st_linestring\"})\n\n//\n// None of the following builtin functions are intended to be used by end users.\n//\n// Calculates grid (set of cell ID tokens) for given region and according to options.\nbuiltin getGrid : (\n    region: T,\n    ?minSize: int,\n    ?maxSize: int,\n    ?level: int,\n    ?maxLevel: int,\n    units: {distance: string},\n) => {level: int, set: [string]} where\n    T: Record\n\n// Returns level of specified cell ID token.\nbuiltin getLevel : (token: string) => int\n\n// Returns cell ID token for given cell or lat/lon point at specified level.\nbuiltin s2CellIDToken : (?token: string, ?point: {lat: float, lon: float}, level: int) => string\n\n// Returns lat/lon coordinates of given cell ID token.\nbuiltin s2CellLatLon : (token: string) => {lat: float, lon: float}\n\n//\n// Flux functions\n//\n// Gets level of cell ID tag `s2cellID` from the first record from the first table in the stream.\n_detectLevel = (tables=<-) => {\n    _r0 = tables\n        |> tableFind(fn: (key) => exists key.s2_cell_id)\n        |> getRecord(idx: 0)\n    _level = if exists _r0 then\n        getLevel(token: _r0.s2_cell_id)\n    else\n        666\n\n    return _level\n}\n\n//\n// Convenience functions\n//\n// Pivots values to row-wise sets.\ntoRows = (tables=<-) => tables\n    |> v1.fieldsAsCols()\n\n// Shapes data to meet the requirements of the geo package.\n// Renames fields containing latitude and longitude values to lat and lon.\n// Pivots values to row-wise sets.\n// Generates an s2_cell_id tag for each reach using lat and lon values.\n// Adds the s2_cell_id column to the group key.\nshapeData = (tables=<-, latField, lonField, level) => tables\n    |> map(\n        fn: (r) => ({r with\n            _field: if r._field == latField then\n                \"lat\"\n            else if r._field == lonField then\n                \"lon\"\n            else\n                r._field,\n        }),\n    )\n    |> toRows()\n    |> map(\n        fn: (r) => ({r with\n            s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n        }),\n    )\n    |> experimental.group(\n        columns: [\"s2_cell_id\"],\n        mode: \"extend\",\n    )\n\n//\n// Filtering functions\n//\n// Filters records by a box, a circle or a polygon area using S2 cell ID tag.\n// It is a coarse filter, as the grid always overlays the region, the result will likely contain records\n// with lat/lon outside the specified region.\ngridFilter = (\n        tables=<-,\n        region,\n        minSize=24,\n        maxSize=-1,\n        level=-1,\n        s2cellIDLevel=-1,\n        units=units,\n) => {\n    _s2cellIDLevel = if s2cellIDLevel == -1 then\n        tables\n            |> _detectLevel()\n    else\n        s2cellIDLevel\n    _grid = getGrid(\n        region: region,\n        minSize: minSize,\n        maxSize: maxSize,\n        level: level,\n        maxLevel: _s2cellIDLevel,\n        units: units,\n    )\n\n    return tables\n        |> filter(\n            fn: (r) => if _grid.level == _s2cellIDLevel then\n                contains(value: r.s2_cell_id, set: _grid.set)\n            else\n                contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set),\n        )\n}\n\n// Filters records by specified region.\n// It is an exact filter and must be used after `toRows()` because it requires `lat` and `lon` columns in input row sets.\nstrictFilter = (tables=<-, region) => tables\n    |> filter(fn: (r) => ST_Contains(region: region, geometry: {lat: r.lat, lon: r.lon}))\n\n// Two-phase filtering by specified region.\n// Checks to see if data is already pivoted and contains a lat column.\n// Returns pivoted data.\nfilterRows = (\n        tables=<-,\n        region,\n        minSize=24,\n        maxSize=-1,\n        level=-1,\n        s2cellIDLevel=-1,\n        strict=true,\n) => {\n    _columns = tables\n        |> columns(column: \"_value\")\n        |> tableFind(fn: (key) => true)\n        |> getColumn(column: \"_value\")\n    _rows = if contains(value: \"lat\", set: _columns) then\n        tables\n            |> gridFilter(\n                region: region,\n                minSize: minSize,\n                maxSize: maxSize,\n                level: level,\n                s2cellIDLevel: s2cellIDLevel,\n            )\n    else\n        tables\n            |> gridFilter(\n                region: region,\n                minSize: minSize,\n                maxSize: maxSize,\n                level: level,\n                s2cellIDLevel: s2cellIDLevel,\n            )\n            |> toRows()\n    _result = if strict then\n        _rows\n            |> strictFilter(region)\n    else\n        _rows\n\n    return _result\n}\n\n//\n// Grouping functions\n//\n// intended to be used row-wise sets (i.e after `toRows()`)\n// Groups data by area of size specified by level. Result is grouped by `newColumn`.\n// Grouping levels: https://s2geometry.io/resources/s2cell_statistics.html\ngroupByArea = (tables=<-, newColumn, level, s2cellIDLevel=-1) => {\n    _s2cellIDLevel = if s2cellIDLevel == -1 then\n        tables\n            |> _detectLevel()\n    else\n        s2cellIDLevel\n    _prepared = if level == _s2cellIDLevel then\n        tables\n            |> duplicate(column: \"s2_cell_id\", as: newColumn)\n    else\n        tables\n            |> map(\n                fn: (r) => ({r with\n                    _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n                }),\n            )\n            |> rename(columns: {_s2_cell_id_xxx: newColumn})\n\n    return _prepared\n        |> group(columns: [newColumn])\n}\n\n// Groups rows into tracks.\nasTracks = (tables=<-, groupBy=[\"id\", \"tid\"], orderBy=[\"_time\"]) => tables\n    |> group(columns: groupBy)\n    |> sort(columns: orderBy)",
				Start: ast.Position{
					Column: 1,
					Line:   2,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   11,
						},
						File:   "geo.flux",
						Source: "units = {\n    distance: \"km\",\n}",
						Start: ast.Position{
							Column: 8,
							Line:   9,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   9,
							},
							File:   "geo.flux",
							Source: "units",
							Start: ast.Position{
								Column: 8,
								Line:   9,
							},
						},
					},
					Name: "units",
				},
				Init: &ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   11,
							},
							File:   "geo.flux",
							Source: "{\n    distance: \"km\",\n}",
							Start: ast.Position{
								Column: 16,
								Line:   9,
							},
						},
					},
					Lbrace: nil,
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   10,
								},
								File:   "geo.flux",
								Source: "distance: \"km\"",
								Start: ast.Position{
									Column: 5,
									Line:   10,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   10,
									},
									File:   "geo.flux",
									Source: "distance",
									Start: ast.Position{
										Column: 5,
										Line:   10,
									},
								},
							},
							Name: "distance",
						},
						Separator: nil,
						Value: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   10,
									},
									File:   "geo.flux",
									Source: "\"km\"",
									Start: ast.Position{
										Column: 15,
										Line:   10,
									},
								},
							},
							Value: "km",
						},
					}},
					Rbrace: nil,
					With:   nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Units\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   11,
					},
					File:   "geo.flux",
					Source: "option units = {\n    distance: \"km\",\n}",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Builtin GIS functions\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Returns boolean whether the region contains specified geometry.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   17,
					},
					File:   "geo.flux",
					Source: "builtin stContains",
					Start: ast.Position{
						Column: 1,
						Line:   17,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   17,
						},
						File:   "geo.flux",
						Source: "stContains",
						Start: ast.Position{
							Column: 9,
							Line:   17,
						},
					},
				},
				Name: "stContains",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 108,
							Line:   17,
						},
						File:   "geo.flux",
						Source: "(region: A, geometry: B, units: {distance: string}) => bool where A: Record, B: Record",
						Start: ast.Position{
							Column: 22,
							Line:   17,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 97,
								Line:   17,
							},
							File:   "geo.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 88,
								Line:   17,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   17,
								},
								File:   "geo.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 91,
									Line:   17,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 89,
									Line:   17,
								},
								File:   "geo.flux",
								Source: "A",
								Start: ast.Position{
									Column: 88,
									Line:   17,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 108,
								Line:   17,
							},
							File:   "geo.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 99,
								Line:   17,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 108,
									Line:   17,
								},
								File:   "geo.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 102,
									Line:   17,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 100,
									Line:   17,
								},
								File:   "geo.flux",
								Source: "B",
								Start: ast.Position{
									Column: 99,
									Line:   17,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   17,
							},
							File:   "geo.flux",
							Source: "(region: A, geometry: B, units: {distance: string}) => bool",
							Start: ast.Position{
								Column: 22,
								Line:   17,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   17,
								},
								File:   "geo.flux",
								Source: "region: A",
								Start: ast.Position{
									Column: 23,
									Line:   17,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   17,
									},
									File:   "geo.flux",
									Source: "region",
									Start: ast.Position{
										Column: 23,
										Line:   17,
									},
								},
							},
							Name: "region",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   17,
									},
									File:   "geo.flux",
									Source: "A",
									Start: ast.Position{
										Column: 31,
										Line:   17,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   17,
										},
										File:   "geo.flux",
										Source: "A",
										Start: ast.Position{
											Column: 31,
											Line:   17,
										},
									},
								},
								Name: "A",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   17,
								},
								File:   "geo.flux",
								Source: "geometry: B",
								Start: ast.Position{
									Column: 34,
									Line:   17,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   17,
									},
									File:   "geo.flux",
									Source: "geometry",
									Start: ast.Position{
										Column: 34,
										Line:   17,
									},
								},
							},
							Name: "geometry",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   17,
									},
									File:   "geo.flux",
									Source: "B",
									Start: ast.Position{
										Column: 44,
										Line:   17,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   17,
										},
										File:   "geo.flux",
										Source: "B",
										Start: ast.Position{
											Column: 44,
											Line:   17,
										},
									},
								},
								Name: "B",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   17,
								},
								File:   "geo.flux",
								Source: "units: {distance: string}",
								Start: ast.Position{
									Column: 47,
									Line:   17,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 52,
										Line:   17,
									},
									File:   "geo.flux",
									Source: "units",
									Start: ast.Position{
										Column: 47,
										Line:   17,
									},
								},
							},
							Name: "units",
						},
						Ty: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 72,
										Line:   17,
									},
									File:   "geo.flux",
									Source: "{distance: string}",
									Start: ast.Position{
										Column: 54,
										Line:   17,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   17,
										},
										File:   "geo.flux",
										Source: "distance: string",
										Start: ast.Position{
											Column: 55,
											Line:   17,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 63,
												Line:   17,
											},
											File:   "geo.flux",
											Source: "distance",
											Start: ast.Position{
												Column: 55,
												Line:   17,
											},
										},
									},
									Name: "distance",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 71,
												Line:   17,
											},
											File:   "geo.flux",
											Source: "string",
											Start: ast.Position{
												Column: 65,
												Line:   17,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 71,
													Line:   17,
												},
												File:   "geo.flux",
												Source: "string",
												Start: ast.Position{
													Column: 65,
													Line:   17,
												},
											},
										},
										Name: "string",
									},
								},
							}},
							Tvar: nil,
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   17,
								},
								File:   "geo.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 77,
									Line:   17,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   17,
									},
									File:   "geo.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 77,
										Line:   17,
									},
								},
							},
							Name: "bool",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Returns distance from given region to specified geometry.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   20,
					},
					File:   "geo.flux",
					Source: "builtin stDistance",
					Start: ast.Position{
						Column: 1,
						Line:   20,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   20,
						},
						File:   "geo.flux",
						Source: "stDistance",
						Start: ast.Position{
							Column: 9,
							Line:   20,
						},
					},
				},
				Name: "stDistance",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 109,
							Line:   20,
						},
						File:   "geo.flux",
						Source: "(region: A, geometry: B, units: {distance: string}) => float where A: Record, B: Record",
						Start: ast.Position{
							Column: 22,
							Line:   20,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 98,
								Line:   20,
							},
							File:   "geo.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 89,
								Line:   20,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 98,
									Line:   20,
								},
								File:   "geo.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 92,
									Line:   20,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 90,
									Line:   20,
								},
								File:   "geo.flux",
								Source: "A",
								Start: ast.Position{
									Column: 89,
									Line:   20,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 109,
								Line:   20,
							},
							File:   "geo.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 100,
								Line:   20,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 109,
									Line:   20,
								},
								File:   "geo.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 103,
									Line:   20,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 101,
									Line:   20,
								},
								File:   "geo.flux",
								Source: "B",
								Start: ast.Position{
									Column: 100,
									Line:   20,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 82,
								Line:   20,
							},
							File:   "geo.flux",
							Source: "(region: A, geometry: B, units: {distance: string}) => float",
							Start: ast.Position{
								Column: 22,
								Line:   20,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   20,
								},
								File:   "geo.flux",
								Source: "region: A",
								Start: ast.Position{
									Column: 23,
									Line:   20,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   20,
									},
									File:   "geo.flux",
									Source: "region",
									Start: ast.Position{
										Column: 23,
										Line:   20,
									},
								},
							},
							Name: "region",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   20,
									},
									File:   "geo.flux",
									Source: "A",
									Start: ast.Position{
										Column: 31,
										Line:   20,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   20,
										},
										File:   "geo.flux",
										Source: "A",
										Start: ast.Position{
											Column: 31,
											Line:   20,
										},
									},
								},
								Name: "A",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   20,
								},
								File:   "geo.flux",
								Source: "geometry: B",
								Start: ast.Position{
									Column: 34,
									Line:   20,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   20,
									},
									File:   "geo.flux",
									Source: "geometry",
									Start: ast.Position{
										Column: 34,
										Line:   20,
									},
								},
							},
							Name: "geometry",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   20,
									},
									File:   "geo.flux",
									Source: "B",
									Start: ast.Position{
										Column: 44,
										Line:   20,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   20,
										},
										File:   "geo.flux",
										Source: "B",
										Start: ast.Position{
											Column: 44,
											Line:   20,
										},
									},
								},
								Name: "B",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   20,
								},
								File:   "geo.flux",
								Source: "units: {distance: string}",
								Start: ast.Position{
									Column: 47,
									Line:   20,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 52,
										Line:   20,
									},
									File:   "geo.flux",
									Source: "units",
									Start: ast.Position{
										Column: 47,
										Line:   20,
									},
								},
							},
							Name: "units",
						},
						Ty: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 72,
										Line:   20,
									},
									File:   "geo.flux",
									Source: "{distance: string}",
									Start: ast.Position{
										Column: 54,
										Line:   20,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   20,
										},
										File:   "geo.flux",
										Source: "distance: string",
										Start: ast.Position{
											Column: 55,
											Line:   20,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 63,
												Line:   20,
											},
											File:   "geo.flux",
											Source: "distance",
											Start: ast.Position{
												Column: 55,
												Line:   20,
											},
										},
									},
									Name: "distance",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 71,
												Line:   20,
											},
											File:   "geo.flux",
											Source: "string",
											Start: ast.Position{
												Column: 65,
												Line:   20,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 71,
													Line:   20,
												},
												File:   "geo.flux",
												Source: "string",
												Start: ast.Position{
													Column: 65,
													Line:   20,
												},
											},
										},
										Name: "string",
									},
								},
							}},
							Tvar: nil,
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   20,
								},
								File:   "geo.flux",
								Source: "float",
								Start: ast.Position{
									Column: 77,
									Line:   20,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 82,
										Line:   20,
									},
									File:   "geo.flux",
									Source: "float",
									Start: ast.Position{
										Column: 77,
										Line:   20,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Returns length of a curve.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   23,
					},
					File:   "geo.flux",
					Source: "builtin stLength",
					Start: ast.Position{
						Column: 1,
						Line:   23,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   23,
						},
						File:   "geo.flux",
						Source: "stLength",
						Start: ast.Position{
							Column: 9,
							Line:   23,
						},
					},
				},
				Name: "stLength",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 85,
							Line:   23,
						},
						File:   "geo.flux",
						Source: "(geometry: A, units: {distance: string}) => float where A: Record",
						Start: ast.Position{
							Column: 20,
							Line:   23,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 85,
								Line:   23,
							},
							File:   "geo.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 76,
								Line:   23,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 85,
									Line:   23,
								},
								File:   "geo.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 79,
									Line:   23,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 77,
									Line:   23,
								},
								File:   "geo.flux",
								Source: "A",
								Start: ast.Position{
									Column: 76,
									Line:   23,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 69,
								Line:   23,
							},
							File:   "geo.flux",
							Source: "(geometry: A, units: {distance: string}) => float",
							Start: ast.Position{
								Column: 20,
								Line:   23,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   23,
								},
								File:   "geo.flux",
								Source: "geometry: A",
								Start: ast.Position{
									Column: 21,
									Line:   23,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   23,
									},
									File:   "geo.flux",
									Source: "geometry",
									Start: ast.Position{
										Column: 21,
										Line:   23,
									},
								},
							},
							Name: "geometry",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   23,
									},
									File:   "geo.flux",
									Source: "A",
									Start: ast.Position{
										Column: 31,
										Line:   23,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   23,
										},
										File:   "geo.flux",
										Source: "A",
										Start: ast.Position{
											Column: 31,
											Line:   23,
										},
									},
								},
								Name: "A",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 59,
									Line:   23,
								},
								File:   "geo.flux",
								Source: "units: {distance: string}",
								Start: ast.Position{
									Column: 34,
									Line:   23,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   23,
									},
									File:   "geo.flux",
									Source: "units",
									Start: ast.Position{
										Column: 34,
										Line:   23,
									},
								},
							},
							Name: "units",
						},
						Ty: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   23,
									},
									File:   "geo.flux",
									Source: "{distance: string}",
									Start: ast.Position{
										Column: 41,
										Line:   23,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   23,
										},
										File:   "geo.flux",
										Source: "distance: string",
										Start: ast.Position{
											Column: 42,
											Line:   23,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   23,
											},
											File:   "geo.flux",
											Source: "distance",
											Start: ast.Position{
												Column: 42,
												Line:   23,
											},
										},
									},
									Name: "distance",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   23,
											},
											File:   "geo.flux",
											Source: "string",
											Start: ast.Position{
												Column: 52,
												Line:   23,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   23,
												},
												File:   "geo.flux",
												Source: "string",
												Start: ast.Position{
													Column: 52,
													Line:   23,
												},
											},
										},
										Name: "string",
									},
								},
							}},
							Tvar: nil,
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 69,
									Line:   23,
								},
								File:   "geo.flux",
								Source: "float",
								Start: ast.Position{
									Column: 64,
									Line:   23,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 69,
										Line:   23,
									},
									File:   "geo.flux",
									Source: "float",
									Start: ast.Position{
										Column: 64,
										Line:   23,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 110,
						Line:   28,
					},
					File:   "geo.flux",
					Source: "ST_Contains = (region, geometry, units=units) => stContains(region: region, geometry: geometry, units: units)",
					Start: ast.Position{
						Column: 1,
						Line:   28,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Flux GIS ST functions\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   28,
						},
						File:   "geo.flux",
						Source: "ST_Contains",
						Start: ast.Position{
							Column: 1,
							Line:   28,
						},
					},
				},
				Name: "ST_Contains",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 110,
							Line:   28,
						},
						File:   "geo.flux",
						Source: "(region, geometry, units=units) => stContains(region: region, geometry: geometry, units: units)",
						Start: ast.Position{
							Column: 15,
							Line:   28,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 109,
									Line:   28,
								},
								File:   "geo.flux",
								Source: "region: region, geometry: geometry, units: units",
								Start: ast.Position{
									Column: 61,
									Line:   28,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   28,
									},
									File:   "geo.flux",
									Source: "region: region",
									Start: ast.Position{
										Column: 61,
										Line:   28,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   28,
										},
										File:   "geo.flux",
										Source: "region",
										Start: ast.Position{
											Column: 61,
											Line:   28,
										},
									},
								},
								Name: "region",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   28,
										},
										File:   "geo.flux",
										Source: "region",
										Start: ast.Position{
											Column: 69,
											Line:   28,
										},
									},
								},
								Name: "region",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 95,
										Line:   28,
									},
									File:   "geo.flux",
									Source: "geometry: geometry",
									Start: ast.Position{
										Column: 77,
										Line:   28,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 85,
											Line:   28,
										},
										File:   "geo.flux",
										Source: "geometry",
										Start: ast.Position{
											Column: 77,
											Line:   28,
										},
									},
								},
								Name: "geometry",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 95,
											Line:   28,
										},
										File:   "geo.flux",
										Source: "geometry",
										Start: ast.Position{
											Column: 87,
											Line:   28,
										},
									},
								},
								Name: "geometry",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 109,
										Line:   28,
									},
									File:   "geo.flux",
									Source: "units: units",
									Start: ast.Position{
										Column: 97,
										Line:   28,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 102,
											Line:   28,
										},
										File:   "geo.flux",
										Source: "units",
										Start: ast.Position{
											Column: 97,
											Line:   28,
										},
									},
								},
								Name: "units",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 109,
											Line:   28,
										},
										File:   "geo.flux",
										Source: "units",
										Start: ast.Position{
											Column: 104,
											Line:   28,
										},
									},
								},
								Name: "units",
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 110,
								Line:   28,
							},
							File:   "geo.flux",
							Source: "stContains(region: region, geometry: geometry, units: units)",
							Start: ast.Position{
								Column: 50,
								Line:   28,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   28,
								},
								File:   "geo.flux",
								Source: "stContains",
								Start: ast.Position{
									Column: 50,
									Line:   28,
								},
							},
						},
						Name: "stContains",
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   28,
							},
							File:   "geo.flux",
							Source: "region",
							Start: ast.Position{
								Column: 16,
								Line:   28,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   28,
								},
								File:   "geo.flux",
								Source: "region",
								Start: ast.Position{
									Column: 16,
									Line:   28,
								},
							},
						},
						Name: "region",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   28,
							},
							File:   "geo.flux",
							Source: "geometry",
							Start: ast.Position{
								Column: 24,
								Line:   28,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   28,
								},
								File:   "geo.flux",
								Source: "geometry",
								Start: ast.Position{
									Column: 24,
									Line:   28,
								},
							},
						},
						Name: "geometry",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 45,
								Line:   28,
							},
							File:   "geo.flux",
							Source: "units=units",
							Start: ast.Position{
								Column: 34,
								Line:   28,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   28,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 34,
									Line:   28,
								},
							},
						},
						Name: "units",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   28,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 40,
									Line:   28,
								},
							},
						},
						Name: "units",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 110,
						Line:   29,
					},
					File:   "geo.flux",
					Source: "ST_Distance = (region, geometry, units=units) => stDistance(region: region, geometry: geometry, units: units)",
					Start: ast.Position{
						Column: 1,
						Line:   29,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   29,
						},
						File:   "geo.flux",
						Source: "ST_Distance",
						Start: ast.Position{
							Column: 1,
							Line:   29,
						},
					},
				},
				Name: "ST_Distance",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 110,
							Line:   29,
						},
						File:   "geo.flux",
						Source: "(region, geometry, units=units) => stDistance(region: region, geometry: geometry, units: units)",
						Start: ast.Position{
							Column: 15,
							Line:   29,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 109,
									Line:   29,
								},
								File:   "geo.flux",
								Source: "region: region, geometry: geometry, units: units",
								Start: ast.Position{
									Column: 61,
									Line:   29,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   29,
									},
									File:   "geo.flux",
									Source: "region: region",
									Start: ast.Position{
										Column: 61,
										Line:   29,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   29,
										},
										File:   "geo.flux",
										Source: "region",
										Start: ast.Position{
											Column: 61,
											Line:   29,
										},
									},
								},
								Name: "region",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   29,
										},
										File:   "geo.flux",
										Source: "region",
										Start: ast.Position{
											Column: 69,
											Line:   29,
										},
									},
								},
								Name: "region",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 95,
										Line:   29,
									},
									File:   "geo.flux",
									Source: "geometry: geometry",
									Start: ast.Position{
										Column: 77,
										Line:   29,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 85,
											Line:   29,
										},
										File:   "geo.flux",
										Source: "geometry",
										Start: ast.Position{
											Column: 77,
											Line:   29,
										},
									},
								},
								Name: "geometry",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 95,
											Line:   29,
										},
										File:   "geo.flux",
										Source: "geometry",
										Start: ast.Position{
											Column: 87,
											Line:   29,
										},
									},
								},
								Name: "geometry",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 109,
										Line:   29,
									},
									File:   "geo.flux",
									Source: "units: units",
									Start: ast.Position{
										Column: 97,
										Line:   29,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 102,
											Line:   29,
										},
										File:   "geo.flux",
										Source: "units",
										Start: ast.Position{
											Column: 97,
											Line:   29,
										},
									},
								},
								Name: "units",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 109,
											Line:   29,
										},
										File:   "geo.flux",
										Source: "units",
										Start: ast.Position{
											Column: 104,
											Line:   29,
										},
									},
								},
								Name: "units",
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 110,
								Line:   29,
							},
							File:   "geo.flux",
							Source: "stDistance(region: region, geometry: geometry, units: units)",
							Start: ast.Position{
								Column: 50,
								Line:   29,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   29,
								},
								File:   "geo.flux",
								Source: "stDistance",
								Start: ast.Position{
									Column: 50,
									Line:   29,
								},
							},
						},
						Name: "stDistance",
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   29,
							},
							File:   "geo.flux",
							Source: "region",
							Start: ast.Position{
								Column: 16,
								Line:   29,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   29,
								},
								File:   "geo.flux",
								Source: "region",
								Start: ast.Position{
									Column: 16,
									Line:   29,
								},
							},
						},
						Name: "region",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   29,
							},
							File:   "geo.flux",
							Source: "geometry",
							Start: ast.Position{
								Column: 24,
								Line:   29,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   29,
								},
								File:   "geo.flux",
								Source: "geometry",
								Start: ast.Position{
									Column: 24,
									Line:   29,
								},
							},
						},
						Name: "geometry",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 45,
								Line:   29,
							},
							File:   "geo.flux",
							Source: "units=units",
							Start: ast.Position{
								Column: 34,
								Line:   29,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   29,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 34,
									Line:   29,
								},
							},
						},
						Name: "units",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   29,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 40,
									Line:   29,
								},
							},
						},
						Name: "units",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 131,
						Line:   30,
					},
					File:   "geo.flux",
					Source: "ST_DWithin = (region, geometry, distance, units=units) => stDistance(region: region, geometry: geometry, units: units) <= distance",
					Start: ast.Position{
						Column: 1,
						Line:   30,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   30,
						},
						File:   "geo.flux",
						Source: "ST_DWithin",
						Start: ast.Position{
							Column: 1,
							Line:   30,
						},
					},
				},
				Name: "ST_DWithin",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 131,
							Line:   30,
						},
						File:   "geo.flux",
						Source: "(region, geometry, distance, units=units) => stDistance(region: region, geometry: geometry, units: units) <= distance",
						Start: ast.Position{
							Column: 14,
							Line:   30,
						},
					},
				},
				Body: &ast.BinaryExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 131,
								Line:   30,
							},
							File:   "geo.flux",
							Source: "stDistance(region: region, geometry: geometry, units: units) <= distance",
							Start: ast.Position{
								Column: 59,
								Line:   30,
							},
						},
					},
					Left: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 118,
										Line:   30,
									},
									File:   "geo.flux",
									Source: "region: region, geometry: geometry, units: units",
									Start: ast.Position{
										Column: 70,
										Line:   30,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 84,
											Line:   30,
										},
										File:   "geo.flux",
										Source: "region: region",
										Start: ast.Position{
											Column: 70,
											Line:   30,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   30,
											},
											File:   "geo.flux",
											Source: "region",
											Start: ast.Position{
												Column: 70,
												Line:   30,
											},
										},
									},
									Name: "region",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   30,
											},
											File:   "geo.flux",
											Source: "region",
											Start: ast.Position{
												Column: 78,
												Line:   30,
											},
										},
									},
									Name: "region",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 104,
											Line:   30,
										},
										File:   "geo.flux",
										Source: "geometry: geometry",
										Start: ast.Position{
											Column: 86,
											Line:   30,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 94,
												Line:   30,
											},
											File:   "geo.flux",
											Source: "geometry",
											Start: ast.Position{
												Column: 86,
												Line:   30,
											},
										},
									},
									Name: "geometry",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 104,
												Line:   30,
											},
											File:   "geo.flux",
											Source: "geometry",
											Start: ast.Position{
												Column: 96,
												Line:   30,
											},
										},
									},
									Name: "geometry",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 118,
											Line:   30,
										},
										File:   "geo.flux",
										Source: "units: units",
										Start: ast.Position{
											Column: 106,
											Line:   30,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 111,
												Line:   30,
											},
											File:   "geo.flux",
											Source: "units",
											Start: ast.Position{
												Column: 106,
												Line:   30,
											},
										},
									},
									Name: "units",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 118,
												Line:   30,
											},
											File:   "geo.flux",
											Source: "units",
											Start: ast.Position{
												Column: 113,
												Line:   30,
											},
										},
									},
									Name: "units",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 119,
									Line:   30,
								},
								File:   "geo.flux",
								Source: "stDistance(region: region, geometry: geometry, units: units)",
								Start: ast.Position{
									Column: 59,
									Line:   30,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 69,
										Line:   30,
									},
									File:   "geo.flux",
									Source: "stDistance",
									Start: ast.Position{
										Column: 59,
										Line:   30,
									},
								},
							},
							Name: "stDistance",
						},
						Lparen: nil,
						Rparen: nil,
					},
					Operator: 7,
					Right: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 131,
									Line:   30,
								},
								File:   "geo.flux",
								Source: "distance",
								Start: ast.Position{
									Column: 123,
									Line:   30,
								},
							},
						},
						Name: "distance",
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   30,
							},
							File:   "geo.flux",
							Source: "region",
							Start: ast.Position{
								Column: 15,
								Line:   30,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   30,
								},
								File:   "geo.flux",
								Source: "region",
								Start: ast.Position{
									Column: 15,
									Line:   30,
								},
							},
						},
						Name: "region",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   30,
							},
							File:   "geo.flux",
							Source: "geometry",
							Start: ast.Position{
								Column: 23,
								Line:   30,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   30,
								},
								File:   "geo.flux",
								Source: "geometry",
								Start: ast.Position{
									Column: 23,
									Line:   30,
								},
							},
						},
						Name: "geometry",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 41,
								Line:   30,
							},
							File:   "geo.flux",
							Source: "distance",
							Start: ast.Position{
								Column: 33,
								Line:   30,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   30,
								},
								File:   "geo.flux",
								Source: "distance",
								Start: ast.Position{
									Column: 33,
									Line:   30,
								},
							},
						},
						Name: "distance",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   30,
							},
							File:   "geo.flux",
							Source: "units=units",
							Start: ast.Position{
								Column: 43,
								Line:   30,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   30,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 43,
									Line:   30,
								},
							},
						},
						Name: "units",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   30,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 49,
									Line:   30,
								},
							},
						},
						Name: "units",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 119,
						Line:   31,
					},
					File:   "geo.flux",
					Source: "ST_Intersects = (region, geometry, units=units) => stDistance(region: region, geometry: geometry, units: units) <= 0.0",
					Start: ast.Position{
						Column: 1,
						Line:   31,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   31,
						},
						File:   "geo.flux",
						Source: "ST_Intersects",
						Start: ast.Position{
							Column: 1,
							Line:   31,
						},
					},
				},
				Name: "ST_Intersects",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 119,
							Line:   31,
						},
						File:   "geo.flux",
						Source: "(region, geometry, units=units) => stDistance(region: region, geometry: geometry, units: units) <= 0.0",
						Start: ast.Position{
							Column: 17,
							Line:   31,
						},
					},
				},
				Body: &ast.BinaryExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 119,
								Line:   31,
							},
							File:   "geo.flux",
							Source: "stDistance(region: region, geometry: geometry, units: units) <= 0.0",
							Start: ast.Position{
								Column: 52,
								Line:   31,
							},
						},
					},
					Left: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 111,
										Line:   31,
									},
									File:   "geo.flux",
									Source: "region: region, geometry: geometry, units: units",
									Start: ast.Position{
										Column: 63,
										Line:   31,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   31,
										},
										File:   "geo.flux",
										Source: "region: region",
										Start: ast.Position{
											Column: 63,
											Line:   31,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   31,
											},
											File:   "geo.flux",
											Source: "region",
											Start: ast.Position{
												Column: 63,
												Line:   31,
											},
										},
									},
									Name: "region",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   31,
											},
											File:   "geo.flux",
											Source: "region",
											Start: ast.Position{
												Column: 71,
												Line:   31,
											},
										},
									},
									Name: "region",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 97,
											Line:   31,
										},
										File:   "geo.flux",
										Source: "geometry: geometry",
										Start: ast.Position{
											Column: 79,
											Line:   31,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 87,
												Line:   31,
											},
											File:   "geo.flux",
											Source: "geometry",
											Start: ast.Position{
												Column: 79,
												Line:   31,
											},
										},
									},
									Name: "geometry",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 97,
												Line:   31,
											},
											File:   "geo.flux",
											Source: "geometry",
											Start: ast.Position{
												Column: 89,
												Line:   31,
											},
										},
									},
									Name: "geometry",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 111,
											Line:   31,
										},
										File:   "geo.flux",
										Source: "units: units",
										Start: ast.Position{
											Column: 99,
											Line:   31,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 104,
												Line:   31,
											},
											File:   "geo.flux",
											Source: "units",
											Start: ast.Position{
												Column: 99,
												Line:   31,
											},
										},
									},
									Name: "units",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 111,
												Line:   31,
											},
											File:   "geo.flux",
											Source: "units",
											Start: ast.Position{
												Column: 106,
												Line:   31,
											},
										},
									},
									Name: "units",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 112,
									Line:   31,
								},
								File:   "geo.flux",
								Source: "stDistance(region: region, geometry: geometry, units: units)",
								Start: ast.Position{
									Column: 52,
									Line:   31,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   31,
									},
									File:   "geo.flux",
									Source: "stDistance",
									Start: ast.Position{
										Column: 52,
										Line:   31,
									},
								},
							},
							Name: "stDistance",
						},
						Lparen: nil,
						Rparen: nil,
					},
					Operator: 7,
					Right: &ast.FloatLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 119,
									Line:   31,
								},
								File:   "geo.flux",
								Source: "0.0",
								Start: ast.Position{
									Column: 116,
									Line:   31,
								},
							},
						},
						Value: 0.0,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   31,
							},
							File:   "geo.flux",
							Source: "region",
							Start: ast.Position{
								Column: 18,
								Line:   31,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   31,
								},
								File:   "geo.flux",
								Source: "region",
								Start: ast.Position{
									Column: 18,
									Line:   31,
								},
							},
						},
						Name: "region",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   31,
							},
							File:   "geo.flux",
							Source: "geometry",
							Start: ast.Position{
								Column: 26,
								Line:   31,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   31,
								},
								File:   "geo.flux",
								Source: "geometry",
								Start: ast.Position{
									Column: 26,
									Line:   31,
								},
							},
						},
						Name: "geometry",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 47,
								Line:   31,
							},
							File:   "geo.flux",
							Source: "units=units",
							Start: ast.Position{
								Column: 36,
								Line:   31,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   31,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 36,
									Line:   31,
								},
							},
						},
						Name: "units",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   31,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 42,
									Line:   31,
								},
							},
						},
						Name: "units",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 82,
						Line:   32,
					},
					File:   "geo.flux",
					Source: "ST_Length = (geometry, units=units) => stLength(geometry: geometry, units: units)",
					Start: ast.Position{
						Column: 1,
						Line:   32,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   32,
						},
						File:   "geo.flux",
						Source: "ST_Length",
						Start: ast.Position{
							Column: 1,
							Line:   32,
						},
					},
				},
				Name: "ST_Length",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 82,
							Line:   32,
						},
						File:   "geo.flux",
						Source: "(geometry, units=units) => stLength(geometry: geometry, units: units)",
						Start: ast.Position{
							Column: 13,
							Line:   32,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   32,
								},
								File:   "geo.flux",
								Source: "geometry: geometry, units: units",
								Start: ast.Position{
									Column: 49,
									Line:   32,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   32,
									},
									File:   "geo.flux",
									Source: "geometry: geometry",
									Start: ast.Position{
										Column: 49,
										Line:   32,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   32,
										},
										File:   "geo.flux",
										Source: "geometry",
										Start: ast.Position{
											Column: 49,
											Line:   32,
										},
									},
								},
								Name: "geometry",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   32,
										},
										File:   "geo.flux",
										Source: "geometry",
										Start: ast.Position{
											Column: 59,
											Line:   32,
										},
									},
								},
								Name: "geometry",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   32,
									},
									File:   "geo.flux",
									Source: "units: units",
									Start: ast.Position{
										Column: 69,
										Line:   32,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 74,
											Line:   32,
										},
										File:   "geo.flux",
										Source: "units",
										Start: ast.Position{
											Column: 69,
											Line:   32,
										},
									},
								},
								Name: "units",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   32,
										},
										File:   "geo.flux",
										Source: "units",
										Start: ast.Position{
											Column: 76,
											Line:   32,
										},
									},
								},
								Name: "units",
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 82,
								Line:   32,
							},
							File:   "geo.flux",
							Source: "stLength(geometry: geometry, units: units)",
							Start: ast.Position{
								Column: 40,
								Line:   32,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   32,
								},
								File:   "geo.flux",
								Source: "stLength",
								Start: ast.Position{
									Column: 40,
									Line:   32,
								},
							},
						},
						Name: "stLength",
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   32,
							},
							File:   "geo.flux",
							Source: "geometry",
							Start: ast.Position{
								Column: 14,
								Line:   32,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   32,
								},
								File:   "geo.flux",
								Source: "geometry",
								Start: ast.Position{
									Column: 14,
									Line:   32,
								},
							},
						},
						Name: "geometry",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   32,
							},
							File:   "geo.flux",
							Source: "units=units",
							Start: ast.Position{
								Column: 24,
								Line:   32,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   32,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 24,
									Line:   32,
								},
							},
						},
						Name: "units",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   32,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 30,
									Line:   32,
								},
							},
						},
						Name: "units",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 56,
						Line:   47,
					},
					File:   "geo.flux",
					Source: "ST_LineString = (tables=<-) => tables\n    |> reduce(\n        fn: (r, accumulator) => ({\n            __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n            __count: accumulator.__count + 1,\n        }),\n        identity: {\n            __linestring: \"\",\n            __count: 0,\n        },\n    )\n    |> drop(columns: [\"__count\"])\n    |> rename(columns: {__linestring: \"st_linestring\"})",
					Start: ast.Position{
						Column: 1,
						Line:   35,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Non-standard\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   35,
						},
						File:   "geo.flux",
						Source: "ST_LineString",
						Start: ast.Position{
							Column: 1,
							Line:   35,
						},
					},
				},
				Name: "ST_LineString",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 56,
							Line:   47,
						},
						File:   "geo.flux",
						Source: "(tables=<-) => tables\n    |> reduce(\n        fn: (r, accumulator) => ({\n            __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n            __count: accumulator.__count + 1,\n        }),\n        identity: {\n            __linestring: \"\",\n            __count: 0,\n        },\n    )\n    |> drop(columns: [\"__count\"])\n    |> rename(columns: {__linestring: \"st_linestring\"})",
						Start: ast.Position{
							Column: 17,
							Line:   35,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   35,
										},
										File:   "geo.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 32,
											Line:   35,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   45,
									},
									File:   "geo.flux",
									Source: "tables\n    |> reduce(\n        fn: (r, accumulator) => ({\n            __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n            __count: accumulator.__count + 1,\n        }),\n        identity: {\n            __linestring: \"\",\n            __count: 0,\n        },\n    )",
									Start: ast.Position{
										Column: 32,
										Line:   35,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   44,
											},
											File:   "geo.flux",
											Source: "fn: (r, accumulator) => ({\n            __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n            __count: accumulator.__count + 1,\n        }),\n        identity: {\n            __linestring: \"\",\n            __count: 0,\n        }",
											Start: ast.Position{
												Column: 9,
												Line:   37,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   40,
												},
												File:   "geo.flux",
												Source: "fn: (r, accumulator) => ({\n            __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n            __count: accumulator.__count + 1,\n        })",
												Start: ast.Position{
													Column: 9,
													Line:   37,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   37,
													},
													File:   "geo.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 9,
														Line:   37,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   40,
													},
													File:   "geo.flux",
													Source: "(r, accumulator) => ({\n            __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n            __count: accumulator.__count + 1,\n        })",
													Start: ast.Position{
														Column: 13,
														Line:   37,
													},
												},
											},
											Body: &ast.ParenExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   40,
														},
														File:   "geo.flux",
														Source: "({\n            __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n            __count: accumulator.__count + 1,\n        })",
														Start: ast.Position{
															Column: 33,
															Line:   37,
														},
													},
												},
												Expression: &ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 10,
																Line:   40,
															},
															File:   "geo.flux",
															Source: "{\n            __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n            __count: accumulator.__count + 1,\n        }",
															Start: ast.Position{
																Column: 34,
																Line:   37,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 144,
																	Line:   38,
																},
																File:   "geo.flux",
																Source: "__linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat)",
																Start: ast.Position{
																	Column: 13,
																	Line:   38,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   38,
																	},
																	File:   "geo.flux",
																	Source: "__linestring",
																	Start: ast.Position{
																		Column: 13,
																		Line:   38,
																	},
																},
															},
															Name: "__linestring",
														},
														Separator: nil,
														Value: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 144,
																		Line:   38,
																	},
																	File:   "geo.flux",
																	Source: "accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat)",
																	Start: ast.Position{
																		Column: 27,
																		Line:   38,
																	},
																},
															},
															Left: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 125,
																			Line:   38,
																		},
																		File:   "geo.flux",
																		Source: "accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \"",
																		Start: ast.Position{
																			Column: 27,
																			Line:   38,
																		},
																	},
																},
																Left: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 119,
																				Line:   38,
																			},
																			File:   "geo.flux",
																			Source: "accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon)",
																			Start: ast.Position{
																				Column: 27,
																				Line:   38,
																			},
																		},
																	},
																	Left: &ast.BinaryExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 100,
																					Line:   38,
																				},
																				File:   "geo.flux",
																				Source: "accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\")",
																				Start: ast.Position{
																					Column: 27,
																					Line:   38,
																				},
																			},
																		},
																		Left: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 51,
																						Line:   38,
																					},
																					File:   "geo.flux",
																					Source: "accumulator.__linestring",
																					Start: ast.Position{
																						Column: 27,
																						Line:   38,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 38,
																							Line:   38,
																						},
																						File:   "geo.flux",
																						Source: "accumulator",
																						Start: ast.Position{
																							Column: 27,
																							Line:   38,
																						},
																					},
																				},
																				Name: "accumulator",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 51,
																							Line:   38,
																						},
																						File:   "geo.flux",
																						Source: "__linestring",
																						Start: ast.Position{
																							Column: 39,
																							Line:   38,
																						},
																					},
																				},
																				Name: "__linestring",
																			},
																			Rbrack: nil,
																		},
																		Operator: 5,
																		Right: &ast.ParenExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 100,
																						Line:   38,
																					},
																					File:   "geo.flux",
																					Source: "(if accumulator.__count > 0 then \", \" else \"\")",
																					Start: ast.Position{
																						Column: 54,
																						Line:   38,
																					},
																				},
																			},
																			Expression: &ast.ConditionalExpression{
																				Alternate: &ast.StringLiteral{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 99,
																								Line:   38,
																							},
																							File:   "geo.flux",
																							Source: "\"\"",
																							Start: ast.Position{
																								Column: 97,
																								Line:   38,
																							},
																						},
																					},
																					Value: "",
																				},
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 99,
																							Line:   38,
																						},
																						File:   "geo.flux",
																						Source: "if accumulator.__count > 0 then \", \" else \"\"",
																						Start: ast.Position{
																							Column: 55,
																							Line:   38,
																						},
																					},
																				},
																				Consequent: &ast.StringLiteral{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 91,
																								Line:   38,
																							},
																							File:   "geo.flux",
																							Source: "\", \"",
																							Start: ast.Position{
																								Column: 87,
																								Line:   38,
																							},
																						},
																					},
																					Value: ", ",
																				},
																				Test: &ast.BinaryExpression{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 81,
																								Line:   38,
																							},
																							File:   "geo.flux",
																							Source: "accumulator.__count > 0",
																							Start: ast.Position{
																								Column: 58,
																								Line:   38,
																							},
																						},
																					},
																					Left: &ast.MemberExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 77,
																									Line:   38,
																								},
																								File:   "geo.flux",
																								Source: "accumulator.__count",
																								Start: ast.Position{
																									Column: 58,
																									Line:   38,
																								},
																							},
																						},
																						Lbrack: nil,
																						Object: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 69,
																										Line:   38,
																									},
																									File:   "geo.flux",
																									Source: "accumulator",
																									Start: ast.Position{
																										Column: 58,
																										Line:   38,
																									},
																								},
																							},
																							Name: "accumulator",
																						},
																						Property: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 77,
																										Line:   38,
																									},
																									File:   "geo.flux",
																									Source: "__count",
																									Start: ast.Position{
																										Column: 70,
																										Line:   38,
																									},
																								},
																							},
																							Name: "__count",
																						},
																						Rbrack: nil,
																					},
																					Operator: 10,
																					Right: &ast.IntegerLiteral{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 81,
																									Line:   38,
																								},
																								File:   "geo.flux",
																								Source: "0",
																								Start: ast.Position{
																									Column: 80,
																									Line:   38,
																								},
																							},
																						},
																						Value: int64(0),
																					},
																				},
																				Tk_else: nil,
																				Tk_if:   nil,
																				Tk_then: nil,
																			},
																			Lparen: nil,
																			Rparen: nil,
																		},
																	},
																	Operator: 5,
																	Right: &ast.CallExpression{
																		Arguments: []ast.Expression{&ast.ObjectExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 118,
																						Line:   38,
																					},
																					File:   "geo.flux",
																					Source: "v: r.lon",
																					Start: ast.Position{
																						Column: 110,
																						Line:   38,
																					},
																				},
																			},
																			Lbrace: nil,
																			Properties: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 118,
																							Line:   38,
																						},
																						File:   "geo.flux",
																						Source: "v: r.lon",
																						Start: ast.Position{
																							Column: 110,
																							Line:   38,
																						},
																					},
																				},
																				Comma: nil,
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 111,
																								Line:   38,
																							},
																							File:   "geo.flux",
																							Source: "v",
																							Start: ast.Position{
																								Column: 110,
																								Line:   38,
																							},
																						},
																					},
																					Name: "v",
																				},
																				Separator: nil,
																				Value: &ast.MemberExpression{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 118,
																								Line:   38,
																							},
																							File:   "geo.flux",
																							Source: "r.lon",
																							Start: ast.Position{
																								Column: 113,
																								Line:   38,
																							},
																						},
																					},
																					Lbrack: nil,
																					Object: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 114,
																									Line:   38,
																								},
																								File:   "geo.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 113,
																									Line:   38,
																								},
																							},
																						},
																						Name: "r",
																					},
																					Property: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 118,
																									Line:   38,
																								},
																								File:   "geo.flux",
																								Source: "lon",
																								Start: ast.Position{
																									Column: 115,
																									Line:   38,
																								},
																							},
																						},
																						Name: "lon",
																					},
																					Rbrack: nil,
																				},
																			}},
																			Rbrace: nil,
																			With:   nil,
																		}},
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 119,
																					Line:   38,
																				},
																				File:   "geo.flux",
																				Source: "string(v: r.lon)",
																				Start: ast.Position{
																					Column: 103,
																					Line:   38,
																				},
																			},
																		},
																		Callee: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 109,
																						Line:   38,
																					},
																					File:   "geo.flux",
																					Source: "string",
																					Start: ast.Position{
																						Column: 103,
																						Line:   38,
																					},
																				},
																			},
																			Name: "string",
																		},
																		Lparen: nil,
																		Rparen: nil,
																	},
																},
																Operator: 5,
																Right: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 125,
																				Line:   38,
																			},
																			File:   "geo.flux",
																			Source: "\" \"",
																			Start: ast.Position{
																				Column: 122,
																				Line:   38,
																			},
																		},
																	},
																	Value: " ",
																},
															},
															Operator: 5,
															Right: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 143,
																				Line:   38,
																			},
																			File:   "geo.flux",
																			Source: "v: r.lat",
																			Start: ast.Position{
																				Column: 135,
																				Line:   38,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 143,
																					Line:   38,
																				},
																				File:   "geo.flux",
																				Source: "v: r.lat",
																				Start: ast.Position{
																					Column: 135,
																					Line:   38,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 136,
																						Line:   38,
																					},
																					File:   "geo.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 135,
																						Line:   38,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 143,
																						Line:   38,
																					},
																					File:   "geo.flux",
																					Source: "r.lat",
																					Start: ast.Position{
																						Column: 138,
																						Line:   38,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 139,
																							Line:   38,
																						},
																						File:   "geo.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 138,
																							Line:   38,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 143,
																							Line:   38,
																						},
																						File:   "geo.flux",
																						Source: "lat",
																						Start: ast.Position{
																							Column: 140,
																							Line:   38,
																						},
																					},
																				},
																				Name: "lat",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 144,
																			Line:   38,
																		},
																		File:   "geo.flux",
																		Source: "string(v: r.lat)",
																		Start: ast.Position{
																			Column: 128,
																			Line:   38,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 134,
																				Line:   38,
																			},
																			File:   "geo.flux",
																			Source: "string",
																			Start: ast.Position{
																				Column: 128,
																				Line:   38,
																			},
																		},
																	},
																	Name: "string",
																},
																Lparen: nil,
																Rparen: nil,
															},
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 45,
																	Line:   39,
																},
																File:   "geo.flux",
																Source: "__count: accumulator.__count + 1",
																Start: ast.Position{
																	Column: 13,
																	Line:   39,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 20,
																		Line:   39,
																	},
																	File:   "geo.flux",
																	Source: "__count",
																	Start: ast.Position{
																		Column: 13,
																		Line:   39,
																	},
																},
															},
															Name: "__count",
														},
														Separator: nil,
														Value: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 45,
																		Line:   39,
																	},
																	File:   "geo.flux",
																	Source: "accumulator.__count + 1",
																	Start: ast.Position{
																		Column: 22,
																		Line:   39,
																	},
																},
															},
															Left: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 41,
																			Line:   39,
																		},
																		File:   "geo.flux",
																		Source: "accumulator.__count",
																		Start: ast.Position{
																			Column: 22,
																			Line:   39,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 33,
																				Line:   39,
																			},
																			File:   "geo.flux",
																			Source: "accumulator",
																			Start: ast.Position{
																				Column: 22,
																				Line:   39,
																			},
																		},
																	},
																	Name: "accumulator",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 41,
																				Line:   39,
																			},
																			File:   "geo.flux",
																			Source: "__count",
																			Start: ast.Position{
																				Column: 34,
																				Line:   39,
																			},
																		},
																	},
																	Name: "__count",
																},
																Rbrack: nil,
															},
															Operator: 5,
															Right: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 45,
																			Line:   39,
																		},
																		File:   "geo.flux",
																		Source: "1",
																		Start: ast.Position{
																			Column: 44,
																			Line:   39,
																		},
																	},
																},
																Value: int64(1),
															},
														},
													}},
													Rbrace: nil,
													With:   nil,
												},
												Lparen: nil,
												Rparen: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   37,
														},
														File:   "geo.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   37,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   37,
															},
															File:   "geo.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   37,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   37,
														},
														File:   "geo.flux",
														Source: "accumulator",
														Start: ast.Position{
															Column: 17,
															Line:   37,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   37,
															},
															File:   "geo.flux",
															Source: "accumulator",
															Start: ast.Position{
																Column: 17,
																Line:   37,
															},
														},
													},
													Name: "accumulator",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   44,
												},
												File:   "geo.flux",
												Source: "identity: {\n            __linestring: \"\",\n            __count: 0,\n        }",
												Start: ast.Position{
													Column: 9,
													Line:   41,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   41,
													},
													File:   "geo.flux",
													Source: "identity",
													Start: ast.Position{
														Column: 9,
														Line:   41,
													},
												},
											},
											Name: "identity",
										},
										Separator: nil,
										Value: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   44,
													},
													File:   "geo.flux",
													Source: "{\n            __linestring: \"\",\n            __count: 0,\n        }",
													Start: ast.Position{
														Column: 19,
														Line:   41,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   42,
														},
														File:   "geo.flux",
														Source: "__linestring: \"\"",
														Start: ast.Position{
															Column: 13,
															Line:   42,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 25,
																Line:   42,
															},
															File:   "geo.flux",
															Source: "__linestring",
															Start: ast.Position{
																Column: 13,
																Line:   42,
															},
														},
													},
													Name: "__linestring",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 29,
																Line:   42,
															},
															File:   "geo.flux",
															Source: "\"\"",
															Start: ast.Position{
																Column: 27,
																Line:   42,
															},
														},
													},
													Value: "",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 23,
															Line:   43,
														},
														File:   "geo.flux",
														Source: "__count: 0",
														Start: ast.Position{
															Column: 13,
															Line:   43,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 20,
																Line:   43,
															},
															File:   "geo.flux",
															Source: "__count",
															Start: ast.Position{
																Column: 13,
																Line:   43,
															},
														},
													},
													Name: "__count",
												},
												Separator: nil,
												Value: &ast.IntegerLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 23,
																Line:   43,
															},
															File:   "geo.flux",
															Source: "0",
															Start: ast.Position{
																Column: 22,
																Line:   43,
															},
														},
													},
													Value: int64(0),
												},
											}},
											Rbrace: nil,
											With:   nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   45,
										},
										File:   "geo.flux",
										Source: "reduce(\n        fn: (r, accumulator) => ({\n            __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n            __count: accumulator.__count + 1,\n        }),\n        identity: {\n            __linestring: \"\",\n            __count: 0,\n        },\n    )",
										Start: ast.Position{
											Column: 8,
											Line:   36,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   36,
											},
											File:   "geo.flux",
											Source: "reduce",
											Start: ast.Position{
												Column: 8,
												Line:   36,
											},
										},
									},
									Name: "reduce",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   46,
								},
								File:   "geo.flux",
								Source: "tables\n    |> reduce(\n        fn: (r, accumulator) => ({\n            __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n            __count: accumulator.__count + 1,\n        }),\n        identity: {\n            __linestring: \"\",\n            __count: 0,\n        },\n    )\n    |> drop(columns: [\"__count\"])",
								Start: ast.Position{
									Column: 32,
									Line:   35,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   46,
										},
										File:   "geo.flux",
										Source: "columns: [\"__count\"]",
										Start: ast.Position{
											Column: 13,
											Line:   46,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   46,
											},
											File:   "geo.flux",
											Source: "columns: [\"__count\"]",
											Start: ast.Position{
												Column: 13,
												Line:   46,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   46,
												},
												File:   "geo.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 13,
													Line:   46,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   46,
												},
												File:   "geo.flux",
												Source: "[\"__count\"]",
												Start: ast.Position{
													Column: 22,
													Line:   46,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 32,
														Line:   46,
													},
													File:   "geo.flux",
													Source: "\"__count\"",
													Start: ast.Position{
														Column: 23,
														Line:   46,
													},
												},
											},
											Value: "__count",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   46,
									},
									File:   "geo.flux",
									Source: "drop(columns: [\"__count\"])",
									Start: ast.Position{
										Column: 8,
										Line:   46,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   46,
										},
										File:   "geo.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 8,
											Line:   46,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   47,
							},
							File:   "geo.flux",
							Source: "tables\n    |> reduce(\n        fn: (r, accumulator) => ({\n            __linestring: accumulator.__linestring + (if accumulator.__count > 0 then \", \" else \"\") + string(v: r.lon) + \" \" + string(v: r.lat),\n            __count: accumulator.__count + 1,\n        }),\n        identity: {\n            __linestring: \"\",\n            __count: 0,\n        },\n    )\n    |> drop(columns: [\"__count\"])\n    |> rename(columns: {__linestring: \"st_linestring\"})",
							Start: ast.Position{
								Column: 32,
								Line:   35,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   47,
									},
									File:   "geo.flux",
									Source: "columns: {__linestring: \"st_linestring\"}",
									Start: ast.Position{
										Column: 15,
										Line:   47,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   47,
										},
										File:   "geo.flux",
										Source: "columns: {__linestring: \"st_linestring\"}",
										Start: ast.Position{
											Column: 15,
											Line:   47,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   47,
											},
											File:   "geo.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 15,
												Line:   47,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   47,
											},
											File:   "geo.flux",
											Source: "{__linestring: \"st_linestring\"}",
											Start: ast.Position{
												Column: 24,
												Line:   47,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   47,
												},
												File:   "geo.flux",
												Source: "__linestring: \"st_linestring\"",
												Start: ast.Position{
													Column: 25,
													Line:   47,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   47,
													},
													File:   "geo.flux",
													Source: "__linestring",
													Start: ast.Position{
														Column: 25,
														Line:   47,
													},
												},
											},
											Name: "__linestring",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   47,
													},
													File:   "geo.flux",
													Source: "\"st_linestring\"",
													Start: ast.Position{
														Column: 39,
														Line:   47,
													},
												},
											},
											Value: "st_linestring",
										},
									}},
									Rbrace: nil,
									With:   nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   47,
								},
								File:   "geo.flux",
								Source: "rename(columns: {__linestring: \"st_linestring\"})",
								Start: ast.Position{
									Column: 8,
									Line:   47,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   47,
									},
									File:   "geo.flux",
									Source: "rename",
									Start: ast.Position{
										Column: 8,
										Line:   47,
									},
								},
							},
							Name: "rename",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   35,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 18,
								Line:   35,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   35,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 18,
									Line:   35,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   35,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 25,
								Line:   35,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "//\n"}, ast.Comment{Text: "// None of the following builtin functions are intended to be used by end users.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Calculates grid (set of cell ID tokens) for given region and according to options.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   53,
					},
					File:   "geo.flux",
					Source: "builtin getGrid",
					Start: ast.Position{
						Column: 1,
						Line:   53,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   53,
						},
						File:   "geo.flux",
						Source: "getGrid",
						Start: ast.Position{
							Column: 9,
							Line:   53,
						},
					},
				},
				Name: "getGrid",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   61,
						},
						File:   "geo.flux",
						Source: "(\n    region: T,\n    ?minSize: int,\n    ?maxSize: int,\n    ?level: int,\n    ?maxLevel: int,\n    units: {distance: string},\n) => {level: int, set: [string]} where\n    T: Record",
						Start: ast.Position{
							Column: 19,
							Line:   53,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   61,
							},
							File:   "geo.flux",
							Source: "T: Record",
							Start: ast.Position{
								Column: 5,
								Line:   61,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   61,
								},
								File:   "geo.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   61,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   61,
								},
								File:   "geo.flux",
								Source: "T",
								Start: ast.Position{
									Column: 5,
									Line:   61,
								},
							},
						},
						Name: "T",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   60,
							},
							File:   "geo.flux",
							Source: "(\n    region: T,\n    ?minSize: int,\n    ?maxSize: int,\n    ?level: int,\n    ?maxLevel: int,\n    units: {distance: string},\n) => {level: int, set: [string]}",
							Start: ast.Position{
								Column: 19,
								Line:   53,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   54,
								},
								File:   "geo.flux",
								Source: "region: T",
								Start: ast.Position{
									Column: 5,
									Line:   54,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   54,
									},
									File:   "geo.flux",
									Source: "region",
									Start: ast.Position{
										Column: 5,
										Line:   54,
									},
								},
							},
							Name: "region",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   54,
									},
									File:   "geo.flux",
									Source: "T",
									Start: ast.Position{
										Column: 13,
										Line:   54,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   54,
										},
										File:   "geo.flux",
										Source: "T",
										Start: ast.Position{
											Column: 13,
											Line:   54,
										},
									},
								},
								Name: "T",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   55,
								},
								File:   "geo.flux",
								Source: "?minSize: int",
								Start: ast.Position{
									Column: 5,
									Line:   55,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   55,
									},
									File:   "geo.flux",
									Source: "minSize",
									Start: ast.Position{
										Column: 6,
										Line:   55,
									},
								},
							},
							Name: "minSize",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   55,
									},
									File:   "geo.flux",
									Source: "int",
									Start: ast.Position{
										Column: 15,
										Line:   55,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   55,
										},
										File:   "geo.flux",
										Source: "int",
										Start: ast.Position{
											Column: 15,
											Line:   55,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   56,
								},
								File:   "geo.flux",
								Source: "?maxSize: int",
								Start: ast.Position{
									Column: 5,
									Line:   56,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   56,
									},
									File:   "geo.flux",
									Source: "maxSize",
									Start: ast.Position{
										Column: 6,
										Line:   56,
									},
								},
							},
							Name: "maxSize",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   56,
									},
									File:   "geo.flux",
									Source: "int",
									Start: ast.Position{
										Column: 15,
										Line:   56,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   56,
										},
										File:   "geo.flux",
										Source: "int",
										Start: ast.Position{
											Column: 15,
											Line:   56,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   57,
								},
								File:   "geo.flux",
								Source: "?level: int",
								Start: ast.Position{
									Column: 5,
									Line:   57,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   57,
									},
									File:   "geo.flux",
									Source: "level",
									Start: ast.Position{
										Column: 6,
										Line:   57,
									},
								},
							},
							Name: "level",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   57,
									},
									File:   "geo.flux",
									Source: "int",
									Start: ast.Position{
										Column: 13,
										Line:   57,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   57,
										},
										File:   "geo.flux",
										Source: "int",
										Start: ast.Position{
											Column: 13,
											Line:   57,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   58,
								},
								File:   "geo.flux",
								Source: "?maxLevel: int",
								Start: ast.Position{
									Column: 5,
									Line:   58,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   58,
									},
									File:   "geo.flux",
									Source: "maxLevel",
									Start: ast.Position{
										Column: 6,
										Line:   58,
									},
								},
							},
							Name: "maxLevel",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   58,
									},
									File:   "geo.flux",
									Source: "int",
									Start: ast.Position{
										Column: 16,
										Line:   58,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   58,
										},
										File:   "geo.flux",
										Source: "int",
										Start: ast.Position{
											Column: 16,
											Line:   58,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   59,
								},
								File:   "geo.flux",
								Source: "units: {distance: string}",
								Start: ast.Position{
									Column: 5,
									Line:   59,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   59,
									},
									File:   "geo.flux",
									Source: "units",
									Start: ast.Position{
										Column: 5,
										Line:   59,
									},
								},
							},
							Name: "units",
						},
						Ty: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   59,
									},
									File:   "geo.flux",
									Source: "{distance: string}",
									Start: ast.Position{
										Column: 12,
										Line:   59,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   59,
										},
										File:   "geo.flux",
										Source: "distance: string",
										Start: ast.Position{
											Column: 13,
											Line:   59,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   59,
											},
											File:   "geo.flux",
											Source: "distance",
											Start: ast.Position{
												Column: 13,
												Line:   59,
											},
										},
									},
									Name: "distance",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   59,
											},
											File:   "geo.flux",
											Source: "string",
											Start: ast.Position{
												Column: 23,
												Line:   59,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   59,
												},
												File:   "geo.flux",
												Source: "string",
												Start: ast.Position{
													Column: 23,
													Line:   59,
												},
											},
										},
										Name: "string",
									},
								},
							}},
							Tvar: nil,
						},
					}},
					Return: &ast.RecordType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   60,
								},
								File:   "geo.flux",
								Source: "{level: int, set: [string]}",
								Start: ast.Position{
									Column: 6,
									Line:   60,
								},
							},
						},
						Properties: []*ast.PropertyType{&ast.PropertyType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   60,
									},
									File:   "geo.flux",
									Source: "level: int",
									Start: ast.Position{
										Column: 7,
										Line:   60,
									},
								},
							},
							Name: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   60,
										},
										File:   "geo.flux",
										Source: "level",
										Start: ast.Position{
											Column: 7,
											Line:   60,
										},
									},
								},
								Name: "level",
							},
							Ty: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   60,
										},
										File:   "geo.flux",
										Source: "int",
										Start: ast.Position{
											Column: 14,
											Line:   60,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   60,
											},
											File:   "geo.flux",
											Source: "int",
											Start: ast.Position{
												Column: 14,
												Line:   60,
											},
										},
									},
									Name: "int",
								},
							},
						}, &ast.PropertyType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   60,
									},
									File:   "geo.flux",
									Source: "set: [string]",
									Start: ast.Position{
										Column: 19,
										Line:   60,
									},
								},
							},
							Name: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   60,
										},
										File:   "geo.flux",
										Source: "set",
										Start: ast.Position{
											Column: 19,
											Line:   60,
										},
									},
								},
								Name: "set",
							},
							Ty: &ast.ArrayType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   60,
										},
										File:   "geo.flux",
										Source: "[string]",
										Start: ast.Position{
											Column: 24,
											Line:   60,
										},
									},
								},
								ElementType: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   60,
											},
											File:   "geo.flux",
											Source: "string",
											Start: ast.Position{
												Column: 25,
												Line:   60,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   60,
												},
												File:   "geo.flux",
												Source: "string",
												Start: ast.Position{
													Column: 25,
													Line:   60,
												},
											},
										},
										Name: "string",
									},
								},
							},
						}},
						Tvar: nil,
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Returns level of specified cell ID token.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   64,
					},
					File:   "geo.flux",
					Source: "builtin getLevel",
					Start: ast.Position{
						Column: 1,
						Line:   64,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   64,
						},
						File:   "geo.flux",
						Source: "getLevel",
						Start: ast.Position{
							Column: 9,
							Line:   64,
						},
					},
				},
				Name: "getLevel",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   64,
						},
						File:   "geo.flux",
						Source: "(token: string) => int",
						Start: ast.Position{
							Column: 20,
							Line:   64,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   64,
							},
							File:   "geo.flux",
							Source: "(token: string) => int",
							Start: ast.Position{
								Column: 20,
								Line:   64,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   64,
								},
								File:   "geo.flux",
								Source: "token: string",
								Start: ast.Position{
									Column: 21,
									Line:   64,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   64,
									},
									File:   "geo.flux",
									Source: "token",
									Start: ast.Position{
										Column: 21,
										Line:   64,
									},
								},
							},
							Name: "token",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   64,
									},
									File:   "geo.flux",
									Source: "string",
									Start: ast.Position{
										Column: 28,
										Line:   64,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   64,
										},
										File:   "geo.flux",
										Source: "string",
										Start: ast.Position{
											Column: 28,
											Line:   64,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   64,
								},
								File:   "geo.flux",
								Source: "int",
								Start: ast.Position{
									Column: 39,
									Line:   64,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   64,
									},
									File:   "geo.flux",
									Source: "int",
									Start: ast.Position{
										Column: 39,
										Line:   64,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Returns cell ID token for given cell or lat/lon point at specified level.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   67,
					},
					File:   "geo.flux",
					Source: "builtin s2CellIDToken",
					Start: ast.Position{
						Column: 1,
						Line:   67,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   67,
						},
						File:   "geo.flux",
						Source: "s2CellIDToken",
						Start: ast.Position{
							Column: 9,
							Line:   67,
						},
					},
				},
				Name: "s2CellIDToken",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 97,
							Line:   67,
						},
						File:   "geo.flux",
						Source: "(?token: string, ?point: {lat: float, lon: float}, level: int) => string",
						Start: ast.Position{
							Column: 25,
							Line:   67,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 97,
								Line:   67,
							},
							File:   "geo.flux",
							Source: "(?token: string, ?point: {lat: float, lon: float}, level: int) => string",
							Start: ast.Position{
								Column: 25,
								Line:   67,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   67,
								},
								File:   "geo.flux",
								Source: "?token: string",
								Start: ast.Position{
									Column: 26,
									Line:   67,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   67,
									},
									File:   "geo.flux",
									Source: "token",
									Start: ast.Position{
										Column: 27,
										Line:   67,
									},
								},
							},
							Name: "token",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   67,
									},
									File:   "geo.flux",
									Source: "string",
									Start: ast.Position{
										Column: 34,
										Line:   67,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   67,
										},
										File:   "geo.flux",
										Source: "string",
										Start: ast.Position{
											Column: 34,
											Line:   67,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   67,
								},
								File:   "geo.flux",
								Source: "?point: {lat: float, lon: float}",
								Start: ast.Position{
									Column: 42,
									Line:   67,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   67,
									},
									File:   "geo.flux",
									Source: "point",
									Start: ast.Position{
										Column: 43,
										Line:   67,
									},
								},
							},
							Name: "point",
						},
						Ty: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 74,
										Line:   67,
									},
									File:   "geo.flux",
									Source: "{lat: float, lon: float}",
									Start: ast.Position{
										Column: 50,
										Line:   67,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 61,
											Line:   67,
										},
										File:   "geo.flux",
										Source: "lat: float",
										Start: ast.Position{
											Column: 51,
											Line:   67,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   67,
											},
											File:   "geo.flux",
											Source: "lat",
											Start: ast.Position{
												Column: 51,
												Line:   67,
											},
										},
									},
									Name: "lat",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 61,
												Line:   67,
											},
											File:   "geo.flux",
											Source: "float",
											Start: ast.Position{
												Column: 56,
												Line:   67,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 61,
													Line:   67,
												},
												File:   "geo.flux",
												Source: "float",
												Start: ast.Position{
													Column: 56,
													Line:   67,
												},
											},
										},
										Name: "float",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 73,
											Line:   67,
										},
										File:   "geo.flux",
										Source: "lon: float",
										Start: ast.Position{
											Column: 63,
											Line:   67,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   67,
											},
											File:   "geo.flux",
											Source: "lon",
											Start: ast.Position{
												Column: 63,
												Line:   67,
											},
										},
									},
									Name: "lon",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 73,
												Line:   67,
											},
											File:   "geo.flux",
											Source: "float",
											Start: ast.Position{
												Column: 68,
												Line:   67,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 73,
													Line:   67,
												},
												File:   "geo.flux",
												Source: "float",
												Start: ast.Position{
													Column: 68,
													Line:   67,
												},
											},
										},
										Name: "float",
									},
								},
							}},
							Tvar: nil,
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   67,
								},
								File:   "geo.flux",
								Source: "level: int",
								Start: ast.Position{
									Column: 76,
									Line:   67,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   67,
									},
									File:   "geo.flux",
									Source: "level",
									Start: ast.Position{
										Column: 76,
										Line:   67,
									},
								},
							},
							Name: "level",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 86,
										Line:   67,
									},
									File:   "geo.flux",
									Source: "int",
									Start: ast.Position{
										Column: 83,
										Line:   67,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 86,
											Line:   67,
										},
										File:   "geo.flux",
										Source: "int",
										Start: ast.Position{
											Column: 83,
											Line:   67,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   67,
								},
								File:   "geo.flux",
								Source: "string",
								Start: ast.Position{
									Column: 91,
									Line:   67,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 97,
										Line:   67,
									},
									File:   "geo.flux",
									Source: "string",
									Start: ast.Position{
										Column: 91,
										Line:   67,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Returns lat/lon coordinates of given cell ID token.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   70,
					},
					File:   "geo.flux",
					Source: "builtin s2CellLatLon",
					Start: ast.Position{
						Column: 1,
						Line:   70,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   70,
						},
						File:   "geo.flux",
						Source: "s2CellLatLon",
						Start: ast.Position{
							Column: 9,
							Line:   70,
						},
					},
				},
				Name: "s2CellLatLon",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 67,
							Line:   70,
						},
						File:   "geo.flux",
						Source: "(token: string) => {lat: float, lon: float}",
						Start: ast.Position{
							Column: 24,
							Line:   70,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 67,
								Line:   70,
							},
							File:   "geo.flux",
							Source: "(token: string) => {lat: float, lon: float}",
							Start: ast.Position{
								Column: 24,
								Line:   70,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   70,
								},
								File:   "geo.flux",
								Source: "token: string",
								Start: ast.Position{
									Column: 25,
									Line:   70,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   70,
									},
									File:   "geo.flux",
									Source: "token",
									Start: ast.Position{
										Column: 25,
										Line:   70,
									},
								},
							},
							Name: "token",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   70,
									},
									File:   "geo.flux",
									Source: "string",
									Start: ast.Position{
										Column: 32,
										Line:   70,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   70,
										},
										File:   "geo.flux",
										Source: "string",
										Start: ast.Position{
											Column: 32,
											Line:   70,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.RecordType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   70,
								},
								File:   "geo.flux",
								Source: "{lat: float, lon: float}",
								Start: ast.Position{
									Column: 43,
									Line:   70,
								},
							},
						},
						Properties: []*ast.PropertyType{&ast.PropertyType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   70,
									},
									File:   "geo.flux",
									Source: "lat: float",
									Start: ast.Position{
										Column: 44,
										Line:   70,
									},
								},
							},
							Name: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   70,
										},
										File:   "geo.flux",
										Source: "lat",
										Start: ast.Position{
											Column: 44,
											Line:   70,
										},
									},
								},
								Name: "lat",
							},
							Ty: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   70,
										},
										File:   "geo.flux",
										Source: "float",
										Start: ast.Position{
											Column: 49,
											Line:   70,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   70,
											},
											File:   "geo.flux",
											Source: "float",
											Start: ast.Position{
												Column: 49,
												Line:   70,
											},
										},
									},
									Name: "float",
								},
							},
						}, &ast.PropertyType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   70,
									},
									File:   "geo.flux",
									Source: "lon: float",
									Start: ast.Position{
										Column: 56,
										Line:   70,
									},
								},
							},
							Name: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   70,
										},
										File:   "geo.flux",
										Source: "lon",
										Start: ast.Position{
											Column: 56,
											Line:   70,
										},
									},
								},
								Name: "lon",
							},
							Ty: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 66,
											Line:   70,
										},
										File:   "geo.flux",
										Source: "float",
										Start: ast.Position{
											Column: 61,
											Line:   70,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   70,
											},
											File:   "geo.flux",
											Source: "float",
											Start: ast.Position{
												Column: 61,
												Line:   70,
											},
										},
									},
									Name: "float",
								},
							},
						}},
						Tvar: nil,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   86,
					},
					File:   "geo.flux",
					Source: "_detectLevel = (tables=<-) => {\n    _r0 = tables\n        |> tableFind(fn: (key) => exists key.s2_cell_id)\n        |> getRecord(idx: 0)\n    _level = if exists _r0 then\n        getLevel(token: _r0.s2_cell_id)\n    else\n        666\n\n    return _level\n}",
					Start: ast.Position{
						Column: 1,
						Line:   76,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Flux functions\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Gets level of cell ID tag `s2cellID` from the first record from the first table in the stream.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   76,
						},
						File:   "geo.flux",
						Source: "_detectLevel",
						Start: ast.Position{
							Column: 1,
							Line:   76,
						},
					},
				},
				Name: "_detectLevel",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   86,
						},
						File:   "geo.flux",
						Source: "(tables=<-) => {\n    _r0 = tables\n        |> tableFind(fn: (key) => exists key.s2_cell_id)\n        |> getRecord(idx: 0)\n    _level = if exists _r0 then\n        getLevel(token: _r0.s2_cell_id)\n    else\n        666\n\n    return _level\n}",
						Start: ast.Position{
							Column: 16,
							Line:   76,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   86,
							},
							File:   "geo.flux",
							Source: "{\n    _r0 = tables\n        |> tableFind(fn: (key) => exists key.s2_cell_id)\n        |> getRecord(idx: 0)\n    _level = if exists _r0 then\n        getLevel(token: _r0.s2_cell_id)\n    else\n        666\n\n    return _level\n}",
							Start: ast.Position{
								Column: 31,
								Line:   76,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   79,
								},
								File:   "geo.flux",
								Source: "_r0 = tables\n        |> tableFind(fn: (key) => exists key.s2_cell_id)\n        |> getRecord(idx: 0)",
								Start: ast.Position{
									Column: 5,
									Line:   77,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   77,
									},
									File:   "geo.flux",
									Source: "_r0",
									Start: ast.Position{
										Column: 5,
										Line:   77,
									},
								},
							},
							Name: "_r0",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   77,
											},
											File:   "geo.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 11,
												Line:   77,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   78,
										},
										File:   "geo.flux",
										Source: "tables\n        |> tableFind(fn: (key) => exists key.s2_cell_id)",
										Start: ast.Position{
											Column: 11,
											Line:   77,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 56,
													Line:   78,
												},
												File:   "geo.flux",
												Source: "fn: (key) => exists key.s2_cell_id",
												Start: ast.Position{
													Column: 22,
													Line:   78,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 56,
														Line:   78,
													},
													File:   "geo.flux",
													Source: "fn: (key) => exists key.s2_cell_id",
													Start: ast.Position{
														Column: 22,
														Line:   78,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   78,
														},
														File:   "geo.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 22,
															Line:   78,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   78,
														},
														File:   "geo.flux",
														Source: "(key) => exists key.s2_cell_id",
														Start: ast.Position{
															Column: 26,
															Line:   78,
														},
													},
												},
												Body: &ast.UnaryExpression{
													Argument: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 56,
																	Line:   78,
																},
																File:   "geo.flux",
																Source: "key.s2_cell_id",
																Start: ast.Position{
																	Column: 42,
																	Line:   78,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 45,
																		Line:   78,
																	},
																	File:   "geo.flux",
																	Source: "key",
																	Start: ast.Position{
																		Column: 42,
																		Line:   78,
																	},
																},
															},
															Name: "key",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 56,
																		Line:   78,
																	},
																	File:   "geo.flux",
																	Source: "s2_cell_id",
																	Start: ast.Position{
																		Column: 46,
																		Line:   78,
																	},
																},
															},
															Name: "s2_cell_id",
														},
														Rbrack: nil,
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   78,
															},
															File:   "geo.flux",
															Source: "exists key.s2_cell_id",
															Start: ast.Position{
																Column: 35,
																Line:   78,
															},
														},
													},
													Operator: 14,
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   78,
															},
															File:   "geo.flux",
															Source: "key",
															Start: ast.Position{
																Column: 27,
																Line:   78,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   78,
																},
																File:   "geo.flux",
																Source: "key",
																Start: ast.Position{
																	Column: 27,
																	Line:   78,
																},
															},
														},
														Name: "key",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   78,
											},
											File:   "geo.flux",
											Source: "tableFind(fn: (key) => exists key.s2_cell_id)",
											Start: ast.Position{
												Column: 12,
												Line:   78,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   78,
												},
												File:   "geo.flux",
												Source: "tableFind",
												Start: ast.Position{
													Column: 12,
													Line:   78,
												},
											},
										},
										Name: "tableFind",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   79,
									},
									File:   "geo.flux",
									Source: "tables\n        |> tableFind(fn: (key) => exists key.s2_cell_id)\n        |> getRecord(idx: 0)",
									Start: ast.Position{
										Column: 11,
										Line:   77,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   79,
											},
											File:   "geo.flux",
											Source: "idx: 0",
											Start: ast.Position{
												Column: 22,
												Line:   79,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   79,
												},
												File:   "geo.flux",
												Source: "idx: 0",
												Start: ast.Position{
													Column: 22,
													Line:   79,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   79,
													},
													File:   "geo.flux",
													Source: "idx",
													Start: ast.Position{
														Column: 22,
														Line:   79,
													},
												},
											},
											Name: "idx",
										},
										Separator: nil,
										Value: &ast.IntegerLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   79,
													},
													File:   "geo.flux",
													Source: "0",
													Start: ast.Position{
														Column: 27,
														Line:   79,
													},
												},
											},
											Value: int64(0),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   79,
										},
										File:   "geo.flux",
										Source: "getRecord(idx: 0)",
										Start: ast.Position{
											Column: 12,
											Line:   79,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   79,
											},
											File:   "geo.flux",
											Source: "getRecord",
											Start: ast.Position{
												Column: 12,
												Line:   79,
											},
										},
									},
									Name: "getRecord",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   83,
								},
								File:   "geo.flux",
								Source: "_level = if exists _r0 then\n        getLevel(token: _r0.s2_cell_id)\n    else\n        666",
								Start: ast.Position{
									Column: 5,
									Line:   80,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   80,
									},
									File:   "geo.flux",
									Source: "_level",
									Start: ast.Position{
										Column: 5,
										Line:   80,
									},
								},
							},
							Name: "_level",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.IntegerLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   83,
										},
										File:   "geo.flux",
										Source: "666",
										Start: ast.Position{
											Column: 9,
											Line:   83,
										},
									},
								},
								Value: int64(666),
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   83,
									},
									File:   "geo.flux",
									Source: "if exists _r0 then\n        getLevel(token: _r0.s2_cell_id)\n    else\n        666",
									Start: ast.Position{
										Column: 14,
										Line:   80,
									},
								},
							},
							Consequent: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   81,
											},
											File:   "geo.flux",
											Source: "token: _r0.s2_cell_id",
											Start: ast.Position{
												Column: 18,
												Line:   81,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   81,
												},
												File:   "geo.flux",
												Source: "token: _r0.s2_cell_id",
												Start: ast.Position{
													Column: 18,
													Line:   81,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   81,
													},
													File:   "geo.flux",
													Source: "token",
													Start: ast.Position{
														Column: 18,
														Line:   81,
													},
												},
											},
											Name: "token",
										},
										Separator: nil,
										Value: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   81,
													},
													File:   "geo.flux",
													Source: "_r0.s2_cell_id",
													Start: ast.Position{
														Column: 25,
														Line:   81,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   81,
														},
														File:   "geo.flux",
														Source: "_r0",
														Start: ast.Position{
															Column: 25,
															Line:   81,
														},
													},
												},
												Name: "_r0",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   81,
														},
														File:   "geo.flux",
														Source: "s2_cell_id",
														Start: ast.Position{
															Column: 29,
															Line:   81,
														},
													},
												},
												Name: "s2_cell_id",
											},
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   81,
										},
										File:   "geo.flux",
										Source: "getLevel(token: _r0.s2_cell_id)",
										Start: ast.Position{
											Column: 9,
											Line:   81,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   81,
											},
											File:   "geo.flux",
											Source: "getLevel",
											Start: ast.Position{
												Column: 9,
												Line:   81,
											},
										},
									},
									Name: "getLevel",
								},
								Lparen: nil,
								Rparen: nil,
							},
							Test: &ast.UnaryExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   80,
											},
											File:   "geo.flux",
											Source: "_r0",
											Start: ast.Position{
												Column: 24,
												Line:   80,
											},
										},
									},
									Name: "_r0",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   80,
										},
										File:   "geo.flux",
										Source: "exists _r0",
										Start: ast.Position{
											Column: 17,
											Line:   80,
										},
									},
								},
								Operator: 14,
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   85,
									},
									File:   "geo.flux",
									Source: "_level",
									Start: ast.Position{
										Column: 12,
										Line:   85,
									},
								},
							},
							Name: "_level",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   85,
								},
								File:   "geo.flux",
								Source: "return _level",
								Start: ast.Position{
									Column: 5,
									Line:   85,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   76,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 17,
								Line:   76,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   76,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 17,
									Line:   76,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   76,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   76,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   93,
					},
					File:   "geo.flux",
					Source: "toRows = (tables=<-) => tables\n    |> v1.fieldsAsCols()",
					Start: ast.Position{
						Column: 1,
						Line:   92,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Convenience functions\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Pivots values to row-wise sets.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   92,
						},
						File:   "geo.flux",
						Source: "toRows",
						Start: ast.Position{
							Column: 1,
							Line:   92,
						},
					},
				},
				Name: "toRows",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   93,
						},
						File:   "geo.flux",
						Source: "(tables=<-) => tables\n    |> v1.fieldsAsCols()",
						Start: ast.Position{
							Column: 10,
							Line:   92,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   92,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 25,
									Line:   92,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   93,
							},
							File:   "geo.flux",
							Source: "tables\n    |> v1.fieldsAsCols()",
							Start: ast.Position{
								Column: 25,
								Line:   92,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   93,
								},
								File:   "geo.flux",
								Source: "v1.fieldsAsCols()",
								Start: ast.Position{
									Column: 8,
									Line:   93,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   93,
									},
									File:   "geo.flux",
									Source: "v1.fieldsAsCols",
									Start: ast.Position{
										Column: 8,
										Line:   93,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   93,
										},
										File:   "geo.flux",
										Source: "v1",
										Start: ast.Position{
											Column: 8,
											Line:   93,
										},
									},
								},
								Name: "v1",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   93,
										},
										File:   "geo.flux",
										Source: "fieldsAsCols",
										Start: ast.Position{
											Column: 11,
											Line:   93,
										},
									},
								},
								Name: "fieldsAsCols",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   92,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 11,
								Line:   92,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   92,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 11,
									Line:   92,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   92,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 18,
								Line:   92,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   120,
					},
					File:   "geo.flux",
					Source: "shapeData = (tables=<-, latField, lonField, level) => tables\n    |> map(\n        fn: (r) => ({r with\n            _field: if r._field == latField then\n                \"lat\"\n            else if r._field == lonField then\n                \"lon\"\n            else\n                r._field,\n        }),\n    )\n    |> toRows()\n    |> map(\n        fn: (r) => ({r with\n            s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n        }),\n    )\n    |> experimental.group(\n        columns: [\"s2_cell_id\"],\n        mode: \"extend\",\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   100,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Shapes data to meet the requirements of the geo package.\n"}, ast.Comment{Text: "// Renames fields containing latitude and longitude values to lat and lon.\n"}, ast.Comment{Text: "// Pivots values to row-wise sets.\n"}, ast.Comment{Text: "// Generates an s2_cell_id tag for each reach using lat and lon values.\n"}, ast.Comment{Text: "// Adds the s2_cell_id column to the group key.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   100,
						},
						File:   "geo.flux",
						Source: "shapeData",
						Start: ast.Position{
							Column: 1,
							Line:   100,
						},
					},
				},
				Name: "shapeData",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   120,
						},
						File:   "geo.flux",
						Source: "(tables=<-, latField, lonField, level) => tables\n    |> map(\n        fn: (r) => ({r with\n            _field: if r._field == latField then\n                \"lat\"\n            else if r._field == lonField then\n                \"lon\"\n            else\n                r._field,\n        }),\n    )\n    |> toRows()\n    |> map(\n        fn: (r) => ({r with\n            s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n        }),\n    )\n    |> experimental.group(\n        columns: [\"s2_cell_id\"],\n        mode: \"extend\",\n    )",
						Start: ast.Position{
							Column: 13,
							Line:   100,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 61,
												Line:   100,
											},
											File:   "geo.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 55,
												Line:   100,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   110,
										},
										File:   "geo.flux",
										Source: "tables\n    |> map(\n        fn: (r) => ({r with\n            _field: if r._field == latField then\n                \"lat\"\n            else if r._field == lonField then\n                \"lon\"\n            else\n                r._field,\n        }),\n    )",
										Start: ast.Position{
											Column: 55,
											Line:   100,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   109,
												},
												File:   "geo.flux",
												Source: "fn: (r) => ({r with\n            _field: if r._field == latField then\n                \"lat\"\n            else if r._field == lonField then\n                \"lon\"\n            else\n                r._field,\n        })",
												Start: ast.Position{
													Column: 9,
													Line:   102,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   109,
													},
													File:   "geo.flux",
													Source: "fn: (r) => ({r with\n            _field: if r._field == latField then\n                \"lat\"\n            else if r._field == lonField then\n                \"lon\"\n            else\n                r._field,\n        })",
													Start: ast.Position{
														Column: 9,
														Line:   102,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   102,
														},
														File:   "geo.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 9,
															Line:   102,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   109,
														},
														File:   "geo.flux",
														Source: "(r) => ({r with\n            _field: if r._field == latField then\n                \"lat\"\n            else if r._field == lonField then\n                \"lon\"\n            else\n                r._field,\n        })",
														Start: ast.Position{
															Column: 13,
															Line:   102,
														},
													},
												},
												Body: &ast.ParenExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 11,
																Line:   109,
															},
															File:   "geo.flux",
															Source: "({r with\n            _field: if r._field == latField then\n                \"lat\"\n            else if r._field == lonField then\n                \"lon\"\n            else\n                r._field,\n        })",
															Start: ast.Position{
																Column: 20,
																Line:   102,
															},
														},
													},
													Expression: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 10,
																	Line:   109,
																},
																File:   "geo.flux",
																Source: "{r with\n            _field: if r._field == latField then\n                \"lat\"\n            else if r._field == lonField then\n                \"lon\"\n            else\n                r._field,\n        }",
																Start: ast.Position{
																	Column: 21,
																	Line:   102,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   108,
																	},
																	File:   "geo.flux",
																	Source: "_field: if r._field == latField then\n                \"lat\"\n            else if r._field == lonField then\n                \"lon\"\n            else\n                r._field",
																	Start: ast.Position{
																		Column: 13,
																		Line:   103,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 19,
																			Line:   103,
																		},
																		File:   "geo.flux",
																		Source: "_field",
																		Start: ast.Position{
																			Column: 13,
																			Line:   103,
																		},
																	},
																},
																Name: "_field",
															},
															Separator: nil,
															Value: &ast.ConditionalExpression{
																Alternate: &ast.ConditionalExpression{
																	Alternate: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 25,
																					Line:   108,
																				},
																				File:   "geo.flux",
																				Source: "r._field",
																				Start: ast.Position{
																					Column: 17,
																					Line:   108,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 18,
																						Line:   108,
																					},
																					File:   "geo.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 17,
																						Line:   108,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 25,
																						Line:   108,
																					},
																					File:   "geo.flux",
																					Source: "_field",
																					Start: ast.Position{
																						Column: 19,
																						Line:   108,
																					},
																				},
																			},
																			Name: "_field",
																		},
																		Rbrack: nil,
																	},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 25,
																				Line:   108,
																			},
																			File:   "geo.flux",
																			Source: "if r._field == lonField then\n                \"lon\"\n            else\n                r._field",
																			Start: ast.Position{
																				Column: 18,
																				Line:   105,
																			},
																		},
																	},
																	Consequent: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 22,
																					Line:   106,
																				},
																				File:   "geo.flux",
																				Source: "\"lon\"",
																				Start: ast.Position{
																					Column: 17,
																					Line:   106,
																				},
																			},
																		},
																		Value: "lon",
																	},
																	Test: &ast.BinaryExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 41,
																					Line:   105,
																				},
																				File:   "geo.flux",
																				Source: "r._field == lonField",
																				Start: ast.Position{
																					Column: 21,
																					Line:   105,
																				},
																			},
																		},
																		Left: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 29,
																						Line:   105,
																					},
																					File:   "geo.flux",
																					Source: "r._field",
																					Start: ast.Position{
																						Column: 21,
																						Line:   105,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 22,
																							Line:   105,
																						},
																						File:   "geo.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 21,
																							Line:   105,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 29,
																							Line:   105,
																						},
																						File:   "geo.flux",
																						Source: "_field",
																						Start: ast.Position{
																							Column: 23,
																							Line:   105,
																						},
																					},
																				},
																				Name: "_field",
																			},
																			Rbrack: nil,
																		},
																		Operator: 17,
																		Right: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 41,
																						Line:   105,
																					},
																					File:   "geo.flux",
																					Source: "lonField",
																					Start: ast.Position{
																						Column: 33,
																						Line:   105,
																					},
																				},
																			},
																			Name: "lonField",
																		},
																	},
																	Tk_else: nil,
																	Tk_if:   nil,
																	Tk_then: nil,
																},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   108,
																		},
																		File:   "geo.flux",
																		Source: "if r._field == latField then\n                \"lat\"\n            else if r._field == lonField then\n                \"lon\"\n            else\n                r._field",
																		Start: ast.Position{
																			Column: 21,
																			Line:   103,
																		},
																	},
																},
																Consequent: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 22,
																				Line:   104,
																			},
																			File:   "geo.flux",
																			Source: "\"lat\"",
																			Start: ast.Position{
																				Column: 17,
																				Line:   104,
																			},
																		},
																	},
																	Value: "lat",
																},
																Test: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 44,
																				Line:   103,
																			},
																			File:   "geo.flux",
																			Source: "r._field == latField",
																			Start: ast.Position{
																				Column: 24,
																				Line:   103,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 32,
																					Line:   103,
																				},
																				File:   "geo.flux",
																				Source: "r._field",
																				Start: ast.Position{
																					Column: 24,
																					Line:   103,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 25,
																						Line:   103,
																					},
																					File:   "geo.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 24,
																						Line:   103,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 32,
																						Line:   103,
																					},
																					File:   "geo.flux",
																					Source: "_field",
																					Start: ast.Position{
																						Column: 26,
																						Line:   103,
																					},
																				},
																			},
																			Name: "_field",
																		},
																		Rbrack: nil,
																	},
																	Operator: 17,
																	Right: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 44,
																					Line:   103,
																				},
																				File:   "geo.flux",
																				Source: "latField",
																				Start: ast.Position{
																					Column: 36,
																					Line:   103,
																				},
																			},
																		},
																		Name: "latField",
																	},
																},
																Tk_else: nil,
																Tk_if:   nil,
																Tk_then: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 23,
																		Line:   102,
																	},
																	File:   "geo.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 22,
																		Line:   102,
																	},
																},
															},
															Name: "r",
														},
													},
													Lparen: nil,
													Rparen: nil,
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   102,
															},
															File:   "geo.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   102,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 15,
																	Line:   102,
																},
																File:   "geo.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 14,
																	Line:   102,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   110,
											},
											File:   "geo.flux",
											Source: "map(\n        fn: (r) => ({r with\n            _field: if r._field == latField then\n                \"lat\"\n            else if r._field == lonField then\n                \"lon\"\n            else\n                r._field,\n        }),\n    )",
											Start: ast.Position{
												Column: 8,
												Line:   101,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   101,
												},
												File:   "geo.flux",
												Source: "map",
												Start: ast.Position{
													Column: 8,
													Line:   101,
												},
											},
										},
										Name: "map",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   111,
									},
									File:   "geo.flux",
									Source: "tables\n    |> map(\n        fn: (r) => ({r with\n            _field: if r._field == latField then\n                \"lat\"\n            else if r._field == lonField then\n                \"lon\"\n            else\n                r._field,\n        }),\n    )\n    |> toRows()",
									Start: ast.Position{
										Column: 55,
										Line:   100,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   111,
										},
										File:   "geo.flux",
										Source: "toRows()",
										Start: ast.Position{
											Column: 8,
											Line:   111,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   111,
											},
											File:   "geo.flux",
											Source: "toRows",
											Start: ast.Position{
												Column: 8,
												Line:   111,
											},
										},
									},
									Name: "toRows",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   116,
								},
								File:   "geo.flux",
								Source: "tables\n    |> map(\n        fn: (r) => ({r with\n            _field: if r._field == latField then\n                \"lat\"\n            else if r._field == lonField then\n                \"lon\"\n            else\n                r._field,\n        }),\n    )\n    |> toRows()\n    |> map(\n        fn: (r) => ({r with\n            s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n        }),\n    )",
								Start: ast.Position{
									Column: 55,
									Line:   100,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   115,
										},
										File:   "geo.flux",
										Source: "fn: (r) => ({r with\n            s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n        })",
										Start: ast.Position{
											Column: 9,
											Line:   113,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   115,
											},
											File:   "geo.flux",
											Source: "fn: (r) => ({r with\n            s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n        })",
											Start: ast.Position{
												Column: 9,
												Line:   113,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   113,
												},
												File:   "geo.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 9,
													Line:   113,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   115,
												},
												File:   "geo.flux",
												Source: "(r) => ({r with\n            s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n        })",
												Start: ast.Position{
													Column: 13,
													Line:   113,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   115,
													},
													File:   "geo.flux",
													Source: "({r with\n            s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n        })",
													Start: ast.Position{
														Column: 20,
														Line:   113,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   115,
														},
														File:   "geo.flux",
														Source: "{r with\n            s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n        }",
														Start: ast.Position{
															Column: 21,
															Line:   113,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 85,
																Line:   114,
															},
															File:   "geo.flux",
															Source: "s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)",
															Start: ast.Position{
																Column: 13,
																Line:   114,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   114,
																},
																File:   "geo.flux",
																Source: "s2_cell_id",
																Start: ast.Position{
																	Column: 13,
																	Line:   114,
																},
															},
														},
														Name: "s2_cell_id",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 84,
																		Line:   114,
																	},
																	File:   "geo.flux",
																	Source: "point: {lat: r.lat, lon: r.lon}, level: level",
																	Start: ast.Position{
																		Column: 39,
																		Line:   114,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 70,
																			Line:   114,
																		},
																		File:   "geo.flux",
																		Source: "point: {lat: r.lat, lon: r.lon}",
																		Start: ast.Position{
																			Column: 39,
																			Line:   114,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 44,
																				Line:   114,
																			},
																			File:   "geo.flux",
																			Source: "point",
																			Start: ast.Position{
																				Column: 39,
																				Line:   114,
																			},
																		},
																	},
																	Name: "point",
																},
																Separator: nil,
																Value: &ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 70,
																				Line:   114,
																			},
																			File:   "geo.flux",
																			Source: "{lat: r.lat, lon: r.lon}",
																			Start: ast.Position{
																				Column: 46,
																				Line:   114,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 57,
																					Line:   114,
																				},
																				File:   "geo.flux",
																				Source: "lat: r.lat",
																				Start: ast.Position{
																					Column: 47,
																					Line:   114,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 50,
																						Line:   114,
																					},
																					File:   "geo.flux",
																					Source: "lat",
																					Start: ast.Position{
																						Column: 47,
																						Line:   114,
																					},
																				},
																			},
																			Name: "lat",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 57,
																						Line:   114,
																					},
																					File:   "geo.flux",
																					Source: "r.lat",
																					Start: ast.Position{
																						Column: 52,
																						Line:   114,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 53,
																							Line:   114,
																						},
																						File:   "geo.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 52,
																							Line:   114,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 57,
																							Line:   114,
																						},
																						File:   "geo.flux",
																						Source: "lat",
																						Start: ast.Position{
																							Column: 54,
																							Line:   114,
																						},
																					},
																				},
																				Name: "lat",
																			},
																			Rbrack: nil,
																		},
																	}, &ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 69,
																					Line:   114,
																				},
																				File:   "geo.flux",
																				Source: "lon: r.lon",
																				Start: ast.Position{
																					Column: 59,
																					Line:   114,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 62,
																						Line:   114,
																					},
																					File:   "geo.flux",
																					Source: "lon",
																					Start: ast.Position{
																						Column: 59,
																						Line:   114,
																					},
																				},
																			},
																			Name: "lon",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 69,
																						Line:   114,
																					},
																					File:   "geo.flux",
																					Source: "r.lon",
																					Start: ast.Position{
																						Column: 64,
																						Line:   114,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 65,
																							Line:   114,
																						},
																						File:   "geo.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 64,
																							Line:   114,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 69,
																							Line:   114,
																						},
																						File:   "geo.flux",
																						Source: "lon",
																						Start: ast.Position{
																							Column: 66,
																							Line:   114,
																						},
																					},
																				},
																				Name: "lon",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 84,
																			Line:   114,
																		},
																		File:   "geo.flux",
																		Source: "level: level",
																		Start: ast.Position{
																			Column: 72,
																			Line:   114,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 77,
																				Line:   114,
																			},
																			File:   "geo.flux",
																			Source: "level",
																			Start: ast.Position{
																				Column: 72,
																				Line:   114,
																			},
																		},
																	},
																	Name: "level",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 84,
																				Line:   114,
																			},
																			File:   "geo.flux",
																			Source: "level",
																			Start: ast.Position{
																				Column: 79,
																				Line:   114,
																			},
																		},
																	},
																	Name: "level",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 85,
																	Line:   114,
																},
																File:   "geo.flux",
																Source: "s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)",
																Start: ast.Position{
																	Column: 25,
																	Line:   114,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   114,
																	},
																	File:   "geo.flux",
																	Source: "s2CellIDToken",
																	Start: ast.Position{
																		Column: 25,
																		Line:   114,
																	},
																},
															},
															Name: "s2CellIDToken",
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 23,
																Line:   113,
															},
															File:   "geo.flux",
															Source: "r",
															Start: ast.Position{
																Column: 22,
																Line:   113,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   113,
													},
													File:   "geo.flux",
													Source: "r",
													Start: ast.Position{
														Column: 14,
														Line:   113,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   113,
														},
														File:   "geo.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   113,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   116,
									},
									File:   "geo.flux",
									Source: "map(\n        fn: (r) => ({r with\n            s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n        }),\n    )",
									Start: ast.Position{
										Column: 8,
										Line:   112,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   112,
										},
										File:   "geo.flux",
										Source: "map",
										Start: ast.Position{
											Column: 8,
											Line:   112,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   120,
							},
							File:   "geo.flux",
							Source: "tables\n    |> map(\n        fn: (r) => ({r with\n            _field: if r._field == latField then\n                \"lat\"\n            else if r._field == lonField then\n                \"lon\"\n            else\n                r._field,\n        }),\n    )\n    |> toRows()\n    |> map(\n        fn: (r) => ({r with\n            s2_cell_id: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n        }),\n    )\n    |> experimental.group(\n        columns: [\"s2_cell_id\"],\n        mode: \"extend\",\n    )",
							Start: ast.Position{
								Column: 55,
								Line:   100,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   119,
									},
									File:   "geo.flux",
									Source: "columns: [\"s2_cell_id\"],\n        mode: \"extend\"",
									Start: ast.Position{
										Column: 9,
										Line:   118,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   118,
										},
										File:   "geo.flux",
										Source: "columns: [\"s2_cell_id\"]",
										Start: ast.Position{
											Column: 9,
											Line:   118,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   118,
											},
											File:   "geo.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 9,
												Line:   118,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   118,
											},
											File:   "geo.flux",
											Source: "[\"s2_cell_id\"]",
											Start: ast.Position{
												Column: 18,
												Line:   118,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   118,
												},
												File:   "geo.flux",
												Source: "\"s2_cell_id\"",
												Start: ast.Position{
													Column: 19,
													Line:   118,
												},
											},
										},
										Value: "s2_cell_id",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   119,
										},
										File:   "geo.flux",
										Source: "mode: \"extend\"",
										Start: ast.Position{
											Column: 9,
											Line:   119,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   119,
											},
											File:   "geo.flux",
											Source: "mode",
											Start: ast.Position{
												Column: 9,
												Line:   119,
											},
										},
									},
									Name: "mode",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   119,
											},
											File:   "geo.flux",
											Source: "\"extend\"",
											Start: ast.Position{
												Column: 15,
												Line:   119,
											},
										},
									},
									Value: "extend",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   120,
								},
								File:   "geo.flux",
								Source: "experimental.group(\n        columns: [\"s2_cell_id\"],\n        mode: \"extend\",\n    )",
								Start: ast.Position{
									Column: 8,
									Line:   117,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   117,
									},
									File:   "geo.flux",
									Source: "experimental.group",
									Start: ast.Position{
										Column: 8,
										Line:   117,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   117,
										},
										File:   "geo.flux",
										Source: "experimental",
										Start: ast.Position{
											Column: 8,
											Line:   117,
										},
									},
								},
								Name: "experimental",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   117,
										},
										File:   "geo.flux",
										Source: "group",
										Start: ast.Position{
											Column: 21,
											Line:   117,
										},
									},
								},
								Name: "group",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   100,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 14,
								Line:   100,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   100,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 14,
									Line:   100,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   100,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 21,
								Line:   100,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   100,
							},
							File:   "geo.flux",
							Source: "latField",
							Start: ast.Position{
								Column: 25,
								Line:   100,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   100,
								},
								File:   "geo.flux",
								Source: "latField",
								Start: ast.Position{
									Column: 25,
									Line:   100,
								},
							},
						},
						Name: "latField",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   100,
							},
							File:   "geo.flux",
							Source: "lonField",
							Start: ast.Position{
								Column: 35,
								Line:   100,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   100,
								},
								File:   "geo.flux",
								Source: "lonField",
								Start: ast.Position{
									Column: 35,
									Line:   100,
								},
							},
						},
						Name: "lonField",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   100,
							},
							File:   "geo.flux",
							Source: "level",
							Start: ast.Position{
								Column: 45,
								Line:   100,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   100,
								},
								File:   "geo.flux",
								Source: "level",
								Start: ast.Position{
									Column: 45,
									Line:   100,
								},
							},
						},
						Name: "level",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   158,
					},
					File:   "geo.flux",
					Source: "gridFilter = (\n        tables=<-,\n        region,\n        minSize=24,\n        maxSize=-1,\n        level=-1,\n        s2cellIDLevel=-1,\n        units=units,\n) => {\n    _s2cellIDLevel = if s2cellIDLevel == -1 then\n        tables\n            |> _detectLevel()\n    else\n        s2cellIDLevel\n    _grid = getGrid(\n        region: region,\n        minSize: minSize,\n        maxSize: maxSize,\n        level: level,\n        maxLevel: _s2cellIDLevel,\n        units: units,\n    )\n\n    return tables\n        |> filter(\n            fn: (r) => if _grid.level == _s2cellIDLevel then\n                contains(value: r.s2_cell_id, set: _grid.set)\n            else\n                contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set),\n        )\n}",
					Start: ast.Position{
						Column: 1,
						Line:   128,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Filtering functions\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Filters records by a box, a circle or a polygon area using S2 cell ID tag.\n"}, ast.Comment{Text: "// It is a coarse filter, as the grid always overlays the region, the result will likely contain records\n"}, ast.Comment{Text: "// with lat/lon outside the specified region.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   128,
						},
						File:   "geo.flux",
						Source: "gridFilter",
						Start: ast.Position{
							Column: 1,
							Line:   128,
						},
					},
				},
				Name: "gridFilter",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   158,
						},
						File:   "geo.flux",
						Source: "(\n        tables=<-,\n        region,\n        minSize=24,\n        maxSize=-1,\n        level=-1,\n        s2cellIDLevel=-1,\n        units=units,\n) => {\n    _s2cellIDLevel = if s2cellIDLevel == -1 then\n        tables\n            |> _detectLevel()\n    else\n        s2cellIDLevel\n    _grid = getGrid(\n        region: region,\n        minSize: minSize,\n        maxSize: maxSize,\n        level: level,\n        maxLevel: _s2cellIDLevel,\n        units: units,\n    )\n\n    return tables\n        |> filter(\n            fn: (r) => if _grid.level == _s2cellIDLevel then\n                contains(value: r.s2_cell_id, set: _grid.set)\n            else\n                contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set),\n        )\n}",
						Start: ast.Position{
							Column: 14,
							Line:   128,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   158,
							},
							File:   "geo.flux",
							Source: "{\n    _s2cellIDLevel = if s2cellIDLevel == -1 then\n        tables\n            |> _detectLevel()\n    else\n        s2cellIDLevel\n    _grid = getGrid(\n        region: region,\n        minSize: minSize,\n        maxSize: maxSize,\n        level: level,\n        maxLevel: _s2cellIDLevel,\n        units: units,\n    )\n\n    return tables\n        |> filter(\n            fn: (r) => if _grid.level == _s2cellIDLevel then\n                contains(value: r.s2_cell_id, set: _grid.set)\n            else\n                contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set),\n        )\n}",
							Start: ast.Position{
								Column: 6,
								Line:   136,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   141,
								},
								File:   "geo.flux",
								Source: "_s2cellIDLevel = if s2cellIDLevel == -1 then\n        tables\n            |> _detectLevel()\n    else\n        s2cellIDLevel",
								Start: ast.Position{
									Column: 5,
									Line:   137,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   137,
									},
									File:   "geo.flux",
									Source: "_s2cellIDLevel",
									Start: ast.Position{
										Column: 5,
										Line:   137,
									},
								},
							},
							Name: "_s2cellIDLevel",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   141,
										},
										File:   "geo.flux",
										Source: "s2cellIDLevel",
										Start: ast.Position{
											Column: 9,
											Line:   141,
										},
									},
								},
								Name: "s2cellIDLevel",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   141,
									},
									File:   "geo.flux",
									Source: "if s2cellIDLevel == -1 then\n        tables\n            |> _detectLevel()\n    else\n        s2cellIDLevel",
									Start: ast.Position{
										Column: 22,
										Line:   137,
									},
								},
							},
							Consequent: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   138,
											},
											File:   "geo.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 9,
												Line:   138,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   139,
										},
										File:   "geo.flux",
										Source: "tables\n            |> _detectLevel()",
										Start: ast.Position{
											Column: 9,
											Line:   138,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   139,
											},
											File:   "geo.flux",
											Source: "_detectLevel()",
											Start: ast.Position{
												Column: 16,
												Line:   139,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   139,
												},
												File:   "geo.flux",
												Source: "_detectLevel",
												Start: ast.Position{
													Column: 16,
													Line:   139,
												},
											},
										},
										Name: "_detectLevel",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   137,
										},
										File:   "geo.flux",
										Source: "s2cellIDLevel == -1",
										Start: ast.Position{
											Column: 25,
											Line:   137,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   137,
											},
											File:   "geo.flux",
											Source: "s2cellIDLevel",
											Start: ast.Position{
												Column: 25,
												Line:   137,
											},
										},
									},
									Name: "s2cellIDLevel",
								},
								Operator: 17,
								Right: &ast.UnaryExpression{
									Argument: &ast.IntegerLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   137,
												},
												File:   "geo.flux",
												Source: "1",
												Start: ast.Position{
													Column: 43,
													Line:   137,
												},
											},
										},
										Value: int64(1),
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   137,
											},
											File:   "geo.flux",
											Source: "-1",
											Start: ast.Position{
												Column: 42,
												Line:   137,
											},
										},
									},
									Operator: 6,
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   149,
								},
								File:   "geo.flux",
								Source: "_grid = getGrid(\n        region: region,\n        minSize: minSize,\n        maxSize: maxSize,\n        level: level,\n        maxLevel: _s2cellIDLevel,\n        units: units,\n    )",
								Start: ast.Position{
									Column: 5,
									Line:   142,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   142,
									},
									File:   "geo.flux",
									Source: "_grid",
									Start: ast.Position{
										Column: 5,
										Line:   142,
									},
								},
							},
							Name: "_grid",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   148,
										},
										File:   "geo.flux",
										Source: "region: region,\n        minSize: minSize,\n        maxSize: maxSize,\n        level: level,\n        maxLevel: _s2cellIDLevel,\n        units: units",
										Start: ast.Position{
											Column: 9,
											Line:   143,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   143,
											},
											File:   "geo.flux",
											Source: "region: region",
											Start: ast.Position{
												Column: 9,
												Line:   143,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   143,
												},
												File:   "geo.flux",
												Source: "region",
												Start: ast.Position{
													Column: 9,
													Line:   143,
												},
											},
										},
										Name: "region",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   143,
												},
												File:   "geo.flux",
												Source: "region",
												Start: ast.Position{
													Column: 17,
													Line:   143,
												},
											},
										},
										Name: "region",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   144,
											},
											File:   "geo.flux",
											Source: "minSize: minSize",
											Start: ast.Position{
												Column: 9,
												Line:   144,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   144,
												},
												File:   "geo.flux",
												Source: "minSize",
												Start: ast.Position{
													Column: 9,
													Line:   144,
												},
											},
										},
										Name: "minSize",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   144,
												},
												File:   "geo.flux",
												Source: "minSize",
												Start: ast.Position{
													Column: 18,
													Line:   144,
												},
											},
										},
										Name: "minSize",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   145,
											},
											File:   "geo.flux",
											Source: "maxSize: maxSize",
											Start: ast.Position{
												Column: 9,
												Line:   145,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   145,
												},
												File:   "geo.flux",
												Source: "maxSize",
												Start: ast.Position{
													Column: 9,
													Line:   145,
												},
											},
										},
										Name: "maxSize",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   145,
												},
												File:   "geo.flux",
												Source: "maxSize",
												Start: ast.Position{
													Column: 18,
													Line:   145,
												},
											},
										},
										Name: "maxSize",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   146,
											},
											File:   "geo.flux",
											Source: "level: level",
											Start: ast.Position{
												Column: 9,
												Line:   146,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   146,
												},
												File:   "geo.flux",
												Source: "level",
												Start: ast.Position{
													Column: 9,
													Line:   146,
												},
											},
										},
										Name: "level",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   146,
												},
												File:   "geo.flux",
												Source: "level",
												Start: ast.Position{
													Column: 16,
													Line:   146,
												},
											},
										},
										Name: "level",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   147,
											},
											File:   "geo.flux",
											Source: "maxLevel: _s2cellIDLevel",
											Start: ast.Position{
												Column: 9,
												Line:   147,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   147,
												},
												File:   "geo.flux",
												Source: "maxLevel",
												Start: ast.Position{
													Column: 9,
													Line:   147,
												},
											},
										},
										Name: "maxLevel",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   147,
												},
												File:   "geo.flux",
												Source: "_s2cellIDLevel",
												Start: ast.Position{
													Column: 19,
													Line:   147,
												},
											},
										},
										Name: "_s2cellIDLevel",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   148,
											},
											File:   "geo.flux",
											Source: "units: units",
											Start: ast.Position{
												Column: 9,
												Line:   148,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   148,
												},
												File:   "geo.flux",
												Source: "units",
												Start: ast.Position{
													Column: 9,
													Line:   148,
												},
											},
										},
										Name: "units",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   148,
												},
												File:   "geo.flux",
												Source: "units",
												Start: ast.Position{
													Column: 16,
													Line:   148,
												},
											},
										},
										Name: "units",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   149,
									},
									File:   "geo.flux",
									Source: "getGrid(\n        region: region,\n        minSize: minSize,\n        maxSize: maxSize,\n        level: level,\n        maxLevel: _s2cellIDLevel,\n        units: units,\n    )",
									Start: ast.Position{
										Column: 13,
										Line:   142,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   142,
										},
										File:   "geo.flux",
										Source: "getGrid",
										Start: ast.Position{
											Column: 13,
											Line:   142,
										},
									},
								},
								Name: "getGrid",
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   151,
										},
										File:   "geo.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 12,
											Line:   151,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   157,
									},
									File:   "geo.flux",
									Source: "tables\n        |> filter(\n            fn: (r) => if _grid.level == _s2cellIDLevel then\n                contains(value: r.s2_cell_id, set: _grid.set)\n            else\n                contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set),\n        )",
									Start: ast.Position{
										Column: 12,
										Line:   151,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 104,
												Line:   156,
											},
											File:   "geo.flux",
											Source: "fn: (r) => if _grid.level == _s2cellIDLevel then\n                contains(value: r.s2_cell_id, set: _grid.set)\n            else\n                contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)",
											Start: ast.Position{
												Column: 13,
												Line:   153,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 104,
													Line:   156,
												},
												File:   "geo.flux",
												Source: "fn: (r) => if _grid.level == _s2cellIDLevel then\n                contains(value: r.s2_cell_id, set: _grid.set)\n            else\n                contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)",
												Start: ast.Position{
													Column: 13,
													Line:   153,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   153,
													},
													File:   "geo.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 13,
														Line:   153,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 104,
														Line:   156,
													},
													File:   "geo.flux",
													Source: "(r) => if _grid.level == _s2cellIDLevel then\n                contains(value: r.s2_cell_id, set: _grid.set)\n            else\n                contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)",
													Start: ast.Position{
														Column: 17,
														Line:   153,
													},
												},
											},
											Body: &ast.ConditionalExpression{
												Alternate: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 103,
																	Line:   156,
																},
																File:   "geo.flux",
																Source: "value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set",
																Start: ast.Position{
																	Column: 26,
																	Line:   156,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 87,
																		Line:   156,
																	},
																	File:   "geo.flux",
																	Source: "value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level)",
																	Start: ast.Position{
																		Column: 26,
																		Line:   156,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   156,
																		},
																		File:   "geo.flux",
																		Source: "value",
																		Start: ast.Position{
																			Column: 26,
																			Line:   156,
																		},
																	},
																},
																Name: "value",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 86,
																				Line:   156,
																			},
																			File:   "geo.flux",
																			Source: "token: r.s2_cell_id, level: _grid.level",
																			Start: ast.Position{
																				Column: 47,
																				Line:   156,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 66,
																					Line:   156,
																				},
																				File:   "geo.flux",
																				Source: "token: r.s2_cell_id",
																				Start: ast.Position{
																					Column: 47,
																					Line:   156,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 52,
																						Line:   156,
																					},
																					File:   "geo.flux",
																					Source: "token",
																					Start: ast.Position{
																						Column: 47,
																						Line:   156,
																					},
																				},
																			},
																			Name: "token",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 66,
																						Line:   156,
																					},
																					File:   "geo.flux",
																					Source: "r.s2_cell_id",
																					Start: ast.Position{
																						Column: 54,
																						Line:   156,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 55,
																							Line:   156,
																						},
																						File:   "geo.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 54,
																							Line:   156,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 66,
																							Line:   156,
																						},
																						File:   "geo.flux",
																						Source: "s2_cell_id",
																						Start: ast.Position{
																							Column: 56,
																							Line:   156,
																						},
																					},
																				},
																				Name: "s2_cell_id",
																			},
																			Rbrack: nil,
																		},
																	}, &ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 86,
																					Line:   156,
																				},
																				File:   "geo.flux",
																				Source: "level: _grid.level",
																				Start: ast.Position{
																					Column: 68,
																					Line:   156,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 73,
																						Line:   156,
																					},
																					File:   "geo.flux",
																					Source: "level",
																					Start: ast.Position{
																						Column: 68,
																						Line:   156,
																					},
																				},
																			},
																			Name: "level",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 86,
																						Line:   156,
																					},
																					File:   "geo.flux",
																					Source: "_grid.level",
																					Start: ast.Position{
																						Column: 75,
																						Line:   156,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 80,
																							Line:   156,
																						},
																						File:   "geo.flux",
																						Source: "_grid",
																						Start: ast.Position{
																							Column: 75,
																							Line:   156,
																						},
																					},
																				},
																				Name: "_grid",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 86,
																							Line:   156,
																						},
																						File:   "geo.flux",
																						Source: "level",
																						Start: ast.Position{
																							Column: 81,
																							Line:   156,
																						},
																					},
																				},
																				Name: "level",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 87,
																			Line:   156,
																		},
																		File:   "geo.flux",
																		Source: "s2CellIDToken(token: r.s2_cell_id, level: _grid.level)",
																		Start: ast.Position{
																			Column: 33,
																			Line:   156,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 46,
																				Line:   156,
																			},
																			File:   "geo.flux",
																			Source: "s2CellIDToken",
																			Start: ast.Position{
																				Column: 33,
																				Line:   156,
																			},
																		},
																	},
																	Name: "s2CellIDToken",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 103,
																		Line:   156,
																	},
																	File:   "geo.flux",
																	Source: "set: _grid.set",
																	Start: ast.Position{
																		Column: 89,
																		Line:   156,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 92,
																			Line:   156,
																		},
																		File:   "geo.flux",
																		Source: "set",
																		Start: ast.Position{
																			Column: 89,
																			Line:   156,
																		},
																	},
																},
																Name: "set",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 103,
																			Line:   156,
																		},
																		File:   "geo.flux",
																		Source: "_grid.set",
																		Start: ast.Position{
																			Column: 94,
																			Line:   156,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 99,
																				Line:   156,
																			},
																			File:   "geo.flux",
																			Source: "_grid",
																			Start: ast.Position{
																				Column: 94,
																				Line:   156,
																			},
																		},
																	},
																	Name: "_grid",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 103,
																				Line:   156,
																			},
																			File:   "geo.flux",
																			Source: "set",
																			Start: ast.Position{
																				Column: 100,
																				Line:   156,
																			},
																		},
																	},
																	Name: "set",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 104,
																Line:   156,
															},
															File:   "geo.flux",
															Source: "contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)",
															Start: ast.Position{
																Column: 17,
																Line:   156,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   156,
																},
																File:   "geo.flux",
																Source: "contains",
																Start: ast.Position{
																	Column: 17,
																	Line:   156,
																},
															},
														},
														Name: "contains",
													},
													Lparen: nil,
													Rparen: nil,
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 104,
															Line:   156,
														},
														File:   "geo.flux",
														Source: "if _grid.level == _s2cellIDLevel then\n                contains(value: r.s2_cell_id, set: _grid.set)\n            else\n                contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set)",
														Start: ast.Position{
															Column: 24,
															Line:   153,
														},
													},
												},
												Consequent: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 61,
																	Line:   154,
																},
																File:   "geo.flux",
																Source: "value: r.s2_cell_id, set: _grid.set",
																Start: ast.Position{
																	Column: 26,
																	Line:   154,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 45,
																		Line:   154,
																	},
																	File:   "geo.flux",
																	Source: "value: r.s2_cell_id",
																	Start: ast.Position{
																		Column: 26,
																		Line:   154,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   154,
																		},
																		File:   "geo.flux",
																		Source: "value",
																		Start: ast.Position{
																			Column: 26,
																			Line:   154,
																		},
																	},
																},
																Name: "value",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 45,
																			Line:   154,
																		},
																		File:   "geo.flux",
																		Source: "r.s2_cell_id",
																		Start: ast.Position{
																			Column: 33,
																			Line:   154,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 34,
																				Line:   154,
																			},
																			File:   "geo.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 33,
																				Line:   154,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   154,
																			},
																			File:   "geo.flux",
																			Source: "s2_cell_id",
																			Start: ast.Position{
																				Column: 35,
																				Line:   154,
																			},
																		},
																	},
																	Name: "s2_cell_id",
																},
																Rbrack: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 61,
																		Line:   154,
																	},
																	File:   "geo.flux",
																	Source: "set: _grid.set",
																	Start: ast.Position{
																		Column: 47,
																		Line:   154,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 50,
																			Line:   154,
																		},
																		File:   "geo.flux",
																		Source: "set",
																		Start: ast.Position{
																			Column: 47,
																			Line:   154,
																		},
																	},
																},
																Name: "set",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 61,
																			Line:   154,
																		},
																		File:   "geo.flux",
																		Source: "_grid.set",
																		Start: ast.Position{
																			Column: 52,
																			Line:   154,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 57,
																				Line:   154,
																			},
																			File:   "geo.flux",
																			Source: "_grid",
																			Start: ast.Position{
																				Column: 52,
																				Line:   154,
																			},
																		},
																	},
																	Name: "_grid",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 61,
																				Line:   154,
																			},
																			File:   "geo.flux",
																			Source: "set",
																			Start: ast.Position{
																				Column: 58,
																				Line:   154,
																			},
																		},
																	},
																	Name: "set",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 62,
																Line:   154,
															},
															File:   "geo.flux",
															Source: "contains(value: r.s2_cell_id, set: _grid.set)",
															Start: ast.Position{
																Column: 17,
																Line:   154,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   154,
																},
																File:   "geo.flux",
																Source: "contains",
																Start: ast.Position{
																	Column: 17,
																	Line:   154,
																},
															},
														},
														Name: "contains",
													},
													Lparen: nil,
													Rparen: nil,
												},
												Test: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   153,
															},
															File:   "geo.flux",
															Source: "_grid.level == _s2cellIDLevel",
															Start: ast.Position{
																Column: 27,
																Line:   153,
															},
														},
													},
													Left: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   153,
																},
																File:   "geo.flux",
																Source: "_grid.level",
																Start: ast.Position{
																	Column: 27,
																	Line:   153,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 32,
																		Line:   153,
																	},
																	File:   "geo.flux",
																	Source: "_grid",
																	Start: ast.Position{
																		Column: 27,
																		Line:   153,
																	},
																},
															},
															Name: "_grid",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   153,
																	},
																	File:   "geo.flux",
																	Source: "level",
																	Start: ast.Position{
																		Column: 33,
																		Line:   153,
																	},
																},
															},
															Name: "level",
														},
														Rbrack: nil,
													},
													Operator: 17,
													Right: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 56,
																	Line:   153,
																},
																File:   "geo.flux",
																Source: "_s2cellIDLevel",
																Start: ast.Position{
																	Column: 42,
																	Line:   153,
																},
															},
														},
														Name: "_s2cellIDLevel",
													},
												},
												Tk_else: nil,
												Tk_if:   nil,
												Tk_then: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   153,
														},
														File:   "geo.flux",
														Source: "r",
														Start: ast.Position{
															Column: 18,
															Line:   153,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 19,
																Line:   153,
															},
															File:   "geo.flux",
															Source: "r",
															Start: ast.Position{
																Column: 18,
																Line:   153,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   157,
										},
										File:   "geo.flux",
										Source: "filter(\n            fn: (r) => if _grid.level == _s2cellIDLevel then\n                contains(value: r.s2_cell_id, set: _grid.set)\n            else\n                contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set),\n        )",
										Start: ast.Position{
											Column: 12,
											Line:   152,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   152,
											},
											File:   "geo.flux",
											Source: "filter",
											Start: ast.Position{
												Column: 12,
												Line:   152,
											},
										},
									},
									Name: "filter",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 10,
									Line:   157,
								},
								File:   "geo.flux",
								Source: "return tables\n        |> filter(\n            fn: (r) => if _grid.level == _s2cellIDLevel then\n                contains(value: r.s2_cell_id, set: _grid.set)\n            else\n                contains(value: s2CellIDToken(token: r.s2_cell_id, level: _grid.level), set: _grid.set),\n        )",
								Start: ast.Position{
									Column: 5,
									Line:   151,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   129,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 9,
								Line:   129,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   129,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 9,
									Line:   129,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   129,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 16,
								Line:   129,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   130,
							},
							File:   "geo.flux",
							Source: "region",
							Start: ast.Position{
								Column: 9,
								Line:   130,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   130,
								},
								File:   "geo.flux",
								Source: "region",
								Start: ast.Position{
									Column: 9,
									Line:   130,
								},
							},
						},
						Name: "region",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   131,
							},
							File:   "geo.flux",
							Source: "minSize=24",
							Start: ast.Position{
								Column: 9,
								Line:   131,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   131,
								},
								File:   "geo.flux",
								Source: "minSize",
								Start: ast.Position{
									Column: 9,
									Line:   131,
								},
							},
						},
						Name: "minSize",
					},
					Separator: nil,
					Value: &ast.IntegerLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   131,
								},
								File:   "geo.flux",
								Source: "24",
								Start: ast.Position{
									Column: 17,
									Line:   131,
								},
							},
						},
						Value: int64(24),
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   132,
							},
							File:   "geo.flux",
							Source: "maxSize=-1",
							Start: ast.Position{
								Column: 9,
								Line:   132,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   132,
								},
								File:   "geo.flux",
								Source: "maxSize",
								Start: ast.Position{
									Column: 9,
									Line:   132,
								},
							},
						},
						Name: "maxSize",
					},
					Separator: nil,
					Value: &ast.UnaryExpression{
						Argument: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   132,
									},
									File:   "geo.flux",
									Source: "1",
									Start: ast.Position{
										Column: 18,
										Line:   132,
									},
								},
							},
							Value: int64(1),
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   132,
								},
								File:   "geo.flux",
								Source: "-1",
								Start: ast.Position{
									Column: 17,
									Line:   132,
								},
							},
						},
						Operator: 6,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   133,
							},
							File:   "geo.flux",
							Source: "level=-1",
							Start: ast.Position{
								Column: 9,
								Line:   133,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   133,
								},
								File:   "geo.flux",
								Source: "level",
								Start: ast.Position{
									Column: 9,
									Line:   133,
								},
							},
						},
						Name: "level",
					},
					Separator: nil,
					Value: &ast.UnaryExpression{
						Argument: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   133,
									},
									File:   "geo.flux",
									Source: "1",
									Start: ast.Position{
										Column: 16,
										Line:   133,
									},
								},
							},
							Value: int64(1),
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   133,
								},
								File:   "geo.flux",
								Source: "-1",
								Start: ast.Position{
									Column: 15,
									Line:   133,
								},
							},
						},
						Operator: 6,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   134,
							},
							File:   "geo.flux",
							Source: "s2cellIDLevel=-1",
							Start: ast.Position{
								Column: 9,
								Line:   134,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   134,
								},
								File:   "geo.flux",
								Source: "s2cellIDLevel",
								Start: ast.Position{
									Column: 9,
									Line:   134,
								},
							},
						},
						Name: "s2cellIDLevel",
					},
					Separator: nil,
					Value: &ast.UnaryExpression{
						Argument: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   134,
									},
									File:   "geo.flux",
									Source: "1",
									Start: ast.Position{
										Column: 24,
										Line:   134,
									},
								},
							},
							Value: int64(1),
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   134,
								},
								File:   "geo.flux",
								Source: "-1",
								Start: ast.Position{
									Column: 23,
									Line:   134,
								},
							},
						},
						Operator: 6,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   135,
							},
							File:   "geo.flux",
							Source: "units=units",
							Start: ast.Position{
								Column: 9,
								Line:   135,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   135,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 9,
									Line:   135,
								},
							},
						},
						Name: "units",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   135,
								},
								File:   "geo.flux",
								Source: "units",
								Start: ast.Position{
									Column: 15,
									Line:   135,
								},
							},
						},
						Name: "units",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 90,
						Line:   163,
					},
					File:   "geo.flux",
					Source: "strictFilter = (tables=<-, region) => tables\n    |> filter(fn: (r) => ST_Contains(region: region, geometry: {lat: r.lat, lon: r.lon}))",
					Start: ast.Position{
						Column: 1,
						Line:   162,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Filters records by specified region.\n"}, ast.Comment{Text: "// It is an exact filter and must be used after `toRows()` because it requires `lat` and `lon` columns in input row sets.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   162,
						},
						File:   "geo.flux",
						Source: "strictFilter",
						Start: ast.Position{
							Column: 1,
							Line:   162,
						},
					},
				},
				Name: "strictFilter",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 90,
							Line:   163,
						},
						File:   "geo.flux",
						Source: "(tables=<-, region) => tables\n    |> filter(fn: (r) => ST_Contains(region: region, geometry: {lat: r.lat, lon: r.lon}))",
						Start: ast.Position{
							Column: 16,
							Line:   162,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   162,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 39,
									Line:   162,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 90,
								Line:   163,
							},
							File:   "geo.flux",
							Source: "tables\n    |> filter(fn: (r) => ST_Contains(region: region, geometry: {lat: r.lat, lon: r.lon}))",
							Start: ast.Position{
								Column: 39,
								Line:   162,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 89,
										Line:   163,
									},
									File:   "geo.flux",
									Source: "fn: (r) => ST_Contains(region: region, geometry: {lat: r.lat, lon: r.lon})",
									Start: ast.Position{
										Column: 15,
										Line:   163,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 89,
											Line:   163,
										},
										File:   "geo.flux",
										Source: "fn: (r) => ST_Contains(region: region, geometry: {lat: r.lat, lon: r.lon})",
										Start: ast.Position{
											Column: 15,
											Line:   163,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   163,
											},
											File:   "geo.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 15,
												Line:   163,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 89,
												Line:   163,
											},
											File:   "geo.flux",
											Source: "(r) => ST_Contains(region: region, geometry: {lat: r.lat, lon: r.lon})",
											Start: ast.Position{
												Column: 19,
												Line:   163,
											},
										},
									},
									Body: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 88,
														Line:   163,
													},
													File:   "geo.flux",
													Source: "region: region, geometry: {lat: r.lat, lon: r.lon}",
													Start: ast.Position{
														Column: 38,
														Line:   163,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 52,
															Line:   163,
														},
														File:   "geo.flux",
														Source: "region: region",
														Start: ast.Position{
															Column: 38,
															Line:   163,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 44,
																Line:   163,
															},
															File:   "geo.flux",
															Source: "region",
															Start: ast.Position{
																Column: 38,
																Line:   163,
															},
														},
													},
													Name: "region",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 52,
																Line:   163,
															},
															File:   "geo.flux",
															Source: "region",
															Start: ast.Position{
																Column: 46,
																Line:   163,
															},
														},
													},
													Name: "region",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 88,
															Line:   163,
														},
														File:   "geo.flux",
														Source: "geometry: {lat: r.lat, lon: r.lon}",
														Start: ast.Position{
															Column: 54,
															Line:   163,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 62,
																Line:   163,
															},
															File:   "geo.flux",
															Source: "geometry",
															Start: ast.Position{
																Column: 54,
																Line:   163,
															},
														},
													},
													Name: "geometry",
												},
												Separator: nil,
												Value: &ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 88,
																Line:   163,
															},
															File:   "geo.flux",
															Source: "{lat: r.lat, lon: r.lon}",
															Start: ast.Position{
																Column: 64,
																Line:   163,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 75,
																	Line:   163,
																},
																File:   "geo.flux",
																Source: "lat: r.lat",
																Start: ast.Position{
																	Column: 65,
																	Line:   163,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 68,
																		Line:   163,
																	},
																	File:   "geo.flux",
																	Source: "lat",
																	Start: ast.Position{
																		Column: 65,
																		Line:   163,
																	},
																},
															},
															Name: "lat",
														},
														Separator: nil,
														Value: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 75,
																		Line:   163,
																	},
																	File:   "geo.flux",
																	Source: "r.lat",
																	Start: ast.Position{
																		Column: 70,
																		Line:   163,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 71,
																			Line:   163,
																		},
																		File:   "geo.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 70,
																			Line:   163,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 75,
																			Line:   163,
																		},
																		File:   "geo.flux",
																		Source: "lat",
																		Start: ast.Position{
																			Column: 72,
																			Line:   163,
																		},
																	},
																},
																Name: "lat",
															},
															Rbrack: nil,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 87,
																	Line:   163,
																},
																File:   "geo.flux",
																Source: "lon: r.lon",
																Start: ast.Position{
																	Column: 77,
																	Line:   163,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 80,
																		Line:   163,
																	},
																	File:   "geo.flux",
																	Source: "lon",
																	Start: ast.Position{
																		Column: 77,
																		Line:   163,
																	},
																},
															},
															Name: "lon",
														},
														Separator: nil,
														Value: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 87,
																		Line:   163,
																	},
																	File:   "geo.flux",
																	Source: "r.lon",
																	Start: ast.Position{
																		Column: 82,
																		Line:   163,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 83,
																			Line:   163,
																		},
																		File:   "geo.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 82,
																			Line:   163,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 87,
																			Line:   163,
																		},
																		File:   "geo.flux",
																		Source: "lon",
																		Start: ast.Position{
																			Column: 84,
																			Line:   163,
																		},
																	},
																},
																Name: "lon",
															},
															Rbrack: nil,
														},
													}},
													Rbrace: nil,
													With:   nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 89,
													Line:   163,
												},
												File:   "geo.flux",
												Source: "ST_Contains(region: region, geometry: {lat: r.lat, lon: r.lon})",
												Start: ast.Position{
													Column: 26,
													Line:   163,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   163,
													},
													File:   "geo.flux",
													Source: "ST_Contains",
													Start: ast.Position{
														Column: 26,
														Line:   163,
													},
												},
											},
											Name: "ST_Contains",
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   163,
												},
												File:   "geo.flux",
												Source: "r",
												Start: ast.Position{
													Column: 20,
													Line:   163,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   163,
													},
													File:   "geo.flux",
													Source: "r",
													Start: ast.Position{
														Column: 20,
														Line:   163,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 90,
									Line:   163,
								},
								File:   "geo.flux",
								Source: "filter(fn: (r) => ST_Contains(region: region, geometry: {lat: r.lat, lon: r.lon}))",
								Start: ast.Position{
									Column: 8,
									Line:   163,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   163,
									},
									File:   "geo.flux",
									Source: "filter",
									Start: ast.Position{
										Column: 8,
										Line:   163,
									},
								},
							},
							Name: "filter",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   162,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 17,
								Line:   162,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   162,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 17,
									Line:   162,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   162,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   162,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   162,
							},
							File:   "geo.flux",
							Source: "region",
							Start: ast.Position{
								Column: 28,
								Line:   162,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   162,
								},
								File:   "geo.flux",
								Source: "region",
								Start: ast.Position{
									Column: 28,
									Line:   162,
								},
							},
						},
						Name: "region",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   207,
					},
					File:   "geo.flux",
					Source: "filterRows = (\n        tables=<-,\n        region,\n        minSize=24,\n        maxSize=-1,\n        level=-1,\n        s2cellIDLevel=-1,\n        strict=true,\n) => {\n    _columns = tables\n        |> columns(column: \"_value\")\n        |> tableFind(fn: (key) => true)\n        |> getColumn(column: \"_value\")\n    _rows = if contains(value: \"lat\", set: _columns) then\n        tables\n            |> gridFilter(\n                region: region,\n                minSize: minSize,\n                maxSize: maxSize,\n                level: level,\n                s2cellIDLevel: s2cellIDLevel,\n            )\n    else\n        tables\n            |> gridFilter(\n                region: region,\n                minSize: minSize,\n                maxSize: maxSize,\n                level: level,\n                s2cellIDLevel: s2cellIDLevel,\n            )\n            |> toRows()\n    _result = if strict then\n        _rows\n            |> strictFilter(region)\n    else\n        _rows\n\n    return _result\n}",
					Start: ast.Position{
						Column: 1,
						Line:   168,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Two-phase filtering by specified region.\n"}, ast.Comment{Text: "// Checks to see if data is already pivoted and contains a lat column.\n"}, ast.Comment{Text: "// Returns pivoted data.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   168,
						},
						File:   "geo.flux",
						Source: "filterRows",
						Start: ast.Position{
							Column: 1,
							Line:   168,
						},
					},
				},
				Name: "filterRows",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   207,
						},
						File:   "geo.flux",
						Source: "(\n        tables=<-,\n        region,\n        minSize=24,\n        maxSize=-1,\n        level=-1,\n        s2cellIDLevel=-1,\n        strict=true,\n) => {\n    _columns = tables\n        |> columns(column: \"_value\")\n        |> tableFind(fn: (key) => true)\n        |> getColumn(column: \"_value\")\n    _rows = if contains(value: \"lat\", set: _columns) then\n        tables\n            |> gridFilter(\n                region: region,\n                minSize: minSize,\n                maxSize: maxSize,\n                level: level,\n                s2cellIDLevel: s2cellIDLevel,\n            )\n    else\n        tables\n            |> gridFilter(\n                region: region,\n                minSize: minSize,\n                maxSize: maxSize,\n                level: level,\n                s2cellIDLevel: s2cellIDLevel,\n            )\n            |> toRows()\n    _result = if strict then\n        _rows\n            |> strictFilter(region)\n    else\n        _rows\n\n    return _result\n}",
						Start: ast.Position{
							Column: 14,
							Line:   168,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   207,
							},
							File:   "geo.flux",
							Source: "{\n    _columns = tables\n        |> columns(column: \"_value\")\n        |> tableFind(fn: (key) => true)\n        |> getColumn(column: \"_value\")\n    _rows = if contains(value: \"lat\", set: _columns) then\n        tables\n            |> gridFilter(\n                region: region,\n                minSize: minSize,\n                maxSize: maxSize,\n                level: level,\n                s2cellIDLevel: s2cellIDLevel,\n            )\n    else\n        tables\n            |> gridFilter(\n                region: region,\n                minSize: minSize,\n                maxSize: maxSize,\n                level: level,\n                s2cellIDLevel: s2cellIDLevel,\n            )\n            |> toRows()\n    _result = if strict then\n        _rows\n            |> strictFilter(region)\n    else\n        _rows\n\n    return _result\n}",
							Start: ast.Position{
								Column: 6,
								Line:   176,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   180,
								},
								File:   "geo.flux",
								Source: "_columns = tables\n        |> columns(column: \"_value\")\n        |> tableFind(fn: (key) => true)\n        |> getColumn(column: \"_value\")",
								Start: ast.Position{
									Column: 5,
									Line:   177,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   177,
									},
									File:   "geo.flux",
									Source: "_columns",
									Start: ast.Position{
										Column: 5,
										Line:   177,
									},
								},
							},
							Name: "_columns",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   177,
												},
												File:   "geo.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 16,
													Line:   177,
												},
											},
										},
										Name: "tables",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   178,
											},
											File:   "geo.flux",
											Source: "tables\n        |> columns(column: \"_value\")",
											Start: ast.Position{
												Column: 16,
												Line:   177,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   178,
													},
													File:   "geo.flux",
													Source: "column: \"_value\"",
													Start: ast.Position{
														Column: 20,
														Line:   178,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   178,
														},
														File:   "geo.flux",
														Source: "column: \"_value\"",
														Start: ast.Position{
															Column: 20,
															Line:   178,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   178,
															},
															File:   "geo.flux",
															Source: "column",
															Start: ast.Position{
																Column: 20,
																Line:   178,
															},
														},
													},
													Name: "column",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   178,
															},
															File:   "geo.flux",
															Source: "\"_value\"",
															Start: ast.Position{
																Column: 28,
																Line:   178,
															},
														},
													},
													Value: "_value",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   178,
												},
												File:   "geo.flux",
												Source: "columns(column: \"_value\")",
												Start: ast.Position{
													Column: 12,
													Line:   178,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   178,
													},
													File:   "geo.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 12,
														Line:   178,
													},
												},
											},
											Name: "columns",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   179,
										},
										File:   "geo.flux",
										Source: "tables\n        |> columns(column: \"_value\")\n        |> tableFind(fn: (key) => true)",
										Start: ast.Position{
											Column: 16,
											Line:   177,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   179,
												},
												File:   "geo.flux",
												Source: "fn: (key) => true",
												Start: ast.Position{
													Column: 22,
													Line:   179,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   179,
													},
													File:   "geo.flux",
													Source: "fn: (key) => true",
													Start: ast.Position{
														Column: 22,
														Line:   179,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   179,
														},
														File:   "geo.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 22,
															Line:   179,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   179,
														},
														File:   "geo.flux",
														Source: "(key) => true",
														Start: ast.Position{
															Column: 26,
															Line:   179,
														},
													},
												},
												Body: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 39,
																Line:   179,
															},
															File:   "geo.flux",
															Source: "true",
															Start: ast.Position{
																Column: 35,
																Line:   179,
															},
														},
													},
													Name: "true",
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   179,
															},
															File:   "geo.flux",
															Source: "key",
															Start: ast.Position{
																Column: 27,
																Line:   179,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   179,
																},
																File:   "geo.flux",
																Source: "key",
																Start: ast.Position{
																	Column: 27,
																	Line:   179,
																},
															},
														},
														Name: "key",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   179,
											},
											File:   "geo.flux",
											Source: "tableFind(fn: (key) => true)",
											Start: ast.Position{
												Column: 12,
												Line:   179,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   179,
												},
												File:   "geo.flux",
												Source: "tableFind",
												Start: ast.Position{
													Column: 12,
													Line:   179,
												},
											},
										},
										Name: "tableFind",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   180,
									},
									File:   "geo.flux",
									Source: "tables\n        |> columns(column: \"_value\")\n        |> tableFind(fn: (key) => true)\n        |> getColumn(column: \"_value\")",
									Start: ast.Position{
										Column: 16,
										Line:   177,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   180,
											},
											File:   "geo.flux",
											Source: "column: \"_value\"",
											Start: ast.Position{
												Column: 22,
												Line:   180,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   180,
												},
												File:   "geo.flux",
												Source: "column: \"_value\"",
												Start: ast.Position{
													Column: 22,
													Line:   180,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   180,
													},
													File:   "geo.flux",
													Source: "column",
													Start: ast.Position{
														Column: 22,
														Line:   180,
													},
												},
											},
											Name: "column",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   180,
													},
													File:   "geo.flux",
													Source: "\"_value\"",
													Start: ast.Position{
														Column: 30,
														Line:   180,
													},
												},
											},
											Value: "_value",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   180,
										},
										File:   "geo.flux",
										Source: "getColumn(column: \"_value\")",
										Start: ast.Position{
											Column: 12,
											Line:   180,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   180,
											},
											File:   "geo.flux",
											Source: "getColumn",
											Start: ast.Position{
												Column: 12,
												Line:   180,
											},
										},
									},
									Name: "getColumn",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   199,
								},
								File:   "geo.flux",
								Source: "_rows = if contains(value: \"lat\", set: _columns) then\n        tables\n            |> gridFilter(\n                region: region,\n                minSize: minSize,\n                maxSize: maxSize,\n                level: level,\n                s2cellIDLevel: s2cellIDLevel,\n            )\n    else\n        tables\n            |> gridFilter(\n                region: region,\n                minSize: minSize,\n                maxSize: maxSize,\n                level: level,\n                s2cellIDLevel: s2cellIDLevel,\n            )\n            |> toRows()",
								Start: ast.Position{
									Column: 5,
									Line:   181,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   181,
									},
									File:   "geo.flux",
									Source: "_rows",
									Start: ast.Position{
										Column: 5,
										Line:   181,
									},
								},
							},
							Name: "_rows",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   191,
												},
												File:   "geo.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 9,
													Line:   191,
												},
											},
										},
										Name: "tables",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   198,
											},
											File:   "geo.flux",
											Source: "tables\n            |> gridFilter(\n                region: region,\n                minSize: minSize,\n                maxSize: maxSize,\n                level: level,\n                s2cellIDLevel: s2cellIDLevel,\n            )",
											Start: ast.Position{
												Column: 9,
												Line:   191,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   197,
													},
													File:   "geo.flux",
													Source: "region: region,\n                minSize: minSize,\n                maxSize: maxSize,\n                level: level,\n                s2cellIDLevel: s2cellIDLevel",
													Start: ast.Position{
														Column: 17,
														Line:   193,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   193,
														},
														File:   "geo.flux",
														Source: "region: region",
														Start: ast.Position{
															Column: 17,
															Line:   193,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 23,
																Line:   193,
															},
															File:   "geo.flux",
															Source: "region",
															Start: ast.Position{
																Column: 17,
																Line:   193,
															},
														},
													},
													Name: "region",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 31,
																Line:   193,
															},
															File:   "geo.flux",
															Source: "region",
															Start: ast.Position{
																Column: 25,
																Line:   193,
															},
														},
													},
													Name: "region",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   194,
														},
														File:   "geo.flux",
														Source: "minSize: minSize",
														Start: ast.Position{
															Column: 17,
															Line:   194,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   194,
															},
															File:   "geo.flux",
															Source: "minSize",
															Start: ast.Position{
																Column: 17,
																Line:   194,
															},
														},
													},
													Name: "minSize",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 33,
																Line:   194,
															},
															File:   "geo.flux",
															Source: "minSize",
															Start: ast.Position{
																Column: 26,
																Line:   194,
															},
														},
													},
													Name: "minSize",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   195,
														},
														File:   "geo.flux",
														Source: "maxSize: maxSize",
														Start: ast.Position{
															Column: 17,
															Line:   195,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   195,
															},
															File:   "geo.flux",
															Source: "maxSize",
															Start: ast.Position{
																Column: 17,
																Line:   195,
															},
														},
													},
													Name: "maxSize",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 33,
																Line:   195,
															},
															File:   "geo.flux",
															Source: "maxSize",
															Start: ast.Position{
																Column: 26,
																Line:   195,
															},
														},
													},
													Name: "maxSize",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   196,
														},
														File:   "geo.flux",
														Source: "level: level",
														Start: ast.Position{
															Column: 17,
															Line:   196,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   196,
															},
															File:   "geo.flux",
															Source: "level",
															Start: ast.Position{
																Column: 17,
																Line:   196,
															},
														},
													},
													Name: "level",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 29,
																Line:   196,
															},
															File:   "geo.flux",
															Source: "level",
															Start: ast.Position{
																Column: 24,
																Line:   196,
															},
														},
													},
													Name: "level",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   197,
														},
														File:   "geo.flux",
														Source: "s2cellIDLevel: s2cellIDLevel",
														Start: ast.Position{
															Column: 17,
															Line:   197,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   197,
															},
															File:   "geo.flux",
															Source: "s2cellIDLevel",
															Start: ast.Position{
																Column: 17,
																Line:   197,
															},
														},
													},
													Name: "s2cellIDLevel",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   197,
															},
															File:   "geo.flux",
															Source: "s2cellIDLevel",
															Start: ast.Position{
																Column: 32,
																Line:   197,
															},
														},
													},
													Name: "s2cellIDLevel",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   198,
												},
												File:   "geo.flux",
												Source: "gridFilter(\n                region: region,\n                minSize: minSize,\n                maxSize: maxSize,\n                level: level,\n                s2cellIDLevel: s2cellIDLevel,\n            )",
												Start: ast.Position{
													Column: 16,
													Line:   192,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   192,
													},
													File:   "geo.flux",
													Source: "gridFilter",
													Start: ast.Position{
														Column: 16,
														Line:   192,
													},
												},
											},
											Name: "gridFilter",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   199,
										},
										File:   "geo.flux",
										Source: "tables\n            |> gridFilter(\n                region: region,\n                minSize: minSize,\n                maxSize: maxSize,\n                level: level,\n                s2cellIDLevel: s2cellIDLevel,\n            )\n            |> toRows()",
										Start: ast.Position{
											Column: 9,
											Line:   191,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   199,
											},
											File:   "geo.flux",
											Source: "toRows()",
											Start: ast.Position{
												Column: 16,
												Line:   199,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   199,
												},
												File:   "geo.flux",
												Source: "toRows",
												Start: ast.Position{
													Column: 16,
													Line:   199,
												},
											},
										},
										Name: "toRows",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   199,
									},
									File:   "geo.flux",
									Source: "if contains(value: \"lat\", set: _columns) then\n        tables\n            |> gridFilter(\n                region: region,\n                minSize: minSize,\n                maxSize: maxSize,\n                level: level,\n                s2cellIDLevel: s2cellIDLevel,\n            )\n    else\n        tables\n            |> gridFilter(\n                region: region,\n                minSize: minSize,\n                maxSize: maxSize,\n                level: level,\n                s2cellIDLevel: s2cellIDLevel,\n            )\n            |> toRows()",
									Start: ast.Position{
										Column: 13,
										Line:   181,
									},
								},
							},
							Consequent: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   182,
											},
											File:   "geo.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 9,
												Line:   182,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   189,
										},
										File:   "geo.flux",
										Source: "tables\n            |> gridFilter(\n                region: region,\n                minSize: minSize,\n                maxSize: maxSize,\n                level: level,\n                s2cellIDLevel: s2cellIDLevel,\n            )",
										Start: ast.Position{
											Column: 9,
											Line:   182,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   188,
												},
												File:   "geo.flux",
												Source: "region: region,\n                minSize: minSize,\n                maxSize: maxSize,\n                level: level,\n                s2cellIDLevel: s2cellIDLevel",
												Start: ast.Position{
													Column: 17,
													Line:   184,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   184,
													},
													File:   "geo.flux",
													Source: "region: region",
													Start: ast.Position{
														Column: 17,
														Line:   184,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 23,
															Line:   184,
														},
														File:   "geo.flux",
														Source: "region",
														Start: ast.Position{
															Column: 17,
															Line:   184,
														},
													},
												},
												Name: "region",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   184,
														},
														File:   "geo.flux",
														Source: "region",
														Start: ast.Position{
															Column: 25,
															Line:   184,
														},
													},
												},
												Name: "region",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   185,
													},
													File:   "geo.flux",
													Source: "minSize: minSize",
													Start: ast.Position{
														Column: 17,
														Line:   185,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   185,
														},
														File:   "geo.flux",
														Source: "minSize",
														Start: ast.Position{
															Column: 17,
															Line:   185,
														},
													},
												},
												Name: "minSize",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   185,
														},
														File:   "geo.flux",
														Source: "minSize",
														Start: ast.Position{
															Column: 26,
															Line:   185,
														},
													},
												},
												Name: "minSize",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   186,
													},
													File:   "geo.flux",
													Source: "maxSize: maxSize",
													Start: ast.Position{
														Column: 17,
														Line:   186,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   186,
														},
														File:   "geo.flux",
														Source: "maxSize",
														Start: ast.Position{
															Column: 17,
															Line:   186,
														},
													},
												},
												Name: "maxSize",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   186,
														},
														File:   "geo.flux",
														Source: "maxSize",
														Start: ast.Position{
															Column: 26,
															Line:   186,
														},
													},
												},
												Name: "maxSize",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   187,
													},
													File:   "geo.flux",
													Source: "level: level",
													Start: ast.Position{
														Column: 17,
														Line:   187,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   187,
														},
														File:   "geo.flux",
														Source: "level",
														Start: ast.Position{
															Column: 17,
															Line:   187,
														},
													},
												},
												Name: "level",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   187,
														},
														File:   "geo.flux",
														Source: "level",
														Start: ast.Position{
															Column: 24,
															Line:   187,
														},
													},
												},
												Name: "level",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   188,
													},
													File:   "geo.flux",
													Source: "s2cellIDLevel: s2cellIDLevel",
													Start: ast.Position{
														Column: 17,
														Line:   188,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   188,
														},
														File:   "geo.flux",
														Source: "s2cellIDLevel",
														Start: ast.Position{
															Column: 17,
															Line:   188,
														},
													},
												},
												Name: "s2cellIDLevel",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   188,
														},
														File:   "geo.flux",
														Source: "s2cellIDLevel",
														Start: ast.Position{
															Column: 32,
															Line:   188,
														},
													},
												},
												Name: "s2cellIDLevel",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   189,
											},
											File:   "geo.flux",
											Source: "gridFilter(\n                region: region,\n                minSize: minSize,\n                maxSize: maxSize,\n                level: level,\n                s2cellIDLevel: s2cellIDLevel,\n            )",
											Start: ast.Position{
												Column: 16,
												Line:   183,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   183,
												},
												File:   "geo.flux",
												Source: "gridFilter",
												Start: ast.Position{
													Column: 16,
													Line:   183,
												},
											},
										},
										Name: "gridFilter",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							Test: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   181,
											},
											File:   "geo.flux",
											Source: "value: \"lat\", set: _columns",
											Start: ast.Position{
												Column: 25,
												Line:   181,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   181,
												},
												File:   "geo.flux",
												Source: "value: \"lat\"",
												Start: ast.Position{
													Column: 25,
													Line:   181,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   181,
													},
													File:   "geo.flux",
													Source: "value",
													Start: ast.Position{
														Column: 25,
														Line:   181,
													},
												},
											},
											Name: "value",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   181,
													},
													File:   "geo.flux",
													Source: "\"lat\"",
													Start: ast.Position{
														Column: 32,
														Line:   181,
													},
												},
											},
											Value: "lat",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 52,
													Line:   181,
												},
												File:   "geo.flux",
												Source: "set: _columns",
												Start: ast.Position{
													Column: 39,
													Line:   181,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   181,
													},
													File:   "geo.flux",
													Source: "set",
													Start: ast.Position{
														Column: 39,
														Line:   181,
													},
												},
											},
											Name: "set",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 52,
														Line:   181,
													},
													File:   "geo.flux",
													Source: "_columns",
													Start: ast.Position{
														Column: 44,
														Line:   181,
													},
												},
											},
											Name: "_columns",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   181,
										},
										File:   "geo.flux",
										Source: "contains(value: \"lat\", set: _columns)",
										Start: ast.Position{
											Column: 16,
											Line:   181,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   181,
											},
											File:   "geo.flux",
											Source: "contains",
											Start: ast.Position{
												Column: 16,
												Line:   181,
											},
										},
									},
									Name: "contains",
								},
								Lparen: nil,
								Rparen: nil,
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   204,
								},
								File:   "geo.flux",
								Source: "_result = if strict then\n        _rows\n            |> strictFilter(region)\n    else\n        _rows",
								Start: ast.Position{
									Column: 5,
									Line:   200,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   200,
									},
									File:   "geo.flux",
									Source: "_result",
									Start: ast.Position{
										Column: 5,
										Line:   200,
									},
								},
							},
							Name: "_result",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   204,
										},
										File:   "geo.flux",
										Source: "_rows",
										Start: ast.Position{
											Column: 9,
											Line:   204,
										},
									},
								},
								Name: "_rows",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   204,
									},
									File:   "geo.flux",
									Source: "if strict then\n        _rows\n            |> strictFilter(region)\n    else\n        _rows",
									Start: ast.Position{
										Column: 15,
										Line:   200,
									},
								},
							},
							Consequent: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   201,
											},
											File:   "geo.flux",
											Source: "_rows",
											Start: ast.Position{
												Column: 9,
												Line:   201,
											},
										},
									},
									Name: "_rows",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   202,
										},
										File:   "geo.flux",
										Source: "_rows\n            |> strictFilter(region)",
										Start: ast.Position{
											Column: 9,
											Line:   201,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   202,
												},
												File:   "geo.flux",
												Source: "region",
												Start: ast.Position{
													Column: 29,
													Line:   202,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   202,
													},
													File:   "geo.flux",
													Source: "region",
													Start: ast.Position{
														Column: 29,
														Line:   202,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   202,
														},
														File:   "geo.flux",
														Source: "region",
														Start: ast.Position{
															Column: 29,
															Line:   202,
														},
													},
												},
												Name: "region",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   202,
											},
											File:   "geo.flux",
											Source: "strictFilter(region)",
											Start: ast.Position{
												Column: 16,
												Line:   202,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   202,
												},
												File:   "geo.flux",
												Source: "strictFilter",
												Start: ast.Position{
													Column: 16,
													Line:   202,
												},
											},
										},
										Name: "strictFilter",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							Test: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   200,
										},
										File:   "geo.flux",
										Source: "strict",
										Start: ast.Position{
											Column: 18,
											Line:   200,
										},
									},
								},
								Name: "strict",
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   206,
									},
									File:   "geo.flux",
									Source: "_result",
									Start: ast.Position{
										Column: 12,
										Line:   206,
									},
								},
							},
							Name: "_result",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   206,
								},
								File:   "geo.flux",
								Source: "return _result",
								Start: ast.Position{
									Column: 5,
									Line:   206,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   169,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 9,
								Line:   169,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   169,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 9,
									Line:   169,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   169,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 16,
								Line:   169,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   170,
							},
							File:   "geo.flux",
							Source: "region",
							Start: ast.Position{
								Column: 9,
								Line:   170,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   170,
								},
								File:   "geo.flux",
								Source: "region",
								Start: ast.Position{
									Column: 9,
									Line:   170,
								},
							},
						},
						Name: "region",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   171,
							},
							File:   "geo.flux",
							Source: "minSize=24",
							Start: ast.Position{
								Column: 9,
								Line:   171,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   171,
								},
								File:   "geo.flux",
								Source: "minSize",
								Start: ast.Position{
									Column: 9,
									Line:   171,
								},
							},
						},
						Name: "minSize",
					},
					Separator: nil,
					Value: &ast.IntegerLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   171,
								},
								File:   "geo.flux",
								Source: "24",
								Start: ast.Position{
									Column: 17,
									Line:   171,
								},
							},
						},
						Value: int64(24),
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   172,
							},
							File:   "geo.flux",
							Source: "maxSize=-1",
							Start: ast.Position{
								Column: 9,
								Line:   172,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   172,
								},
								File:   "geo.flux",
								Source: "maxSize",
								Start: ast.Position{
									Column: 9,
									Line:   172,
								},
							},
						},
						Name: "maxSize",
					},
					Separator: nil,
					Value: &ast.UnaryExpression{
						Argument: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   172,
									},
									File:   "geo.flux",
									Source: "1",
									Start: ast.Position{
										Column: 18,
										Line:   172,
									},
								},
							},
							Value: int64(1),
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   172,
								},
								File:   "geo.flux",
								Source: "-1",
								Start: ast.Position{
									Column: 17,
									Line:   172,
								},
							},
						},
						Operator: 6,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   173,
							},
							File:   "geo.flux",
							Source: "level=-1",
							Start: ast.Position{
								Column: 9,
								Line:   173,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   173,
								},
								File:   "geo.flux",
								Source: "level",
								Start: ast.Position{
									Column: 9,
									Line:   173,
								},
							},
						},
						Name: "level",
					},
					Separator: nil,
					Value: &ast.UnaryExpression{
						Argument: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   173,
									},
									File:   "geo.flux",
									Source: "1",
									Start: ast.Position{
										Column: 16,
										Line:   173,
									},
								},
							},
							Value: int64(1),
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   173,
								},
								File:   "geo.flux",
								Source: "-1",
								Start: ast.Position{
									Column: 15,
									Line:   173,
								},
							},
						},
						Operator: 6,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   174,
							},
							File:   "geo.flux",
							Source: "s2cellIDLevel=-1",
							Start: ast.Position{
								Column: 9,
								Line:   174,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   174,
								},
								File:   "geo.flux",
								Source: "s2cellIDLevel",
								Start: ast.Position{
									Column: 9,
									Line:   174,
								},
							},
						},
						Name: "s2cellIDLevel",
					},
					Separator: nil,
					Value: &ast.UnaryExpression{
						Argument: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   174,
									},
									File:   "geo.flux",
									Source: "1",
									Start: ast.Position{
										Column: 24,
										Line:   174,
									},
								},
							},
							Value: int64(1),
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   174,
								},
								File:   "geo.flux",
								Source: "-1",
								Start: ast.Position{
									Column: 23,
									Line:   174,
								},
							},
						},
						Operator: 6,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   175,
							},
							File:   "geo.flux",
							Source: "strict=true",
							Start: ast.Position{
								Column: 9,
								Line:   175,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   175,
								},
								File:   "geo.flux",
								Source: "strict",
								Start: ast.Position{
									Column: 9,
									Line:   175,
								},
							},
						},
						Name: "strict",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   175,
								},
								File:   "geo.flux",
								Source: "true",
								Start: ast.Position{
									Column: 16,
									Line:   175,
								},
							},
						},
						Name: "true",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   235,
					},
					File:   "geo.flux",
					Source: "groupByArea = (tables=<-, newColumn, level, s2cellIDLevel=-1) => {\n    _s2cellIDLevel = if s2cellIDLevel == -1 then\n        tables\n            |> _detectLevel()\n    else\n        s2cellIDLevel\n    _prepared = if level == _s2cellIDLevel then\n        tables\n            |> duplicate(column: \"s2_cell_id\", as: newColumn)\n    else\n        tables\n            |> map(\n                fn: (r) => ({r with\n                    _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n                }),\n            )\n            |> rename(columns: {_s2_cell_id_xxx: newColumn})\n\n    return _prepared\n        |> group(columns: [newColumn])\n}",
					Start: ast.Position{
						Column: 1,
						Line:   215,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Grouping functions\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// intended to be used row-wise sets (i.e after `toRows()`)\n"}, ast.Comment{Text: "// Groups data by area of size specified by level. Result is grouped by `newColumn`.\n"}, ast.Comment{Text: "// Grouping levels: https://s2geometry.io/resources/s2cell_statistics.html\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   215,
						},
						File:   "geo.flux",
						Source: "groupByArea",
						Start: ast.Position{
							Column: 1,
							Line:   215,
						},
					},
				},
				Name: "groupByArea",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   235,
						},
						File:   "geo.flux",
						Source: "(tables=<-, newColumn, level, s2cellIDLevel=-1) => {\n    _s2cellIDLevel = if s2cellIDLevel == -1 then\n        tables\n            |> _detectLevel()\n    else\n        s2cellIDLevel\n    _prepared = if level == _s2cellIDLevel then\n        tables\n            |> duplicate(column: \"s2_cell_id\", as: newColumn)\n    else\n        tables\n            |> map(\n                fn: (r) => ({r with\n                    _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n                }),\n            )\n            |> rename(columns: {_s2_cell_id_xxx: newColumn})\n\n    return _prepared\n        |> group(columns: [newColumn])\n}",
						Start: ast.Position{
							Column: 15,
							Line:   215,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   235,
							},
							File:   "geo.flux",
							Source: "{\n    _s2cellIDLevel = if s2cellIDLevel == -1 then\n        tables\n            |> _detectLevel()\n    else\n        s2cellIDLevel\n    _prepared = if level == _s2cellIDLevel then\n        tables\n            |> duplicate(column: \"s2_cell_id\", as: newColumn)\n    else\n        tables\n            |> map(\n                fn: (r) => ({r with\n                    _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n                }),\n            )\n            |> rename(columns: {_s2_cell_id_xxx: newColumn})\n\n    return _prepared\n        |> group(columns: [newColumn])\n}",
							Start: ast.Position{
								Column: 66,
								Line:   215,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   220,
								},
								File:   "geo.flux",
								Source: "_s2cellIDLevel = if s2cellIDLevel == -1 then\n        tables\n            |> _detectLevel()\n    else\n        s2cellIDLevel",
								Start: ast.Position{
									Column: 5,
									Line:   216,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   216,
									},
									File:   "geo.flux",
									Source: "_s2cellIDLevel",
									Start: ast.Position{
										Column: 5,
										Line:   216,
									},
								},
							},
							Name: "_s2cellIDLevel",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   220,
										},
										File:   "geo.flux",
										Source: "s2cellIDLevel",
										Start: ast.Position{
											Column: 9,
											Line:   220,
										},
									},
								},
								Name: "s2cellIDLevel",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   220,
									},
									File:   "geo.flux",
									Source: "if s2cellIDLevel == -1 then\n        tables\n            |> _detectLevel()\n    else\n        s2cellIDLevel",
									Start: ast.Position{
										Column: 22,
										Line:   216,
									},
								},
							},
							Consequent: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   217,
											},
											File:   "geo.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 9,
												Line:   217,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   218,
										},
										File:   "geo.flux",
										Source: "tables\n            |> _detectLevel()",
										Start: ast.Position{
											Column: 9,
											Line:   217,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   218,
											},
											File:   "geo.flux",
											Source: "_detectLevel()",
											Start: ast.Position{
												Column: 16,
												Line:   218,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   218,
												},
												File:   "geo.flux",
												Source: "_detectLevel",
												Start: ast.Position{
													Column: 16,
													Line:   218,
												},
											},
										},
										Name: "_detectLevel",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   216,
										},
										File:   "geo.flux",
										Source: "s2cellIDLevel == -1",
										Start: ast.Position{
											Column: 25,
											Line:   216,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   216,
											},
											File:   "geo.flux",
											Source: "s2cellIDLevel",
											Start: ast.Position{
												Column: 25,
												Line:   216,
											},
										},
									},
									Name: "s2cellIDLevel",
								},
								Operator: 17,
								Right: &ast.UnaryExpression{
									Argument: &ast.IntegerLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   216,
												},
												File:   "geo.flux",
												Source: "1",
												Start: ast.Position{
													Column: 43,
													Line:   216,
												},
											},
										},
										Value: int64(1),
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   216,
											},
											File:   "geo.flux",
											Source: "-1",
											Start: ast.Position{
												Column: 42,
												Line:   216,
											},
										},
									},
									Operator: 6,
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   231,
								},
								File:   "geo.flux",
								Source: "_prepared = if level == _s2cellIDLevel then\n        tables\n            |> duplicate(column: \"s2_cell_id\", as: newColumn)\n    else\n        tables\n            |> map(\n                fn: (r) => ({r with\n                    _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n                }),\n            )\n            |> rename(columns: {_s2_cell_id_xxx: newColumn})",
								Start: ast.Position{
									Column: 5,
									Line:   221,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   221,
									},
									File:   "geo.flux",
									Source: "_prepared",
									Start: ast.Position{
										Column: 5,
										Line:   221,
									},
								},
							},
							Name: "_prepared",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   225,
												},
												File:   "geo.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 9,
													Line:   225,
												},
											},
										},
										Name: "tables",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   230,
											},
											File:   "geo.flux",
											Source: "tables\n            |> map(\n                fn: (r) => ({r with\n                    _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n                }),\n            )",
											Start: ast.Position{
												Column: 9,
												Line:   225,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   229,
													},
													File:   "geo.flux",
													Source: "fn: (r) => ({r with\n                    _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n                })",
													Start: ast.Position{
														Column: 17,
														Line:   227,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   229,
														},
														File:   "geo.flux",
														Source: "fn: (r) => ({r with\n                    _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n                })",
														Start: ast.Position{
															Column: 17,
															Line:   227,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 19,
																Line:   227,
															},
															File:   "geo.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 17,
																Line:   227,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 19,
																Line:   229,
															},
															File:   "geo.flux",
															Source: "(r) => ({r with\n                    _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n                })",
															Start: ast.Position{
																Column: 21,
																Line:   227,
															},
														},
													},
													Body: &ast.ParenExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 19,
																	Line:   229,
																},
																File:   "geo.flux",
																Source: "({r with\n                    _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n                })",
																Start: ast.Position{
																	Column: 28,
																	Line:   227,
																},
															},
														},
														Expression: &ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   229,
																	},
																	File:   "geo.flux",
																	Source: "{r with\n                    _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n                }",
																	Start: ast.Position{
																		Column: 29,
																		Line:   227,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 98,
																			Line:   228,
																		},
																		File:   "geo.flux",
																		Source: "_s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)",
																		Start: ast.Position{
																			Column: 21,
																			Line:   228,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 36,
																				Line:   228,
																			},
																			File:   "geo.flux",
																			Source: "_s2_cell_id_xxx",
																			Start: ast.Position{
																				Column: 21,
																				Line:   228,
																			},
																		},
																	},
																	Name: "_s2_cell_id_xxx",
																},
																Separator: nil,
																Value: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 97,
																					Line:   228,
																				},
																				File:   "geo.flux",
																				Source: "point: {lat: r.lat, lon: r.lon}, level: level",
																				Start: ast.Position{
																					Column: 52,
																					Line:   228,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 83,
																						Line:   228,
																					},
																					File:   "geo.flux",
																					Source: "point: {lat: r.lat, lon: r.lon}",
																					Start: ast.Position{
																						Column: 52,
																						Line:   228,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 57,
																							Line:   228,
																						},
																						File:   "geo.flux",
																						Source: "point",
																						Start: ast.Position{
																							Column: 52,
																							Line:   228,
																						},
																					},
																				},
																				Name: "point",
																			},
																			Separator: nil,
																			Value: &ast.ObjectExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 83,
																							Line:   228,
																						},
																						File:   "geo.flux",
																						Source: "{lat: r.lat, lon: r.lon}",
																						Start: ast.Position{
																							Column: 59,
																							Line:   228,
																						},
																					},
																				},
																				Lbrace: nil,
																				Properties: []*ast.Property{&ast.Property{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 70,
																								Line:   228,
																							},
																							File:   "geo.flux",
																							Source: "lat: r.lat",
																							Start: ast.Position{
																								Column: 60,
																								Line:   228,
																							},
																						},
																					},
																					Comma: nil,
																					Key: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 63,
																									Line:   228,
																								},
																								File:   "geo.flux",
																								Source: "lat",
																								Start: ast.Position{
																									Column: 60,
																									Line:   228,
																								},
																							},
																						},
																						Name: "lat",
																					},
																					Separator: nil,
																					Value: &ast.MemberExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 70,
																									Line:   228,
																								},
																								File:   "geo.flux",
																								Source: "r.lat",
																								Start: ast.Position{
																									Column: 65,
																									Line:   228,
																								},
																							},
																						},
																						Lbrack: nil,
																						Object: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 66,
																										Line:   228,
																									},
																									File:   "geo.flux",
																									Source: "r",
																									Start: ast.Position{
																										Column: 65,
																										Line:   228,
																									},
																								},
																							},
																							Name: "r",
																						},
																						Property: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 70,
																										Line:   228,
																									},
																									File:   "geo.flux",
																									Source: "lat",
																									Start: ast.Position{
																										Column: 67,
																										Line:   228,
																									},
																								},
																							},
																							Name: "lat",
																						},
																						Rbrack: nil,
																					},
																				}, &ast.Property{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 82,
																								Line:   228,
																							},
																							File:   "geo.flux",
																							Source: "lon: r.lon",
																							Start: ast.Position{
																								Column: 72,
																								Line:   228,
																							},
																						},
																					},
																					Comma: nil,
																					Key: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 75,
																									Line:   228,
																								},
																								File:   "geo.flux",
																								Source: "lon",
																								Start: ast.Position{
																									Column: 72,
																									Line:   228,
																								},
																							},
																						},
																						Name: "lon",
																					},
																					Separator: nil,
																					Value: &ast.MemberExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 82,
																									Line:   228,
																								},
																								File:   "geo.flux",
																								Source: "r.lon",
																								Start: ast.Position{
																									Column: 77,
																									Line:   228,
																								},
																							},
																						},
																						Lbrack: nil,
																						Object: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 78,
																										Line:   228,
																									},
																									File:   "geo.flux",
																									Source: "r",
																									Start: ast.Position{
																										Column: 77,
																										Line:   228,
																									},
																								},
																							},
																							Name: "r",
																						},
																						Property: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 82,
																										Line:   228,
																									},
																									File:   "geo.flux",
																									Source: "lon",
																									Start: ast.Position{
																										Column: 79,
																										Line:   228,
																									},
																								},
																							},
																							Name: "lon",
																						},
																						Rbrack: nil,
																					},
																				}},
																				Rbrace: nil,
																				With:   nil,
																			},
																		}, &ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 97,
																						Line:   228,
																					},
																					File:   "geo.flux",
																					Source: "level: level",
																					Start: ast.Position{
																						Column: 85,
																						Line:   228,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 90,
																							Line:   228,
																						},
																						File:   "geo.flux",
																						Source: "level",
																						Start: ast.Position{
																							Column: 85,
																							Line:   228,
																						},
																					},
																				},
																				Name: "level",
																			},
																			Separator: nil,
																			Value: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 97,
																							Line:   228,
																						},
																						File:   "geo.flux",
																						Source: "level",
																						Start: ast.Position{
																							Column: 92,
																							Line:   228,
																						},
																					},
																				},
																				Name: "level",
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 98,
																				Line:   228,
																			},
																			File:   "geo.flux",
																			Source: "s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level)",
																			Start: ast.Position{
																				Column: 38,
																				Line:   228,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 51,
																					Line:   228,
																				},
																				File:   "geo.flux",
																				Source: "s2CellIDToken",
																				Start: ast.Position{
																					Column: 38,
																					Line:   228,
																				},
																			},
																		},
																		Name: "s2CellIDToken",
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
															}},
															Rbrace: nil,
															With: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   227,
																		},
																		File:   "geo.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 30,
																			Line:   227,
																		},
																	},
																},
																Name: "r",
															},
														},
														Lparen: nil,
														Rparen: nil,
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   227,
																},
																File:   "geo.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 22,
																	Line:   227,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 23,
																		Line:   227,
																	},
																	File:   "geo.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 22,
																		Line:   227,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   230,
												},
												File:   "geo.flux",
												Source: "map(\n                fn: (r) => ({r with\n                    _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n                }),\n            )",
												Start: ast.Position{
													Column: 16,
													Line:   226,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   226,
													},
													File:   "geo.flux",
													Source: "map",
													Start: ast.Position{
														Column: 16,
														Line:   226,
													},
												},
											},
											Name: "map",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 61,
											Line:   231,
										},
										File:   "geo.flux",
										Source: "tables\n            |> map(\n                fn: (r) => ({r with\n                    _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n                }),\n            )\n            |> rename(columns: {_s2_cell_id_xxx: newColumn})",
										Start: ast.Position{
											Column: 9,
											Line:   225,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   231,
												},
												File:   "geo.flux",
												Source: "columns: {_s2_cell_id_xxx: newColumn}",
												Start: ast.Position{
													Column: 23,
													Line:   231,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   231,
													},
													File:   "geo.flux",
													Source: "columns: {_s2_cell_id_xxx: newColumn}",
													Start: ast.Position{
														Column: 23,
														Line:   231,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   231,
														},
														File:   "geo.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 23,
															Line:   231,
														},
													},
												},
												Name: "columns",
											},
											Separator: nil,
											Value: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 60,
															Line:   231,
														},
														File:   "geo.flux",
														Source: "{_s2_cell_id_xxx: newColumn}",
														Start: ast.Position{
															Column: 32,
															Line:   231,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 59,
																Line:   231,
															},
															File:   "geo.flux",
															Source: "_s2_cell_id_xxx: newColumn",
															Start: ast.Position{
																Column: 33,
																Line:   231,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 48,
																	Line:   231,
																},
																File:   "geo.flux",
																Source: "_s2_cell_id_xxx",
																Start: ast.Position{
																	Column: 33,
																	Line:   231,
																},
															},
														},
														Name: "_s2_cell_id_xxx",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 59,
																	Line:   231,
																},
																File:   "geo.flux",
																Source: "newColumn",
																Start: ast.Position{
																	Column: 50,
																	Line:   231,
																},
															},
														},
														Name: "newColumn",
													},
												}},
												Rbrace: nil,
												With:   nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 61,
												Line:   231,
											},
											File:   "geo.flux",
											Source: "rename(columns: {_s2_cell_id_xxx: newColumn})",
											Start: ast.Position{
												Column: 16,
												Line:   231,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   231,
												},
												File:   "geo.flux",
												Source: "rename",
												Start: ast.Position{
													Column: 16,
													Line:   231,
												},
											},
										},
										Name: "rename",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 61,
										Line:   231,
									},
									File:   "geo.flux",
									Source: "if level == _s2cellIDLevel then\n        tables\n            |> duplicate(column: \"s2_cell_id\", as: newColumn)\n    else\n        tables\n            |> map(\n                fn: (r) => ({r with\n                    _s2_cell_id_xxx: s2CellIDToken(point: {lat: r.lat, lon: r.lon}, level: level),\n                }),\n            )\n            |> rename(columns: {_s2_cell_id_xxx: newColumn})",
									Start: ast.Position{
										Column: 17,
										Line:   221,
									},
								},
							},
							Consequent: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   222,
											},
											File:   "geo.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 9,
												Line:   222,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 62,
											Line:   223,
										},
										File:   "geo.flux",
										Source: "tables\n            |> duplicate(column: \"s2_cell_id\", as: newColumn)",
										Start: ast.Position{
											Column: 9,
											Line:   222,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 61,
													Line:   223,
												},
												File:   "geo.flux",
												Source: "column: \"s2_cell_id\", as: newColumn",
												Start: ast.Position{
													Column: 26,
													Line:   223,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   223,
													},
													File:   "geo.flux",
													Source: "column: \"s2_cell_id\"",
													Start: ast.Position{
														Column: 26,
														Line:   223,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   223,
														},
														File:   "geo.flux",
														Source: "column",
														Start: ast.Position{
															Column: 26,
															Line:   223,
														},
													},
												},
												Name: "column",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   223,
														},
														File:   "geo.flux",
														Source: "\"s2_cell_id\"",
														Start: ast.Position{
															Column: 34,
															Line:   223,
														},
													},
												},
												Value: "s2_cell_id",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   223,
													},
													File:   "geo.flux",
													Source: "as: newColumn",
													Start: ast.Position{
														Column: 48,
														Line:   223,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   223,
														},
														File:   "geo.flux",
														Source: "as",
														Start: ast.Position{
															Column: 48,
															Line:   223,
														},
													},
												},
												Name: "as",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   223,
														},
														File:   "geo.flux",
														Source: "newColumn",
														Start: ast.Position{
															Column: 52,
															Line:   223,
														},
													},
												},
												Name: "newColumn",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 62,
												Line:   223,
											},
											File:   "geo.flux",
											Source: "duplicate(column: \"s2_cell_id\", as: newColumn)",
											Start: ast.Position{
												Column: 16,
												Line:   223,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   223,
												},
												File:   "geo.flux",
												Source: "duplicate",
												Start: ast.Position{
													Column: 16,
													Line:   223,
												},
											},
										},
										Name: "duplicate",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   221,
										},
										File:   "geo.flux",
										Source: "level == _s2cellIDLevel",
										Start: ast.Position{
											Column: 20,
											Line:   221,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   221,
											},
											File:   "geo.flux",
											Source: "level",
											Start: ast.Position{
												Column: 20,
												Line:   221,
											},
										},
									},
									Name: "level",
								},
								Operator: 17,
								Right: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   221,
											},
											File:   "geo.flux",
											Source: "_s2cellIDLevel",
											Start: ast.Position{
												Column: 29,
												Line:   221,
											},
										},
									},
									Name: "_s2cellIDLevel",
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   233,
										},
										File:   "geo.flux",
										Source: "_prepared",
										Start: ast.Position{
											Column: 12,
											Line:   233,
										},
									},
								},
								Name: "_prepared",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   234,
									},
									File:   "geo.flux",
									Source: "_prepared\n        |> group(columns: [newColumn])",
									Start: ast.Position{
										Column: 12,
										Line:   233,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   234,
											},
											File:   "geo.flux",
											Source: "columns: [newColumn]",
											Start: ast.Position{
												Column: 18,
												Line:   234,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   234,
												},
												File:   "geo.flux",
												Source: "columns: [newColumn]",
												Start: ast.Position{
													Column: 18,
													Line:   234,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   234,
													},
													File:   "geo.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 18,
														Line:   234,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   234,
													},
													File:   "geo.flux",
													Source: "[newColumn]",
													Start: ast.Position{
														Column: 27,
														Line:   234,
													},
												},
											},
											Elements: []ast.Expression{&ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   234,
														},
														File:   "geo.flux",
														Source: "newColumn",
														Start: ast.Position{
															Column: 28,
															Line:   234,
														},
													},
												},
												Name: "newColumn",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   234,
										},
										File:   "geo.flux",
										Source: "group(columns: [newColumn])",
										Start: ast.Position{
											Column: 12,
											Line:   234,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   234,
											},
											File:   "geo.flux",
											Source: "group",
											Start: ast.Position{
												Column: 12,
												Line:   234,
											},
										},
									},
									Name: "group",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   234,
								},
								File:   "geo.flux",
								Source: "return _prepared\n        |> group(columns: [newColumn])",
								Start: ast.Position{
									Column: 5,
									Line:   233,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   215,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 16,
								Line:   215,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   215,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 16,
									Line:   215,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   215,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 23,
								Line:   215,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   215,
							},
							File:   "geo.flux",
							Source: "newColumn",
							Start: ast.Position{
								Column: 27,
								Line:   215,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   215,
								},
								File:   "geo.flux",
								Source: "newColumn",
								Start: ast.Position{
									Column: 27,
									Line:   215,
								},
							},
						},
						Name: "newColumn",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   215,
							},
							File:   "geo.flux",
							Source: "level",
							Start: ast.Position{
								Column: 38,
								Line:   215,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   215,
								},
								File:   "geo.flux",
								Source: "level",
								Start: ast.Position{
									Column: 38,
									Line:   215,
								},
							},
						},
						Name: "level",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 61,
								Line:   215,
							},
							File:   "geo.flux",
							Source: "s2cellIDLevel=-1",
							Start: ast.Position{
								Column: 45,
								Line:   215,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   215,
								},
								File:   "geo.flux",
								Source: "s2cellIDLevel",
								Start: ast.Position{
									Column: 45,
									Line:   215,
								},
							},
						},
						Name: "s2cellIDLevel",
					},
					Separator: nil,
					Value: &ast.UnaryExpression{
						Argument: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 61,
										Line:   215,
									},
									File:   "geo.flux",
									Source: "1",
									Start: ast.Position{
										Column: 60,
										Line:   215,
									},
								},
							},
							Value: int64(1),
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   215,
								},
								File:   "geo.flux",
								Source: "-1",
								Start: ast.Position{
									Column: 59,
									Line:   215,
								},
							},
						},
						Operator: 6,
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 30,
						Line:   240,
					},
					File:   "geo.flux",
					Source: "asTracks = (tables=<-, groupBy=[\"id\", \"tid\"], orderBy=[\"_time\"]) => tables\n    |> group(columns: groupBy)\n    |> sort(columns: orderBy)",
					Start: ast.Position{
						Column: 1,
						Line:   238,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Groups rows into tracks.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   238,
						},
						File:   "geo.flux",
						Source: "asTracks",
						Start: ast.Position{
							Column: 1,
							Line:   238,
						},
					},
				},
				Name: "asTracks",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   240,
						},
						File:   "geo.flux",
						Source: "(tables=<-, groupBy=[\"id\", \"tid\"], orderBy=[\"_time\"]) => tables\n    |> group(columns: groupBy)\n    |> sort(columns: orderBy)",
						Start: ast.Position{
							Column: 12,
							Line:   238,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   238,
									},
									File:   "geo.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 69,
										Line:   238,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   239,
								},
								File:   "geo.flux",
								Source: "tables\n    |> group(columns: groupBy)",
								Start: ast.Position{
									Column: 69,
									Line:   238,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   239,
										},
										File:   "geo.flux",
										Source: "columns: groupBy",
										Start: ast.Position{
											Column: 14,
											Line:   239,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   239,
											},
											File:   "geo.flux",
											Source: "columns: groupBy",
											Start: ast.Position{
												Column: 14,
												Line:   239,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   239,
												},
												File:   "geo.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 14,
													Line:   239,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   239,
												},
												File:   "geo.flux",
												Source: "groupBy",
												Start: ast.Position{
													Column: 23,
													Line:   239,
												},
											},
										},
										Name: "groupBy",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   239,
									},
									File:   "geo.flux",
									Source: "group(columns: groupBy)",
									Start: ast.Position{
										Column: 8,
										Line:   239,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   239,
										},
										File:   "geo.flux",
										Source: "group",
										Start: ast.Position{
											Column: 8,
											Line:   239,
										},
									},
								},
								Name: "group",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   240,
							},
							File:   "geo.flux",
							Source: "tables\n    |> group(columns: groupBy)\n    |> sort(columns: orderBy)",
							Start: ast.Position{
								Column: 69,
								Line:   238,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   240,
									},
									File:   "geo.flux",
									Source: "columns: orderBy",
									Start: ast.Position{
										Column: 13,
										Line:   240,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   240,
										},
										File:   "geo.flux",
										Source: "columns: orderBy",
										Start: ast.Position{
											Column: 13,
											Line:   240,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   240,
											},
											File:   "geo.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 13,
												Line:   240,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   240,
											},
											File:   "geo.flux",
											Source: "orderBy",
											Start: ast.Position{
												Column: 22,
												Line:   240,
											},
										},
									},
									Name: "orderBy",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   240,
								},
								File:   "geo.flux",
								Source: "sort(columns: orderBy)",
								Start: ast.Position{
									Column: 8,
									Line:   240,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   240,
									},
									File:   "geo.flux",
									Source: "sort",
									Start: ast.Position{
										Column: 8,
										Line:   240,
									},
								},
							},
							Name: "sort",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   238,
							},
							File:   "geo.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 13,
								Line:   238,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   238,
								},
								File:   "geo.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 13,
									Line:   238,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   238,
							},
							File:   "geo.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 20,
								Line:   238,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 45,
								Line:   238,
							},
							File:   "geo.flux",
							Source: "groupBy=[\"id\", \"tid\"]",
							Start: ast.Position{
								Column: 24,
								Line:   238,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   238,
								},
								File:   "geo.flux",
								Source: "groupBy",
								Start: ast.Position{
									Column: 24,
									Line:   238,
								},
							},
						},
						Name: "groupBy",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   238,
								},
								File:   "geo.flux",
								Source: "[\"id\", \"tid\"]",
								Start: ast.Position{
									Column: 32,
									Line:   238,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   238,
									},
									File:   "geo.flux",
									Source: "\"id\"",
									Start: ast.Position{
										Column: 33,
										Line:   238,
									},
								},
							},
							Value: "id",
						}, &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   238,
									},
									File:   "geo.flux",
									Source: "\"tid\"",
									Start: ast.Position{
										Column: 39,
										Line:   238,
									},
								},
							},
							Value: "tid",
						}},
						Lbrack: nil,
						Rbrack: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 64,
								Line:   238,
							},
							File:   "geo.flux",
							Source: "orderBy=[\"_time\"]",
							Start: ast.Position{
								Column: 47,
								Line:   238,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   238,
								},
								File:   "geo.flux",
								Source: "orderBy",
								Start: ast.Position{
									Column: 47,
									Line:   238,
								},
							},
						},
						Name: "orderBy",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   238,
								},
								File:   "geo.flux",
								Source: "[\"_time\"]",
								Start: ast.Position{
									Column: 55,
									Line:   238,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   238,
									},
									File:   "geo.flux",
									Source: "\"_time\"",
									Start: ast.Position{
										Column: 56,
										Line:   238,
									},
								},
							},
							Value: "_time",
						}},
						Lbrack: nil,
						Rbrack: nil,
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   5,
					},
					File:   "geo.flux",
					Source: "import \"experimental\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   5,
						},
						File:   "geo.flux",
						Source: "\"experimental\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "experimental",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 32,
						Line:   6,
					},
					File:   "geo.flux",
					Source: "import \"influxdata/influxdb/v1\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   6,
						},
						File:   "geo.flux",
						Source: "\"influxdata/influxdb/v1\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "influxdata/influxdb/v1",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "geo.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Provides functions for geographic location filtering and grouping based on S2 cells.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   2,
					},
					File:   "geo.flux",
					Source: "package geo",
					Start: ast.Position{
						Column: 1,
						Line:   2,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   2,
						},
						File:   "geo.flux",
						Source: "geo",
						Start: ast.Position{
							Column: 9,
							Line:   2,
						},
					},
				},
				Name: "geo",
			},
		},
	}},
	Package: "geo",
	Path:    "experimental/geo",
}
