// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/dataplex/v1/logs.proto

package dataplex

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of the event.
type DiscoveryEvent_EventType int32

const (
	// An unspecified event type.
	DiscoveryEvent_EVENT_TYPE_UNSPECIFIED DiscoveryEvent_EventType = 0
	// An event representing discovery configuration in effect.
	DiscoveryEvent_CONFIG DiscoveryEvent_EventType = 1
	// An event representing a metadata entity being created.
	DiscoveryEvent_ENTITY_CREATED DiscoveryEvent_EventType = 2
	// An event representing a metadata entity being updated.
	DiscoveryEvent_ENTITY_UPDATED DiscoveryEvent_EventType = 3
	// An event representing a metadata entity being deleted.
	DiscoveryEvent_ENTITY_DELETED DiscoveryEvent_EventType = 4
	// An event representing a partition being created.
	DiscoveryEvent_PARTITION_CREATED DiscoveryEvent_EventType = 5
	// An event representing a partition being updated.
	DiscoveryEvent_PARTITION_UPDATED DiscoveryEvent_EventType = 6
	// An event representing a partition being deleted.
	DiscoveryEvent_PARTITION_DELETED DiscoveryEvent_EventType = 7
)

// Enum value maps for DiscoveryEvent_EventType.
var (
	DiscoveryEvent_EventType_name = map[int32]string{
		0: "EVENT_TYPE_UNSPECIFIED",
		1: "CONFIG",
		2: "ENTITY_CREATED",
		3: "ENTITY_UPDATED",
		4: "ENTITY_DELETED",
		5: "PARTITION_CREATED",
		6: "PARTITION_UPDATED",
		7: "PARTITION_DELETED",
	}
	DiscoveryEvent_EventType_value = map[string]int32{
		"EVENT_TYPE_UNSPECIFIED": 0,
		"CONFIG":                 1,
		"ENTITY_CREATED":         2,
		"ENTITY_UPDATED":         3,
		"ENTITY_DELETED":         4,
		"PARTITION_CREATED":      5,
		"PARTITION_UPDATED":      6,
		"PARTITION_DELETED":      7,
	}
)

func (x DiscoveryEvent_EventType) Enum() *DiscoveryEvent_EventType {
	p := new(DiscoveryEvent_EventType)
	*p = x
	return p
}

func (x DiscoveryEvent_EventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DiscoveryEvent_EventType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[0].Descriptor()
}

func (DiscoveryEvent_EventType) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[0]
}

func (x DiscoveryEvent_EventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DiscoveryEvent_EventType.Descriptor instead.
func (DiscoveryEvent_EventType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{0, 0}
}

// The type of the entity.
type DiscoveryEvent_EntityType int32

const (
	// An unspecified event type.
	DiscoveryEvent_ENTITY_TYPE_UNSPECIFIED DiscoveryEvent_EntityType = 0
	// Entities representing structured data.
	DiscoveryEvent_TABLE DiscoveryEvent_EntityType = 1
	// Entities representing unstructured data.
	DiscoveryEvent_FILESET DiscoveryEvent_EntityType = 2
)

// Enum value maps for DiscoveryEvent_EntityType.
var (
	DiscoveryEvent_EntityType_name = map[int32]string{
		0: "ENTITY_TYPE_UNSPECIFIED",
		1: "TABLE",
		2: "FILESET",
	}
	DiscoveryEvent_EntityType_value = map[string]int32{
		"ENTITY_TYPE_UNSPECIFIED": 0,
		"TABLE":                   1,
		"FILESET":                 2,
	}
)

func (x DiscoveryEvent_EntityType) Enum() *DiscoveryEvent_EntityType {
	p := new(DiscoveryEvent_EntityType)
	*p = x
	return p
}

func (x DiscoveryEvent_EntityType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DiscoveryEvent_EntityType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[1].Descriptor()
}

func (DiscoveryEvent_EntityType) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[1]
}

func (x DiscoveryEvent_EntityType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DiscoveryEvent_EntityType.Descriptor instead.
func (DiscoveryEvent_EntityType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{0, 1}
}

// The type of the job.
type JobEvent_Type int32

const (
	// Unspecified job type.
	JobEvent_TYPE_UNSPECIFIED JobEvent_Type = 0
	// Spark jobs.
	JobEvent_SPARK JobEvent_Type = 1
	// Notebook jobs.
	JobEvent_NOTEBOOK JobEvent_Type = 2
)

// Enum value maps for JobEvent_Type.
var (
	JobEvent_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "SPARK",
		2: "NOTEBOOK",
	}
	JobEvent_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"SPARK":            1,
		"NOTEBOOK":         2,
	}
)

func (x JobEvent_Type) Enum() *JobEvent_Type {
	p := new(JobEvent_Type)
	*p = x
	return p
}

func (x JobEvent_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobEvent_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[2].Descriptor()
}

func (JobEvent_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[2]
}

func (x JobEvent_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobEvent_Type.Descriptor instead.
func (JobEvent_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{1, 0}
}

// The completion status of the job.
type JobEvent_State int32

const (
	// Unspecified job state.
	JobEvent_STATE_UNSPECIFIED JobEvent_State = 0
	// Job successfully completed.
	JobEvent_SUCCEEDED JobEvent_State = 1
	// Job was unsuccessful.
	JobEvent_FAILED JobEvent_State = 2
	// Job was cancelled by the user.
	JobEvent_CANCELLED JobEvent_State = 3
	// Job was cancelled or aborted via the service executing the job.
	JobEvent_ABORTED JobEvent_State = 4
)

// Enum value maps for JobEvent_State.
var (
	JobEvent_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "SUCCEEDED",
		2: "FAILED",
		3: "CANCELLED",
		4: "ABORTED",
	}
	JobEvent_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"SUCCEEDED":         1,
		"FAILED":            2,
		"CANCELLED":         3,
		"ABORTED":           4,
	}
)

func (x JobEvent_State) Enum() *JobEvent_State {
	p := new(JobEvent_State)
	*p = x
	return p
}

func (x JobEvent_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobEvent_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[3].Descriptor()
}

func (JobEvent_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[3]
}

func (x JobEvent_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobEvent_State.Descriptor instead.
func (JobEvent_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{1, 1}
}

// The service used to execute the job.
type JobEvent_Service int32

const (
	// Unspecified service.
	JobEvent_SERVICE_UNSPECIFIED JobEvent_Service = 0
	// Cloud Dataproc.
	JobEvent_DATAPROC JobEvent_Service = 1
)

// Enum value maps for JobEvent_Service.
var (
	JobEvent_Service_name = map[int32]string{
		0: "SERVICE_UNSPECIFIED",
		1: "DATAPROC",
	}
	JobEvent_Service_value = map[string]int32{
		"SERVICE_UNSPECIFIED": 0,
		"DATAPROC":            1,
	}
)

func (x JobEvent_Service) Enum() *JobEvent_Service {
	p := new(JobEvent_Service)
	*p = x
	return p
}

func (x JobEvent_Service) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobEvent_Service) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[4].Descriptor()
}

func (JobEvent_Service) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[4]
}

func (x JobEvent_Service) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobEvent_Service.Descriptor instead.
func (JobEvent_Service) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{1, 2}
}

// The type of the event.
type SessionEvent_EventType int32

const (
	// An unspecified event type.
	SessionEvent_EVENT_TYPE_UNSPECIFIED SessionEvent_EventType = 0
	// Event for start of a session.
	SessionEvent_START SessionEvent_EventType = 1
	// Event for stop of a session.
	SessionEvent_STOP SessionEvent_EventType = 2
	// Query events in the session.
	SessionEvent_QUERY SessionEvent_EventType = 3
)

// Enum value maps for SessionEvent_EventType.
var (
	SessionEvent_EventType_name = map[int32]string{
		0: "EVENT_TYPE_UNSPECIFIED",
		1: "START",
		2: "STOP",
		3: "QUERY",
	}
	SessionEvent_EventType_value = map[string]int32{
		"EVENT_TYPE_UNSPECIFIED": 0,
		"START":                  1,
		"STOP":                   2,
		"QUERY":                  3,
	}
)

func (x SessionEvent_EventType) Enum() *SessionEvent_EventType {
	p := new(SessionEvent_EventType)
	*p = x
	return p
}

func (x SessionEvent_EventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SessionEvent_EventType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[5].Descriptor()
}

func (SessionEvent_EventType) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[5]
}

func (x SessionEvent_EventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SessionEvent_EventType.Descriptor instead.
func (SessionEvent_EventType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{2, 0}
}

// Query Execution engine.
type SessionEvent_QueryDetail_Engine int32

const (
	// An unspecified Engine type.
	SessionEvent_QueryDetail_ENGINE_UNSPECIFIED SessionEvent_QueryDetail_Engine = 0
	// Spark-sql engine is specified in Query.
	SessionEvent_QueryDetail_SPARK_SQL SessionEvent_QueryDetail_Engine = 1
	// BigQuery engine is specified in Query.
	SessionEvent_QueryDetail_BIGQUERY SessionEvent_QueryDetail_Engine = 2
)

// Enum value maps for SessionEvent_QueryDetail_Engine.
var (
	SessionEvent_QueryDetail_Engine_name = map[int32]string{
		0: "ENGINE_UNSPECIFIED",
		1: "SPARK_SQL",
		2: "BIGQUERY",
	}
	SessionEvent_QueryDetail_Engine_value = map[string]int32{
		"ENGINE_UNSPECIFIED": 0,
		"SPARK_SQL":          1,
		"BIGQUERY":           2,
	}
)

func (x SessionEvent_QueryDetail_Engine) Enum() *SessionEvent_QueryDetail_Engine {
	p := new(SessionEvent_QueryDetail_Engine)
	*p = x
	return p
}

func (x SessionEvent_QueryDetail_Engine) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SessionEvent_QueryDetail_Engine) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_logs_proto_enumTypes[6].Descriptor()
}

func (SessionEvent_QueryDetail_Engine) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_logs_proto_enumTypes[6]
}

func (x SessionEvent_QueryDetail_Engine) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SessionEvent_QueryDetail_Engine.Descriptor instead.
func (SessionEvent_QueryDetail_Engine) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{2, 0, 0}
}

// The payload associated with Discovery data processing.
type DiscoveryEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The log message.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// The id of the associated lake.
	LakeId string `protobuf:"bytes,2,opt,name=lake_id,json=lakeId,proto3" json:"lake_id,omitempty"`
	// The id of the associated zone.
	ZoneId string `protobuf:"bytes,3,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// The id of the associated asset.
	AssetId string `protobuf:"bytes,4,opt,name=asset_id,json=assetId,proto3" json:"asset_id,omitempty"`
	// The data location associated with the event.
	DataLocation string `protobuf:"bytes,5,opt,name=data_location,json=dataLocation,proto3" json:"data_location,omitempty"`
	// The type of the event being logged.
	Type DiscoveryEvent_EventType `protobuf:"varint,10,opt,name=type,proto3,enum=google.cloud.dataplex.v1.DiscoveryEvent_EventType" json:"type,omitempty"`
	// Additional details about the event.
	//
	// Types that are assignable to Details:
	//	*DiscoveryEvent_Config
	//	*DiscoveryEvent_Entity
	//	*DiscoveryEvent_Partition
	//	*DiscoveryEvent_Action
	Details isDiscoveryEvent_Details `protobuf_oneof:"details"`
}

func (x *DiscoveryEvent) Reset() {
	*x = DiscoveryEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryEvent) ProtoMessage() {}

func (x *DiscoveryEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryEvent.ProtoReflect.Descriptor instead.
func (*DiscoveryEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{0}
}

func (x *DiscoveryEvent) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *DiscoveryEvent) GetLakeId() string {
	if x != nil {
		return x.LakeId
	}
	return ""
}

func (x *DiscoveryEvent) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *DiscoveryEvent) GetAssetId() string {
	if x != nil {
		return x.AssetId
	}
	return ""
}

func (x *DiscoveryEvent) GetDataLocation() string {
	if x != nil {
		return x.DataLocation
	}
	return ""
}

func (x *DiscoveryEvent) GetType() DiscoveryEvent_EventType {
	if x != nil {
		return x.Type
	}
	return DiscoveryEvent_EVENT_TYPE_UNSPECIFIED
}

func (m *DiscoveryEvent) GetDetails() isDiscoveryEvent_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (x *DiscoveryEvent) GetConfig() *DiscoveryEvent_ConfigDetails {
	if x, ok := x.GetDetails().(*DiscoveryEvent_Config); ok {
		return x.Config
	}
	return nil
}

func (x *DiscoveryEvent) GetEntity() *DiscoveryEvent_EntityDetails {
	if x, ok := x.GetDetails().(*DiscoveryEvent_Entity); ok {
		return x.Entity
	}
	return nil
}

func (x *DiscoveryEvent) GetPartition() *DiscoveryEvent_PartitionDetails {
	if x, ok := x.GetDetails().(*DiscoveryEvent_Partition); ok {
		return x.Partition
	}
	return nil
}

func (x *DiscoveryEvent) GetAction() *DiscoveryEvent_ActionDetails {
	if x, ok := x.GetDetails().(*DiscoveryEvent_Action); ok {
		return x.Action
	}
	return nil
}

type isDiscoveryEvent_Details interface {
	isDiscoveryEvent_Details()
}

type DiscoveryEvent_Config struct {
	// Details about discovery configuration in effect.
	Config *DiscoveryEvent_ConfigDetails `protobuf:"bytes,20,opt,name=config,proto3,oneof"`
}

type DiscoveryEvent_Entity struct {
	// Details about the entity associated with the event.
	Entity *DiscoveryEvent_EntityDetails `protobuf:"bytes,21,opt,name=entity,proto3,oneof"`
}

type DiscoveryEvent_Partition struct {
	// Details about the partition associated with the event.
	Partition *DiscoveryEvent_PartitionDetails `protobuf:"bytes,22,opt,name=partition,proto3,oneof"`
}

type DiscoveryEvent_Action struct {
	// Details about the action associated with the event.
	Action *DiscoveryEvent_ActionDetails `protobuf:"bytes,23,opt,name=action,proto3,oneof"`
}

func (*DiscoveryEvent_Config) isDiscoveryEvent_Details() {}

func (*DiscoveryEvent_Entity) isDiscoveryEvent_Details() {}

func (*DiscoveryEvent_Partition) isDiscoveryEvent_Details() {}

func (*DiscoveryEvent_Action) isDiscoveryEvent_Details() {}

// The payload associated with Job logs that contains events describing jobs
// that have run within a Lake.
type JobEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The log message.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// The unique id identifying the job.
	JobId string `protobuf:"bytes,2,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// The time when the job started running.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time when the job ended running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The job state on completion.
	State JobEvent_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.dataplex.v1.JobEvent_State" json:"state,omitempty"`
	// The number of retries.
	Retries int32 `protobuf:"varint,6,opt,name=retries,proto3" json:"retries,omitempty"`
	// The type of the job.
	Type JobEvent_Type `protobuf:"varint,7,opt,name=type,proto3,enum=google.cloud.dataplex.v1.JobEvent_Type" json:"type,omitempty"`
	// The service used to execute the job.
	Service JobEvent_Service `protobuf:"varint,8,opt,name=service,proto3,enum=google.cloud.dataplex.v1.JobEvent_Service" json:"service,omitempty"`
	// The reference to the job within the service.
	ServiceJob string `protobuf:"bytes,9,opt,name=service_job,json=serviceJob,proto3" json:"service_job,omitempty"`
}

func (x *JobEvent) Reset() {
	*x = JobEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobEvent) ProtoMessage() {}

func (x *JobEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobEvent.ProtoReflect.Descriptor instead.
func (*JobEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{1}
}

func (x *JobEvent) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *JobEvent) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *JobEvent) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *JobEvent) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *JobEvent) GetState() JobEvent_State {
	if x != nil {
		return x.State
	}
	return JobEvent_STATE_UNSPECIFIED
}

func (x *JobEvent) GetRetries() int32 {
	if x != nil {
		return x.Retries
	}
	return 0
}

func (x *JobEvent) GetType() JobEvent_Type {
	if x != nil {
		return x.Type
	}
	return JobEvent_TYPE_UNSPECIFIED
}

func (x *JobEvent) GetService() JobEvent_Service {
	if x != nil {
		return x.Service
	}
	return JobEvent_SERVICE_UNSPECIFIED
}

func (x *JobEvent) GetServiceJob() string {
	if x != nil {
		return x.ServiceJob
	}
	return ""
}

// These messages contain information about sessions within an environment.
// The monitored resource is 'Environment'.
type SessionEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The log message.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// The information about the user that created the session.
	UserId string `protobuf:"bytes,2,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Unique identifier for the session.
	SessionId string `protobuf:"bytes,3,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
	// The type of the event.
	Type SessionEvent_EventType `protobuf:"varint,4,opt,name=type,proto3,enum=google.cloud.dataplex.v1.SessionEvent_EventType" json:"type,omitempty"`
	// Additional information about the Query metadata.
	//
	// Types that are assignable to Detail:
	//	*SessionEvent_Query
	Detail isSessionEvent_Detail `protobuf_oneof:"detail"`
}

func (x *SessionEvent) Reset() {
	*x = SessionEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionEvent) ProtoMessage() {}

func (x *SessionEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionEvent.ProtoReflect.Descriptor instead.
func (*SessionEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{2}
}

func (x *SessionEvent) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *SessionEvent) GetUserId() string {
	if x != nil {
		return x.UserId
	}
	return ""
}

func (x *SessionEvent) GetSessionId() string {
	if x != nil {
		return x.SessionId
	}
	return ""
}

func (x *SessionEvent) GetType() SessionEvent_EventType {
	if x != nil {
		return x.Type
	}
	return SessionEvent_EVENT_TYPE_UNSPECIFIED
}

func (m *SessionEvent) GetDetail() isSessionEvent_Detail {
	if m != nil {
		return m.Detail
	}
	return nil
}

func (x *SessionEvent) GetQuery() *SessionEvent_QueryDetail {
	if x, ok := x.GetDetail().(*SessionEvent_Query); ok {
		return x.Query
	}
	return nil
}

type isSessionEvent_Detail interface {
	isSessionEvent_Detail()
}

type SessionEvent_Query struct {
	// The execution details of the query.
	Query *SessionEvent_QueryDetail `protobuf:"bytes,5,opt,name=query,proto3,oneof"`
}

func (*SessionEvent_Query) isSessionEvent_Detail() {}

// Details about configuration events.
type DiscoveryEvent_ConfigDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of discovery configuration parameters in effect.
	// The keys are the field paths within DiscoverySpec.
	// Eg. includePatterns, excludePatterns, csvOptions.disableTypeInference,
	// etc.
	Parameters map[string]string `protobuf:"bytes,1,rep,name=parameters,proto3" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *DiscoveryEvent_ConfigDetails) Reset() {
	*x = DiscoveryEvent_ConfigDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryEvent_ConfigDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryEvent_ConfigDetails) ProtoMessage() {}

func (x *DiscoveryEvent_ConfigDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryEvent_ConfigDetails.ProtoReflect.Descriptor instead.
func (*DiscoveryEvent_ConfigDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{0, 0}
}

func (x *DiscoveryEvent_ConfigDetails) GetParameters() map[string]string {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// Details about the entity.
type DiscoveryEvent_EntityDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the entity resource.
	// The name is the fully-qualified resource name.
	Entity string `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// The type of the entity resource.
	Type DiscoveryEvent_EntityType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.dataplex.v1.DiscoveryEvent_EntityType" json:"type,omitempty"`
}

func (x *DiscoveryEvent_EntityDetails) Reset() {
	*x = DiscoveryEvent_EntityDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryEvent_EntityDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryEvent_EntityDetails) ProtoMessage() {}

func (x *DiscoveryEvent_EntityDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryEvent_EntityDetails.ProtoReflect.Descriptor instead.
func (*DiscoveryEvent_EntityDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{0, 1}
}

func (x *DiscoveryEvent_EntityDetails) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *DiscoveryEvent_EntityDetails) GetType() DiscoveryEvent_EntityType {
	if x != nil {
		return x.Type
	}
	return DiscoveryEvent_ENTITY_TYPE_UNSPECIFIED
}

// Details about the partition.
type DiscoveryEvent_PartitionDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name to the partition resource.
	// The name is the fully-qualified resource name.
	Partition string `protobuf:"bytes,1,opt,name=partition,proto3" json:"partition,omitempty"`
	// The name to the containing entity resource.
	// The name is the fully-qualified resource name.
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// The type of the containing entity resource.
	Type DiscoveryEvent_EntityType `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.dataplex.v1.DiscoveryEvent_EntityType" json:"type,omitempty"`
}

func (x *DiscoveryEvent_PartitionDetails) Reset() {
	*x = DiscoveryEvent_PartitionDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryEvent_PartitionDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryEvent_PartitionDetails) ProtoMessage() {}

func (x *DiscoveryEvent_PartitionDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryEvent_PartitionDetails.ProtoReflect.Descriptor instead.
func (*DiscoveryEvent_PartitionDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{0, 2}
}

func (x *DiscoveryEvent_PartitionDetails) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

func (x *DiscoveryEvent_PartitionDetails) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *DiscoveryEvent_PartitionDetails) GetType() DiscoveryEvent_EntityType {
	if x != nil {
		return x.Type
	}
	return DiscoveryEvent_ENTITY_TYPE_UNSPECIFIED
}

// Details about the action.
type DiscoveryEvent_ActionDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of action.
	// Eg. IncompatibleDataSchema, InvalidDataFormat
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *DiscoveryEvent_ActionDetails) Reset() {
	*x = DiscoveryEvent_ActionDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryEvent_ActionDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryEvent_ActionDetails) ProtoMessage() {}

func (x *DiscoveryEvent_ActionDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryEvent_ActionDetails.ProtoReflect.Descriptor instead.
func (*DiscoveryEvent_ActionDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{0, 3}
}

func (x *DiscoveryEvent_ActionDetails) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// Execution details of the query.
type SessionEvent_QueryDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique Query id identifying the query.
	QueryId string `protobuf:"bytes,1,opt,name=query_id,json=queryId,proto3" json:"query_id,omitempty"`
	// The query text executed.
	QueryText string `protobuf:"bytes,2,opt,name=query_text,json=queryText,proto3" json:"query_text,omitempty"`
	// Query Execution engine.
	Engine SessionEvent_QueryDetail_Engine `protobuf:"varint,3,opt,name=engine,proto3,enum=google.cloud.dataplex.v1.SessionEvent_QueryDetail_Engine" json:"engine,omitempty"`
	// Time taken for execution of the query.
	Duration *durationpb.Duration `protobuf:"bytes,4,opt,name=duration,proto3" json:"duration,omitempty"`
	// The size of results the query produced.
	ResultSizeBytes int64 `protobuf:"varint,5,opt,name=result_size_bytes,json=resultSizeBytes,proto3" json:"result_size_bytes,omitempty"`
	// The data processed by the query.
	DataProcessedBytes int64 `protobuf:"varint,6,opt,name=data_processed_bytes,json=dataProcessedBytes,proto3" json:"data_processed_bytes,omitempty"`
}

func (x *SessionEvent_QueryDetail) Reset() {
	*x = SessionEvent_QueryDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionEvent_QueryDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionEvent_QueryDetail) ProtoMessage() {}

func (x *SessionEvent_QueryDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_logs_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionEvent_QueryDetail.ProtoReflect.Descriptor instead.
func (*SessionEvent_QueryDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP(), []int{2, 0}
}

func (x *SessionEvent_QueryDetail) GetQueryId() string {
	if x != nil {
		return x.QueryId
	}
	return ""
}

func (x *SessionEvent_QueryDetail) GetQueryText() string {
	if x != nil {
		return x.QueryText
	}
	return ""
}

func (x *SessionEvent_QueryDetail) GetEngine() SessionEvent_QueryDetail_Engine {
	if x != nil {
		return x.Engine
	}
	return SessionEvent_QueryDetail_ENGINE_UNSPECIFIED
}

func (x *SessionEvent_QueryDetail) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *SessionEvent_QueryDetail) GetResultSizeBytes() int64 {
	if x != nil {
		return x.ResultSizeBytes
	}
	return 0
}

func (x *SessionEvent_QueryDetail) GetDataProcessedBytes() int64 {
	if x != nil {
		return x.DataProcessedBytes
	}
	return 0
}

var File_google_cloud_dataplex_v1_logs_proto protoreflect.FileDescriptor

var file_google_cloud_dataplex_v1_logs_proto_rawDesc = []byte{
	0x0a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9e,
	0x0a, 0x0a, 0x0e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x6c,
	0x61, 0x6b, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6c, 0x61,
	0x6b, 0x65, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x7a, 0x6f, 0x6e, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x7a, 0x6f, 0x6e, 0x65, 0x49, 0x64, 0x12, 0x19, 0x0a,
	0x08, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x61, 0x73, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x64, 0x61, 0x74, 0x61, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x50, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x50, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48,
	0x00, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x59, 0x0a, 0x09, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x17,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x06,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xb6, 0x01, 0x0a, 0x0d, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x66, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x1a, 0x3d, 0x0a, 0x0f, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a,
	0x70, 0x0a, 0x0d, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x16, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x47, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x1a, 0x91, 0x01, 0x0a, 0x10, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x47, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x1a, 0x23, 0x0a, 0x0d, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0xb4, 0x01, 0x0a, 0x09, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x56, 0x45, 0x4e,
	0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x10, 0x01,
	0x12, 0x12, 0x0a, 0x0e, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x55,
	0x50, 0x44, 0x41, 0x54, 0x45, 0x44, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x45, 0x4e, 0x54, 0x49,
	0x54, 0x59, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x04, 0x12, 0x15, 0x0a, 0x11,
	0x50, 0x41, 0x52, 0x54, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45,
	0x44, 0x10, 0x05, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x41, 0x52, 0x54, 0x49, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x44, 0x10, 0x06, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x41,
	0x52, 0x54, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10,
	0x07, 0x22, 0x41, 0x0a, 0x0a, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1b, 0x0a, 0x17, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05,
	0x54, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x49, 0x4c, 0x45, 0x53,
	0x45, 0x54, 0x10, 0x02, 0x42, 0x09, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22,
	0xeb, 0x04, 0x0a, 0x08, 0x4a, 0x6f, 0x62, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x18, 0x0a, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x39, 0x0a,
	0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3e, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x07, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x44, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x1f, 0x0a, 0x0b,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4a, 0x6f, 0x62, 0x22, 0x35, 0x0a,
	0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x53,
	0x50, 0x41, 0x52, 0x4b, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x4e, 0x4f, 0x54, 0x45, 0x42, 0x4f,
	0x4f, 0x4b, 0x10, 0x02, 0x22, 0x55, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12,
	0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0b,
	0x0a, 0x07, 0x41, 0x42, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x04, 0x22, 0x30, 0x0a, 0x07, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0c, 0x0a, 0x08, 0x44, 0x41, 0x54, 0x41, 0x50, 0x52, 0x4f, 0x43, 0x10, 0x01, 0x22, 0xb6, 0x05,
	0x0a, 0x0c, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x18,
	0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x12, 0x44, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x4a, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x48, 0x00, 0x52, 0x05, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x1a, 0xee, 0x02, 0x0a, 0x0b, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x12, 0x19, 0x0a, 0x08, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x71, 0x75, 0x65, 0x72, 0x79, 0x49, 0x64, 0x12, 0x1d, 0x0a,
	0x0a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x71, 0x75, 0x65, 0x72, 0x79, 0x54, 0x65, 0x78, 0x74, 0x12, 0x51, 0x0a, 0x06,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x06, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12,
	0x35, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x12, 0x64, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x42,
	0x79, 0x74, 0x65, 0x73, 0x22, 0x3d, 0x0a, 0x06, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x16,
	0x0a, 0x12, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x50, 0x41, 0x52, 0x4b, 0x5f,
	0x53, 0x51, 0x4c, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x42, 0x49, 0x47, 0x51, 0x55, 0x45, 0x52,
	0x59, 0x10, 0x02, 0x22, 0x47, 0x0a, 0x09, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1a, 0x0a, 0x16, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05,
	0x53, 0x54, 0x41, 0x52, 0x54, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x54, 0x4f, 0x50, 0x10,
	0x02, 0x12, 0x09, 0x0a, 0x05, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x03, 0x42, 0x08, 0x0a, 0x06,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x42, 0x6d, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x42, 0x09, 0x4c, 0x6f, 0x67, 0x73, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x3b, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dataplex_v1_logs_proto_rawDescOnce sync.Once
	file_google_cloud_dataplex_v1_logs_proto_rawDescData = file_google_cloud_dataplex_v1_logs_proto_rawDesc
)

func file_google_cloud_dataplex_v1_logs_proto_rawDescGZIP() []byte {
	file_google_cloud_dataplex_v1_logs_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataplex_v1_logs_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataplex_v1_logs_proto_rawDescData)
	})
	return file_google_cloud_dataplex_v1_logs_proto_rawDescData
}

var file_google_cloud_dataplex_v1_logs_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_google_cloud_dataplex_v1_logs_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_dataplex_v1_logs_proto_goTypes = []interface{}{
	(DiscoveryEvent_EventType)(0),           // 0: google.cloud.dataplex.v1.DiscoveryEvent.EventType
	(DiscoveryEvent_EntityType)(0),          // 1: google.cloud.dataplex.v1.DiscoveryEvent.EntityType
	(JobEvent_Type)(0),                      // 2: google.cloud.dataplex.v1.JobEvent.Type
	(JobEvent_State)(0),                     // 3: google.cloud.dataplex.v1.JobEvent.State
	(JobEvent_Service)(0),                   // 4: google.cloud.dataplex.v1.JobEvent.Service
	(SessionEvent_EventType)(0),             // 5: google.cloud.dataplex.v1.SessionEvent.EventType
	(SessionEvent_QueryDetail_Engine)(0),    // 6: google.cloud.dataplex.v1.SessionEvent.QueryDetail.Engine
	(*DiscoveryEvent)(nil),                  // 7: google.cloud.dataplex.v1.DiscoveryEvent
	(*JobEvent)(nil),                        // 8: google.cloud.dataplex.v1.JobEvent
	(*SessionEvent)(nil),                    // 9: google.cloud.dataplex.v1.SessionEvent
	(*DiscoveryEvent_ConfigDetails)(nil),    // 10: google.cloud.dataplex.v1.DiscoveryEvent.ConfigDetails
	(*DiscoveryEvent_EntityDetails)(nil),    // 11: google.cloud.dataplex.v1.DiscoveryEvent.EntityDetails
	(*DiscoveryEvent_PartitionDetails)(nil), // 12: google.cloud.dataplex.v1.DiscoveryEvent.PartitionDetails
	(*DiscoveryEvent_ActionDetails)(nil),    // 13: google.cloud.dataplex.v1.DiscoveryEvent.ActionDetails
	nil,                                     // 14: google.cloud.dataplex.v1.DiscoveryEvent.ConfigDetails.ParametersEntry
	(*SessionEvent_QueryDetail)(nil),        // 15: google.cloud.dataplex.v1.SessionEvent.QueryDetail
	(*timestamppb.Timestamp)(nil),           // 16: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),             // 17: google.protobuf.Duration
}
var file_google_cloud_dataplex_v1_logs_proto_depIdxs = []int32{
	0,  // 0: google.cloud.dataplex.v1.DiscoveryEvent.type:type_name -> google.cloud.dataplex.v1.DiscoveryEvent.EventType
	10, // 1: google.cloud.dataplex.v1.DiscoveryEvent.config:type_name -> google.cloud.dataplex.v1.DiscoveryEvent.ConfigDetails
	11, // 2: google.cloud.dataplex.v1.DiscoveryEvent.entity:type_name -> google.cloud.dataplex.v1.DiscoveryEvent.EntityDetails
	12, // 3: google.cloud.dataplex.v1.DiscoveryEvent.partition:type_name -> google.cloud.dataplex.v1.DiscoveryEvent.PartitionDetails
	13, // 4: google.cloud.dataplex.v1.DiscoveryEvent.action:type_name -> google.cloud.dataplex.v1.DiscoveryEvent.ActionDetails
	16, // 5: google.cloud.dataplex.v1.JobEvent.start_time:type_name -> google.protobuf.Timestamp
	16, // 6: google.cloud.dataplex.v1.JobEvent.end_time:type_name -> google.protobuf.Timestamp
	3,  // 7: google.cloud.dataplex.v1.JobEvent.state:type_name -> google.cloud.dataplex.v1.JobEvent.State
	2,  // 8: google.cloud.dataplex.v1.JobEvent.type:type_name -> google.cloud.dataplex.v1.JobEvent.Type
	4,  // 9: google.cloud.dataplex.v1.JobEvent.service:type_name -> google.cloud.dataplex.v1.JobEvent.Service
	5,  // 10: google.cloud.dataplex.v1.SessionEvent.type:type_name -> google.cloud.dataplex.v1.SessionEvent.EventType
	15, // 11: google.cloud.dataplex.v1.SessionEvent.query:type_name -> google.cloud.dataplex.v1.SessionEvent.QueryDetail
	14, // 12: google.cloud.dataplex.v1.DiscoveryEvent.ConfigDetails.parameters:type_name -> google.cloud.dataplex.v1.DiscoveryEvent.ConfigDetails.ParametersEntry
	1,  // 13: google.cloud.dataplex.v1.DiscoveryEvent.EntityDetails.type:type_name -> google.cloud.dataplex.v1.DiscoveryEvent.EntityType
	1,  // 14: google.cloud.dataplex.v1.DiscoveryEvent.PartitionDetails.type:type_name -> google.cloud.dataplex.v1.DiscoveryEvent.EntityType
	6,  // 15: google.cloud.dataplex.v1.SessionEvent.QueryDetail.engine:type_name -> google.cloud.dataplex.v1.SessionEvent.QueryDetail.Engine
	17, // 16: google.cloud.dataplex.v1.SessionEvent.QueryDetail.duration:type_name -> google.protobuf.Duration
	17, // [17:17] is the sub-list for method output_type
	17, // [17:17] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_google_cloud_dataplex_v1_logs_proto_init() }
func file_google_cloud_dataplex_v1_logs_proto_init() {
	if File_google_cloud_dataplex_v1_logs_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiscoveryEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SessionEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiscoveryEvent_ConfigDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiscoveryEvent_EntityDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiscoveryEvent_PartitionDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiscoveryEvent_ActionDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_logs_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SessionEvent_QueryDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dataplex_v1_logs_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*DiscoveryEvent_Config)(nil),
		(*DiscoveryEvent_Entity)(nil),
		(*DiscoveryEvent_Partition)(nil),
		(*DiscoveryEvent_Action)(nil),
	}
	file_google_cloud_dataplex_v1_logs_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*SessionEvent_Query)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataplex_v1_logs_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dataplex_v1_logs_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataplex_v1_logs_proto_depIdxs,
		EnumInfos:         file_google_cloud_dataplex_v1_logs_proto_enumTypes,
		MessageInfos:      file_google_cloud_dataplex_v1_logs_proto_msgTypes,
	}.Build()
	File_google_cloud_dataplex_v1_logs_proto = out.File
	file_google_cloud_dataplex_v1_logs_proto_rawDesc = nil
	file_google_cloud_dataplex_v1_logs_proto_goTypes = nil
	file_google_cloud_dataplex_v1_logs_proto_depIdxs = nil
}
