/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.builder.xml;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.util.OptionHelper;
import org.jxls.area.Area;
import org.jxls.command.Command;
import org.jxls.common.AreaRef;
import org.jxls.util.Util;
import org.xml.sax.Attributes;

public class UserCommandAction
extends Action {
    public static final String ATTR = "attr";
    public static final String REF_ATTR = "ref";
    public static final String COMMAND_CLASS_ATTR = "commandClass";

    public void begin(InterpretationContext ic, String name, Attributes attributes) throws ActionException {
        Command command;
        String ref = attributes.getValue(REF_ATTR);
        String commandClassName = attributes.getValue(COMMAND_CLASS_ATTR);
        if (commandClassName == null || commandClassName.trim().length() == 0) {
            String errMsg = "Required actionClass attribute is not specified for userCommand";
            ic.addError(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        try {
            command = (Command)OptionHelper.instantiateByClassName((String)commandClassName, Command.class, (Context)this.context);
        }
        catch (Exception e) {
            this.addError("Could not instantiate class [" + commandClassName + "]", e);
            throw new IllegalStateException(e);
        }
        try {
            this.initPropertiesFromAttributes(command, attributes);
        }
        catch (Exception e) {
            this.addWarn("Could not set an attribute");
        }
        Object object = ic.peekObject();
        if (!(object instanceof Area)) {
            String errMsg = "Object [" + object + "] currently at the top of the stack is not an Area";
            ic.addError(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        Area area = (Area)object;
        area.addCommand(new AreaRef(ref), command);
        ic.pushObject((Object)command);
    }

    private void initPropertiesFromAttributes(Object obj, Attributes attributes) {
        int attrLength = attributes.getLength();
        for (int i = 0; i < attrLength; ++i) {
            try {
                Util.setObjectProperty(obj, attributes.getLocalName(i), attributes.getValue(i));
                continue;
            }
            catch (Exception e) {
                this.addWarn("Could not set an attribute attr=" + attributes.getLocalName(i) + ", value=" + attributes.getValue(i));
            }
        }
    }

    public void end(InterpretationContext ic, String name) throws ActionException {
        ic.popObject();
    }
}

