/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper.model;

import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.traccar.model.BaseModel;
import org.traccar.model.Device;
import org.traccar.model.Position;
import org.traccar.model.User;
import org.traccar.session.cache.CacheManager;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Order;
import org.traccar.storage.query.Request;

public final class PositionUtil {
    private PositionUtil() {
    }

    public static boolean isLatest(CacheManager cacheManager, Position position) {
        Position lastPosition = cacheManager.getPosition(position.getDeviceId());
        return lastPosition == null || position.getFixTime().compareTo(lastPosition.getFixTime()) >= 0;
    }

    public static double calculateDistance(Position first, Position last, boolean useOdometer) {
        double firstOdometer = first.getDouble("odometer");
        double lastOdometer = last.getDouble("odometer");
        double distance = useOdometer && firstOdometer != 0.0 && lastOdometer != 0.0 ? lastOdometer - firstOdometer : last.getDouble("totalDistance") - first.getDouble("totalDistance");
        return distance;
    }

    public static List<Position> getPositions(Storage storage, long deviceId, Date from, Date to) throws StorageException {
        try (Stream<Position> positions = PositionUtil.getPositionsStream(storage, deviceId, from, to);){
            List<Position> list = positions.toList();
            return list;
        }
    }

    public static Stream<Position> getPositionsStream(Storage storage, long deviceId, Date from, Date to) throws StorageException {
        return storage.getObjectsStream(Position.class, new Request(new Columns.All(), new Condition.And(new Condition.Equals("deviceId", deviceId), new Condition.Between("fixTime", from, to)), new Order("fixTime")));
    }

    public static Position getEdgePosition(Storage storage, long deviceId, Date from, Date to, boolean end) throws StorageException {
        return storage.getObject(Position.class, new Request(new Columns.All(), new Condition.And(new Condition.Equals("deviceId", deviceId), new Condition.Between("fixTime", from, to)), new Order("fixTime", end, 1)));
    }

    public static List<Position> getLatestPositions(Storage storage, long userId) throws StorageException {
        List<Device> devices = storage.getObjects(Device.class, new Request((Columns)new Columns.Include("id"), new Condition.Permission(User.class, userId, Device.class)));
        Set deviceIds = devices.stream().map(BaseModel::getId).collect(Collectors.toUnmodifiableSet());
        List<Position> positions = storage.getObjects(Position.class, new Request((Columns)new Columns.All(), new Condition.LatestPositions()));
        return positions.stream().filter(position -> deviceIds.contains(position.getDeviceId())).toList();
    }
}

