/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.xpp.impl.tag;

import org.gjt.xpp.XmlStartTag;
import org.gjt.xpp.impl.tag.Attribute;
import org.gjt.xpp.impl.tag.Tag;

public class StartTag
extends Tag
implements XmlStartTag {
    private static final boolean TRACE_SIZING = false;
    private int attEnd;
    private int attSize;
    private Attribute[] attArr;

    public void resetStartTag() {
        super.resetTag();
        this.attEnd = 0;
    }

    public int getAttributeCount() {
        return this.attEnd;
    }

    public String getAttributeNamespaceUri(int index) {
        if (index >= 0 && index < this.attEnd) {
            return this.attArr[index].uri;
        }
        return null;
    }

    public String getAttributeLocalName(int index) {
        if (index >= 0 && index < this.attEnd) {
            return this.attArr[index].localName;
        }
        return null;
    }

    public String getAttributePrefix(int index) {
        int pos;
        String s;
        if (index >= 0 && index < this.attEnd && (s = this.attArr[index].qName) != null && (pos = s.indexOf(58)) != -1) {
            return s.substring(0, pos);
        }
        return null;
    }

    public String getAttributeRawName(int index) {
        if (index >= 0 && index < this.attEnd) {
            return this.attArr[index].qName;
        }
        return null;
    }

    public String getAttributeValue(int index) {
        if (index >= 0 && index < this.attEnd) {
            return this.attArr[index].value;
        }
        return null;
    }

    public boolean isAttributeNamespaceDeclaration(int index) {
        return this.attArr[index].xmlnsAttrib;
    }

    public String getAttributeValueFromName(String uri, String localName) {
        for (int i = 0; i < this.attEnd; ++i) {
            if ((uri == null || !uri.equals(this.attArr[i].uri)) && (uri != null || this.attArr[i].uri != null) || !localName.equals(this.attArr[i].localName)) continue;
            return this.attArr[i].value;
        }
        return null;
    }

    public String getAttributeValueFromRawName(String qName) {
        for (int i = 0; i < this.attEnd; ++i) {
            if (!qName.equals(this.attArr[i].qName)) continue;
            return this.attArr[i].value;
        }
        return null;
    }

    public void addAttribute(String namespaceUri, String localName, String rawName, String value) {
        this.addAttribute(namespaceUri, localName, rawName, value, false);
    }

    public void addAttribute(String namespaceUri, String localName, String rawName, String value, boolean isNamespaceDeclaration) {
        if (this.attEnd >= this.attSize) {
            this.ensureAttributesCapacity(2 * this.attEnd + 1);
        }
        Attribute att = this.attArr[this.attEnd++];
        att.uri = namespaceUri;
        att.localName = localName;
        att.qName = rawName;
        att.value = value;
    }

    public void ensureAttributesCapacity(int minCapacity) {
        int newSize = minCapacity;
        if (this.attSize < newSize) {
            Attribute[] newAttArr = new Attribute[newSize];
            if (this.attArr != null) {
                System.arraycopy(this.attArr, 0, newAttArr, 0, this.attEnd);
            }
            for (int i = this.attEnd; i < newSize; ++i) {
                newAttArr[i] = new Attribute();
            }
            this.attArr = newAttArr;
            this.attSize = newSize;
        }
    }

    public boolean removeAttributeByRawName(String rawName) {
        for (int i = 0; i < this.attEnd; ++i) {
            if (!rawName.equals(this.attArr[i].qName)) continue;
            this.removeAttributeAtPos(i);
            return true;
        }
        return false;
    }

    public boolean removeAttributeByName(String uri, String localName) {
        for (int i = 0; i < this.attEnd; ++i) {
            if ((uri == null || !uri.equals(this.attArr[i].uri)) && (uri != null || this.attArr[i].uri != null) || !localName.equals(this.attArr[i].localName)) continue;
            this.removeAttributeAtPos(i);
            return true;
        }
        return false;
    }

    private void removeAttributeAtPos(int i) {
        int count = this.attEnd - i - 1;
        if (count > 0) {
            Attribute attr = this.attArr[i];
            System.arraycopy(this.attArr, i + 1, this.attArr, i, count);
            this.attArr[this.attEnd - 1] = attr;
        }
        --this.attEnd;
    }

    public void removeAttributes() {
        this.attEnd = 0;
    }

    protected void printFields(StringBuffer buf) {
        super.printFields(buf);
        if (this.attEnd > 0) {
            buf.append(" attArr=[ ");
            for (int i = 0; i < this.attEnd; ++i) {
                buf.append(this.attArr[i] + " ");
            }
            buf.append(" ]");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("StartTag={");
        this.printFields(buf);
        buf.append(" }");
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof StartTag)) {
            return false;
        }
        StartTag t = (StartTag)o;
        if (this.attEnd != t.attEnd) {
            return false;
        }
        for (int i = 0; i < this.attEnd; ++i) {
            if (this.attArr[i].equals(t.attArr[i])) continue;
            return false;
        }
        return super.equals(o);
    }
}

