/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.util;

import io.jenetics.internal.util.require;
import io.jenetics.util.Context;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class RandomRegistry {
    private static final Context<Supplier<Random>> CONTEXT = new Context<Supplier<Random>>(ThreadLocalRandom::current);

    private RandomRegistry() {
        require.noInstance();
    }

    public static Random getRandom() {
        return CONTEXT.get().get();
    }

    static Random random() {
        return CONTEXT.get().get();
    }

    public static void setRandom(Random random2) {
        Objects.requireNonNull(random2, "Random must not be null.");
        CONTEXT.set(() -> random2);
    }

    public static void setRandom(ThreadLocal<? extends Random> random2) {
        Objects.requireNonNull(random2, "Random must not be null.");
        CONTEXT.set(random2::get);
    }

    public static void reset() {
        CONTEXT.reset();
    }

    public static <R extends Random> void using(R random2, Consumer<? super R> consumer) {
        CONTEXT.with(() -> random2, r -> {
            consumer.accept((Object)random2);
            return null;
        });
    }

    public static <R extends Random> void using(ThreadLocal<R> random2, Consumer<? super R> consumer) {
        CONTEXT.with(random2::get, r -> {
            consumer.accept((Object)random2.get());
            return null;
        });
    }

    public static <R extends Random, T> T with(R random2, Function<? super R, ? extends T> function) {
        return (T)CONTEXT.with(() -> random2, s -> function.apply((Object)random2));
    }

    public static <R extends Random, T> T with(ThreadLocal<R> random2, Function<? super R, ? extends T> function) {
        return (T)CONTEXT.with(random2::get, s -> function.apply((Object)random2.get()));
    }
}

