/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.util;

import io.jenetics.internal.collection.Empty;
import io.jenetics.internal.util.require;
import io.jenetics.util.Copyable;
import io.jenetics.util.MSeq;
import io.jenetics.util.Seq;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public interface ISeq<T>
extends Seq<T>,
Copyable<MSeq<T>> {
    public static final ISeq<?> EMPTY = Empty.EmptyISeq.INSTANCE;

    @Override
    public ISeq<T> subSeq(int var1, int var2);

    @Override
    public ISeq<T> subSeq(int var1);

    @Override
    public <B> ISeq<B> map(Function<? super T, ? extends B> var1);

    @Override
    default public ISeq<T> append(T ... values) {
        return this.append(ISeq.of(values));
    }

    @Override
    public ISeq<T> append(Iterable<? extends T> var1);

    @Override
    default public ISeq<T> prepend(T ... values) {
        return this.prepend(ISeq.of(values));
    }

    @Override
    public ISeq<T> prepend(Iterable<? extends T> var1);

    @Override
    public MSeq<T> copy();

    public static <T> ISeq<T> empty() {
        return Empty.iseq();
    }

    public static <T> Collector<T, ?, ISeq<T>> toISeq() {
        return Collector.of(ArrayList::new, List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, ISeq::of, new Collector.Characteristics[0]);
    }

    @SafeVarargs
    public static <T> ISeq<T> of(T ... values) {
        return values.length == 0 ? ISeq.empty() : MSeq.of(values).toISeq();
    }

    public static <T> ISeq<T> of(Iterable<? extends T> values) {
        Objects.requireNonNull(values);
        return values instanceof ISeq ? (ISeq)values : (values instanceof MSeq ? ((MSeq)values).toISeq() : MSeq.of(values).toISeq());
    }

    public static <T> ISeq<T> of(Supplier<? extends T> supplier, int length) {
        Objects.requireNonNull(supplier);
        require.nonNegative(length);
        return length == 0 ? ISeq.empty() : MSeq.ofLength(length).fill(supplier).toISeq();
    }

    public static <A, B extends A> ISeq<A> upcast(ISeq<B> seq) {
        return seq;
    }
}

