// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateOpsItemInput struct {
	_ struct{} `type:"structure"`

	// Specify a new category for an OpsItem.
	Category *string `min:"1" type:"string"`

	// Update the information about the OpsItem. Provide enough information so that
	// users reading this OpsItem for the first time understand the issue.
	Description *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of an SNS topic where notifications are sent
	// when this OpsItem is edited or changed.
	Notifications []OpsItemNotification `type:"list"`

	// Add new keys or edit existing key-value pairs of the OperationalData map
	// in the OpsItem object.
	//
	// Operational data is custom data that provides useful reference details about
	// the OpsItem. For example, you can specify log files, error strings, license
	// keys, troubleshooting tips, or other relevant data. You enter operational
	// data as key-value pairs. The key has a maximum length of 128 characters.
	// The value has a maximum size of 20 KB.
	//
	// Operational data keys can't begin with the following: amazon, aws, amzn,
	// ssm, /amazon, /aws, /amzn, /ssm.
	//
	// You can choose to make the data searchable by other users in the account
	// or you can restrict search access. Searchable data means that all users with
	// access to the OpsItem Overview page (as provided by the DescribeOpsItems
	// API action) can view and search on the specified data. Operational data that
	// is not searchable is only viewable by users who have access to the OpsItem
	// (as provided by the GetOpsItem API action).
	//
	// Use the /aws/resources key in OperationalData to specify a related resource
	// in the request. Use the /aws/automations key in OperationalData to associate
	// an Automation runbook with the OpsItem. To view AWS CLI example commands
	// that use these keys, see Creating OpsItems Manually (http://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems)
	// in the AWS Systems Manager User Guide.
	OperationalData map[string]OpsItemDataValue `type:"map"`

	// Keys that you want to remove from the OperationalData map.
	OperationalDataToDelete []string `type:"list"`

	// The ID of the OpsItem.
	//
	// OpsItemId is a required field
	OpsItemId *string `type:"string" required:"true"`

	// The importance of this OpsItem in relation to other OpsItems in the system.
	Priority *int64 `min:"1" type:"integer"`

	// One or more OpsItems that share something in common with the current OpsItems.
	// For example, related OpsItems can include OpsItems with similar error messages,
	// impacted resources, or statuses for the impacted resource.
	RelatedOpsItems []RelatedOpsItem `type:"list"`

	// Specify a new severity for an OpsItem.
	Severity *string `min:"1" type:"string"`

	// The OpsItem status. Status can be Open, In Progress, or Resolved. For more
	// information, see Editing OpsItem Details (http://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-working-with-OpsItems-editing-details.html)
	// in the AWS Systems Manager User Guide.
	Status OpsItemStatus `type:"string" enum:"true"`

	// A short heading that describes the nature of the OpsItem and the impacted
	// resource.
	Title *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateOpsItemInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateOpsItemInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateOpsItemInput"}
	if s.Category != nil && len(*s.Category) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Category", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.OpsItemId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OpsItemId"))
	}
	if s.Priority != nil && *s.Priority < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Priority", 1))
	}
	if s.Severity != nil && len(*s.Severity) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Severity", 1))
	}
	if s.Title != nil && len(*s.Title) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Title", 1))
	}
	if s.RelatedOpsItems != nil {
		for i, v := range s.RelatedOpsItems {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RelatedOpsItems", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateOpsItemOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateOpsItemOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateOpsItem = "UpdateOpsItem"

// UpdateOpsItemRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Edit or change an OpsItem. You must have permission in AWS Identity and Access
// Management (IAM) to update an OpsItem. For more information, see Getting
// Started with OpsCenter (http://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html)
// in the AWS Systems Manager User Guide.
//
// Operations engineers and IT professionals use OpsCenter to view, investigate,
// and remediate operational issues impacting the performance and health of
// their AWS resources. For more information, see AWS Systems Manager OpsCenter
// (http://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html)
// in the AWS Systems Manager User Guide.
//
//    // Example sending a request using UpdateOpsItemRequest.
//    req := client.UpdateOpsItemRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateOpsItem
func (c *Client) UpdateOpsItemRequest(input *UpdateOpsItemInput) UpdateOpsItemRequest {
	op := &aws.Operation{
		Name:       opUpdateOpsItem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateOpsItemInput{}
	}

	req := c.newRequest(op, input, &UpdateOpsItemOutput{})
	return UpdateOpsItemRequest{Request: req, Input: input, Copy: c.UpdateOpsItemRequest}
}

// UpdateOpsItemRequest is the request type for the
// UpdateOpsItem API operation.
type UpdateOpsItemRequest struct {
	*aws.Request
	Input *UpdateOpsItemInput
	Copy  func(*UpdateOpsItemInput) UpdateOpsItemRequest
}

// Send marshals and sends the UpdateOpsItem API request.
func (r UpdateOpsItemRequest) Send(ctx context.Context) (*UpdateOpsItemResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateOpsItemResponse{
		UpdateOpsItemOutput: r.Request.Data.(*UpdateOpsItemOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateOpsItemResponse is the response type for the
// UpdateOpsItem API operation.
type UpdateOpsItemResponse struct {
	*UpdateOpsItemOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateOpsItem request.
func (r *UpdateOpsItemResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
