// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicediscovery

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RegisterInstanceInput struct {
	_ struct{} `type:"structure"`

	// A string map that contains the following information for the service that
	// you specify in ServiceId:
	//
	//    * The attributes that apply to the records that are defined in the service.
	//
	//    * For each attribute, the applicable value.
	//
	// Supported attribute keys include the following:
	//
	// AWS_ALIAS_DNS_NAME
	//
	// If you want AWS Cloud Map to create an Amazon Route 53 alias record that
	// routes traffic to an Elastic Load Balancing load balancer, specify the DNS
	// name that is associated with the load balancer. For information about how
	// to get the DNS name, see "DNSName" in the topic AliasTarget (http://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html)
	// in the Route 53 API Reference.
	//
	// Note the following:
	//
	//    * The configuration for the service that is specified by ServiceId must
	//    include settings for an A record, an AAAA record, or both.
	//
	//    * In the service that is specified by ServiceId, the value of RoutingPolicy
	//    must be WEIGHTED.
	//
	//    * If the service that is specified by ServiceId includes HealthCheckConfig
	//    settings, AWS Cloud Map will create the Route 53 health check, but it
	//    won't associate the health check with the alias record.
	//
	//    * Auto naming currently doesn't support creating alias records that route
	//    traffic to AWS resources other than ELB load balancers.
	//
	//    * If you specify a value for AWS_ALIAS_DNS_NAME, don't specify values
	//    for any of the AWS_INSTANCE attributes.
	//
	// AWS_INIT_HEALTH_STATUS
	//
	// If the service configuration includes HealthCheckCustomConfig, you can optionally
	// use AWS_INIT_HEALTH_STATUS to specify the initial status of the custom health
	// check, HEALTHY or UNHEALTHY. If you don't specify a value for AWS_INIT_HEALTH_STATUS,
	// the initial status is HEALTHY.
	//
	// AWS_INSTANCE_CNAME
	//
	// If the service configuration includes a CNAME record, the domain name that
	// you want Route 53 to return in response to DNS queries, for example, example.com.
	//
	// This value is required if the service specified by ServiceId includes settings
	// for an CNAME record.
	//
	// AWS_INSTANCE_IPV4
	//
	// If the service configuration includes an A record, the IPv4 address that
	// you want Route 53 to return in response to DNS queries, for example, 192.0.2.44.
	//
	// This value is required if the service specified by ServiceId includes settings
	// for an A record. If the service includes settings for an SRV record, you
	// must specify a value for AWS_INSTANCE_IPV4, AWS_INSTANCE_IPV6, or both.
	//
	// AWS_INSTANCE_IPV6
	//
	// If the service configuration includes an AAAA record, the IPv6 address that
	// you want Route 53 to return in response to DNS queries, for example, 2001:0db8:85a3:0000:0000:abcd:0001:2345.
	//
	// This value is required if the service specified by ServiceId includes settings
	// for an AAAA record. If the service includes settings for an SRV record, you
	// must specify a value for AWS_INSTANCE_IPV4, AWS_INSTANCE_IPV6, or both.
	//
	// AWS_INSTANCE_PORT
	//
	// If the service includes an SRV record, the value that you want Route 53 to
	// return for the port.
	//
	// If the service includes HealthCheckConfig, the port on the endpoint that
	// you want Route 53 to send requests to.
	//
	// This value is required if you specified settings for an SRV record when you
	// created the service.
	//
	// Custom attributes
	//
	// You can add up to 30 custom attributes. For each key-value pair, the maximum
	// length of the attribute name is 255 characters, and the maximum length of
	// the attribute value is 1,024 characters.
	//
	// Attributes is a required field
	Attributes map[string]string `type:"map" required:"true"`

	// A unique string that identifies the request and that allows failed RegisterInstance
	// requests to be retried without the risk of executing the operation twice.
	// You must use a unique CreatorRequestId string every time you submit a RegisterInstance
	// request if you're registering additional instances for the same namespace
	// and service. CreatorRequestId can be any unique string, for example, a date/time
	// stamp.
	CreatorRequestId *string `type:"string" idempotencyToken:"true"`

	// An identifier that you want to associate with the instance. Note the following:
	//
	//    * If the service that is specified by ServiceId includes settings for
	//    an SRV record, the value of InstanceId is automatically included as part
	//    of the value for the SRV record. For more information, see DnsRecord$Type.
	//
	//    * You can use this value to update an existing instance.
	//
	//    * To register a new instance, you must specify a value that is unique
	//    among instances that you register by using the same service.
	//
	//    * If you specify an existing InstanceId and ServiceId, AWS Cloud Map updates
	//    the existing DNS records, if any. If there's also an existing health check,
	//    AWS Cloud Map deletes the old health check and creates a new one. The
	//    health check isn't deleted immediately, so it will still appear for a
	//    while if you submit a ListHealthChecks request, for example.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The ID of the service that you want to use for settings for the instance.
	//
	// ServiceId is a required field
	ServiceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterInstanceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RegisterInstanceInput"}

	if s.Attributes == nil {
		invalidParams.Add(aws.NewErrParamRequired("Attributes"))
	}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}

	if s.ServiceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RegisterInstanceOutput struct {
	_ struct{} `type:"structure"`

	// A value that you can use to determine whether the request completed successfully.
	// To get the status of the operation, see GetOperation.
	OperationId *string `type:"string"`
}

// String returns the string representation
func (s RegisterInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opRegisterInstance = "RegisterInstance"

// RegisterInstanceRequest returns a request value for making API operation for
// AWS Cloud Map.
//
// Creates or updates one or more records and, optionally, creates a health
// check based on the settings in a specified service. When you submit a RegisterInstance
// request, the following occurs:
//
//    * For each DNS record that you define in the service that is specified
//    by ServiceId, a record is created or updated in the hosted zone that is
//    associated with the corresponding namespace.
//
//    * If the service includes HealthCheckConfig, a health check is created
//    based on the settings in the health check configuration.
//
//    * The health check, if any, is associated with each of the new or updated
//    records.
//
// One RegisterInstance request must complete before you can submit another
// request and specify the same service ID and instance ID.
//
// For more information, see CreateService.
//
// When AWS Cloud Map receives a DNS query for the specified DNS name, it returns
// the applicable value:
//
//    * If the health check is healthy: returns all the records
//
//    * If the health check is unhealthy: returns the applicable value for the
//    last healthy instance
//
//    * If you didn't specify a health check configuration: returns all the
//    records
//
// For the current limit on the number of instances that you can register using
// the same namespace and using the same service, see AWS Cloud Map Limits (http://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html)
// in the AWS Cloud Map Developer Guide.
//
//    // Example sending a request using RegisterInstanceRequest.
//    req := client.RegisterInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/RegisterInstance
func (c *Client) RegisterInstanceRequest(input *RegisterInstanceInput) RegisterInstanceRequest {
	op := &aws.Operation{
		Name:       opRegisterInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterInstanceInput{}
	}

	req := c.newRequest(op, input, &RegisterInstanceOutput{})
	return RegisterInstanceRequest{Request: req, Input: input, Copy: c.RegisterInstanceRequest}
}

// RegisterInstanceRequest is the request type for the
// RegisterInstance API operation.
type RegisterInstanceRequest struct {
	*aws.Request
	Input *RegisterInstanceInput
	Copy  func(*RegisterInstanceInput) RegisterInstanceRequest
}

// Send marshals and sends the RegisterInstance API request.
func (r RegisterInstanceRequest) Send(ctx context.Context) (*RegisterInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RegisterInstanceResponse{
		RegisterInstanceOutput: r.Request.Data.(*RegisterInstanceOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RegisterInstanceResponse is the response type for the
// RegisterInstance API operation.
type RegisterInstanceResponse struct {
	*RegisterInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RegisterInstance request.
func (r *RegisterInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
